// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// RenderReportPDFsReader is a Reader for the RenderReportPDFs structure.
type RenderReportPDFsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RenderReportPDFsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRenderReportPDFsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRenderReportPDFsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewRenderReportPDFsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRenderReportPDFsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /reports/render/pdfs] renderReportPDFs", response, response.Code())
	}
}

// NewRenderReportPDFsOK creates a RenderReportPDFsOK with default headers values
func NewRenderReportPDFsOK() *RenderReportPDFsOK {
	return &RenderReportPDFsOK{}
}

/*
RenderReportPDFsOK describes a response with status code 200, with default header values.

(empty)
*/
type RenderReportPDFsOK struct {
	Payload []uint8
}

// IsSuccess returns true when this render report p d fs Ok response has a 2xx status code
func (o *RenderReportPDFsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this render report p d fs Ok response has a 3xx status code
func (o *RenderReportPDFsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this render report p d fs Ok response has a 4xx status code
func (o *RenderReportPDFsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this render report p d fs Ok response has a 5xx status code
func (o *RenderReportPDFsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this render report p d fs Ok response a status code equal to that given
func (o *RenderReportPDFsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the render report p d fs Ok response
func (o *RenderReportPDFsOK) Code() int {
	return 200
}

func (o *RenderReportPDFsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/render/pdfs][%d] renderReportPDFsOk %s", 200, payload)
}

func (o *RenderReportPDFsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/render/pdfs][%d] renderReportPDFsOk %s", 200, payload)
}

func (o *RenderReportPDFsOK) GetPayload() []uint8 {
	return o.Payload
}

func (o *RenderReportPDFsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRenderReportPDFsBadRequest creates a RenderReportPDFsBadRequest with default headers values
func NewRenderReportPDFsBadRequest() *RenderReportPDFsBadRequest {
	return &RenderReportPDFsBadRequest{}
}

/*
RenderReportPDFsBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type RenderReportPDFsBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this render report p d fs bad request response has a 2xx status code
func (o *RenderReportPDFsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this render report p d fs bad request response has a 3xx status code
func (o *RenderReportPDFsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this render report p d fs bad request response has a 4xx status code
func (o *RenderReportPDFsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this render report p d fs bad request response has a 5xx status code
func (o *RenderReportPDFsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this render report p d fs bad request response a status code equal to that given
func (o *RenderReportPDFsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the render report p d fs bad request response
func (o *RenderReportPDFsBadRequest) Code() int {
	return 400
}

func (o *RenderReportPDFsBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/render/pdfs][%d] renderReportPDFsBadRequest %s", 400, payload)
}

func (o *RenderReportPDFsBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/render/pdfs][%d] renderReportPDFsBadRequest %s", 400, payload)
}

func (o *RenderReportPDFsBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RenderReportPDFsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRenderReportPDFsUnauthorized creates a RenderReportPDFsUnauthorized with default headers values
func NewRenderReportPDFsUnauthorized() *RenderReportPDFsUnauthorized {
	return &RenderReportPDFsUnauthorized{}
}

/*
RenderReportPDFsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type RenderReportPDFsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this render report p d fs unauthorized response has a 2xx status code
func (o *RenderReportPDFsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this render report p d fs unauthorized response has a 3xx status code
func (o *RenderReportPDFsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this render report p d fs unauthorized response has a 4xx status code
func (o *RenderReportPDFsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this render report p d fs unauthorized response has a 5xx status code
func (o *RenderReportPDFsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this render report p d fs unauthorized response a status code equal to that given
func (o *RenderReportPDFsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the render report p d fs unauthorized response
func (o *RenderReportPDFsUnauthorized) Code() int {
	return 401
}

func (o *RenderReportPDFsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/render/pdfs][%d] renderReportPDFsUnauthorized %s", 401, payload)
}

func (o *RenderReportPDFsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/render/pdfs][%d] renderReportPDFsUnauthorized %s", 401, payload)
}

func (o *RenderReportPDFsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RenderReportPDFsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRenderReportPDFsInternalServerError creates a RenderReportPDFsInternalServerError with default headers values
func NewRenderReportPDFsInternalServerError() *RenderReportPDFsInternalServerError {
	return &RenderReportPDFsInternalServerError{}
}

/*
RenderReportPDFsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type RenderReportPDFsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this render report p d fs internal server error response has a 2xx status code
func (o *RenderReportPDFsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this render report p d fs internal server error response has a 3xx status code
func (o *RenderReportPDFsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this render report p d fs internal server error response has a 4xx status code
func (o *RenderReportPDFsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this render report p d fs internal server error response has a 5xx status code
func (o *RenderReportPDFsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this render report p d fs internal server error response a status code equal to that given
func (o *RenderReportPDFsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the render report p d fs internal server error response
func (o *RenderReportPDFsInternalServerError) Code() int {
	return 500
}

func (o *RenderReportPDFsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/render/pdfs][%d] renderReportPDFsInternalServerError %s", 500, payload)
}

func (o *RenderReportPDFsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /reports/render/pdfs][%d] renderReportPDFsInternalServerError %s", 500, payload)
}

func (o *RenderReportPDFsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RenderReportPDFsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
