// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new reports API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for reports API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateReport(body *models.CreateOrUpdateReport, opts ...ClientOption) (*CreateReportOK, error)
	CreateReportWithParams(params *CreateReportParams, opts ...ClientOption) (*CreateReportOK, error)

	DeleteReport(id int64, opts ...ClientOption) (*DeleteReportOK, error)
	DeleteReportWithParams(params *DeleteReportParams, opts ...ClientOption) (*DeleteReportOK, error)

	GetReport(id int64, opts ...ClientOption) (*GetReportOK, error)
	GetReportWithParams(params *GetReportParams, opts ...ClientOption) (*GetReportOK, error)

	GetReportSettings(opts ...ClientOption) (*GetReportSettingsOK, error)
	GetReportSettingsWithParams(params *GetReportSettingsParams, opts ...ClientOption) (*GetReportSettingsOK, error)

	GetReports(opts ...ClientOption) (*GetReportsOK, error)
	GetReportsWithParams(params *GetReportsParams, opts ...ClientOption) (*GetReportsOK, error)

	GetSettingsImage(opts ...ClientOption) (*GetSettingsImageOK, error)
	GetSettingsImageWithParams(params *GetSettingsImageParams, opts ...ClientOption) (*GetSettingsImageOK, error)

	RenderReportCSVs(params *RenderReportCSVsParams, opts ...ClientOption) (*RenderReportCSVsOK, *RenderReportCSVsNoContent, error)

	RenderReportPDFs(params *RenderReportPDFsParams, opts ...ClientOption) (*RenderReportPDFsOK, error)

	SaveReportSettings(body *models.ReportSettings, opts ...ClientOption) (*SaveReportSettingsOK, error)
	SaveReportSettingsWithParams(params *SaveReportSettingsParams, opts ...ClientOption) (*SaveReportSettingsOK, error)

	SendReport(body *models.ReportEmail, opts ...ClientOption) (*SendReportOK, error)
	SendReportWithParams(params *SendReportParams, opts ...ClientOption) (*SendReportOK, error)

	SendTestEmail(body *models.CreateOrUpdateReport, opts ...ClientOption) (*SendTestEmailOK, error)
	SendTestEmailWithParams(params *SendTestEmailParams, opts ...ClientOption) (*SendTestEmailOK, error)

	UpdateReport(id int64, body *models.CreateOrUpdateReport, opts ...ClientOption) (*UpdateReportOK, error)
	UpdateReportWithParams(params *UpdateReportParams, opts ...ClientOption) (*UpdateReportOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateReport creates a report

Available to org admins only and with a valid license.

You need to have a permission with action `reports.admin:create`.
*/
func (a *Client) CreateReport(body *models.CreateOrUpdateReport, opts ...ClientOption) (*CreateReportOK, error) {
	params := NewCreateReportParams().WithBody(body)
	return a.CreateReportWithParams(params, opts...)
}

func (a *Client) CreateReportWithParams(params *CreateReportParams, opts ...ClientOption) (*CreateReportOK, error) {
	if params == nil {
		params = NewCreateReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createReport",
		Method:             "POST",
		PathPattern:        "/reports",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateReportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createReport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteReport deletes a report

Available to org admins only and with a valid or expired license.

You need to have a permission with action `reports.delete` with scope `reports:id:<report ID>`.

Requesting reports using the internal id will stop workgin in the future
Use the reporting apiserver to manage reports.  See: /apis/reporting.grafana.app/
*/
func (a *Client) DeleteReport(id int64, opts ...ClientOption) (*DeleteReportOK, error) {
	params := NewDeleteReportParams().WithID(id)
	return a.DeleteReportWithParams(params, opts...)
}

func (a *Client) DeleteReportWithParams(params *DeleteReportParams, opts ...ClientOption) (*DeleteReportOK, error) {
	if params == nil {
		params = NewDeleteReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteReport",
		Method:             "DELETE",
		PathPattern:        "/reports/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteReportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteReport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetReport gets a report

Available to org admins only and with a valid or expired license.

You need to have a permission with action `reports:read` with scope `reports:id:<report ID>`.

Requesting reports using the internal id will stop workgin in the future
Use the reporting apiserver to manage reports.  See: /apis/reporting.grafana.app/
*/
func (a *Client) GetReport(id int64, opts ...ClientOption) (*GetReportOK, error) {
	params := NewGetReportParams().WithID(id)
	return a.GetReportWithParams(params, opts...)
}

func (a *Client) GetReportWithParams(params *GetReportParams, opts ...ClientOption) (*GetReportOK, error) {
	if params == nil {
		params = NewGetReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getReport",
		Method:             "GET",
		PathPattern:        "/reports/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetReportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getReport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetReportSettings gets report settings

Available to org admins only and with a valid or expired license.

You need to have a permission with action `reports.settings:read`x.
*/
func (a *Client) GetReportSettings(opts ...ClientOption) (*GetReportSettingsOK, error) {
	params := NewGetReportSettingsParams()
	return a.GetReportSettingsWithParams(params, opts...)
}

func (a *Client) GetReportSettingsWithParams(params *GetReportSettingsParams, opts ...ClientOption) (*GetReportSettingsOK, error) {
	if params == nil {
		params = NewGetReportSettingsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getReportSettings",
		Method:             "GET",
		PathPattern:        "/reports/settings",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetReportSettingsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetReportSettingsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getReportSettings: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetReports lists reports

Available to org admins only and with a valid or expired license.

You need to have a permission with action `reports:read` with scope `reports:*`.
*/
func (a *Client) GetReports(opts ...ClientOption) (*GetReportsOK, error) {
	params := NewGetReportsParams()
	return a.GetReportsWithParams(params, opts...)
}

func (a *Client) GetReportsWithParams(params *GetReportsParams, opts ...ClientOption) (*GetReportsOK, error) {
	if params == nil {
		params = NewGetReportsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getReports",
		Method:             "GET",
		PathPattern:        "/reports",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetReportsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetReportsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getReports: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSettingsImage gets custom branding report image

Available to org admins only and with a valid or expired license.

You need to have a permission with action `reports.settings:read`.
*/
func (a *Client) GetSettingsImage(opts ...ClientOption) (*GetSettingsImageOK, error) {
	params := NewGetSettingsImageParams()
	return a.GetSettingsImageWithParams(params, opts...)
}

func (a *Client) GetSettingsImageWithParams(params *GetSettingsImageParams, opts ...ClientOption) (*GetSettingsImageOK, error) {
	if params == nil {
		params = NewGetSettingsImageParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSettingsImage",
		Method:             "GET",
		PathPattern:        "/reports/images/:image",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSettingsImageReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSettingsImageOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getSettingsImage: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RenderReportCSVs downloads a CSV report

Available to all users and with a valid license.
*/

func (a *Client) RenderReportCSVs(params *RenderReportCSVsParams, opts ...ClientOption) (*RenderReportCSVsOK, *RenderReportCSVsNoContent, error) {
	if params == nil {
		params = NewRenderReportCSVsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "renderReportCSVs",
		Method:             "GET",
		PathPattern:        "/reports/render/csvs",
		ProducesMediaTypes: []string{"application/zip"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RenderReportCSVsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *RenderReportCSVsOK:
		return value, nil, nil
	case *RenderReportCSVsNoContent:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for reports: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RenderReportPDFs renders report for multiple dashboards

Available to all users and with a valid license.
*/

func (a *Client) RenderReportPDFs(params *RenderReportPDFsParams, opts ...ClientOption) (*RenderReportPDFsOK, error) {
	if params == nil {
		params = NewRenderReportPDFsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "renderReportPDFs",
		Method:             "GET",
		PathPattern:        "/reports/render/pdfs",
		ProducesMediaTypes: []string{"application/pdf"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RenderReportPDFsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RenderReportPDFsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for renderReportPDFs: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SaveReportSettings saves settings

Available to org admins only and with a valid or expired license.

You need to have a permission with action `reports.settings:write`xx.
*/
func (a *Client) SaveReportSettings(body *models.ReportSettings, opts ...ClientOption) (*SaveReportSettingsOK, error) {
	params := NewSaveReportSettingsParams().WithBody(body)
	return a.SaveReportSettingsWithParams(params, opts...)
}

func (a *Client) SaveReportSettingsWithParams(params *SaveReportSettingsParams, opts ...ClientOption) (*SaveReportSettingsOK, error) {
	if params == nil {
		params = NewSaveReportSettingsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "saveReportSettings",
		Method:             "POST",
		PathPattern:        "/reports/settings",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SaveReportSettingsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SaveReportSettingsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for saveReportSettings: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SendReport sends a report

Generate and send a report. This API waits for the report to be generated before returning. We recommend that you set the client’s timeout to at least 60 seconds. Available to org admins only and with a valid license.

Only available in Grafana Enterprise v7.0+.
This API endpoint is experimental and may be deprecated in a future release. On deprecation, a migration strategy will be provided and the endpoint will remain functional until the next major release of Grafana.

You need to have a permission with action `reports:send`.
*/
func (a *Client) SendReport(body *models.ReportEmail, opts ...ClientOption) (*SendReportOK, error) {
	params := NewSendReportParams().WithBody(body)
	return a.SendReportWithParams(params, opts...)
}

func (a *Client) SendReportWithParams(params *SendReportParams, opts ...ClientOption) (*SendReportOK, error) {
	if params == nil {
		params = NewSendReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "sendReport",
		Method:             "POST",
		PathPattern:        "/reports/email",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SendReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SendReportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for sendReport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SendTestEmail sends test report via email

Available to org admins only and with a valid license.

You need to have a permission with action `reports:send`.
*/
func (a *Client) SendTestEmail(body *models.CreateOrUpdateReport, opts ...ClientOption) (*SendTestEmailOK, error) {
	params := NewSendTestEmailParams().WithBody(body)
	return a.SendTestEmailWithParams(params, opts...)
}

func (a *Client) SendTestEmailWithParams(params *SendTestEmailParams, opts ...ClientOption) (*SendTestEmailOK, error) {
	if params == nil {
		params = NewSendTestEmailParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "sendTestEmail",
		Method:             "POST",
		PathPattern:        "/reports/test-email",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SendTestEmailReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SendTestEmailOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for sendTestEmail: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateReport updates a report

Available to org admins only and with a valid or expired license.

You need to have a permission with action `reports.admin:write` with scope `reports:id:<report ID>`.

Requesting reports using the internal id will stop workgin in the future
Use the reporting apiserver to manage reports.  See: /apis/reporting.grafana.app/
*/
func (a *Client) UpdateReport(id int64, body *models.CreateOrUpdateReport, opts ...ClientOption) (*UpdateReportOK, error) {
	params := NewUpdateReportParams().WithBody(body).WithID(id)
	return a.UpdateReportWithParams(params, opts...)
}

func (a *Client) UpdateReportWithParams(params *UpdateReportParams, opts ...ClientOption) (*UpdateReportOK, error) {
	if params == nil {
		params = NewUpdateReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateReport",
		Method:             "PUT",
		PathPattern:        "/reports/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateReportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateReport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
