// Code generated by go-swagger; DO NOT EDIT.

package saml

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PostACSReader is a Reader for the PostACS structure.
type PostACSReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PostACSReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 302:
		result := NewPostACSFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPostACSForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPostACSInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /saml/acs] postACS", response, response.Code())
	}
}

// NewPostACSFound creates a PostACSFound with default headers values
func NewPostACSFound() *PostACSFound {
	return &PostACSFound{}
}

/*
PostACSFound describes a response with status code 302, with default header values.

(empty)
*/
type PostACSFound struct {
}

// IsSuccess returns true when this post a c s found response has a 2xx status code
func (o *PostACSFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post a c s found response has a 3xx status code
func (o *PostACSFound) IsRedirect() bool {
	return true
}

// IsClientError returns true when this post a c s found response has a 4xx status code
func (o *PostACSFound) IsClientError() bool {
	return false
}

// IsServerError returns true when this post a c s found response has a 5xx status code
func (o *PostACSFound) IsServerError() bool {
	return false
}

// IsCode returns true when this post a c s found response a status code equal to that given
func (o *PostACSFound) IsCode(code int) bool {
	return code == 302
}

// Code gets the status code for the post a c s found response
func (o *PostACSFound) Code() int {
	return 302
}

func (o *PostACSFound) Error() string {
	return fmt.Sprintf("[POST /saml/acs][%d] postACSFound", 302)
}

func (o *PostACSFound) String() string {
	return fmt.Sprintf("[POST /saml/acs][%d] postACSFound", 302)
}

func (o *PostACSFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPostACSForbidden creates a PostACSForbidden with default headers values
func NewPostACSForbidden() *PostACSForbidden {
	return &PostACSForbidden{}
}

/*
PostACSForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type PostACSForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post a c s forbidden response has a 2xx status code
func (o *PostACSForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post a c s forbidden response has a 3xx status code
func (o *PostACSForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post a c s forbidden response has a 4xx status code
func (o *PostACSForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this post a c s forbidden response has a 5xx status code
func (o *PostACSForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this post a c s forbidden response a status code equal to that given
func (o *PostACSForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the post a c s forbidden response
func (o *PostACSForbidden) Code() int {
	return 403
}

func (o *PostACSForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /saml/acs][%d] postACSForbidden %s", 403, payload)
}

func (o *PostACSForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /saml/acs][%d] postACSForbidden %s", 403, payload)
}

func (o *PostACSForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostACSForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostACSInternalServerError creates a PostACSInternalServerError with default headers values
func NewPostACSInternalServerError() *PostACSInternalServerError {
	return &PostACSInternalServerError{}
}

/*
PostACSInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type PostACSInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post a c s internal server error response has a 2xx status code
func (o *PostACSInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post a c s internal server error response has a 3xx status code
func (o *PostACSInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post a c s internal server error response has a 4xx status code
func (o *PostACSInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this post a c s internal server error response has a 5xx status code
func (o *PostACSInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this post a c s internal server error response a status code equal to that given
func (o *PostACSInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the post a c s internal server error response
func (o *PostACSInternalServerError) Code() int {
	return 500
}

func (o *PostACSInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /saml/acs][%d] postACSInternalServerError %s", 500, payload)
}

func (o *PostACSInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /saml/acs][%d] postACSInternalServerError %s", 500, payload)
}

func (o *PostACSInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostACSInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
