// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetUserByLoginOrEmailReader is a Reader for the GetUserByLoginOrEmail structure.
type GetUserByLoginOrEmailReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetUserByLoginOrEmailReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetUserByLoginOrEmailOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetUserByLoginOrEmailUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetUserByLoginOrEmailForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetUserByLoginOrEmailNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetUserByLoginOrEmailInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /users/lookup] getUserByLoginOrEmail", response, response.Code())
	}
}

// NewGetUserByLoginOrEmailOK creates a GetUserByLoginOrEmailOK with default headers values
func NewGetUserByLoginOrEmailOK() *GetUserByLoginOrEmailOK {
	return &GetUserByLoginOrEmailOK{}
}

/*
GetUserByLoginOrEmailOK describes a response with status code 200, with default header values.

(empty)
*/
type GetUserByLoginOrEmailOK struct {
	Payload *models.UserProfileDTO
}

// IsSuccess returns true when this get user by login or email Ok response has a 2xx status code
func (o *GetUserByLoginOrEmailOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get user by login or email Ok response has a 3xx status code
func (o *GetUserByLoginOrEmailOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user by login or email Ok response has a 4xx status code
func (o *GetUserByLoginOrEmailOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user by login or email Ok response has a 5xx status code
func (o *GetUserByLoginOrEmailOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get user by login or email Ok response a status code equal to that given
func (o *GetUserByLoginOrEmailOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get user by login or email Ok response
func (o *GetUserByLoginOrEmailOK) Code() int {
	return 200
}

func (o *GetUserByLoginOrEmailOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailOk %s", 200, payload)
}

func (o *GetUserByLoginOrEmailOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailOk %s", 200, payload)
}

func (o *GetUserByLoginOrEmailOK) GetPayload() *models.UserProfileDTO {
	return o.Payload
}

func (o *GetUserByLoginOrEmailOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.UserProfileDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserByLoginOrEmailUnauthorized creates a GetUserByLoginOrEmailUnauthorized with default headers values
func NewGetUserByLoginOrEmailUnauthorized() *GetUserByLoginOrEmailUnauthorized {
	return &GetUserByLoginOrEmailUnauthorized{}
}

/*
GetUserByLoginOrEmailUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetUserByLoginOrEmailUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user by login or email unauthorized response has a 2xx status code
func (o *GetUserByLoginOrEmailUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user by login or email unauthorized response has a 3xx status code
func (o *GetUserByLoginOrEmailUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user by login or email unauthorized response has a 4xx status code
func (o *GetUserByLoginOrEmailUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user by login or email unauthorized response has a 5xx status code
func (o *GetUserByLoginOrEmailUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get user by login or email unauthorized response a status code equal to that given
func (o *GetUserByLoginOrEmailUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get user by login or email unauthorized response
func (o *GetUserByLoginOrEmailUnauthorized) Code() int {
	return 401
}

func (o *GetUserByLoginOrEmailUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailUnauthorized %s", 401, payload)
}

func (o *GetUserByLoginOrEmailUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailUnauthorized %s", 401, payload)
}

func (o *GetUserByLoginOrEmailUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserByLoginOrEmailUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserByLoginOrEmailForbidden creates a GetUserByLoginOrEmailForbidden with default headers values
func NewGetUserByLoginOrEmailForbidden() *GetUserByLoginOrEmailForbidden {
	return &GetUserByLoginOrEmailForbidden{}
}

/*
GetUserByLoginOrEmailForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetUserByLoginOrEmailForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user by login or email forbidden response has a 2xx status code
func (o *GetUserByLoginOrEmailForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user by login or email forbidden response has a 3xx status code
func (o *GetUserByLoginOrEmailForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user by login or email forbidden response has a 4xx status code
func (o *GetUserByLoginOrEmailForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user by login or email forbidden response has a 5xx status code
func (o *GetUserByLoginOrEmailForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get user by login or email forbidden response a status code equal to that given
func (o *GetUserByLoginOrEmailForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get user by login or email forbidden response
func (o *GetUserByLoginOrEmailForbidden) Code() int {
	return 403
}

func (o *GetUserByLoginOrEmailForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailForbidden %s", 403, payload)
}

func (o *GetUserByLoginOrEmailForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailForbidden %s", 403, payload)
}

func (o *GetUserByLoginOrEmailForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserByLoginOrEmailForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserByLoginOrEmailNotFound creates a GetUserByLoginOrEmailNotFound with default headers values
func NewGetUserByLoginOrEmailNotFound() *GetUserByLoginOrEmailNotFound {
	return &GetUserByLoginOrEmailNotFound{}
}

/*
GetUserByLoginOrEmailNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetUserByLoginOrEmailNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user by login or email not found response has a 2xx status code
func (o *GetUserByLoginOrEmailNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user by login or email not found response has a 3xx status code
func (o *GetUserByLoginOrEmailNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user by login or email not found response has a 4xx status code
func (o *GetUserByLoginOrEmailNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user by login or email not found response has a 5xx status code
func (o *GetUserByLoginOrEmailNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get user by login or email not found response a status code equal to that given
func (o *GetUserByLoginOrEmailNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get user by login or email not found response
func (o *GetUserByLoginOrEmailNotFound) Code() int {
	return 404
}

func (o *GetUserByLoginOrEmailNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailNotFound %s", 404, payload)
}

func (o *GetUserByLoginOrEmailNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailNotFound %s", 404, payload)
}

func (o *GetUserByLoginOrEmailNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserByLoginOrEmailNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserByLoginOrEmailInternalServerError creates a GetUserByLoginOrEmailInternalServerError with default headers values
func NewGetUserByLoginOrEmailInternalServerError() *GetUserByLoginOrEmailInternalServerError {
	return &GetUserByLoginOrEmailInternalServerError{}
}

/*
GetUserByLoginOrEmailInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetUserByLoginOrEmailInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user by login or email internal server error response has a 2xx status code
func (o *GetUserByLoginOrEmailInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user by login or email internal server error response has a 3xx status code
func (o *GetUserByLoginOrEmailInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user by login or email internal server error response has a 4xx status code
func (o *GetUserByLoginOrEmailInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user by login or email internal server error response has a 5xx status code
func (o *GetUserByLoginOrEmailInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get user by login or email internal server error response a status code equal to that given
func (o *GetUserByLoginOrEmailInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get user by login or email internal server error response
func (o *GetUserByLoginOrEmailInternalServerError) Code() int {
	return 500
}

func (o *GetUserByLoginOrEmailInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailInternalServerError %s", 500, payload)
}

func (o *GetUserByLoginOrEmailInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users/lookup][%d] getUserByLoginOrEmailInternalServerError %s", 500, payload)
}

func (o *GetUserByLoginOrEmailInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserByLoginOrEmailInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
