package main

import (
	"context"
	"errors"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"os"
	"strings"

	"github.com/tencentyun/cos-go-sdk-v5"
	"github.com/tencentyun/cos-go-sdk-v5/debug"
)

func logStatus(err error) {
	if err == nil {
		return
	}
	if cos.IsNotFoundError(err) {
		// WARN
		fmt.Println("WARN: Resource is not existed")
	} else if e, ok := cos.IsCOSError(err); ok {
		fmt.Printf("ERROR: Code: %v\n", e.Code)
		fmt.Printf("ERROR: Message: %v\n", e.Message)
		fmt.Printf("ERROR: Resource: %v\n", e.Resource)
		fmt.Printf("ERROR: RequestId: %v\n", e.RequestID)
		// ERROR
	} else {
		fmt.Printf("ERROR: %v\n", err)
		// ERROR
	}
}

func main() {
	u, _ := url.Parse("https://testcd-1259654469.cos.ap-chengdu.myqcloud.com")
	b := &cos.BaseURL{BucketURL: u}
	c := cos.NewClient(b, &http.Client{
		Transport: &cos.AuthorizationTransport{
			SecretID:  os.Getenv("SECRETID"),
			SecretKey: os.Getenv("SECRETKEY"),
			Transport: &debug.DebugRequestTransport{
				RequestHeader: true,
				// Notice when put a large file and set need the request body, might happend out of memory error.
				RequestBody:    false,
				ResponseHeader: true,
				ResponseBody:   true,
			},
		},
	})
	opt := &cos.ObjectPutOptions{
		ObjectPutHeaderOptions: &cos.ObjectPutHeaderOptions{
			ContentType:           "text/html",
			XCosSSECustomerAglo:   "AES256",
			XCosSSECustomerKey:    "MDEyMzQ1Njc4OUFCQ0RFRjAxMjM0NTY3ODlBQkNERUY=",
			XCosSSECustomerKeyMD5: "U5L61r7jcwdNvT7frmUG8g==",
		},
		ACLHeaderOptions: &cos.ACLHeaderOptions{},
	}
	name := "PutFromGoWithSSE-C"
	content := "Put Object From Go With SSE-C"
	f := strings.NewReader(content)
	_, err := c.Object.Put(context.Background(), name, f, opt)
	logStatus(err)

	getopt := &cos.ObjectGetOptions{
		XCosSSECustomerAglo:   "AES256",
		XCosSSECustomerKey:    "MDEyMzQ1Njc4OUFCQ0RFRjAxMjM0NTY3ODlBQkNERUY=",
		XCosSSECustomerKeyMD5: "U5L61r7jcwdNvT7frmUG8g==",
	}
	var resp *cos.Response
	resp, err = c.Object.Get(context.Background(), name, getopt)
	logStatus(err)

	bodyBytes, _ := ioutil.ReadAll(resp.Body)
	bodyContent := string(bodyBytes)
	if bodyContent != content {
		logStatus(errors.New("Content inconsistency"))
	}
}
