/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;

public class CompletedUpgradeResponse
implements UpgradeResponse {
    private final HttpFields _httpFields;
    private final Map<String, List<String>> _headers;
    private final List<ExtensionConfig> _negotiatedExtensions;
    private final int _status;
    private final String _acceptedSubProtocol;

    public CompletedUpgradeResponse(ServerUpgradeResponse response) {
        this._httpFields = response.getHeaders().asImmutable();
        this._headers = HttpFields.asMap((HttpFields)response.getHeaders());
        this._status = response.getStatus();
        this._acceptedSubProtocol = response.getAcceptedSubProtocol();
        ArrayList<JettyExtensionConfig> extensionConfigs = new ArrayList<JettyExtensionConfig>();
        for (org.eclipse.jetty.websocket.core.ExtensionConfig extensionConfig : response.getExtensions()) {
            extensionConfigs.add(new JettyExtensionConfig(extensionConfig));
        }
        this._negotiatedExtensions = Collections.unmodifiableList(extensionConfigs);
    }

    public String getAcceptedSubProtocol() {
        return this._acceptedSubProtocol;
    }

    public List<ExtensionConfig> getExtensions() {
        return this._negotiatedExtensions;
    }

    public String getHeader(String name) {
        return this._httpFields.get(name);
    }

    public Set<String> getHeaderNames() {
        return this._httpFields.getFieldNamesCollection();
    }

    public Map<String, List<String>> getHeaders() {
        return this._headers;
    }

    public List<String> getHeaders(String name) {
        return this._httpFields.getValuesList(name);
    }

    public int getStatusCode() {
        return this._status;
    }
}

