/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.util.Arrays;
import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.util.JedisAsserts;

@Experimental
public final class CompareCondition {
    private final Condition condition;
    private final Object payload;

    private CompareCondition(Condition condition, Object payload) {
        if (!(payload instanceof String) && !(payload instanceof byte[])) {
            throw new IllegalArgumentException("payload must be String or byte[]");
        }
        this.condition = condition;
        this.payload = payload;
    }

    public static CompareCondition valueEq(String value) {
        JedisAsserts.notNull(value, "value must not be null");
        return new CompareCondition(Condition.VALUE_EQUAL, value);
    }

    public static CompareCondition valueNe(String value) {
        JedisAsserts.notNull(value, "value must not be null");
        return new CompareCondition(Condition.VALUE_NOT_EQUAL, value);
    }

    public static CompareCondition valueEq(byte[] value) {
        JedisAsserts.notNull(value, "value must not be null");
        return new CompareCondition(Condition.VALUE_EQUAL, value);
    }

    public static CompareCondition valueNe(byte[] value) {
        JedisAsserts.notNull(value, "value must not be null");
        return new CompareCondition(Condition.VALUE_NOT_EQUAL, value);
    }

    public static CompareCondition digestEq(String hex16) {
        JedisAsserts.notNull(hex16, "digest must not be null");
        return new CompareCondition(Condition.DIGEST_EQUAL, hex16);
    }

    public static CompareCondition digestNe(String hex16) {
        JedisAsserts.notNull(hex16, "digest must not be null");
        return new CompareCondition(Condition.DIGEST_NOT_EQUAL, hex16);
    }

    public static CompareCondition digestEq(byte[] digest) {
        JedisAsserts.notNull(digest, "digest must not be null");
        return new CompareCondition(Condition.DIGEST_EQUAL, digest);
    }

    public static CompareCondition digestNe(byte[] digest) {
        JedisAsserts.notNull(digest, "digest must not be null");
        return new CompareCondition(Condition.DIGEST_NOT_EQUAL, digest);
    }

    public void addTo(CommandArguments args) {
        args.add(this.condition.getKeyword()).add(this.payload);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Object getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompareCondition that = (CompareCondition)o;
        if (this.condition != that.condition) {
            return false;
        }
        if (this.payload instanceof byte[] && that.payload instanceof byte[]) {
            return Arrays.equals((byte[])this.payload, (byte[])that.payload);
        }
        return Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.condition});
        result = this.payload instanceof byte[] ? 31 * result + Arrays.hashCode((byte[])this.payload) : 31 * result + Objects.hashCode(this.payload);
        return result;
    }

    public String toString() {
        return "CompareCondition{condition=" + (Object)((Object)this.condition) + (this.payload != null ? ", payload=" + this.payload : "") + '}';
    }

    public static enum Condition {
        VALUE_EQUAL(Protocol.Keyword.IFEQ),
        VALUE_NOT_EQUAL(Protocol.Keyword.IFNE),
        DIGEST_EQUAL(Protocol.Keyword.IFDEQ),
        DIGEST_NOT_EQUAL(Protocol.Keyword.IFDNE);

        private final Protocol.Keyword keyword;

        private Condition(Protocol.Keyword keyword) {
            this.keyword = keyword;
        }

        public Protocol.Keyword getKeyword() {
            return this.keyword;
        }
    }
}

