/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;

public class PartialByteBufferMessageSink
extends AbstractMessageSink {
    public PartialByteBufferMessageSink(CoreSession session, MethodHolder methodHolder, boolean autoDemand) {
        super(session, methodHolder, autoDemand);
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (frame.hasPayload() || frame.isFin()) {
                this.invoke(this.getMethodHolder(), frame.getPayload(), frame.isFin(), callback);
                this.autoDemand();
            } else {
                callback.succeeded();
                this.getCoreSession().demand();
            }
        }
        catch (Throwable t) {
            callback.failed(t);
        }
    }

    protected void invoke(MethodHolder methodHolder, ByteBuffer byteBuffer, boolean fin, Callback callback) throws Throwable {
        methodHolder.invoke(byteBuffer, fin);
        callback.succeeded();
    }
}

