// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
)

func TestCopyOrigResourceLogsSlice(t *testing.T) {
	src := []*otlplogs.ResourceLogs{}
	dest := []*otlplogs.ResourceLogs{}
	// Test CopyTo empty
	dest = CopyOrigResourceLogsSlice(dest, src)
	assert.Equal(t, []*otlplogs.ResourceLogs{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestResourceLogsSlice()
	dest = CopyOrigResourceLogsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceLogsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigResourceLogsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceLogsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigResourceLogsSlice(dest, []*otlplogs.ResourceLogs{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigResourceLogsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceLogsSlice(), dest)
}
