//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcompute

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIError.
func (a APIError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", a.Code)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "innererror", a.Innererror)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "target", a.Target)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationProfile.
func (a ApplicationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "galleryApplications", a.GalleryApplications)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySet.
func (a AvailabilitySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetProperties.
func (a AvailabilitySetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "platformFaultDomainCount", a.PlatformFaultDomainCount)
	populate(objectMap, "platformUpdateDomainCount", a.PlatformUpdateDomainCount)
	populate(objectMap, "proximityPlacementGroup", a.ProximityPlacementGroup)
	populate(objectMap, "statuses", a.Statuses)
	populate(objectMap, "virtualMachines", a.VirtualMachines)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetUpdate.
func (a AvailabilitySetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AvailablePatchSummary.
func (a AvailablePatchSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentActivityId", a.AssessmentActivityID)
	populate(objectMap, "criticalAndSecurityPatchCount", a.CriticalAndSecurityPatchCount)
	populate(objectMap, "error", a.Error)
	populateTimeRFC3339(objectMap, "lastModifiedTime", a.LastModifiedTime)
	populate(objectMap, "otherPatchCount", a.OtherPatchCount)
	populate(objectMap, "rebootPending", a.RebootPending)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailablePatchSummary.
func (a *AvailablePatchSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentActivityId":
			err = unpopulate(val, "AssessmentActivityID", &a.AssessmentActivityID)
			delete(rawMsg, key)
		case "criticalAndSecurityPatchCount":
			err = unpopulate(val, "CriticalAndSecurityPatchCount", &a.CriticalAndSecurityPatchCount)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &a.LastModifiedTime)
			delete(rawMsg, key)
		case "otherPatchCount":
			err = unpopulate(val, "OtherPatchCount", &a.OtherPatchCount)
			delete(rawMsg, key)
		case "rebootPending":
			err = unpopulate(val, "RebootPending", &a.RebootPending)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservation.
func (c CapacityReservation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroup.
func (c CapacityReservationGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroupInstanceView.
func (c CapacityReservationGroupInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacityReservations", c.CapacityReservations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroupProperties.
func (c CapacityReservationGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacityReservations", c.CapacityReservations)
	populate(objectMap, "instanceView", c.InstanceView)
	populate(objectMap, "virtualMachinesAssociated", c.VirtualMachinesAssociated)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroupUpdate.
func (c CapacityReservationGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationInstanceView.
func (c CapacityReservationInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "statuses", c.Statuses)
	populate(objectMap, "utilizationInfo", c.UtilizationInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationInstanceViewWithName.
func (c CapacityReservationInstanceViewWithName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "statuses", c.Statuses)
	populate(objectMap, "utilizationInfo", c.UtilizationInfo)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationProperties.
func (c CapacityReservationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "instanceView", c.InstanceView)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populateTimeRFC3339(objectMap, "provisioningTime", c.ProvisioningTime)
	populate(objectMap, "reservationId", c.ReservationID)
	populateTimeRFC3339(objectMap, "timeCreated", c.TimeCreated)
	populate(objectMap, "virtualMachinesAssociated", c.VirtualMachinesAssociated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationProperties.
func (c *CapacityReservationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceView":
			err = unpopulate(val, "InstanceView", &c.InstanceView)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "provisioningTime":
			err = unpopulateTimeRFC3339(val, "ProvisioningTime", &c.ProvisioningTime)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &c.ReservationID)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &c.TimeCreated)
			delete(rawMsg, key)
		case "virtualMachinesAssociated":
			err = unpopulate(val, "VirtualMachinesAssociated", &c.VirtualMachinesAssociated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationUpdate.
func (c CapacityReservationUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationUtilization.
func (c CapacityReservationUtilization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "virtualMachinesAllocated", c.VirtualMachinesAllocated)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudService.
func (c CloudService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceExtensionProfile.
func (c CloudServiceExtensionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extensions", c.Extensions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceExtensionProperties.
func (c CloudServiceExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoUpgradeMinorVersion", c.AutoUpgradeMinorVersion)
	populate(objectMap, "forceUpdateTag", c.ForceUpdateTag)
	populate(objectMap, "protectedSettings", c.ProtectedSettings)
	populate(objectMap, "protectedSettingsFromKeyVault", c.ProtectedSettingsFromKeyVault)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "publisher", c.Publisher)
	populate(objectMap, "rolesAppliedTo", c.RolesAppliedTo)
	populate(objectMap, "settings", c.Settings)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "typeHandlerVersion", c.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceNetworkProfile.
func (c CloudServiceNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "loadBalancerConfigurations", c.LoadBalancerConfigurations)
	populate(objectMap, "swappableCloudService", c.SwappableCloudService)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceOsProfile.
func (c CloudServiceOsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "secrets", c.Secrets)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceRoleProfile.
func (c CloudServiceRoleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "roles", c.Roles)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceUpdate.
func (c CloudServiceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceVaultSecretGroup.
func (c CloudServiceVaultSecretGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sourceVault", c.SourceVault)
	populate(objectMap, "vaultCertificates", c.VaultCertificates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImageProperties.
func (c *CommunityGalleryImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disallowed":
			err = unpopulate(val, "Disallowed", &c.Disallowed)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &c.EndOfLifeDate)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &c.Features)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &c.HyperVGeneration)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &c.Identifier)
			delete(rawMsg, key)
		case "osState":
			err = unpopulate(val, "OSState", &c.OSState)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &c.OSType)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &c.PurchasePlan)
			delete(rawMsg, key)
		case "recommended":
			err = unpopulate(val, "Recommended", &c.Recommended)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImageVersionProperties.
func (c *CommunityGalleryImageVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &c.EndOfLifeDate)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateTimeRFC3339(val, "PublishedDate", &c.PublishedDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHost.
func (d DedicatedHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostAvailableCapacity.
func (d DedicatedHostAvailableCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allocatableVMs", d.AllocatableVMs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroup.
func (d DedicatedHostGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupInstanceView.
func (d DedicatedHostGroupInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hosts", d.Hosts)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupProperties.
func (d DedicatedHostGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalCapabilities", d.AdditionalCapabilities)
	populate(objectMap, "hosts", d.Hosts)
	populate(objectMap, "instanceView", d.InstanceView)
	populate(objectMap, "platformFaultDomainCount", d.PlatformFaultDomainCount)
	populate(objectMap, "supportAutomaticPlacement", d.SupportAutomaticPlacement)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupUpdate.
func (d DedicatedHostGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostInstanceView.
func (d DedicatedHostInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assetId", d.AssetID)
	populate(objectMap, "availableCapacity", d.AvailableCapacity)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostInstanceViewWithName.
func (d DedicatedHostInstanceViewWithName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assetId", d.AssetID)
	populate(objectMap, "availableCapacity", d.AvailableCapacity)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostProperties.
func (d DedicatedHostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoReplaceOnFailure", d.AutoReplaceOnFailure)
	populate(objectMap, "hostId", d.HostID)
	populate(objectMap, "instanceView", d.InstanceView)
	populate(objectMap, "licenseType", d.LicenseType)
	populate(objectMap, "platformFaultDomain", d.PlatformFaultDomain)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populateTimeRFC3339(objectMap, "provisioningTime", d.ProvisioningTime)
	populateTimeRFC3339(objectMap, "timeCreated", d.TimeCreated)
	populate(objectMap, "virtualMachines", d.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostProperties.
func (d *DedicatedHostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoReplaceOnFailure":
			err = unpopulate(val, "AutoReplaceOnFailure", &d.AutoReplaceOnFailure)
			delete(rawMsg, key)
		case "hostId":
			err = unpopulate(val, "HostID", &d.HostID)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &d.InstanceView)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &d.LicenseType)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &d.PlatformFaultDomain)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "provisioningTime":
			err = unpopulateTimeRFC3339(val, "ProvisioningTime", &d.ProvisioningTime)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &d.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostUpdate.
func (d DedicatedHostUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Disallowed.
func (d Disallowed) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskTypes", d.DiskTypes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", d.ExtendedLocation)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "managedBy", d.ManagedBy)
	populate(objectMap, "managedByExtended", d.ManagedByExtended)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskAccess.
func (d DiskAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", d.ExtendedLocation)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskAccessProperties.
func (d DiskAccessProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "privateEndpointConnections", d.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populateTimeRFC3339(objectMap, "timeCreated", d.TimeCreated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskAccessProperties.
func (d *DiskAccessProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &d.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskAccessUpdate.
func (d DiskAccessUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSet.
func (d DiskEncryptionSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetUpdate.
func (d DiskEncryptionSetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskInstanceView.
func (d DiskInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryptionSettings", d.EncryptionSettings)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskProperties.
func (d DiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "burstingEnabled", d.BurstingEnabled)
	populate(objectMap, "completionPercent", d.CompletionPercent)
	populate(objectMap, "creationData", d.CreationData)
	populate(objectMap, "dataAccessAuthMode", d.DataAccessAuthMode)
	populate(objectMap, "diskAccessId", d.DiskAccessID)
	populate(objectMap, "diskIOPSReadOnly", d.DiskIOPSReadOnly)
	populate(objectMap, "diskIOPSReadWrite", d.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadOnly", d.DiskMBpsReadOnly)
	populate(objectMap, "diskMBpsReadWrite", d.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeBytes", d.DiskSizeBytes)
	populate(objectMap, "diskSizeGB", d.DiskSizeGB)
	populate(objectMap, "diskState", d.DiskState)
	populate(objectMap, "encryption", d.Encryption)
	populate(objectMap, "encryptionSettingsCollection", d.EncryptionSettingsCollection)
	populate(objectMap, "hyperVGeneration", d.HyperVGeneration)
	populate(objectMap, "maxShares", d.MaxShares)
	populate(objectMap, "networkAccessPolicy", d.NetworkAccessPolicy)
	populate(objectMap, "osType", d.OSType)
	populate(objectMap, "propertyUpdatesInProgress", d.PropertyUpdatesInProgress)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", d.PublicNetworkAccess)
	populate(objectMap, "purchasePlan", d.PurchasePlan)
	populate(objectMap, "securityProfile", d.SecurityProfile)
	populate(objectMap, "shareInfo", d.ShareInfo)
	populate(objectMap, "supportedCapabilities", d.SupportedCapabilities)
	populate(objectMap, "supportsHibernation", d.SupportsHibernation)
	populate(objectMap, "tier", d.Tier)
	populateTimeRFC3339(objectMap, "timeCreated", d.TimeCreated)
	populate(objectMap, "uniqueId", d.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskProperties.
func (d *DiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "burstingEnabled":
			err = unpopulate(val, "BurstingEnabled", &d.BurstingEnabled)
			delete(rawMsg, key)
		case "completionPercent":
			err = unpopulate(val, "CompletionPercent", &d.CompletionPercent)
			delete(rawMsg, key)
		case "creationData":
			err = unpopulate(val, "CreationData", &d.CreationData)
			delete(rawMsg, key)
		case "dataAccessAuthMode":
			err = unpopulate(val, "DataAccessAuthMode", &d.DataAccessAuthMode)
			delete(rawMsg, key)
		case "diskAccessId":
			err = unpopulate(val, "DiskAccessID", &d.DiskAccessID)
			delete(rawMsg, key)
		case "diskIOPSReadOnly":
			err = unpopulate(val, "DiskIOPSReadOnly", &d.DiskIOPSReadOnly)
			delete(rawMsg, key)
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &d.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadOnly":
			err = unpopulate(val, "DiskMBpsReadOnly", &d.DiskMBpsReadOnly)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &d.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeBytes":
			err = unpopulate(val, "DiskSizeBytes", &d.DiskSizeBytes)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &d.DiskSizeGB)
			delete(rawMsg, key)
		case "diskState":
			err = unpopulate(val, "DiskState", &d.DiskState)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &d.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &d.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &d.HyperVGeneration)
			delete(rawMsg, key)
		case "maxShares":
			err = unpopulate(val, "MaxShares", &d.MaxShares)
			delete(rawMsg, key)
		case "networkAccessPolicy":
			err = unpopulate(val, "NetworkAccessPolicy", &d.NetworkAccessPolicy)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &d.OSType)
			delete(rawMsg, key)
		case "propertyUpdatesInProgress":
			err = unpopulate(val, "PropertyUpdatesInProgress", &d.PropertyUpdatesInProgress)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &d.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &d.PurchasePlan)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &d.SecurityProfile)
			delete(rawMsg, key)
		case "shareInfo":
			err = unpopulate(val, "ShareInfo", &d.ShareInfo)
			delete(rawMsg, key)
		case "supportedCapabilities":
			err = unpopulate(val, "SupportedCapabilities", &d.SupportedCapabilities)
			delete(rawMsg, key)
		case "supportsHibernation":
			err = unpopulate(val, "SupportsHibernation", &d.SupportsHibernation)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &d.Tier)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &d.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskRestorePointProperties.
func (d *DiskRestorePointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completionPercent":
			err = unpopulate(val, "CompletionPercent", &d.CompletionPercent)
			delete(rawMsg, key)
		case "diskAccessId":
			err = unpopulate(val, "DiskAccessID", &d.DiskAccessID)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &d.Encryption)
			delete(rawMsg, key)
		case "familyId":
			err = unpopulate(val, "FamilyID", &d.FamilyID)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &d.HyperVGeneration)
			delete(rawMsg, key)
		case "networkAccessPolicy":
			err = unpopulate(val, "NetworkAccessPolicy", &d.NetworkAccessPolicy)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &d.OSType)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &d.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &d.PurchasePlan)
			delete(rawMsg, key)
		case "replicationState":
			err = unpopulate(val, "ReplicationState", &d.ReplicationState)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &d.SourceResourceID)
			delete(rawMsg, key)
		case "sourceResourceLocation":
			err = unpopulate(val, "SourceResourceLocation", &d.SourceResourceLocation)
			delete(rawMsg, key)
		case "sourceUniqueId":
			err = unpopulate(val, "SourceUniqueID", &d.SourceUniqueID)
			delete(rawMsg, key)
		case "supportedCapabilities":
			err = unpopulate(val, "SupportedCapabilities", &d.SupportedCapabilities)
			delete(rawMsg, key)
		case "supportsHibernation":
			err = unpopulate(val, "SupportsHibernation", &d.SupportsHibernation)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskUpdate.
func (d DiskUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionImages.
func (e EncryptionImages) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDiskImages", e.DataDiskImages)
	populate(objectMap, "osDiskImage", e.OSDiskImage)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSetProperties.
func (e EncryptionSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activeKey", e.ActiveKey)
	populate(objectMap, "autoKeyRotationError", e.AutoKeyRotationError)
	populate(objectMap, "encryptionType", e.EncryptionType)
	populateTimeRFC3339(objectMap, "lastKeyRotationTimestamp", e.LastKeyRotationTimestamp)
	populate(objectMap, "previousKeys", e.PreviousKeys)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "rotationToLatestKeyVersionEnabled", e.RotationToLatestKeyVersionEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSetProperties.
func (e *EncryptionSetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeKey":
			err = unpopulate(val, "ActiveKey", &e.ActiveKey)
			delete(rawMsg, key)
		case "autoKeyRotationError":
			err = unpopulate(val, "AutoKeyRotationError", &e.AutoKeyRotationError)
			delete(rawMsg, key)
		case "encryptionType":
			err = unpopulate(val, "EncryptionType", &e.EncryptionType)
			delete(rawMsg, key)
		case "lastKeyRotationTimestamp":
			err = unpopulateTimeRFC3339(val, "LastKeyRotationTimestamp", &e.LastKeyRotationTimestamp)
			delete(rawMsg, key)
		case "previousKeys":
			err = unpopulate(val, "PreviousKeys", &e.PreviousKeys)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "rotationToLatestKeyVersionEnabled":
			err = unpopulate(val, "RotationToLatestKeyVersionEnabled", &e.RotationToLatestKeyVersionEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSettingsCollection.
func (e EncryptionSettingsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", e.Enabled)
	populate(objectMap, "encryptionSettings", e.EncryptionSettings)
	populate(objectMap, "encryptionSettingsVersion", e.EncryptionSettingsVersion)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Gallery.
func (g Gallery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplication.
func (g GalleryApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationProperties.
func (g GalleryApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", g.Description)
	populateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "eula", g.Eula)
	populate(objectMap, "privacyStatementUri", g.PrivacyStatementURI)
	populate(objectMap, "releaseNoteUri", g.ReleaseNoteURI)
	populate(objectMap, "supportedOSType", g.SupportedOSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationProperties.
func (g *GalleryApplicationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "eula":
			err = unpopulate(val, "Eula", &g.Eula)
			delete(rawMsg, key)
		case "privacyStatementUri":
			err = unpopulate(val, "PrivacyStatementURI", &g.PrivacyStatementURI)
			delete(rawMsg, key)
		case "releaseNoteUri":
			err = unpopulate(val, "ReleaseNoteURI", &g.ReleaseNoteURI)
			delete(rawMsg, key)
		case "supportedOSType":
			err = unpopulate(val, "SupportedOSType", &g.SupportedOSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationUpdate.
func (g GalleryApplicationUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersion.
func (g GalleryApplicationVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersionPublishingProfile.
func (g GalleryApplicationVersionPublishingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enableHealthCheck", g.EnableHealthCheck)
	populateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "excludeFromLatest", g.ExcludeFromLatest)
	populate(objectMap, "manageActions", g.ManageActions)
	populateTimeRFC3339(objectMap, "publishedDate", g.PublishedDate)
	populate(objectMap, "replicaCount", g.ReplicaCount)
	populate(objectMap, "replicationMode", g.ReplicationMode)
	populate(objectMap, "source", g.Source)
	populate(objectMap, "storageAccountType", g.StorageAccountType)
	populate(objectMap, "targetExtendedLocations", g.TargetExtendedLocations)
	populate(objectMap, "targetRegions", g.TargetRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationVersionPublishingProfile.
func (g *GalleryApplicationVersionPublishingProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableHealthCheck":
			err = unpopulate(val, "EnableHealthCheck", &g.EnableHealthCheck)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &g.ExcludeFromLatest)
			delete(rawMsg, key)
		case "manageActions":
			err = unpopulate(val, "ManageActions", &g.ManageActions)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateTimeRFC3339(val, "PublishedDate", &g.PublishedDate)
			delete(rawMsg, key)
		case "replicaCount":
			err = unpopulate(val, "ReplicaCount", &g.ReplicaCount)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &g.ReplicationMode)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &g.Source)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &g.StorageAccountType)
			delete(rawMsg, key)
		case "targetExtendedLocations":
			err = unpopulate(val, "TargetExtendedLocations", &g.TargetExtendedLocations)
			delete(rawMsg, key)
		case "targetRegions":
			err = unpopulate(val, "TargetRegions", &g.TargetRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersionUpdate.
func (g GalleryApplicationVersionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryArtifactPublishingProfileBase.
func (g GalleryArtifactPublishingProfileBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "excludeFromLatest", g.ExcludeFromLatest)
	populateTimeRFC3339(objectMap, "publishedDate", g.PublishedDate)
	populate(objectMap, "replicaCount", g.ReplicaCount)
	populate(objectMap, "replicationMode", g.ReplicationMode)
	populate(objectMap, "storageAccountType", g.StorageAccountType)
	populate(objectMap, "targetExtendedLocations", g.TargetExtendedLocations)
	populate(objectMap, "targetRegions", g.TargetRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryArtifactPublishingProfileBase.
func (g *GalleryArtifactPublishingProfileBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &g.ExcludeFromLatest)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateTimeRFC3339(val, "PublishedDate", &g.PublishedDate)
			delete(rawMsg, key)
		case "replicaCount":
			err = unpopulate(val, "ReplicaCount", &g.ReplicaCount)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &g.ReplicationMode)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &g.StorageAccountType)
			delete(rawMsg, key)
		case "targetExtendedLocations":
			err = unpopulate(val, "TargetExtendedLocations", &g.TargetExtendedLocations)
			delete(rawMsg, key)
		case "targetRegions":
			err = unpopulate(val, "TargetRegions", &g.TargetRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImage.
func (g GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageProperties.
func (g GalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "architecture", g.Architecture)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "disallowed", g.Disallowed)
	populateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "eula", g.Eula)
	populate(objectMap, "features", g.Features)
	populate(objectMap, "hyperVGeneration", g.HyperVGeneration)
	populate(objectMap, "identifier", g.Identifier)
	populate(objectMap, "osState", g.OSState)
	populate(objectMap, "osType", g.OSType)
	populate(objectMap, "privacyStatementUri", g.PrivacyStatementURI)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "purchasePlan", g.PurchasePlan)
	populate(objectMap, "recommended", g.Recommended)
	populate(objectMap, "releaseNoteUri", g.ReleaseNoteURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageProperties.
func (g *GalleryImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "architecture":
			err = unpopulate(val, "Architecture", &g.Architecture)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "disallowed":
			err = unpopulate(val, "Disallowed", &g.Disallowed)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "eula":
			err = unpopulate(val, "Eula", &g.Eula)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &g.Features)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &g.HyperVGeneration)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &g.Identifier)
			delete(rawMsg, key)
		case "osState":
			err = unpopulate(val, "OSState", &g.OSState)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &g.OSType)
			delete(rawMsg, key)
		case "privacyStatementUri":
			err = unpopulate(val, "PrivacyStatementURI", &g.PrivacyStatementURI)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &g.PurchasePlan)
			delete(rawMsg, key)
		case "recommended":
			err = unpopulate(val, "Recommended", &g.Recommended)
			delete(rawMsg, key)
		case "releaseNoteUri":
			err = unpopulate(val, "ReleaseNoteURI", &g.ReleaseNoteURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageUpdate.
func (g GalleryImageUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersion.
func (g GalleryImageVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionPublishingProfile.
func (g GalleryImageVersionPublishingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "excludeFromLatest", g.ExcludeFromLatest)
	populateTimeRFC3339(objectMap, "publishedDate", g.PublishedDate)
	populate(objectMap, "replicaCount", g.ReplicaCount)
	populate(objectMap, "replicationMode", g.ReplicationMode)
	populate(objectMap, "storageAccountType", g.StorageAccountType)
	populate(objectMap, "targetExtendedLocations", g.TargetExtendedLocations)
	populate(objectMap, "targetRegions", g.TargetRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersionPublishingProfile.
func (g *GalleryImageVersionPublishingProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &g.ExcludeFromLatest)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateTimeRFC3339(val, "PublishedDate", &g.PublishedDate)
			delete(rawMsg, key)
		case "replicaCount":
			err = unpopulate(val, "ReplicaCount", &g.ReplicaCount)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &g.ReplicationMode)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &g.StorageAccountType)
			delete(rawMsg, key)
		case "targetExtendedLocations":
			err = unpopulate(val, "TargetExtendedLocations", &g.TargetExtendedLocations)
			delete(rawMsg, key)
		case "targetRegions":
			err = unpopulate(val, "TargetRegions", &g.TargetRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionStorageProfile.
func (g GalleryImageVersionStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDiskImages", g.DataDiskImages)
	populate(objectMap, "osDiskImage", g.OSDiskImage)
	populate(objectMap, "source", g.Source)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionUpdate.
func (g GalleryImageVersionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryUpdate.
func (g GalleryUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Image.
func (i Image) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", i.ExtendedLocation)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ImageStorageProfile.
func (i ImageStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDisks", i.DataDisks)
	populate(objectMap, "osDisk", i.OSDisk)
	populate(objectMap, "zoneResilient", i.ZoneResilient)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ImageUpdate.
func (i ImageUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type InstanceViewStatus.
func (i InstanceViewStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", i.Code)
	populate(objectMap, "displayStatus", i.DisplayStatus)
	populate(objectMap, "level", i.Level)
	populate(objectMap, "message", i.Message)
	populateTimeRFC3339(objectMap, "time", i.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstanceViewStatus.
func (i *InstanceViewStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &i.Code)
			delete(rawMsg, key)
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &i.DisplayStatus)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &i.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &i.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &i.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LastPatchInstallationSummary.
func (l LastPatchInstallationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", l.Error)
	populate(objectMap, "excludedPatchCount", l.ExcludedPatchCount)
	populate(objectMap, "failedPatchCount", l.FailedPatchCount)
	populate(objectMap, "installationActivityId", l.InstallationActivityID)
	populate(objectMap, "installedPatchCount", l.InstalledPatchCount)
	populateTimeRFC3339(objectMap, "lastModifiedTime", l.LastModifiedTime)
	populate(objectMap, "maintenanceWindowExceeded", l.MaintenanceWindowExceeded)
	populate(objectMap, "notSelectedPatchCount", l.NotSelectedPatchCount)
	populate(objectMap, "pendingPatchCount", l.PendingPatchCount)
	populateTimeRFC3339(objectMap, "startTime", l.StartTime)
	populate(objectMap, "status", l.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LastPatchInstallationSummary.
func (l *LastPatchInstallationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &l.Error)
			delete(rawMsg, key)
		case "excludedPatchCount":
			err = unpopulate(val, "ExcludedPatchCount", &l.ExcludedPatchCount)
			delete(rawMsg, key)
		case "failedPatchCount":
			err = unpopulate(val, "FailedPatchCount", &l.FailedPatchCount)
			delete(rawMsg, key)
		case "installationActivityId":
			err = unpopulate(val, "InstallationActivityID", &l.InstallationActivityID)
			delete(rawMsg, key)
		case "installedPatchCount":
			err = unpopulate(val, "InstalledPatchCount", &l.InstalledPatchCount)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &l.LastModifiedTime)
			delete(rawMsg, key)
		case "maintenanceWindowExceeded":
			err = unpopulate(val, "MaintenanceWindowExceeded", &l.MaintenanceWindowExceeded)
			delete(rawMsg, key)
		case "notSelectedPatchCount":
			err = unpopulate(val, "NotSelectedPatchCount", &l.NotSelectedPatchCount)
			delete(rawMsg, key)
		case "pendingPatchCount":
			err = unpopulate(val, "PendingPatchCount", &l.PendingPatchCount)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &l.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxParameters.
func (l LinuxParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "classificationsToInclude", l.ClassificationsToInclude)
	populate(objectMap, "maintenanceRunId", l.MaintenanceRunID)
	populate(objectMap, "packageNameMasksToExclude", l.PackageNameMasksToExclude)
	populate(objectMap, "packageNameMasksToInclude", l.PackageNameMasksToInclude)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerConfigurationProperties.
func (l LoadBalancerConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "frontendIPConfigurations", l.FrontendIPConfigurations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsInputBase.
func (l LogAnalyticsInputBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobContainerSasUri", l.BlobContainerSasURI)
	populateTimeRFC3339(objectMap, "fromTime", l.FromTime)
	populate(objectMap, "groupByClientApplicationId", l.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", l.GroupByOperationName)
	populate(objectMap, "groupByResourceName", l.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", l.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", l.GroupByUserAgent)
	populateTimeRFC3339(objectMap, "toTime", l.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsInputBase.
func (l *LogAnalyticsInputBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &l.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateTimeRFC3339(val, "FromTime", &l.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &l.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &l.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &l.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &l.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &l.GroupByUserAgent)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateTimeRFC3339(val, "ToTime", &l.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceRedeployStatus.
func (m MaintenanceRedeployStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isCustomerInitiatedMaintenanceAllowed", m.IsCustomerInitiatedMaintenanceAllowed)
	populate(objectMap, "lastOperationMessage", m.LastOperationMessage)
	populate(objectMap, "lastOperationResultCode", m.LastOperationResultCode)
	populateTimeRFC3339(objectMap, "maintenanceWindowEndTime", m.MaintenanceWindowEndTime)
	populateTimeRFC3339(objectMap, "maintenanceWindowStartTime", m.MaintenanceWindowStartTime)
	populateTimeRFC3339(objectMap, "preMaintenanceWindowEndTime", m.PreMaintenanceWindowEndTime)
	populateTimeRFC3339(objectMap, "preMaintenanceWindowStartTime", m.PreMaintenanceWindowStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceRedeployStatus.
func (m *MaintenanceRedeployStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isCustomerInitiatedMaintenanceAllowed":
			err = unpopulate(val, "IsCustomerInitiatedMaintenanceAllowed", &m.IsCustomerInitiatedMaintenanceAllowed)
			delete(rawMsg, key)
		case "lastOperationMessage":
			err = unpopulate(val, "LastOperationMessage", &m.LastOperationMessage)
			delete(rawMsg, key)
		case "lastOperationResultCode":
			err = unpopulate(val, "LastOperationResultCode", &m.LastOperationResultCode)
			delete(rawMsg, key)
		case "maintenanceWindowEndTime":
			err = unpopulateTimeRFC3339(val, "MaintenanceWindowEndTime", &m.MaintenanceWindowEndTime)
			delete(rawMsg, key)
		case "maintenanceWindowStartTime":
			err = unpopulateTimeRFC3339(val, "MaintenanceWindowStartTime", &m.MaintenanceWindowStartTime)
			delete(rawMsg, key)
		case "preMaintenanceWindowEndTime":
			err = unpopulateTimeRFC3339(val, "PreMaintenanceWindowEndTime", &m.PreMaintenanceWindowEndTime)
			delete(rawMsg, key)
		case "preMaintenanceWindowStartTime":
			err = unpopulateTimeRFC3339(val, "PreMaintenanceWindowStartTime", &m.PreMaintenanceWindowStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkApiVersion", n.NetworkAPIVersion)
	populate(objectMap, "networkInterfaceConfigurations", n.NetworkInterfaceConfigurations)
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OSProfile.
func (o OSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminPassword", o.AdminPassword)
	populate(objectMap, "adminUsername", o.AdminUsername)
	populate(objectMap, "allowExtensionOperations", o.AllowExtensionOperations)
	populate(objectMap, "computerName", o.ComputerName)
	populate(objectMap, "customData", o.CustomData)
	populate(objectMap, "linuxConfiguration", o.LinuxConfiguration)
	populate(objectMap, "requireGuestProvisionSignal", o.RequireGuestProvisionSignal)
	populate(objectMap, "secrets", o.Secrets)
	populate(objectMap, "windowsConfiguration", o.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroup.
func (p ProximityPlacementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "zones", p.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupProperties.
func (p ProximityPlacementGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availabilitySets", p.AvailabilitySets)
	populate(objectMap, "colocationStatus", p.ColocationStatus)
	populate(objectMap, "intent", p.Intent)
	populate(objectMap, "proximityPlacementGroupType", p.ProximityPlacementGroupType)
	populate(objectMap, "virtualMachineScaleSets", p.VirtualMachineScaleSets)
	populate(objectMap, "virtualMachines", p.VirtualMachines)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupPropertiesIntent.
func (p ProximityPlacementGroupPropertiesIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "vmSizes", p.VMSizes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupUpdate.
func (p ProximityPlacementGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationStatus.
func (r ReplicationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregatedState", r.AggregatedState)
	populate(objectMap, "summary", r.Summary)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestRateByIntervalInput.
func (r RequestRateByIntervalInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobContainerSasUri", r.BlobContainerSasURI)
	populateTimeRFC3339(objectMap, "fromTime", r.FromTime)
	populate(objectMap, "groupByClientApplicationId", r.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", r.GroupByOperationName)
	populate(objectMap, "groupByResourceName", r.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", r.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", r.GroupByUserAgent)
	populate(objectMap, "intervalLength", r.IntervalLength)
	populateTimeRFC3339(objectMap, "toTime", r.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestRateByIntervalInput.
func (r *RequestRateByIntervalInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &r.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateTimeRFC3339(val, "FromTime", &r.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &r.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &r.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &r.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &r.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &r.GroupByUserAgent)
			delete(rawMsg, key)
		case "intervalLength":
			err = unpopulate(val, "IntervalLength", &r.IntervalLength)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateTimeRFC3339(val, "ToTime", &r.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceInstanceViewStatus.
func (r *ResourceInstanceViewStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &r.DisplayStatus)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &r.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &r.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceWithOptionalLocation.
func (r ResourceWithOptionalLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointCollection.
func (r RestorePointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointCollectionProperties.
func (r RestorePointCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "restorePointCollectionId", r.RestorePointCollectionID)
	populate(objectMap, "restorePoints", r.RestorePoints)
	populate(objectMap, "source", r.Source)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointCollectionUpdate.
func (r RestorePointCollectionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointInstanceView.
func (r RestorePointInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskRestorePoints", r.DiskRestorePoints)
	populate(objectMap, "statuses", r.Statuses)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointProperties.
func (r RestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consistencyMode", r.ConsistencyMode)
	populate(objectMap, "excludeDisks", r.ExcludeDisks)
	populate(objectMap, "instanceView", r.InstanceView)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "sourceMetadata", r.SourceMetadata)
	populate(objectMap, "sourceRestorePoint", r.SourceRestorePoint)
	populateTimeRFC3339(objectMap, "timeCreated", r.TimeCreated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointProperties.
func (r *RestorePointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consistencyMode":
			err = unpopulate(val, "ConsistencyMode", &r.ConsistencyMode)
			delete(rawMsg, key)
		case "excludeDisks":
			err = unpopulate(val, "ExcludeDisks", &r.ExcludeDisks)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &r.InstanceView)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "sourceMetadata":
			err = unpopulate(val, "SourceMetadata", &r.SourceMetadata)
			delete(rawMsg, key)
		case "sourceRestorePoint":
			err = unpopulate(val, "SourceRestorePoint", &r.SourceRestorePoint)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &r.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointSourceVMStorageProfile.
func (r RestorePointSourceVMStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDisks", r.DataDisks)
	populate(objectMap, "osDisk", r.OSDisk)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RoleInstances.
func (r RoleInstances) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "roleInstances", r.RoleInstances)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeRunningStatus.
func (r RollingUpgradeRunningStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", r.Code)
	populate(objectMap, "lastAction", r.LastAction)
	populateTimeRFC3339(objectMap, "lastActionTime", r.LastActionTime)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeRunningStatus.
func (r *RollingUpgradeRunningStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "lastAction":
			err = unpopulate(val, "LastAction", &r.LastAction)
			delete(rawMsg, key)
		case "lastActionTime":
			err = unpopulateTimeRFC3339(val, "LastActionTime", &r.LastActionTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeStatusInfo.
func (r RollingUpgradeStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandInput.
func (r RunCommandInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "commandId", r.CommandID)
	populate(objectMap, "parameters", r.Parameters)
	populate(objectMap, "script", r.Script)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SSHConfiguration.
func (s SSHConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publicKeys", s.PublicKeys)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyResource.
func (s SSHPublicKeyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyUpdateResource.
func (s SSHPublicKeyUpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ScaleInPolicy.
func (s ScaleInPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "forceDeletion", s.ForceDeletion)
	populate(objectMap, "rules", s.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImageProperties.
func (s *SharedGalleryImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disallowed":
			err = unpopulate(val, "Disallowed", &s.Disallowed)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &s.EndOfLifeDate)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &s.Features)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &s.HyperVGeneration)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &s.Identifier)
			delete(rawMsg, key)
		case "osState":
			err = unpopulate(val, "OSState", &s.OSState)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &s.PurchasePlan)
			delete(rawMsg, key)
		case "recommended":
			err = unpopulate(val, "Recommended", &s.Recommended)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImageVersionProperties.
func (s *SharedGalleryImageVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endOfLifeDate":
			err = unpopulateTimeRFC3339(val, "EndOfLifeDate", &s.EndOfLifeDate)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateTimeRFC3339(val, "PublishedDate", &s.PublishedDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharingProfile.
func (s SharingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "communityGalleryInfo", &s.CommunityGalleryInfo)
	populate(objectMap, "groups", s.Groups)
	populate(objectMap, "permissions", s.Permissions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SharingProfileGroup.
func (s SharingProfileGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ids", s.IDs)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SharingStatus.
func (s SharingStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregatedState", s.AggregatedState)
	populate(objectMap, "summary", s.Summary)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SharingUpdate.
func (s SharingUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groups", s.Groups)
	populate(objectMap, "operationType", s.OperationType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", s.ExtendedLocation)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "managedBy", s.ManagedBy)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotProperties.
func (s SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "completionPercent", s.CompletionPercent)
	populate(objectMap, "creationData", s.CreationData)
	populate(objectMap, "dataAccessAuthMode", s.DataAccessAuthMode)
	populate(objectMap, "diskAccessId", s.DiskAccessID)
	populate(objectMap, "diskSizeBytes", s.DiskSizeBytes)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "diskState", s.DiskState)
	populate(objectMap, "encryption", s.Encryption)
	populate(objectMap, "encryptionSettingsCollection", s.EncryptionSettingsCollection)
	populate(objectMap, "hyperVGeneration", s.HyperVGeneration)
	populate(objectMap, "incremental", s.Incremental)
	populate(objectMap, "networkAccessPolicy", s.NetworkAccessPolicy)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "purchasePlan", s.PurchasePlan)
	populate(objectMap, "securityProfile", s.SecurityProfile)
	populate(objectMap, "supportedCapabilities", s.SupportedCapabilities)
	populate(objectMap, "supportsHibernation", s.SupportsHibernation)
	populateTimeRFC3339(objectMap, "timeCreated", s.TimeCreated)
	populate(objectMap, "uniqueId", s.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotProperties.
func (s *SnapshotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completionPercent":
			err = unpopulate(val, "CompletionPercent", &s.CompletionPercent)
			delete(rawMsg, key)
		case "creationData":
			err = unpopulate(val, "CreationData", &s.CreationData)
			delete(rawMsg, key)
		case "dataAccessAuthMode":
			err = unpopulate(val, "DataAccessAuthMode", &s.DataAccessAuthMode)
			delete(rawMsg, key)
		case "diskAccessId":
			err = unpopulate(val, "DiskAccessID", &s.DiskAccessID)
			delete(rawMsg, key)
		case "diskSizeBytes":
			err = unpopulate(val, "DiskSizeBytes", &s.DiskSizeBytes)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "diskState":
			err = unpopulate(val, "DiskState", &s.DiskState)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &s.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &s.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &s.HyperVGeneration)
			delete(rawMsg, key)
		case "incremental":
			err = unpopulate(val, "Incremental", &s.Incremental)
			delete(rawMsg, key)
		case "networkAccessPolicy":
			err = unpopulate(val, "NetworkAccessPolicy", &s.NetworkAccessPolicy)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &s.PurchasePlan)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &s.SecurityProfile)
			delete(rawMsg, key)
		case "supportedCapabilities":
			err = unpopulate(val, "SupportedCapabilities", &s.SupportedCapabilities)
			delete(rawMsg, key)
		case "supportsHibernation":
			err = unpopulate(val, "SupportsHibernation", &s.SupportsHibernation)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &s.TimeCreated)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &s.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotUpdate.
func (s SnapshotUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfile.
func (s StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDisks", s.DataDisks)
	populate(objectMap, "imageReference", s.ImageReference)
	populate(objectMap, "osDisk", s.OSDisk)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ThrottledRequestsInput.
func (t ThrottledRequestsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobContainerSasUri", t.BlobContainerSasURI)
	populateTimeRFC3339(objectMap, "fromTime", t.FromTime)
	populate(objectMap, "groupByClientApplicationId", t.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", t.GroupByOperationName)
	populate(objectMap, "groupByResourceName", t.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", t.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", t.GroupByUserAgent)
	populateTimeRFC3339(objectMap, "toTime", t.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThrottledRequestsInput.
func (t *ThrottledRequestsInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &t.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateTimeRFC3339(val, "FromTime", &t.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &t.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &t.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &t.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &t.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &t.GroupByUserAgent)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateTimeRFC3339(val, "ToTime", &t.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateResource.
func (u UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateResourceDefinition.
func (u UpdateResourceDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", u.ID)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "tags", u.Tags)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradeOperationHistoryStatus.
func (u *UpgradeOperationHistoryStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &u.Code)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &u.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &u.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultSecretGroup.
func (v VaultSecretGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sourceVault", v.SourceVault)
	populate(objectMap, "vaultCertificates", v.VaultCertificates)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachine.
func (v VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineAgentInstanceView.
func (v VirtualMachineAgentInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extensionHandlers", v.ExtensionHandlers)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgentVersion", v.VMAgentVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineAssessPatchesResult.
func (v *VirtualMachineAssessPatchesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentActivityId":
			err = unpopulate(val, "AssessmentActivityID", &v.AssessmentActivityID)
			delete(rawMsg, key)
		case "availablePatches":
			err = unpopulate(val, "AvailablePatches", &v.AvailablePatches)
			delete(rawMsg, key)
		case "criticalAndSecurityPatchCount":
			err = unpopulate(val, "CriticalAndSecurityPatchCount", &v.CriticalAndSecurityPatchCount)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "otherPatchCount":
			err = unpopulate(val, "OtherPatchCount", &v.OtherPatchCount)
			delete(rawMsg, key)
		case "rebootPending":
			err = unpopulate(val, "RebootPending", &v.RebootPending)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateTimeRFC3339(val, "StartDateTime", &v.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineCaptureResult.
func (v VirtualMachineCaptureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentVersion", v.ContentVersion)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "parameters", &v.Parameters)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "$schema", v.Schema)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtension.
func (v VirtualMachineExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionImage.
func (v VirtualMachineExtensionImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionInstanceView.
func (v VirtualMachineExtensionInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", v.Name)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "substatuses", v.Substatuses)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionUpdate.
func (v VirtualMachineExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineIdentity.
func (v VirtualMachineIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", v.PrincipalID)
	populate(objectMap, "tenantId", v.TenantID)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "userAssignedIdentities", v.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImage.
func (v VirtualMachineImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImageProperties.
func (v VirtualMachineImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "architecture", v.Architecture)
	populate(objectMap, "automaticOSUpgradeProperties", v.AutomaticOSUpgradeProperties)
	populate(objectMap, "dataDiskImages", v.DataDiskImages)
	populate(objectMap, "disallowed", v.Disallowed)
	populate(objectMap, "features", v.Features)
	populate(objectMap, "hyperVGeneration", v.HyperVGeneration)
	populate(objectMap, "osDiskImage", v.OSDiskImage)
	populate(objectMap, "plan", v.Plan)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImageResource.
func (v VirtualMachineImageResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInstallPatchesResult.
func (v *VirtualMachineInstallPatchesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "excludedPatchCount":
			err = unpopulate(val, "ExcludedPatchCount", &v.ExcludedPatchCount)
			delete(rawMsg, key)
		case "failedPatchCount":
			err = unpopulate(val, "FailedPatchCount", &v.FailedPatchCount)
			delete(rawMsg, key)
		case "installationActivityId":
			err = unpopulate(val, "InstallationActivityID", &v.InstallationActivityID)
			delete(rawMsg, key)
		case "installedPatchCount":
			err = unpopulate(val, "InstalledPatchCount", &v.InstalledPatchCount)
			delete(rawMsg, key)
		case "maintenanceWindowExceeded":
			err = unpopulate(val, "MaintenanceWindowExceeded", &v.MaintenanceWindowExceeded)
			delete(rawMsg, key)
		case "notSelectedPatchCount":
			err = unpopulate(val, "NotSelectedPatchCount", &v.NotSelectedPatchCount)
			delete(rawMsg, key)
		case "patches":
			err = unpopulate(val, "Patches", &v.Patches)
			delete(rawMsg, key)
		case "pendingPatchCount":
			err = unpopulate(val, "PendingPatchCount", &v.PendingPatchCount)
			delete(rawMsg, key)
		case "rebootStatus":
			err = unpopulate(val, "RebootStatus", &v.RebootStatus)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateTimeRFC3339(val, "StartDateTime", &v.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInstanceView.
func (v VirtualMachineInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assignedHost", v.AssignedHost)
	populate(objectMap, "bootDiagnostics", v.BootDiagnostics)
	populate(objectMap, "computerName", v.ComputerName)
	populate(objectMap, "disks", v.Disks)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "hyperVGeneration", v.HyperVGeneration)
	populate(objectMap, "maintenanceRedeployStatus", v.MaintenanceRedeployStatus)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osVersion", v.OSVersion)
	populate(objectMap, "patchStatus", v.PatchStatus)
	populate(objectMap, "platformFaultDomain", v.PlatformFaultDomain)
	populate(objectMap, "platformUpdateDomain", v.PlatformUpdateDomain)
	populate(objectMap, "rdpThumbPrint", v.RdpThumbPrint)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgent", v.VMAgent)
	populate(objectMap, "vmHealth", v.VMHealth)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineNetworkInterfaceConfigurationProperties.
func (v VirtualMachineNetworkInterfaceConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "dscpConfiguration", v.DscpConfiguration)
	populate(objectMap, "enableAcceleratedNetworking", v.EnableAcceleratedNetworking)
	populate(objectMap, "enableFpga", v.EnableFpga)
	populate(objectMap, "enableIPForwarding", v.EnableIPForwarding)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "networkSecurityGroup", v.NetworkSecurityGroup)
	populate(objectMap, "primary", v.Primary)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineNetworkInterfaceDNSSettingsConfiguration.
func (v VirtualMachineNetworkInterfaceDNSSettingsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsServers", v.DNSServers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineNetworkInterfaceIPConfigurationProperties.
func (v VirtualMachineNetworkInterfaceIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationGatewayBackendAddressPools", v.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", v.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", v.LoadBalancerBackendAddressPools)
	populate(objectMap, "primary", v.Primary)
	populate(objectMap, "privateIPAddressVersion", v.PrivateIPAddressVersion)
	populate(objectMap, "publicIPAddressConfiguration", v.PublicIPAddressConfiguration)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePatchStatus.
func (v VirtualMachinePatchStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availablePatchSummary", v.AvailablePatchSummary)
	populate(objectMap, "configurationStatuses", v.ConfigurationStatuses)
	populate(objectMap, "lastPatchInstallationSummary", v.LastPatchInstallationSummary)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineProperties.
func (v VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "applicationProfile", v.ApplicationProfile)
	populate(objectMap, "availabilitySet", v.AvailabilitySet)
	populate(objectMap, "billingProfile", v.BillingProfile)
	populate(objectMap, "capacityReservation", v.CapacityReservation)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "evictionPolicy", v.EvictionPolicy)
	populate(objectMap, "extensionsTimeBudget", v.ExtensionsTimeBudget)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "host", v.Host)
	populate(objectMap, "hostGroup", v.HostGroup)
	populate(objectMap, "instanceView", v.InstanceView)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "platformFaultDomain", v.PlatformFaultDomain)
	populate(objectMap, "priority", v.Priority)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "scheduledEventsProfile", v.ScheduledEventsProfile)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populateTimeRFC3339(objectMap, "timeCreated", v.TimeCreated)
	populate(objectMap, "userData", v.UserData)
	populate(objectMap, "vmId", v.VMID)
	populate(objectMap, "virtualMachineScaleSet", v.VirtualMachineScaleSet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineProperties.
func (v *VirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "applicationProfile":
			err = unpopulate(val, "ApplicationProfile", &v.ApplicationProfile)
			delete(rawMsg, key)
		case "availabilitySet":
			err = unpopulate(val, "AvailabilitySet", &v.AvailabilitySet)
			delete(rawMsg, key)
		case "billingProfile":
			err = unpopulate(val, "BillingProfile", &v.BillingProfile)
			delete(rawMsg, key)
		case "capacityReservation":
			err = unpopulate(val, "CapacityReservation", &v.CapacityReservation)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "evictionPolicy":
			err = unpopulate(val, "EvictionPolicy", &v.EvictionPolicy)
			delete(rawMsg, key)
		case "extensionsTimeBudget":
			err = unpopulate(val, "ExtensionsTimeBudget", &v.ExtensionsTimeBudget)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &v.Host)
			delete(rawMsg, key)
		case "hostGroup":
			err = unpopulate(val, "HostGroup", &v.HostGroup)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &v.InstanceView)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &v.PlatformFaultDomain)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &v.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "scheduledEventsProfile":
			err = unpopulate(val, "ScheduledEventsProfile", &v.ScheduledEventsProfile)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &v.TimeCreated)
			delete(rawMsg, key)
		case "userData":
			err = unpopulate(val, "UserData", &v.UserData)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &v.VMID)
			delete(rawMsg, key)
		case "virtualMachineScaleSet":
			err = unpopulate(val, "VirtualMachineScaleSet", &v.VirtualMachineScaleSet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePublicIPAddressConfigurationProperties.
func (v VirtualMachinePublicIPAddressConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "ipTags", v.IPTags)
	populate(objectMap, "idleTimeoutInMinutes", v.IdleTimeoutInMinutes)
	populate(objectMap, "publicIPAddressVersion", v.PublicIPAddressVersion)
	populate(objectMap, "publicIPAllocationMethod", v.PublicIPAllocationMethod)
	populate(objectMap, "publicIPPrefix", v.PublicIPPrefix)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommand.
func (v VirtualMachineRunCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommandInstanceView.
func (v VirtualMachineRunCommandInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", v.EndTime)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "executionMessage", v.ExecutionMessage)
	populate(objectMap, "executionState", v.ExecutionState)
	populate(objectMap, "exitCode", v.ExitCode)
	populate(objectMap, "output", v.Output)
	populateTimeRFC3339(objectMap, "startTime", v.StartTime)
	populate(objectMap, "statuses", v.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineRunCommandInstanceView.
func (v *VirtualMachineRunCommandInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &v.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "executionMessage":
			err = unpopulate(val, "ExecutionMessage", &v.ExecutionMessage)
			delete(rawMsg, key)
		case "executionState":
			err = unpopulate(val, "ExecutionState", &v.ExecutionState)
			delete(rawMsg, key)
		case "exitCode":
			err = unpopulate(val, "ExitCode", &v.ExitCode)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &v.Output)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &v.StartTime)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommandProperties.
func (v VirtualMachineRunCommandProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "asyncExecution", v.AsyncExecution)
	populate(objectMap, "errorBlobUri", v.ErrorBlobURI)
	populate(objectMap, "instanceView", v.InstanceView)
	populate(objectMap, "outputBlobUri", v.OutputBlobURI)
	populate(objectMap, "parameters", v.Parameters)
	populate(objectMap, "protectedParameters", v.ProtectedParameters)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "runAsPassword", v.RunAsPassword)
	populate(objectMap, "runAsUser", v.RunAsUser)
	populate(objectMap, "source", v.Source)
	populate(objectMap, "timeoutInSeconds", v.TimeoutInSeconds)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommandUpdate.
func (v VirtualMachineRunCommandUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSet.
func (v VirtualMachineScaleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionProfile.
func (v VirtualMachineScaleSetExtensionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "extensionsTimeBudget", v.ExtensionsTimeBudget)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionProperties.
func (v VirtualMachineScaleSetExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoUpgradeMinorVersion", v.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", v.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", v.ForceUpdateTag)
	populate(objectMap, "protectedSettings", &v.ProtectedSettings)
	populate(objectMap, "protectedSettingsFromKeyVault", &v.ProtectedSettingsFromKeyVault)
	populate(objectMap, "provisionAfterExtensions", v.ProvisionAfterExtensions)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "publisher", v.Publisher)
	populate(objectMap, "settings", &v.Settings)
	populate(objectMap, "suppressFailures", v.SuppressFailures)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionUpdate.
func (v VirtualMachineScaleSetExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIPConfigurationProperties.
func (v VirtualMachineScaleSetIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationGatewayBackendAddressPools", v.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", v.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", v.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerInboundNatPools", v.LoadBalancerInboundNatPools)
	populate(objectMap, "primary", v.Primary)
	populate(objectMap, "privateIPAddressVersion", v.PrivateIPAddressVersion)
	populate(objectMap, "publicIPAddressConfiguration", v.PublicIPAddressConfiguration)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIdentity.
func (v VirtualMachineScaleSetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", v.PrincipalID)
	populate(objectMap, "tenantId", v.TenantID)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "userAssignedIdentities", v.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkConfigurationDNSSettings.
func (v VirtualMachineScaleSetNetworkConfigurationDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsServers", v.DNSServers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkConfigurationProperties.
func (v VirtualMachineScaleSetNetworkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "enableAcceleratedNetworking", v.EnableAcceleratedNetworking)
	populate(objectMap, "enableFpga", v.EnableFpga)
	populate(objectMap, "enableIPForwarding", v.EnableIPForwarding)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "networkSecurityGroup", v.NetworkSecurityGroup)
	populate(objectMap, "primary", v.Primary)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkProfile.
func (v VirtualMachineScaleSetNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "healthProbe", v.HealthProbe)
	populate(objectMap, "networkApiVersion", v.NetworkAPIVersion)
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetOSDisk.
func (v VirtualMachineScaleSetOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "caching", v.Caching)
	populate(objectMap, "createOption", v.CreateOption)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "diffDiskSettings", v.DiffDiskSettings)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "image", v.Image)
	populate(objectMap, "managedDisk", v.ManagedDisk)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "vhdContainers", v.VhdContainers)
	populate(objectMap, "writeAcceleratorEnabled", v.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetOSProfile.
func (v VirtualMachineScaleSetOSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminPassword", v.AdminPassword)
	populate(objectMap, "adminUsername", v.AdminUsername)
	populate(objectMap, "allowExtensionOperations", v.AllowExtensionOperations)
	populate(objectMap, "computerNamePrefix", v.ComputerNamePrefix)
	populate(objectMap, "customData", v.CustomData)
	populate(objectMap, "linuxConfiguration", v.LinuxConfiguration)
	populate(objectMap, "secrets", v.Secrets)
	populate(objectMap, "windowsConfiguration", v.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetProperties.
func (v VirtualMachineScaleSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "automaticRepairsPolicy", v.AutomaticRepairsPolicy)
	populate(objectMap, "doNotRunExtensionsOnOverprovisionedVMs", v.DoNotRunExtensionsOnOverprovisionedVMs)
	populate(objectMap, "hostGroup", v.HostGroup)
	populate(objectMap, "orchestrationMode", v.OrchestrationMode)
	populate(objectMap, "overprovision", v.Overprovision)
	populate(objectMap, "platformFaultDomainCount", v.PlatformFaultDomainCount)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "scaleInPolicy", v.ScaleInPolicy)
	populate(objectMap, "singlePlacementGroup", v.SinglePlacementGroup)
	populate(objectMap, "spotRestorePolicy", v.SpotRestorePolicy)
	populateTimeRFC3339(objectMap, "timeCreated", v.TimeCreated)
	populate(objectMap, "uniqueId", v.UniqueID)
	populate(objectMap, "upgradePolicy", v.UpgradePolicy)
	populate(objectMap, "virtualMachineProfile", v.VirtualMachineProfile)
	populate(objectMap, "zoneBalance", v.ZoneBalance)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetProperties.
func (v *VirtualMachineScaleSetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "automaticRepairsPolicy":
			err = unpopulate(val, "AutomaticRepairsPolicy", &v.AutomaticRepairsPolicy)
			delete(rawMsg, key)
		case "doNotRunExtensionsOnOverprovisionedVMs":
			err = unpopulate(val, "DoNotRunExtensionsOnOverprovisionedVMs", &v.DoNotRunExtensionsOnOverprovisionedVMs)
			delete(rawMsg, key)
		case "hostGroup":
			err = unpopulate(val, "HostGroup", &v.HostGroup)
			delete(rawMsg, key)
		case "orchestrationMode":
			err = unpopulate(val, "OrchestrationMode", &v.OrchestrationMode)
			delete(rawMsg, key)
		case "overprovision":
			err = unpopulate(val, "Overprovision", &v.Overprovision)
			delete(rawMsg, key)
		case "platformFaultDomainCount":
			err = unpopulate(val, "PlatformFaultDomainCount", &v.PlatformFaultDomainCount)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "scaleInPolicy":
			err = unpopulate(val, "ScaleInPolicy", &v.ScaleInPolicy)
			delete(rawMsg, key)
		case "singlePlacementGroup":
			err = unpopulate(val, "SinglePlacementGroup", &v.SinglePlacementGroup)
			delete(rawMsg, key)
		case "spotRestorePolicy":
			err = unpopulate(val, "SpotRestorePolicy", &v.SpotRestorePolicy)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &v.TimeCreated)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &v.UniqueID)
			delete(rawMsg, key)
		case "upgradePolicy":
			err = unpopulate(val, "UpgradePolicy", &v.UpgradePolicy)
			delete(rawMsg, key)
		case "virtualMachineProfile":
			err = unpopulate(val, "VirtualMachineProfile", &v.VirtualMachineProfile)
			delete(rawMsg, key)
		case "zoneBalance":
			err = unpopulate(val, "ZoneBalance", &v.ZoneBalance)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationProperties.
func (v VirtualMachineScaleSetPublicIPAddressConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "ipTags", v.IPTags)
	populate(objectMap, "idleTimeoutInMinutes", v.IdleTimeoutInMinutes)
	populate(objectMap, "publicIPAddressVersion", v.PublicIPAddressVersion)
	populate(objectMap, "publicIPPrefix", v.PublicIPPrefix)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetReimageParameters.
func (v VirtualMachineScaleSetReimageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "instanceIds", v.InstanceIDs)
	populate(objectMap, "tempDisk", v.TempDisk)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetStorageProfile.
func (v VirtualMachineScaleSetStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDisks", v.DataDisks)
	populate(objectMap, "imageReference", v.ImageReference)
	populate(objectMap, "osDisk", v.OSDisk)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdate.
func (v VirtualMachineScaleSetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateIPConfigurationProperties.
func (v VirtualMachineScaleSetUpdateIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationGatewayBackendAddressPools", v.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", v.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", v.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerInboundNatPools", v.LoadBalancerInboundNatPools)
	populate(objectMap, "primary", v.Primary)
	populate(objectMap, "privateIPAddressVersion", v.PrivateIPAddressVersion)
	populate(objectMap, "publicIPAddressConfiguration", v.PublicIPAddressConfiguration)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateNetworkConfigurationProperties.
func (v VirtualMachineScaleSetUpdateNetworkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "enableAcceleratedNetworking", v.EnableAcceleratedNetworking)
	populate(objectMap, "enableFpga", v.EnableFpga)
	populate(objectMap, "enableIPForwarding", v.EnableIPForwarding)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "networkSecurityGroup", v.NetworkSecurityGroup)
	populate(objectMap, "primary", v.Primary)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateNetworkProfile.
func (v VirtualMachineScaleSetUpdateNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "healthProbe", v.HealthProbe)
	populate(objectMap, "networkApiVersion", v.NetworkAPIVersion)
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateOSDisk.
func (v VirtualMachineScaleSetUpdateOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "caching", v.Caching)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "image", v.Image)
	populate(objectMap, "managedDisk", v.ManagedDisk)
	populate(objectMap, "vhdContainers", v.VhdContainers)
	populate(objectMap, "writeAcceleratorEnabled", v.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateOSProfile.
func (v VirtualMachineScaleSetUpdateOSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customData", v.CustomData)
	populate(objectMap, "linuxConfiguration", v.LinuxConfiguration)
	populate(objectMap, "secrets", v.Secrets)
	populate(objectMap, "windowsConfiguration", v.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateStorageProfile.
func (v VirtualMachineScaleSetUpdateStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDisks", v.DataDisks)
	populate(objectMap, "imageReference", v.ImageReference)
	populate(objectMap, "osDisk", v.OSDisk)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVM.
func (v VirtualMachineScaleSetVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "instanceId", v.InstanceID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtensionUpdate.
func (v VirtualMachineScaleSetVMExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceIDs.
func (v VirtualMachineScaleSetVMInstanceIDs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "instanceIds", v.InstanceIDs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceRequiredIDs.
func (v VirtualMachineScaleSetVMInstanceRequiredIDs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "instanceIds", v.InstanceIDs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceView.
func (v VirtualMachineScaleSetVMInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assignedHost", v.AssignedHost)
	populate(objectMap, "bootDiagnostics", v.BootDiagnostics)
	populate(objectMap, "disks", v.Disks)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "maintenanceRedeployStatus", v.MaintenanceRedeployStatus)
	populate(objectMap, "placementGroupId", v.PlacementGroupID)
	populate(objectMap, "platformFaultDomain", v.PlatformFaultDomain)
	populate(objectMap, "platformUpdateDomain", v.PlatformUpdateDomain)
	populate(objectMap, "rdpThumbPrint", v.RdpThumbPrint)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgent", v.VMAgent)
	populate(objectMap, "vmHealth", v.VMHealth)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMNetworkProfileConfiguration.
func (v VirtualMachineScaleSetVMNetworkProfileConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSoftwarePatchProperties.
func (v *VirtualMachineSoftwarePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &v.ActivityID)
			delete(rawMsg, key)
		case "assessmentState":
			err = unpopulate(val, "AssessmentState", &v.AssessmentState)
			delete(rawMsg, key)
		case "classifications":
			err = unpopulate(val, "Classifications", &v.Classifications)
			delete(rawMsg, key)
		case "kbId":
			err = unpopulate(val, "KbID", &v.KbID)
			delete(rawMsg, key)
		case "lastModifiedDateTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedDateTime", &v.LastModifiedDateTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "patchId":
			err = unpopulate(val, "PatchID", &v.PatchID)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateTimeRFC3339(val, "PublishedDate", &v.PublishedDate)
			delete(rawMsg, key)
		case "rebootBehavior":
			err = unpopulate(val, "RebootBehavior", &v.RebootBehavior)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &v.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineUpdate.
func (v VirtualMachineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WinRMConfiguration.
func (w WinRMConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "listeners", w.Listeners)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WindowsConfiguration.
func (w WindowsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalUnattendContent", w.AdditionalUnattendContent)
	populate(objectMap, "enableAutomaticUpdates", w.EnableAutomaticUpdates)
	populate(objectMap, "patchSettings", w.PatchSettings)
	populate(objectMap, "provisionVMAgent", w.ProvisionVMAgent)
	populate(objectMap, "timeZone", w.TimeZone)
	populate(objectMap, "winRM", w.WinRM)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WindowsParameters.
func (w WindowsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "classificationsToInclude", w.ClassificationsToInclude)
	populate(objectMap, "excludeKbsRequiringReboot", w.ExcludeKbsRequiringReboot)
	populate(objectMap, "kbNumbersToExclude", w.KbNumbersToExclude)
	populate(objectMap, "kbNumbersToInclude", w.KbNumbersToInclude)
	populateTimeRFC3339(objectMap, "maxPatchPublishDate", w.MaxPatchPublishDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsParameters.
func (w *WindowsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classificationsToInclude":
			err = unpopulate(val, "ClassificationsToInclude", &w.ClassificationsToInclude)
			delete(rawMsg, key)
		case "excludeKbsRequiringReboot":
			err = unpopulate(val, "ExcludeKbsRequiringReboot", &w.ExcludeKbsRequiringReboot)
			delete(rawMsg, key)
		case "kbNumbersToExclude":
			err = unpopulate(val, "KbNumbersToExclude", &w.KbNumbersToExclude)
			delete(rawMsg, key)
		case "kbNumbersToInclude":
			err = unpopulate(val, "KbNumbersToInclude", &w.KbNumbersToInclude)
			delete(rawMsg, key)
		case "maxPatchPublishDate":
			err = unpopulateTimeRFC3339(val, "MaxPatchPublishDate", &w.MaxPatchPublishDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
