// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: state.proto

package state

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of hardware technology used to protect this instance
type GCEConfidentialTechnology int32

const (
	GCEConfidentialTechnology_NONE        GCEConfidentialTechnology = 0
	GCEConfidentialTechnology_AMD_SEV     GCEConfidentialTechnology = 1
	GCEConfidentialTechnology_AMD_SEV_ES  GCEConfidentialTechnology = 2
	GCEConfidentialTechnology_INTEL_TDX   GCEConfidentialTechnology = 3
	GCEConfidentialTechnology_AMD_SEV_SNP GCEConfidentialTechnology = 4
)

// Enum value maps for GCEConfidentialTechnology.
var (
	GCEConfidentialTechnology_name = map[int32]string{
		0: "NONE",
		1: "AMD_SEV",
		2: "AMD_SEV_ES",
		3: "INTEL_TDX",
		4: "AMD_SEV_SNP",
	}
	GCEConfidentialTechnology_value = map[string]int32{
		"NONE":        0,
		"AMD_SEV":     1,
		"AMD_SEV_ES":  2,
		"INTEL_TDX":   3,
		"AMD_SEV_SNP": 4,
	}
)

func (x GCEConfidentialTechnology) Enum() *GCEConfidentialTechnology {
	p := new(GCEConfidentialTechnology)
	*p = x
	return p
}

func (x GCEConfidentialTechnology) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GCEConfidentialTechnology) Descriptor() protoreflect.EnumDescriptor {
	return file_state_proto_enumTypes[0].Descriptor()
}

func (GCEConfidentialTechnology) Type() protoreflect.EnumType {
	return &file_state_proto_enumTypes[0]
}

func (x GCEConfidentialTechnology) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GCEConfidentialTechnology.Descriptor instead.
func (GCEConfidentialTechnology) EnumDescriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{0}
}

// Common, publicly-listed certificates by different vendors.
type WellKnownCertificate int32

const (
	WellKnownCertificate_UNKNOWN WellKnownCertificate = 0
	// Microsoft certs:
	// https://go.microsoft.com/fwlink/p/?linkid=321192
	WellKnownCertificate_MS_WINDOWS_PROD_PCA_2011 WellKnownCertificate = 1
	// https://go.microsoft.com/fwlink/p/?linkid=321194
	WellKnownCertificate_MS_THIRD_PARTY_UEFI_CA_2011 WellKnownCertificate = 2
)

// Enum value maps for WellKnownCertificate.
var (
	WellKnownCertificate_name = map[int32]string{
		0: "UNKNOWN",
		1: "MS_WINDOWS_PROD_PCA_2011",
		2: "MS_THIRD_PARTY_UEFI_CA_2011",
	}
	WellKnownCertificate_value = map[string]int32{
		"UNKNOWN":                     0,
		"MS_WINDOWS_PROD_PCA_2011":    1,
		"MS_THIRD_PARTY_UEFI_CA_2011": 2,
	}
)

func (x WellKnownCertificate) Enum() *WellKnownCertificate {
	p := new(WellKnownCertificate)
	*p = x
	return p
}

func (x WellKnownCertificate) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WellKnownCertificate) Descriptor() protoreflect.EnumDescriptor {
	return file_state_proto_enumTypes[1].Descriptor()
}

func (WellKnownCertificate) Type() protoreflect.EnumType {
	return &file_state_proto_enumTypes[1]
}

func (x WellKnownCertificate) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WellKnownCertificate.Descriptor instead.
func (WellKnownCertificate) EnumDescriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{1}
}

// Enum values come from the TCG Algorithm Registry - v1.27 - Table 3.
type HashAlgo int32

const (
	HashAlgo_HASH_INVALID HashAlgo = 0
	HashAlgo_SHA1         HashAlgo = 4
	HashAlgo_SHA256       HashAlgo = 11
	HashAlgo_SHA384       HashAlgo = 12
	HashAlgo_SHA512       HashAlgo = 13
)

// Enum value maps for HashAlgo.
var (
	HashAlgo_name = map[int32]string{
		0:  "HASH_INVALID",
		4:  "SHA1",
		11: "SHA256",
		12: "SHA384",
		13: "SHA512",
	}
	HashAlgo_value = map[string]int32{
		"HASH_INVALID": 0,
		"SHA1":         4,
		"SHA256":       11,
		"SHA384":       12,
		"SHA512":       13,
	}
)

func (x HashAlgo) Enum() *HashAlgo {
	p := new(HashAlgo)
	*p = x
	return p
}

func (x HashAlgo) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HashAlgo) Descriptor() protoreflect.EnumDescriptor {
	return file_state_proto_enumTypes[2].Descriptor()
}

func (HashAlgo) Type() protoreflect.EnumType {
	return &file_state_proto_enumTypes[2]
}

func (x HashAlgo) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HashAlgo.Descriptor instead.
func (HashAlgo) EnumDescriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{2}
}

// Information uniquely identifying a GCE instance. Can be used to create an
// instance URL, which can then be used with GCE APIs. Formatted like:
//
//	https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/instances/{instance_name}
type GCEInstanceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Zone          string `protobuf:"bytes,1,opt,name=zone,proto3" json:"zone,omitempty"`
	ProjectId     string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	ProjectNumber uint64 `protobuf:"varint,3,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	InstanceName  string `protobuf:"bytes,4,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	InstanceId    uint64 `protobuf:"varint,5,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
}

func (x *GCEInstanceInfo) Reset() {
	*x = GCEInstanceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GCEInstanceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GCEInstanceInfo) ProtoMessage() {}

func (x *GCEInstanceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GCEInstanceInfo.ProtoReflect.Descriptor instead.
func (*GCEInstanceInfo) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{0}
}

func (x *GCEInstanceInfo) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *GCEInstanceInfo) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GCEInstanceInfo) GetProjectNumber() uint64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

func (x *GCEInstanceInfo) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *GCEInstanceInfo) GetInstanceId() uint64 {
	if x != nil {
		return x.InstanceId
	}
	return 0
}

// The platform/firmware state for this instance
type PlatformState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Firmware:
	//
	//	*PlatformState_ScrtmVersionId
	//	*PlatformState_GceVersion
	Firmware isPlatformState_Firmware `protobuf_oneof:"firmware"`
	// Set to NONE on non-GCE instances or non-Confidential Shielded GCE instances
	Technology GCEConfidentialTechnology `protobuf:"varint,3,opt,name=technology,proto3,enum=state.GCEConfidentialTechnology" json:"technology,omitempty"`
	// Only set for GCE instances.
	// Included for backcompat. go-eventlog should NOT set this field.
	InstanceInfo *GCEInstanceInfo `protobuf:"bytes,4,opt,name=instance_info,json=instanceInfo,proto3" json:"instance_info,omitempty"`
}

func (x *PlatformState) Reset() {
	*x = PlatformState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformState) ProtoMessage() {}

func (x *PlatformState) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformState.ProtoReflect.Descriptor instead.
func (*PlatformState) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{1}
}

func (m *PlatformState) GetFirmware() isPlatformState_Firmware {
	if m != nil {
		return m.Firmware
	}
	return nil
}

func (x *PlatformState) GetScrtmVersionId() []byte {
	if x, ok := x.GetFirmware().(*PlatformState_ScrtmVersionId); ok {
		return x.ScrtmVersionId
	}
	return nil
}

func (x *PlatformState) GetGceVersion() uint32 {
	if x, ok := x.GetFirmware().(*PlatformState_GceVersion); ok {
		return x.GceVersion
	}
	return 0
}

func (x *PlatformState) GetTechnology() GCEConfidentialTechnology {
	if x != nil {
		return x.Technology
	}
	return GCEConfidentialTechnology_NONE
}

func (x *PlatformState) GetInstanceInfo() *GCEInstanceInfo {
	if x != nil {
		return x.InstanceInfo
	}
	return nil
}

type isPlatformState_Firmware interface {
	isPlatformState_Firmware()
}

type PlatformState_ScrtmVersionId struct {
	// Raw S-CRTM version identifier (EV_S_CRTM_VERSION)
	ScrtmVersionId []byte `protobuf:"bytes,1,opt,name=scrtm_version_id,json=scrtmVersionId,proto3,oneof"`
}

type PlatformState_GceVersion struct {
	// Virtual GCE firmware version (parsed from S-CRTM version id)
	GceVersion uint32 `protobuf:"varint,2,opt,name=gce_version,json=gceVersion,proto3,oneof"`
}

func (*PlatformState_ScrtmVersionId) isPlatformState_Firmware() {}

func (*PlatformState_GceVersion) isPlatformState_Firmware() {}

type GrubFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The digest of the file (pulled from the raw event digest).
	Digest []byte `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// The event data. This is not measured, so it is untrusted.
	UntrustedFilename []byte `protobuf:"bytes,2,opt,name=untrusted_filename,json=untrustedFilename,proto3" json:"untrusted_filename,omitempty"`
}

func (x *GrubFile) Reset() {
	*x = GrubFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrubFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrubFile) ProtoMessage() {}

func (x *GrubFile) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrubFile.ProtoReflect.Descriptor instead.
func (*GrubFile) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{2}
}

func (x *GrubFile) GetDigest() []byte {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *GrubFile) GetUntrustedFilename() []byte {
	if x != nil {
		return x.UntrustedFilename
	}
	return nil
}

type GrubState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All GRUB-read and measured files, including grub.cfg.
	Files []*GrubFile `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	// A list of executed GRUB commands and command lines passed to the kernel
	// and kernel modules.
	Commands []string `protobuf:"bytes,2,rep,name=commands,proto3" json:"commands,omitempty"`
}

func (x *GrubState) Reset() {
	*x = GrubState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrubState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrubState) ProtoMessage() {}

func (x *GrubState) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrubState.ProtoReflect.Descriptor instead.
func (*GrubState) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{3}
}

func (x *GrubState) GetFiles() []*GrubFile {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *GrubState) GetCommands() []string {
	if x != nil {
		return x.Commands
	}
	return nil
}

// The state of the Linux kernel.
// At the moment, parsing LinuxKernelState relies on parsing the GrubState.
// To do so, use ExtractOpts{Loader: GRUB} when calling ParseMachineState.
type LinuxKernelState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kernel command line.
	CommandLine string `protobuf:"bytes,1,opt,name=command_line,json=commandLine,proto3" json:"command_line,omitempty"`
}

func (x *LinuxKernelState) Reset() {
	*x = LinuxKernelState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxKernelState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxKernelState) ProtoMessage() {}

func (x *LinuxKernelState) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxKernelState.ProtoReflect.Descriptor instead.
func (*LinuxKernelState) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{4}
}

func (x *LinuxKernelState) GetCommandLine() string {
	if x != nil {
		return x.CommandLine
	}
	return ""
}

// A parsed event from the source firmware event log. This can be from either
// the firmware TPM event log, the Confidential Computing event log, or any
// other TCG-like event log used by firmware to record its measurements.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The register this event was extended into. Can be PCR, RTMR, etc.
	// Named pcr_index for backcompat reasons.
	PcrIndex uint32 `protobuf:"varint,1,opt,name=pcr_index,json=pcrIndex,proto3" json:"pcr_index,omitempty"`
	// The type of this event. Note that this value is not verified, so it should
	// only be used as a hint during event parsing.
	UntrustedType uint32 `protobuf:"varint,2,opt,name=untrusted_type,json=untrustedType,proto3" json:"untrusted_type,omitempty"`
	// The raw data associated to this event. The meaning of this data is
	// specific to the type of the event.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// The event digest actually extended into the TPM. This is often the hash of
	// the data field, but in some cases it may have a type-specific calculation.
	Digest []byte `protobuf:"bytes,4,opt,name=digest,proto3" json:"digest,omitempty"`
	// This is true if hash(data) == digest.
	DigestVerified bool `protobuf:"varint,5,opt,name=digest_verified,json=digestVerified,proto3" json:"digest_verified,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{5}
}

func (x *Event) GetPcrIndex() uint32 {
	if x != nil {
		return x.PcrIndex
	}
	return 0
}

func (x *Event) GetUntrustedType() uint32 {
	if x != nil {
		return x.UntrustedType
	}
	return 0
}

func (x *Event) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Event) GetDigest() []byte {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *Event) GetDigestVerified() bool {
	if x != nil {
		return x.DigestVerified
	}
	return false
}

type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The representation of the certificate. If the certificate matches a
	// well-known certificate above, representation should contain the value in
	// the enum. Otherwise, it will contain the raw DER.
	//
	// Types that are assignable to Representation:
	//
	//	*Certificate_Der
	//	*Certificate_WellKnown
	Representation isCertificate_Representation `protobuf_oneof:"representation"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{6}
}

func (m *Certificate) GetRepresentation() isCertificate_Representation {
	if m != nil {
		return m.Representation
	}
	return nil
}

func (x *Certificate) GetDer() []byte {
	if x, ok := x.GetRepresentation().(*Certificate_Der); ok {
		return x.Der
	}
	return nil
}

func (x *Certificate) GetWellKnown() WellKnownCertificate {
	if x, ok := x.GetRepresentation().(*Certificate_WellKnown); ok {
		return x.WellKnown
	}
	return WellKnownCertificate_UNKNOWN
}

type isCertificate_Representation interface {
	isCertificate_Representation()
}

type Certificate_Der struct {
	// DER representation of the certificate.
	Der []byte `protobuf:"bytes,1,opt,name=der,proto3,oneof"`
}

type Certificate_WellKnown struct {
	WellKnown WellKnownCertificate `protobuf:"varint,2,opt,name=well_known,json=wellKnown,proto3,enum=state.WellKnownCertificate,oneof"`
}

func (*Certificate_Der) isCertificate_Representation() {}

func (*Certificate_WellKnown) isCertificate_Representation() {}

// A Secure Boot database containing lists of hashes and certificates,
// as defined by section 32.4.1 Signature Database in the UEFI spec.
type Database struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Certs  []*Certificate `protobuf:"bytes,1,rep,name=certs,proto3" json:"certs,omitempty"`
	Hashes [][]byte       `protobuf:"bytes,2,rep,name=hashes,proto3" json:"hashes,omitempty"`
}

func (x *Database) Reset() {
	*x = Database{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Database) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Database) ProtoMessage() {}

func (x *Database) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Database.ProtoReflect.Descriptor instead.
func (*Database) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{7}
}

func (x *Database) GetCerts() []*Certificate {
	if x != nil {
		return x.Certs
	}
	return nil
}

func (x *Database) GetHashes() [][]byte {
	if x != nil {
		return x.Hashes
	}
	return nil
}

// The Secure Boot state for this instance.
type SecureBootState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Secure Boot is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The Secure Boot signature (allowed) database.
	Db *Database `protobuf:"bytes,2,opt,name=db,proto3" json:"db,omitempty"`
	// The Secure Boot revoked signature (forbidden) database.
	Dbx *Database `protobuf:"bytes,3,opt,name=dbx,proto3" json:"dbx,omitempty"`
	// Authority events post-separator. Pre-separator authorities
	// are currently not supported.
	Authority *Database `protobuf:"bytes,4,opt,name=authority,proto3" json:"authority,omitempty"`
}

func (x *SecureBootState) Reset() {
	*x = SecureBootState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecureBootState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecureBootState) ProtoMessage() {}

func (x *SecureBootState) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecureBootState.ProtoReflect.Descriptor instead.
func (*SecureBootState) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{8}
}

func (x *SecureBootState) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SecureBootState) GetDb() *Database {
	if x != nil {
		return x.Db
	}
	return nil
}

func (x *SecureBootState) GetDbx() *Database {
	if x != nil {
		return x.Dbx
	}
	return nil
}

func (x *SecureBootState) GetAuthority() *Database {
	if x != nil {
		return x.Authority
	}
	return nil
}

type EfiApp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The PE/COFF digest of the EFI application (pulled from the raw event digest).
	Digest []byte `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
}

func (x *EfiApp) Reset() {
	*x = EfiApp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EfiApp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EfiApp) ProtoMessage() {}

func (x *EfiApp) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EfiApp.ProtoReflect.Descriptor instead.
func (*EfiApp) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{9}
}

func (x *EfiApp) GetDigest() []byte {
	if x != nil {
		return x.Digest
	}
	return nil
}

// The verified state of EFI Applications. Policy usage on this machine state
// should check the entire set of EFI App digests matches, not a subset.
type EfiState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// UEFI's OS Loader code is required to measure attempts to load and execute
	// UEFI applications.
	// UEFI applications are typically bootloaders such as shim and GRUB.
	// These run and are measured using the UEFI LoadImage() service.
	Apps []*EfiApp `protobuf:"bytes,1,rep,name=apps,proto3" json:"apps,omitempty"`
}

func (x *EfiState) Reset() {
	*x = EfiState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EfiState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EfiState) ProtoMessage() {}

func (x *EfiState) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EfiState.ProtoReflect.Descriptor instead.
func (*EfiState) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{10}
}

func (x *EfiState) GetApps() []*EfiApp {
	if x != nil {
		return x.Apps
	}
	return nil
}

// The verified state of a booted machine, obtained from a UEFI event log.
// The state is extracted from either EFI_TCG2_PROTOCOL or
// EFI_CC_MEASUREMENT_PROTOCOL. Both of these follow the TCG-defined format
// in https://trustedcomputinggroup.org/resource/tcg-efi-protocol-specification/
// The TCG2-related (TPM) logs are structured using TCG_PCR_EVENT (SHA1 format)
// or TCG_PCR_EVENT2 (Crypto Agile format).
// The CC logs are structured using CC_EVENT.
type FirmwareLogState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Platform   *PlatformState   `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
	SecureBoot *SecureBootState `protobuf:"bytes,2,opt,name=secure_boot,json=secureBoot,proto3" json:"secure_boot,omitempty"`
	// The complete parsed Firmware Event Log, including those events used to
	// create this MachineState.
	RawEvents []*Event `protobuf:"bytes,3,rep,name=raw_events,json=rawEvents,proto3" json:"raw_events,omitempty"`
	// The hash algorithm used to calculate event digests to verify a log entry.
	Hash        HashAlgo          `protobuf:"varint,4,opt,name=hash,proto3,enum=state.HashAlgo" json:"hash,omitempty"`
	Grub        *GrubState        `protobuf:"bytes,5,opt,name=grub,proto3" json:"grub,omitempty"`
	LinuxKernel *LinuxKernelState `protobuf:"bytes,6,opt,name=linux_kernel,json=linuxKernel,proto3" json:"linux_kernel,omitempty"`
	Efi         *EfiState         `protobuf:"bytes,8,opt,name=efi,proto3" json:"efi,omitempty"`
}

func (x *FirmwareLogState) Reset() {
	*x = FirmwareLogState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_state_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirmwareLogState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirmwareLogState) ProtoMessage() {}

func (x *FirmwareLogState) ProtoReflect() protoreflect.Message {
	mi := &file_state_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirmwareLogState.ProtoReflect.Descriptor instead.
func (*FirmwareLogState) Descriptor() ([]byte, []int) {
	return file_state_proto_rawDescGZIP(), []int{11}
}

func (x *FirmwareLogState) GetPlatform() *PlatformState {
	if x != nil {
		return x.Platform
	}
	return nil
}

func (x *FirmwareLogState) GetSecureBoot() *SecureBootState {
	if x != nil {
		return x.SecureBoot
	}
	return nil
}

func (x *FirmwareLogState) GetRawEvents() []*Event {
	if x != nil {
		return x.RawEvents
	}
	return nil
}

func (x *FirmwareLogState) GetHash() HashAlgo {
	if x != nil {
		return x.Hash
	}
	return HashAlgo_HASH_INVALID
}

func (x *FirmwareLogState) GetGrub() *GrubState {
	if x != nil {
		return x.Grub
	}
	return nil
}

func (x *FirmwareLogState) GetLinuxKernel() *LinuxKernelState {
	if x != nil {
		return x.LinuxKernel
	}
	return nil
}

func (x *FirmwareLogState) GetEfi() *EfiState {
	if x != nil {
		return x.Efi
	}
	return nil
}

var File_state_proto protoreflect.FileDescriptor

var file_state_proto_rawDesc = []byte{
	0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x0f, 0x47, 0x43, 0x45, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x22, 0xe9, 0x01, 0x0a, 0x0d, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x73, 0x63,
	0x72, 0x74, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x63, 0x72, 0x74, 0x6d, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0b, 0x67, 0x63, 0x65, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x0a, 0x67,
	0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0a, 0x74, 0x65, 0x63,
	0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x43, 0x45, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52,
	0x0a, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12, 0x3b, 0x0a, 0x0d, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x43, 0x45, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0a, 0x0a, 0x08, 0x66, 0x69, 0x72, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x22, 0x51, 0x0a, 0x08, 0x47, 0x72, 0x75, 0x62, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x75, 0x6e, 0x74, 0x72,
	0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x75, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x46,
	0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4e, 0x0a, 0x09, 0x47, 0x72, 0x75, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x75, 0x62,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x22, 0x35, 0x0a, 0x10, 0x4c, 0x69, 0x6e, 0x75, 0x78,
	0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4c, 0x69, 0x6e, 0x65, 0x22, 0xa0,
	0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x63, 0x72, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x63, 0x72,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74,
	0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x75,
	0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x16, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0e, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x22, 0x71, 0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x12, 0x0a, 0x03, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x03, 0x64, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x0a, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f,
	0x77, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x57, 0x65, 0x6c, 0x6c, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x77, 0x65, 0x6c, 0x6c, 0x4b, 0x6e, 0x6f,
	0x77, 0x6e, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4c, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x12, 0x28, 0x0a, 0x05, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x63, 0x65, 0x72, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x61,
	0x73, 0x68, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x06, 0x68, 0x61, 0x73, 0x68,
	0x65, 0x73, 0x22, 0x9e, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x1f, 0x0a, 0x02, 0x64, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x02, 0x64,
	0x62, 0x12, 0x21, 0x0a, 0x03, 0x64, 0x62, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f,
	0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52,
	0x03, 0x64, 0x62, 0x78, 0x12, 0x2d, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x22, 0x20, 0x0a, 0x06, 0x45, 0x66, 0x69, 0x41, 0x70, 0x70, 0x12, 0x16, 0x0a,
	0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x22, 0x2d, 0x0a, 0x08, 0x45, 0x66, 0x69, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x21, 0x0a, 0x04, 0x61, 0x70, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x0d, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x66, 0x69, 0x41, 0x70, 0x70, 0x52, 0x04,
	0x61, 0x70, 0x70, 0x73, 0x22, 0xda, 0x02, 0x0a, 0x10, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x4c, 0x6f, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x30, 0x0a, 0x08, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x37, 0x0a, 0x0b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42,
	0x6f, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65,
	0x42, 0x6f, 0x6f, 0x74, 0x12, 0x2b, 0x0a, 0x0a, 0x72, 0x61, 0x77, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x72, 0x61, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x23, 0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x0f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f,
	0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x12, 0x24, 0x0a, 0x04, 0x67, 0x72, 0x75, 0x62, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x75,
	0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x04, 0x67, 0x72, 0x75, 0x62, 0x12, 0x3a, 0x0a, 0x0c,
	0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78,
	0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x6c, 0x69, 0x6e,
	0x75, 0x78, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x12, 0x21, 0x0a, 0x03, 0x65, 0x66, 0x69, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x66,
	0x69, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x03, 0x65, 0x66, 0x69, 0x4a, 0x04, 0x08, 0x07, 0x10,
	0x08, 0x2a, 0x62, 0x0a, 0x19, 0x47, 0x43, 0x45, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12, 0x08,
	0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x4d, 0x44, 0x5f,
	0x53, 0x45, 0x56, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x4d, 0x44, 0x5f, 0x53, 0x45, 0x56,
	0x5f, 0x45, 0x53, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x54, 0x45, 0x4c, 0x5f, 0x54,
	0x44, 0x58, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4d, 0x44, 0x5f, 0x53, 0x45, 0x56, 0x5f,
	0x53, 0x4e, 0x50, 0x10, 0x04, 0x2a, 0x62, 0x0a, 0x14, 0x57, 0x65, 0x6c, 0x6c, 0x4b, 0x6e, 0x6f,
	0x77, 0x6e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a,
	0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x53,
	0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x5f, 0x50, 0x43,
	0x41, 0x5f, 0x32, 0x30, 0x31, 0x31, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x53, 0x5f, 0x54,
	0x48, 0x49, 0x52, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x59, 0x5f, 0x55, 0x45, 0x46, 0x49, 0x5f,
	0x43, 0x41, 0x5f, 0x32, 0x30, 0x31, 0x31, 0x10, 0x02, 0x2a, 0x4a, 0x0a, 0x08, 0x48, 0x61, 0x73,
	0x68, 0x41, 0x6c, 0x67, 0x6f, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x41, 0x53, 0x48, 0x5f, 0x49, 0x4e,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x48, 0x41, 0x31, 0x10,
	0x04, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x0b, 0x12, 0x0a, 0x0a,
	0x06, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x0c, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41,
	0x35, 0x31, 0x32, 0x10, 0x0d, 0x42, 0x2b, 0x5a, 0x29, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x6f, 0x2d, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x6c, 0x6f, 0x67, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_state_proto_rawDescOnce sync.Once
	file_state_proto_rawDescData = file_state_proto_rawDesc
)

func file_state_proto_rawDescGZIP() []byte {
	file_state_proto_rawDescOnce.Do(func() {
		file_state_proto_rawDescData = protoimpl.X.CompressGZIP(file_state_proto_rawDescData)
	})
	return file_state_proto_rawDescData
}

var file_state_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_state_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_state_proto_goTypes = []any{
	(GCEConfidentialTechnology)(0), // 0: state.GCEConfidentialTechnology
	(WellKnownCertificate)(0),      // 1: state.WellKnownCertificate
	(HashAlgo)(0),                  // 2: state.HashAlgo
	(*GCEInstanceInfo)(nil),        // 3: state.GCEInstanceInfo
	(*PlatformState)(nil),          // 4: state.PlatformState
	(*GrubFile)(nil),               // 5: state.GrubFile
	(*GrubState)(nil),              // 6: state.GrubState
	(*LinuxKernelState)(nil),       // 7: state.LinuxKernelState
	(*Event)(nil),                  // 8: state.Event
	(*Certificate)(nil),            // 9: state.Certificate
	(*Database)(nil),               // 10: state.Database
	(*SecureBootState)(nil),        // 11: state.SecureBootState
	(*EfiApp)(nil),                 // 12: state.EfiApp
	(*EfiState)(nil),               // 13: state.EfiState
	(*FirmwareLogState)(nil),       // 14: state.FirmwareLogState
}
var file_state_proto_depIdxs = []int32{
	0,  // 0: state.PlatformState.technology:type_name -> state.GCEConfidentialTechnology
	3,  // 1: state.PlatformState.instance_info:type_name -> state.GCEInstanceInfo
	5,  // 2: state.GrubState.files:type_name -> state.GrubFile
	1,  // 3: state.Certificate.well_known:type_name -> state.WellKnownCertificate
	9,  // 4: state.Database.certs:type_name -> state.Certificate
	10, // 5: state.SecureBootState.db:type_name -> state.Database
	10, // 6: state.SecureBootState.dbx:type_name -> state.Database
	10, // 7: state.SecureBootState.authority:type_name -> state.Database
	12, // 8: state.EfiState.apps:type_name -> state.EfiApp
	4,  // 9: state.FirmwareLogState.platform:type_name -> state.PlatformState
	11, // 10: state.FirmwareLogState.secure_boot:type_name -> state.SecureBootState
	8,  // 11: state.FirmwareLogState.raw_events:type_name -> state.Event
	2,  // 12: state.FirmwareLogState.hash:type_name -> state.HashAlgo
	6,  // 13: state.FirmwareLogState.grub:type_name -> state.GrubState
	7,  // 14: state.FirmwareLogState.linux_kernel:type_name -> state.LinuxKernelState
	13, // 15: state.FirmwareLogState.efi:type_name -> state.EfiState
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_state_proto_init() }
func file_state_proto_init() {
	if File_state_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_state_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GCEInstanceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*GrubFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*GrubState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*LinuxKernelState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Database); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*SecureBootState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*EfiApp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*EfiState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_state_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*FirmwareLogState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_state_proto_msgTypes[1].OneofWrappers = []any{
		(*PlatformState_ScrtmVersionId)(nil),
		(*PlatformState_GceVersion)(nil),
	}
	file_state_proto_msgTypes[6].OneofWrappers = []any{
		(*Certificate_Der)(nil),
		(*Certificate_WellKnown)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_state_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_state_proto_goTypes,
		DependencyIndexes: file_state_proto_depIdxs,
		EnumInfos:         file_state_proto_enumTypes,
		MessageInfos:      file_state_proto_msgTypes,
	}.Build()
	File_state_proto = out.File
	file_state_proto_rawDesc = nil
	file_state_proto_goTypes = nil
	file_state_proto_depIdxs = nil
}
