// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a distribution tenant.
func (c *Client) CreateDistributionTenant(ctx context.Context, params *CreateDistributionTenantInput, optFns ...func(*Options)) (*CreateDistributionTenantOutput, error) {
	if params == nil {
		params = &CreateDistributionTenantInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDistributionTenant", params, optFns, c.addOperationCreateDistributionTenantMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDistributionTenantOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDistributionTenantInput struct {

	// The ID of the multi-tenant distribution to use for creating the distribution
	// tenant.
	//
	// This member is required.
	DistributionId *string

	// The domains associated with the distribution tenant. You must specify at least
	// one domain in the request.
	//
	// This member is required.
	Domains []types.DomainItem

	// The name of the distribution tenant. Enter a friendly identifier that is unique
	// within your Amazon Web Services account. This name can't be updated after you
	// create the distribution tenant.
	//
	// This member is required.
	Name *string

	// The ID of the connection group to associate with the distribution tenant.
	ConnectionGroupId *string

	// Customizations for the distribution tenant. For each distribution tenant, you
	// can specify the geographic restrictions, and the Amazon Resource Names (ARNs)
	// for the ACM certificate and WAF web ACL. These are specific values that you can
	// override or disable from the multi-tenant distribution that was used to create
	// the distribution tenant.
	Customizations *types.Customizations

	// Indicates whether the distribution tenant should be enabled when created. If
	// the distribution tenant is disabled, the distribution tenant won't serve
	// traffic.
	Enabled *bool

	// The configuration for the CloudFront managed ACM certificate request.
	ManagedCertificateRequest *types.ManagedCertificateRequest

	// A list of parameter values to add to the resource. A parameter is specified as
	// a key-value pair. A valid parameter value must exist for any parameter that is
	// marked as required in the multi-tenant distribution.
	Parameters []types.Parameter

	// A complex type that contains zero or more Tag elements.
	Tags *types.Tags

	noSmithyDocumentSerde
}

type CreateDistributionTenantOutput struct {

	// The distribution tenant that you created.
	DistributionTenant *types.DistributionTenant

	// The current version of the distribution tenant.
	ETag *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDistributionTenantMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpCreateDistributionTenant{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpCreateDistributionTenant{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDistributionTenant"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDistributionTenantValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDistributionTenant(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDistributionTenant(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDistributionTenant",
	}
}
