// DO NOT EDIT: This file is autogenerated via the builtin command.

package interpolate

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 130,
					Line:   58,
				},
				File:   "interpolate_test.flux",
				Source: "package interpolate_test\n\n\nimport \"testing\"\nimport \"interpolate\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2014-01-01T01:00:00Z,_m,FF,0\n,,0,2014-01-01T01:02:00Z,_m,FF,2\n,,0,2014-01-01T01:04:00Z,_m,FF,4\n,,0,2014-01-01T01:06:00Z,_m,FF,6\n,,0,2014-01-01T01:08:00Z,_m,FF,8\n,,0,2014-01-01T01:10:00Z,_m,FF,10\n,,1,2014-01-01T01:01:00Z,_m,QQ,11\n,,1,2014-01-01T01:03:00Z,_m,QQ,9\n,,1,2014-01-01T01:05:00Z,_m,QQ,7\n,,1,2014-01-01T01:07:00Z,_m,QQ,5\n,,1,2014-01-01T01:09:00Z,_m,QQ,3\n,,1,2014-01-01T01:11:00Z,_m,QQ,1\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2014-01-01T01:00:00Z,_m,FF,0\n,,0,2014-01-01T01:01:00Z,_m,FF,1\n,,0,2014-01-01T01:02:00Z,_m,FF,2\n,,0,2014-01-01T01:03:00Z,_m,FF,3\n,,0,2014-01-01T01:04:00Z,_m,FF,4\n,,0,2014-01-01T01:05:00Z,_m,FF,5\n,,0,2014-01-01T01:06:00Z,_m,FF,6\n,,0,2014-01-01T01:07:00Z,_m,FF,7\n,,0,2014-01-01T01:08:00Z,_m,FF,8\n,,0,2014-01-01T01:09:00Z,_m,FF,9\n,,0,2014-01-01T01:10:00Z,_m,FF,10\n,,1,2014-01-01T01:01:00Z,_m,QQ,11\n,,1,2014-01-01T01:02:00Z,_m,QQ,10\n,,1,2014-01-01T01:03:00Z,_m,QQ,9\n,,1,2014-01-01T01:04:00Z,_m,QQ,8\n,,1,2014-01-01T01:05:00Z,_m,QQ,7\n,,1,2014-01-01T01:06:00Z,_m,QQ,6\n,,1,2014-01-01T01:07:00Z,_m,QQ,5\n,,1,2014-01-01T01:08:00Z,_m,QQ,4\n,,1,2014-01-01T01:09:00Z,_m,QQ,3\n,,1,2014-01-01T01:10:00Z,_m,QQ,2\n,,1,2014-01-01T01:11:00Z,_m,QQ,1\n\"\ninterpolateFn = (table=<-) => table\n    |> range(start: 2014-01-01T01:00:00Z, stop: 2014-01-01T02:00:00Z)\n    |> interpolate.linear(every: 1m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n\ntest interpolate_test = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: interpolateFn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "interpolate_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2014-01-01T01:00:00Z,_m,FF,0\n,,0,2014-01-01T01:02:00Z,_m,FF,2\n,,0,2014-01-01T01:04:00Z,_m,FF,4\n,,0,2014-01-01T01:06:00Z,_m,FF,6\n,,0,2014-01-01T01:08:00Z,_m,FF,8\n,,0,2014-01-01T01:10:00Z,_m,FF,10\n,,1,2014-01-01T01:01:00Z,_m,QQ,11\n,,1,2014-01-01T01:03:00Z,_m,QQ,9\n,,1,2014-01-01T01:05:00Z,_m,QQ,7\n,,1,2014-01-01T01:07:00Z,_m,QQ,5\n,,1,2014-01-01T01:09:00Z,_m,QQ,3\n,,1,2014-01-01T01:11:00Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "interpolate_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "interpolate_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2014-01-01T01:00:00Z,_m,FF,0\n,,0,2014-01-01T01:02:00Z,_m,FF,2\n,,0,2014-01-01T01:04:00Z,_m,FF,4\n,,0,2014-01-01T01:06:00Z,_m,FF,6\n,,0,2014-01-01T01:08:00Z,_m,FF,8\n,,0,2014-01-01T01:10:00Z,_m,FF,10\n,,1,2014-01-01T01:01:00Z,_m,QQ,11\n,,1,2014-01-01T01:03:00Z,_m,QQ,9\n,,1,2014-01-01T01:05:00Z,_m,QQ,7\n,,1,2014-01-01T01:07:00Z,_m,QQ,5\n,,1,2014-01-01T01:09:00Z,_m,QQ,3\n,,1,2014-01-01T01:11:00Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2014-01-01T01:00:00Z,_m,FF,0\n,,0,2014-01-01T01:02:00Z,_m,FF,2\n,,0,2014-01-01T01:04:00Z,_m,FF,4\n,,0,2014-01-01T01:06:00Z,_m,FF,6\n,,0,2014-01-01T01:08:00Z,_m,FF,8\n,,0,2014-01-01T01:10:00Z,_m,FF,10\n,,1,2014-01-01T01:01:00Z,_m,QQ,11\n,,1,2014-01-01T01:03:00Z,_m,QQ,9\n,,1,2014-01-01T01:05:00Z,_m,QQ,7\n,,1,2014-01-01T01:07:00Z,_m,QQ,5\n,,1,2014-01-01T01:09:00Z,_m,QQ,3\n,,1,2014-01-01T01:11:00Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   52,
					},
					File:   "interpolate_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2014-01-01T01:00:00Z,_m,FF,0\n,,0,2014-01-01T01:01:00Z,_m,FF,1\n,,0,2014-01-01T01:02:00Z,_m,FF,2\n,,0,2014-01-01T01:03:00Z,_m,FF,3\n,,0,2014-01-01T01:04:00Z,_m,FF,4\n,,0,2014-01-01T01:05:00Z,_m,FF,5\n,,0,2014-01-01T01:06:00Z,_m,FF,6\n,,0,2014-01-01T01:07:00Z,_m,FF,7\n,,0,2014-01-01T01:08:00Z,_m,FF,8\n,,0,2014-01-01T01:09:00Z,_m,FF,9\n,,0,2014-01-01T01:10:00Z,_m,FF,10\n,,1,2014-01-01T01:01:00Z,_m,QQ,11\n,,1,2014-01-01T01:02:00Z,_m,QQ,10\n,,1,2014-01-01T01:03:00Z,_m,QQ,9\n,,1,2014-01-01T01:04:00Z,_m,QQ,8\n,,1,2014-01-01T01:05:00Z,_m,QQ,7\n,,1,2014-01-01T01:06:00Z,_m,QQ,6\n,,1,2014-01-01T01:07:00Z,_m,QQ,5\n,,1,2014-01-01T01:08:00Z,_m,QQ,4\n,,1,2014-01-01T01:09:00Z,_m,QQ,3\n,,1,2014-01-01T01:10:00Z,_m,QQ,2\n,,1,2014-01-01T01:11:00Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   25,
						},
						File:   "interpolate_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   25,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   52,
						},
						File:   "interpolate_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2014-01-01T01:00:00Z,_m,FF,0\n,,0,2014-01-01T01:01:00Z,_m,FF,1\n,,0,2014-01-01T01:02:00Z,_m,FF,2\n,,0,2014-01-01T01:03:00Z,_m,FF,3\n,,0,2014-01-01T01:04:00Z,_m,FF,4\n,,0,2014-01-01T01:05:00Z,_m,FF,5\n,,0,2014-01-01T01:06:00Z,_m,FF,6\n,,0,2014-01-01T01:07:00Z,_m,FF,7\n,,0,2014-01-01T01:08:00Z,_m,FF,8\n,,0,2014-01-01T01:09:00Z,_m,FF,9\n,,0,2014-01-01T01:10:00Z,_m,FF,10\n,,1,2014-01-01T01:01:00Z,_m,QQ,11\n,,1,2014-01-01T01:02:00Z,_m,QQ,10\n,,1,2014-01-01T01:03:00Z,_m,QQ,9\n,,1,2014-01-01T01:04:00Z,_m,QQ,8\n,,1,2014-01-01T01:05:00Z,_m,QQ,7\n,,1,2014-01-01T01:06:00Z,_m,QQ,6\n,,1,2014-01-01T01:07:00Z,_m,QQ,5\n,,1,2014-01-01T01:08:00Z,_m,QQ,4\n,,1,2014-01-01T01:09:00Z,_m,QQ,3\n,,1,2014-01-01T01:10:00Z,_m,QQ,2\n,,1,2014-01-01T01:11:00Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   25,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2014-01-01T01:00:00Z,_m,FF,0\n,,0,2014-01-01T01:01:00Z,_m,FF,1\n,,0,2014-01-01T01:02:00Z,_m,FF,2\n,,0,2014-01-01T01:03:00Z,_m,FF,3\n,,0,2014-01-01T01:04:00Z,_m,FF,4\n,,0,2014-01-01T01:05:00Z,_m,FF,5\n,,0,2014-01-01T01:06:00Z,_m,FF,6\n,,0,2014-01-01T01:07:00Z,_m,FF,7\n,,0,2014-01-01T01:08:00Z,_m,FF,8\n,,0,2014-01-01T01:09:00Z,_m,FF,9\n,,0,2014-01-01T01:10:00Z,_m,FF,10\n,,1,2014-01-01T01:01:00Z,_m,QQ,11\n,,1,2014-01-01T01:02:00Z,_m,QQ,10\n,,1,2014-01-01T01:03:00Z,_m,QQ,9\n,,1,2014-01-01T01:04:00Z,_m,QQ,8\n,,1,2014-01-01T01:05:00Z,_m,QQ,7\n,,1,2014-01-01T01:06:00Z,_m,QQ,6\n,,1,2014-01-01T01:07:00Z,_m,QQ,5\n,,1,2014-01-01T01:08:00Z,_m,QQ,4\n,,1,2014-01-01T01:09:00Z,_m,QQ,3\n,,1,2014-01-01T01:10:00Z,_m,QQ,2\n,,1,2014-01-01T01:11:00Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   56,
					},
					File:   "interpolate_test.flux",
					Source: "interpolateFn = (table=<-) => table\n    |> range(start: 2014-01-01T01:00:00Z, stop: 2014-01-01T02:00:00Z)\n    |> interpolate.linear(every: 1m)\n    |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   53,
						},
						File:   "interpolate_test.flux",
						Source: "interpolateFn",
						Start: ast.Position{
							Column: 1,
							Line:   53,
						},
					},
				},
				Name: "interpolateFn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   56,
						},
						File:   "interpolate_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2014-01-01T01:00:00Z, stop: 2014-01-01T02:00:00Z)\n    |> interpolate.linear(every: 1m)\n    |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 17,
							Line:   53,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   53,
										},
										File:   "interpolate_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 31,
											Line:   53,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   54,
									},
									File:   "interpolate_test.flux",
									Source: "table\n    |> range(start: 2014-01-01T01:00:00Z, stop: 2014-01-01T02:00:00Z)",
									Start: ast.Position{
										Column: 31,
										Line:   53,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   54,
											},
											File:   "interpolate_test.flux",
											Source: "start: 2014-01-01T01:00:00Z, stop: 2014-01-01T02:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   54,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   54,
												},
												File:   "interpolate_test.flux",
												Source: "start: 2014-01-01T01:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   54,
													},
													File:   "interpolate_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   54,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   54,
													},
													File:   "interpolate_test.flux",
													Source: "2014-01-01T01:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   54,
													},
												},
											},
											Value: parser.MustParseTime("2014-01-01T01:00:00Z"),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   54,
												},
												File:   "interpolate_test.flux",
												Source: "stop: 2014-01-01T02:00:00Z",
												Start: ast.Position{
													Column: 43,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   54,
													},
													File:   "interpolate_test.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 43,
														Line:   54,
													},
												},
											},
											Name: "stop",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   54,
													},
													File:   "interpolate_test.flux",
													Source: "2014-01-01T02:00:00Z",
													Start: ast.Position{
														Column: 49,
														Line:   54,
													},
												},
											},
											Value: parser.MustParseTime("2014-01-01T02:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   54,
										},
										File:   "interpolate_test.flux",
										Source: "range(start: 2014-01-01T01:00:00Z, stop: 2014-01-01T02:00:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   54,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   54,
											},
											File:   "interpolate_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   54,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   55,
								},
								File:   "interpolate_test.flux",
								Source: "table\n    |> range(start: 2014-01-01T01:00:00Z, stop: 2014-01-01T02:00:00Z)\n    |> interpolate.linear(every: 1m)",
								Start: ast.Position{
									Column: 31,
									Line:   53,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   55,
										},
										File:   "interpolate_test.flux",
										Source: "every: 1m",
										Start: ast.Position{
											Column: 27,
											Line:   55,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   55,
											},
											File:   "interpolate_test.flux",
											Source: "every: 1m",
											Start: ast.Position{
												Column: 27,
												Line:   55,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   55,
												},
												File:   "interpolate_test.flux",
												Source: "every",
												Start: ast.Position{
													Column: 27,
													Line:   55,
												},
											},
										},
										Name: "every",
									},
									Separator: nil,
									Value: &ast.DurationLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   55,
												},
												File:   "interpolate_test.flux",
												Source: "1m",
												Start: ast.Position{
													Column: 34,
													Line:   55,
												},
											},
										},
										Values: []ast.Duration{ast.Duration{
											Magnitude: int64(1),
											Unit:      "m",
										}},
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   55,
									},
									File:   "interpolate_test.flux",
									Source: "interpolate.linear(every: 1m)",
									Start: ast.Position{
										Column: 8,
										Line:   55,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   55,
										},
										File:   "interpolate_test.flux",
										Source: "interpolate.linear",
										Start: ast.Position{
											Column: 8,
											Line:   55,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   55,
											},
											File:   "interpolate_test.flux",
											Source: "interpolate",
											Start: ast.Position{
												Column: 8,
												Line:   55,
											},
										},
									},
									Name: "interpolate",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   55,
											},
											File:   "interpolate_test.flux",
											Source: "linear",
											Start: ast.Position{
												Column: 20,
												Line:   55,
											},
										},
									},
									Name: "linear",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   56,
							},
							File:   "interpolate_test.flux",
							Source: "table\n    |> range(start: 2014-01-01T01:00:00Z, stop: 2014-01-01T02:00:00Z)\n    |> interpolate.linear(every: 1m)\n    |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 31,
								Line:   53,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   56,
									},
									File:   "interpolate_test.flux",
									Source: "columns: [\"_start\", \"_stop\"]",
									Start: ast.Position{
										Column: 13,
										Line:   56,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   56,
										},
										File:   "interpolate_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   56,
											},
											File:   "interpolate_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   56,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   56,
											},
											File:   "interpolate_test.flux",
											Source: "[\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 22,
												Line:   56,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   56,
												},
												File:   "interpolate_test.flux",
												Source: "\"_start\"",
												Start: ast.Position{
													Column: 23,
													Line:   56,
												},
											},
										},
										Value: "_start",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   56,
												},
												File:   "interpolate_test.flux",
												Source: "\"_stop\"",
												Start: ast.Position{
													Column: 33,
													Line:   56,
												},
											},
										},
										Value: "_stop",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   56,
								},
								File:   "interpolate_test.flux",
								Source: "drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 8,
									Line:   56,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   56,
									},
									File:   "interpolate_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   56,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   53,
							},
							File:   "interpolate_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 18,
								Line:   53,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   53,
								},
								File:   "interpolate_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 18,
									Line:   53,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   53,
							},
							File:   "interpolate_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   53,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 130,
							Line:   58,
						},
						File:   "interpolate_test.flux",
						Source: "interpolate_test = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: interpolateFn})",
						Start: ast.Position{
							Column: 6,
							Line:   58,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   58,
							},
							File:   "interpolate_test.flux",
							Source: "interpolate_test",
							Start: ast.Position{
								Column: 6,
								Line:   58,
							},
						},
					},
					Name: "interpolate_test",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 130,
								Line:   58,
							},
							File:   "interpolate_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: interpolateFn})",
							Start: ast.Position{
								Column: 25,
								Line:   58,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 130,
									Line:   58,
								},
								File:   "interpolate_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: interpolateFn})",
								Start: ast.Position{
									Column: 31,
									Line:   58,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 129,
										Line:   58,
									},
									File:   "interpolate_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: interpolateFn}",
									Start: ast.Position{
										Column: 32,
										Line:   58,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   58,
										},
										File:   "interpolate_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 33,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   58,
											},
											File:   "interpolate_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 33,
												Line:   58,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   58,
												},
												File:   "interpolate_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 60,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   58,
													},
													File:   "interpolate_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 60,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   58,
														},
														File:   "interpolate_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 60,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   58,
														},
														File:   "interpolate_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 65,
															Line:   58,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   58,
											},
											File:   "interpolate_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 40,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   58,
												},
												File:   "interpolate_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 40,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   58,
													},
													File:   "interpolate_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 40,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   58,
													},
													File:   "interpolate_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 48,
														Line:   58,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   58,
										},
										File:   "interpolate_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 74,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   58,
											},
											File:   "interpolate_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 74,
												Line:   58,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   58,
												},
												File:   "interpolate_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 96,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   58,
													},
													File:   "interpolate_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 96,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   58,
														},
														File:   "interpolate_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 96,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   58,
														},
														File:   "interpolate_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 101,
															Line:   58,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   58,
											},
											File:   "interpolate_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 80,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   58,
												},
												File:   "interpolate_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 80,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   58,
													},
													File:   "interpolate_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 80,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   58,
													},
													File:   "interpolate_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 88,
														Line:   58,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 128,
											Line:   58,
										},
										File:   "interpolate_test.flux",
										Source: "fn: interpolateFn",
										Start: ast.Position{
											Column: 111,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   58,
											},
											File:   "interpolate_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 111,
												Line:   58,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 128,
												Line:   58,
											},
											File:   "interpolate_test.flux",
											Source: "interpolateFn",
											Start: ast.Position{
												Column: 115,
												Line:   58,
											},
										},
									},
									Name: "interpolateFn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 130,
						Line:   58,
					},
					File:   "interpolate_test.flux",
					Source: "test interpolate_test = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: interpolateFn})",
					Start: ast.Position{
						Column: 1,
						Line:   58,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "interpolate_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "interpolate_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   5,
					},
					File:   "interpolate_test.flux",
					Source: "import \"interpolate\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   5,
						},
						File:   "interpolate_test.flux",
						Source: "\"interpolate\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "interpolate",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "interpolate_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   1,
					},
					File:   "interpolate_test.flux",
					Source: "package interpolate_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   1,
						},
						File:   "interpolate_test.flux",
						Source: "interpolate_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "interpolate_test",
			},
		},
	}},
	Package: "interpolate_test",
	Path:    "interpolate",
}}
