// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

package contactcenterinsightspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ContactCenterInsights_CreateConversation_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateConversation"
	ContactCenterInsights_UploadConversation_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UploadConversation"
	ContactCenterInsights_UpdateConversation_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateConversation"
	ContactCenterInsights_GetConversation_FullMethodName             = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetConversation"
	ContactCenterInsights_ListConversations_FullMethodName           = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListConversations"
	ContactCenterInsights_DeleteConversation_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteConversation"
	ContactCenterInsights_CreateAnalysis_FullMethodName              = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateAnalysis"
	ContactCenterInsights_GetAnalysis_FullMethodName                 = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetAnalysis"
	ContactCenterInsights_ListAnalyses_FullMethodName                = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListAnalyses"
	ContactCenterInsights_DeleteAnalysis_FullMethodName              = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteAnalysis"
	ContactCenterInsights_BulkAnalyzeConversations_FullMethodName    = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/BulkAnalyzeConversations"
	ContactCenterInsights_BulkDeleteConversations_FullMethodName     = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/BulkDeleteConversations"
	ContactCenterInsights_IngestConversations_FullMethodName         = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/IngestConversations"
	ContactCenterInsights_ExportInsightsData_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ExportInsightsData"
	ContactCenterInsights_CreateIssueModel_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateIssueModel"
	ContactCenterInsights_UpdateIssueModel_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssueModel"
	ContactCenterInsights_GetIssueModel_FullMethodName               = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssueModel"
	ContactCenterInsights_ListIssueModels_FullMethodName             = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssueModels"
	ContactCenterInsights_DeleteIssueModel_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteIssueModel"
	ContactCenterInsights_DeployIssueModel_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeployIssueModel"
	ContactCenterInsights_UndeployIssueModel_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UndeployIssueModel"
	ContactCenterInsights_ExportIssueModel_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ExportIssueModel"
	ContactCenterInsights_ImportIssueModel_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ImportIssueModel"
	ContactCenterInsights_GetIssue_FullMethodName                    = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssue"
	ContactCenterInsights_ListIssues_FullMethodName                  = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssues"
	ContactCenterInsights_UpdateIssue_FullMethodName                 = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssue"
	ContactCenterInsights_DeleteIssue_FullMethodName                 = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteIssue"
	ContactCenterInsights_CalculateIssueModelStats_FullMethodName    = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateIssueModelStats"
	ContactCenterInsights_CreatePhraseMatcher_FullMethodName         = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreatePhraseMatcher"
	ContactCenterInsights_GetPhraseMatcher_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetPhraseMatcher"
	ContactCenterInsights_ListPhraseMatchers_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListPhraseMatchers"
	ContactCenterInsights_DeletePhraseMatcher_FullMethodName         = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeletePhraseMatcher"
	ContactCenterInsights_UpdatePhraseMatcher_FullMethodName         = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdatePhraseMatcher"
	ContactCenterInsights_CalculateStats_FullMethodName              = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateStats"
	ContactCenterInsights_GetSettings_FullMethodName                 = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetSettings"
	ContactCenterInsights_UpdateSettings_FullMethodName              = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateSettings"
	ContactCenterInsights_CreateAnalysisRule_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateAnalysisRule"
	ContactCenterInsights_GetAnalysisRule_FullMethodName             = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetAnalysisRule"
	ContactCenterInsights_ListAnalysisRules_FullMethodName           = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListAnalysisRules"
	ContactCenterInsights_UpdateAnalysisRule_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateAnalysisRule"
	ContactCenterInsights_DeleteAnalysisRule_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteAnalysisRule"
	ContactCenterInsights_GetEncryptionSpec_FullMethodName           = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetEncryptionSpec"
	ContactCenterInsights_InitializeEncryptionSpec_FullMethodName    = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/InitializeEncryptionSpec"
	ContactCenterInsights_CreateView_FullMethodName                  = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateView"
	ContactCenterInsights_GetView_FullMethodName                     = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetView"
	ContactCenterInsights_ListViews_FullMethodName                   = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListViews"
	ContactCenterInsights_UpdateView_FullMethodName                  = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateView"
	ContactCenterInsights_DeleteView_FullMethodName                  = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteView"
	ContactCenterInsights_QueryMetrics_FullMethodName                = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/QueryMetrics"
	ContactCenterInsights_CreateQaQuestion_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateQaQuestion"
	ContactCenterInsights_GetQaQuestion_FullMethodName               = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetQaQuestion"
	ContactCenterInsights_UpdateQaQuestion_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateQaQuestion"
	ContactCenterInsights_DeleteQaQuestion_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteQaQuestion"
	ContactCenterInsights_ListQaQuestions_FullMethodName             = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListQaQuestions"
	ContactCenterInsights_CreateQaScorecard_FullMethodName           = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateQaScorecard"
	ContactCenterInsights_GetQaScorecard_FullMethodName              = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetQaScorecard"
	ContactCenterInsights_UpdateQaScorecard_FullMethodName           = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateQaScorecard"
	ContactCenterInsights_DeleteQaScorecard_FullMethodName           = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteQaScorecard"
	ContactCenterInsights_ListQaScorecards_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListQaScorecards"
	ContactCenterInsights_CreateQaScorecardRevision_FullMethodName   = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateQaScorecardRevision"
	ContactCenterInsights_GetQaScorecardRevision_FullMethodName      = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetQaScorecardRevision"
	ContactCenterInsights_TuneQaScorecardRevision_FullMethodName     = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/TuneQaScorecardRevision"
	ContactCenterInsights_DeployQaScorecardRevision_FullMethodName   = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeployQaScorecardRevision"
	ContactCenterInsights_UndeployQaScorecardRevision_FullMethodName = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UndeployQaScorecardRevision"
	ContactCenterInsights_DeleteQaScorecardRevision_FullMethodName   = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteQaScorecardRevision"
	ContactCenterInsights_ListQaScorecardRevisions_FullMethodName    = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListQaScorecardRevisions"
	ContactCenterInsights_CreateFeedbackLabel_FullMethodName         = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateFeedbackLabel"
	ContactCenterInsights_ListFeedbackLabels_FullMethodName          = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListFeedbackLabels"
	ContactCenterInsights_GetFeedbackLabel_FullMethodName            = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetFeedbackLabel"
	ContactCenterInsights_UpdateFeedbackLabel_FullMethodName         = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateFeedbackLabel"
	ContactCenterInsights_DeleteFeedbackLabel_FullMethodName         = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteFeedbackLabel"
	ContactCenterInsights_ListAllFeedbackLabels_FullMethodName       = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListAllFeedbackLabels"
	ContactCenterInsights_BulkUploadFeedbackLabels_FullMethodName    = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/BulkUploadFeedbackLabels"
	ContactCenterInsights_BulkDownloadFeedbackLabels_FullMethodName  = "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/BulkDownloadFeedbackLabels"
)

// ContactCenterInsightsClient is the client API for ContactCenterInsights service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ContactCenterInsightsClient interface {
	// Creates a conversation.
	// Note that this method does not support audio transcription or redaction.
	// Use `conversations.upload` instead.
	CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Create a long-running conversation upload operation. This method differs
	// from `CreateConversation` by allowing audio transcription and optional DLP
	// redaction.
	UploadConversation(ctx context.Context, in *UploadConversationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a conversation.
	UpdateConversation(ctx context.Context, in *UpdateConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Gets a conversation.
	GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Lists conversations.
	ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error)
	// Deletes a conversation.
	DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates an analysis. The long running operation is done when the analysis
	// has completed.
	CreateAnalysis(ctx context.Context, in *CreateAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an analysis.
	GetAnalysis(ctx context.Context, in *GetAnalysisRequest, opts ...grpc.CallOption) (*Analysis, error)
	// Lists analyses.
	ListAnalyses(ctx context.Context, in *ListAnalysesRequest, opts ...grpc.CallOption) (*ListAnalysesResponse, error)
	// Deletes an analysis.
	DeleteAnalysis(ctx context.Context, in *DeleteAnalysisRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Analyzes multiple conversations in a single request.
	BulkAnalyzeConversations(ctx context.Context, in *BulkAnalyzeConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes multiple conversations in a single request.
	BulkDeleteConversations(ctx context.Context, in *BulkDeleteConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports conversations and processes them according to the user's
	// configuration.
	IngestConversations(ctx context.Context, in *IngestConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Export insights data to a destination defined in the request body.
	ExportInsightsData(ctx context.Context, in *ExportInsightsDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates an issue model.
	CreateIssueModel(ctx context.Context, in *CreateIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an issue model.
	UpdateIssueModel(ctx context.Context, in *UpdateIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error)
	// Gets an issue model.
	GetIssueModel(ctx context.Context, in *GetIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error)
	// Lists issue models.
	ListIssueModels(ctx context.Context, in *ListIssueModelsRequest, opts ...grpc.CallOption) (*ListIssueModelsResponse, error)
	// Deletes an issue model.
	DeleteIssueModel(ctx context.Context, in *DeleteIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys an issue model. Returns an error if a model is already deployed.
	// An issue model can only be used in analysis after it has been deployed.
	DeployIssueModel(ctx context.Context, in *DeployIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys an issue model.
	// An issue model can not be used in analysis after it has been undeployed.
	UndeployIssueModel(ctx context.Context, in *UndeployIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports an issue model to the provided destination.
	ExportIssueModel(ctx context.Context, in *ExportIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports an issue model from a Cloud Storage bucket.
	ImportIssueModel(ctx context.Context, in *ImportIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an issue.
	GetIssue(ctx context.Context, in *GetIssueRequest, opts ...grpc.CallOption) (*Issue, error)
	// Lists issues.
	ListIssues(ctx context.Context, in *ListIssuesRequest, opts ...grpc.CallOption) (*ListIssuesResponse, error)
	// Updates an issue.
	UpdateIssue(ctx context.Context, in *UpdateIssueRequest, opts ...grpc.CallOption) (*Issue, error)
	// Deletes an issue.
	DeleteIssue(ctx context.Context, in *DeleteIssueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets an issue model's statistics.
	CalculateIssueModelStats(ctx context.Context, in *CalculateIssueModelStatsRequest, opts ...grpc.CallOption) (*CalculateIssueModelStatsResponse, error)
	// Creates a phrase matcher.
	CreatePhraseMatcher(ctx context.Context, in *CreatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error)
	// Gets a phrase matcher.
	GetPhraseMatcher(ctx context.Context, in *GetPhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error)
	// Lists phrase matchers.
	ListPhraseMatchers(ctx context.Context, in *ListPhraseMatchersRequest, opts ...grpc.CallOption) (*ListPhraseMatchersResponse, error)
	// Deletes a phrase matcher.
	DeletePhraseMatcher(ctx context.Context, in *DeletePhraseMatcherRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a phrase matcher.
	UpdatePhraseMatcher(ctx context.Context, in *UpdatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error)
	// Gets conversation statistics.
	CalculateStats(ctx context.Context, in *CalculateStatsRequest, opts ...grpc.CallOption) (*CalculateStatsResponse, error)
	// Gets project-level settings.
	GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Updates project-level settings.
	UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Creates a analysis rule.
	CreateAnalysisRule(ctx context.Context, in *CreateAnalysisRuleRequest, opts ...grpc.CallOption) (*AnalysisRule, error)
	// Get a analysis rule.
	GetAnalysisRule(ctx context.Context, in *GetAnalysisRuleRequest, opts ...grpc.CallOption) (*AnalysisRule, error)
	// Lists analysis rules.
	ListAnalysisRules(ctx context.Context, in *ListAnalysisRulesRequest, opts ...grpc.CallOption) (*ListAnalysisRulesResponse, error)
	// Updates a analysis rule.
	UpdateAnalysisRule(ctx context.Context, in *UpdateAnalysisRuleRequest, opts ...grpc.CallOption) (*AnalysisRule, error)
	// Deletes a analysis rule.
	DeleteAnalysisRule(ctx context.Context, in *DeleteAnalysisRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets location-level encryption key specification.
	GetEncryptionSpec(ctx context.Context, in *GetEncryptionSpecRequest, opts ...grpc.CallOption) (*EncryptionSpec, error)
	// Initializes a location-level encryption key specification. An error will
	// result if the location has resources already created before the
	// initialization. After the encryption specification is initialized at a
	// location, it is immutable and all newly created resources under the
	// location will be encrypted with the existing specification.
	InitializeEncryptionSpec(ctx context.Context, in *InitializeEncryptionSpecRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a view.
	CreateView(ctx context.Context, in *CreateViewRequest, opts ...grpc.CallOption) (*View, error)
	// Gets a view.
	GetView(ctx context.Context, in *GetViewRequest, opts ...grpc.CallOption) (*View, error)
	// Lists views.
	ListViews(ctx context.Context, in *ListViewsRequest, opts ...grpc.CallOption) (*ListViewsResponse, error)
	// Updates a view.
	UpdateView(ctx context.Context, in *UpdateViewRequest, opts ...grpc.CallOption) (*View, error)
	// Deletes a view.
	DeleteView(ctx context.Context, in *DeleteViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Query metrics.
	QueryMetrics(ctx context.Context, in *QueryMetricsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create a QaQuestion.
	CreateQaQuestion(ctx context.Context, in *CreateQaQuestionRequest, opts ...grpc.CallOption) (*QaQuestion, error)
	// Gets a QaQuestion.
	GetQaQuestion(ctx context.Context, in *GetQaQuestionRequest, opts ...grpc.CallOption) (*QaQuestion, error)
	// Updates a QaQuestion.
	UpdateQaQuestion(ctx context.Context, in *UpdateQaQuestionRequest, opts ...grpc.CallOption) (*QaQuestion, error)
	// Deletes a QaQuestion.
	DeleteQaQuestion(ctx context.Context, in *DeleteQaQuestionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists QaQuestions.
	ListQaQuestions(ctx context.Context, in *ListQaQuestionsRequest, opts ...grpc.CallOption) (*ListQaQuestionsResponse, error)
	// Create a QaScorecard.
	CreateQaScorecard(ctx context.Context, in *CreateQaScorecardRequest, opts ...grpc.CallOption) (*QaScorecard, error)
	// Gets a QaScorecard.
	GetQaScorecard(ctx context.Context, in *GetQaScorecardRequest, opts ...grpc.CallOption) (*QaScorecard, error)
	// Updates a QaScorecard.
	UpdateQaScorecard(ctx context.Context, in *UpdateQaScorecardRequest, opts ...grpc.CallOption) (*QaScorecard, error)
	// Deletes a QaScorecard.
	DeleteQaScorecard(ctx context.Context, in *DeleteQaScorecardRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists QaScorecards.
	ListQaScorecards(ctx context.Context, in *ListQaScorecardsRequest, opts ...grpc.CallOption) (*ListQaScorecardsResponse, error)
	// Creates a QaScorecardRevision.
	CreateQaScorecardRevision(ctx context.Context, in *CreateQaScorecardRevisionRequest, opts ...grpc.CallOption) (*QaScorecardRevision, error)
	// Gets a QaScorecardRevision.
	GetQaScorecardRevision(ctx context.Context, in *GetQaScorecardRevisionRequest, opts ...grpc.CallOption) (*QaScorecardRevision, error)
	// Fine tune one or more QaModels.
	TuneQaScorecardRevision(ctx context.Context, in *TuneQaScorecardRevisionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploy a QaScorecardRevision.
	DeployQaScorecardRevision(ctx context.Context, in *DeployQaScorecardRevisionRequest, opts ...grpc.CallOption) (*QaScorecardRevision, error)
	// Undeploy a QaScorecardRevision.
	UndeployQaScorecardRevision(ctx context.Context, in *UndeployQaScorecardRevisionRequest, opts ...grpc.CallOption) (*QaScorecardRevision, error)
	// Deletes a QaScorecardRevision.
	DeleteQaScorecardRevision(ctx context.Context, in *DeleteQaScorecardRevisionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all revisions under the parent QaScorecard.
	ListQaScorecardRevisions(ctx context.Context, in *ListQaScorecardRevisionsRequest, opts ...grpc.CallOption) (*ListQaScorecardRevisionsResponse, error)
	// Create feedback label.
	CreateFeedbackLabel(ctx context.Context, in *CreateFeedbackLabelRequest, opts ...grpc.CallOption) (*FeedbackLabel, error)
	// List feedback labels.
	ListFeedbackLabels(ctx context.Context, in *ListFeedbackLabelsRequest, opts ...grpc.CallOption) (*ListFeedbackLabelsResponse, error)
	// Get feedback label.
	GetFeedbackLabel(ctx context.Context, in *GetFeedbackLabelRequest, opts ...grpc.CallOption) (*FeedbackLabel, error)
	// Update feedback label.
	UpdateFeedbackLabel(ctx context.Context, in *UpdateFeedbackLabelRequest, opts ...grpc.CallOption) (*FeedbackLabel, error)
	// Delete feedback label.
	DeleteFeedbackLabel(ctx context.Context, in *DeleteFeedbackLabelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all feedback labels by project number.
	ListAllFeedbackLabels(ctx context.Context, in *ListAllFeedbackLabelsRequest, opts ...grpc.CallOption) (*ListAllFeedbackLabelsResponse, error)
	// Upload feedback labels in bulk.
	BulkUploadFeedbackLabels(ctx context.Context, in *BulkUploadFeedbackLabelsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Download feedback labels in bulk.
	BulkDownloadFeedbackLabels(ctx context.Context, in *BulkDownloadFeedbackLabelsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type contactCenterInsightsClient struct {
	cc grpc.ClientConnInterface
}

func NewContactCenterInsightsClient(cc grpc.ClientConnInterface) ContactCenterInsightsClient {
	return &contactCenterInsightsClient{cc}
}

func (c *contactCenterInsightsClient) CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UploadConversation(ctx context.Context, in *UploadConversationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UploadConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateConversation(ctx context.Context, in *UpdateConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error) {
	out := new(ListConversationsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListConversations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateAnalysis(ctx context.Context, in *CreateAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateAnalysis_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetAnalysis(ctx context.Context, in *GetAnalysisRequest, opts ...grpc.CallOption) (*Analysis, error) {
	out := new(Analysis)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetAnalysis_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListAnalyses(ctx context.Context, in *ListAnalysesRequest, opts ...grpc.CallOption) (*ListAnalysesResponse, error) {
	out := new(ListAnalysesResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListAnalyses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteAnalysis(ctx context.Context, in *DeleteAnalysisRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteAnalysis_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) BulkAnalyzeConversations(ctx context.Context, in *BulkAnalyzeConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_BulkAnalyzeConversations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) BulkDeleteConversations(ctx context.Context, in *BulkDeleteConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_BulkDeleteConversations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) IngestConversations(ctx context.Context, in *IngestConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_IngestConversations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ExportInsightsData(ctx context.Context, in *ExportInsightsDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ExportInsightsData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateIssueModel(ctx context.Context, in *CreateIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateIssueModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateIssueModel(ctx context.Context, in *UpdateIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error) {
	out := new(IssueModel)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateIssueModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetIssueModel(ctx context.Context, in *GetIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error) {
	out := new(IssueModel)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetIssueModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListIssueModels(ctx context.Context, in *ListIssueModelsRequest, opts ...grpc.CallOption) (*ListIssueModelsResponse, error) {
	out := new(ListIssueModelsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListIssueModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteIssueModel(ctx context.Context, in *DeleteIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteIssueModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeployIssueModel(ctx context.Context, in *DeployIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeployIssueModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UndeployIssueModel(ctx context.Context, in *UndeployIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UndeployIssueModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ExportIssueModel(ctx context.Context, in *ExportIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ExportIssueModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ImportIssueModel(ctx context.Context, in *ImportIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ImportIssueModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetIssue(ctx context.Context, in *GetIssueRequest, opts ...grpc.CallOption) (*Issue, error) {
	out := new(Issue)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetIssue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListIssues(ctx context.Context, in *ListIssuesRequest, opts ...grpc.CallOption) (*ListIssuesResponse, error) {
	out := new(ListIssuesResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListIssues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateIssue(ctx context.Context, in *UpdateIssueRequest, opts ...grpc.CallOption) (*Issue, error) {
	out := new(Issue)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateIssue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteIssue(ctx context.Context, in *DeleteIssueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteIssue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CalculateIssueModelStats(ctx context.Context, in *CalculateIssueModelStatsRequest, opts ...grpc.CallOption) (*CalculateIssueModelStatsResponse, error) {
	out := new(CalculateIssueModelStatsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CalculateIssueModelStats_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreatePhraseMatcher(ctx context.Context, in *CreatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error) {
	out := new(PhraseMatcher)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreatePhraseMatcher_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetPhraseMatcher(ctx context.Context, in *GetPhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error) {
	out := new(PhraseMatcher)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetPhraseMatcher_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListPhraseMatchers(ctx context.Context, in *ListPhraseMatchersRequest, opts ...grpc.CallOption) (*ListPhraseMatchersResponse, error) {
	out := new(ListPhraseMatchersResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListPhraseMatchers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeletePhraseMatcher(ctx context.Context, in *DeletePhraseMatcherRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeletePhraseMatcher_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdatePhraseMatcher(ctx context.Context, in *UpdatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error) {
	out := new(PhraseMatcher)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdatePhraseMatcher_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CalculateStats(ctx context.Context, in *CalculateStatsRequest, opts ...grpc.CallOption) (*CalculateStatsResponse, error) {
	out := new(CalculateStatsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CalculateStats_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateAnalysisRule(ctx context.Context, in *CreateAnalysisRuleRequest, opts ...grpc.CallOption) (*AnalysisRule, error) {
	out := new(AnalysisRule)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateAnalysisRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetAnalysisRule(ctx context.Context, in *GetAnalysisRuleRequest, opts ...grpc.CallOption) (*AnalysisRule, error) {
	out := new(AnalysisRule)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetAnalysisRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListAnalysisRules(ctx context.Context, in *ListAnalysisRulesRequest, opts ...grpc.CallOption) (*ListAnalysisRulesResponse, error) {
	out := new(ListAnalysisRulesResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListAnalysisRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateAnalysisRule(ctx context.Context, in *UpdateAnalysisRuleRequest, opts ...grpc.CallOption) (*AnalysisRule, error) {
	out := new(AnalysisRule)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateAnalysisRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteAnalysisRule(ctx context.Context, in *DeleteAnalysisRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteAnalysisRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetEncryptionSpec(ctx context.Context, in *GetEncryptionSpecRequest, opts ...grpc.CallOption) (*EncryptionSpec, error) {
	out := new(EncryptionSpec)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetEncryptionSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) InitializeEncryptionSpec(ctx context.Context, in *InitializeEncryptionSpecRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_InitializeEncryptionSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateView(ctx context.Context, in *CreateViewRequest, opts ...grpc.CallOption) (*View, error) {
	out := new(View)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetView(ctx context.Context, in *GetViewRequest, opts ...grpc.CallOption) (*View, error) {
	out := new(View)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListViews(ctx context.Context, in *ListViewsRequest, opts ...grpc.CallOption) (*ListViewsResponse, error) {
	out := new(ListViewsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListViews_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateView(ctx context.Context, in *UpdateViewRequest, opts ...grpc.CallOption) (*View, error) {
	out := new(View)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteView(ctx context.Context, in *DeleteViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) QueryMetrics(ctx context.Context, in *QueryMetricsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_QueryMetrics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateQaQuestion(ctx context.Context, in *CreateQaQuestionRequest, opts ...grpc.CallOption) (*QaQuestion, error) {
	out := new(QaQuestion)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateQaQuestion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetQaQuestion(ctx context.Context, in *GetQaQuestionRequest, opts ...grpc.CallOption) (*QaQuestion, error) {
	out := new(QaQuestion)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetQaQuestion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateQaQuestion(ctx context.Context, in *UpdateQaQuestionRequest, opts ...grpc.CallOption) (*QaQuestion, error) {
	out := new(QaQuestion)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateQaQuestion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteQaQuestion(ctx context.Context, in *DeleteQaQuestionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteQaQuestion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListQaQuestions(ctx context.Context, in *ListQaQuestionsRequest, opts ...grpc.CallOption) (*ListQaQuestionsResponse, error) {
	out := new(ListQaQuestionsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListQaQuestions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateQaScorecard(ctx context.Context, in *CreateQaScorecardRequest, opts ...grpc.CallOption) (*QaScorecard, error) {
	out := new(QaScorecard)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateQaScorecard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetQaScorecard(ctx context.Context, in *GetQaScorecardRequest, opts ...grpc.CallOption) (*QaScorecard, error) {
	out := new(QaScorecard)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetQaScorecard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateQaScorecard(ctx context.Context, in *UpdateQaScorecardRequest, opts ...grpc.CallOption) (*QaScorecard, error) {
	out := new(QaScorecard)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateQaScorecard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteQaScorecard(ctx context.Context, in *DeleteQaScorecardRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteQaScorecard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListQaScorecards(ctx context.Context, in *ListQaScorecardsRequest, opts ...grpc.CallOption) (*ListQaScorecardsResponse, error) {
	out := new(ListQaScorecardsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListQaScorecards_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateQaScorecardRevision(ctx context.Context, in *CreateQaScorecardRevisionRequest, opts ...grpc.CallOption) (*QaScorecardRevision, error) {
	out := new(QaScorecardRevision)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateQaScorecardRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetQaScorecardRevision(ctx context.Context, in *GetQaScorecardRevisionRequest, opts ...grpc.CallOption) (*QaScorecardRevision, error) {
	out := new(QaScorecardRevision)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetQaScorecardRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) TuneQaScorecardRevision(ctx context.Context, in *TuneQaScorecardRevisionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_TuneQaScorecardRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeployQaScorecardRevision(ctx context.Context, in *DeployQaScorecardRevisionRequest, opts ...grpc.CallOption) (*QaScorecardRevision, error) {
	out := new(QaScorecardRevision)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeployQaScorecardRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UndeployQaScorecardRevision(ctx context.Context, in *UndeployQaScorecardRevisionRequest, opts ...grpc.CallOption) (*QaScorecardRevision, error) {
	out := new(QaScorecardRevision)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UndeployQaScorecardRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteQaScorecardRevision(ctx context.Context, in *DeleteQaScorecardRevisionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteQaScorecardRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListQaScorecardRevisions(ctx context.Context, in *ListQaScorecardRevisionsRequest, opts ...grpc.CallOption) (*ListQaScorecardRevisionsResponse, error) {
	out := new(ListQaScorecardRevisionsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListQaScorecardRevisions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateFeedbackLabel(ctx context.Context, in *CreateFeedbackLabelRequest, opts ...grpc.CallOption) (*FeedbackLabel, error) {
	out := new(FeedbackLabel)
	err := c.cc.Invoke(ctx, ContactCenterInsights_CreateFeedbackLabel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListFeedbackLabels(ctx context.Context, in *ListFeedbackLabelsRequest, opts ...grpc.CallOption) (*ListFeedbackLabelsResponse, error) {
	out := new(ListFeedbackLabelsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListFeedbackLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetFeedbackLabel(ctx context.Context, in *GetFeedbackLabelRequest, opts ...grpc.CallOption) (*FeedbackLabel, error) {
	out := new(FeedbackLabel)
	err := c.cc.Invoke(ctx, ContactCenterInsights_GetFeedbackLabel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateFeedbackLabel(ctx context.Context, in *UpdateFeedbackLabelRequest, opts ...grpc.CallOption) (*FeedbackLabel, error) {
	out := new(FeedbackLabel)
	err := c.cc.Invoke(ctx, ContactCenterInsights_UpdateFeedbackLabel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteFeedbackLabel(ctx context.Context, in *DeleteFeedbackLabelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactCenterInsights_DeleteFeedbackLabel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListAllFeedbackLabels(ctx context.Context, in *ListAllFeedbackLabelsRequest, opts ...grpc.CallOption) (*ListAllFeedbackLabelsResponse, error) {
	out := new(ListAllFeedbackLabelsResponse)
	err := c.cc.Invoke(ctx, ContactCenterInsights_ListAllFeedbackLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) BulkUploadFeedbackLabels(ctx context.Context, in *BulkUploadFeedbackLabelsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_BulkUploadFeedbackLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) BulkDownloadFeedbackLabels(ctx context.Context, in *BulkDownloadFeedbackLabelsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ContactCenterInsights_BulkDownloadFeedbackLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContactCenterInsightsServer is the server API for ContactCenterInsights service.
// All implementations should embed UnimplementedContactCenterInsightsServer
// for forward compatibility
type ContactCenterInsightsServer interface {
	// Creates a conversation.
	// Note that this method does not support audio transcription or redaction.
	// Use `conversations.upload` instead.
	CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error)
	// Create a long-running conversation upload operation. This method differs
	// from `CreateConversation` by allowing audio transcription and optional DLP
	// redaction.
	UploadConversation(context.Context, *UploadConversationRequest) (*longrunningpb.Operation, error)
	// Updates a conversation.
	UpdateConversation(context.Context, *UpdateConversationRequest) (*Conversation, error)
	// Gets a conversation.
	GetConversation(context.Context, *GetConversationRequest) (*Conversation, error)
	// Lists conversations.
	ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error)
	// Deletes a conversation.
	DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error)
	// Creates an analysis. The long running operation is done when the analysis
	// has completed.
	CreateAnalysis(context.Context, *CreateAnalysisRequest) (*longrunningpb.Operation, error)
	// Gets an analysis.
	GetAnalysis(context.Context, *GetAnalysisRequest) (*Analysis, error)
	// Lists analyses.
	ListAnalyses(context.Context, *ListAnalysesRequest) (*ListAnalysesResponse, error)
	// Deletes an analysis.
	DeleteAnalysis(context.Context, *DeleteAnalysisRequest) (*emptypb.Empty, error)
	// Analyzes multiple conversations in a single request.
	BulkAnalyzeConversations(context.Context, *BulkAnalyzeConversationsRequest) (*longrunningpb.Operation, error)
	// Deletes multiple conversations in a single request.
	BulkDeleteConversations(context.Context, *BulkDeleteConversationsRequest) (*longrunningpb.Operation, error)
	// Imports conversations and processes them according to the user's
	// configuration.
	IngestConversations(context.Context, *IngestConversationsRequest) (*longrunningpb.Operation, error)
	// Export insights data to a destination defined in the request body.
	ExportInsightsData(context.Context, *ExportInsightsDataRequest) (*longrunningpb.Operation, error)
	// Creates an issue model.
	CreateIssueModel(context.Context, *CreateIssueModelRequest) (*longrunningpb.Operation, error)
	// Updates an issue model.
	UpdateIssueModel(context.Context, *UpdateIssueModelRequest) (*IssueModel, error)
	// Gets an issue model.
	GetIssueModel(context.Context, *GetIssueModelRequest) (*IssueModel, error)
	// Lists issue models.
	ListIssueModels(context.Context, *ListIssueModelsRequest) (*ListIssueModelsResponse, error)
	// Deletes an issue model.
	DeleteIssueModel(context.Context, *DeleteIssueModelRequest) (*longrunningpb.Operation, error)
	// Deploys an issue model. Returns an error if a model is already deployed.
	// An issue model can only be used in analysis after it has been deployed.
	DeployIssueModel(context.Context, *DeployIssueModelRequest) (*longrunningpb.Operation, error)
	// Undeploys an issue model.
	// An issue model can not be used in analysis after it has been undeployed.
	UndeployIssueModel(context.Context, *UndeployIssueModelRequest) (*longrunningpb.Operation, error)
	// Exports an issue model to the provided destination.
	ExportIssueModel(context.Context, *ExportIssueModelRequest) (*longrunningpb.Operation, error)
	// Imports an issue model from a Cloud Storage bucket.
	ImportIssueModel(context.Context, *ImportIssueModelRequest) (*longrunningpb.Operation, error)
	// Gets an issue.
	GetIssue(context.Context, *GetIssueRequest) (*Issue, error)
	// Lists issues.
	ListIssues(context.Context, *ListIssuesRequest) (*ListIssuesResponse, error)
	// Updates an issue.
	UpdateIssue(context.Context, *UpdateIssueRequest) (*Issue, error)
	// Deletes an issue.
	DeleteIssue(context.Context, *DeleteIssueRequest) (*emptypb.Empty, error)
	// Gets an issue model's statistics.
	CalculateIssueModelStats(context.Context, *CalculateIssueModelStatsRequest) (*CalculateIssueModelStatsResponse, error)
	// Creates a phrase matcher.
	CreatePhraseMatcher(context.Context, *CreatePhraseMatcherRequest) (*PhraseMatcher, error)
	// Gets a phrase matcher.
	GetPhraseMatcher(context.Context, *GetPhraseMatcherRequest) (*PhraseMatcher, error)
	// Lists phrase matchers.
	ListPhraseMatchers(context.Context, *ListPhraseMatchersRequest) (*ListPhraseMatchersResponse, error)
	// Deletes a phrase matcher.
	DeletePhraseMatcher(context.Context, *DeletePhraseMatcherRequest) (*emptypb.Empty, error)
	// Updates a phrase matcher.
	UpdatePhraseMatcher(context.Context, *UpdatePhraseMatcherRequest) (*PhraseMatcher, error)
	// Gets conversation statistics.
	CalculateStats(context.Context, *CalculateStatsRequest) (*CalculateStatsResponse, error)
	// Gets project-level settings.
	GetSettings(context.Context, *GetSettingsRequest) (*Settings, error)
	// Updates project-level settings.
	UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error)
	// Creates a analysis rule.
	CreateAnalysisRule(context.Context, *CreateAnalysisRuleRequest) (*AnalysisRule, error)
	// Get a analysis rule.
	GetAnalysisRule(context.Context, *GetAnalysisRuleRequest) (*AnalysisRule, error)
	// Lists analysis rules.
	ListAnalysisRules(context.Context, *ListAnalysisRulesRequest) (*ListAnalysisRulesResponse, error)
	// Updates a analysis rule.
	UpdateAnalysisRule(context.Context, *UpdateAnalysisRuleRequest) (*AnalysisRule, error)
	// Deletes a analysis rule.
	DeleteAnalysisRule(context.Context, *DeleteAnalysisRuleRequest) (*emptypb.Empty, error)
	// Gets location-level encryption key specification.
	GetEncryptionSpec(context.Context, *GetEncryptionSpecRequest) (*EncryptionSpec, error)
	// Initializes a location-level encryption key specification. An error will
	// result if the location has resources already created before the
	// initialization. After the encryption specification is initialized at a
	// location, it is immutable and all newly created resources under the
	// location will be encrypted with the existing specification.
	InitializeEncryptionSpec(context.Context, *InitializeEncryptionSpecRequest) (*longrunningpb.Operation, error)
	// Creates a view.
	CreateView(context.Context, *CreateViewRequest) (*View, error)
	// Gets a view.
	GetView(context.Context, *GetViewRequest) (*View, error)
	// Lists views.
	ListViews(context.Context, *ListViewsRequest) (*ListViewsResponse, error)
	// Updates a view.
	UpdateView(context.Context, *UpdateViewRequest) (*View, error)
	// Deletes a view.
	DeleteView(context.Context, *DeleteViewRequest) (*emptypb.Empty, error)
	// Query metrics.
	QueryMetrics(context.Context, *QueryMetricsRequest) (*longrunningpb.Operation, error)
	// Create a QaQuestion.
	CreateQaQuestion(context.Context, *CreateQaQuestionRequest) (*QaQuestion, error)
	// Gets a QaQuestion.
	GetQaQuestion(context.Context, *GetQaQuestionRequest) (*QaQuestion, error)
	// Updates a QaQuestion.
	UpdateQaQuestion(context.Context, *UpdateQaQuestionRequest) (*QaQuestion, error)
	// Deletes a QaQuestion.
	DeleteQaQuestion(context.Context, *DeleteQaQuestionRequest) (*emptypb.Empty, error)
	// Lists QaQuestions.
	ListQaQuestions(context.Context, *ListQaQuestionsRequest) (*ListQaQuestionsResponse, error)
	// Create a QaScorecard.
	CreateQaScorecard(context.Context, *CreateQaScorecardRequest) (*QaScorecard, error)
	// Gets a QaScorecard.
	GetQaScorecard(context.Context, *GetQaScorecardRequest) (*QaScorecard, error)
	// Updates a QaScorecard.
	UpdateQaScorecard(context.Context, *UpdateQaScorecardRequest) (*QaScorecard, error)
	// Deletes a QaScorecard.
	DeleteQaScorecard(context.Context, *DeleteQaScorecardRequest) (*emptypb.Empty, error)
	// Lists QaScorecards.
	ListQaScorecards(context.Context, *ListQaScorecardsRequest) (*ListQaScorecardsResponse, error)
	// Creates a QaScorecardRevision.
	CreateQaScorecardRevision(context.Context, *CreateQaScorecardRevisionRequest) (*QaScorecardRevision, error)
	// Gets a QaScorecardRevision.
	GetQaScorecardRevision(context.Context, *GetQaScorecardRevisionRequest) (*QaScorecardRevision, error)
	// Fine tune one or more QaModels.
	TuneQaScorecardRevision(context.Context, *TuneQaScorecardRevisionRequest) (*longrunningpb.Operation, error)
	// Deploy a QaScorecardRevision.
	DeployQaScorecardRevision(context.Context, *DeployQaScorecardRevisionRequest) (*QaScorecardRevision, error)
	// Undeploy a QaScorecardRevision.
	UndeployQaScorecardRevision(context.Context, *UndeployQaScorecardRevisionRequest) (*QaScorecardRevision, error)
	// Deletes a QaScorecardRevision.
	DeleteQaScorecardRevision(context.Context, *DeleteQaScorecardRevisionRequest) (*emptypb.Empty, error)
	// Lists all revisions under the parent QaScorecard.
	ListQaScorecardRevisions(context.Context, *ListQaScorecardRevisionsRequest) (*ListQaScorecardRevisionsResponse, error)
	// Create feedback label.
	CreateFeedbackLabel(context.Context, *CreateFeedbackLabelRequest) (*FeedbackLabel, error)
	// List feedback labels.
	ListFeedbackLabels(context.Context, *ListFeedbackLabelsRequest) (*ListFeedbackLabelsResponse, error)
	// Get feedback label.
	GetFeedbackLabel(context.Context, *GetFeedbackLabelRequest) (*FeedbackLabel, error)
	// Update feedback label.
	UpdateFeedbackLabel(context.Context, *UpdateFeedbackLabelRequest) (*FeedbackLabel, error)
	// Delete feedback label.
	DeleteFeedbackLabel(context.Context, *DeleteFeedbackLabelRequest) (*emptypb.Empty, error)
	// List all feedback labels by project number.
	ListAllFeedbackLabels(context.Context, *ListAllFeedbackLabelsRequest) (*ListAllFeedbackLabelsResponse, error)
	// Upload feedback labels in bulk.
	BulkUploadFeedbackLabels(context.Context, *BulkUploadFeedbackLabelsRequest) (*longrunningpb.Operation, error)
	// Download feedback labels in bulk.
	BulkDownloadFeedbackLabels(context.Context, *BulkDownloadFeedbackLabelsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedContactCenterInsightsServer should be embedded to have forward compatible implementations.
type UnimplementedContactCenterInsightsServer struct {
}

func (UnimplementedContactCenterInsightsServer) CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversation not implemented")
}
func (UnimplementedContactCenterInsightsServer) UploadConversation(context.Context, *UploadConversationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadConversation not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateConversation(context.Context, *UpdateConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversation not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetConversation(context.Context, *GetConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversation not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversations not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversation not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreateAnalysis(context.Context, *CreateAnalysisRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnalysis not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetAnalysis(context.Context, *GetAnalysisRequest) (*Analysis, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnalysis not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListAnalyses(context.Context, *ListAnalysesRequest) (*ListAnalysesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnalyses not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteAnalysis(context.Context, *DeleteAnalysisRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAnalysis not implemented")
}
func (UnimplementedContactCenterInsightsServer) BulkAnalyzeConversations(context.Context, *BulkAnalyzeConversationsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkAnalyzeConversations not implemented")
}
func (UnimplementedContactCenterInsightsServer) BulkDeleteConversations(context.Context, *BulkDeleteConversationsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkDeleteConversations not implemented")
}
func (UnimplementedContactCenterInsightsServer) IngestConversations(context.Context, *IngestConversationsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IngestConversations not implemented")
}
func (UnimplementedContactCenterInsightsServer) ExportInsightsData(context.Context, *ExportInsightsDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportInsightsData not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreateIssueModel(context.Context, *CreateIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIssueModel not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateIssueModel(context.Context, *UpdateIssueModelRequest) (*IssueModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIssueModel not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetIssueModel(context.Context, *GetIssueModelRequest) (*IssueModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIssueModel not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListIssueModels(context.Context, *ListIssueModelsRequest) (*ListIssueModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIssueModels not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteIssueModel(context.Context, *DeleteIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIssueModel not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeployIssueModel(context.Context, *DeployIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployIssueModel not implemented")
}
func (UnimplementedContactCenterInsightsServer) UndeployIssueModel(context.Context, *UndeployIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployIssueModel not implemented")
}
func (UnimplementedContactCenterInsightsServer) ExportIssueModel(context.Context, *ExportIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportIssueModel not implemented")
}
func (UnimplementedContactCenterInsightsServer) ImportIssueModel(context.Context, *ImportIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportIssueModel not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetIssue(context.Context, *GetIssueRequest) (*Issue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIssue not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListIssues(context.Context, *ListIssuesRequest) (*ListIssuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIssues not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateIssue(context.Context, *UpdateIssueRequest) (*Issue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIssue not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteIssue(context.Context, *DeleteIssueRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIssue not implemented")
}
func (UnimplementedContactCenterInsightsServer) CalculateIssueModelStats(context.Context, *CalculateIssueModelStatsRequest) (*CalculateIssueModelStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateIssueModelStats not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreatePhraseMatcher(context.Context, *CreatePhraseMatcherRequest) (*PhraseMatcher, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePhraseMatcher not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetPhraseMatcher(context.Context, *GetPhraseMatcherRequest) (*PhraseMatcher, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPhraseMatcher not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListPhraseMatchers(context.Context, *ListPhraseMatchersRequest) (*ListPhraseMatchersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPhraseMatchers not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeletePhraseMatcher(context.Context, *DeletePhraseMatcherRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePhraseMatcher not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdatePhraseMatcher(context.Context, *UpdatePhraseMatcherRequest) (*PhraseMatcher, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePhraseMatcher not implemented")
}
func (UnimplementedContactCenterInsightsServer) CalculateStats(context.Context, *CalculateStatsRequest) (*CalculateStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateStats not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetSettings(context.Context, *GetSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSettings not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSettings not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreateAnalysisRule(context.Context, *CreateAnalysisRuleRequest) (*AnalysisRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnalysisRule not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetAnalysisRule(context.Context, *GetAnalysisRuleRequest) (*AnalysisRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnalysisRule not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListAnalysisRules(context.Context, *ListAnalysisRulesRequest) (*ListAnalysisRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnalysisRules not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateAnalysisRule(context.Context, *UpdateAnalysisRuleRequest) (*AnalysisRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAnalysisRule not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteAnalysisRule(context.Context, *DeleteAnalysisRuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAnalysisRule not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetEncryptionSpec(context.Context, *GetEncryptionSpecRequest) (*EncryptionSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEncryptionSpec not implemented")
}
func (UnimplementedContactCenterInsightsServer) InitializeEncryptionSpec(context.Context, *InitializeEncryptionSpecRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InitializeEncryptionSpec not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreateView(context.Context, *CreateViewRequest) (*View, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateView not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetView(context.Context, *GetViewRequest) (*View, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetView not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListViews(context.Context, *ListViewsRequest) (*ListViewsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListViews not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateView(context.Context, *UpdateViewRequest) (*View, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateView not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteView(context.Context, *DeleteViewRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteView not implemented")
}
func (UnimplementedContactCenterInsightsServer) QueryMetrics(context.Context, *QueryMetricsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryMetrics not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreateQaQuestion(context.Context, *CreateQaQuestionRequest) (*QaQuestion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateQaQuestion not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetQaQuestion(context.Context, *GetQaQuestionRequest) (*QaQuestion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQaQuestion not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateQaQuestion(context.Context, *UpdateQaQuestionRequest) (*QaQuestion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateQaQuestion not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteQaQuestion(context.Context, *DeleteQaQuestionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteQaQuestion not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListQaQuestions(context.Context, *ListQaQuestionsRequest) (*ListQaQuestionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQaQuestions not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreateQaScorecard(context.Context, *CreateQaScorecardRequest) (*QaScorecard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateQaScorecard not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetQaScorecard(context.Context, *GetQaScorecardRequest) (*QaScorecard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQaScorecard not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateQaScorecard(context.Context, *UpdateQaScorecardRequest) (*QaScorecard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateQaScorecard not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteQaScorecard(context.Context, *DeleteQaScorecardRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteQaScorecard not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListQaScorecards(context.Context, *ListQaScorecardsRequest) (*ListQaScorecardsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQaScorecards not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreateQaScorecardRevision(context.Context, *CreateQaScorecardRevisionRequest) (*QaScorecardRevision, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateQaScorecardRevision not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetQaScorecardRevision(context.Context, *GetQaScorecardRevisionRequest) (*QaScorecardRevision, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQaScorecardRevision not implemented")
}
func (UnimplementedContactCenterInsightsServer) TuneQaScorecardRevision(context.Context, *TuneQaScorecardRevisionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TuneQaScorecardRevision not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeployQaScorecardRevision(context.Context, *DeployQaScorecardRevisionRequest) (*QaScorecardRevision, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployQaScorecardRevision not implemented")
}
func (UnimplementedContactCenterInsightsServer) UndeployQaScorecardRevision(context.Context, *UndeployQaScorecardRevisionRequest) (*QaScorecardRevision, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployQaScorecardRevision not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteQaScorecardRevision(context.Context, *DeleteQaScorecardRevisionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteQaScorecardRevision not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListQaScorecardRevisions(context.Context, *ListQaScorecardRevisionsRequest) (*ListQaScorecardRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQaScorecardRevisions not implemented")
}
func (UnimplementedContactCenterInsightsServer) CreateFeedbackLabel(context.Context, *CreateFeedbackLabelRequest) (*FeedbackLabel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeedbackLabel not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListFeedbackLabels(context.Context, *ListFeedbackLabelsRequest) (*ListFeedbackLabelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeedbackLabels not implemented")
}
func (UnimplementedContactCenterInsightsServer) GetFeedbackLabel(context.Context, *GetFeedbackLabelRequest) (*FeedbackLabel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeedbackLabel not implemented")
}
func (UnimplementedContactCenterInsightsServer) UpdateFeedbackLabel(context.Context, *UpdateFeedbackLabelRequest) (*FeedbackLabel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeedbackLabel not implemented")
}
func (UnimplementedContactCenterInsightsServer) DeleteFeedbackLabel(context.Context, *DeleteFeedbackLabelRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeedbackLabel not implemented")
}
func (UnimplementedContactCenterInsightsServer) ListAllFeedbackLabels(context.Context, *ListAllFeedbackLabelsRequest) (*ListAllFeedbackLabelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAllFeedbackLabels not implemented")
}
func (UnimplementedContactCenterInsightsServer) BulkUploadFeedbackLabels(context.Context, *BulkUploadFeedbackLabelsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkUploadFeedbackLabels not implemented")
}
func (UnimplementedContactCenterInsightsServer) BulkDownloadFeedbackLabels(context.Context, *BulkDownloadFeedbackLabelsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkDownloadFeedbackLabels not implemented")
}

// UnsafeContactCenterInsightsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ContactCenterInsightsServer will
// result in compilation errors.
type UnsafeContactCenterInsightsServer interface {
	mustEmbedUnimplementedContactCenterInsightsServer()
}

func RegisterContactCenterInsightsServer(s grpc.ServiceRegistrar, srv ContactCenterInsightsServer) {
	s.RegisterService(&ContactCenterInsights_ServiceDesc, srv)
}

func _ContactCenterInsights_CreateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateConversation(ctx, req.(*CreateConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UploadConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UploadConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UploadConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UploadConversation(ctx, req.(*UploadConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateConversation(ctx, req.(*UpdateConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetConversation(ctx, req.(*GetConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListConversations(ctx, req.(*ListConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteConversation(ctx, req.(*DeleteConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateAnalysis_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateAnalysis(ctx, req.(*CreateAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetAnalysis_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetAnalysis(ctx, req.(*GetAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListAnalyses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnalysesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListAnalyses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListAnalyses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListAnalyses(ctx, req.(*ListAnalysesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteAnalysis_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteAnalysis(ctx, req.(*DeleteAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_BulkAnalyzeConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkAnalyzeConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).BulkAnalyzeConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_BulkAnalyzeConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).BulkAnalyzeConversations(ctx, req.(*BulkAnalyzeConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_BulkDeleteConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkDeleteConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).BulkDeleteConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_BulkDeleteConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).BulkDeleteConversations(ctx, req.(*BulkDeleteConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_IngestConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).IngestConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_IngestConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).IngestConversations(ctx, req.(*IngestConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ExportInsightsData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportInsightsDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ExportInsightsData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ExportInsightsData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ExportInsightsData(ctx, req.(*ExportInsightsDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateIssueModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateIssueModel(ctx, req.(*CreateIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateIssueModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateIssueModel(ctx, req.(*UpdateIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetIssueModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetIssueModel(ctx, req.(*GetIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListIssueModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIssueModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListIssueModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListIssueModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListIssueModels(ctx, req.(*ListIssueModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteIssueModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteIssueModel(ctx, req.(*DeleteIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeployIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeployIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeployIssueModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeployIssueModel(ctx, req.(*DeployIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UndeployIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UndeployIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UndeployIssueModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UndeployIssueModel(ctx, req.(*UndeployIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ExportIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ExportIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ExportIssueModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ExportIssueModel(ctx, req.(*ExportIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ImportIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ImportIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ImportIssueModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ImportIssueModel(ctx, req.(*ImportIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetIssue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIssueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetIssue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetIssue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetIssue(ctx, req.(*GetIssueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListIssues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIssuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListIssues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListIssues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListIssues(ctx, req.(*ListIssuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateIssue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIssueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateIssue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateIssue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateIssue(ctx, req.(*UpdateIssueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteIssue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIssueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteIssue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteIssue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteIssue(ctx, req.(*DeleteIssueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CalculateIssueModelStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateIssueModelStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CalculateIssueModelStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CalculateIssueModelStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CalculateIssueModelStats(ctx, req.(*CalculateIssueModelStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreatePhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreatePhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreatePhraseMatcher_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreatePhraseMatcher(ctx, req.(*CreatePhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetPhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetPhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetPhraseMatcher_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetPhraseMatcher(ctx, req.(*GetPhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListPhraseMatchers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPhraseMatchersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListPhraseMatchers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListPhraseMatchers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListPhraseMatchers(ctx, req.(*ListPhraseMatchersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeletePhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeletePhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeletePhraseMatcher_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeletePhraseMatcher(ctx, req.(*DeletePhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdatePhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdatePhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdatePhraseMatcher_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdatePhraseMatcher(ctx, req.(*UpdatePhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CalculateStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CalculateStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CalculateStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CalculateStats(ctx, req.(*CalculateStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetSettings(ctx, req.(*GetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateSettings(ctx, req.(*UpdateSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateAnalysisRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnalysisRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateAnalysisRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateAnalysisRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateAnalysisRule(ctx, req.(*CreateAnalysisRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetAnalysisRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnalysisRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetAnalysisRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetAnalysisRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetAnalysisRule(ctx, req.(*GetAnalysisRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListAnalysisRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnalysisRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListAnalysisRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListAnalysisRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListAnalysisRules(ctx, req.(*ListAnalysisRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateAnalysisRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnalysisRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateAnalysisRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateAnalysisRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateAnalysisRule(ctx, req.(*UpdateAnalysisRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteAnalysisRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnalysisRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteAnalysisRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteAnalysisRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteAnalysisRule(ctx, req.(*DeleteAnalysisRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetEncryptionSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEncryptionSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetEncryptionSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetEncryptionSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetEncryptionSpec(ctx, req.(*GetEncryptionSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_InitializeEncryptionSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitializeEncryptionSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).InitializeEncryptionSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_InitializeEncryptionSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).InitializeEncryptionSpec(ctx, req.(*InitializeEncryptionSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateView(ctx, req.(*CreateViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetView(ctx, req.(*GetViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListViews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListViewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListViews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListViews_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListViews(ctx, req.(*ListViewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateView(ctx, req.(*UpdateViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteView(ctx, req.(*DeleteViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_QueryMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).QueryMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_QueryMetrics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).QueryMetrics(ctx, req.(*QueryMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateQaQuestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQaQuestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateQaQuestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateQaQuestion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateQaQuestion(ctx, req.(*CreateQaQuestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetQaQuestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQaQuestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetQaQuestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetQaQuestion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetQaQuestion(ctx, req.(*GetQaQuestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateQaQuestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateQaQuestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateQaQuestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateQaQuestion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateQaQuestion(ctx, req.(*UpdateQaQuestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteQaQuestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteQaQuestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteQaQuestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteQaQuestion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteQaQuestion(ctx, req.(*DeleteQaQuestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListQaQuestions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQaQuestionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListQaQuestions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListQaQuestions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListQaQuestions(ctx, req.(*ListQaQuestionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateQaScorecard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQaScorecardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateQaScorecard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateQaScorecard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateQaScorecard(ctx, req.(*CreateQaScorecardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetQaScorecard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQaScorecardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetQaScorecard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetQaScorecard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetQaScorecard(ctx, req.(*GetQaScorecardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateQaScorecard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateQaScorecardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateQaScorecard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateQaScorecard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateQaScorecard(ctx, req.(*UpdateQaScorecardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteQaScorecard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteQaScorecardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteQaScorecard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteQaScorecard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteQaScorecard(ctx, req.(*DeleteQaScorecardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListQaScorecards_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQaScorecardsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListQaScorecards(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListQaScorecards_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListQaScorecards(ctx, req.(*ListQaScorecardsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateQaScorecardRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQaScorecardRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateQaScorecardRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateQaScorecardRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateQaScorecardRevision(ctx, req.(*CreateQaScorecardRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetQaScorecardRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQaScorecardRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetQaScorecardRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetQaScorecardRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetQaScorecardRevision(ctx, req.(*GetQaScorecardRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_TuneQaScorecardRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TuneQaScorecardRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).TuneQaScorecardRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_TuneQaScorecardRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).TuneQaScorecardRevision(ctx, req.(*TuneQaScorecardRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeployQaScorecardRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployQaScorecardRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeployQaScorecardRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeployQaScorecardRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeployQaScorecardRevision(ctx, req.(*DeployQaScorecardRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UndeployQaScorecardRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployQaScorecardRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UndeployQaScorecardRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UndeployQaScorecardRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UndeployQaScorecardRevision(ctx, req.(*UndeployQaScorecardRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteQaScorecardRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteQaScorecardRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteQaScorecardRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteQaScorecardRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteQaScorecardRevision(ctx, req.(*DeleteQaScorecardRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListQaScorecardRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQaScorecardRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListQaScorecardRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListQaScorecardRevisions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListQaScorecardRevisions(ctx, req.(*ListQaScorecardRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateFeedbackLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeedbackLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateFeedbackLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_CreateFeedbackLabel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateFeedbackLabel(ctx, req.(*CreateFeedbackLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListFeedbackLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeedbackLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListFeedbackLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListFeedbackLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListFeedbackLabels(ctx, req.(*ListFeedbackLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetFeedbackLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedbackLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetFeedbackLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_GetFeedbackLabel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetFeedbackLabel(ctx, req.(*GetFeedbackLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateFeedbackLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeedbackLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateFeedbackLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_UpdateFeedbackLabel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateFeedbackLabel(ctx, req.(*UpdateFeedbackLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteFeedbackLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeedbackLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteFeedbackLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_DeleteFeedbackLabel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteFeedbackLabel(ctx, req.(*DeleteFeedbackLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListAllFeedbackLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAllFeedbackLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListAllFeedbackLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_ListAllFeedbackLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListAllFeedbackLabels(ctx, req.(*ListAllFeedbackLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_BulkUploadFeedbackLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkUploadFeedbackLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).BulkUploadFeedbackLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_BulkUploadFeedbackLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).BulkUploadFeedbackLabels(ctx, req.(*BulkUploadFeedbackLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_BulkDownloadFeedbackLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkDownloadFeedbackLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).BulkDownloadFeedbackLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactCenterInsights_BulkDownloadFeedbackLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).BulkDownloadFeedbackLabels(ctx, req.(*BulkDownloadFeedbackLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ContactCenterInsights_ServiceDesc is the grpc.ServiceDesc for ContactCenterInsights service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ContactCenterInsights_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
	HandlerType: (*ContactCenterInsightsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversation",
			Handler:    _ContactCenterInsights_CreateConversation_Handler,
		},
		{
			MethodName: "UploadConversation",
			Handler:    _ContactCenterInsights_UploadConversation_Handler,
		},
		{
			MethodName: "UpdateConversation",
			Handler:    _ContactCenterInsights_UpdateConversation_Handler,
		},
		{
			MethodName: "GetConversation",
			Handler:    _ContactCenterInsights_GetConversation_Handler,
		},
		{
			MethodName: "ListConversations",
			Handler:    _ContactCenterInsights_ListConversations_Handler,
		},
		{
			MethodName: "DeleteConversation",
			Handler:    _ContactCenterInsights_DeleteConversation_Handler,
		},
		{
			MethodName: "CreateAnalysis",
			Handler:    _ContactCenterInsights_CreateAnalysis_Handler,
		},
		{
			MethodName: "GetAnalysis",
			Handler:    _ContactCenterInsights_GetAnalysis_Handler,
		},
		{
			MethodName: "ListAnalyses",
			Handler:    _ContactCenterInsights_ListAnalyses_Handler,
		},
		{
			MethodName: "DeleteAnalysis",
			Handler:    _ContactCenterInsights_DeleteAnalysis_Handler,
		},
		{
			MethodName: "BulkAnalyzeConversations",
			Handler:    _ContactCenterInsights_BulkAnalyzeConversations_Handler,
		},
		{
			MethodName: "BulkDeleteConversations",
			Handler:    _ContactCenterInsights_BulkDeleteConversations_Handler,
		},
		{
			MethodName: "IngestConversations",
			Handler:    _ContactCenterInsights_IngestConversations_Handler,
		},
		{
			MethodName: "ExportInsightsData",
			Handler:    _ContactCenterInsights_ExportInsightsData_Handler,
		},
		{
			MethodName: "CreateIssueModel",
			Handler:    _ContactCenterInsights_CreateIssueModel_Handler,
		},
		{
			MethodName: "UpdateIssueModel",
			Handler:    _ContactCenterInsights_UpdateIssueModel_Handler,
		},
		{
			MethodName: "GetIssueModel",
			Handler:    _ContactCenterInsights_GetIssueModel_Handler,
		},
		{
			MethodName: "ListIssueModels",
			Handler:    _ContactCenterInsights_ListIssueModels_Handler,
		},
		{
			MethodName: "DeleteIssueModel",
			Handler:    _ContactCenterInsights_DeleteIssueModel_Handler,
		},
		{
			MethodName: "DeployIssueModel",
			Handler:    _ContactCenterInsights_DeployIssueModel_Handler,
		},
		{
			MethodName: "UndeployIssueModel",
			Handler:    _ContactCenterInsights_UndeployIssueModel_Handler,
		},
		{
			MethodName: "ExportIssueModel",
			Handler:    _ContactCenterInsights_ExportIssueModel_Handler,
		},
		{
			MethodName: "ImportIssueModel",
			Handler:    _ContactCenterInsights_ImportIssueModel_Handler,
		},
		{
			MethodName: "GetIssue",
			Handler:    _ContactCenterInsights_GetIssue_Handler,
		},
		{
			MethodName: "ListIssues",
			Handler:    _ContactCenterInsights_ListIssues_Handler,
		},
		{
			MethodName: "UpdateIssue",
			Handler:    _ContactCenterInsights_UpdateIssue_Handler,
		},
		{
			MethodName: "DeleteIssue",
			Handler:    _ContactCenterInsights_DeleteIssue_Handler,
		},
		{
			MethodName: "CalculateIssueModelStats",
			Handler:    _ContactCenterInsights_CalculateIssueModelStats_Handler,
		},
		{
			MethodName: "CreatePhraseMatcher",
			Handler:    _ContactCenterInsights_CreatePhraseMatcher_Handler,
		},
		{
			MethodName: "GetPhraseMatcher",
			Handler:    _ContactCenterInsights_GetPhraseMatcher_Handler,
		},
		{
			MethodName: "ListPhraseMatchers",
			Handler:    _ContactCenterInsights_ListPhraseMatchers_Handler,
		},
		{
			MethodName: "DeletePhraseMatcher",
			Handler:    _ContactCenterInsights_DeletePhraseMatcher_Handler,
		},
		{
			MethodName: "UpdatePhraseMatcher",
			Handler:    _ContactCenterInsights_UpdatePhraseMatcher_Handler,
		},
		{
			MethodName: "CalculateStats",
			Handler:    _ContactCenterInsights_CalculateStats_Handler,
		},
		{
			MethodName: "GetSettings",
			Handler:    _ContactCenterInsights_GetSettings_Handler,
		},
		{
			MethodName: "UpdateSettings",
			Handler:    _ContactCenterInsights_UpdateSettings_Handler,
		},
		{
			MethodName: "CreateAnalysisRule",
			Handler:    _ContactCenterInsights_CreateAnalysisRule_Handler,
		},
		{
			MethodName: "GetAnalysisRule",
			Handler:    _ContactCenterInsights_GetAnalysisRule_Handler,
		},
		{
			MethodName: "ListAnalysisRules",
			Handler:    _ContactCenterInsights_ListAnalysisRules_Handler,
		},
		{
			MethodName: "UpdateAnalysisRule",
			Handler:    _ContactCenterInsights_UpdateAnalysisRule_Handler,
		},
		{
			MethodName: "DeleteAnalysisRule",
			Handler:    _ContactCenterInsights_DeleteAnalysisRule_Handler,
		},
		{
			MethodName: "GetEncryptionSpec",
			Handler:    _ContactCenterInsights_GetEncryptionSpec_Handler,
		},
		{
			MethodName: "InitializeEncryptionSpec",
			Handler:    _ContactCenterInsights_InitializeEncryptionSpec_Handler,
		},
		{
			MethodName: "CreateView",
			Handler:    _ContactCenterInsights_CreateView_Handler,
		},
		{
			MethodName: "GetView",
			Handler:    _ContactCenterInsights_GetView_Handler,
		},
		{
			MethodName: "ListViews",
			Handler:    _ContactCenterInsights_ListViews_Handler,
		},
		{
			MethodName: "UpdateView",
			Handler:    _ContactCenterInsights_UpdateView_Handler,
		},
		{
			MethodName: "DeleteView",
			Handler:    _ContactCenterInsights_DeleteView_Handler,
		},
		{
			MethodName: "QueryMetrics",
			Handler:    _ContactCenterInsights_QueryMetrics_Handler,
		},
		{
			MethodName: "CreateQaQuestion",
			Handler:    _ContactCenterInsights_CreateQaQuestion_Handler,
		},
		{
			MethodName: "GetQaQuestion",
			Handler:    _ContactCenterInsights_GetQaQuestion_Handler,
		},
		{
			MethodName: "UpdateQaQuestion",
			Handler:    _ContactCenterInsights_UpdateQaQuestion_Handler,
		},
		{
			MethodName: "DeleteQaQuestion",
			Handler:    _ContactCenterInsights_DeleteQaQuestion_Handler,
		},
		{
			MethodName: "ListQaQuestions",
			Handler:    _ContactCenterInsights_ListQaQuestions_Handler,
		},
		{
			MethodName: "CreateQaScorecard",
			Handler:    _ContactCenterInsights_CreateQaScorecard_Handler,
		},
		{
			MethodName: "GetQaScorecard",
			Handler:    _ContactCenterInsights_GetQaScorecard_Handler,
		},
		{
			MethodName: "UpdateQaScorecard",
			Handler:    _ContactCenterInsights_UpdateQaScorecard_Handler,
		},
		{
			MethodName: "DeleteQaScorecard",
			Handler:    _ContactCenterInsights_DeleteQaScorecard_Handler,
		},
		{
			MethodName: "ListQaScorecards",
			Handler:    _ContactCenterInsights_ListQaScorecards_Handler,
		},
		{
			MethodName: "CreateQaScorecardRevision",
			Handler:    _ContactCenterInsights_CreateQaScorecardRevision_Handler,
		},
		{
			MethodName: "GetQaScorecardRevision",
			Handler:    _ContactCenterInsights_GetQaScorecardRevision_Handler,
		},
		{
			MethodName: "TuneQaScorecardRevision",
			Handler:    _ContactCenterInsights_TuneQaScorecardRevision_Handler,
		},
		{
			MethodName: "DeployQaScorecardRevision",
			Handler:    _ContactCenterInsights_DeployQaScorecardRevision_Handler,
		},
		{
			MethodName: "UndeployQaScorecardRevision",
			Handler:    _ContactCenterInsights_UndeployQaScorecardRevision_Handler,
		},
		{
			MethodName: "DeleteQaScorecardRevision",
			Handler:    _ContactCenterInsights_DeleteQaScorecardRevision_Handler,
		},
		{
			MethodName: "ListQaScorecardRevisions",
			Handler:    _ContactCenterInsights_ListQaScorecardRevisions_Handler,
		},
		{
			MethodName: "CreateFeedbackLabel",
			Handler:    _ContactCenterInsights_CreateFeedbackLabel_Handler,
		},
		{
			MethodName: "ListFeedbackLabels",
			Handler:    _ContactCenterInsights_ListFeedbackLabels_Handler,
		},
		{
			MethodName: "GetFeedbackLabel",
			Handler:    _ContactCenterInsights_GetFeedbackLabel_Handler,
		},
		{
			MethodName: "UpdateFeedbackLabel",
			Handler:    _ContactCenterInsights_UpdateFeedbackLabel_Handler,
		},
		{
			MethodName: "DeleteFeedbackLabel",
			Handler:    _ContactCenterInsights_DeleteFeedbackLabel_Handler,
		},
		{
			MethodName: "ListAllFeedbackLabels",
			Handler:    _ContactCenterInsights_ListAllFeedbackLabels_Handler,
		},
		{
			MethodName: "BulkUploadFeedbackLabels",
			Handler:    _ContactCenterInsights_BulkUploadFeedbackLabels_Handler,
		},
		{
			MethodName: "BulkDownloadFeedbackLabels",
			Handler:    _ContactCenterInsights_BulkDownloadFeedbackLabels_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/contactcenterinsights/v1/contact_center_insights.proto",
}
