// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/resourcemanager/v3/tag_values.proto

package resourcemanagerpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TagValues_ListTagValues_FullMethodName         = "/google.cloud.resourcemanager.v3.TagValues/ListTagValues"
	TagValues_GetTagValue_FullMethodName           = "/google.cloud.resourcemanager.v3.TagValues/GetTagValue"
	TagValues_GetNamespacedTagValue_FullMethodName = "/google.cloud.resourcemanager.v3.TagValues/GetNamespacedTagValue"
	TagValues_CreateTagValue_FullMethodName        = "/google.cloud.resourcemanager.v3.TagValues/CreateTagValue"
	TagValues_UpdateTagValue_FullMethodName        = "/google.cloud.resourcemanager.v3.TagValues/UpdateTagValue"
	TagValues_DeleteTagValue_FullMethodName        = "/google.cloud.resourcemanager.v3.TagValues/DeleteTagValue"
	TagValues_GetIamPolicy_FullMethodName          = "/google.cloud.resourcemanager.v3.TagValues/GetIamPolicy"
	TagValues_SetIamPolicy_FullMethodName          = "/google.cloud.resourcemanager.v3.TagValues/SetIamPolicy"
	TagValues_TestIamPermissions_FullMethodName    = "/google.cloud.resourcemanager.v3.TagValues/TestIamPermissions"
)

// TagValuesClient is the client API for TagValues service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TagValuesClient interface {
	// Lists all TagValues for a specific TagKey.
	ListTagValues(ctx context.Context, in *ListTagValuesRequest, opts ...grpc.CallOption) (*ListTagValuesResponse, error)
	// Retrieves a TagValue. This method will return `PERMISSION_DENIED` if the
	// value does not exist or the user does not have permission to view it.
	GetTagValue(ctx context.Context, in *GetTagValueRequest, opts ...grpc.CallOption) (*TagValue, error)
	// Retrieves a TagValue by its namespaced name.
	// This method will return `PERMISSION_DENIED` if the value does not exist
	// or the user does not have permission to view it.
	GetNamespacedTagValue(ctx context.Context, in *GetNamespacedTagValueRequest, opts ...grpc.CallOption) (*TagValue, error)
	// Creates a TagValue as a child of the specified TagKey. If a another
	// request with the same parameters is sent while the original request is in
	// process the second request will receive an error. A maximum of 1000
	// TagValues can exist under a TagKey at any given time.
	CreateTagValue(ctx context.Context, in *CreateTagValueRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the attributes of the TagValue resource.
	UpdateTagValue(ctx context.Context, in *UpdateTagValueRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a TagValue. The TagValue cannot have any bindings when it is
	// deleted.
	DeleteTagValue(ctx context.Context, in *DeleteTagValueRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the access control policy for a TagValue. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the TagValue's resource name. For example: `tagValues/1234`.
	// The caller must have the
	// `cloudresourcemanager.googleapis.com/tagValues.getIamPolicy` permission on
	// the identified TagValue to get the access control policy.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy on a TagValue, replacing any existing
	// policy. The `resource` field should be the TagValue's resource name.
	// For example: `tagValues/1234`.
	// The caller must have `resourcemanager.tagValues.setIamPolicy` permission
	// on the identified tagValue.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified TagValue.
	// The `resource` field should be the TagValue's resource name. For example:
	// `tagValues/1234`.
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type tagValuesClient struct {
	cc grpc.ClientConnInterface
}

func NewTagValuesClient(cc grpc.ClientConnInterface) TagValuesClient {
	return &tagValuesClient{cc}
}

func (c *tagValuesClient) ListTagValues(ctx context.Context, in *ListTagValuesRequest, opts ...grpc.CallOption) (*ListTagValuesResponse, error) {
	out := new(ListTagValuesResponse)
	err := c.cc.Invoke(ctx, TagValues_ListTagValues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagValuesClient) GetTagValue(ctx context.Context, in *GetTagValueRequest, opts ...grpc.CallOption) (*TagValue, error) {
	out := new(TagValue)
	err := c.cc.Invoke(ctx, TagValues_GetTagValue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagValuesClient) GetNamespacedTagValue(ctx context.Context, in *GetNamespacedTagValueRequest, opts ...grpc.CallOption) (*TagValue, error) {
	out := new(TagValue)
	err := c.cc.Invoke(ctx, TagValues_GetNamespacedTagValue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagValuesClient) CreateTagValue(ctx context.Context, in *CreateTagValueRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TagValues_CreateTagValue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagValuesClient) UpdateTagValue(ctx context.Context, in *UpdateTagValueRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TagValues_UpdateTagValue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagValuesClient) DeleteTagValue(ctx context.Context, in *DeleteTagValueRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TagValues_DeleteTagValue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagValuesClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, TagValues_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagValuesClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, TagValues_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagValuesClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, TagValues_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TagValuesServer is the server API for TagValues service.
// All implementations should embed UnimplementedTagValuesServer
// for forward compatibility
type TagValuesServer interface {
	// Lists all TagValues for a specific TagKey.
	ListTagValues(context.Context, *ListTagValuesRequest) (*ListTagValuesResponse, error)
	// Retrieves a TagValue. This method will return `PERMISSION_DENIED` if the
	// value does not exist or the user does not have permission to view it.
	GetTagValue(context.Context, *GetTagValueRequest) (*TagValue, error)
	// Retrieves a TagValue by its namespaced name.
	// This method will return `PERMISSION_DENIED` if the value does not exist
	// or the user does not have permission to view it.
	GetNamespacedTagValue(context.Context, *GetNamespacedTagValueRequest) (*TagValue, error)
	// Creates a TagValue as a child of the specified TagKey. If a another
	// request with the same parameters is sent while the original request is in
	// process the second request will receive an error. A maximum of 1000
	// TagValues can exist under a TagKey at any given time.
	CreateTagValue(context.Context, *CreateTagValueRequest) (*longrunningpb.Operation, error)
	// Updates the attributes of the TagValue resource.
	UpdateTagValue(context.Context, *UpdateTagValueRequest) (*longrunningpb.Operation, error)
	// Deletes a TagValue. The TagValue cannot have any bindings when it is
	// deleted.
	DeleteTagValue(context.Context, *DeleteTagValueRequest) (*longrunningpb.Operation, error)
	// Gets the access control policy for a TagValue. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the TagValue's resource name. For example: `tagValues/1234`.
	// The caller must have the
	// `cloudresourcemanager.googleapis.com/tagValues.getIamPolicy` permission on
	// the identified TagValue to get the access control policy.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy on a TagValue, replacing any existing
	// policy. The `resource` field should be the TagValue's resource name.
	// For example: `tagValues/1234`.
	// The caller must have `resourcemanager.tagValues.setIamPolicy` permission
	// on the identified tagValue.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified TagValue.
	// The `resource` field should be the TagValue's resource name. For example:
	// `tagValues/1234`.
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedTagValuesServer should be embedded to have forward compatible implementations.
type UnimplementedTagValuesServer struct {
}

func (UnimplementedTagValuesServer) ListTagValues(context.Context, *ListTagValuesRequest) (*ListTagValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTagValues not implemented")
}
func (UnimplementedTagValuesServer) GetTagValue(context.Context, *GetTagValueRequest) (*TagValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTagValue not implemented")
}
func (UnimplementedTagValuesServer) GetNamespacedTagValue(context.Context, *GetNamespacedTagValueRequest) (*TagValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNamespacedTagValue not implemented")
}
func (UnimplementedTagValuesServer) CreateTagValue(context.Context, *CreateTagValueRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagValue not implemented")
}
func (UnimplementedTagValuesServer) UpdateTagValue(context.Context, *UpdateTagValueRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagValue not implemented")
}
func (UnimplementedTagValuesServer) DeleteTagValue(context.Context, *DeleteTagValueRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagValue not implemented")
}
func (UnimplementedTagValuesServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedTagValuesServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedTagValuesServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeTagValuesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TagValuesServer will
// result in compilation errors.
type UnsafeTagValuesServer interface {
	mustEmbedUnimplementedTagValuesServer()
}

func RegisterTagValuesServer(s grpc.ServiceRegistrar, srv TagValuesServer) {
	s.RegisterService(&TagValues_ServiceDesc, srv)
}

func _TagValues_ListTagValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).ListTagValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_ListTagValues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).ListTagValues(ctx, req.(*ListTagValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagValues_GetTagValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).GetTagValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_GetTagValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).GetTagValue(ctx, req.(*GetTagValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagValues_GetNamespacedTagValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNamespacedTagValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).GetNamespacedTagValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_GetNamespacedTagValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).GetNamespacedTagValue(ctx, req.(*GetNamespacedTagValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagValues_CreateTagValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).CreateTagValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_CreateTagValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).CreateTagValue(ctx, req.(*CreateTagValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagValues_UpdateTagValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).UpdateTagValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_UpdateTagValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).UpdateTagValue(ctx, req.(*UpdateTagValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagValues_DeleteTagValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).DeleteTagValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_DeleteTagValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).DeleteTagValue(ctx, req.(*DeleteTagValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagValues_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagValues_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagValues_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagValuesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagValues_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagValuesServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TagValues_ServiceDesc is the grpc.ServiceDesc for TagValues service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TagValues_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v3.TagValues",
	HandlerType: (*TagValuesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTagValues",
			Handler:    _TagValues_ListTagValues_Handler,
		},
		{
			MethodName: "GetTagValue",
			Handler:    _TagValues_GetTagValue_Handler,
		},
		{
			MethodName: "GetNamespacedTagValue",
			Handler:    _TagValues_GetNamespacedTagValue_Handler,
		},
		{
			MethodName: "CreateTagValue",
			Handler:    _TagValues_CreateTagValue_Handler,
		},
		{
			MethodName: "UpdateTagValue",
			Handler:    _TagValues_UpdateTagValue_Handler,
		},
		{
			MethodName: "DeleteTagValue",
			Handler:    _TagValues_DeleteTagValue_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _TagValues_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _TagValues_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _TagValues_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v3/tag_values.proto",
}
