// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more IPAM policies.
//
// An IPAM policy is a set of rules that define how public IPv4 addresses from
// IPAM pools are allocated to Amazon Web Services resources. Each rule maps an
// Amazon Web Services service to IPAM pools that the service will use to get IP
// addresses. A single policy can have multiple rules and be applied to multiple
// Amazon Web Services Regions. If the IPAM pool run out of addresses then the
// services fallback to Amazon-provided IP addresses. A policy can be applied to an
// individual Amazon Web Services account or an entity within Amazon Web Services
// Organizations.
func (c *Client) DescribeIpamPolicies(ctx context.Context, params *DescribeIpamPoliciesInput, optFns ...func(*Options)) (*DescribeIpamPoliciesOutput, error) {
	if params == nil {
		params = &DescribeIpamPoliciesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeIpamPolicies", params, optFns, c.addOperationDescribeIpamPoliciesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeIpamPoliciesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeIpamPoliciesInput struct {

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// One or more filters for the IPAM policy description.
	Filters []types.Filter

	// The IDs of the IPAM policies to describe.
	IpamPolicyIds []string

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeIpamPoliciesOutput struct {

	// Information about the IPAM policies.
	//
	// An IPAM policy is a set of rules that define how public IPv4 addresses from
	// IPAM pools are allocated to Amazon Web Services resources. Each rule maps an
	// Amazon Web Services service to IPAM pools that the service will use to get IP
	// addresses. A single policy can have multiple rules and be applied to multiple
	// Amazon Web Services Regions. If the IPAM pool run out of addresses then the
	// services fallback to Amazon-provided IP addresses. A policy can be applied to an
	// individual Amazon Web Services account or an entity within Amazon Web Services
	// Organizations.
	IpamPolicies []types.IpamPolicy

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeIpamPoliciesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeIpamPolicies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeIpamPolicies{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeIpamPolicies"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeIpamPolicies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeIpamPolicies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeIpamPolicies",
	}
}
