// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enable Amazon EC2 instances running in an SQL Server High Availability cluster
// for SQL Server High Availability instance standby detection monitoring. Once
// enabled, Amazon Web Services monitors the metadata for the instances to
// determine whether they are active or standby nodes in the SQL Server High
// Availability cluster. If the instances are determined to be standby failover
// nodes, Amazon Web Services automatically applies SQL Server licensing fee waiver
// for those instances.
//
// To register an instance, it must be running a Windows SQL Server
// license-included AMI and have the Amazon Web Services Systems Manager agent
// installed and running. Only Windows Server 2019 and later and SQL Server
// (Standard and Enterprise editions) 2017 and later are supported. For more
// information, see [Prerequisites for using SQL Server High Availability instance standby detection].
//
// [Prerequisites for using SQL Server High Availability instance standby detection]: https://docs.aws.amazon.com/sql-server-ec2/latest/userguide/prerequisites-and-requirements.html
func (c *Client) EnableInstanceSqlHaStandbyDetections(ctx context.Context, params *EnableInstanceSqlHaStandbyDetectionsInput, optFns ...func(*Options)) (*EnableInstanceSqlHaStandbyDetectionsOutput, error) {
	if params == nil {
		params = &EnableInstanceSqlHaStandbyDetectionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EnableInstanceSqlHaStandbyDetections", params, optFns, c.addOperationEnableInstanceSqlHaStandbyDetectionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EnableInstanceSqlHaStandbyDetectionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EnableInstanceSqlHaStandbyDetectionsInput struct {

	// The IDs of the instances to enable for SQL Server High Availability standby
	// detection monitoring.
	//
	// This member is required.
	InstanceIds []string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The ARN of the Secrets Manager secret containing the SQL Server access
	// credentials. The specified secret must contain valid SQL Server credentials for
	// the specified instances. If not specified, deafult local user credentials will
	// be used by the Amazon Web Services Systems Manager agent. To enable instances
	// with different credentials, you must make separate requests.
	SqlServerCredentials *string

	noSmithyDocumentSerde
}

type EnableInstanceSqlHaStandbyDetectionsOutput struct {

	// Information about the instances that were enabled for SQL Server High
	// Availability standby detection monitoring.
	Instances []types.RegisteredInstance

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEnableInstanceSqlHaStandbyDetectionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpEnableInstanceSqlHaStandbyDetections{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpEnableInstanceSqlHaStandbyDetections{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EnableInstanceSqlHaStandbyDetections"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpEnableInstanceSqlHaStandbyDetectionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEnableInstanceSqlHaStandbyDetections(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEnableInstanceSqlHaStandbyDetections(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EnableInstanceSqlHaStandbyDetections",
	}
}
