// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modify VPC Block Public Access (BPA) options. VPC Block Public Access (BPA)
// enables you to block resources in VPCs and subnets that you own in a Region from
// reaching or being reached from the internet through internet gateways and
// egress-only internet gateways. To learn more about VPC BPA, see [Block public access to VPCs and subnets]in the Amazon
// VPC User Guide.
//
// [Block public access to VPCs and subnets]: https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html
func (c *Client) ModifyVpcBlockPublicAccessOptions(ctx context.Context, params *ModifyVpcBlockPublicAccessOptionsInput, optFns ...func(*Options)) (*ModifyVpcBlockPublicAccessOptionsOutput, error) {
	if params == nil {
		params = &ModifyVpcBlockPublicAccessOptionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyVpcBlockPublicAccessOptions", params, optFns, c.addOperationModifyVpcBlockPublicAccessOptionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyVpcBlockPublicAccessOptionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyVpcBlockPublicAccessOptionsInput struct {

	// The mode of VPC BPA.
	//
	//   - off : VPC BPA is not enabled and traffic is allowed to and from internet
	//   gateways and egress-only internet gateways in this Region.
	//
	//   - block-bidirectional : Block all traffic to and from internet gateways and
	//   egress-only internet gateways in this Region (except for excluded VPCs and
	//   subnets).
	//
	//   - block-ingress : Block all internet traffic to the VPCs in this Region
	//   (except for VPCs or subnets which are excluded). Only traffic to and from NAT
	//   gateways and egress-only internet gateways is allowed because these gateways
	//   only allow outbound connections to be established.
	//
	// This member is required.
	InternetGatewayBlockMode types.InternetGatewayBlockMode

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	noSmithyDocumentSerde
}

type ModifyVpcBlockPublicAccessOptionsOutput struct {

	// Details related to the VPC Block Public Access (BPA) options.
	VpcBlockPublicAccessOptions *types.VpcBlockPublicAccessOptions

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyVpcBlockPublicAccessOptionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpModifyVpcBlockPublicAccessOptions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpModifyVpcBlockPublicAccessOptions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyVpcBlockPublicAccessOptions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpModifyVpcBlockPublicAccessOptionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyVpcBlockPublicAccessOptions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyVpcBlockPublicAccessOptions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyVpcBlockPublicAccessOptions",
	}
}
