// Code generated by protoc-gen-go-aip. DO NOT EDIT.
//
// versions:
// 	protoc-gen-go-aip development
// 	protoc (unknown)
// source: test/originallysinglepattern/testdata.proto

package originallysinglepattern

import (
	encoding "encoding"
	fmt "fmt"
	resourcename "go.einride.tech/aip/resourcename"
	strings "strings"
)

type BookMultiPatternResourceName interface {
	fmt.Stringer
	encoding.TextMarshaler
	MarshalString() (string, error)
	ContainsWildcard() bool
}

func ParseBookMultiPatternResourceName(name string) (BookMultiPatternResourceName, error) {
	switch {
	case resourcename.Match("shelves/{shelf}/books/{book}", name):
		var result ShelvesBookResourceName
		return &result, result.UnmarshalString(name)
	case resourcename.Match("publishers/{publisher}/books/{book}", name):
		var result PublishersBookResourceName
		return &result, result.UnmarshalString(name)
	default:
		return nil, fmt.Errorf("no matching pattern")
	}
}

type BookResourceName struct {
	Shelf string
	Book  string
}

func (n ShelfResourceName) BookResourceName(
	book string,
) BookResourceName {
	return BookResourceName{
		Shelf: n.Shelf,
		Book:  book,
	}
}

func (n BookResourceName) Validate() error {
	if n.Shelf == "" {
		return fmt.Errorf("shelf: empty")
	}
	if strings.IndexByte(n.Shelf, '/') != -1 {
		return fmt.Errorf("shelf: contains illegal character '/'")
	}
	if n.Book == "" {
		return fmt.Errorf("book: empty")
	}
	if strings.IndexByte(n.Book, '/') != -1 {
		return fmt.Errorf("book: contains illegal character '/'")
	}
	return nil
}

func (n BookResourceName) ContainsWildcard() bool {
	return false || n.Shelf == "-" || n.Book == "-"
}

func (n BookResourceName) String() string {
	return resourcename.Sprint(
		"shelves/{shelf}/books/{book}",
		n.Shelf,
		n.Book,
	)
}

func (n BookResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

// MarshalText implements the encoding.TextMarshaler interface.
func (n BookResourceName) MarshalText() ([]byte, error) {
	if err := n.Validate(); err != nil {
		return nil, err
	}
	return []byte(n.String()), nil
}

func (n *BookResourceName) UnmarshalString(name string) error {
	err := resourcename.Sscan(
		name,
		"shelves/{shelf}/books/{book}",
		&n.Shelf,
		&n.Book,
	)
	if err != nil {
		return err
	}
	return n.Validate()
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (n *BookResourceName) UnmarshalText(text []byte) error {
	return n.UnmarshalString(string(text))
}

func (n BookResourceName) Type() string {
	return "test1.testdata/Book"
}

func (n BookResourceName) ShelfResourceName() ShelfResourceName {
	return ShelfResourceName{
		Shelf: n.Shelf,
	}
}

type ShelvesBookResourceName struct {
	Shelf string
	Book  string
}

func (n ShelfResourceName) ShelvesBookResourceName(
	book string,
) ShelvesBookResourceName {
	return ShelvesBookResourceName{
		Shelf: n.Shelf,
		Book:  book,
	}
}

func (n ShelvesBookResourceName) Validate() error {
	if n.Shelf == "" {
		return fmt.Errorf("shelf: empty")
	}
	if strings.IndexByte(n.Shelf, '/') != -1 {
		return fmt.Errorf("shelf: contains illegal character '/'")
	}
	if n.Book == "" {
		return fmt.Errorf("book: empty")
	}
	if strings.IndexByte(n.Book, '/') != -1 {
		return fmt.Errorf("book: contains illegal character '/'")
	}
	return nil
}

func (n ShelvesBookResourceName) ContainsWildcard() bool {
	return false || n.Shelf == "-" || n.Book == "-"
}

func (n ShelvesBookResourceName) String() string {
	return resourcename.Sprint(
		"shelves/{shelf}/books/{book}",
		n.Shelf,
		n.Book,
	)
}

func (n ShelvesBookResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

// MarshalText implements the encoding.TextMarshaler interface.
func (n ShelvesBookResourceName) MarshalText() ([]byte, error) {
	if err := n.Validate(); err != nil {
		return nil, err
	}
	return []byte(n.String()), nil
}

func (n *ShelvesBookResourceName) UnmarshalString(name string) error {
	err := resourcename.Sscan(
		name,
		"shelves/{shelf}/books/{book}",
		&n.Shelf,
		&n.Book,
	)
	if err != nil {
		return err
	}
	return n.Validate()
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (n *ShelvesBookResourceName) UnmarshalText(text []byte) error {
	return n.UnmarshalString(string(text))
}

func (n ShelvesBookResourceName) Type() string {
	return "test1.testdata/Book"
}

func (n ShelvesBookResourceName) ShelfResourceName() ShelfResourceName {
	return ShelfResourceName{
		Shelf: n.Shelf,
	}
}

type PublishersBookResourceName struct {
	Publisher string
	Book      string
}

func (n PublishersBookResourceName) Validate() error {
	if n.Publisher == "" {
		return fmt.Errorf("publisher: empty")
	}
	if strings.IndexByte(n.Publisher, '/') != -1 {
		return fmt.Errorf("publisher: contains illegal character '/'")
	}
	if n.Book == "" {
		return fmt.Errorf("book: empty")
	}
	if strings.IndexByte(n.Book, '/') != -1 {
		return fmt.Errorf("book: contains illegal character '/'")
	}
	return nil
}

func (n PublishersBookResourceName) ContainsWildcard() bool {
	return false || n.Publisher == "-" || n.Book == "-"
}

func (n PublishersBookResourceName) String() string {
	return resourcename.Sprint(
		"publishers/{publisher}/books/{book}",
		n.Publisher,
		n.Book,
	)
}

func (n PublishersBookResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

// MarshalText implements the encoding.TextMarshaler interface.
func (n PublishersBookResourceName) MarshalText() ([]byte, error) {
	if err := n.Validate(); err != nil {
		return nil, err
	}
	return []byte(n.String()), nil
}

func (n *PublishersBookResourceName) UnmarshalString(name string) error {
	err := resourcename.Sscan(
		name,
		"publishers/{publisher}/books/{book}",
		&n.Publisher,
		&n.Book,
	)
	if err != nil {
		return err
	}
	return n.Validate()
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (n *PublishersBookResourceName) UnmarshalText(text []byte) error {
	return n.UnmarshalString(string(text))
}

func (n PublishersBookResourceName) Type() string {
	return "test1.testdata/Book"
}

type ShelfMultiPatternResourceName interface {
	fmt.Stringer
	encoding.TextMarshaler
	MarshalString() (string, error)
	ContainsWildcard() bool
}

func ParseShelfMultiPatternResourceName(name string) (ShelfMultiPatternResourceName, error) {
	switch {
	case resourcename.Match("shelves/{shelf}", name):
		var result ShelfResourceName
		return &result, result.UnmarshalString(name)
	case resourcename.Match("libraries/{library}/shelves/{shelf}", name):
		var result LibrariesShelfResourceName
		return &result, result.UnmarshalString(name)
	case resourcename.Match("rooms/{room}/shelves/{shelf}", name):
		var result RoomsShelfResourceName
		return &result, result.UnmarshalString(name)
	default:
		return nil, fmt.Errorf("no matching pattern")
	}
}

type ShelfResourceName struct {
	Shelf string
}

func (n ShelfResourceName) Validate() error {
	if n.Shelf == "" {
		return fmt.Errorf("shelf: empty")
	}
	if strings.IndexByte(n.Shelf, '/') != -1 {
		return fmt.Errorf("shelf: contains illegal character '/'")
	}
	return nil
}

func (n ShelfResourceName) ContainsWildcard() bool {
	return false || n.Shelf == "-"
}

func (n ShelfResourceName) String() string {
	return resourcename.Sprint(
		"shelves/{shelf}",
		n.Shelf,
	)
}

func (n ShelfResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

// MarshalText implements the encoding.TextMarshaler interface.
func (n ShelfResourceName) MarshalText() ([]byte, error) {
	if err := n.Validate(); err != nil {
		return nil, err
	}
	return []byte(n.String()), nil
}

func (n *ShelfResourceName) UnmarshalString(name string) error {
	err := resourcename.Sscan(
		name,
		"shelves/{shelf}",
		&n.Shelf,
	)
	if err != nil {
		return err
	}
	return n.Validate()
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (n *ShelfResourceName) UnmarshalText(text []byte) error {
	return n.UnmarshalString(string(text))
}

func (n ShelfResourceName) Type() string {
	return "test1.testdata/Shelf"
}

type LibrariesShelfResourceName struct {
	Library string
	Shelf   string
}

func (n LibrariesShelfResourceName) Validate() error {
	if n.Library == "" {
		return fmt.Errorf("library: empty")
	}
	if strings.IndexByte(n.Library, '/') != -1 {
		return fmt.Errorf("library: contains illegal character '/'")
	}
	if n.Shelf == "" {
		return fmt.Errorf("shelf: empty")
	}
	if strings.IndexByte(n.Shelf, '/') != -1 {
		return fmt.Errorf("shelf: contains illegal character '/'")
	}
	return nil
}

func (n LibrariesShelfResourceName) ContainsWildcard() bool {
	return false || n.Library == "-" || n.Shelf == "-"
}

func (n LibrariesShelfResourceName) String() string {
	return resourcename.Sprint(
		"libraries/{library}/shelves/{shelf}",
		n.Library,
		n.Shelf,
	)
}

func (n LibrariesShelfResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

// MarshalText implements the encoding.TextMarshaler interface.
func (n LibrariesShelfResourceName) MarshalText() ([]byte, error) {
	if err := n.Validate(); err != nil {
		return nil, err
	}
	return []byte(n.String()), nil
}

func (n *LibrariesShelfResourceName) UnmarshalString(name string) error {
	err := resourcename.Sscan(
		name,
		"libraries/{library}/shelves/{shelf}",
		&n.Library,
		&n.Shelf,
	)
	if err != nil {
		return err
	}
	return n.Validate()
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (n *LibrariesShelfResourceName) UnmarshalText(text []byte) error {
	return n.UnmarshalString(string(text))
}

func (n LibrariesShelfResourceName) Type() string {
	return "test1.testdata/Shelf"
}

type RoomsShelfResourceName struct {
	Room  string
	Shelf string
}

func (n RoomsShelfResourceName) Validate() error {
	if n.Room == "" {
		return fmt.Errorf("room: empty")
	}
	if strings.IndexByte(n.Room, '/') != -1 {
		return fmt.Errorf("room: contains illegal character '/'")
	}
	if n.Shelf == "" {
		return fmt.Errorf("shelf: empty")
	}
	if strings.IndexByte(n.Shelf, '/') != -1 {
		return fmt.Errorf("shelf: contains illegal character '/'")
	}
	return nil
}

func (n RoomsShelfResourceName) ContainsWildcard() bool {
	return false || n.Room == "-" || n.Shelf == "-"
}

func (n RoomsShelfResourceName) String() string {
	return resourcename.Sprint(
		"rooms/{room}/shelves/{shelf}",
		n.Room,
		n.Shelf,
	)
}

func (n RoomsShelfResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

// MarshalText implements the encoding.TextMarshaler interface.
func (n RoomsShelfResourceName) MarshalText() ([]byte, error) {
	if err := n.Validate(); err != nil {
		return nil, err
	}
	return []byte(n.String()), nil
}

func (n *RoomsShelfResourceName) UnmarshalString(name string) error {
	err := resourcename.Sscan(
		name,
		"rooms/{room}/shelves/{shelf}",
		&n.Room,
		&n.Shelf,
	)
	if err != nil {
		return err
	}
	return n.Validate()
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (n *RoomsShelfResourceName) UnmarshalText(text []byte) error {
	return n.UnmarshalString(string(text))
}

func (n RoomsShelfResourceName) Type() string {
	return "test1.testdata/Shelf"
}
