// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: config/v1beta1/config.proto

package v1beta1

import (
	validate "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Config represents the root configuration structure for GitLab SDK clients.
// It follows a similar pattern to Kubernetes config with contexts and instances.
type Config struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// version specifies the configuration schema version
	Version *string `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// preferences contains global client preferences
	Preferences *Preferences `protobuf:"bytes,3,opt,name=preferences" json:"preferences,omitempty"`
	// instances contains the list of GitLab instances
	Instances []*Instance `protobuf:"bytes,4,rep,name=instances" json:"instances,omitempty"`
	// auths contains credential information for different authentication methods
	Auths []*Auth `protobuf:"bytes,5,rep,name=auths" json:"auths,omitempty"`
	// contexts contains the list of available contexts
	Contexts []*Context `protobuf:"bytes,6,rep,name=contexts" json:"contexts,omitempty"`
	// current_context specifies the active context
	CurrentContext *string `protobuf:"bytes,7,opt,name=current_context,json=current-context" json:"current_context,omitempty"`
	// extensions specifies arbitrary custom configuration
	Extensions    map[string]*structpb.Struct `protobuf:"bytes,8,rep,name=extensions" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Config) Reset() {
	*x = Config{}
	mi := &file_config_v1beta1_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Config) ProtoMessage() {}

func (x *Config) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Config.ProtoReflect.Descriptor instead.
func (*Config) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{0}
}

func (x *Config) GetVersion() string {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return ""
}

func (x *Config) GetPreferences() *Preferences {
	if x != nil {
		return x.Preferences
	}
	return nil
}

func (x *Config) GetInstances() []*Instance {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *Config) GetAuths() []*Auth {
	if x != nil {
		return x.Auths
	}
	return nil
}

func (x *Config) GetContexts() []*Context {
	if x != nil {
		return x.Contexts
	}
	return nil
}

func (x *Config) GetCurrentContext() string {
	if x != nil && x.CurrentContext != nil {
		return *x.CurrentContext
	}
	return ""
}

func (x *Config) GetExtensions() map[string]*structpb.Struct {
	if x != nil {
		return x.Extensions
	}
	return nil
}

// Preferences contains global client configuration preferences
type Preferences struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// retry_max specifies the maximum number of retries
	RetryMax *int32 `protobuf:"varint,2,opt,name=retry_max,json=retry-max" json:"retry_max,omitempty"`
	// retry_wait_min specifies the minimum wait time between retries (in milliseconds)
	RetryWaitMin *durationpb.Duration `protobuf:"bytes,3,opt,name=retry_wait_min,json=retry-wait-min" json:"retry_wait_min,omitempty"`
	// retry_wait_max specifies the maximum wait time between retries (in milliseconds)
	RetryWaitMax  *durationpb.Duration `protobuf:"bytes,4,opt,name=retry_wait_max,json=retry-wait-max" json:"retry_wait_max,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Preferences) Reset() {
	*x = Preferences{}
	mi := &file_config_v1beta1_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Preferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Preferences) ProtoMessage() {}

func (x *Preferences) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Preferences.ProtoReflect.Descriptor instead.
func (*Preferences) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{1}
}

func (x *Preferences) GetRetryMax() int32 {
	if x != nil && x.RetryMax != nil {
		return *x.RetryMax
	}
	return 0
}

func (x *Preferences) GetRetryWaitMin() *durationpb.Duration {
	if x != nil {
		return x.RetryWaitMin
	}
	return nil
}

func (x *Preferences) GetRetryWaitMax() *durationpb.Duration {
	if x != nil {
		return x.RetryWaitMax
	}
	return nil
}

// Instance represents a GitLab instance configuration
type Instance struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the unique identifier for this instance
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// server is the GitLab instance URL
	Server *string `protobuf:"bytes,2,opt,name=server" json:"server,omitempty"`
	// api_version specifies the GitLab API version (defaults to v4)
	ApiVersion *string `protobuf:"bytes,3,opt,name=api_version,json=api-version" json:"api_version,omitempty"`
	// Types that are valid to be assigned to InstanceCa:
	//
	//	*Instance_CertificateAuthority
	//	*Instance_CertificateAuthoritySource
	InstanceCa isInstance_InstanceCa `protobuf_oneof:"instance_ca"`
	// Types that are valid to be assigned to InstanceClientCert:
	//
	//	*Instance_ClientCert
	//	*Instance_ClientCertSource
	InstanceClientCert isInstance_InstanceClientCert `protobuf_oneof:"instance_client_cert"`
	// Types that are valid to be assigned to InstanceClientKey:
	//
	//	*Instance_ClientKey
	//	*Instance_ClientKeySource
	InstanceClientKey isInstance_InstanceClientKey `protobuf_oneof:"instance_client_key"`
	// insecure_skip_tls_verify skips TLS certificate verification
	InsecureSkipTlsVerify *bool `protobuf:"varint,10,opt,name=insecure_skip_tls_verify,json=insecure-skip-tls-verify" json:"insecure_skip_tls_verify,omitempty"`
	// rate_limit contains rate limiting configuration
	RateLimit *RateLimit `protobuf:"bytes,11,opt,name=rate_limit,json=rate-limit" json:"rate_limit,omitempty"`
	// extensions specifies arbitrary custom configuration
	Extensions map[string]*structpb.Struct `protobuf:"bytes,12,rep,name=extensions" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// custom_headers can contain a list of additional headers to add to every request.
	CustomHeaders []*Header `protobuf:"bytes,13,rep,name=custom_headers,json=custom-headers" json:"custom_headers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Instance) Reset() {
	*x = Instance{}
	mi := &file_config_v1beta1_config_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{2}
}

func (x *Instance) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Instance) GetServer() string {
	if x != nil && x.Server != nil {
		return *x.Server
	}
	return ""
}

func (x *Instance) GetApiVersion() string {
	if x != nil && x.ApiVersion != nil {
		return *x.ApiVersion
	}
	return ""
}

func (x *Instance) GetInstanceCa() isInstance_InstanceCa {
	if x != nil {
		return x.InstanceCa
	}
	return nil
}

func (x *Instance) GetCertificateAuthority() string {
	if x != nil {
		if x, ok := x.InstanceCa.(*Instance_CertificateAuthority); ok {
			return x.CertificateAuthority
		}
	}
	return ""
}

func (x *Instance) GetCertificateAuthoritySource() *CredentialSource {
	if x != nil {
		if x, ok := x.InstanceCa.(*Instance_CertificateAuthoritySource); ok {
			return x.CertificateAuthoritySource
		}
	}
	return nil
}

func (x *Instance) GetInstanceClientCert() isInstance_InstanceClientCert {
	if x != nil {
		return x.InstanceClientCert
	}
	return nil
}

func (x *Instance) GetClientCert() string {
	if x != nil {
		if x, ok := x.InstanceClientCert.(*Instance_ClientCert); ok {
			return x.ClientCert
		}
	}
	return ""
}

func (x *Instance) GetClientCertSource() *CredentialSource {
	if x != nil {
		if x, ok := x.InstanceClientCert.(*Instance_ClientCertSource); ok {
			return x.ClientCertSource
		}
	}
	return nil
}

func (x *Instance) GetInstanceClientKey() isInstance_InstanceClientKey {
	if x != nil {
		return x.InstanceClientKey
	}
	return nil
}

func (x *Instance) GetClientKey() string {
	if x != nil {
		if x, ok := x.InstanceClientKey.(*Instance_ClientKey); ok {
			return x.ClientKey
		}
	}
	return ""
}

func (x *Instance) GetClientKeySource() *CredentialSource {
	if x != nil {
		if x, ok := x.InstanceClientKey.(*Instance_ClientKeySource); ok {
			return x.ClientKeySource
		}
	}
	return nil
}

func (x *Instance) GetInsecureSkipTlsVerify() bool {
	if x != nil && x.InsecureSkipTlsVerify != nil {
		return *x.InsecureSkipTlsVerify
	}
	return false
}

func (x *Instance) GetRateLimit() *RateLimit {
	if x != nil {
		return x.RateLimit
	}
	return nil
}

func (x *Instance) GetExtensions() map[string]*structpb.Struct {
	if x != nil {
		return x.Extensions
	}
	return nil
}

func (x *Instance) GetCustomHeaders() []*Header {
	if x != nil {
		return x.CustomHeaders
	}
	return nil
}

type isInstance_InstanceCa interface {
	isInstance_InstanceCa()
}

type Instance_CertificateAuthority struct {
	// certificate_authority contains the CA certificate data
	CertificateAuthority string `protobuf:"bytes,4,opt,name=certificate_authority,json=certificate-authority,oneof"`
}

type Instance_CertificateAuthoritySource struct {
	// certificate_authority_source specifies how to get the CA certificate
	CertificateAuthoritySource *CredentialSource `protobuf:"bytes,5,opt,name=certificate_authority_source,json=certificate-authority-source,oneof"`
}

func (*Instance_CertificateAuthority) isInstance_InstanceCa() {}

func (*Instance_CertificateAuthoritySource) isInstance_InstanceCa() {}

type isInstance_InstanceClientCert interface {
	isInstance_InstanceClientCert()
}

type Instance_ClientCert struct {
	// client_cert contains the client certificate data for mTLS
	ClientCert string `protobuf:"bytes,6,opt,name=client_cert,json=client-cert,oneof"`
}

type Instance_ClientCertSource struct {
	// client_cert_source specifies how to get the client certificate for mTLS
	ClientCertSource *CredentialSource `protobuf:"bytes,7,opt,name=client_cert_source,json=client-cert-source,oneof"`
}

func (*Instance_ClientCert) isInstance_InstanceClientCert() {}

func (*Instance_ClientCertSource) isInstance_InstanceClientCert() {}

type isInstance_InstanceClientKey interface {
	isInstance_InstanceClientKey()
}

type Instance_ClientKey struct {
	// client_key contains the client key data for mTLS
	ClientKey string `protobuf:"bytes,8,opt,name=client_key,json=client-key,oneof"`
}

type Instance_ClientKeySource struct {
	// client_key_source specifies how to get the client key for mTLS
	ClientKeySource *CredentialSource `protobuf:"bytes,9,opt,name=client_key_source,json=client-key-source,oneof"`
}

func (*Instance_ClientKey) isInstance_InstanceClientKey() {}

func (*Instance_ClientKeySource) isInstance_InstanceClientKey() {}

// RateLimit contains rate limiting configuration
type RateLimit struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// requests_per_second specifies the maximum requests per second
	RequestsPerSecond *float64 `protobuf:"fixed64,2,opt,name=requests_per_second,json=requests-per-second" json:"requests_per_second,omitempty"`
	// burst specifies the maximum burst size
	Burst         *int32 `protobuf:"varint,3,opt,name=burst" json:"burst,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RateLimit) Reset() {
	*x = RateLimit{}
	mi := &file_config_v1beta1_config_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RateLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimit) ProtoMessage() {}

func (x *RateLimit) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimit.ProtoReflect.Descriptor instead.
func (*RateLimit) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{3}
}

func (x *RateLimit) GetRequestsPerSecond() float64 {
	if x != nil && x.RequestsPerSecond != nil {
		return *x.RequestsPerSecond
	}
	return 0
}

func (x *RateLimit) GetBurst() int32 {
	if x != nil && x.Burst != nil {
		return *x.Burst
	}
	return 0
}

// Header contains a single HTTP header definition
type Header struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name contains the name of the header
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Types that are valid to be assigned to HeaderValue:
	//
	//	*Header_Value
	//	*Header_ValueFrom
	HeaderValue   isHeader_HeaderValue `protobuf_oneof:"header_value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Header) Reset() {
	*x = Header{}
	mi := &file_config_v1beta1_config_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Header) ProtoMessage() {}

func (x *Header) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Header.ProtoReflect.Descriptor instead.
func (*Header) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{4}
}

func (x *Header) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Header) GetHeaderValue() isHeader_HeaderValue {
	if x != nil {
		return x.HeaderValue
	}
	return nil
}

func (x *Header) GetValue() string {
	if x != nil {
		if x, ok := x.HeaderValue.(*Header_Value); ok {
			return x.Value
		}
	}
	return ""
}

func (x *Header) GetValueFrom() *CredentialSource {
	if x != nil {
		if x, ok := x.HeaderValue.(*Header_ValueFrom); ok {
			return x.ValueFrom
		}
	}
	return nil
}

type isHeader_HeaderValue interface {
	isHeader_HeaderValue()
}

type Header_Value struct {
	// value contains the literal value of the header
	Value string `protobuf:"bytes,2,opt,name=value,oneof"`
}

type Header_ValueFrom struct {
	// value_from contains a source from where to retrieve the value from.
	ValueFrom *CredentialSource `protobuf:"bytes,3,opt,name=value_from,json=value-from,oneof"`
}

func (*Header_Value) isHeader_HeaderValue() {}

func (*Header_ValueFrom) isHeader_HeaderValue() {}

// Context represents a combination of instance and auth
type Context struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the unique identifier for this context
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// instance references an instance by name
	Instance *string `protobuf:"bytes,2,opt,name=instance" json:"instance,omitempty"`
	// auth references an auth by name
	Auth          *string `protobuf:"bytes,3,opt,name=auth" json:"auth,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Context) Reset() {
	*x = Context{}
	mi := &file_config_v1beta1_config_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Context) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Context) ProtoMessage() {}

func (x *Context) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Context.ProtoReflect.Descriptor instead.
func (*Context) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{5}
}

func (x *Context) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Context) GetInstance() string {
	if x != nil && x.Instance != nil {
		return *x.Instance
	}
	return ""
}

func (x *Context) GetAuth() string {
	if x != nil && x.Auth != nil {
		return *x.Auth
	}
	return ""
}

// Auth contains authentication information
type Auth struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the unique identifier for this auth
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// auth_info contains the authentication details
	AuthInfo      *AuthInfo `protobuf:"bytes,2,opt,name=auth_info,json=auth-info" json:"auth_info,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Auth) Reset() {
	*x = Auth{}
	mi := &file_config_v1beta1_config_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Auth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Auth) ProtoMessage() {}

func (x *Auth) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Auth.ProtoReflect.Descriptor instead.
func (*Auth) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{6}
}

func (x *Auth) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Auth) GetAuthInfo() *AuthInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

// AuthInfo contains authentication configuration
type AuthInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// auth_provider specifies the authentication method
	//
	// Types that are valid to be assigned to AuthProvider:
	//
	//	*AuthInfo_PersonalAccessToken
	//	*AuthInfo_JobToken
	//	*AuthInfo_Oauth2
	//	*AuthInfo_BasicAuth
	AuthProvider  isAuthInfo_AuthProvider `protobuf_oneof:"auth_provider"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AuthInfo) Reset() {
	*x = AuthInfo{}
	mi := &file_config_v1beta1_config_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthInfo) ProtoMessage() {}

func (x *AuthInfo) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthInfo.ProtoReflect.Descriptor instead.
func (*AuthInfo) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{7}
}

func (x *AuthInfo) GetAuthProvider() isAuthInfo_AuthProvider {
	if x != nil {
		return x.AuthProvider
	}
	return nil
}

func (x *AuthInfo) GetPersonalAccessToken() *PersonalAccessToken {
	if x != nil {
		if x, ok := x.AuthProvider.(*AuthInfo_PersonalAccessToken); ok {
			return x.PersonalAccessToken
		}
	}
	return nil
}

func (x *AuthInfo) GetJobToken() *JobToken {
	if x != nil {
		if x, ok := x.AuthProvider.(*AuthInfo_JobToken); ok {
			return x.JobToken
		}
	}
	return nil
}

func (x *AuthInfo) GetOauth2() *OAuth2 {
	if x != nil {
		if x, ok := x.AuthProvider.(*AuthInfo_Oauth2); ok {
			return x.Oauth2
		}
	}
	return nil
}

func (x *AuthInfo) GetBasicAuth() *BasicAuth {
	if x != nil {
		if x, ok := x.AuthProvider.(*AuthInfo_BasicAuth); ok {
			return x.BasicAuth
		}
	}
	return nil
}

type isAuthInfo_AuthProvider interface {
	isAuthInfo_AuthProvider()
}

type AuthInfo_PersonalAccessToken struct {
	PersonalAccessToken *PersonalAccessToken `protobuf:"bytes,1,opt,name=personal_access_token,json=personal-access-token,oneof"`
}

type AuthInfo_JobToken struct {
	JobToken *JobToken `protobuf:"bytes,2,opt,name=job_token,json=job-token,oneof"`
}

type AuthInfo_Oauth2 struct {
	Oauth2 *OAuth2 `protobuf:"bytes,3,opt,name=oauth2,oneof"`
}

type AuthInfo_BasicAuth struct {
	BasicAuth *BasicAuth `protobuf:"bytes,4,opt,name=basic_auth,json=basic-auth,oneof"`
}

func (*AuthInfo_PersonalAccessToken) isAuthInfo_AuthProvider() {}

func (*AuthInfo_JobToken) isAuthInfo_AuthProvider() {}

func (*AuthInfo_Oauth2) isAuthInfo_AuthProvider() {}

func (*AuthInfo_BasicAuth) isAuthInfo_AuthProvider() {}

// PersonalAccessToken contains personal access token authentication
type PersonalAccessToken struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to PersonalAccessToken:
	//
	//	*PersonalAccessToken_Token
	//	*PersonalAccessToken_TokenSource
	PersonalAccessToken isPersonalAccessToken_PersonalAccessToken `protobuf_oneof:"personal_access_token"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *PersonalAccessToken) Reset() {
	*x = PersonalAccessToken{}
	mi := &file_config_v1beta1_config_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PersonalAccessToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalAccessToken) ProtoMessage() {}

func (x *PersonalAccessToken) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalAccessToken.ProtoReflect.Descriptor instead.
func (*PersonalAccessToken) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{8}
}

func (x *PersonalAccessToken) GetPersonalAccessToken() isPersonalAccessToken_PersonalAccessToken {
	if x != nil {
		return x.PersonalAccessToken
	}
	return nil
}

func (x *PersonalAccessToken) GetToken() string {
	if x != nil {
		if x, ok := x.PersonalAccessToken.(*PersonalAccessToken_Token); ok {
			return x.Token
		}
	}
	return ""
}

func (x *PersonalAccessToken) GetTokenSource() *CredentialSource {
	if x != nil {
		if x, ok := x.PersonalAccessToken.(*PersonalAccessToken_TokenSource); ok {
			return x.TokenSource
		}
	}
	return nil
}

type isPersonalAccessToken_PersonalAccessToken interface {
	isPersonalAccessToken_PersonalAccessToken()
}

type PersonalAccessToken_Token struct {
	// token contains the actual token value
	Token string `protobuf:"bytes,1,opt,name=token,oneof"`
}

type PersonalAccessToken_TokenSource struct {
	// token_source specifies how to obtain the token
	TokenSource *CredentialSource `protobuf:"bytes,2,opt,name=token_source,json=token-source,oneof"`
}

func (*PersonalAccessToken_Token) isPersonalAccessToken_PersonalAccessToken() {}

func (*PersonalAccessToken_TokenSource) isPersonalAccessToken_PersonalAccessToken() {}

// JobToken contains CI job token authentication
type JobToken struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to JobToken:
	//
	//	*JobToken_Token
	//	*JobToken_TokenSource
	JobToken      isJobToken_JobToken `protobuf_oneof:"job_token"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JobToken) Reset() {
	*x = JobToken{}
	mi := &file_config_v1beta1_config_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JobToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobToken) ProtoMessage() {}

func (x *JobToken) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobToken.ProtoReflect.Descriptor instead.
func (*JobToken) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{9}
}

func (x *JobToken) GetJobToken() isJobToken_JobToken {
	if x != nil {
		return x.JobToken
	}
	return nil
}

func (x *JobToken) GetToken() string {
	if x != nil {
		if x, ok := x.JobToken.(*JobToken_Token); ok {
			return x.Token
		}
	}
	return ""
}

func (x *JobToken) GetTokenSource() *CredentialSource {
	if x != nil {
		if x, ok := x.JobToken.(*JobToken_TokenSource); ok {
			return x.TokenSource
		}
	}
	return nil
}

type isJobToken_JobToken interface {
	isJobToken_JobToken()
}

type JobToken_Token struct {
	// token contains the actual token value
	Token string `protobuf:"bytes,1,opt,name=token,oneof"`
}

type JobToken_TokenSource struct {
	// token_source specifies how to obtain the token
	TokenSource *CredentialSource `protobuf:"bytes,2,opt,name=token_source,json=token-source,oneof"`
}

func (*JobToken_Token) isJobToken_JobToken() {}

func (*JobToken_TokenSource) isJobToken_JobToken() {}

// OAuth2 contains OAuth2 token authentication
type OAuth2 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// client_id contains the client_id for the OAuth2 app. If not set, then a default client_id is used
	ClientId *string `protobuf:"bytes,1,opt,name=client_id,json=client-id" json:"client_id,omitempty"`
	// Types that are valid to be assigned to Oauth2ClientSecret:
	//
	//	*OAuth2_ClientSecret
	//	*OAuth2_ClientSecretSource
	Oauth2ClientSecret isOAuth2_Oauth2ClientSecret `protobuf_oneof:"oauth2_client_secret"`
	// Types that are valid to be assigned to Oauth2AccessToken:
	//
	//	*OAuth2_AccessToken
	//	*OAuth2_AccessTokenSource
	Oauth2AccessToken isOAuth2_Oauth2AccessToken `protobuf_oneof:"oauth2_access_token"`
	// Types that are valid to be assigned to Oauth2RefreshToken:
	//
	//	*OAuth2_RefreshToken
	//	*OAuth2_RefreshTokenSource
	Oauth2RefreshToken isOAuth2_Oauth2RefreshToken `protobuf_oneof:"oauth2_refresh_token"`
	// expires_at contains the token expiration time
	ExpiresAt     *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=expires_at,json=expires-at" json:"expires_at,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OAuth2) Reset() {
	*x = OAuth2{}
	mi := &file_config_v1beta1_config_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OAuth2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuth2) ProtoMessage() {}

func (x *OAuth2) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuth2.ProtoReflect.Descriptor instead.
func (*OAuth2) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{10}
}

func (x *OAuth2) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *OAuth2) GetOauth2ClientSecret() isOAuth2_Oauth2ClientSecret {
	if x != nil {
		return x.Oauth2ClientSecret
	}
	return nil
}

func (x *OAuth2) GetClientSecret() string {
	if x != nil {
		if x, ok := x.Oauth2ClientSecret.(*OAuth2_ClientSecret); ok {
			return x.ClientSecret
		}
	}
	return ""
}

func (x *OAuth2) GetClientSecretSource() *CredentialSource {
	if x != nil {
		if x, ok := x.Oauth2ClientSecret.(*OAuth2_ClientSecretSource); ok {
			return x.ClientSecretSource
		}
	}
	return nil
}

func (x *OAuth2) GetOauth2AccessToken() isOAuth2_Oauth2AccessToken {
	if x != nil {
		return x.Oauth2AccessToken
	}
	return nil
}

func (x *OAuth2) GetAccessToken() string {
	if x != nil {
		if x, ok := x.Oauth2AccessToken.(*OAuth2_AccessToken); ok {
			return x.AccessToken
		}
	}
	return ""
}

func (x *OAuth2) GetAccessTokenSource() *CredentialSource {
	if x != nil {
		if x, ok := x.Oauth2AccessToken.(*OAuth2_AccessTokenSource); ok {
			return x.AccessTokenSource
		}
	}
	return nil
}

func (x *OAuth2) GetOauth2RefreshToken() isOAuth2_Oauth2RefreshToken {
	if x != nil {
		return x.Oauth2RefreshToken
	}
	return nil
}

func (x *OAuth2) GetRefreshToken() string {
	if x != nil {
		if x, ok := x.Oauth2RefreshToken.(*OAuth2_RefreshToken); ok {
			return x.RefreshToken
		}
	}
	return ""
}

func (x *OAuth2) GetRefreshTokenSource() *CredentialSource {
	if x != nil {
		if x, ok := x.Oauth2RefreshToken.(*OAuth2_RefreshTokenSource); ok {
			return x.RefreshTokenSource
		}
	}
	return nil
}

func (x *OAuth2) GetExpiresAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiresAt
	}
	return nil
}

type isOAuth2_Oauth2ClientSecret interface {
	isOAuth2_Oauth2ClientSecret()
}

type OAuth2_ClientSecret struct {
	// client_secret contains the client secret for the OAuth2 app. If not set, then a default client secret might be used
	ClientSecret string `protobuf:"bytes,2,opt,name=client_secret,json=client-secret,oneof"`
}

type OAuth2_ClientSecretSource struct {
	// client_secret specifies how to obtain the client secret
	ClientSecretSource *CredentialSource `protobuf:"bytes,3,opt,name=client_secret_source,json=client-secret-source,oneof"`
}

func (*OAuth2_ClientSecret) isOAuth2_Oauth2ClientSecret() {}

func (*OAuth2_ClientSecretSource) isOAuth2_Oauth2ClientSecret() {}

type isOAuth2_Oauth2AccessToken interface {
	isOAuth2_Oauth2AccessToken()
}

type OAuth2_AccessToken struct {
	// access_token contains the OAuth access token
	AccessToken string `protobuf:"bytes,4,opt,name=access_token,json=access-token,oneof"`
}

type OAuth2_AccessTokenSource struct {
	// access_token_source specifies how to obtain the access token
	AccessTokenSource *CredentialSource `protobuf:"bytes,5,opt,name=access_token_source,json=access-token-source,oneof"`
}

func (*OAuth2_AccessToken) isOAuth2_Oauth2AccessToken() {}

func (*OAuth2_AccessTokenSource) isOAuth2_Oauth2AccessToken() {}

type isOAuth2_Oauth2RefreshToken interface {
	isOAuth2_Oauth2RefreshToken()
}

type OAuth2_RefreshToken struct {
	// refresh_token contains the OAuth refresh token
	RefreshToken string `protobuf:"bytes,6,opt,name=refresh_token,json=refresh-token,oneof"`
}

type OAuth2_RefreshTokenSource struct {
	// token_source specifies how to obtain the refresh token
	RefreshTokenSource *CredentialSource `protobuf:"bytes,7,opt,name=refresh_token_source,json=refresh-token-source,oneof"`
}

func (*OAuth2_RefreshToken) isOAuth2_Oauth2RefreshToken() {}

func (*OAuth2_RefreshTokenSource) isOAuth2_Oauth2RefreshToken() {}

type BasicAuth struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to BasicAuthUsername:
	//
	//	*BasicAuth_Username
	//	*BasicAuth_UsernameSource
	BasicAuthUsername isBasicAuth_BasicAuthUsername `protobuf_oneof:"basic_auth_username"`
	// Types that are valid to be assigned to BasicAuthPassword:
	//
	//	*BasicAuth_Password
	//	*BasicAuth_PasswordSource
	BasicAuthPassword isBasicAuth_BasicAuthPassword `protobuf_oneof:"basic_auth_password"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *BasicAuth) Reset() {
	*x = BasicAuth{}
	mi := &file_config_v1beta1_config_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BasicAuth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BasicAuth) ProtoMessage() {}

func (x *BasicAuth) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BasicAuth.ProtoReflect.Descriptor instead.
func (*BasicAuth) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{11}
}

func (x *BasicAuth) GetBasicAuthUsername() isBasicAuth_BasicAuthUsername {
	if x != nil {
		return x.BasicAuthUsername
	}
	return nil
}

func (x *BasicAuth) GetUsername() string {
	if x != nil {
		if x, ok := x.BasicAuthUsername.(*BasicAuth_Username); ok {
			return x.Username
		}
	}
	return ""
}

func (x *BasicAuth) GetUsernameSource() *CredentialSource {
	if x != nil {
		if x, ok := x.BasicAuthUsername.(*BasicAuth_UsernameSource); ok {
			return x.UsernameSource
		}
	}
	return nil
}

func (x *BasicAuth) GetBasicAuthPassword() isBasicAuth_BasicAuthPassword {
	if x != nil {
		return x.BasicAuthPassword
	}
	return nil
}

func (x *BasicAuth) GetPassword() string {
	if x != nil {
		if x, ok := x.BasicAuthPassword.(*BasicAuth_Password); ok {
			return x.Password
		}
	}
	return ""
}

func (x *BasicAuth) GetPasswordSource() *CredentialSource {
	if x != nil {
		if x, ok := x.BasicAuthPassword.(*BasicAuth_PasswordSource); ok {
			return x.PasswordSource
		}
	}
	return nil
}

type isBasicAuth_BasicAuthUsername interface {
	isBasicAuth_BasicAuthUsername()
}

type BasicAuth_Username struct {
	Username string `protobuf:"bytes,1,opt,name=username,oneof"`
}

type BasicAuth_UsernameSource struct {
	UsernameSource *CredentialSource `protobuf:"bytes,2,opt,name=username_source,json=username-source,oneof"`
}

func (*BasicAuth_Username) isBasicAuth_BasicAuthUsername() {}

func (*BasicAuth_UsernameSource) isBasicAuth_BasicAuthUsername() {}

type isBasicAuth_BasicAuthPassword interface {
	isBasicAuth_BasicAuthPassword()
}

type BasicAuth_Password struct {
	Password string `protobuf:"bytes,3,opt,name=password,oneof"`
}

type BasicAuth_PasswordSource struct {
	PasswordSource *CredentialSource `protobuf:"bytes,4,opt,name=password_source,json=password-source,oneof"`
}

func (*BasicAuth_Password) isBasicAuth_BasicAuthPassword() {}

func (*BasicAuth_PasswordSource) isBasicAuth_BasicAuthPassword() {}

// ExecCredential contains configuration for executable credential providers
type ExecCredential struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// command is the executable to run
	Command *string `protobuf:"bytes,1,opt,name=command" json:"command,omitempty"`
	// args contains arguments to pass to the command
	Args []string `protobuf:"bytes,2,rep,name=args" json:"args,omitempty"`
	// env contains environment variables to set
	Env map[string]string `protobuf:"bytes,3,rep,name=env" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// timeout specifies the execution timeout (in seconds)
	Timeout       *durationpb.Duration `protobuf:"bytes,4,opt,name=timeout" json:"timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExecCredential) Reset() {
	*x = ExecCredential{}
	mi := &file_config_v1beta1_config_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecCredential) ProtoMessage() {}

func (x *ExecCredential) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecCredential.ProtoReflect.Descriptor instead.
func (*ExecCredential) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{12}
}

func (x *ExecCredential) GetCommand() string {
	if x != nil && x.Command != nil {
		return *x.Command
	}
	return ""
}

func (x *ExecCredential) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ExecCredential) GetEnv() map[string]string {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *ExecCredential) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

// CredentialSource specifies how to obtain credential values
type CredentialSource struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Source:
	//
	//	*CredentialSource_Value
	//	*CredentialSource_EnvVar
	//	*CredentialSource_File
	//	*CredentialSource_Exec
	//	*CredentialSource_Keyring
	Source        isCredentialSource_Source `protobuf_oneof:"source"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CredentialSource) Reset() {
	*x = CredentialSource{}
	mi := &file_config_v1beta1_config_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CredentialSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CredentialSource) ProtoMessage() {}

func (x *CredentialSource) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CredentialSource.ProtoReflect.Descriptor instead.
func (*CredentialSource) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{13}
}

func (x *CredentialSource) GetSource() isCredentialSource_Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *CredentialSource) GetValue() string {
	if x != nil {
		if x, ok := x.Source.(*CredentialSource_Value); ok {
			return x.Value
		}
	}
	return ""
}

func (x *CredentialSource) GetEnvVar() string {
	if x != nil {
		if x, ok := x.Source.(*CredentialSource_EnvVar); ok {
			return x.EnvVar
		}
	}
	return ""
}

func (x *CredentialSource) GetFile() string {
	if x != nil {
		if x, ok := x.Source.(*CredentialSource_File); ok {
			return x.File
		}
	}
	return ""
}

func (x *CredentialSource) GetExec() *ExecCredential {
	if x != nil {
		if x, ok := x.Source.(*CredentialSource_Exec); ok {
			return x.Exec
		}
	}
	return nil
}

func (x *CredentialSource) GetKeyring() *KeyringSource {
	if x != nil {
		if x, ok := x.Source.(*CredentialSource_Keyring); ok {
			return x.Keyring
		}
	}
	return nil
}

type isCredentialSource_Source interface {
	isCredentialSource_Source()
}

type CredentialSource_Value struct {
	// literal value stored directly in config
	Value string `protobuf:"bytes,1,opt,name=value,oneof"`
}

type CredentialSource_EnvVar struct {
	// environment variable name
	EnvVar string `protobuf:"bytes,2,opt,name=env_var,json=env-var,oneof"`
}

type CredentialSource_File struct {
	// file path containing the credential
	File string `protobuf:"bytes,3,opt,name=file,oneof"`
}

type CredentialSource_Exec struct {
	// command to execute to get the credential
	Exec *ExecCredential `protobuf:"bytes,4,opt,name=exec,oneof"`
}

type CredentialSource_Keyring struct {
	// keyring/keychain entry
	Keyring *KeyringSource `protobuf:"bytes,5,opt,name=keyring,oneof"`
}

func (*CredentialSource_Value) isCredentialSource_Source() {}

func (*CredentialSource_EnvVar) isCredentialSource_Source() {}

func (*CredentialSource_File) isCredentialSource_Source() {}

func (*CredentialSource_Exec) isCredentialSource_Source() {}

func (*CredentialSource_Keyring) isCredentialSource_Source() {}

// KeyringSource specifies keyring/keychain credential storage
type KeyringSource struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// service name in the keyring
	Service *string `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
	// user name is the keyring
	User          *string `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KeyringSource) Reset() {
	*x = KeyringSource{}
	mi := &file_config_v1beta1_config_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyringSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyringSource) ProtoMessage() {}

func (x *KeyringSource) ProtoReflect() protoreflect.Message {
	mi := &file_config_v1beta1_config_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyringSource.ProtoReflect.Descriptor instead.
func (*KeyringSource) Descriptor() ([]byte, []int) {
	return file_config_v1beta1_config_proto_rawDescGZIP(), []int{14}
}

func (x *KeyringSource) GetService() string {
	if x != nil && x.Service != nil {
		return *x.Service
	}
	return ""
}

func (x *KeyringSource) GetUser() string {
	if x != nil && x.User != nil {
		return *x.User
	}
	return ""
}

var file_config_v1beta1_config_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*validate.RepeatedRules)(nil),
		ExtensionType: (*bool)(nil),
		Field:         80000042,
		Name:          "config.v1beta1.unique_names",
		Tag:           "varint,80000042,opt,name=unique_names",
		Filename:      "config/v1beta1/config.proto",
	},
}

// Extension fields to validate.RepeatedRules.
var (
	// optional bool unique_names = 80000042;
	E_UniqueNames = &file_config_v1beta1_config_proto_extTypes[0]
)

var File_config_v1beta1_config_proto protoreflect.FileDescriptor

const file_config_v1beta1_config_proto_rawDesc = "" +
	"\n" +
	"\x1bconfig/v1beta1/config.proto\x12\x0econfig.v1beta1\x1a\x1bbuf/validate/validate.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1cgoogle/protobuf/struct.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\x83\b\n" +
	"\x06Config\x12:\n" +
	"\aversion\x18\x01 \x01(\tB \xbaH\x1dr\x1b\n" +
	"\x19gitlab.com/config/v1beta1R\aversion\x12=\n" +
	"\vpreferences\x18\x03 \x01(\v2\x1b.config.v1beta1.PreferencesR\vpreferences\x12D\n" +
	"\tinstances\x18\x04 \x03(\v2\x18.config.v1beta1.InstanceB\f\xbaH\t\x92\x01\x06\xd0\u0096\xb1\x02\x01R\tinstances\x128\n" +
	"\x05auths\x18\x05 \x03(\v2\x14.config.v1beta1.AuthB\f\xbaH\t\x92\x01\x06\xd0\u0096\xb1\x02\x01R\x05auths\x12A\n" +
	"\bcontexts\x18\x06 \x03(\v2\x17.config.v1beta1.ContextB\f\xbaH\t\x92\x01\x06\xd0\u0096\xb1\x02\x01R\bcontexts\x12(\n" +
	"\x0fcurrent_context\x18\a \x01(\tR\x0fcurrent-context\x12F\n" +
	"\n" +
	"extensions\x18\b \x03(\v2&.config.v1beta1.Config.ExtensionsEntryR\n" +
	"extensions\x1aV\n" +
	"\x0fExtensionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12-\n" +
	"\x05value\x18\x02 \x01(\v2\x17.google.protobuf.StructR\x05value:\x028\x01:\xf0\x03\xbaH\xec\x03\x1a\xa5\x01\n" +
	"\x16current_context_exists\x127current_context must reference an existing context name\x1aRthis.current_context == '' || this.current_context in this.contexts.map(c, c.name)\x1a\xab\x01\n" +
	"\x17context_instance_exists\x129context.instance must reference an existing instance name\x1aUthis.contexts.all(c, c.instance == '' || c.instance in this.instances.map(i, i.name))\x1a\x93\x01\n" +
	"\x13context_auth_exists\x121context.auth must reference an existing auth name\x1aIthis.contexts.all(c, c.auth == '' || c.auth in this.auths.map(a, a.name))\"\xd9\x02\n" +
	"\vPreferences\x12\x1c\n" +
	"\tretry_max\x18\x02 \x01(\x05R\tretry-max\x12A\n" +
	"\x0eretry_wait_min\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\x0eretry-wait-min\x12A\n" +
	"\x0eretry_wait_max\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\x0eretry-wait-max:\xa5\x01\xbaH\xa1\x01\x1a\x9e\x01\n" +
	"\x1aretry_wait_both_or_neither\x12Jretry_wait_min and retry_wait_max must both be provided or both be omitted\x1a4has(this.retry_wait_min) == has(this.retry_wait_max)\"\xd2\a\n" +
	"\bInstance\x12\x1e\n" +
	"\x04name\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x03R\x04name\x12V\n" +
	"\x06server\x18\x02 \x01(\tB>\xbaH;\xc8\x01\x01r6\x10\x01\x92\x02\x12https://gitlab.com\x92\x02\x19https://gitlab.com/api/v4\x88\x01\x01R\x06server\x12+\n" +
	"\vapi_version\x18\x03 \x01(\tB\t\xbaH\x06r\x04\n" +
	"\x02v4R\vapi-version\x126\n" +
	"\x15certificate_authority\x18\x04 \x01(\tH\x00R\x15certificate-authority\x12f\n" +
	"\x1ccertificate_authority_source\x18\x05 \x01(\v2 .config.v1beta1.CredentialSourceH\x00R\x1ccertificate-authority-source\x12\"\n" +
	"\vclient_cert\x18\x06 \x01(\tH\x01R\vclient-cert\x12R\n" +
	"\x12client_cert_source\x18\a \x01(\v2 .config.v1beta1.CredentialSourceH\x01R\x12client-cert-source\x12 \n" +
	"\n" +
	"client_key\x18\b \x01(\tH\x02R\n" +
	"client-key\x12P\n" +
	"\x11client_key_source\x18\t \x01(\v2 .config.v1beta1.CredentialSourceH\x02R\x11client-key-source\x12:\n" +
	"\x18insecure_skip_tls_verify\x18\n" +
	" \x01(\bR\x18insecure-skip-tls-verify\x129\n" +
	"\n" +
	"rate_limit\x18\v \x01(\v2\x19.config.v1beta1.RateLimitR\n" +
	"rate-limit\x12H\n" +
	"\n" +
	"extensions\x18\f \x03(\v2(.config.v1beta1.Instance.ExtensionsEntryR\n" +
	"extensions\x12>\n" +
	"\x0ecustom_headers\x18\r \x03(\v2\x16.config.v1beta1.HeaderR\x0ecustom-headers\x1aV\n" +
	"\x0fExtensionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12-\n" +
	"\x05value\x18\x02 \x01(\v2\x17.google.protobuf.StructR\x05value:\x028\x01B\r\n" +
	"\vinstance_caB\x16\n" +
	"\x14instance_client_certB\x15\n" +
	"\x13instance_client_key\"l\n" +
	"\tRateLimit\x12@\n" +
	"\x13requests_per_second\x18\x02 \x01(\x01B\x0e\xbaH\v\x12\t!\x00\x00\x00\x00\x00\x00\x00\x00R\x13requests-per-second\x12\x1d\n" +
	"\x05burst\x18\x03 \x01(\x05B\a\xbaH\x04\x1a\x02 \x00R\x05burst\"\xa4\x01\n" +
	"\x06Header\x12\x1e\n" +
	"\x04name\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x03R\x04name\x12\x1f\n" +
	"\x05value\x18\x02 \x01(\tB\a\xbaH\x04r\x02\x10\x01H\x00R\x05value\x12B\n" +
	"\n" +
	"value_from\x18\x03 \x01(\v2 .config.v1beta1.CredentialSourceH\x00R\n" +
	"value-fromB\x15\n" +
	"\fheader_value\x12\x05\xbaH\x02\b\x01\"q\n" +
	"\aContext\x12\x1e\n" +
	"\x04name\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x03R\x04name\x12&\n" +
	"\binstance\x18\x02 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x03R\binstance\x12\x1e\n" +
	"\x04auth\x18\x03 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x03R\x04auth\"f\n" +
	"\x04Auth\x12\x1e\n" +
	"\x04name\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x03R\x04name\x12>\n" +
	"\tauth_info\x18\x02 \x01(\v2\x18.config.v1beta1.AuthInfoB\x06\xbaH\x03\xc8\x01\x01R\tauth-info\"\xa8\x02\n" +
	"\bAuthInfo\x12[\n" +
	"\x15personal_access_token\x18\x01 \x01(\v2#.config.v1beta1.PersonalAccessTokenH\x00R\x15personal-access-token\x128\n" +
	"\tjob_token\x18\x02 \x01(\v2\x18.config.v1beta1.JobTokenH\x00R\tjob-token\x120\n" +
	"\x06oauth2\x18\x03 \x01(\v2\x16.config.v1beta1.OAuth2H\x00R\x06oauth2\x12;\n" +
	"\n" +
	"basic_auth\x18\x04 \x01(\v2\x19.config.v1beta1.BasicAuthH\x00R\n" +
	"basic-authB\x16\n" +
	"\rauth_provider\x12\x05\xbaH\x02\b\x01\"\x95\x01\n" +
	"\x13PersonalAccessToken\x12\x16\n" +
	"\x05token\x18\x01 \x01(\tH\x00R\x05token\x12F\n" +
	"\ftoken_source\x18\x02 \x01(\v2 .config.v1beta1.CredentialSourceH\x00R\ftoken-sourceB\x1e\n" +
	"\x15personal_access_token\x12\x05\xbaH\x02\b\x01\"~\n" +
	"\bJobToken\x12\x16\n" +
	"\x05token\x18\x01 \x01(\tH\x00R\x05token\x12F\n" +
	"\ftoken_source\x18\x02 \x01(\v2 .config.v1beta1.CredentialSourceH\x00R\ftoken-sourceB\x12\n" +
	"\tjob_token\x12\x05\xbaH\x02\b\x01\"\xa5\x04\n" +
	"\x06OAuth2\x12\x1c\n" +
	"\tclient_id\x18\x01 \x01(\tR\tclient-id\x12&\n" +
	"\rclient_secret\x18\x02 \x01(\tH\x00R\rclient-secret\x12V\n" +
	"\x14client_secret_source\x18\x03 \x01(\v2 .config.v1beta1.CredentialSourceH\x00R\x14client-secret-source\x12$\n" +
	"\faccess_token\x18\x04 \x01(\tH\x01R\faccess-token\x12T\n" +
	"\x13access_token_source\x18\x05 \x01(\v2 .config.v1beta1.CredentialSourceH\x01R\x13access-token-source\x12&\n" +
	"\rrefresh_token\x18\x06 \x01(\tH\x02R\rrefresh-token\x12V\n" +
	"\x14refresh_token_source\x18\a \x01(\v2 .config.v1beta1.CredentialSourceH\x02R\x14refresh-token-source\x12:\n" +
	"\n" +
	"expires_at\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"expires-atB\x16\n" +
	"\x14oauth2_client_secretB\x15\n" +
	"\x13oauth2_access_tokenB\x16\n" +
	"\x14oauth2_refresh_token\"\x9f\x02\n" +
	"\tBasicAuth\x12\x1c\n" +
	"\busername\x18\x01 \x01(\tH\x00R\busername\x12L\n" +
	"\x0fusername_source\x18\x02 \x01(\v2 .config.v1beta1.CredentialSourceH\x00R\x0fusername-source\x12\x1c\n" +
	"\bpassword\x18\x03 \x01(\tH\x01R\bpassword\x12L\n" +
	"\x0fpassword_source\x18\x04 \x01(\v2 .config.v1beta1.CredentialSourceH\x01R\x0fpassword-sourceB\x1c\n" +
	"\x13basic_auth_username\x12\x05\xbaH\x02\b\x01B\x1c\n" +
	"\x13basic_auth_password\x12\x05\xbaH\x02\b\x01\"\xf2\x01\n" +
	"\x0eExecCredential\x12$\n" +
	"\acommand\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x01R\acommand\x12\x12\n" +
	"\x04args\x18\x02 \x03(\tR\x04args\x129\n" +
	"\x03env\x18\x03 \x03(\v2'.config.v1beta1.ExecCredential.EnvEntryR\x03env\x123\n" +
	"\atimeout\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\atimeout\x1a6\n" +
	"\bEnvEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xde\x01\n" +
	"\x10CredentialSource\x12\x16\n" +
	"\x05value\x18\x01 \x01(\tH\x00R\x05value\x12\x1a\n" +
	"\aenv_var\x18\x02 \x01(\tH\x00R\aenv-var\x12\x14\n" +
	"\x04file\x18\x03 \x01(\tH\x00R\x04file\x124\n" +
	"\x04exec\x18\x04 \x01(\v2\x1e.config.v1beta1.ExecCredentialH\x00R\x04exec\x129\n" +
	"\akeyring\x18\x05 \x01(\v2\x1d.config.v1beta1.KeyringSourceH\x00R\akeyringB\x0f\n" +
	"\x06source\x12\x05\xbaH\x02\b\x01\"U\n" +
	"\rKeyringSource\x12$\n" +
	"\aservice\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x01R\aservice\x12\x1e\n" +
	"\x04user\x18\x02 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x10\x01R\x04user:\xbb\x01\n" +
	"\funique_names\x12\x1b.buf.validate.RepeatedRules\x18\xaa\xe8\x92& \x01(\bBx\xc2Hu\n" +
	"s\n" +
	"\funique_names\x12\x18all names must be unique\x1aIthis.map(i, i.name).all(name, this.filter(j, j.name == name).size() == 1)R\vuniqueNamesB4Z2gitlab.com/gitlab-org/api/client-go/config/v1beta1b\beditionsp\xe8\a"

var (
	file_config_v1beta1_config_proto_rawDescOnce sync.Once
	file_config_v1beta1_config_proto_rawDescData []byte
)

func file_config_v1beta1_config_proto_rawDescGZIP() []byte {
	file_config_v1beta1_config_proto_rawDescOnce.Do(func() {
		file_config_v1beta1_config_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_config_v1beta1_config_proto_rawDesc), len(file_config_v1beta1_config_proto_rawDesc)))
	})
	return file_config_v1beta1_config_proto_rawDescData
}

var file_config_v1beta1_config_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_config_v1beta1_config_proto_goTypes = []any{
	(*Config)(nil),                 // 0: config.v1beta1.Config
	(*Preferences)(nil),            // 1: config.v1beta1.Preferences
	(*Instance)(nil),               // 2: config.v1beta1.Instance
	(*RateLimit)(nil),              // 3: config.v1beta1.RateLimit
	(*Header)(nil),                 // 4: config.v1beta1.Header
	(*Context)(nil),                // 5: config.v1beta1.Context
	(*Auth)(nil),                   // 6: config.v1beta1.Auth
	(*AuthInfo)(nil),               // 7: config.v1beta1.AuthInfo
	(*PersonalAccessToken)(nil),    // 8: config.v1beta1.PersonalAccessToken
	(*JobToken)(nil),               // 9: config.v1beta1.JobToken
	(*OAuth2)(nil),                 // 10: config.v1beta1.OAuth2
	(*BasicAuth)(nil),              // 11: config.v1beta1.BasicAuth
	(*ExecCredential)(nil),         // 12: config.v1beta1.ExecCredential
	(*CredentialSource)(nil),       // 13: config.v1beta1.CredentialSource
	(*KeyringSource)(nil),          // 14: config.v1beta1.KeyringSource
	nil,                            // 15: config.v1beta1.Config.ExtensionsEntry
	nil,                            // 16: config.v1beta1.Instance.ExtensionsEntry
	nil,                            // 17: config.v1beta1.ExecCredential.EnvEntry
	(*durationpb.Duration)(nil),    // 18: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),  // 19: google.protobuf.Timestamp
	(*structpb.Struct)(nil),        // 20: google.protobuf.Struct
	(*validate.RepeatedRules)(nil), // 21: buf.validate.RepeatedRules
}
var file_config_v1beta1_config_proto_depIdxs = []int32{
	1,  // 0: config.v1beta1.Config.preferences:type_name -> config.v1beta1.Preferences
	2,  // 1: config.v1beta1.Config.instances:type_name -> config.v1beta1.Instance
	6,  // 2: config.v1beta1.Config.auths:type_name -> config.v1beta1.Auth
	5,  // 3: config.v1beta1.Config.contexts:type_name -> config.v1beta1.Context
	15, // 4: config.v1beta1.Config.extensions:type_name -> config.v1beta1.Config.ExtensionsEntry
	18, // 5: config.v1beta1.Preferences.retry_wait_min:type_name -> google.protobuf.Duration
	18, // 6: config.v1beta1.Preferences.retry_wait_max:type_name -> google.protobuf.Duration
	13, // 7: config.v1beta1.Instance.certificate_authority_source:type_name -> config.v1beta1.CredentialSource
	13, // 8: config.v1beta1.Instance.client_cert_source:type_name -> config.v1beta1.CredentialSource
	13, // 9: config.v1beta1.Instance.client_key_source:type_name -> config.v1beta1.CredentialSource
	3,  // 10: config.v1beta1.Instance.rate_limit:type_name -> config.v1beta1.RateLimit
	16, // 11: config.v1beta1.Instance.extensions:type_name -> config.v1beta1.Instance.ExtensionsEntry
	4,  // 12: config.v1beta1.Instance.custom_headers:type_name -> config.v1beta1.Header
	13, // 13: config.v1beta1.Header.value_from:type_name -> config.v1beta1.CredentialSource
	7,  // 14: config.v1beta1.Auth.auth_info:type_name -> config.v1beta1.AuthInfo
	8,  // 15: config.v1beta1.AuthInfo.personal_access_token:type_name -> config.v1beta1.PersonalAccessToken
	9,  // 16: config.v1beta1.AuthInfo.job_token:type_name -> config.v1beta1.JobToken
	10, // 17: config.v1beta1.AuthInfo.oauth2:type_name -> config.v1beta1.OAuth2
	11, // 18: config.v1beta1.AuthInfo.basic_auth:type_name -> config.v1beta1.BasicAuth
	13, // 19: config.v1beta1.PersonalAccessToken.token_source:type_name -> config.v1beta1.CredentialSource
	13, // 20: config.v1beta1.JobToken.token_source:type_name -> config.v1beta1.CredentialSource
	13, // 21: config.v1beta1.OAuth2.client_secret_source:type_name -> config.v1beta1.CredentialSource
	13, // 22: config.v1beta1.OAuth2.access_token_source:type_name -> config.v1beta1.CredentialSource
	13, // 23: config.v1beta1.OAuth2.refresh_token_source:type_name -> config.v1beta1.CredentialSource
	19, // 24: config.v1beta1.OAuth2.expires_at:type_name -> google.protobuf.Timestamp
	13, // 25: config.v1beta1.BasicAuth.username_source:type_name -> config.v1beta1.CredentialSource
	13, // 26: config.v1beta1.BasicAuth.password_source:type_name -> config.v1beta1.CredentialSource
	17, // 27: config.v1beta1.ExecCredential.env:type_name -> config.v1beta1.ExecCredential.EnvEntry
	18, // 28: config.v1beta1.ExecCredential.timeout:type_name -> google.protobuf.Duration
	12, // 29: config.v1beta1.CredentialSource.exec:type_name -> config.v1beta1.ExecCredential
	14, // 30: config.v1beta1.CredentialSource.keyring:type_name -> config.v1beta1.KeyringSource
	20, // 31: config.v1beta1.Config.ExtensionsEntry.value:type_name -> google.protobuf.Struct
	20, // 32: config.v1beta1.Instance.ExtensionsEntry.value:type_name -> google.protobuf.Struct
	21, // 33: config.v1beta1.unique_names:extendee -> buf.validate.RepeatedRules
	34, // [34:34] is the sub-list for method output_type
	34, // [34:34] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	33, // [33:34] is the sub-list for extension extendee
	0,  // [0:33] is the sub-list for field type_name
}

func init() { file_config_v1beta1_config_proto_init() }
func file_config_v1beta1_config_proto_init() {
	if File_config_v1beta1_config_proto != nil {
		return
	}
	file_config_v1beta1_config_proto_msgTypes[2].OneofWrappers = []any{
		(*Instance_CertificateAuthority)(nil),
		(*Instance_CertificateAuthoritySource)(nil),
		(*Instance_ClientCert)(nil),
		(*Instance_ClientCertSource)(nil),
		(*Instance_ClientKey)(nil),
		(*Instance_ClientKeySource)(nil),
	}
	file_config_v1beta1_config_proto_msgTypes[4].OneofWrappers = []any{
		(*Header_Value)(nil),
		(*Header_ValueFrom)(nil),
	}
	file_config_v1beta1_config_proto_msgTypes[7].OneofWrappers = []any{
		(*AuthInfo_PersonalAccessToken)(nil),
		(*AuthInfo_JobToken)(nil),
		(*AuthInfo_Oauth2)(nil),
		(*AuthInfo_BasicAuth)(nil),
	}
	file_config_v1beta1_config_proto_msgTypes[8].OneofWrappers = []any{
		(*PersonalAccessToken_Token)(nil),
		(*PersonalAccessToken_TokenSource)(nil),
	}
	file_config_v1beta1_config_proto_msgTypes[9].OneofWrappers = []any{
		(*JobToken_Token)(nil),
		(*JobToken_TokenSource)(nil),
	}
	file_config_v1beta1_config_proto_msgTypes[10].OneofWrappers = []any{
		(*OAuth2_ClientSecret)(nil),
		(*OAuth2_ClientSecretSource)(nil),
		(*OAuth2_AccessToken)(nil),
		(*OAuth2_AccessTokenSource)(nil),
		(*OAuth2_RefreshToken)(nil),
		(*OAuth2_RefreshTokenSource)(nil),
	}
	file_config_v1beta1_config_proto_msgTypes[11].OneofWrappers = []any{
		(*BasicAuth_Username)(nil),
		(*BasicAuth_UsernameSource)(nil),
		(*BasicAuth_Password)(nil),
		(*BasicAuth_PasswordSource)(nil),
	}
	file_config_v1beta1_config_proto_msgTypes[13].OneofWrappers = []any{
		(*CredentialSource_Value)(nil),
		(*CredentialSource_EnvVar)(nil),
		(*CredentialSource_File)(nil),
		(*CredentialSource_Exec)(nil),
		(*CredentialSource_Keyring)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_config_v1beta1_config_proto_rawDesc), len(file_config_v1beta1_config_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 1,
			NumServices:   0,
		},
		GoTypes:           file_config_v1beta1_config_proto_goTypes,
		DependencyIndexes: file_config_v1beta1_config_proto_depIdxs,
		MessageInfos:      file_config_v1beta1_config_proto_msgTypes,
		ExtensionInfos:    file_config_v1beta1_config_proto_extTypes,
	}.Build()
	File_config_v1beta1_config_proto = out.File
	file_config_v1beta1_config_proto_goTypes = nil
	file_config_v1beta1_config_proto_depIdxs = nil
}
