// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataplex/v1/metadata.proto

package dataplexpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MetadataService_CreateEntity_FullMethodName    = "/google.cloud.dataplex.v1.MetadataService/CreateEntity"
	MetadataService_UpdateEntity_FullMethodName    = "/google.cloud.dataplex.v1.MetadataService/UpdateEntity"
	MetadataService_DeleteEntity_FullMethodName    = "/google.cloud.dataplex.v1.MetadataService/DeleteEntity"
	MetadataService_GetEntity_FullMethodName       = "/google.cloud.dataplex.v1.MetadataService/GetEntity"
	MetadataService_ListEntities_FullMethodName    = "/google.cloud.dataplex.v1.MetadataService/ListEntities"
	MetadataService_CreatePartition_FullMethodName = "/google.cloud.dataplex.v1.MetadataService/CreatePartition"
	MetadataService_DeletePartition_FullMethodName = "/google.cloud.dataplex.v1.MetadataService/DeletePartition"
	MetadataService_GetPartition_FullMethodName    = "/google.cloud.dataplex.v1.MetadataService/GetPartition"
	MetadataService_ListPartitions_FullMethodName  = "/google.cloud.dataplex.v1.MetadataService/ListPartitions"
)

// MetadataServiceClient is the client API for MetadataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MetadataServiceClient interface {
	// Create a metadata entity.
	CreateEntity(ctx context.Context, in *CreateEntityRequest, opts ...grpc.CallOption) (*Entity, error)
	// Update a metadata entity. Only supports full resource update.
	UpdateEntity(ctx context.Context, in *UpdateEntityRequest, opts ...grpc.CallOption) (*Entity, error)
	// Delete a metadata entity.
	DeleteEntity(ctx context.Context, in *DeleteEntityRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get a metadata entity.
	GetEntity(ctx context.Context, in *GetEntityRequest, opts ...grpc.CallOption) (*Entity, error)
	// List metadata entities in a zone.
	ListEntities(ctx context.Context, in *ListEntitiesRequest, opts ...grpc.CallOption) (*ListEntitiesResponse, error)
	// Create a metadata partition.
	CreatePartition(ctx context.Context, in *CreatePartitionRequest, opts ...grpc.CallOption) (*Partition, error)
	// Delete a metadata partition.
	DeletePartition(ctx context.Context, in *DeletePartitionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get a metadata partition of an entity.
	GetPartition(ctx context.Context, in *GetPartitionRequest, opts ...grpc.CallOption) (*Partition, error)
	// List metadata partitions of an entity.
	ListPartitions(ctx context.Context, in *ListPartitionsRequest, opts ...grpc.CallOption) (*ListPartitionsResponse, error)
}

type metadataServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetadataServiceClient(cc grpc.ClientConnInterface) MetadataServiceClient {
	return &metadataServiceClient{cc}
}

func (c *metadataServiceClient) CreateEntity(ctx context.Context, in *CreateEntityRequest, opts ...grpc.CallOption) (*Entity, error) {
	out := new(Entity)
	err := c.cc.Invoke(ctx, MetadataService_CreateEntity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) UpdateEntity(ctx context.Context, in *UpdateEntityRequest, opts ...grpc.CallOption) (*Entity, error) {
	out := new(Entity)
	err := c.cc.Invoke(ctx, MetadataService_UpdateEntity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteEntity(ctx context.Context, in *DeleteEntityRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, MetadataService_DeleteEntity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetEntity(ctx context.Context, in *GetEntityRequest, opts ...grpc.CallOption) (*Entity, error) {
	out := new(Entity)
	err := c.cc.Invoke(ctx, MetadataService_GetEntity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListEntities(ctx context.Context, in *ListEntitiesRequest, opts ...grpc.CallOption) (*ListEntitiesResponse, error) {
	out := new(ListEntitiesResponse)
	err := c.cc.Invoke(ctx, MetadataService_ListEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreatePartition(ctx context.Context, in *CreatePartitionRequest, opts ...grpc.CallOption) (*Partition, error) {
	out := new(Partition)
	err := c.cc.Invoke(ctx, MetadataService_CreatePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeletePartition(ctx context.Context, in *DeletePartitionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, MetadataService_DeletePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetPartition(ctx context.Context, in *GetPartitionRequest, opts ...grpc.CallOption) (*Partition, error) {
	out := new(Partition)
	err := c.cc.Invoke(ctx, MetadataService_GetPartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListPartitions(ctx context.Context, in *ListPartitionsRequest, opts ...grpc.CallOption) (*ListPartitionsResponse, error) {
	out := new(ListPartitionsResponse)
	err := c.cc.Invoke(ctx, MetadataService_ListPartitions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetadataServiceServer is the server API for MetadataService service.
// All implementations should embed UnimplementedMetadataServiceServer
// for forward compatibility
type MetadataServiceServer interface {
	// Create a metadata entity.
	CreateEntity(context.Context, *CreateEntityRequest) (*Entity, error)
	// Update a metadata entity. Only supports full resource update.
	UpdateEntity(context.Context, *UpdateEntityRequest) (*Entity, error)
	// Delete a metadata entity.
	DeleteEntity(context.Context, *DeleteEntityRequest) (*emptypb.Empty, error)
	// Get a metadata entity.
	GetEntity(context.Context, *GetEntityRequest) (*Entity, error)
	// List metadata entities in a zone.
	ListEntities(context.Context, *ListEntitiesRequest) (*ListEntitiesResponse, error)
	// Create a metadata partition.
	CreatePartition(context.Context, *CreatePartitionRequest) (*Partition, error)
	// Delete a metadata partition.
	DeletePartition(context.Context, *DeletePartitionRequest) (*emptypb.Empty, error)
	// Get a metadata partition of an entity.
	GetPartition(context.Context, *GetPartitionRequest) (*Partition, error)
	// List metadata partitions of an entity.
	ListPartitions(context.Context, *ListPartitionsRequest) (*ListPartitionsResponse, error)
}

// UnimplementedMetadataServiceServer should be embedded to have forward compatible implementations.
type UnimplementedMetadataServiceServer struct {
}

func (UnimplementedMetadataServiceServer) CreateEntity(context.Context, *CreateEntityRequest) (*Entity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntity not implemented")
}
func (UnimplementedMetadataServiceServer) UpdateEntity(context.Context, *UpdateEntityRequest) (*Entity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntity not implemented")
}
func (UnimplementedMetadataServiceServer) DeleteEntity(context.Context, *DeleteEntityRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntity not implemented")
}
func (UnimplementedMetadataServiceServer) GetEntity(context.Context, *GetEntityRequest) (*Entity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntity not implemented")
}
func (UnimplementedMetadataServiceServer) ListEntities(context.Context, *ListEntitiesRequest) (*ListEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntities not implemented")
}
func (UnimplementedMetadataServiceServer) CreatePartition(context.Context, *CreatePartitionRequest) (*Partition, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePartition not implemented")
}
func (UnimplementedMetadataServiceServer) DeletePartition(context.Context, *DeletePartitionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePartition not implemented")
}
func (UnimplementedMetadataServiceServer) GetPartition(context.Context, *GetPartitionRequest) (*Partition, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPartition not implemented")
}
func (UnimplementedMetadataServiceServer) ListPartitions(context.Context, *ListPartitionsRequest) (*ListPartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPartitions not implemented")
}

// UnsafeMetadataServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MetadataServiceServer will
// result in compilation errors.
type UnsafeMetadataServiceServer interface {
	mustEmbedUnimplementedMetadataServiceServer()
}

func RegisterMetadataServiceServer(s grpc.ServiceRegistrar, srv MetadataServiceServer) {
	s.RegisterService(&MetadataService_ServiceDesc, srv)
}

func _MetadataService_CreateEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_CreateEntity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateEntity(ctx, req.(*CreateEntityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_UpdateEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).UpdateEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_UpdateEntity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).UpdateEntity(ctx, req.(*UpdateEntityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_DeleteEntity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteEntity(ctx, req.(*DeleteEntityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetEntity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetEntity(ctx, req.(*GetEntityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_ListEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListEntities(ctx, req.(*ListEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreatePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreatePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_CreatePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreatePartition(ctx, req.(*CreatePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeletePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeletePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_DeletePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeletePartition(ctx, req.(*DeletePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetPartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetPartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetPartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetPartition(ctx, req.(*GetPartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListPartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListPartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_ListPartitions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListPartitions(ctx, req.(*ListPartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MetadataService_ServiceDesc is the grpc.ServiceDesc for MetadataService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MetadataService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataplex.v1.MetadataService",
	HandlerType: (*MetadataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateEntity",
			Handler:    _MetadataService_CreateEntity_Handler,
		},
		{
			MethodName: "UpdateEntity",
			Handler:    _MetadataService_UpdateEntity_Handler,
		},
		{
			MethodName: "DeleteEntity",
			Handler:    _MetadataService_DeleteEntity_Handler,
		},
		{
			MethodName: "GetEntity",
			Handler:    _MetadataService_GetEntity_Handler,
		},
		{
			MethodName: "ListEntities",
			Handler:    _MetadataService_ListEntities_Handler,
		},
		{
			MethodName: "CreatePartition",
			Handler:    _MetadataService_CreatePartition_Handler,
		},
		{
			MethodName: "DeletePartition",
			Handler:    _MetadataService_DeletePartition_Handler,
		},
		{
			MethodName: "GetPartition",
			Handler:    _MetadataService_GetPartition_Handler,
		},
		{
			MethodName: "ListPartitions",
			Handler:    _MetadataService_ListPartitions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataplex/v1/metadata.proto",
}
