// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package dataplex

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"

	dataplexpb "cloud.google.com/go/dataplex/apiv1/dataplexpb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newBusinessGlossaryClientHook clientHook

// BusinessGlossaryCallOptions contains the retry settings for each method of BusinessGlossaryClient.
type BusinessGlossaryCallOptions struct {
	CreateGlossary         []gax.CallOption
	UpdateGlossary         []gax.CallOption
	DeleteGlossary         []gax.CallOption
	GetGlossary            []gax.CallOption
	ListGlossaries         []gax.CallOption
	CreateGlossaryCategory []gax.CallOption
	UpdateGlossaryCategory []gax.CallOption
	DeleteGlossaryCategory []gax.CallOption
	GetGlossaryCategory    []gax.CallOption
	ListGlossaryCategories []gax.CallOption
	CreateGlossaryTerm     []gax.CallOption
	UpdateGlossaryTerm     []gax.CallOption
	DeleteGlossaryTerm     []gax.CallOption
	GetGlossaryTerm        []gax.CallOption
	ListGlossaryTerms      []gax.CallOption
	GetLocation            []gax.CallOption
	ListLocations          []gax.CallOption
	CancelOperation        []gax.CallOption
	DeleteOperation        []gax.CallOption
	GetOperation           []gax.CallOption
	ListOperations         []gax.CallOption
}

func defaultBusinessGlossaryGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("dataplex.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("dataplex.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("dataplex.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://dataplex.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultBusinessGlossaryCallOptions() *BusinessGlossaryCallOptions {
	return &BusinessGlossaryCallOptions{
		CreateGlossary:         []gax.CallOption{},
		UpdateGlossary:         []gax.CallOption{},
		DeleteGlossary:         []gax.CallOption{},
		GetGlossary:            []gax.CallOption{},
		ListGlossaries:         []gax.CallOption{},
		CreateGlossaryCategory: []gax.CallOption{},
		UpdateGlossaryCategory: []gax.CallOption{},
		DeleteGlossaryCategory: []gax.CallOption{},
		GetGlossaryCategory:    []gax.CallOption{},
		ListGlossaryCategories: []gax.CallOption{},
		CreateGlossaryTerm:     []gax.CallOption{},
		UpdateGlossaryTerm:     []gax.CallOption{},
		DeleteGlossaryTerm:     []gax.CallOption{},
		GetGlossaryTerm:        []gax.CallOption{},
		ListGlossaryTerms:      []gax.CallOption{},
		GetLocation:            []gax.CallOption{},
		ListLocations:          []gax.CallOption{},
		CancelOperation:        []gax.CallOption{},
		DeleteOperation:        []gax.CallOption{},
		GetOperation:           []gax.CallOption{},
		ListOperations:         []gax.CallOption{},
	}
}

func defaultBusinessGlossaryRESTCallOptions() *BusinessGlossaryCallOptions {
	return &BusinessGlossaryCallOptions{
		CreateGlossary:         []gax.CallOption{},
		UpdateGlossary:         []gax.CallOption{},
		DeleteGlossary:         []gax.CallOption{},
		GetGlossary:            []gax.CallOption{},
		ListGlossaries:         []gax.CallOption{},
		CreateGlossaryCategory: []gax.CallOption{},
		UpdateGlossaryCategory: []gax.CallOption{},
		DeleteGlossaryCategory: []gax.CallOption{},
		GetGlossaryCategory:    []gax.CallOption{},
		ListGlossaryCategories: []gax.CallOption{},
		CreateGlossaryTerm:     []gax.CallOption{},
		UpdateGlossaryTerm:     []gax.CallOption{},
		DeleteGlossaryTerm:     []gax.CallOption{},
		GetGlossaryTerm:        []gax.CallOption{},
		ListGlossaryTerms:      []gax.CallOption{},
		GetLocation:            []gax.CallOption{},
		ListLocations:          []gax.CallOption{},
		CancelOperation:        []gax.CallOption{},
		DeleteOperation:        []gax.CallOption{},
		GetOperation:           []gax.CallOption{},
		ListOperations:         []gax.CallOption{},
	}
}

// internalBusinessGlossaryClient is an interface that defines the methods available from Cloud Dataplex API.
type internalBusinessGlossaryClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateGlossary(context.Context, *dataplexpb.CreateGlossaryRequest, ...gax.CallOption) (*CreateGlossaryOperation, error)
	CreateGlossaryOperation(name string) *CreateGlossaryOperation
	UpdateGlossary(context.Context, *dataplexpb.UpdateGlossaryRequest, ...gax.CallOption) (*UpdateGlossaryOperation, error)
	UpdateGlossaryOperation(name string) *UpdateGlossaryOperation
	DeleteGlossary(context.Context, *dataplexpb.DeleteGlossaryRequest, ...gax.CallOption) (*DeleteGlossaryOperation, error)
	DeleteGlossaryOperation(name string) *DeleteGlossaryOperation
	GetGlossary(context.Context, *dataplexpb.GetGlossaryRequest, ...gax.CallOption) (*dataplexpb.Glossary, error)
	ListGlossaries(context.Context, *dataplexpb.ListGlossariesRequest, ...gax.CallOption) *GlossaryIterator
	CreateGlossaryCategory(context.Context, *dataplexpb.CreateGlossaryCategoryRequest, ...gax.CallOption) (*dataplexpb.GlossaryCategory, error)
	UpdateGlossaryCategory(context.Context, *dataplexpb.UpdateGlossaryCategoryRequest, ...gax.CallOption) (*dataplexpb.GlossaryCategory, error)
	DeleteGlossaryCategory(context.Context, *dataplexpb.DeleteGlossaryCategoryRequest, ...gax.CallOption) error
	GetGlossaryCategory(context.Context, *dataplexpb.GetGlossaryCategoryRequest, ...gax.CallOption) (*dataplexpb.GlossaryCategory, error)
	ListGlossaryCategories(context.Context, *dataplexpb.ListGlossaryCategoriesRequest, ...gax.CallOption) *GlossaryCategoryIterator
	CreateGlossaryTerm(context.Context, *dataplexpb.CreateGlossaryTermRequest, ...gax.CallOption) (*dataplexpb.GlossaryTerm, error)
	UpdateGlossaryTerm(context.Context, *dataplexpb.UpdateGlossaryTermRequest, ...gax.CallOption) (*dataplexpb.GlossaryTerm, error)
	DeleteGlossaryTerm(context.Context, *dataplexpb.DeleteGlossaryTermRequest, ...gax.CallOption) error
	GetGlossaryTerm(context.Context, *dataplexpb.GetGlossaryTermRequest, ...gax.CallOption) (*dataplexpb.GlossaryTerm, error)
	ListGlossaryTerms(context.Context, *dataplexpb.ListGlossaryTermsRequest, ...gax.CallOption) *GlossaryTermIterator
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// BusinessGlossaryClient is a client for interacting with Cloud Dataplex API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// BusinessGlossaryService provides APIs for managing business glossary
// resources for enterprise customers.
// The resources currently supported in Business Glossary are:
//
// # Glossary
//
// # GlossaryCategory
//
// GlossaryTerm
type BusinessGlossaryClient struct {
	// The internal transport-dependent client.
	internalClient internalBusinessGlossaryClient

	// The call options for this service.
	CallOptions *BusinessGlossaryCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *BusinessGlossaryClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *BusinessGlossaryClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *BusinessGlossaryClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateGlossary creates a new Glossary resource.
func (c *BusinessGlossaryClient) CreateGlossary(ctx context.Context, req *dataplexpb.CreateGlossaryRequest, opts ...gax.CallOption) (*CreateGlossaryOperation, error) {
	return c.internalClient.CreateGlossary(ctx, req, opts...)
}

// CreateGlossaryOperation returns a new CreateGlossaryOperation from a given name.
// The name must be that of a previously created CreateGlossaryOperation, possibly from a different process.
func (c *BusinessGlossaryClient) CreateGlossaryOperation(name string) *CreateGlossaryOperation {
	return c.internalClient.CreateGlossaryOperation(name)
}

// UpdateGlossary updates a Glossary resource.
func (c *BusinessGlossaryClient) UpdateGlossary(ctx context.Context, req *dataplexpb.UpdateGlossaryRequest, opts ...gax.CallOption) (*UpdateGlossaryOperation, error) {
	return c.internalClient.UpdateGlossary(ctx, req, opts...)
}

// UpdateGlossaryOperation returns a new UpdateGlossaryOperation from a given name.
// The name must be that of a previously created UpdateGlossaryOperation, possibly from a different process.
func (c *BusinessGlossaryClient) UpdateGlossaryOperation(name string) *UpdateGlossaryOperation {
	return c.internalClient.UpdateGlossaryOperation(name)
}

// DeleteGlossary deletes a Glossary resource. All the categories and terms within the
// Glossary must be deleted before the Glossary can be deleted.
func (c *BusinessGlossaryClient) DeleteGlossary(ctx context.Context, req *dataplexpb.DeleteGlossaryRequest, opts ...gax.CallOption) (*DeleteGlossaryOperation, error) {
	return c.internalClient.DeleteGlossary(ctx, req, opts...)
}

// DeleteGlossaryOperation returns a new DeleteGlossaryOperation from a given name.
// The name must be that of a previously created DeleteGlossaryOperation, possibly from a different process.
func (c *BusinessGlossaryClient) DeleteGlossaryOperation(name string) *DeleteGlossaryOperation {
	return c.internalClient.DeleteGlossaryOperation(name)
}

// GetGlossary gets a Glossary resource.
func (c *BusinessGlossaryClient) GetGlossary(ctx context.Context, req *dataplexpb.GetGlossaryRequest, opts ...gax.CallOption) (*dataplexpb.Glossary, error) {
	return c.internalClient.GetGlossary(ctx, req, opts...)
}

// ListGlossaries lists Glossary resources in a project and location.
func (c *BusinessGlossaryClient) ListGlossaries(ctx context.Context, req *dataplexpb.ListGlossariesRequest, opts ...gax.CallOption) *GlossaryIterator {
	return c.internalClient.ListGlossaries(ctx, req, opts...)
}

// CreateGlossaryCategory creates a new GlossaryCategory resource.
func (c *BusinessGlossaryClient) CreateGlossaryCategory(ctx context.Context, req *dataplexpb.CreateGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	return c.internalClient.CreateGlossaryCategory(ctx, req, opts...)
}

// UpdateGlossaryCategory updates a GlossaryCategory resource.
func (c *BusinessGlossaryClient) UpdateGlossaryCategory(ctx context.Context, req *dataplexpb.UpdateGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	return c.internalClient.UpdateGlossaryCategory(ctx, req, opts...)
}

// DeleteGlossaryCategory deletes a GlossaryCategory resource. All the GlossaryCategories and
// GlossaryTerms nested directly under the specified GlossaryCategory will be
// moved one level up to the parent in the hierarchy.
func (c *BusinessGlossaryClient) DeleteGlossaryCategory(ctx context.Context, req *dataplexpb.DeleteGlossaryCategoryRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteGlossaryCategory(ctx, req, opts...)
}

// GetGlossaryCategory gets a GlossaryCategory resource.
func (c *BusinessGlossaryClient) GetGlossaryCategory(ctx context.Context, req *dataplexpb.GetGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	return c.internalClient.GetGlossaryCategory(ctx, req, opts...)
}

// ListGlossaryCategories lists GlossaryCategory resources in a Glossary.
func (c *BusinessGlossaryClient) ListGlossaryCategories(ctx context.Context, req *dataplexpb.ListGlossaryCategoriesRequest, opts ...gax.CallOption) *GlossaryCategoryIterator {
	return c.internalClient.ListGlossaryCategories(ctx, req, opts...)
}

// CreateGlossaryTerm creates a new GlossaryTerm resource.
func (c *BusinessGlossaryClient) CreateGlossaryTerm(ctx context.Context, req *dataplexpb.CreateGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	return c.internalClient.CreateGlossaryTerm(ctx, req, opts...)
}

// UpdateGlossaryTerm updates a GlossaryTerm resource.
func (c *BusinessGlossaryClient) UpdateGlossaryTerm(ctx context.Context, req *dataplexpb.UpdateGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	return c.internalClient.UpdateGlossaryTerm(ctx, req, opts...)
}

// DeleteGlossaryTerm deletes a GlossaryTerm resource.
func (c *BusinessGlossaryClient) DeleteGlossaryTerm(ctx context.Context, req *dataplexpb.DeleteGlossaryTermRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteGlossaryTerm(ctx, req, opts...)
}

// GetGlossaryTerm gets a GlossaryTerm resource.
func (c *BusinessGlossaryClient) GetGlossaryTerm(ctx context.Context, req *dataplexpb.GetGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	return c.internalClient.GetGlossaryTerm(ctx, req, opts...)
}

// ListGlossaryTerms lists GlossaryTerm resources in a Glossary.
func (c *BusinessGlossaryClient) ListGlossaryTerms(ctx context.Context, req *dataplexpb.ListGlossaryTermsRequest, opts ...gax.CallOption) *GlossaryTermIterator {
	return c.internalClient.ListGlossaryTerms(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *BusinessGlossaryClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *BusinessGlossaryClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *BusinessGlossaryClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *BusinessGlossaryClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *BusinessGlossaryClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *BusinessGlossaryClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// businessGlossaryGRPCClient is a client for interacting with Cloud Dataplex API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type businessGlossaryGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing BusinessGlossaryClient
	CallOptions **BusinessGlossaryCallOptions

	// The gRPC API client.
	businessGlossaryClient dataplexpb.BusinessGlossaryServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewBusinessGlossaryClient creates a new business glossary service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// BusinessGlossaryService provides APIs for managing business glossary
// resources for enterprise customers.
// The resources currently supported in Business Glossary are:
//
// # Glossary
//
// # GlossaryCategory
//
// GlossaryTerm
func NewBusinessGlossaryClient(ctx context.Context, opts ...option.ClientOption) (*BusinessGlossaryClient, error) {
	clientOpts := defaultBusinessGlossaryGRPCClientOptions()
	if newBusinessGlossaryClientHook != nil {
		hookOpts, err := newBusinessGlossaryClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := BusinessGlossaryClient{CallOptions: defaultBusinessGlossaryCallOptions()}

	c := &businessGlossaryGRPCClient{
		connPool:               connPool,
		businessGlossaryClient: dataplexpb.NewBusinessGlossaryServiceClient(connPool),
		CallOptions:            &client.CallOptions,
		logger:                 internaloption.GetLogger(opts),
		operationsClient:       longrunningpb.NewOperationsClient(connPool),
		locationsClient:        locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *businessGlossaryGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *businessGlossaryGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *businessGlossaryGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type businessGlossaryRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing BusinessGlossaryClient
	CallOptions **BusinessGlossaryCallOptions

	logger *slog.Logger
}

// NewBusinessGlossaryRESTClient creates a new business glossary service rest client.
//
// BusinessGlossaryService provides APIs for managing business glossary
// resources for enterprise customers.
// The resources currently supported in Business Glossary are:
//
// # Glossary
//
// # GlossaryCategory
//
// GlossaryTerm
func NewBusinessGlossaryRESTClient(ctx context.Context, opts ...option.ClientOption) (*BusinessGlossaryClient, error) {
	clientOpts := append(defaultBusinessGlossaryRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultBusinessGlossaryRESTCallOptions()
	c := &businessGlossaryRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &BusinessGlossaryClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultBusinessGlossaryRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://dataplex.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://dataplex.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://dataplex.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://dataplex.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *businessGlossaryRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN", "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *businessGlossaryRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *businessGlossaryRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *businessGlossaryGRPCClient) CreateGlossary(ctx context.Context, req *dataplexpb.CreateGlossaryRequest, opts ...gax.CallOption) (*CreateGlossaryOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGlossary[0:len((*c.CallOptions).CreateGlossary):len((*c.CallOptions).CreateGlossary)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.CreateGlossary, req, settings.GRPC, c.logger, "CreateGlossary")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateGlossaryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *businessGlossaryGRPCClient) UpdateGlossary(ctx context.Context, req *dataplexpb.UpdateGlossaryRequest, opts ...gax.CallOption) (*UpdateGlossaryOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "glossary.name", url.QueryEscape(req.GetGlossary().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGlossary[0:len((*c.CallOptions).UpdateGlossary):len((*c.CallOptions).UpdateGlossary)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.UpdateGlossary, req, settings.GRPC, c.logger, "UpdateGlossary")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateGlossaryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *businessGlossaryGRPCClient) DeleteGlossary(ctx context.Context, req *dataplexpb.DeleteGlossaryRequest, opts ...gax.CallOption) (*DeleteGlossaryOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteGlossary[0:len((*c.CallOptions).DeleteGlossary):len((*c.CallOptions).DeleteGlossary)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.DeleteGlossary, req, settings.GRPC, c.logger, "DeleteGlossary")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteGlossaryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *businessGlossaryGRPCClient) GetGlossary(ctx context.Context, req *dataplexpb.GetGlossaryRequest, opts ...gax.CallOption) (*dataplexpb.Glossary, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGlossary[0:len((*c.CallOptions).GetGlossary):len((*c.CallOptions).GetGlossary)], opts...)
	var resp *dataplexpb.Glossary
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.GetGlossary, req, settings.GRPC, c.logger, "GetGlossary")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) ListGlossaries(ctx context.Context, req *dataplexpb.ListGlossariesRequest, opts ...gax.CallOption) *GlossaryIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGlossaries[0:len((*c.CallOptions).ListGlossaries):len((*c.CallOptions).ListGlossaries)], opts...)
	it := &GlossaryIterator{}
	req = proto.Clone(req).(*dataplexpb.ListGlossariesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*dataplexpb.Glossary, string, error) {
		resp := &dataplexpb.ListGlossariesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.businessGlossaryClient.ListGlossaries, req, settings.GRPC, c.logger, "ListGlossaries")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGlossaries(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *businessGlossaryGRPCClient) CreateGlossaryCategory(ctx context.Context, req *dataplexpb.CreateGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGlossaryCategory[0:len((*c.CallOptions).CreateGlossaryCategory):len((*c.CallOptions).CreateGlossaryCategory)], opts...)
	var resp *dataplexpb.GlossaryCategory
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.CreateGlossaryCategory, req, settings.GRPC, c.logger, "CreateGlossaryCategory")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) UpdateGlossaryCategory(ctx context.Context, req *dataplexpb.UpdateGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "category.name", url.QueryEscape(req.GetCategory().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGlossaryCategory[0:len((*c.CallOptions).UpdateGlossaryCategory):len((*c.CallOptions).UpdateGlossaryCategory)], opts...)
	var resp *dataplexpb.GlossaryCategory
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.UpdateGlossaryCategory, req, settings.GRPC, c.logger, "UpdateGlossaryCategory")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) DeleteGlossaryCategory(ctx context.Context, req *dataplexpb.DeleteGlossaryCategoryRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteGlossaryCategory[0:len((*c.CallOptions).DeleteGlossaryCategory):len((*c.CallOptions).DeleteGlossaryCategory)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.businessGlossaryClient.DeleteGlossaryCategory, req, settings.GRPC, c.logger, "DeleteGlossaryCategory")
		return err
	}, opts...)
	return err
}

func (c *businessGlossaryGRPCClient) GetGlossaryCategory(ctx context.Context, req *dataplexpb.GetGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGlossaryCategory[0:len((*c.CallOptions).GetGlossaryCategory):len((*c.CallOptions).GetGlossaryCategory)], opts...)
	var resp *dataplexpb.GlossaryCategory
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.GetGlossaryCategory, req, settings.GRPC, c.logger, "GetGlossaryCategory")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) ListGlossaryCategories(ctx context.Context, req *dataplexpb.ListGlossaryCategoriesRequest, opts ...gax.CallOption) *GlossaryCategoryIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGlossaryCategories[0:len((*c.CallOptions).ListGlossaryCategories):len((*c.CallOptions).ListGlossaryCategories)], opts...)
	it := &GlossaryCategoryIterator{}
	req = proto.Clone(req).(*dataplexpb.ListGlossaryCategoriesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*dataplexpb.GlossaryCategory, string, error) {
		resp := &dataplexpb.ListGlossaryCategoriesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.businessGlossaryClient.ListGlossaryCategories, req, settings.GRPC, c.logger, "ListGlossaryCategories")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCategories(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *businessGlossaryGRPCClient) CreateGlossaryTerm(ctx context.Context, req *dataplexpb.CreateGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGlossaryTerm[0:len((*c.CallOptions).CreateGlossaryTerm):len((*c.CallOptions).CreateGlossaryTerm)], opts...)
	var resp *dataplexpb.GlossaryTerm
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.CreateGlossaryTerm, req, settings.GRPC, c.logger, "CreateGlossaryTerm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) UpdateGlossaryTerm(ctx context.Context, req *dataplexpb.UpdateGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "term.name", url.QueryEscape(req.GetTerm().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGlossaryTerm[0:len((*c.CallOptions).UpdateGlossaryTerm):len((*c.CallOptions).UpdateGlossaryTerm)], opts...)
	var resp *dataplexpb.GlossaryTerm
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.UpdateGlossaryTerm, req, settings.GRPC, c.logger, "UpdateGlossaryTerm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) DeleteGlossaryTerm(ctx context.Context, req *dataplexpb.DeleteGlossaryTermRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteGlossaryTerm[0:len((*c.CallOptions).DeleteGlossaryTerm):len((*c.CallOptions).DeleteGlossaryTerm)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.businessGlossaryClient.DeleteGlossaryTerm, req, settings.GRPC, c.logger, "DeleteGlossaryTerm")
		return err
	}, opts...)
	return err
}

func (c *businessGlossaryGRPCClient) GetGlossaryTerm(ctx context.Context, req *dataplexpb.GetGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGlossaryTerm[0:len((*c.CallOptions).GetGlossaryTerm):len((*c.CallOptions).GetGlossaryTerm)], opts...)
	var resp *dataplexpb.GlossaryTerm
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.businessGlossaryClient.GetGlossaryTerm, req, settings.GRPC, c.logger, "GetGlossaryTerm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) ListGlossaryTerms(ctx context.Context, req *dataplexpb.ListGlossaryTermsRequest, opts ...gax.CallOption) *GlossaryTermIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGlossaryTerms[0:len((*c.CallOptions).ListGlossaryTerms):len((*c.CallOptions).ListGlossaryTerms)], opts...)
	it := &GlossaryTermIterator{}
	req = proto.Clone(req).(*dataplexpb.ListGlossaryTermsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*dataplexpb.GlossaryTerm, string, error) {
		resp := &dataplexpb.ListGlossaryTermsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.businessGlossaryClient.ListGlossaryTerms, req, settings.GRPC, c.logger, "ListGlossaryTerms")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTerms(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *businessGlossaryGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *businessGlossaryGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *businessGlossaryGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *businessGlossaryGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *businessGlossaryGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateGlossary creates a new Glossary resource.
func (c *businessGlossaryRESTClient) CreateGlossary(ctx context.Context, req *dataplexpb.CreateGlossaryRequest, opts ...gax.CallOption) (*CreateGlossaryOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGlossary()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/glossaries", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("glossaryId", fmt.Sprintf("%v", req.GetGlossaryId()))
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateGlossary")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateGlossaryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateGlossary updates a Glossary resource.
func (c *businessGlossaryRESTClient) UpdateGlossary(ctx context.Context, req *dataplexpb.UpdateGlossaryRequest, opts ...gax.CallOption) (*UpdateGlossaryOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGlossary()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetGlossary().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "glossary.name", url.QueryEscape(req.GetGlossary().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateGlossary")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateGlossaryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteGlossary deletes a Glossary resource. All the categories and terms within the
// Glossary must be deleted before the Glossary can be deleted.
func (c *businessGlossaryRESTClient) DeleteGlossary(ctx context.Context, req *dataplexpb.DeleteGlossaryRequest, opts ...gax.CallOption) (*DeleteGlossaryOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetEtag() != "" {
		params.Add("etag", fmt.Sprintf("%v", req.GetEtag()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteGlossary")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteGlossaryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetGlossary gets a Glossary resource.
func (c *businessGlossaryRESTClient) GetGlossary(ctx context.Context, req *dataplexpb.GetGlossaryRequest, opts ...gax.CallOption) (*dataplexpb.Glossary, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGlossary[0:len((*c.CallOptions).GetGlossary):len((*c.CallOptions).GetGlossary)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &dataplexpb.Glossary{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetGlossary")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListGlossaries lists Glossary resources in a project and location.
func (c *businessGlossaryRESTClient) ListGlossaries(ctx context.Context, req *dataplexpb.ListGlossariesRequest, opts ...gax.CallOption) *GlossaryIterator {
	it := &GlossaryIterator{}
	req = proto.Clone(req).(*dataplexpb.ListGlossariesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*dataplexpb.Glossary, string, error) {
		resp := &dataplexpb.ListGlossariesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/glossaries", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListGlossaries")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGlossaries(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateGlossaryCategory creates a new GlossaryCategory resource.
func (c *businessGlossaryRESTClient) CreateGlossaryCategory(ctx context.Context, req *dataplexpb.CreateGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCategory()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/categories", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("categoryId", fmt.Sprintf("%v", req.GetCategoryId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateGlossaryCategory[0:len((*c.CallOptions).CreateGlossaryCategory):len((*c.CallOptions).CreateGlossaryCategory)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &dataplexpb.GlossaryCategory{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateGlossaryCategory")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateGlossaryCategory updates a GlossaryCategory resource.
func (c *businessGlossaryRESTClient) UpdateGlossaryCategory(ctx context.Context, req *dataplexpb.UpdateGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCategory()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetCategory().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "category.name", url.QueryEscape(req.GetCategory().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGlossaryCategory[0:len((*c.CallOptions).UpdateGlossaryCategory):len((*c.CallOptions).UpdateGlossaryCategory)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &dataplexpb.GlossaryCategory{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateGlossaryCategory")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteGlossaryCategory deletes a GlossaryCategory resource. All the GlossaryCategories and
// GlossaryTerms nested directly under the specified GlossaryCategory will be
// moved one level up to the parent in the hierarchy.
func (c *businessGlossaryRESTClient) DeleteGlossaryCategory(ctx context.Context, req *dataplexpb.DeleteGlossaryCategoryRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteGlossaryCategory")
		return err
	}, opts...)
}

// GetGlossaryCategory gets a GlossaryCategory resource.
func (c *businessGlossaryRESTClient) GetGlossaryCategory(ctx context.Context, req *dataplexpb.GetGlossaryCategoryRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryCategory, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGlossaryCategory[0:len((*c.CallOptions).GetGlossaryCategory):len((*c.CallOptions).GetGlossaryCategory)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &dataplexpb.GlossaryCategory{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetGlossaryCategory")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListGlossaryCategories lists GlossaryCategory resources in a Glossary.
func (c *businessGlossaryRESTClient) ListGlossaryCategories(ctx context.Context, req *dataplexpb.ListGlossaryCategoriesRequest, opts ...gax.CallOption) *GlossaryCategoryIterator {
	it := &GlossaryCategoryIterator{}
	req = proto.Clone(req).(*dataplexpb.ListGlossaryCategoriesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*dataplexpb.GlossaryCategory, string, error) {
		resp := &dataplexpb.ListGlossaryCategoriesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/categories", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListGlossaryCategories")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetCategories(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateGlossaryTerm creates a new GlossaryTerm resource.
func (c *businessGlossaryRESTClient) CreateGlossaryTerm(ctx context.Context, req *dataplexpb.CreateGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTerm()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/terms", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("termId", fmt.Sprintf("%v", req.GetTermId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateGlossaryTerm[0:len((*c.CallOptions).CreateGlossaryTerm):len((*c.CallOptions).CreateGlossaryTerm)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &dataplexpb.GlossaryTerm{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateGlossaryTerm")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateGlossaryTerm updates a GlossaryTerm resource.
func (c *businessGlossaryRESTClient) UpdateGlossaryTerm(ctx context.Context, req *dataplexpb.UpdateGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTerm()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetTerm().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "term.name", url.QueryEscape(req.GetTerm().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGlossaryTerm[0:len((*c.CallOptions).UpdateGlossaryTerm):len((*c.CallOptions).UpdateGlossaryTerm)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &dataplexpb.GlossaryTerm{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateGlossaryTerm")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteGlossaryTerm deletes a GlossaryTerm resource.
func (c *businessGlossaryRESTClient) DeleteGlossaryTerm(ctx context.Context, req *dataplexpb.DeleteGlossaryTermRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteGlossaryTerm")
		return err
	}, opts...)
}

// GetGlossaryTerm gets a GlossaryTerm resource.
func (c *businessGlossaryRESTClient) GetGlossaryTerm(ctx context.Context, req *dataplexpb.GetGlossaryTermRequest, opts ...gax.CallOption) (*dataplexpb.GlossaryTerm, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGlossaryTerm[0:len((*c.CallOptions).GetGlossaryTerm):len((*c.CallOptions).GetGlossaryTerm)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &dataplexpb.GlossaryTerm{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetGlossaryTerm")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListGlossaryTerms lists GlossaryTerm resources in a Glossary.
func (c *businessGlossaryRESTClient) ListGlossaryTerms(ctx context.Context, req *dataplexpb.ListGlossaryTermsRequest, opts ...gax.CallOption) *GlossaryTermIterator {
	it := &GlossaryTermIterator{}
	req = proto.Clone(req).(*dataplexpb.ListGlossaryTermsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*dataplexpb.GlossaryTerm, string, error) {
		resp := &dataplexpb.ListGlossaryTermsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/terms", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListGlossaryTerms")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetTerms(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetLocation gets information about a location.
func (c *businessGlossaryRESTClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *businessGlossaryRESTClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *businessGlossaryRESTClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *businessGlossaryRESTClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *businessGlossaryRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *businessGlossaryRESTClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateGlossaryOperation returns a new CreateGlossaryOperation from a given name.
// The name must be that of a previously created CreateGlossaryOperation, possibly from a different process.
func (c *businessGlossaryGRPCClient) CreateGlossaryOperation(name string) *CreateGlossaryOperation {
	return &CreateGlossaryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateGlossaryOperation returns a new CreateGlossaryOperation from a given name.
// The name must be that of a previously created CreateGlossaryOperation, possibly from a different process.
func (c *businessGlossaryRESTClient) CreateGlossaryOperation(name string) *CreateGlossaryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateGlossaryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteGlossaryOperation returns a new DeleteGlossaryOperation from a given name.
// The name must be that of a previously created DeleteGlossaryOperation, possibly from a different process.
func (c *businessGlossaryGRPCClient) DeleteGlossaryOperation(name string) *DeleteGlossaryOperation {
	return &DeleteGlossaryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteGlossaryOperation returns a new DeleteGlossaryOperation from a given name.
// The name must be that of a previously created DeleteGlossaryOperation, possibly from a different process.
func (c *businessGlossaryRESTClient) DeleteGlossaryOperation(name string) *DeleteGlossaryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteGlossaryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateGlossaryOperation returns a new UpdateGlossaryOperation from a given name.
// The name must be that of a previously created UpdateGlossaryOperation, possibly from a different process.
func (c *businessGlossaryGRPCClient) UpdateGlossaryOperation(name string) *UpdateGlossaryOperation {
	return &UpdateGlossaryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateGlossaryOperation returns a new UpdateGlossaryOperation from a given name.
// The name must be that of a previously created UpdateGlossaryOperation, possibly from a different process.
func (c *businessGlossaryRESTClient) UpdateGlossaryOperation(name string) *UpdateGlossaryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateGlossaryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
