// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing scheduled query with new configuration. This operation uses
// PUT semantics, allowing modification of query parameters, schedule, and
// destinations.
func (c *Client) UpdateScheduledQuery(ctx context.Context, params *UpdateScheduledQueryInput, optFns ...func(*Options)) (*UpdateScheduledQueryOutput, error) {
	if params == nil {
		params = &UpdateScheduledQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateScheduledQuery", params, optFns, c.addOperationUpdateScheduledQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateScheduledQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateScheduledQueryInput struct {

	// The updated ARN of the IAM role that grants permissions to execute the query
	// and deliver results.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The ARN or name of the scheduled query to update.
	//
	// This member is required.
	Identifier *string

	// The updated query language for the scheduled query.
	//
	// This member is required.
	QueryLanguage types.QueryLanguage

	// The updated query string to execute.
	//
	// This member is required.
	QueryString *string

	// The updated cron expression that defines when the scheduled query runs.
	//
	// This member is required.
	ScheduleExpression *string

	// An updated description for the scheduled query.
	Description *string

	// The updated configuration for where to deliver query results.
	DestinationConfiguration *types.DestinationConfiguration

	// The updated array of log group names or ARNs to query.
	LogGroupIdentifiers []string

	// The updated end time for the scheduled query in Unix epoch format.
	ScheduleEndTime *int64

	// The updated start time for the scheduled query in Unix epoch format.
	ScheduleStartTime *int64

	// The updated time offset in seconds that defines the lookback period for the
	// query.
	StartTimeOffset *int64

	// The updated state of the scheduled query.
	State types.ScheduledQueryState

	// The updated timezone for evaluating the schedule expression.
	Timezone *string

	noSmithyDocumentSerde
}

type UpdateScheduledQueryOutput struct {

	// The timestamp when the scheduled query was originally created.
	CreationTime *int64

	// The description of the updated scheduled query.
	Description *string

	// The destination configuration of the updated scheduled query.
	DestinationConfiguration *types.DestinationConfiguration

	// The execution role ARN of the updated scheduled query.
	ExecutionRoleArn *string

	// The status of the most recent execution of the updated scheduled query.
	LastExecutionStatus types.ExecutionStatus

	// The timestamp when the updated scheduled query was last executed.
	LastTriggeredTime *int64

	// The timestamp when the scheduled query was last updated.
	LastUpdatedTime *int64

	// The log groups queried by the updated scheduled query.
	LogGroupIdentifiers []string

	// The name of the updated scheduled query.
	Name *string

	// The query language of the updated scheduled query.
	QueryLanguage types.QueryLanguage

	// The query string of the updated scheduled query.
	QueryString *string

	// The end time of the updated scheduled query.
	ScheduleEndTime *int64

	// The cron expression of the updated scheduled query.
	ScheduleExpression *string

	// The start time of the updated scheduled query.
	ScheduleStartTime *int64

	// The ARN of the updated scheduled query.
	ScheduledQueryArn *string

	// The time offset of the updated scheduled query.
	StartTimeOffset *int64

	// The state of the updated scheduled query.
	State types.ScheduledQueryState

	// The timezone of the updated scheduled query.
	Timezone *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateScheduledQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateScheduledQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateScheduledQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateScheduledQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateScheduledQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateScheduledQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateScheduledQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateScheduledQuery",
	}
}
