// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-models'; DO NOT EDIT

package iaas

import (
	"time"

	"github.com/sacloud/iaas-api-go/accessor"
	"github.com/sacloud/iaas-api-go/search"
	"github.com/sacloud/iaas-api-go/types"
)

/*************************************************
* Archive
*************************************************/

// Archive represents API parameter/response structure
type Archive struct {
	ID                        types.ID
	Name                      string
	Description               string
	Tags                      types.Tags
	DisplayOrder              int64
	Availability              types.EAvailability
	Scope                     types.EScope
	SizeMB                    int
	MigratedMB                int
	DiskPlanID                types.ID            `mapconv:"Plan.ID"`
	DiskPlanName              string              `mapconv:"Plan.Name"`
	DiskPlanStorageClass      string              `mapconv:"Plan.StorageClass"`
	SourceDiskID              types.ID            `mapconv:"SourceDisk.ID,omitempty"`
	SourceDiskAvailability    types.EAvailability `mapconv:"SourceDisk.Availability,omitempty"`
	SourceArchiveID           types.ID            `mapconv:"SourceArchive.ID,omitempty"`
	SourceArchiveAvailability types.EAvailability `mapconv:"SourceArchive.Availability,omitempty"`
	BundleInfo                *BundleInfo         `json:",omitempty" mapconv:",omitempty,recursive"`
	Storage                   *Storage            `json:",omitempty" mapconv:",omitempty,recursive"`
	IconID                    types.ID            `mapconv:"Icon.ID"`
	CreatedAt                 time.Time
	ModifiedAt                time.Time
	OriginalArchiveID         types.ID           `mapconv:"OriginalArchive.ID,omitempty"`
	SourceInfo                *SourceArchiveInfo `mapconv:",omitempty,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *Archive) setDefaults() interface{} {
	return &struct {
		ID                        types.ID
		Name                      string
		Description               string
		Tags                      types.Tags
		DisplayOrder              int64
		Availability              types.EAvailability
		Scope                     types.EScope
		SizeMB                    int
		MigratedMB                int
		DiskPlanID                types.ID            `mapconv:"Plan.ID"`
		DiskPlanName              string              `mapconv:"Plan.Name"`
		DiskPlanStorageClass      string              `mapconv:"Plan.StorageClass"`
		SourceDiskID              types.ID            `mapconv:"SourceDisk.ID,omitempty"`
		SourceDiskAvailability    types.EAvailability `mapconv:"SourceDisk.Availability,omitempty"`
		SourceArchiveID           types.ID            `mapconv:"SourceArchive.ID,omitempty"`
		SourceArchiveAvailability types.EAvailability `mapconv:"SourceArchive.Availability,omitempty"`
		BundleInfo                *BundleInfo         `json:",omitempty" mapconv:",omitempty,recursive"`
		Storage                   *Storage            `json:",omitempty" mapconv:",omitempty,recursive"`
		IconID                    types.ID            `mapconv:"Icon.ID"`
		CreatedAt                 time.Time
		ModifiedAt                time.Time
		OriginalArchiveID         types.ID           `mapconv:"OriginalArchive.ID,omitempty"`
		SourceInfo                *SourceArchiveInfo `mapconv:",omitempty,recursive"`
	}{
		ID:                        o.GetID(),
		Name:                      o.GetName(),
		Description:               o.GetDescription(),
		Tags:                      o.GetTags(),
		DisplayOrder:              o.GetDisplayOrder(),
		Availability:              o.GetAvailability(),
		Scope:                     o.GetScope(),
		SizeMB:                    o.GetSizeMB(),
		MigratedMB:                o.GetMigratedMB(),
		DiskPlanID:                o.GetDiskPlanID(),
		DiskPlanName:              o.GetDiskPlanName(),
		DiskPlanStorageClass:      o.GetDiskPlanStorageClass(),
		SourceDiskID:              o.GetSourceDiskID(),
		SourceDiskAvailability:    o.GetSourceDiskAvailability(),
		SourceArchiveID:           o.GetSourceArchiveID(),
		SourceArchiveAvailability: o.GetSourceArchiveAvailability(),
		BundleInfo:                o.GetBundleInfo(),
		Storage:                   o.GetStorage(),
		IconID:                    o.GetIconID(),
		CreatedAt:                 o.GetCreatedAt(),
		ModifiedAt:                o.GetModifiedAt(),
		OriginalArchiveID:         o.GetOriginalArchiveID(),
		SourceInfo:                o.GetSourceInfo(),
	}
}

// GetID returns value of ID
func (o *Archive) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Archive) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Archive) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Archive) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Archive) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Archive) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Archive) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Archive) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Archive) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Archive) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *Archive) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *Archive) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *Archive) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *Archive) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *Archive) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *Archive) ClearTags() {
	accessor.ClearTags(o)
}

// GetDisplayOrder returns value of DisplayOrder
func (o *Archive) GetDisplayOrder() int64 {
	return o.DisplayOrder
}

// SetDisplayOrder sets value to DisplayOrder
func (o *Archive) SetDisplayOrder(v int64) {
	o.DisplayOrder = v
}

// GetAvailability returns value of Availability
func (o *Archive) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *Archive) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetScope returns value of Scope
func (o *Archive) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *Archive) SetScope(v types.EScope) {
	o.Scope = v
}

// GetSizeMB returns value of SizeMB
func (o *Archive) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *Archive) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *Archive) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *Archive) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

// GetMigratedMB returns value of MigratedMB
func (o *Archive) GetMigratedMB() int {
	return o.MigratedMB
}

// SetMigratedMB sets value to MigratedMB
func (o *Archive) SetMigratedMB(v int) {
	o.MigratedMB = v
}

// GetMigratedGB .
func (o *Archive) GetMigratedGB() int {
	return accessor.GetMigratedGB(o)
}

// GetDiskPlanID returns value of DiskPlanID
func (o *Archive) GetDiskPlanID() types.ID {
	return o.DiskPlanID
}

// SetDiskPlanID sets value to DiskPlanID
func (o *Archive) SetDiskPlanID(v types.ID) {
	o.DiskPlanID = v
}

// GetDiskPlanName returns value of DiskPlanName
func (o *Archive) GetDiskPlanName() string {
	return o.DiskPlanName
}

// SetDiskPlanName sets value to DiskPlanName
func (o *Archive) SetDiskPlanName(v string) {
	o.DiskPlanName = v
}

// GetDiskPlanStorageClass returns value of DiskPlanStorageClass
func (o *Archive) GetDiskPlanStorageClass() string {
	return o.DiskPlanStorageClass
}

// SetDiskPlanStorageClass sets value to DiskPlanStorageClass
func (o *Archive) SetDiskPlanStorageClass(v string) {
	o.DiskPlanStorageClass = v
}

// GetSourceDiskID returns value of SourceDiskID
func (o *Archive) GetSourceDiskID() types.ID {
	return o.SourceDiskID
}

// SetSourceDiskID sets value to SourceDiskID
func (o *Archive) SetSourceDiskID(v types.ID) {
	o.SourceDiskID = v
}

// GetSourceDiskAvailability returns value of SourceDiskAvailability
func (o *Archive) GetSourceDiskAvailability() types.EAvailability {
	return o.SourceDiskAvailability
}

// SetSourceDiskAvailability sets value to SourceDiskAvailability
func (o *Archive) SetSourceDiskAvailability(v types.EAvailability) {
	o.SourceDiskAvailability = v
}

// GetSourceArchiveID returns value of SourceArchiveID
func (o *Archive) GetSourceArchiveID() types.ID {
	return o.SourceArchiveID
}

// SetSourceArchiveID sets value to SourceArchiveID
func (o *Archive) SetSourceArchiveID(v types.ID) {
	o.SourceArchiveID = v
}

// GetSourceArchiveAvailability returns value of SourceArchiveAvailability
func (o *Archive) GetSourceArchiveAvailability() types.EAvailability {
	return o.SourceArchiveAvailability
}

// SetSourceArchiveAvailability sets value to SourceArchiveAvailability
func (o *Archive) SetSourceArchiveAvailability(v types.EAvailability) {
	o.SourceArchiveAvailability = v
}

// GetBundleInfo returns value of BundleInfo
func (o *Archive) GetBundleInfo() *BundleInfo {
	return o.BundleInfo
}

// SetBundleInfo sets value to BundleInfo
func (o *Archive) SetBundleInfo(v *BundleInfo) {
	o.BundleInfo = v
}

// GetStorage returns value of Storage
func (o *Archive) GetStorage() *Storage {
	return o.Storage
}

// SetStorage sets value to Storage
func (o *Archive) SetStorage(v *Storage) {
	o.Storage = v
}

// GetIconID returns value of IconID
func (o *Archive) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *Archive) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Archive) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Archive) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *Archive) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *Archive) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetOriginalArchiveID returns value of OriginalArchiveID
func (o *Archive) GetOriginalArchiveID() types.ID {
	return o.OriginalArchiveID
}

// SetOriginalArchiveID sets value to OriginalArchiveID
func (o *Archive) SetOriginalArchiveID(v types.ID) {
	o.OriginalArchiveID = v
}

// GetSourceInfo returns value of SourceInfo
func (o *Archive) GetSourceInfo() *SourceArchiveInfo {
	return o.SourceInfo
}

// SetSourceInfo sets value to SourceInfo
func (o *Archive) SetSourceInfo(v *SourceArchiveInfo) {
	o.SourceInfo = v
}

/*************************************************
* BundleInfo
*************************************************/

// BundleInfo represents API parameter/response structure
type BundleInfo struct {
	ID           types.ID
	HostClass    string `json:",omitempty" mapconv:",omitempty"`
	ServiceClass string `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *BundleInfo) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		HostClass    string `json:",omitempty" mapconv:",omitempty"`
		ServiceClass string `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:           o.GetID(),
		HostClass:    o.GetHostClass(),
		ServiceClass: o.GetServiceClass(),
	}
}

// GetID returns value of ID
func (o *BundleInfo) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *BundleInfo) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *BundleInfo) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *BundleInfo) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *BundleInfo) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *BundleInfo) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetHostClass returns value of HostClass
func (o *BundleInfo) GetHostClass() string {
	return o.HostClass
}

// SetHostClass sets value to HostClass
func (o *BundleInfo) SetHostClass(v string) {
	o.HostClass = v
}

// GetServiceClass returns value of ServiceClass
func (o *BundleInfo) GetServiceClass() string {
	return o.ServiceClass
}

// SetServiceClass sets value to ServiceClass
func (o *BundleInfo) SetServiceClass(v string) {
	o.ServiceClass = v
}

/*************************************************
* Storage
*************************************************/

// Storage represents API parameter/response structure
type Storage struct {
	ID         types.ID
	Name       string
	Class      string `json:",omitempty" mapconv:",omitempty"`
	Generation int    `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *Storage) setDefaults() interface{} {
	return &struct {
		ID         types.ID
		Name       string
		Class      string `json:",omitempty" mapconv:",omitempty"`
		Generation int    `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:         o.GetID(),
		Name:       o.GetName(),
		Class:      o.GetClass(),
		Generation: o.GetGeneration(),
	}
}

// GetID returns value of ID
func (o *Storage) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Storage) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Storage) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Storage) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Storage) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Storage) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Storage) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Storage) SetName(v string) {
	o.Name = v
}

// GetClass returns value of Class
func (o *Storage) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *Storage) SetClass(v string) {
	o.Class = v
}

// GetGeneration returns value of Generation
func (o *Storage) GetGeneration() int {
	return o.Generation
}

// SetGeneration sets value to Generation
func (o *Storage) SetGeneration(v int) {
	o.Generation = v
}

/*************************************************
* SourceArchiveInfo
*************************************************/

// SourceArchiveInfo represents API parameter/response structure
type SourceArchiveInfo struct {
	ID        types.ID `mapconv:"ArchiveUnderZone.ID"`
	AccountID types.ID `mapconv:"ArchiveUnderZone.Account.ID"`
	ZoneID    types.ID `mapconv:"ArchiveUnderZone.Zone.ID"`
	ZoneName  string   `mapconv:"ArchiveUnderZone.Zone.Name"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SourceArchiveInfo) setDefaults() interface{} {
	return &struct {
		ID        types.ID `mapconv:"ArchiveUnderZone.ID"`
		AccountID types.ID `mapconv:"ArchiveUnderZone.Account.ID"`
		ZoneID    types.ID `mapconv:"ArchiveUnderZone.Zone.ID"`
		ZoneName  string   `mapconv:"ArchiveUnderZone.Zone.Name"`
	}{
		ID:        o.GetID(),
		AccountID: o.GetAccountID(),
		ZoneID:    o.GetZoneID(),
		ZoneName:  o.GetZoneName(),
	}
}

// GetID returns value of ID
func (o *SourceArchiveInfo) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *SourceArchiveInfo) SetID(v types.ID) {
	o.ID = v
}

// GetAccountID returns value of AccountID
func (o *SourceArchiveInfo) GetAccountID() types.ID {
	return o.AccountID
}

// SetAccountID sets value to AccountID
func (o *SourceArchiveInfo) SetAccountID(v types.ID) {
	o.AccountID = v
}

// GetZoneID returns value of ZoneID
func (o *SourceArchiveInfo) GetZoneID() types.ID {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *SourceArchiveInfo) SetZoneID(v types.ID) {
	o.ZoneID = v
}

// GetZoneName returns value of ZoneName
func (o *SourceArchiveInfo) GetZoneName() string {
	return o.ZoneName
}

// SetZoneName sets value to ZoneName
func (o *SourceArchiveInfo) SetZoneName(v string) {
	o.ZoneName = v
}

/*************************************************
* FindCondition
*************************************************/

// FindCondition represents API parameter/response structure
type FindCondition struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *FindCondition) setDefaults() interface{} {
	return &struct {
		Count   int             `mapconv:",omitempty"`
		From    int             `mapconv:",omitempty"`
		Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
		Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
		Include []string        `json:",omitempty" mapconv:",omitempty"`
		Exclude []string        `json:",omitempty" mapconv:",omitempty"`
	}{
		Count:   o.GetCount(),
		From:    o.GetFrom(),
		Sort:    o.GetSort(),
		Filter:  o.GetFilter(),
		Include: o.GetInclude(),
		Exclude: o.GetExclude(),
	}
}

// ClearFilter フィルタのクリア
func (o *FindCondition) ClearFilter() {
	accessor.ClearFilter(o)
}

// GetCount returns value of Count
func (o *FindCondition) GetCount() int {
	return o.Count
}

// SetCount sets value to Count
func (o *FindCondition) SetCount(v int) {
	o.Count = v
}

// GetFrom returns value of From
func (o *FindCondition) GetFrom() int {
	return o.From
}

// SetFrom sets value to From
func (o *FindCondition) SetFrom(v int) {
	o.From = v
}

// GetSort returns value of Sort
func (o *FindCondition) GetSort() search.SortKeys {
	return o.Sort
}

// SetSort sets value to Sort
func (o *FindCondition) SetSort(v search.SortKeys) {
	o.Sort = v
}

// GetFilter returns value of Filter
func (o *FindCondition) GetFilter() search.Filter {
	return o.Filter
}

// SetFilter sets value to Filter
func (o *FindCondition) SetFilter(v search.Filter) {
	o.Filter = v
}

// GetInclude returns value of Include
func (o *FindCondition) GetInclude() []string {
	return o.Include
}

// SetInclude sets value to Include
func (o *FindCondition) SetInclude(v []string) {
	o.Include = v
}

// GetExclude returns value of Exclude
func (o *FindCondition) GetExclude() []string {
	return o.Exclude
}

// SetExclude sets value to Exclude
func (o *FindCondition) SetExclude(v []string) {
	o.Exclude = v
}

/*************************************************
* ArchiveCreateRequest
*************************************************/

// ArchiveCreateRequest represents API parameter/response structure
type ArchiveCreateRequest struct {
	SourceDiskID    types.ID `mapconv:"SourceDisk.ID,omitempty"`
	SourceArchiveID types.ID `mapconv:"SourceArchive.ID,omitempty"`
	Name            string
	Description     string
	Tags            types.Tags
	IconID          types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ArchiveCreateRequest) setDefaults() interface{} {
	return &struct {
		SourceDiskID    types.ID `mapconv:"SourceDisk.ID,omitempty"`
		SourceArchiveID types.ID `mapconv:"SourceArchive.ID,omitempty"`
		Name            string
		Description     string
		Tags            types.Tags
		IconID          types.ID `mapconv:"Icon.ID"`
	}{
		SourceDiskID:    o.GetSourceDiskID(),
		SourceArchiveID: o.GetSourceArchiveID(),
		Name:            o.GetName(),
		Description:     o.GetDescription(),
		Tags:            o.GetTags(),
		IconID:          o.GetIconID(),
	}
}

// GetSourceDiskID returns value of SourceDiskID
func (o *ArchiveCreateRequest) GetSourceDiskID() types.ID {
	return o.SourceDiskID
}

// SetSourceDiskID sets value to SourceDiskID
func (o *ArchiveCreateRequest) SetSourceDiskID(v types.ID) {
	o.SourceDiskID = v
}

// GetSourceArchiveID returns value of SourceArchiveID
func (o *ArchiveCreateRequest) GetSourceArchiveID() types.ID {
	return o.SourceArchiveID
}

// SetSourceArchiveID sets value to SourceArchiveID
func (o *ArchiveCreateRequest) SetSourceArchiveID(v types.ID) {
	o.SourceArchiveID = v
}

// GetName returns value of Name
func (o *ArchiveCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ArchiveCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ArchiveCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ArchiveCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ArchiveCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ArchiveCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ArchiveCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ArchiveCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ArchiveCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ArchiveCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ArchiveCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ArchiveCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* FTPServer
*************************************************/

// FTPServer represents API parameter/response structure
type FTPServer struct {
	HostName  string
	IPAddress string
	User      string
	Password  string
}

// setDefaults implements iaas.argumentDefaulter
func (o *FTPServer) setDefaults() interface{} {
	return &struct {
		HostName  string
		IPAddress string
		User      string
		Password  string
	}{
		HostName:  o.GetHostName(),
		IPAddress: o.GetIPAddress(),
		User:      o.GetUser(),
		Password:  o.GetPassword(),
	}
}

// GetHostName returns value of HostName
func (o *FTPServer) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *FTPServer) SetHostName(v string) {
	o.HostName = v
}

// GetIPAddress returns value of IPAddress
func (o *FTPServer) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *FTPServer) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetUser returns value of User
func (o *FTPServer) GetUser() string {
	return o.User
}

// SetUser sets value to User
func (o *FTPServer) SetUser(v string) {
	o.User = v
}

// GetPassword returns value of Password
func (o *FTPServer) GetPassword() string {
	return o.Password
}

// SetPassword sets value to Password
func (o *FTPServer) SetPassword(v string) {
	o.Password = v
}

/*************************************************
* ArchiveCreateBlankRequest
*************************************************/

// ArchiveCreateBlankRequest represents API parameter/response structure
type ArchiveCreateBlankRequest struct {
	SizeMB      int
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ArchiveCreateBlankRequest) setDefaults() interface{} {
	return &struct {
		SizeMB      int
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		SizeMB:      o.GetSizeMB(),
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetSizeMB returns value of SizeMB
func (o *ArchiveCreateBlankRequest) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *ArchiveCreateBlankRequest) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *ArchiveCreateBlankRequest) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *ArchiveCreateBlankRequest) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

// GetName returns value of Name
func (o *ArchiveCreateBlankRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ArchiveCreateBlankRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ArchiveCreateBlankRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ArchiveCreateBlankRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ArchiveCreateBlankRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ArchiveCreateBlankRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ArchiveCreateBlankRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ArchiveCreateBlankRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ArchiveCreateBlankRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ArchiveCreateBlankRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ArchiveCreateBlankRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ArchiveCreateBlankRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* ArchiveUpdateRequest
*************************************************/

// ArchiveUpdateRequest represents API parameter/response structure
type ArchiveUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ArchiveUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *ArchiveUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ArchiveUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ArchiveUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ArchiveUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ArchiveUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ArchiveUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ArchiveUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ArchiveUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ArchiveUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ArchiveUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ArchiveUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ArchiveUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* OpenFTPRequest
*************************************************/

// OpenFTPRequest represents API parameter/response structure
type OpenFTPRequest struct {
	ChangePassword bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *OpenFTPRequest) setDefaults() interface{} {
	return &struct {
		ChangePassword bool
	}{
		ChangePassword: o.GetChangePassword(),
	}
}

// GetChangePassword returns value of ChangePassword
func (o *OpenFTPRequest) GetChangePassword() bool {
	return o.ChangePassword
}

// SetChangePassword sets value to ChangePassword
func (o *OpenFTPRequest) SetChangePassword(v bool) {
	o.ChangePassword = v
}

/*************************************************
* ArchiveShareInfo
*************************************************/

// ArchiveShareInfo represents API parameter/response structure
type ArchiveShareInfo struct {
	SharedKey types.ArchiveShareKey
}

// setDefaults implements iaas.argumentDefaulter
func (o *ArchiveShareInfo) setDefaults() interface{} {
	return &struct {
		SharedKey types.ArchiveShareKey
	}{
		SharedKey: o.GetSharedKey(),
	}
}

// GetSharedKey returns value of SharedKey
func (o *ArchiveShareInfo) GetSharedKey() types.ArchiveShareKey {
	return o.SharedKey
}

// SetSharedKey sets value to SharedKey
func (o *ArchiveShareInfo) SetSharedKey(v types.ArchiveShareKey) {
	o.SharedKey = v
}

/*************************************************
* ArchiveCreateRequestFromShared
*************************************************/

// ArchiveCreateRequestFromShared represents API parameter/response structure
type ArchiveCreateRequestFromShared struct {
	Name            string
	Description     string
	Tags            types.Tags
	IconID          types.ID `mapconv:"Icon.ID"`
	SourceSharedKey types.ArchiveShareKey
}

// setDefaults implements iaas.argumentDefaulter
func (o *ArchiveCreateRequestFromShared) setDefaults() interface{} {
	return &struct {
		Name            string
		Description     string
		Tags            types.Tags
		IconID          types.ID `mapconv:"Icon.ID"`
		SourceSharedKey types.ArchiveShareKey
	}{
		Name:            o.GetName(),
		Description:     o.GetDescription(),
		Tags:            o.GetTags(),
		IconID:          o.GetIconID(),
		SourceSharedKey: o.GetSourceSharedKey(),
	}
}

// GetName returns value of Name
func (o *ArchiveCreateRequestFromShared) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ArchiveCreateRequestFromShared) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ArchiveCreateRequestFromShared) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ArchiveCreateRequestFromShared) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ArchiveCreateRequestFromShared) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ArchiveCreateRequestFromShared) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ArchiveCreateRequestFromShared) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ArchiveCreateRequestFromShared) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ArchiveCreateRequestFromShared) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ArchiveCreateRequestFromShared) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ArchiveCreateRequestFromShared) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ArchiveCreateRequestFromShared) SetIconID(v types.ID) {
	o.IconID = v
}

// GetSourceSharedKey returns value of SourceSharedKey
func (o *ArchiveCreateRequestFromShared) GetSourceSharedKey() types.ArchiveShareKey {
	return o.SourceSharedKey
}

// SetSourceSharedKey sets value to SourceSharedKey
func (o *ArchiveCreateRequestFromShared) SetSourceSharedKey(v types.ArchiveShareKey) {
	o.SourceSharedKey = v
}

/*************************************************
* ArchiveTransferRequest
*************************************************/

// ArchiveTransferRequest represents API parameter/response structure
type ArchiveTransferRequest struct {
	SizeMB      int
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ArchiveTransferRequest) setDefaults() interface{} {
	return &struct {
		SizeMB      int
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		SizeMB:      o.GetSizeMB(),
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetSizeMB returns value of SizeMB
func (o *ArchiveTransferRequest) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *ArchiveTransferRequest) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *ArchiveTransferRequest) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *ArchiveTransferRequest) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

// GetName returns value of Name
func (o *ArchiveTransferRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ArchiveTransferRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ArchiveTransferRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ArchiveTransferRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ArchiveTransferRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ArchiveTransferRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ArchiveTransferRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ArchiveTransferRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ArchiveTransferRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ArchiveTransferRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ArchiveTransferRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ArchiveTransferRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* AuthStatus
*************************************************/

// AuthStatus represents API parameter/response structure
type AuthStatus struct {
	AccountID          types.ID `mapconv:"Account.ID"`
	AccountName        string   `mapconv:"Account.Name"`
	AccountCode        string   `mapconv:"Account.Code"`
	AccountClass       string   `mapconv:"Account.Class"`
	MemberCode         string   `mapconv:"Member.Code"`
	MemberClass        string   `mapconv:"Member.Class"`
	AuthClass          types.EAuthClass
	AuthMethod         types.EAuthMethod
	IsAPIKey           bool
	ExternalPermission types.ExternalPermission
	OperationPenalty   types.EOperationPenalty
	Permission         types.EPermission
}

// setDefaults implements iaas.argumentDefaulter
func (o *AuthStatus) setDefaults() interface{} {
	return &struct {
		AccountID          types.ID `mapconv:"Account.ID"`
		AccountName        string   `mapconv:"Account.Name"`
		AccountCode        string   `mapconv:"Account.Code"`
		AccountClass       string   `mapconv:"Account.Class"`
		MemberCode         string   `mapconv:"Member.Code"`
		MemberClass        string   `mapconv:"Member.Class"`
		AuthClass          types.EAuthClass
		AuthMethod         types.EAuthMethod
		IsAPIKey           bool
		ExternalPermission types.ExternalPermission
		OperationPenalty   types.EOperationPenalty
		Permission         types.EPermission
	}{
		AccountID:          o.GetAccountID(),
		AccountName:        o.GetAccountName(),
		AccountCode:        o.GetAccountCode(),
		AccountClass:       o.GetAccountClass(),
		MemberCode:         o.GetMemberCode(),
		MemberClass:        o.GetMemberClass(),
		AuthClass:          o.GetAuthClass(),
		AuthMethod:         o.GetAuthMethod(),
		IsAPIKey:           o.GetIsAPIKey(),
		ExternalPermission: o.GetExternalPermission(),
		OperationPenalty:   o.GetOperationPenalty(),
		Permission:         o.GetPermission(),
	}
}

// GetAccountID returns value of AccountID
func (o *AuthStatus) GetAccountID() types.ID {
	return o.AccountID
}

// SetAccountID sets value to AccountID
func (o *AuthStatus) SetAccountID(v types.ID) {
	o.AccountID = v
}

// GetAccountName returns value of AccountName
func (o *AuthStatus) GetAccountName() string {
	return o.AccountName
}

// SetAccountName sets value to AccountName
func (o *AuthStatus) SetAccountName(v string) {
	o.AccountName = v
}

// GetAccountCode returns value of AccountCode
func (o *AuthStatus) GetAccountCode() string {
	return o.AccountCode
}

// SetAccountCode sets value to AccountCode
func (o *AuthStatus) SetAccountCode(v string) {
	o.AccountCode = v
}

// GetAccountClass returns value of AccountClass
func (o *AuthStatus) GetAccountClass() string {
	return o.AccountClass
}

// SetAccountClass sets value to AccountClass
func (o *AuthStatus) SetAccountClass(v string) {
	o.AccountClass = v
}

// GetMemberCode returns value of MemberCode
func (o *AuthStatus) GetMemberCode() string {
	return o.MemberCode
}

// SetMemberCode sets value to MemberCode
func (o *AuthStatus) SetMemberCode(v string) {
	o.MemberCode = v
}

// GetMemberClass returns value of MemberClass
func (o *AuthStatus) GetMemberClass() string {
	return o.MemberClass
}

// SetMemberClass sets value to MemberClass
func (o *AuthStatus) SetMemberClass(v string) {
	o.MemberClass = v
}

// GetAuthClass returns value of AuthClass
func (o *AuthStatus) GetAuthClass() types.EAuthClass {
	return o.AuthClass
}

// SetAuthClass sets value to AuthClass
func (o *AuthStatus) SetAuthClass(v types.EAuthClass) {
	o.AuthClass = v
}

// GetAuthMethod returns value of AuthMethod
func (o *AuthStatus) GetAuthMethod() types.EAuthMethod {
	return o.AuthMethod
}

// SetAuthMethod sets value to AuthMethod
func (o *AuthStatus) SetAuthMethod(v types.EAuthMethod) {
	o.AuthMethod = v
}

// GetIsAPIKey returns value of IsAPIKey
func (o *AuthStatus) GetIsAPIKey() bool {
	return o.IsAPIKey
}

// SetIsAPIKey sets value to IsAPIKey
func (o *AuthStatus) SetIsAPIKey(v bool) {
	o.IsAPIKey = v
}

// GetExternalPermission returns value of ExternalPermission
func (o *AuthStatus) GetExternalPermission() types.ExternalPermission {
	return o.ExternalPermission
}

// SetExternalPermission sets value to ExternalPermission
func (o *AuthStatus) SetExternalPermission(v types.ExternalPermission) {
	o.ExternalPermission = v
}

// GetOperationPenalty returns value of OperationPenalty
func (o *AuthStatus) GetOperationPenalty() types.EOperationPenalty {
	return o.OperationPenalty
}

// SetOperationPenalty sets value to OperationPenalty
func (o *AuthStatus) SetOperationPenalty(v types.EOperationPenalty) {
	o.OperationPenalty = v
}

// GetPermission returns value of Permission
func (o *AuthStatus) GetPermission() types.EPermission {
	return o.Permission
}

// SetPermission sets value to Permission
func (o *AuthStatus) SetPermission(v types.EPermission) {
	o.Permission = v
}

/*************************************************
* AutoBackup
*************************************************/

// AutoBackup represents API parameter/response structure
type AutoBackup struct {
	ID                      types.ID
	Name                    string
	Description             string
	Tags                    types.Tags
	Availability            types.EAvailability
	IconID                  types.ID `mapconv:"Icon.ID"`
	CreatedAt               time.Time
	ModifiedAt              time.Time
	BackupSpanWeekdays      []types.EDayOfTheWeek `mapconv:"Settings.Autobackup.BackupSpanWeekdays"`
	MaximumNumberOfArchives int                   `mapconv:"Settings.Autobackup.MaximumNumberOfArchives"`
	SettingsHash            string                `json:",omitempty" mapconv:",omitempty"`
	DiskID                  types.ID              `mapconv:"Status.DiskID"`
	AccountID               types.ID              `mapconv:"Status.AccountID"`
	ZoneID                  types.ID              `mapconv:"Status.ZoneID"`
	ZoneName                string                `mapconv:"Status.ZoneName"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoBackup) setDefaults() interface{} {
	return &struct {
		ID                      types.ID
		Name                    string
		Description             string
		Tags                    types.Tags
		Availability            types.EAvailability
		IconID                  types.ID `mapconv:"Icon.ID"`
		CreatedAt               time.Time
		ModifiedAt              time.Time
		BackupSpanWeekdays      []types.EDayOfTheWeek `mapconv:"Settings.Autobackup.BackupSpanWeekdays"`
		MaximumNumberOfArchives int                   `mapconv:"Settings.Autobackup.MaximumNumberOfArchives"`
		SettingsHash            string                `json:",omitempty" mapconv:",omitempty"`
		DiskID                  types.ID              `mapconv:"Status.DiskID"`
		AccountID               types.ID              `mapconv:"Status.AccountID"`
		ZoneID                  types.ID              `mapconv:"Status.ZoneID"`
		ZoneName                string                `mapconv:"Status.ZoneName"`
	}{
		ID:                      o.GetID(),
		Name:                    o.GetName(),
		Description:             o.GetDescription(),
		Tags:                    o.GetTags(),
		Availability:            o.GetAvailability(),
		IconID:                  o.GetIconID(),
		CreatedAt:               o.GetCreatedAt(),
		ModifiedAt:              o.GetModifiedAt(),
		BackupSpanWeekdays:      o.GetBackupSpanWeekdays(),
		MaximumNumberOfArchives: o.GetMaximumNumberOfArchives(),
		SettingsHash:            o.GetSettingsHash(),
		DiskID:                  o.GetDiskID(),
		AccountID:               o.GetAccountID(),
		ZoneID:                  o.GetZoneID(),
		ZoneName:                o.GetZoneName(),
	}
}

// GetID returns value of ID
func (o *AutoBackup) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *AutoBackup) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *AutoBackup) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *AutoBackup) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *AutoBackup) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *AutoBackup) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *AutoBackup) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *AutoBackup) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *AutoBackup) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *AutoBackup) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *AutoBackup) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *AutoBackup) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *AutoBackup) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *AutoBackup) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *AutoBackup) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *AutoBackup) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *AutoBackup) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *AutoBackup) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *AutoBackup) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *AutoBackup) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *AutoBackup) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *AutoBackup) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *AutoBackup) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *AutoBackup) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetBackupSpanWeekdays returns value of BackupSpanWeekdays
func (o *AutoBackup) GetBackupSpanWeekdays() []types.EDayOfTheWeek {
	return o.BackupSpanWeekdays
}

// SetBackupSpanWeekdays sets value to BackupSpanWeekdays
func (o *AutoBackup) SetBackupSpanWeekdays(v []types.EDayOfTheWeek) {
	o.BackupSpanWeekdays = v
}

// GetMaximumNumberOfArchives returns value of MaximumNumberOfArchives
func (o *AutoBackup) GetMaximumNumberOfArchives() int {
	return o.MaximumNumberOfArchives
}

// SetMaximumNumberOfArchives sets value to MaximumNumberOfArchives
func (o *AutoBackup) SetMaximumNumberOfArchives(v int) {
	o.MaximumNumberOfArchives = v
}

// GetSettingsHash returns value of SettingsHash
func (o *AutoBackup) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *AutoBackup) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetDiskID returns value of DiskID
func (o *AutoBackup) GetDiskID() types.ID {
	return o.DiskID
}

// SetDiskID sets value to DiskID
func (o *AutoBackup) SetDiskID(v types.ID) {
	o.DiskID = v
}

// GetAccountID returns value of AccountID
func (o *AutoBackup) GetAccountID() types.ID {
	return o.AccountID
}

// SetAccountID sets value to AccountID
func (o *AutoBackup) SetAccountID(v types.ID) {
	o.AccountID = v
}

// GetZoneID returns value of ZoneID
func (o *AutoBackup) GetZoneID() types.ID {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *AutoBackup) SetZoneID(v types.ID) {
	o.ZoneID = v
}

// GetZoneName returns value of ZoneName
func (o *AutoBackup) GetZoneName() string {
	return o.ZoneName
}

// SetZoneName sets value to ZoneName
func (o *AutoBackup) SetZoneName(v string) {
	o.ZoneName = v
}

/*************************************************
* AutoBackupCreateRequest
*************************************************/

// AutoBackupCreateRequest represents API parameter/response structure
type AutoBackupCreateRequest struct {
	DiskID                  types.ID              `mapconv:"Status.DiskID"`
	BackupSpanWeekdays      []types.EDayOfTheWeek `mapconv:"Settings.Autobackup.BackupSpanWeekdays"`
	MaximumNumberOfArchives int                   `mapconv:"Settings.Autobackup.MaximumNumberOfArchives"`
	Name                    string
	Description             string
	Tags                    types.Tags
	IconID                  types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoBackupCreateRequest) setDefaults() interface{} {
	return &struct {
		DiskID                  types.ID              `mapconv:"Status.DiskID"`
		BackupSpanWeekdays      []types.EDayOfTheWeek `mapconv:"Settings.Autobackup.BackupSpanWeekdays"`
		MaximumNumberOfArchives int                   `mapconv:"Settings.Autobackup.MaximumNumberOfArchives"`
		Name                    string
		Description             string
		Tags                    types.Tags
		IconID                  types.ID              `mapconv:"Icon.ID"`
		Class                   string                `mapconv:"Provider.Class"`
		BackupSpanType          types.EBackupSpanType `mapconv:"Settings.Autobackup.BackupSpanType"`
	}{
		DiskID:                  o.GetDiskID(),
		BackupSpanWeekdays:      o.GetBackupSpanWeekdays(),
		MaximumNumberOfArchives: o.GetMaximumNumberOfArchives(),
		Name:                    o.GetName(),
		Description:             o.GetDescription(),
		Tags:                    o.GetTags(),
		IconID:                  o.GetIconID(),
		Class:                   "autobackup",
		BackupSpanType:          types.BackupSpanTypes.Weekdays,
	}
}

// GetDiskID returns value of DiskID
func (o *AutoBackupCreateRequest) GetDiskID() types.ID {
	return o.DiskID
}

// SetDiskID sets value to DiskID
func (o *AutoBackupCreateRequest) SetDiskID(v types.ID) {
	o.DiskID = v
}

// GetBackupSpanWeekdays returns value of BackupSpanWeekdays
func (o *AutoBackupCreateRequest) GetBackupSpanWeekdays() []types.EDayOfTheWeek {
	return o.BackupSpanWeekdays
}

// SetBackupSpanWeekdays sets value to BackupSpanWeekdays
func (o *AutoBackupCreateRequest) SetBackupSpanWeekdays(v []types.EDayOfTheWeek) {
	o.BackupSpanWeekdays = v
}

// GetMaximumNumberOfArchives returns value of MaximumNumberOfArchives
func (o *AutoBackupCreateRequest) GetMaximumNumberOfArchives() int {
	return o.MaximumNumberOfArchives
}

// SetMaximumNumberOfArchives sets value to MaximumNumberOfArchives
func (o *AutoBackupCreateRequest) SetMaximumNumberOfArchives(v int) {
	o.MaximumNumberOfArchives = v
}

// GetName returns value of Name
func (o *AutoBackupCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *AutoBackupCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *AutoBackupCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *AutoBackupCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *AutoBackupCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *AutoBackupCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *AutoBackupCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *AutoBackupCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *AutoBackupCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *AutoBackupCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *AutoBackupCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *AutoBackupCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* AutoBackupUpdateRequest
*************************************************/

// AutoBackupUpdateRequest represents API parameter/response structure
type AutoBackupUpdateRequest struct {
	Name                    string
	Description             string
	Tags                    types.Tags
	IconID                  types.ID              `mapconv:"Icon.ID"`
	BackupSpanWeekdays      []types.EDayOfTheWeek `mapconv:"Settings.Autobackup.BackupSpanWeekdays"`
	MaximumNumberOfArchives int                   `mapconv:"Settings.Autobackup.MaximumNumberOfArchives"`
	SettingsHash            string                `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoBackupUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name                    string
		Description             string
		Tags                    types.Tags
		IconID                  types.ID              `mapconv:"Icon.ID"`
		BackupSpanWeekdays      []types.EDayOfTheWeek `mapconv:"Settings.Autobackup.BackupSpanWeekdays"`
		MaximumNumberOfArchives int                   `mapconv:"Settings.Autobackup.MaximumNumberOfArchives"`
		SettingsHash            string                `json:",omitempty" mapconv:",omitempty"`
		BackupSpanType          types.EBackupSpanType `mapconv:"Settings.Autobackup.BackupSpanType"`
	}{
		Name:                    o.GetName(),
		Description:             o.GetDescription(),
		Tags:                    o.GetTags(),
		IconID:                  o.GetIconID(),
		BackupSpanWeekdays:      o.GetBackupSpanWeekdays(),
		MaximumNumberOfArchives: o.GetMaximumNumberOfArchives(),
		SettingsHash:            o.GetSettingsHash(),
		BackupSpanType:          types.BackupSpanTypes.Weekdays,
	}
}

// GetName returns value of Name
func (o *AutoBackupUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *AutoBackupUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *AutoBackupUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *AutoBackupUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *AutoBackupUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *AutoBackupUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *AutoBackupUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *AutoBackupUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *AutoBackupUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *AutoBackupUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *AutoBackupUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *AutoBackupUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetBackupSpanWeekdays returns value of BackupSpanWeekdays
func (o *AutoBackupUpdateRequest) GetBackupSpanWeekdays() []types.EDayOfTheWeek {
	return o.BackupSpanWeekdays
}

// SetBackupSpanWeekdays sets value to BackupSpanWeekdays
func (o *AutoBackupUpdateRequest) SetBackupSpanWeekdays(v []types.EDayOfTheWeek) {
	o.BackupSpanWeekdays = v
}

// GetMaximumNumberOfArchives returns value of MaximumNumberOfArchives
func (o *AutoBackupUpdateRequest) GetMaximumNumberOfArchives() int {
	return o.MaximumNumberOfArchives
}

// SetMaximumNumberOfArchives sets value to MaximumNumberOfArchives
func (o *AutoBackupUpdateRequest) SetMaximumNumberOfArchives(v int) {
	o.MaximumNumberOfArchives = v
}

// GetSettingsHash returns value of SettingsHash
func (o *AutoBackupUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *AutoBackupUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* AutoBackupUpdateSettingsRequest
*************************************************/

// AutoBackupUpdateSettingsRequest represents API parameter/response structure
type AutoBackupUpdateSettingsRequest struct {
	BackupSpanWeekdays      []types.EDayOfTheWeek `mapconv:"Settings.Autobackup.BackupSpanWeekdays"`
	MaximumNumberOfArchives int                   `mapconv:"Settings.Autobackup.MaximumNumberOfArchives"`
	SettingsHash            string                `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoBackupUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		BackupSpanWeekdays      []types.EDayOfTheWeek `mapconv:"Settings.Autobackup.BackupSpanWeekdays"`
		MaximumNumberOfArchives int                   `mapconv:"Settings.Autobackup.MaximumNumberOfArchives"`
		SettingsHash            string                `json:",omitempty" mapconv:",omitempty"`
		BackupSpanType          types.EBackupSpanType `mapconv:"Settings.Autobackup.BackupSpanType"`
	}{
		BackupSpanWeekdays:      o.GetBackupSpanWeekdays(),
		MaximumNumberOfArchives: o.GetMaximumNumberOfArchives(),
		SettingsHash:            o.GetSettingsHash(),
		BackupSpanType:          types.BackupSpanTypes.Weekdays,
	}
}

// GetBackupSpanWeekdays returns value of BackupSpanWeekdays
func (o *AutoBackupUpdateSettingsRequest) GetBackupSpanWeekdays() []types.EDayOfTheWeek {
	return o.BackupSpanWeekdays
}

// SetBackupSpanWeekdays sets value to BackupSpanWeekdays
func (o *AutoBackupUpdateSettingsRequest) SetBackupSpanWeekdays(v []types.EDayOfTheWeek) {
	o.BackupSpanWeekdays = v
}

// GetMaximumNumberOfArchives returns value of MaximumNumberOfArchives
func (o *AutoBackupUpdateSettingsRequest) GetMaximumNumberOfArchives() int {
	return o.MaximumNumberOfArchives
}

// SetMaximumNumberOfArchives sets value to MaximumNumberOfArchives
func (o *AutoBackupUpdateSettingsRequest) SetMaximumNumberOfArchives(v int) {
	o.MaximumNumberOfArchives = v
}

// GetSettingsHash returns value of SettingsHash
func (o *AutoBackupUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *AutoBackupUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* AutoScale
*************************************************/

// AutoScale represents API parameter/response structure
type AutoScale struct {
	ID                     types.ID
	Name                   string
	Description            string
	Tags                   types.Tags
	Availability           types.EAvailability
	IconID                 types.ID `mapconv:"Icon.ID"`
	CreatedAt              time.Time
	ModifiedAt             time.Time
	Disabled               bool                             `mapconv:"Settings.Disabled"`
	Zones                  []string                         `mapconv:"Settings.Zones"`
	Config                 string                           `mapconv:"Settings.Config"`
	TriggerType            types.EAutoScaleTriggerType      `mapconv:"Settings.TriggerType"`
	CPUThresholdScaling    *AutoScaleCPUThresholdScaling    `mapconv:"Settings.CPUThresholdScaling,recursive"`
	RouterThresholdScaling *AutoScaleRouterThresholdScaling `mapconv:"Settings.RouterThresholdScaling,recursive"`
	ScheduleScaling        []*AutoScaleScheduleScaling      `mapconv:"Settings.ScheduleScaling,recursive"`
	SettingsHash           string                           `json:",omitempty" mapconv:",omitempty"`
	APIKeyID               string                           `mapconv:"Status.APIKey.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoScale) setDefaults() interface{} {
	return &struct {
		ID                     types.ID
		Name                   string
		Description            string
		Tags                   types.Tags
		Availability           types.EAvailability
		IconID                 types.ID `mapconv:"Icon.ID"`
		CreatedAt              time.Time
		ModifiedAt             time.Time
		Disabled               bool                             `mapconv:"Settings.Disabled"`
		Zones                  []string                         `mapconv:"Settings.Zones"`
		Config                 string                           `mapconv:"Settings.Config"`
		TriggerType            types.EAutoScaleTriggerType      `mapconv:"Settings.TriggerType"`
		CPUThresholdScaling    *AutoScaleCPUThresholdScaling    `mapconv:"Settings.CPUThresholdScaling,recursive"`
		RouterThresholdScaling *AutoScaleRouterThresholdScaling `mapconv:"Settings.RouterThresholdScaling,recursive"`
		ScheduleScaling        []*AutoScaleScheduleScaling      `mapconv:"Settings.ScheduleScaling,recursive"`
		SettingsHash           string                           `json:",omitempty" mapconv:",omitempty"`
		APIKeyID               string                           `mapconv:"Status.APIKey.ID"`
	}{
		ID:                     o.GetID(),
		Name:                   o.GetName(),
		Description:            o.GetDescription(),
		Tags:                   o.GetTags(),
		Availability:           o.GetAvailability(),
		IconID:                 o.GetIconID(),
		CreatedAt:              o.GetCreatedAt(),
		ModifiedAt:             o.GetModifiedAt(),
		Disabled:               o.GetDisabled(),
		Zones:                  o.GetZones(),
		Config:                 o.GetConfig(),
		TriggerType:            o.GetTriggerType(),
		CPUThresholdScaling:    o.GetCPUThresholdScaling(),
		RouterThresholdScaling: o.GetRouterThresholdScaling(),
		ScheduleScaling:        o.GetScheduleScaling(),
		SettingsHash:           o.GetSettingsHash(),
		APIKeyID:               o.GetAPIKeyID(),
	}
}

// GetID returns value of ID
func (o *AutoScale) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *AutoScale) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *AutoScale) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *AutoScale) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *AutoScale) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *AutoScale) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *AutoScale) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *AutoScale) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *AutoScale) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *AutoScale) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *AutoScale) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *AutoScale) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *AutoScale) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *AutoScale) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *AutoScale) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *AutoScale) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *AutoScale) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *AutoScale) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *AutoScale) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *AutoScale) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *AutoScale) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *AutoScale) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *AutoScale) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *AutoScale) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetDisabled returns value of Disabled
func (o *AutoScale) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *AutoScale) SetDisabled(v bool) {
	o.Disabled = v
}

// GetZones returns value of Zones
func (o *AutoScale) GetZones() []string {
	return o.Zones
}

// SetZones sets value to Zones
func (o *AutoScale) SetZones(v []string) {
	o.Zones = v
}

// GetConfig returns value of Config
func (o *AutoScale) GetConfig() string {
	return o.Config
}

// SetConfig sets value to Config
func (o *AutoScale) SetConfig(v string) {
	o.Config = v
}

// GetTriggerType returns value of TriggerType
func (o *AutoScale) GetTriggerType() types.EAutoScaleTriggerType {
	return o.TriggerType
}

// SetTriggerType sets value to TriggerType
func (o *AutoScale) SetTriggerType(v types.EAutoScaleTriggerType) {
	o.TriggerType = v
}

// GetCPUThresholdScaling returns value of CPUThresholdScaling
func (o *AutoScale) GetCPUThresholdScaling() *AutoScaleCPUThresholdScaling {
	return o.CPUThresholdScaling
}

// SetCPUThresholdScaling sets value to CPUThresholdScaling
func (o *AutoScale) SetCPUThresholdScaling(v *AutoScaleCPUThresholdScaling) {
	o.CPUThresholdScaling = v
}

// GetRouterThresholdScaling returns value of RouterThresholdScaling
func (o *AutoScale) GetRouterThresholdScaling() *AutoScaleRouterThresholdScaling {
	return o.RouterThresholdScaling
}

// SetRouterThresholdScaling sets value to RouterThresholdScaling
func (o *AutoScale) SetRouterThresholdScaling(v *AutoScaleRouterThresholdScaling) {
	o.RouterThresholdScaling = v
}

// GetScheduleScaling returns value of ScheduleScaling
func (o *AutoScale) GetScheduleScaling() []*AutoScaleScheduleScaling {
	return o.ScheduleScaling
}

// SetScheduleScaling sets value to ScheduleScaling
func (o *AutoScale) SetScheduleScaling(v []*AutoScaleScheduleScaling) {
	o.ScheduleScaling = v
}

// GetSettingsHash returns value of SettingsHash
func (o *AutoScale) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *AutoScale) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetAPIKeyID returns value of APIKeyID
func (o *AutoScale) GetAPIKeyID() string {
	return o.APIKeyID
}

// SetAPIKeyID sets value to APIKeyID
func (o *AutoScale) SetAPIKeyID(v string) {
	o.APIKeyID = v
}

/*************************************************
* AutoScaleCPUThresholdScaling
*************************************************/

// AutoScaleCPUThresholdScaling represents API parameter/response structure
type AutoScaleCPUThresholdScaling struct {
	ServerPrefix string
	Up           int
	Down         int
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoScaleCPUThresholdScaling) setDefaults() interface{} {
	return &struct {
		ServerPrefix string
		Up           int
		Down         int
	}{
		ServerPrefix: o.GetServerPrefix(),
		Up:           o.GetUp(),
		Down:         o.GetDown(),
	}
}

// GetServerPrefix returns value of ServerPrefix
func (o *AutoScaleCPUThresholdScaling) GetServerPrefix() string {
	return o.ServerPrefix
}

// SetServerPrefix sets value to ServerPrefix
func (o *AutoScaleCPUThresholdScaling) SetServerPrefix(v string) {
	o.ServerPrefix = v
}

// GetUp returns value of Up
func (o *AutoScaleCPUThresholdScaling) GetUp() int {
	return o.Up
}

// SetUp sets value to Up
func (o *AutoScaleCPUThresholdScaling) SetUp(v int) {
	o.Up = v
}

// GetDown returns value of Down
func (o *AutoScaleCPUThresholdScaling) GetDown() int {
	return o.Down
}

// SetDown sets value to Down
func (o *AutoScaleCPUThresholdScaling) SetDown(v int) {
	o.Down = v
}

/*************************************************
* AutoScaleRouterThresholdScaling
*************************************************/

// AutoScaleRouterThresholdScaling represents API parameter/response structure
type AutoScaleRouterThresholdScaling struct {
	RouterPrefix string
	Direction    string
	Mbps         int
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoScaleRouterThresholdScaling) setDefaults() interface{} {
	return &struct {
		RouterPrefix string
		Direction    string
		Mbps         int
	}{
		RouterPrefix: o.GetRouterPrefix(),
		Direction:    o.GetDirection(),
		Mbps:         o.GetMbps(),
	}
}

// GetRouterPrefix returns value of RouterPrefix
func (o *AutoScaleRouterThresholdScaling) GetRouterPrefix() string {
	return o.RouterPrefix
}

// SetRouterPrefix sets value to RouterPrefix
func (o *AutoScaleRouterThresholdScaling) SetRouterPrefix(v string) {
	o.RouterPrefix = v
}

// GetDirection returns value of Direction
func (o *AutoScaleRouterThresholdScaling) GetDirection() string {
	return o.Direction
}

// SetDirection sets value to Direction
func (o *AutoScaleRouterThresholdScaling) SetDirection(v string) {
	o.Direction = v
}

// GetMbps returns value of Mbps
func (o *AutoScaleRouterThresholdScaling) GetMbps() int {
	return o.Mbps
}

// SetMbps sets value to Mbps
func (o *AutoScaleRouterThresholdScaling) SetMbps(v int) {
	o.Mbps = v
}

/*************************************************
* AutoScaleScheduleScaling
*************************************************/

// AutoScaleScheduleScaling represents API parameter/response structure
type AutoScaleScheduleScaling struct {
	Action    types.EAutoScaleAction
	Hour      int
	Minute    int
	DayOfWeek []types.EDayOfTheWeek
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoScaleScheduleScaling) setDefaults() interface{} {
	return &struct {
		Action    types.EAutoScaleAction
		Hour      int
		Minute    int
		DayOfWeek []types.EDayOfTheWeek
	}{
		Action:    o.GetAction(),
		Hour:      o.GetHour(),
		Minute:    o.GetMinute(),
		DayOfWeek: o.GetDayOfWeek(),
	}
}

// GetAction returns value of Action
func (o *AutoScaleScheduleScaling) GetAction() types.EAutoScaleAction {
	return o.Action
}

// SetAction sets value to Action
func (o *AutoScaleScheduleScaling) SetAction(v types.EAutoScaleAction) {
	o.Action = v
}

// GetHour returns value of Hour
func (o *AutoScaleScheduleScaling) GetHour() int {
	return o.Hour
}

// SetHour sets value to Hour
func (o *AutoScaleScheduleScaling) SetHour(v int) {
	o.Hour = v
}

// GetMinute returns value of Minute
func (o *AutoScaleScheduleScaling) GetMinute() int {
	return o.Minute
}

// SetMinute sets value to Minute
func (o *AutoScaleScheduleScaling) SetMinute(v int) {
	o.Minute = v
}

// GetDayOfWeek returns value of DayOfWeek
func (o *AutoScaleScheduleScaling) GetDayOfWeek() []types.EDayOfTheWeek {
	return o.DayOfWeek
}

// SetDayOfWeek sets value to DayOfWeek
func (o *AutoScaleScheduleScaling) SetDayOfWeek(v []types.EDayOfTheWeek) {
	o.DayOfWeek = v
}

/*************************************************
* AutoScaleCreateRequest
*************************************************/

// AutoScaleCreateRequest represents API parameter/response structure
type AutoScaleCreateRequest struct {
	Name                   string
	Description            string
	Tags                   types.Tags
	IconID                 types.ID                         `mapconv:"Icon.ID"`
	Disabled               bool                             `mapconv:"Settings.Disabled"`
	Zones                  []string                         `mapconv:"Settings.Zones"`
	Config                 string                           `mapconv:"Settings.Config"`
	TriggerType            types.EAutoScaleTriggerType      `mapconv:"Settings.TriggerType"`
	CPUThresholdScaling    *AutoScaleCPUThresholdScaling    `mapconv:"Settings.CPUThresholdScaling,recursive"`
	RouterThresholdScaling *AutoScaleRouterThresholdScaling `mapconv:"Settings.RouterThresholdScaling,recursive"`
	ScheduleScaling        []*AutoScaleScheduleScaling      `mapconv:"Settings.ScheduleScaling,recursive"`
	APIKeyID               string                           `mapconv:"Status.APIKey.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoScaleCreateRequest) setDefaults() interface{} {
	return &struct {
		Name                   string
		Description            string
		Tags                   types.Tags
		IconID                 types.ID                         `mapconv:"Icon.ID"`
		Disabled               bool                             `mapconv:"Settings.Disabled"`
		Zones                  []string                         `mapconv:"Settings.Zones"`
		Config                 string                           `mapconv:"Settings.Config"`
		TriggerType            types.EAutoScaleTriggerType      `mapconv:"Settings.TriggerType"`
		CPUThresholdScaling    *AutoScaleCPUThresholdScaling    `mapconv:"Settings.CPUThresholdScaling,recursive"`
		RouterThresholdScaling *AutoScaleRouterThresholdScaling `mapconv:"Settings.RouterThresholdScaling,recursive"`
		ScheduleScaling        []*AutoScaleScheduleScaling      `mapconv:"Settings.ScheduleScaling,recursive"`
		APIKeyID               string                           `mapconv:"Status.APIKey.ID"`
		Class                  string                           `mapconv:"Provider.Class"`
		ServiceClass           string
	}{
		Name:                   o.GetName(),
		Description:            o.GetDescription(),
		Tags:                   o.GetTags(),
		IconID:                 o.GetIconID(),
		Disabled:               o.GetDisabled(),
		Zones:                  o.GetZones(),
		Config:                 o.GetConfig(),
		TriggerType:            o.GetTriggerType(),
		CPUThresholdScaling:    o.GetCPUThresholdScaling(),
		RouterThresholdScaling: o.GetRouterThresholdScaling(),
		ScheduleScaling:        o.GetScheduleScaling(),
		APIKeyID:               o.GetAPIKeyID(),
		Class:                  "autoscale",
		ServiceClass:           "cloud/autoscale/1",
	}
}

// GetName returns value of Name
func (o *AutoScaleCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *AutoScaleCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *AutoScaleCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *AutoScaleCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *AutoScaleCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *AutoScaleCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *AutoScaleCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *AutoScaleCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *AutoScaleCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *AutoScaleCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *AutoScaleCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *AutoScaleCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetDisabled returns value of Disabled
func (o *AutoScaleCreateRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *AutoScaleCreateRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetZones returns value of Zones
func (o *AutoScaleCreateRequest) GetZones() []string {
	return o.Zones
}

// SetZones sets value to Zones
func (o *AutoScaleCreateRequest) SetZones(v []string) {
	o.Zones = v
}

// GetConfig returns value of Config
func (o *AutoScaleCreateRequest) GetConfig() string {
	return o.Config
}

// SetConfig sets value to Config
func (o *AutoScaleCreateRequest) SetConfig(v string) {
	o.Config = v
}

// GetTriggerType returns value of TriggerType
func (o *AutoScaleCreateRequest) GetTriggerType() types.EAutoScaleTriggerType {
	return o.TriggerType
}

// SetTriggerType sets value to TriggerType
func (o *AutoScaleCreateRequest) SetTriggerType(v types.EAutoScaleTriggerType) {
	o.TriggerType = v
}

// GetCPUThresholdScaling returns value of CPUThresholdScaling
func (o *AutoScaleCreateRequest) GetCPUThresholdScaling() *AutoScaleCPUThresholdScaling {
	return o.CPUThresholdScaling
}

// SetCPUThresholdScaling sets value to CPUThresholdScaling
func (o *AutoScaleCreateRequest) SetCPUThresholdScaling(v *AutoScaleCPUThresholdScaling) {
	o.CPUThresholdScaling = v
}

// GetRouterThresholdScaling returns value of RouterThresholdScaling
func (o *AutoScaleCreateRequest) GetRouterThresholdScaling() *AutoScaleRouterThresholdScaling {
	return o.RouterThresholdScaling
}

// SetRouterThresholdScaling sets value to RouterThresholdScaling
func (o *AutoScaleCreateRequest) SetRouterThresholdScaling(v *AutoScaleRouterThresholdScaling) {
	o.RouterThresholdScaling = v
}

// GetScheduleScaling returns value of ScheduleScaling
func (o *AutoScaleCreateRequest) GetScheduleScaling() []*AutoScaleScheduleScaling {
	return o.ScheduleScaling
}

// SetScheduleScaling sets value to ScheduleScaling
func (o *AutoScaleCreateRequest) SetScheduleScaling(v []*AutoScaleScheduleScaling) {
	o.ScheduleScaling = v
}

// GetAPIKeyID returns value of APIKeyID
func (o *AutoScaleCreateRequest) GetAPIKeyID() string {
	return o.APIKeyID
}

// SetAPIKeyID sets value to APIKeyID
func (o *AutoScaleCreateRequest) SetAPIKeyID(v string) {
	o.APIKeyID = v
}

/*************************************************
* AutoScaleUpdateRequest
*************************************************/

// AutoScaleUpdateRequest represents API parameter/response structure
type AutoScaleUpdateRequest struct {
	Name                   string
	Description            string
	Tags                   types.Tags
	IconID                 types.ID                         `mapconv:"Icon.ID"`
	Disabled               bool                             `mapconv:"Settings.Disabled"`
	Zones                  []string                         `mapconv:"Settings.Zones"`
	Config                 string                           `mapconv:"Settings.Config"`
	TriggerType            types.EAutoScaleTriggerType      `mapconv:"Settings.TriggerType"`
	CPUThresholdScaling    *AutoScaleCPUThresholdScaling    `mapconv:"Settings.CPUThresholdScaling,recursive"`
	RouterThresholdScaling *AutoScaleRouterThresholdScaling `mapconv:"Settings.RouterThresholdScaling,recursive"`
	ScheduleScaling        []*AutoScaleScheduleScaling      `mapconv:"Settings.ScheduleScaling,recursive"`
	SettingsHash           string                           `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoScaleUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name                   string
		Description            string
		Tags                   types.Tags
		IconID                 types.ID                         `mapconv:"Icon.ID"`
		Disabled               bool                             `mapconv:"Settings.Disabled"`
		Zones                  []string                         `mapconv:"Settings.Zones"`
		Config                 string                           `mapconv:"Settings.Config"`
		TriggerType            types.EAutoScaleTriggerType      `mapconv:"Settings.TriggerType"`
		CPUThresholdScaling    *AutoScaleCPUThresholdScaling    `mapconv:"Settings.CPUThresholdScaling,recursive"`
		RouterThresholdScaling *AutoScaleRouterThresholdScaling `mapconv:"Settings.RouterThresholdScaling,recursive"`
		ScheduleScaling        []*AutoScaleScheduleScaling      `mapconv:"Settings.ScheduleScaling,recursive"`
		SettingsHash           string                           `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:                   o.GetName(),
		Description:            o.GetDescription(),
		Tags:                   o.GetTags(),
		IconID:                 o.GetIconID(),
		Disabled:               o.GetDisabled(),
		Zones:                  o.GetZones(),
		Config:                 o.GetConfig(),
		TriggerType:            o.GetTriggerType(),
		CPUThresholdScaling:    o.GetCPUThresholdScaling(),
		RouterThresholdScaling: o.GetRouterThresholdScaling(),
		ScheduleScaling:        o.GetScheduleScaling(),
		SettingsHash:           o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *AutoScaleUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *AutoScaleUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *AutoScaleUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *AutoScaleUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *AutoScaleUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *AutoScaleUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *AutoScaleUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *AutoScaleUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *AutoScaleUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *AutoScaleUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *AutoScaleUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *AutoScaleUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetDisabled returns value of Disabled
func (o *AutoScaleUpdateRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *AutoScaleUpdateRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetZones returns value of Zones
func (o *AutoScaleUpdateRequest) GetZones() []string {
	return o.Zones
}

// SetZones sets value to Zones
func (o *AutoScaleUpdateRequest) SetZones(v []string) {
	o.Zones = v
}

// GetConfig returns value of Config
func (o *AutoScaleUpdateRequest) GetConfig() string {
	return o.Config
}

// SetConfig sets value to Config
func (o *AutoScaleUpdateRequest) SetConfig(v string) {
	o.Config = v
}

// GetTriggerType returns value of TriggerType
func (o *AutoScaleUpdateRequest) GetTriggerType() types.EAutoScaleTriggerType {
	return o.TriggerType
}

// SetTriggerType sets value to TriggerType
func (o *AutoScaleUpdateRequest) SetTriggerType(v types.EAutoScaleTriggerType) {
	o.TriggerType = v
}

// GetCPUThresholdScaling returns value of CPUThresholdScaling
func (o *AutoScaleUpdateRequest) GetCPUThresholdScaling() *AutoScaleCPUThresholdScaling {
	return o.CPUThresholdScaling
}

// SetCPUThresholdScaling sets value to CPUThresholdScaling
func (o *AutoScaleUpdateRequest) SetCPUThresholdScaling(v *AutoScaleCPUThresholdScaling) {
	o.CPUThresholdScaling = v
}

// GetRouterThresholdScaling returns value of RouterThresholdScaling
func (o *AutoScaleUpdateRequest) GetRouterThresholdScaling() *AutoScaleRouterThresholdScaling {
	return o.RouterThresholdScaling
}

// SetRouterThresholdScaling sets value to RouterThresholdScaling
func (o *AutoScaleUpdateRequest) SetRouterThresholdScaling(v *AutoScaleRouterThresholdScaling) {
	o.RouterThresholdScaling = v
}

// GetScheduleScaling returns value of ScheduleScaling
func (o *AutoScaleUpdateRequest) GetScheduleScaling() []*AutoScaleScheduleScaling {
	return o.ScheduleScaling
}

// SetScheduleScaling sets value to ScheduleScaling
func (o *AutoScaleUpdateRequest) SetScheduleScaling(v []*AutoScaleScheduleScaling) {
	o.ScheduleScaling = v
}

// GetSettingsHash returns value of SettingsHash
func (o *AutoScaleUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *AutoScaleUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* AutoScaleUpdateSettingsRequest
*************************************************/

// AutoScaleUpdateSettingsRequest represents API parameter/response structure
type AutoScaleUpdateSettingsRequest struct {
	Disabled               bool                             `mapconv:"Settings.Disabled"`
	Zones                  []string                         `mapconv:"Settings.Zones"`
	Config                 string                           `mapconv:"Settings.Config"`
	TriggerType            types.EAutoScaleTriggerType      `mapconv:"Settings.TriggerType"`
	CPUThresholdScaling    *AutoScaleCPUThresholdScaling    `mapconv:"Settings.CPUThresholdScaling,recursive"`
	RouterThresholdScaling *AutoScaleRouterThresholdScaling `mapconv:"Settings.RouterThresholdScaling,recursive"`
	ScheduleScaling        []*AutoScaleScheduleScaling      `mapconv:"Settings.ScheduleScaling,recursive"`
	SettingsHash           string                           `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoScaleUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		Disabled               bool                             `mapconv:"Settings.Disabled"`
		Zones                  []string                         `mapconv:"Settings.Zones"`
		Config                 string                           `mapconv:"Settings.Config"`
		TriggerType            types.EAutoScaleTriggerType      `mapconv:"Settings.TriggerType"`
		CPUThresholdScaling    *AutoScaleCPUThresholdScaling    `mapconv:"Settings.CPUThresholdScaling,recursive"`
		RouterThresholdScaling *AutoScaleRouterThresholdScaling `mapconv:"Settings.RouterThresholdScaling,recursive"`
		ScheduleScaling        []*AutoScaleScheduleScaling      `mapconv:"Settings.ScheduleScaling,recursive"`
		SettingsHash           string                           `json:",omitempty" mapconv:",omitempty"`
	}{
		Disabled:               o.GetDisabled(),
		Zones:                  o.GetZones(),
		Config:                 o.GetConfig(),
		TriggerType:            o.GetTriggerType(),
		CPUThresholdScaling:    o.GetCPUThresholdScaling(),
		RouterThresholdScaling: o.GetRouterThresholdScaling(),
		ScheduleScaling:        o.GetScheduleScaling(),
		SettingsHash:           o.GetSettingsHash(),
	}
}

// GetDisabled returns value of Disabled
func (o *AutoScaleUpdateSettingsRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *AutoScaleUpdateSettingsRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetZones returns value of Zones
func (o *AutoScaleUpdateSettingsRequest) GetZones() []string {
	return o.Zones
}

// SetZones sets value to Zones
func (o *AutoScaleUpdateSettingsRequest) SetZones(v []string) {
	o.Zones = v
}

// GetConfig returns value of Config
func (o *AutoScaleUpdateSettingsRequest) GetConfig() string {
	return o.Config
}

// SetConfig sets value to Config
func (o *AutoScaleUpdateSettingsRequest) SetConfig(v string) {
	o.Config = v
}

// GetTriggerType returns value of TriggerType
func (o *AutoScaleUpdateSettingsRequest) GetTriggerType() types.EAutoScaleTriggerType {
	return o.TriggerType
}

// SetTriggerType sets value to TriggerType
func (o *AutoScaleUpdateSettingsRequest) SetTriggerType(v types.EAutoScaleTriggerType) {
	o.TriggerType = v
}

// GetCPUThresholdScaling returns value of CPUThresholdScaling
func (o *AutoScaleUpdateSettingsRequest) GetCPUThresholdScaling() *AutoScaleCPUThresholdScaling {
	return o.CPUThresholdScaling
}

// SetCPUThresholdScaling sets value to CPUThresholdScaling
func (o *AutoScaleUpdateSettingsRequest) SetCPUThresholdScaling(v *AutoScaleCPUThresholdScaling) {
	o.CPUThresholdScaling = v
}

// GetRouterThresholdScaling returns value of RouterThresholdScaling
func (o *AutoScaleUpdateSettingsRequest) GetRouterThresholdScaling() *AutoScaleRouterThresholdScaling {
	return o.RouterThresholdScaling
}

// SetRouterThresholdScaling sets value to RouterThresholdScaling
func (o *AutoScaleUpdateSettingsRequest) SetRouterThresholdScaling(v *AutoScaleRouterThresholdScaling) {
	o.RouterThresholdScaling = v
}

// GetScheduleScaling returns value of ScheduleScaling
func (o *AutoScaleUpdateSettingsRequest) GetScheduleScaling() []*AutoScaleScheduleScaling {
	return o.ScheduleScaling
}

// SetScheduleScaling sets value to ScheduleScaling
func (o *AutoScaleUpdateSettingsRequest) SetScheduleScaling(v []*AutoScaleScheduleScaling) {
	o.ScheduleScaling = v
}

// GetSettingsHash returns value of SettingsHash
func (o *AutoScaleUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *AutoScaleUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* AutoScaleStatus
*************************************************/

// AutoScaleStatus represents API parameter/response structure
type AutoScaleStatus struct {
	LatestLogs    []string
	ResourcesText string
}

// setDefaults implements iaas.argumentDefaulter
func (o *AutoScaleStatus) setDefaults() interface{} {
	return &struct {
		LatestLogs    []string
		ResourcesText string
	}{
		LatestLogs:    o.GetLatestLogs(),
		ResourcesText: o.GetResourcesText(),
	}
}

// GetLatestLogs returns value of LatestLogs
func (o *AutoScaleStatus) GetLatestLogs() []string {
	return o.LatestLogs
}

// SetLatestLogs sets value to LatestLogs
func (o *AutoScaleStatus) SetLatestLogs(v []string) {
	o.LatestLogs = v
}

// GetResourcesText returns value of ResourcesText
func (o *AutoScaleStatus) GetResourcesText() string {
	return o.ResourcesText
}

// SetResourcesText sets value to ResourcesText
func (o *AutoScaleStatus) SetResourcesText(v string) {
	o.ResourcesText = v
}

/*************************************************
* Bill
*************************************************/

// Bill represents API parameter/response structure
type Bill struct {
	ID             types.ID
	Amount         int64
	Date           time.Time
	MemberID       string
	Paid           bool
	PayLimit       time.Time
	PaymentClassID types.ID
}

// setDefaults implements iaas.argumentDefaulter
func (o *Bill) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		Amount         int64
		Date           time.Time
		MemberID       string
		Paid           bool
		PayLimit       time.Time
		PaymentClassID types.ID
	}{
		ID:             o.GetID(),
		Amount:         o.GetAmount(),
		Date:           o.GetDate(),
		MemberID:       o.GetMemberID(),
		Paid:           o.GetPaid(),
		PayLimit:       o.GetPayLimit(),
		PaymentClassID: o.GetPaymentClassID(),
	}
}

// GetID returns value of ID
func (o *Bill) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Bill) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Bill) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Bill) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Bill) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Bill) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetAmount returns value of Amount
func (o *Bill) GetAmount() int64 {
	return o.Amount
}

// SetAmount sets value to Amount
func (o *Bill) SetAmount(v int64) {
	o.Amount = v
}

// GetDate returns value of Date
func (o *Bill) GetDate() time.Time {
	return o.Date
}

// SetDate sets value to Date
func (o *Bill) SetDate(v time.Time) {
	o.Date = v
}

// GetMemberID returns value of MemberID
func (o *Bill) GetMemberID() string {
	return o.MemberID
}

// SetMemberID sets value to MemberID
func (o *Bill) SetMemberID(v string) {
	o.MemberID = v
}

// GetPaid returns value of Paid
func (o *Bill) GetPaid() bool {
	return o.Paid
}

// SetPaid sets value to Paid
func (o *Bill) SetPaid(v bool) {
	o.Paid = v
}

// GetPayLimit returns value of PayLimit
func (o *Bill) GetPayLimit() time.Time {
	return o.PayLimit
}

// SetPayLimit sets value to PayLimit
func (o *Bill) SetPayLimit(v time.Time) {
	o.PayLimit = v
}

// GetPaymentClassID returns value of PaymentClassID
func (o *Bill) GetPaymentClassID() types.ID {
	return o.PaymentClassID
}

// SetPaymentClassID sets value to PaymentClassID
func (o *Bill) SetPaymentClassID(v types.ID) {
	o.PaymentClassID = v
}

/*************************************************
* BillDetail
*************************************************/

// BillDetail represents API parameter/response structure
type BillDetail struct {
	ID               types.ID
	Amount           int64
	Description      string
	ServiceClassID   types.ID
	ServiceClassPath string
	Usage            int64
	FormattedUsage   string
	ServiceUsagePath string
	Zone             string
	ContractEndAt    time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *BillDetail) setDefaults() interface{} {
	return &struct {
		ID               types.ID
		Amount           int64
		Description      string
		ServiceClassID   types.ID
		ServiceClassPath string
		Usage            int64
		FormattedUsage   string
		ServiceUsagePath string
		Zone             string
		ContractEndAt    time.Time
	}{
		ID:               o.GetID(),
		Amount:           o.GetAmount(),
		Description:      o.GetDescription(),
		ServiceClassID:   o.GetServiceClassID(),
		ServiceClassPath: o.GetServiceClassPath(),
		Usage:            o.GetUsage(),
		FormattedUsage:   o.GetFormattedUsage(),
		ServiceUsagePath: o.GetServiceUsagePath(),
		Zone:             o.GetZone(),
		ContractEndAt:    o.GetContractEndAt(),
	}
}

// GetID returns value of ID
func (o *BillDetail) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *BillDetail) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *BillDetail) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *BillDetail) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *BillDetail) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *BillDetail) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetAmount returns value of Amount
func (o *BillDetail) GetAmount() int64 {
	return o.Amount
}

// SetAmount sets value to Amount
func (o *BillDetail) SetAmount(v int64) {
	o.Amount = v
}

// GetDescription returns value of Description
func (o *BillDetail) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *BillDetail) SetDescription(v string) {
	o.Description = v
}

// GetServiceClassID returns value of ServiceClassID
func (o *BillDetail) GetServiceClassID() types.ID {
	return o.ServiceClassID
}

// SetServiceClassID sets value to ServiceClassID
func (o *BillDetail) SetServiceClassID(v types.ID) {
	o.ServiceClassID = v
}

// GetServiceClassPath returns value of ServiceClassPath
func (o *BillDetail) GetServiceClassPath() string {
	return o.ServiceClassPath
}

// SetServiceClassPath sets value to ServiceClassPath
func (o *BillDetail) SetServiceClassPath(v string) {
	o.ServiceClassPath = v
}

// GetUsage returns value of Usage
func (o *BillDetail) GetUsage() int64 {
	return o.Usage
}

// SetUsage sets value to Usage
func (o *BillDetail) SetUsage(v int64) {
	o.Usage = v
}

// GetFormattedUsage returns value of FormattedUsage
func (o *BillDetail) GetFormattedUsage() string {
	return o.FormattedUsage
}

// SetFormattedUsage sets value to FormattedUsage
func (o *BillDetail) SetFormattedUsage(v string) {
	o.FormattedUsage = v
}

// GetServiceUsagePath returns value of ServiceUsagePath
func (o *BillDetail) GetServiceUsagePath() string {
	return o.ServiceUsagePath
}

// SetServiceUsagePath sets value to ServiceUsagePath
func (o *BillDetail) SetServiceUsagePath(v string) {
	o.ServiceUsagePath = v
}

// GetZone returns value of Zone
func (o *BillDetail) GetZone() string {
	return o.Zone
}

// SetZone sets value to Zone
func (o *BillDetail) SetZone(v string) {
	o.Zone = v
}

// GetContractEndAt returns value of ContractEndAt
func (o *BillDetail) GetContractEndAt() time.Time {
	return o.ContractEndAt
}

// SetContractEndAt sets value to ContractEndAt
func (o *BillDetail) SetContractEndAt(v time.Time) {
	o.ContractEndAt = v
}

/*************************************************
* BillDetailCSV
*************************************************/

// BillDetailCSV represents API parameter/response structure
type BillDetailCSV struct {
	Count       int
	ResponsedAt time.Time
	Filename    string
	RawBody     string
	HeaderRow   []string
	BodyRows    [][]string
}

// setDefaults implements iaas.argumentDefaulter
func (o *BillDetailCSV) setDefaults() interface{} {
	return &struct {
		Count       int
		ResponsedAt time.Time
		Filename    string
		RawBody     string
		HeaderRow   []string
		BodyRows    [][]string
	}{
		Count:       o.GetCount(),
		ResponsedAt: o.GetResponsedAt(),
		Filename:    o.GetFilename(),
		RawBody:     o.GetRawBody(),
		HeaderRow:   o.GetHeaderRow(),
		BodyRows:    o.GetBodyRows(),
	}
}

// GetCount returns value of Count
func (o *BillDetailCSV) GetCount() int {
	return o.Count
}

// SetCount sets value to Count
func (o *BillDetailCSV) SetCount(v int) {
	o.Count = v
}

// GetResponsedAt returns value of ResponsedAt
func (o *BillDetailCSV) GetResponsedAt() time.Time {
	return o.ResponsedAt
}

// SetResponsedAt sets value to ResponsedAt
func (o *BillDetailCSV) SetResponsedAt(v time.Time) {
	o.ResponsedAt = v
}

// GetFilename returns value of Filename
func (o *BillDetailCSV) GetFilename() string {
	return o.Filename
}

// SetFilename sets value to Filename
func (o *BillDetailCSV) SetFilename(v string) {
	o.Filename = v
}

// GetRawBody returns value of RawBody
func (o *BillDetailCSV) GetRawBody() string {
	return o.RawBody
}

// SetRawBody sets value to RawBody
func (o *BillDetailCSV) SetRawBody(v string) {
	o.RawBody = v
}

// GetHeaderRow returns value of HeaderRow
func (o *BillDetailCSV) GetHeaderRow() []string {
	return o.HeaderRow
}

// SetHeaderRow sets value to HeaderRow
func (o *BillDetailCSV) SetHeaderRow(v []string) {
	o.HeaderRow = v
}

// GetBodyRows returns value of BodyRows
func (o *BillDetailCSV) GetBodyRows() [][]string {
	return o.BodyRows
}

// SetBodyRows sets value to BodyRows
func (o *BillDetailCSV) SetBodyRows(v [][]string) {
	o.BodyRows = v
}

/*************************************************
* Bridge
*************************************************/

// Bridge represents API parameter/response structure
type Bridge struct {
	ID           types.ID
	Name         string
	Description  string
	CreatedAt    time.Time
	Region       *Region       `json:",omitempty"`
	BridgeInfo   []*BridgeInfo `mapconv:"Info.[]Switches,recursive"`
	SwitchInZone *BridgeSwitchInfo
}

// setDefaults implements iaas.argumentDefaulter
func (o *Bridge) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		CreatedAt    time.Time
		Region       *Region       `json:",omitempty"`
		BridgeInfo   []*BridgeInfo `mapconv:"Info.[]Switches,recursive"`
		SwitchInZone *BridgeSwitchInfo
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		CreatedAt:    o.GetCreatedAt(),
		Region:       o.GetRegion(),
		BridgeInfo:   o.GetBridgeInfo(),
		SwitchInZone: o.GetSwitchInZone(),
	}
}

// GetID returns value of ID
func (o *Bridge) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Bridge) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Bridge) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Bridge) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Bridge) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Bridge) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Bridge) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Bridge) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Bridge) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Bridge) SetDescription(v string) {
	o.Description = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Bridge) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Bridge) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetRegion returns value of Region
func (o *Bridge) GetRegion() *Region {
	return o.Region
}

// SetRegion sets value to Region
func (o *Bridge) SetRegion(v *Region) {
	o.Region = v
}

// GetBridgeInfo returns value of BridgeInfo
func (o *Bridge) GetBridgeInfo() []*BridgeInfo {
	return o.BridgeInfo
}

// SetBridgeInfo sets value to BridgeInfo
func (o *Bridge) SetBridgeInfo(v []*BridgeInfo) {
	o.BridgeInfo = v
}

// GetSwitchInZone returns value of SwitchInZone
func (o *Bridge) GetSwitchInZone() *BridgeSwitchInfo {
	return o.SwitchInZone
}

// SetSwitchInZone sets value to SwitchInZone
func (o *Bridge) SetSwitchInZone(v *BridgeSwitchInfo) {
	o.SwitchInZone = v
}

/*************************************************
* Region
*************************************************/

// Region represents API parameter/response structure
type Region struct {
	ID          types.ID
	Name        string
	Description string
	NameServers []string `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *Region) setDefaults() interface{} {
	return &struct {
		ID          types.ID
		Name        string
		Description string
		NameServers []string `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:          o.GetID(),
		Name:        o.GetName(),
		Description: o.GetDescription(),
		NameServers: o.GetNameServers(),
	}
}

// GetID returns value of ID
func (o *Region) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Region) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Region) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Region) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Region) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Region) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Region) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Region) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Region) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Region) SetDescription(v string) {
	o.Description = v
}

// GetNameServers returns value of NameServers
func (o *Region) GetNameServers() []string {
	return o.NameServers
}

// SetNameServers sets value to NameServers
func (o *Region) SetNameServers(v []string) {
	o.NameServers = v
}

/*************************************************
* BridgeInfo
*************************************************/

// BridgeInfo represents API parameter/response structure
type BridgeInfo struct {
	ID       types.ID
	Name     string
	ZoneID   types.ID `mapconv:"Zone.ID"`
	ZoneName string   `mapconv:"Zone.Name"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *BridgeInfo) setDefaults() interface{} {
	return &struct {
		ID       types.ID
		Name     string
		ZoneID   types.ID `mapconv:"Zone.ID"`
		ZoneName string   `mapconv:"Zone.Name"`
	}{
		ID:       o.GetID(),
		Name:     o.GetName(),
		ZoneID:   o.GetZoneID(),
		ZoneName: o.GetZoneName(),
	}
}

// GetID returns value of ID
func (o *BridgeInfo) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *BridgeInfo) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *BridgeInfo) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *BridgeInfo) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *BridgeInfo) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *BridgeInfo) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *BridgeInfo) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *BridgeInfo) SetName(v string) {
	o.Name = v
}

// GetZoneID returns value of ZoneID
func (o *BridgeInfo) GetZoneID() types.ID {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *BridgeInfo) SetZoneID(v types.ID) {
	o.ZoneID = v
}

// GetZoneName returns value of ZoneName
func (o *BridgeInfo) GetZoneName() string {
	return o.ZoneName
}

// SetZoneName sets value to ZoneName
func (o *BridgeInfo) SetZoneName(v string) {
	o.ZoneName = v
}

/*************************************************
* BridgeSwitchInfo
*************************************************/

// BridgeSwitchInfo represents API parameter/response structure
type BridgeSwitchInfo struct {
	ID             types.ID
	Name           string
	Scope          types.EScope
	ServerCount    int
	ApplianceCount int
}

// setDefaults implements iaas.argumentDefaulter
func (o *BridgeSwitchInfo) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		Name           string
		Scope          types.EScope
		ServerCount    int
		ApplianceCount int
	}{
		ID:             o.GetID(),
		Name:           o.GetName(),
		Scope:          o.GetScope(),
		ServerCount:    o.GetServerCount(),
		ApplianceCount: o.GetApplianceCount(),
	}
}

// GetID returns value of ID
func (o *BridgeSwitchInfo) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *BridgeSwitchInfo) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *BridgeSwitchInfo) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *BridgeSwitchInfo) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *BridgeSwitchInfo) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *BridgeSwitchInfo) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *BridgeSwitchInfo) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *BridgeSwitchInfo) SetName(v string) {
	o.Name = v
}

// GetScope returns value of Scope
func (o *BridgeSwitchInfo) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *BridgeSwitchInfo) SetScope(v types.EScope) {
	o.Scope = v
}

// GetServerCount returns value of ServerCount
func (o *BridgeSwitchInfo) GetServerCount() int {
	return o.ServerCount
}

// SetServerCount sets value to ServerCount
func (o *BridgeSwitchInfo) SetServerCount(v int) {
	o.ServerCount = v
}

// GetApplianceCount returns value of ApplianceCount
func (o *BridgeSwitchInfo) GetApplianceCount() int {
	return o.ApplianceCount
}

// SetApplianceCount sets value to ApplianceCount
func (o *BridgeSwitchInfo) SetApplianceCount(v int) {
	o.ApplianceCount = v
}

/*************************************************
* BridgeCreateRequest
*************************************************/

// BridgeCreateRequest represents API parameter/response structure
type BridgeCreateRequest struct {
	Name        string
	Description string
}

// setDefaults implements iaas.argumentDefaulter
func (o *BridgeCreateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
	}
}

// GetName returns value of Name
func (o *BridgeCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *BridgeCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *BridgeCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *BridgeCreateRequest) SetDescription(v string) {
	o.Description = v
}

/*************************************************
* BridgeUpdateRequest
*************************************************/

// BridgeUpdateRequest represents API parameter/response structure
type BridgeUpdateRequest struct {
	Name        string
	Description string
}

// setDefaults implements iaas.argumentDefaulter
func (o *BridgeUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
	}
}

// GetName returns value of Name
func (o *BridgeUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *BridgeUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *BridgeUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *BridgeUpdateRequest) SetDescription(v string) {
	o.Description = v
}

/*************************************************
* CDROM
*************************************************/

// CDROM represents API parameter/response structure
type CDROM struct {
	ID           types.ID
	Name         string
	Description  string
	DisplayOrder int64
	Tags         types.Tags
	Availability types.EAvailability
	Scope        types.EScope
	Storage      *Storage `json:",omitempty" mapconv:",omitempty,recursive"`
	SizeMB       int
	IconID       types.ID `mapconv:"Icon.ID"`
	CreatedAt    time.Time
	ModifiedAt   time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *CDROM) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		DisplayOrder int64
		Tags         types.Tags
		Availability types.EAvailability
		Scope        types.EScope
		Storage      *Storage `json:",omitempty" mapconv:",omitempty,recursive"`
		SizeMB       int
		IconID       types.ID `mapconv:"Icon.ID"`
		CreatedAt    time.Time
		ModifiedAt   time.Time
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		DisplayOrder: o.GetDisplayOrder(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		Scope:        o.GetScope(),
		Storage:      o.GetStorage(),
		SizeMB:       o.GetSizeMB(),
		IconID:       o.GetIconID(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
	}
}

// GetID returns value of ID
func (o *CDROM) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *CDROM) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *CDROM) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *CDROM) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *CDROM) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *CDROM) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *CDROM) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *CDROM) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *CDROM) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *CDROM) SetDescription(v string) {
	o.Description = v
}

// GetDisplayOrder returns value of DisplayOrder
func (o *CDROM) GetDisplayOrder() int64 {
	return o.DisplayOrder
}

// SetDisplayOrder sets value to DisplayOrder
func (o *CDROM) SetDisplayOrder(v int64) {
	o.DisplayOrder = v
}

// GetTags returns value of Tags
func (o *CDROM) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *CDROM) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *CDROM) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *CDROM) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *CDROM) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *CDROM) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *CDROM) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *CDROM) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetScope returns value of Scope
func (o *CDROM) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *CDROM) SetScope(v types.EScope) {
	o.Scope = v
}

// GetStorage returns value of Storage
func (o *CDROM) GetStorage() *Storage {
	return o.Storage
}

// SetStorage sets value to Storage
func (o *CDROM) SetStorage(v *Storage) {
	o.Storage = v
}

// GetSizeMB returns value of SizeMB
func (o *CDROM) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *CDROM) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *CDROM) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *CDROM) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

// GetIconID returns value of IconID
func (o *CDROM) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *CDROM) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *CDROM) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *CDROM) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *CDROM) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *CDROM) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* CDROMCreateRequest
*************************************************/

// CDROMCreateRequest represents API parameter/response structure
type CDROMCreateRequest struct {
	SizeMB      int
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CDROMCreateRequest) setDefaults() interface{} {
	return &struct {
		SizeMB      int
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		SizeMB:      o.GetSizeMB(),
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetSizeMB returns value of SizeMB
func (o *CDROMCreateRequest) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *CDROMCreateRequest) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *CDROMCreateRequest) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *CDROMCreateRequest) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

// GetName returns value of Name
func (o *CDROMCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *CDROMCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *CDROMCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *CDROMCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *CDROMCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *CDROMCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *CDROMCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *CDROMCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *CDROMCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *CDROMCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *CDROMCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *CDROMCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* CDROMUpdateRequest
*************************************************/

// CDROMUpdateRequest represents API parameter/response structure
type CDROMUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CDROMUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *CDROMUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *CDROMUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *CDROMUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *CDROMUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *CDROMUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *CDROMUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *CDROMUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *CDROMUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *CDROMUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *CDROMUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *CDROMUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *CDROMUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* CertificateAuthority
*************************************************/

// CertificateAuthority represents API parameter/response structure
type CertificateAuthority struct {
	ID               types.ID
	Name             string
	Description      string
	Tags             types.Tags
	Availability     types.EAvailability
	IconID           types.ID `mapconv:"Icon.ID"`
	CreatedAt        time.Time
	ModifiedAt       time.Time
	Country          string    `mapconv:"Status.Country"`
	Organization     string    `mapconv:"Status.Organization"`
	OrganizationUnit []string  `mapconv:"Status.OrganizationUnit"`
	CommonName       string    `mapconv:"Status.CommonName"`
	NotAfter         time.Time `mapconv:"Status.NotAfter"`
	Subject          string    `mapconv:"Status.Subject"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthority) setDefaults() interface{} {
	return &struct {
		ID               types.ID
		Name             string
		Description      string
		Tags             types.Tags
		Availability     types.EAvailability
		IconID           types.ID `mapconv:"Icon.ID"`
		CreatedAt        time.Time
		ModifiedAt       time.Time
		Country          string    `mapconv:"Status.Country"`
		Organization     string    `mapconv:"Status.Organization"`
		OrganizationUnit []string  `mapconv:"Status.OrganizationUnit"`
		CommonName       string    `mapconv:"Status.CommonName"`
		NotAfter         time.Time `mapconv:"Status.NotAfter"`
		Subject          string    `mapconv:"Status.Subject"`
	}{
		ID:               o.GetID(),
		Name:             o.GetName(),
		Description:      o.GetDescription(),
		Tags:             o.GetTags(),
		Availability:     o.GetAvailability(),
		IconID:           o.GetIconID(),
		CreatedAt:        o.GetCreatedAt(),
		ModifiedAt:       o.GetModifiedAt(),
		Country:          o.GetCountry(),
		Organization:     o.GetOrganization(),
		OrganizationUnit: o.GetOrganizationUnit(),
		CommonName:       o.GetCommonName(),
		NotAfter:         o.GetNotAfter(),
		Subject:          o.GetSubject(),
	}
}

// GetID returns value of ID
func (o *CertificateAuthority) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *CertificateAuthority) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *CertificateAuthority) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *CertificateAuthority) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *CertificateAuthority) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *CertificateAuthority) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *CertificateAuthority) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *CertificateAuthority) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *CertificateAuthority) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *CertificateAuthority) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *CertificateAuthority) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *CertificateAuthority) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *CertificateAuthority) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *CertificateAuthority) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *CertificateAuthority) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *CertificateAuthority) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *CertificateAuthority) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *CertificateAuthority) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *CertificateAuthority) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *CertificateAuthority) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *CertificateAuthority) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *CertificateAuthority) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *CertificateAuthority) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *CertificateAuthority) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetCountry returns value of Country
func (o *CertificateAuthority) GetCountry() string {
	return o.Country
}

// SetCountry sets value to Country
func (o *CertificateAuthority) SetCountry(v string) {
	o.Country = v
}

// GetOrganization returns value of Organization
func (o *CertificateAuthority) GetOrganization() string {
	return o.Organization
}

// SetOrganization sets value to Organization
func (o *CertificateAuthority) SetOrganization(v string) {
	o.Organization = v
}

// GetOrganizationUnit returns value of OrganizationUnit
func (o *CertificateAuthority) GetOrganizationUnit() []string {
	return o.OrganizationUnit
}

// SetOrganizationUnit sets value to OrganizationUnit
func (o *CertificateAuthority) SetOrganizationUnit(v []string) {
	o.OrganizationUnit = v
}

// GetCommonName returns value of CommonName
func (o *CertificateAuthority) GetCommonName() string {
	return o.CommonName
}

// SetCommonName sets value to CommonName
func (o *CertificateAuthority) SetCommonName(v string) {
	o.CommonName = v
}

// GetNotAfter returns value of NotAfter
func (o *CertificateAuthority) GetNotAfter() time.Time {
	return o.NotAfter
}

// SetNotAfter sets value to NotAfter
func (o *CertificateAuthority) SetNotAfter(v time.Time) {
	o.NotAfter = v
}

// GetSubject returns value of Subject
func (o *CertificateAuthority) GetSubject() string {
	return o.Subject
}

// SetSubject sets value to Subject
func (o *CertificateAuthority) SetSubject(v string) {
	o.Subject = v
}

/*************************************************
* CertificateAuthorityCreateRequest
*************************************************/

// CertificateAuthorityCreateRequest represents API parameter/response structure
type CertificateAuthorityCreateRequest struct {
	Name             string
	Description      string
	Tags             types.Tags
	IconID           types.ID  `mapconv:"Icon.ID"`
	Country          string    `mapconv:"Status.Country"`
	Organization     string    `mapconv:"Status.Organization"`
	OrganizationUnit []string  `mapconv:"Status.OrganizationUnit"`
	CommonName       string    `mapconv:"Status.CommonName"`
	NotAfter         time.Time `mapconv:"Status.NotAfter"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthorityCreateRequest) setDefaults() interface{} {
	return &struct {
		Name             string
		Description      string
		Tags             types.Tags
		IconID           types.ID  `mapconv:"Icon.ID"`
		Country          string    `mapconv:"Status.Country"`
		Organization     string    `mapconv:"Status.Organization"`
		OrganizationUnit []string  `mapconv:"Status.OrganizationUnit"`
		CommonName       string    `mapconv:"Status.CommonName"`
		NotAfter         time.Time `mapconv:"Status.NotAfter"`
		Class            string    `mapconv:"Provider.Class"`
	}{
		Name:             o.GetName(),
		Description:      o.GetDescription(),
		Tags:             o.GetTags(),
		IconID:           o.GetIconID(),
		Country:          o.GetCountry(),
		Organization:     o.GetOrganization(),
		OrganizationUnit: o.GetOrganizationUnit(),
		CommonName:       o.GetCommonName(),
		NotAfter:         o.GetNotAfter(),
		Class:            "certificateauthority",
	}
}

// GetName returns value of Name
func (o *CertificateAuthorityCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *CertificateAuthorityCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *CertificateAuthorityCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *CertificateAuthorityCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *CertificateAuthorityCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *CertificateAuthorityCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *CertificateAuthorityCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *CertificateAuthorityCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *CertificateAuthorityCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *CertificateAuthorityCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *CertificateAuthorityCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *CertificateAuthorityCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCountry returns value of Country
func (o *CertificateAuthorityCreateRequest) GetCountry() string {
	return o.Country
}

// SetCountry sets value to Country
func (o *CertificateAuthorityCreateRequest) SetCountry(v string) {
	o.Country = v
}

// GetOrganization returns value of Organization
func (o *CertificateAuthorityCreateRequest) GetOrganization() string {
	return o.Organization
}

// SetOrganization sets value to Organization
func (o *CertificateAuthorityCreateRequest) SetOrganization(v string) {
	o.Organization = v
}

// GetOrganizationUnit returns value of OrganizationUnit
func (o *CertificateAuthorityCreateRequest) GetOrganizationUnit() []string {
	return o.OrganizationUnit
}

// SetOrganizationUnit sets value to OrganizationUnit
func (o *CertificateAuthorityCreateRequest) SetOrganizationUnit(v []string) {
	o.OrganizationUnit = v
}

// GetCommonName returns value of CommonName
func (o *CertificateAuthorityCreateRequest) GetCommonName() string {
	return o.CommonName
}

// SetCommonName sets value to CommonName
func (o *CertificateAuthorityCreateRequest) SetCommonName(v string) {
	o.CommonName = v
}

// GetNotAfter returns value of NotAfter
func (o *CertificateAuthorityCreateRequest) GetNotAfter() time.Time {
	return o.NotAfter
}

// SetNotAfter sets value to NotAfter
func (o *CertificateAuthorityCreateRequest) SetNotAfter(v time.Time) {
	o.NotAfter = v
}

/*************************************************
* CertificateAuthorityUpdateRequest
*************************************************/

// CertificateAuthorityUpdateRequest represents API parameter/response structure
type CertificateAuthorityUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthorityUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *CertificateAuthorityUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *CertificateAuthorityUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *CertificateAuthorityUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *CertificateAuthorityUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *CertificateAuthorityUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *CertificateAuthorityUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *CertificateAuthorityUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *CertificateAuthorityUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *CertificateAuthorityUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *CertificateAuthorityUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *CertificateAuthorityUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *CertificateAuthorityUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* CertificateAuthorityDetail
*************************************************/

// CertificateAuthorityDetail represents API parameter/response structure
type CertificateAuthorityDetail struct {
	Subject         string
	CertificateData *CertificateData `mapconv:",recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthorityDetail) setDefaults() interface{} {
	return &struct {
		Subject         string
		CertificateData *CertificateData `mapconv:",recursive"`
	}{
		Subject:         o.GetSubject(),
		CertificateData: o.GetCertificateData(),
	}
}

// GetSubject returns value of Subject
func (o *CertificateAuthorityDetail) GetSubject() string {
	return o.Subject
}

// SetSubject sets value to Subject
func (o *CertificateAuthorityDetail) SetSubject(v string) {
	o.Subject = v
}

// GetCertificateData returns value of CertificateData
func (o *CertificateAuthorityDetail) GetCertificateData() *CertificateData {
	return o.CertificateData
}

// SetCertificateData sets value to CertificateData
func (o *CertificateAuthorityDetail) SetCertificateData(v *CertificateData) {
	o.CertificateData = v
}

/*************************************************
* CertificateData
*************************************************/

// CertificateData represents API parameter/response structure
type CertificateData struct {
	CertificatePEM string
	Subject        string
	SerialNumber   string
	NotBefore      time.Time
	NotAfter       time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateData) setDefaults() interface{} {
	return &struct {
		CertificatePEM string
		Subject        string
		SerialNumber   string
		NotBefore      time.Time
		NotAfter       time.Time
	}{
		CertificatePEM: o.GetCertificatePEM(),
		Subject:        o.GetSubject(),
		SerialNumber:   o.GetSerialNumber(),
		NotBefore:      o.GetNotBefore(),
		NotAfter:       o.GetNotAfter(),
	}
}

// GetCertificatePEM returns value of CertificatePEM
func (o *CertificateData) GetCertificatePEM() string {
	return o.CertificatePEM
}

// SetCertificatePEM sets value to CertificatePEM
func (o *CertificateData) SetCertificatePEM(v string) {
	o.CertificatePEM = v
}

// GetSubject returns value of Subject
func (o *CertificateData) GetSubject() string {
	return o.Subject
}

// SetSubject sets value to Subject
func (o *CertificateData) SetSubject(v string) {
	o.Subject = v
}

// GetSerialNumber returns value of SerialNumber
func (o *CertificateData) GetSerialNumber() string {
	return o.SerialNumber
}

// SetSerialNumber sets value to SerialNumber
func (o *CertificateData) SetSerialNumber(v string) {
	o.SerialNumber = v
}

// GetNotBefore returns value of NotBefore
func (o *CertificateData) GetNotBefore() time.Time {
	return o.NotBefore
}

// SetNotBefore sets value to NotBefore
func (o *CertificateData) SetNotBefore(v time.Time) {
	o.NotBefore = v
}

// GetNotAfter returns value of NotAfter
func (o *CertificateData) GetNotAfter() time.Time {
	return o.NotAfter
}

// SetNotAfter sets value to NotAfter
func (o *CertificateData) SetNotAfter(v time.Time) {
	o.NotAfter = v
}

/*************************************************
* CertificateAuthorityAddClientOrServerResult
*************************************************/

// CertificateAuthorityAddClientOrServerResult represents API parameter/response structure
type CertificateAuthorityAddClientOrServerResult struct {
	ID string
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthorityAddClientOrServerResult) setDefaults() interface{} {
	return &struct {
		ID string
	}{
		ID: o.GetID(),
	}
}

// GetID returns value of ID
func (o *CertificateAuthorityAddClientOrServerResult) GetID() string {
	return o.ID
}

// SetID sets value to ID
func (o *CertificateAuthorityAddClientOrServerResult) SetID(v string) {
	o.ID = v
}

/*************************************************
* CertificateAuthorityAddClientParam
*************************************************/

// CertificateAuthorityAddClientParam represents API parameter/response structure
type CertificateAuthorityAddClientParam struct {
	Country                   string
	Organization              string
	OrganizationUnit          []string
	CommonName                string
	NotAfter                  time.Time
	IssuanceMethod            types.ECertificateAuthorityIssuanceMethod
	EMail                     string
	CertificateSigningRequest string
	PublicKey                 string
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthorityAddClientParam) setDefaults() interface{} {
	return &struct {
		Country                   string
		Organization              string
		OrganizationUnit          []string
		CommonName                string
		NotAfter                  time.Time
		IssuanceMethod            types.ECertificateAuthorityIssuanceMethod
		EMail                     string
		CertificateSigningRequest string
		PublicKey                 string
	}{
		Country:                   o.GetCountry(),
		Organization:              o.GetOrganization(),
		OrganizationUnit:          o.GetOrganizationUnit(),
		CommonName:                o.GetCommonName(),
		NotAfter:                  o.GetNotAfter(),
		IssuanceMethod:            o.GetIssuanceMethod(),
		EMail:                     o.GetEMail(),
		CertificateSigningRequest: o.GetCertificateSigningRequest(),
		PublicKey:                 o.GetPublicKey(),
	}
}

// GetCountry returns value of Country
func (o *CertificateAuthorityAddClientParam) GetCountry() string {
	return o.Country
}

// SetCountry sets value to Country
func (o *CertificateAuthorityAddClientParam) SetCountry(v string) {
	o.Country = v
}

// GetOrganization returns value of Organization
func (o *CertificateAuthorityAddClientParam) GetOrganization() string {
	return o.Organization
}

// SetOrganization sets value to Organization
func (o *CertificateAuthorityAddClientParam) SetOrganization(v string) {
	o.Organization = v
}

// GetOrganizationUnit returns value of OrganizationUnit
func (o *CertificateAuthorityAddClientParam) GetOrganizationUnit() []string {
	return o.OrganizationUnit
}

// SetOrganizationUnit sets value to OrganizationUnit
func (o *CertificateAuthorityAddClientParam) SetOrganizationUnit(v []string) {
	o.OrganizationUnit = v
}

// GetCommonName returns value of CommonName
func (o *CertificateAuthorityAddClientParam) GetCommonName() string {
	return o.CommonName
}

// SetCommonName sets value to CommonName
func (o *CertificateAuthorityAddClientParam) SetCommonName(v string) {
	o.CommonName = v
}

// GetNotAfter returns value of NotAfter
func (o *CertificateAuthorityAddClientParam) GetNotAfter() time.Time {
	return o.NotAfter
}

// SetNotAfter sets value to NotAfter
func (o *CertificateAuthorityAddClientParam) SetNotAfter(v time.Time) {
	o.NotAfter = v
}

// GetIssuanceMethod returns value of IssuanceMethod
func (o *CertificateAuthorityAddClientParam) GetIssuanceMethod() types.ECertificateAuthorityIssuanceMethod {
	return o.IssuanceMethod
}

// SetIssuanceMethod sets value to IssuanceMethod
func (o *CertificateAuthorityAddClientParam) SetIssuanceMethod(v types.ECertificateAuthorityIssuanceMethod) {
	o.IssuanceMethod = v
}

// GetEMail returns value of EMail
func (o *CertificateAuthorityAddClientParam) GetEMail() string {
	return o.EMail
}

// SetEMail sets value to EMail
func (o *CertificateAuthorityAddClientParam) SetEMail(v string) {
	o.EMail = v
}

// GetCertificateSigningRequest returns value of CertificateSigningRequest
func (o *CertificateAuthorityAddClientParam) GetCertificateSigningRequest() string {
	return o.CertificateSigningRequest
}

// SetCertificateSigningRequest sets value to CertificateSigningRequest
func (o *CertificateAuthorityAddClientParam) SetCertificateSigningRequest(v string) {
	o.CertificateSigningRequest = v
}

// GetPublicKey returns value of PublicKey
func (o *CertificateAuthorityAddClientParam) GetPublicKey() string {
	return o.PublicKey
}

// SetPublicKey sets value to PublicKey
func (o *CertificateAuthorityAddClientParam) SetPublicKey(v string) {
	o.PublicKey = v
}

/*************************************************
* CertificateAuthorityClient
*************************************************/

// CertificateAuthorityClient represents API parameter/response structure
type CertificateAuthorityClient struct {
	ID              string
	Subject         string
	EMail           string
	IssuanceMethod  types.ECertificateAuthorityIssuanceMethod
	IssueState      string
	URL             string
	CertificateData *CertificateData `mapconv:",recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthorityClient) setDefaults() interface{} {
	return &struct {
		ID              string
		Subject         string
		EMail           string
		IssuanceMethod  types.ECertificateAuthorityIssuanceMethod
		IssueState      string
		URL             string
		CertificateData *CertificateData `mapconv:",recursive"`
	}{
		ID:              o.GetID(),
		Subject:         o.GetSubject(),
		EMail:           o.GetEMail(),
		IssuanceMethod:  o.GetIssuanceMethod(),
		IssueState:      o.GetIssueState(),
		URL:             o.GetURL(),
		CertificateData: o.GetCertificateData(),
	}
}

// GetID returns value of ID
func (o *CertificateAuthorityClient) GetID() string {
	return o.ID
}

// SetID sets value to ID
func (o *CertificateAuthorityClient) SetID(v string) {
	o.ID = v
}

// GetSubject returns value of Subject
func (o *CertificateAuthorityClient) GetSubject() string {
	return o.Subject
}

// SetSubject sets value to Subject
func (o *CertificateAuthorityClient) SetSubject(v string) {
	o.Subject = v
}

// GetEMail returns value of EMail
func (o *CertificateAuthorityClient) GetEMail() string {
	return o.EMail
}

// SetEMail sets value to EMail
func (o *CertificateAuthorityClient) SetEMail(v string) {
	o.EMail = v
}

// GetIssuanceMethod returns value of IssuanceMethod
func (o *CertificateAuthorityClient) GetIssuanceMethod() types.ECertificateAuthorityIssuanceMethod {
	return o.IssuanceMethod
}

// SetIssuanceMethod sets value to IssuanceMethod
func (o *CertificateAuthorityClient) SetIssuanceMethod(v types.ECertificateAuthorityIssuanceMethod) {
	o.IssuanceMethod = v
}

// GetIssueState returns value of IssueState
func (o *CertificateAuthorityClient) GetIssueState() string {
	return o.IssueState
}

// SetIssueState sets value to IssueState
func (o *CertificateAuthorityClient) SetIssueState(v string) {
	o.IssueState = v
}

// GetURL returns value of URL
func (o *CertificateAuthorityClient) GetURL() string {
	return o.URL
}

// SetURL sets value to URL
func (o *CertificateAuthorityClient) SetURL(v string) {
	o.URL = v
}

// GetCertificateData returns value of CertificateData
func (o *CertificateAuthorityClient) GetCertificateData() *CertificateData {
	return o.CertificateData
}

// SetCertificateData sets value to CertificateData
func (o *CertificateAuthorityClient) SetCertificateData(v *CertificateData) {
	o.CertificateData = v
}

/*************************************************
* CertificateAuthorityAddServerParam
*************************************************/

// CertificateAuthorityAddServerParam represents API parameter/response structure
type CertificateAuthorityAddServerParam struct {
	Country                   string
	Organization              string
	OrganizationUnit          []string
	CommonName                string
	NotAfter                  time.Time
	SANs                      []string
	CertificateSigningRequest string
	PublicKey                 string
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthorityAddServerParam) setDefaults() interface{} {
	return &struct {
		Country                   string
		Organization              string
		OrganizationUnit          []string
		CommonName                string
		NotAfter                  time.Time
		SANs                      []string
		CertificateSigningRequest string
		PublicKey                 string
	}{
		Country:                   o.GetCountry(),
		Organization:              o.GetOrganization(),
		OrganizationUnit:          o.GetOrganizationUnit(),
		CommonName:                o.GetCommonName(),
		NotAfter:                  o.GetNotAfter(),
		SANs:                      o.GetSANs(),
		CertificateSigningRequest: o.GetCertificateSigningRequest(),
		PublicKey:                 o.GetPublicKey(),
	}
}

// GetCountry returns value of Country
func (o *CertificateAuthorityAddServerParam) GetCountry() string {
	return o.Country
}

// SetCountry sets value to Country
func (o *CertificateAuthorityAddServerParam) SetCountry(v string) {
	o.Country = v
}

// GetOrganization returns value of Organization
func (o *CertificateAuthorityAddServerParam) GetOrganization() string {
	return o.Organization
}

// SetOrganization sets value to Organization
func (o *CertificateAuthorityAddServerParam) SetOrganization(v string) {
	o.Organization = v
}

// GetOrganizationUnit returns value of OrganizationUnit
func (o *CertificateAuthorityAddServerParam) GetOrganizationUnit() []string {
	return o.OrganizationUnit
}

// SetOrganizationUnit sets value to OrganizationUnit
func (o *CertificateAuthorityAddServerParam) SetOrganizationUnit(v []string) {
	o.OrganizationUnit = v
}

// GetCommonName returns value of CommonName
func (o *CertificateAuthorityAddServerParam) GetCommonName() string {
	return o.CommonName
}

// SetCommonName sets value to CommonName
func (o *CertificateAuthorityAddServerParam) SetCommonName(v string) {
	o.CommonName = v
}

// GetNotAfter returns value of NotAfter
func (o *CertificateAuthorityAddServerParam) GetNotAfter() time.Time {
	return o.NotAfter
}

// SetNotAfter sets value to NotAfter
func (o *CertificateAuthorityAddServerParam) SetNotAfter(v time.Time) {
	o.NotAfter = v
}

// GetSANs returns value of SANs
func (o *CertificateAuthorityAddServerParam) GetSANs() []string {
	return o.SANs
}

// SetSANs sets value to SANs
func (o *CertificateAuthorityAddServerParam) SetSANs(v []string) {
	o.SANs = v
}

// GetCertificateSigningRequest returns value of CertificateSigningRequest
func (o *CertificateAuthorityAddServerParam) GetCertificateSigningRequest() string {
	return o.CertificateSigningRequest
}

// SetCertificateSigningRequest sets value to CertificateSigningRequest
func (o *CertificateAuthorityAddServerParam) SetCertificateSigningRequest(v string) {
	o.CertificateSigningRequest = v
}

// GetPublicKey returns value of PublicKey
func (o *CertificateAuthorityAddServerParam) GetPublicKey() string {
	return o.PublicKey
}

// SetPublicKey sets value to PublicKey
func (o *CertificateAuthorityAddServerParam) SetPublicKey(v string) {
	o.PublicKey = v
}

/*************************************************
* CertificateAuthorityServer
*************************************************/

// CertificateAuthorityServer represents API parameter/response structure
type CertificateAuthorityServer struct {
	ID              string
	Subject         string
	SANs            []string
	EMail           string
	IssueState      string
	CertificateData *CertificateData `mapconv:",recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CertificateAuthorityServer) setDefaults() interface{} {
	return &struct {
		ID              string
		Subject         string
		SANs            []string
		EMail           string
		IssueState      string
		CertificateData *CertificateData `mapconv:",recursive"`
	}{
		ID:              o.GetID(),
		Subject:         o.GetSubject(),
		SANs:            o.GetSANs(),
		EMail:           o.GetEMail(),
		IssueState:      o.GetIssueState(),
		CertificateData: o.GetCertificateData(),
	}
}

// GetID returns value of ID
func (o *CertificateAuthorityServer) GetID() string {
	return o.ID
}

// SetID sets value to ID
func (o *CertificateAuthorityServer) SetID(v string) {
	o.ID = v
}

// GetSubject returns value of Subject
func (o *CertificateAuthorityServer) GetSubject() string {
	return o.Subject
}

// SetSubject sets value to Subject
func (o *CertificateAuthorityServer) SetSubject(v string) {
	o.Subject = v
}

// GetSANs returns value of SANs
func (o *CertificateAuthorityServer) GetSANs() []string {
	return o.SANs
}

// SetSANs sets value to SANs
func (o *CertificateAuthorityServer) SetSANs(v []string) {
	o.SANs = v
}

// GetEMail returns value of EMail
func (o *CertificateAuthorityServer) GetEMail() string {
	return o.EMail
}

// SetEMail sets value to EMail
func (o *CertificateAuthorityServer) SetEMail(v string) {
	o.EMail = v
}

// GetIssueState returns value of IssueState
func (o *CertificateAuthorityServer) GetIssueState() string {
	return o.IssueState
}

// SetIssueState sets value to IssueState
func (o *CertificateAuthorityServer) SetIssueState(v string) {
	o.IssueState = v
}

// GetCertificateData returns value of CertificateData
func (o *CertificateAuthorityServer) GetCertificateData() *CertificateData {
	return o.CertificateData
}

// SetCertificateData sets value to CertificateData
func (o *CertificateAuthorityServer) SetCertificateData(v *CertificateData) {
	o.CertificateData = v
}

/*************************************************
* ContainerRegistry
*************************************************/

// ContainerRegistry represents API parameter/response structure
type ContainerRegistry struct {
	ID             types.ID
	Name           string
	Description    string
	Tags           types.Tags
	Availability   types.EAvailability
	IconID         types.ID `mapconv:"Icon.ID"`
	CreatedAt      time.Time
	ModifiedAt     time.Time
	AccessLevel    types.EContainerRegistryAccessLevel `mapconv:"Settings.ContainerRegistry.Public"`
	VirtualDomain  string                              `mapconv:"Settings.ContainerRegistry.VirtualDomain"`
	SettingsHash   string                              `json:",omitempty" mapconv:",omitempty"`
	SubDomainLabel string                              `mapconv:"Status.RegistryName"`
	FQDN           string                              `mapconv:"Status.FQDN"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ContainerRegistry) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		Name           string
		Description    string
		Tags           types.Tags
		Availability   types.EAvailability
		IconID         types.ID `mapconv:"Icon.ID"`
		CreatedAt      time.Time
		ModifiedAt     time.Time
		AccessLevel    types.EContainerRegistryAccessLevel `mapconv:"Settings.ContainerRegistry.Public"`
		VirtualDomain  string                              `mapconv:"Settings.ContainerRegistry.VirtualDomain"`
		SettingsHash   string                              `json:",omitempty" mapconv:",omitempty"`
		SubDomainLabel string                              `mapconv:"Status.RegistryName"`
		FQDN           string                              `mapconv:"Status.FQDN"`
	}{
		ID:             o.GetID(),
		Name:           o.GetName(),
		Description:    o.GetDescription(),
		Tags:           o.GetTags(),
		Availability:   o.GetAvailability(),
		IconID:         o.GetIconID(),
		CreatedAt:      o.GetCreatedAt(),
		ModifiedAt:     o.GetModifiedAt(),
		AccessLevel:    o.GetAccessLevel(),
		VirtualDomain:  o.GetVirtualDomain(),
		SettingsHash:   o.GetSettingsHash(),
		SubDomainLabel: o.GetSubDomainLabel(),
		FQDN:           o.GetFQDN(),
	}
}

// GetID returns value of ID
func (o *ContainerRegistry) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ContainerRegistry) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ContainerRegistry) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ContainerRegistry) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ContainerRegistry) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ContainerRegistry) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *ContainerRegistry) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ContainerRegistry) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ContainerRegistry) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ContainerRegistry) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ContainerRegistry) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ContainerRegistry) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ContainerRegistry) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ContainerRegistry) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ContainerRegistry) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ContainerRegistry) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *ContainerRegistry) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *ContainerRegistry) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *ContainerRegistry) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ContainerRegistry) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *ContainerRegistry) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *ContainerRegistry) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *ContainerRegistry) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *ContainerRegistry) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetAccessLevel returns value of AccessLevel
func (o *ContainerRegistry) GetAccessLevel() types.EContainerRegistryAccessLevel {
	return o.AccessLevel
}

// SetAccessLevel sets value to AccessLevel
func (o *ContainerRegistry) SetAccessLevel(v types.EContainerRegistryAccessLevel) {
	o.AccessLevel = v
}

// GetVirtualDomain returns value of VirtualDomain
func (o *ContainerRegistry) GetVirtualDomain() string {
	return o.VirtualDomain
}

// SetVirtualDomain sets value to VirtualDomain
func (o *ContainerRegistry) SetVirtualDomain(v string) {
	o.VirtualDomain = v
}

// GetSettingsHash returns value of SettingsHash
func (o *ContainerRegistry) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *ContainerRegistry) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetSubDomainLabel returns value of SubDomainLabel
func (o *ContainerRegistry) GetSubDomainLabel() string {
	return o.SubDomainLabel
}

// SetSubDomainLabel sets value to SubDomainLabel
func (o *ContainerRegistry) SetSubDomainLabel(v string) {
	o.SubDomainLabel = v
}

// GetFQDN returns value of FQDN
func (o *ContainerRegistry) GetFQDN() string {
	return o.FQDN
}

// SetFQDN sets value to FQDN
func (o *ContainerRegistry) SetFQDN(v string) {
	o.FQDN = v
}

/*************************************************
* ContainerRegistryCreateRequest
*************************************************/

// ContainerRegistryCreateRequest represents API parameter/response structure
type ContainerRegistryCreateRequest struct {
	Name           string
	Description    string
	Tags           types.Tags
	IconID         types.ID                            `mapconv:"Icon.ID"`
	AccessLevel    types.EContainerRegistryAccessLevel `mapconv:"Settings.ContainerRegistry.Public"`
	VirtualDomain  string                              `mapconv:"Settings.ContainerRegistry.VirtualDomain"`
	SubDomainLabel string                              `mapconv:"Status.RegistryName"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ContainerRegistryCreateRequest) setDefaults() interface{} {
	return &struct {
		Name           string
		Description    string
		Tags           types.Tags
		IconID         types.ID                            `mapconv:"Icon.ID"`
		AccessLevel    types.EContainerRegistryAccessLevel `mapconv:"Settings.ContainerRegistry.Public"`
		VirtualDomain  string                              `mapconv:"Settings.ContainerRegistry.VirtualDomain"`
		SubDomainLabel string                              `mapconv:"Status.RegistryName"`
		Class          string                              `mapconv:"Provider.Class"`
	}{
		Name:           o.GetName(),
		Description:    o.GetDescription(),
		Tags:           o.GetTags(),
		IconID:         o.GetIconID(),
		AccessLevel:    o.GetAccessLevel(),
		VirtualDomain:  o.GetVirtualDomain(),
		SubDomainLabel: o.GetSubDomainLabel(),
		Class:          "containerregistry",
	}
}

// GetName returns value of Name
func (o *ContainerRegistryCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ContainerRegistryCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ContainerRegistryCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ContainerRegistryCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ContainerRegistryCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ContainerRegistryCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ContainerRegistryCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ContainerRegistryCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ContainerRegistryCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ContainerRegistryCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ContainerRegistryCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ContainerRegistryCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetAccessLevel returns value of AccessLevel
func (o *ContainerRegistryCreateRequest) GetAccessLevel() types.EContainerRegistryAccessLevel {
	return o.AccessLevel
}

// SetAccessLevel sets value to AccessLevel
func (o *ContainerRegistryCreateRequest) SetAccessLevel(v types.EContainerRegistryAccessLevel) {
	o.AccessLevel = v
}

// GetVirtualDomain returns value of VirtualDomain
func (o *ContainerRegistryCreateRequest) GetVirtualDomain() string {
	return o.VirtualDomain
}

// SetVirtualDomain sets value to VirtualDomain
func (o *ContainerRegistryCreateRequest) SetVirtualDomain(v string) {
	o.VirtualDomain = v
}

// GetSubDomainLabel returns value of SubDomainLabel
func (o *ContainerRegistryCreateRequest) GetSubDomainLabel() string {
	return o.SubDomainLabel
}

// SetSubDomainLabel sets value to SubDomainLabel
func (o *ContainerRegistryCreateRequest) SetSubDomainLabel(v string) {
	o.SubDomainLabel = v
}

/*************************************************
* ContainerRegistryUpdateRequest
*************************************************/

// ContainerRegistryUpdateRequest represents API parameter/response structure
type ContainerRegistryUpdateRequest struct {
	Name          string
	Description   string
	Tags          types.Tags
	IconID        types.ID                            `mapconv:"Icon.ID"`
	AccessLevel   types.EContainerRegistryAccessLevel `mapconv:"Settings.ContainerRegistry.Public"`
	VirtualDomain string                              `mapconv:"Settings.ContainerRegistry.VirtualDomain"`
	SettingsHash  string                              `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ContainerRegistryUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name          string
		Description   string
		Tags          types.Tags
		IconID        types.ID                            `mapconv:"Icon.ID"`
		AccessLevel   types.EContainerRegistryAccessLevel `mapconv:"Settings.ContainerRegistry.Public"`
		VirtualDomain string                              `mapconv:"Settings.ContainerRegistry.VirtualDomain"`
		SettingsHash  string                              `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:          o.GetName(),
		Description:   o.GetDescription(),
		Tags:          o.GetTags(),
		IconID:        o.GetIconID(),
		AccessLevel:   o.GetAccessLevel(),
		VirtualDomain: o.GetVirtualDomain(),
		SettingsHash:  o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *ContainerRegistryUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ContainerRegistryUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ContainerRegistryUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ContainerRegistryUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ContainerRegistryUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ContainerRegistryUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ContainerRegistryUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ContainerRegistryUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ContainerRegistryUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ContainerRegistryUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ContainerRegistryUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ContainerRegistryUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetAccessLevel returns value of AccessLevel
func (o *ContainerRegistryUpdateRequest) GetAccessLevel() types.EContainerRegistryAccessLevel {
	return o.AccessLevel
}

// SetAccessLevel sets value to AccessLevel
func (o *ContainerRegistryUpdateRequest) SetAccessLevel(v types.EContainerRegistryAccessLevel) {
	o.AccessLevel = v
}

// GetVirtualDomain returns value of VirtualDomain
func (o *ContainerRegistryUpdateRequest) GetVirtualDomain() string {
	return o.VirtualDomain
}

// SetVirtualDomain sets value to VirtualDomain
func (o *ContainerRegistryUpdateRequest) SetVirtualDomain(v string) {
	o.VirtualDomain = v
}

// GetSettingsHash returns value of SettingsHash
func (o *ContainerRegistryUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *ContainerRegistryUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* ContainerRegistryUpdateSettingsRequest
*************************************************/

// ContainerRegistryUpdateSettingsRequest represents API parameter/response structure
type ContainerRegistryUpdateSettingsRequest struct {
	AccessLevel   types.EContainerRegistryAccessLevel `mapconv:"Settings.ContainerRegistry.Public"`
	VirtualDomain string                              `mapconv:"Settings.ContainerRegistry.VirtualDomain"`
	SettingsHash  string                              `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ContainerRegistryUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		AccessLevel   types.EContainerRegistryAccessLevel `mapconv:"Settings.ContainerRegistry.Public"`
		VirtualDomain string                              `mapconv:"Settings.ContainerRegistry.VirtualDomain"`
		SettingsHash  string                              `json:",omitempty" mapconv:",omitempty"`
	}{
		AccessLevel:   o.GetAccessLevel(),
		VirtualDomain: o.GetVirtualDomain(),
		SettingsHash:  o.GetSettingsHash(),
	}
}

// GetAccessLevel returns value of AccessLevel
func (o *ContainerRegistryUpdateSettingsRequest) GetAccessLevel() types.EContainerRegistryAccessLevel {
	return o.AccessLevel
}

// SetAccessLevel sets value to AccessLevel
func (o *ContainerRegistryUpdateSettingsRequest) SetAccessLevel(v types.EContainerRegistryAccessLevel) {
	o.AccessLevel = v
}

// GetVirtualDomain returns value of VirtualDomain
func (o *ContainerRegistryUpdateSettingsRequest) GetVirtualDomain() string {
	return o.VirtualDomain
}

// SetVirtualDomain sets value to VirtualDomain
func (o *ContainerRegistryUpdateSettingsRequest) SetVirtualDomain(v string) {
	o.VirtualDomain = v
}

// GetSettingsHash returns value of SettingsHash
func (o *ContainerRegistryUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *ContainerRegistryUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* ContainerRegistryUsers
*************************************************/

// ContainerRegistryUsers represents API parameter/response structure
type ContainerRegistryUsers struct {
	Users []*ContainerRegistryUser
}

// setDefaults implements iaas.argumentDefaulter
func (o *ContainerRegistryUsers) setDefaults() interface{} {
	return &struct {
		Users []*ContainerRegistryUser
	}{
		Users: o.GetUsers(),
	}
}

// GetUsers returns value of Users
func (o *ContainerRegistryUsers) GetUsers() []*ContainerRegistryUser {
	return o.Users
}

// SetUsers sets value to Users
func (o *ContainerRegistryUsers) SetUsers(v []*ContainerRegistryUser) {
	o.Users = v
}

/*************************************************
* ContainerRegistryUser
*************************************************/

// ContainerRegistryUser represents API parameter/response structure
type ContainerRegistryUser struct {
	UserName   string
	Permission types.EContainerRegistryPermission
}

// setDefaults implements iaas.argumentDefaulter
func (o *ContainerRegistryUser) setDefaults() interface{} {
	return &struct {
		UserName   string
		Permission types.EContainerRegistryPermission
	}{
		UserName:   o.GetUserName(),
		Permission: o.GetPermission(),
	}
}

// GetUserName returns value of UserName
func (o *ContainerRegistryUser) GetUserName() string {
	return o.UserName
}

// SetUserName sets value to UserName
func (o *ContainerRegistryUser) SetUserName(v string) {
	o.UserName = v
}

// GetPermission returns value of Permission
func (o *ContainerRegistryUser) GetPermission() types.EContainerRegistryPermission {
	return o.Permission
}

// SetPermission sets value to Permission
func (o *ContainerRegistryUser) SetPermission(v types.EContainerRegistryPermission) {
	o.Permission = v
}

/*************************************************
* ContainerRegistryUserCreateRequest
*************************************************/

// ContainerRegistryUserCreateRequest represents API parameter/response structure
type ContainerRegistryUserCreateRequest struct {
	UserName   string
	Password   string
	Permission types.EContainerRegistryPermission
}

// setDefaults implements iaas.argumentDefaulter
func (o *ContainerRegistryUserCreateRequest) setDefaults() interface{} {
	return &struct {
		UserName   string
		Password   string
		Permission types.EContainerRegistryPermission
	}{
		UserName:   o.GetUserName(),
		Password:   o.GetPassword(),
		Permission: o.GetPermission(),
	}
}

// GetUserName returns value of UserName
func (o *ContainerRegistryUserCreateRequest) GetUserName() string {
	return o.UserName
}

// SetUserName sets value to UserName
func (o *ContainerRegistryUserCreateRequest) SetUserName(v string) {
	o.UserName = v
}

// GetPassword returns value of Password
func (o *ContainerRegistryUserCreateRequest) GetPassword() string {
	return o.Password
}

// SetPassword sets value to Password
func (o *ContainerRegistryUserCreateRequest) SetPassword(v string) {
	o.Password = v
}

// GetPermission returns value of Permission
func (o *ContainerRegistryUserCreateRequest) GetPermission() types.EContainerRegistryPermission {
	return o.Permission
}

// SetPermission sets value to Permission
func (o *ContainerRegistryUserCreateRequest) SetPermission(v types.EContainerRegistryPermission) {
	o.Permission = v
}

/*************************************************
* ContainerRegistryUserUpdateRequest
*************************************************/

// ContainerRegistryUserUpdateRequest represents API parameter/response structure
type ContainerRegistryUserUpdateRequest struct {
	Password   string
	Permission types.EContainerRegistryPermission
}

// setDefaults implements iaas.argumentDefaulter
func (o *ContainerRegistryUserUpdateRequest) setDefaults() interface{} {
	return &struct {
		Password   string
		Permission types.EContainerRegistryPermission
	}{
		Password:   o.GetPassword(),
		Permission: o.GetPermission(),
	}
}

// GetPassword returns value of Password
func (o *ContainerRegistryUserUpdateRequest) GetPassword() string {
	return o.Password
}

// SetPassword sets value to Password
func (o *ContainerRegistryUserUpdateRequest) SetPassword(v string) {
	o.Password = v
}

// GetPermission returns value of Permission
func (o *ContainerRegistryUserUpdateRequest) GetPermission() types.EContainerRegistryPermission {
	return o.Permission
}

// SetPermission sets value to Permission
func (o *ContainerRegistryUserUpdateRequest) SetPermission(v types.EContainerRegistryPermission) {
	o.Permission = v
}

/*************************************************
* Coupon
*************************************************/

// Coupon represents API parameter/response structure
type Coupon struct {
	ID             types.ID
	MemberID       string
	ContractID     types.ID
	ServiceClassID types.ID
	Discount       int64
	AppliedAt      time.Time
	UntilAt        time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *Coupon) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		MemberID       string
		ContractID     types.ID
		ServiceClassID types.ID
		Discount       int64
		AppliedAt      time.Time
		UntilAt        time.Time
	}{
		ID:             o.GetID(),
		MemberID:       o.GetMemberID(),
		ContractID:     o.GetContractID(),
		ServiceClassID: o.GetServiceClassID(),
		Discount:       o.GetDiscount(),
		AppliedAt:      o.GetAppliedAt(),
		UntilAt:        o.GetUntilAt(),
	}
}

// GetID returns value of ID
func (o *Coupon) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Coupon) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Coupon) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Coupon) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Coupon) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Coupon) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetMemberID returns value of MemberID
func (o *Coupon) GetMemberID() string {
	return o.MemberID
}

// SetMemberID sets value to MemberID
func (o *Coupon) SetMemberID(v string) {
	o.MemberID = v
}

// GetContractID returns value of ContractID
func (o *Coupon) GetContractID() types.ID {
	return o.ContractID
}

// SetContractID sets value to ContractID
func (o *Coupon) SetContractID(v types.ID) {
	o.ContractID = v
}

// GetServiceClassID returns value of ServiceClassID
func (o *Coupon) GetServiceClassID() types.ID {
	return o.ServiceClassID
}

// SetServiceClassID sets value to ServiceClassID
func (o *Coupon) SetServiceClassID(v types.ID) {
	o.ServiceClassID = v
}

// GetDiscount returns value of Discount
func (o *Coupon) GetDiscount() int64 {
	return o.Discount
}

// SetDiscount sets value to Discount
func (o *Coupon) SetDiscount(v int64) {
	o.Discount = v
}

// GetAppliedAt returns value of AppliedAt
func (o *Coupon) GetAppliedAt() time.Time {
	return o.AppliedAt
}

// SetAppliedAt sets value to AppliedAt
func (o *Coupon) SetAppliedAt(v time.Time) {
	o.AppliedAt = v
}

// GetUntilAt returns value of UntilAt
func (o *Coupon) GetUntilAt() time.Time {
	return o.UntilAt
}

// SetUntilAt sets value to UntilAt
func (o *Coupon) SetUntilAt(v time.Time) {
	o.UntilAt = v
}

/*************************************************
* Database
*************************************************/

// Database represents API parameter/response structure
type Database struct {
	ID                      types.ID
	Class                   string
	Name                    string
	Description             string
	Tags                    types.Tags
	Availability            types.EAvailability
	IconID                  types.ID `mapconv:"Icon.ID"`
	CreatedAt               time.Time
	ModifiedAt              time.Time
	CommonSetting           *DatabaseSettingCommon       `mapconv:"Settings.DBConf.Common,recursive"`
	BackupSetting           *DatabaseSettingBackup       `mapconv:"Settings.DBConf.Backup,recursive"`
	Backupv2Setting         *DatabaseSettingBackupv2View `mapconv:"Settings.DBConf.Backupv2,recursive"`
	ReplicationSetting      *DatabaseReplicationSetting  `mapconv:"Settings.DBConf.Replication,recursive"`
	InterfaceSettings       []*DatabaseSettingsInterface `mapconv:"Settings.DBConf.[]Interfaces,omitempty,recursive"`
	MonitoringSuite         *MonitoringSuite             `mapconv:"Settings.MonitoringSuite,omitempty,recursive"`
	SettingsHash            string                       `json:",omitempty" mapconv:",omitempty"`
	InstanceHostName        string                       `mapconv:"Instance.Host.Name"`
	InstanceHostInfoURL     string                       `mapconv:"Instance.Host.InfoURL"`
	InstanceStatus          types.EServerInstanceStatus  `mapconv:"Instance.Status"`
	InstanceStatusChangedAt time.Time                    `mapconv:"Instance.StatusChangedAt"`
	PlanID                  types.ID                     `mapconv:"Remark.Plan.ID/Plan.ID"`
	SwitchID                types.ID                     `mapconv:"Remark.Switch.ID"`
	Conf                    *DatabaseRemarkDBConfCommon  `mapconv:"Remark.DBConf.Common,recursive"`
	DefaultRoute            string                       `mapconv:"Remark.Network.DefaultRoute"`
	NetworkMaskLen          int                          `mapconv:"Remark.Network.NetworkMaskLen"`
	IPAddresses             []string                     `mapconv:"Remark.[]Servers.IPAddress"`
	ZoneID                  types.ID                     `mapconv:"Remark.Zone.ID"`
	Interfaces              []*InterfaceView             `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
	Disk                    *DatabaseDisk                `mapconv:"Disk,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *Database) setDefaults() interface{} {
	return &struct {
		ID                      types.ID
		Class                   string
		Name                    string
		Description             string
		Tags                    types.Tags
		Availability            types.EAvailability
		IconID                  types.ID `mapconv:"Icon.ID"`
		CreatedAt               time.Time
		ModifiedAt              time.Time
		CommonSetting           *DatabaseSettingCommon       `mapconv:"Settings.DBConf.Common,recursive"`
		BackupSetting           *DatabaseSettingBackup       `mapconv:"Settings.DBConf.Backup,recursive"`
		Backupv2Setting         *DatabaseSettingBackupv2View `mapconv:"Settings.DBConf.Backupv2,recursive"`
		ReplicationSetting      *DatabaseReplicationSetting  `mapconv:"Settings.DBConf.Replication,recursive"`
		InterfaceSettings       []*DatabaseSettingsInterface `mapconv:"Settings.DBConf.[]Interfaces,omitempty,recursive"`
		MonitoringSuite         *MonitoringSuite             `mapconv:"Settings.MonitoringSuite,omitempty,recursive"`
		SettingsHash            string                       `json:",omitempty" mapconv:",omitempty"`
		InstanceHostName        string                       `mapconv:"Instance.Host.Name"`
		InstanceHostInfoURL     string                       `mapconv:"Instance.Host.InfoURL"`
		InstanceStatus          types.EServerInstanceStatus  `mapconv:"Instance.Status"`
		InstanceStatusChangedAt time.Time                    `mapconv:"Instance.StatusChangedAt"`
		PlanID                  types.ID                     `mapconv:"Remark.Plan.ID/Plan.ID"`
		SwitchID                types.ID                     `mapconv:"Remark.Switch.ID"`
		Conf                    *DatabaseRemarkDBConfCommon  `mapconv:"Remark.DBConf.Common,recursive"`
		DefaultRoute            string                       `mapconv:"Remark.Network.DefaultRoute"`
		NetworkMaskLen          int                          `mapconv:"Remark.Network.NetworkMaskLen"`
		IPAddresses             []string                     `mapconv:"Remark.[]Servers.IPAddress"`
		ZoneID                  types.ID                     `mapconv:"Remark.Zone.ID"`
		Interfaces              []*InterfaceView             `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
		Disk                    *DatabaseDisk                `mapconv:"Disk,recursive"`
	}{
		ID:                      o.GetID(),
		Class:                   o.GetClass(),
		Name:                    o.GetName(),
		Description:             o.GetDescription(),
		Tags:                    o.GetTags(),
		Availability:            o.GetAvailability(),
		IconID:                  o.GetIconID(),
		CreatedAt:               o.GetCreatedAt(),
		ModifiedAt:              o.GetModifiedAt(),
		CommonSetting:           o.GetCommonSetting(),
		BackupSetting:           o.GetBackupSetting(),
		Backupv2Setting:         o.GetBackupv2Setting(),
		ReplicationSetting:      o.GetReplicationSetting(),
		InterfaceSettings:       o.GetInterfaceSettings(),
		MonitoringSuite:         o.GetMonitoringSuite(),
		SettingsHash:            o.GetSettingsHash(),
		InstanceHostName:        o.GetInstanceHostName(),
		InstanceHostInfoURL:     o.GetInstanceHostInfoURL(),
		InstanceStatus:          o.GetInstanceStatus(),
		InstanceStatusChangedAt: o.GetInstanceStatusChangedAt(),
		PlanID:                  o.GetPlanID(),
		SwitchID:                o.GetSwitchID(),
		Conf:                    o.GetConf(),
		DefaultRoute:            o.GetDefaultRoute(),
		NetworkMaskLen:          o.GetNetworkMaskLen(),
		IPAddresses:             o.GetIPAddresses(),
		ZoneID:                  o.GetZoneID(),
		Interfaces:              o.GetInterfaces(),
		Disk:                    o.GetDisk(),
	}
}

// GetID returns value of ID
func (o *Database) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Database) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Database) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Database) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Database) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Database) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetClass returns value of Class
func (o *Database) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *Database) SetClass(v string) {
	o.Class = v
}

// GetName returns value of Name
func (o *Database) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Database) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Database) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Database) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *Database) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *Database) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *Database) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *Database) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *Database) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *Database) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *Database) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *Database) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *Database) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *Database) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Database) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Database) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *Database) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *Database) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetCommonSetting returns value of CommonSetting
func (o *Database) GetCommonSetting() *DatabaseSettingCommon {
	return o.CommonSetting
}

// SetCommonSetting sets value to CommonSetting
func (o *Database) SetCommonSetting(v *DatabaseSettingCommon) {
	o.CommonSetting = v
}

// GetBackupSetting returns value of BackupSetting
func (o *Database) GetBackupSetting() *DatabaseSettingBackup {
	return o.BackupSetting
}

// SetBackupSetting sets value to BackupSetting
func (o *Database) SetBackupSetting(v *DatabaseSettingBackup) {
	o.BackupSetting = v
}

// GetBackupv2Setting returns value of Backupv2Setting
func (o *Database) GetBackupv2Setting() *DatabaseSettingBackupv2View {
	return o.Backupv2Setting
}

// SetBackupv2Setting sets value to Backupv2Setting
func (o *Database) SetBackupv2Setting(v *DatabaseSettingBackupv2View) {
	o.Backupv2Setting = v
}

// GetReplicationSetting returns value of ReplicationSetting
func (o *Database) GetReplicationSetting() *DatabaseReplicationSetting {
	return o.ReplicationSetting
}

// SetReplicationSetting sets value to ReplicationSetting
func (o *Database) SetReplicationSetting(v *DatabaseReplicationSetting) {
	o.ReplicationSetting = v
}

// GetInterfaceSettings returns value of InterfaceSettings
func (o *Database) GetInterfaceSettings() []*DatabaseSettingsInterface {
	return o.InterfaceSettings
}

// SetInterfaceSettings sets value to InterfaceSettings
func (o *Database) SetInterfaceSettings(v []*DatabaseSettingsInterface) {
	o.InterfaceSettings = v
}

// GetMonitoringSuite returns value of MonitoringSuite
func (o *Database) GetMonitoringSuite() *MonitoringSuite {
	return o.MonitoringSuite
}

// SetMonitoringSuite sets value to MonitoringSuite
func (o *Database) SetMonitoringSuite(v *MonitoringSuite) {
	o.MonitoringSuite = v
}

// GetSettingsHash returns value of SettingsHash
func (o *Database) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *Database) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetInstanceHostName returns value of InstanceHostName
func (o *Database) GetInstanceHostName() string {
	return o.InstanceHostName
}

// SetInstanceHostName sets value to InstanceHostName
func (o *Database) SetInstanceHostName(v string) {
	o.InstanceHostName = v
}

// GetInstanceHostInfoURL returns value of InstanceHostInfoURL
func (o *Database) GetInstanceHostInfoURL() string {
	return o.InstanceHostInfoURL
}

// SetInstanceHostInfoURL sets value to InstanceHostInfoURL
func (o *Database) SetInstanceHostInfoURL(v string) {
	o.InstanceHostInfoURL = v
}

// GetInstanceStatus returns value of InstanceStatus
func (o *Database) GetInstanceStatus() types.EServerInstanceStatus {
	return o.InstanceStatus
}

// SetInstanceStatus sets value to InstanceStatus
func (o *Database) SetInstanceStatus(v types.EServerInstanceStatus) {
	o.InstanceStatus = v
}

// GetInstanceStatusChangedAt returns value of InstanceStatusChangedAt
func (o *Database) GetInstanceStatusChangedAt() time.Time {
	return o.InstanceStatusChangedAt
}

// SetInstanceStatusChangedAt sets value to InstanceStatusChangedAt
func (o *Database) SetInstanceStatusChangedAt(v time.Time) {
	o.InstanceStatusChangedAt = v
}

// GetPlanID returns value of PlanID
func (o *Database) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *Database) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetSwitchID returns value of SwitchID
func (o *Database) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *Database) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetConf returns value of Conf
func (o *Database) GetConf() *DatabaseRemarkDBConfCommon {
	return o.Conf
}

// SetConf sets value to Conf
func (o *Database) SetConf(v *DatabaseRemarkDBConfCommon) {
	o.Conf = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *Database) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *Database) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *Database) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *Database) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetIPAddresses returns value of IPAddresses
func (o *Database) GetIPAddresses() []string {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *Database) SetIPAddresses(v []string) {
	o.IPAddresses = v
}

// GetZoneID returns value of ZoneID
func (o *Database) GetZoneID() types.ID {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *Database) SetZoneID(v types.ID) {
	o.ZoneID = v
}

// GetInterfaces returns value of Interfaces
func (o *Database) GetInterfaces() []*InterfaceView {
	return o.Interfaces
}

// SetInterfaces sets value to Interfaces
func (o *Database) SetInterfaces(v []*InterfaceView) {
	o.Interfaces = v
}

// GetDisk returns value of Disk
func (o *Database) GetDisk() *DatabaseDisk {
	return o.Disk
}

// SetDisk sets value to Disk
func (o *Database) SetDisk(v *DatabaseDisk) {
	o.Disk = v
}

/*************************************************
* DatabaseSettingCommon
*************************************************/

// DatabaseSettingCommon represents API parameter/response structure
type DatabaseSettingCommon struct {
	WebUI           types.WebUI
	ServicePort     int
	SourceNetwork   []string
	DefaultUser     string
	UserPassword    string
	ReplicaUser     string
	ReplicaPassword string
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseSettingCommon) setDefaults() interface{} {
	return &struct {
		WebUI           types.WebUI
		ServicePort     int
		SourceNetwork   []string
		DefaultUser     string
		UserPassword    string
		ReplicaUser     string
		ReplicaPassword string
	}{
		WebUI:           o.GetWebUI(),
		ServicePort:     o.GetServicePort(),
		SourceNetwork:   o.GetSourceNetwork(),
		DefaultUser:     o.GetDefaultUser(),
		UserPassword:    o.GetUserPassword(),
		ReplicaUser:     o.GetReplicaUser(),
		ReplicaPassword: o.GetReplicaPassword(),
	}
}

// GetWebUI returns value of WebUI
func (o *DatabaseSettingCommon) GetWebUI() types.WebUI {
	return o.WebUI
}

// SetWebUI sets value to WebUI
func (o *DatabaseSettingCommon) SetWebUI(v types.WebUI) {
	o.WebUI = v
}

// GetServicePort returns value of ServicePort
func (o *DatabaseSettingCommon) GetServicePort() int {
	return o.ServicePort
}

// SetServicePort sets value to ServicePort
func (o *DatabaseSettingCommon) SetServicePort(v int) {
	o.ServicePort = v
}

// GetSourceNetwork returns value of SourceNetwork
func (o *DatabaseSettingCommon) GetSourceNetwork() []string {
	return o.SourceNetwork
}

// SetSourceNetwork sets value to SourceNetwork
func (o *DatabaseSettingCommon) SetSourceNetwork(v []string) {
	o.SourceNetwork = v
}

// GetDefaultUser returns value of DefaultUser
func (o *DatabaseSettingCommon) GetDefaultUser() string {
	return o.DefaultUser
}

// SetDefaultUser sets value to DefaultUser
func (o *DatabaseSettingCommon) SetDefaultUser(v string) {
	o.DefaultUser = v
}

// GetUserPassword returns value of UserPassword
func (o *DatabaseSettingCommon) GetUserPassword() string {
	return o.UserPassword
}

// SetUserPassword sets value to UserPassword
func (o *DatabaseSettingCommon) SetUserPassword(v string) {
	o.UserPassword = v
}

// GetReplicaUser returns value of ReplicaUser
func (o *DatabaseSettingCommon) GetReplicaUser() string {
	return o.ReplicaUser
}

// SetReplicaUser sets value to ReplicaUser
func (o *DatabaseSettingCommon) SetReplicaUser(v string) {
	o.ReplicaUser = v
}

// GetReplicaPassword returns value of ReplicaPassword
func (o *DatabaseSettingCommon) GetReplicaPassword() string {
	return o.ReplicaPassword
}

// SetReplicaPassword sets value to ReplicaPassword
func (o *DatabaseSettingCommon) SetReplicaPassword(v string) {
	o.ReplicaPassword = v
}

/*************************************************
* DatabaseSettingBackup
*************************************************/

// DatabaseSettingBackup represents API parameter/response structure
type DatabaseSettingBackup struct {
	Rotate    int
	Time      string
	DayOfWeek []types.EDayOfTheWeek
	Connect   string
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseSettingBackup) setDefaults() interface{} {
	return &struct {
		Rotate    int
		Time      string
		DayOfWeek []types.EDayOfTheWeek
		Connect   string
	}{
		Rotate:    o.GetRotate(),
		Time:      o.GetTime(),
		DayOfWeek: o.GetDayOfWeek(),
		Connect:   o.GetConnect(),
	}
}

// GetRotate returns value of Rotate
func (o *DatabaseSettingBackup) GetRotate() int {
	return o.Rotate
}

// SetRotate sets value to Rotate
func (o *DatabaseSettingBackup) SetRotate(v int) {
	o.Rotate = v
}

// GetTime returns value of Time
func (o *DatabaseSettingBackup) GetTime() string {
	return o.Time
}

// SetTime sets value to Time
func (o *DatabaseSettingBackup) SetTime(v string) {
	o.Time = v
}

// GetDayOfWeek returns value of DayOfWeek
func (o *DatabaseSettingBackup) GetDayOfWeek() []types.EDayOfTheWeek {
	return o.DayOfWeek
}

// SetDayOfWeek sets value to DayOfWeek
func (o *DatabaseSettingBackup) SetDayOfWeek(v []types.EDayOfTheWeek) {
	o.DayOfWeek = v
}

// GetConnect returns value of Connect
func (o *DatabaseSettingBackup) GetConnect() string {
	return o.Connect
}

// SetConnect sets value to Connect
func (o *DatabaseSettingBackup) SetConnect(v string) {
	o.Connect = v
}

/*************************************************
* DatabaseSettingBackupv2View
*************************************************/

// DatabaseSettingBackupv2View represents API parameter/response structure
type DatabaseSettingBackupv2View struct {
	Rotate         int
	Time           string
	DayOfWeek      []types.EDayOfTheWeek
	Connect        string
	FirstEnabledAt time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseSettingBackupv2View) setDefaults() interface{} {
	return &struct {
		Rotate         int
		Time           string
		DayOfWeek      []types.EDayOfTheWeek
		Connect        string
		FirstEnabledAt time.Time
	}{
		Rotate:         o.GetRotate(),
		Time:           o.GetTime(),
		DayOfWeek:      o.GetDayOfWeek(),
		Connect:        o.GetConnect(),
		FirstEnabledAt: o.GetFirstEnabledAt(),
	}
}

// GetRotate returns value of Rotate
func (o *DatabaseSettingBackupv2View) GetRotate() int {
	return o.Rotate
}

// SetRotate sets value to Rotate
func (o *DatabaseSettingBackupv2View) SetRotate(v int) {
	o.Rotate = v
}

// GetTime returns value of Time
func (o *DatabaseSettingBackupv2View) GetTime() string {
	return o.Time
}

// SetTime sets value to Time
func (o *DatabaseSettingBackupv2View) SetTime(v string) {
	o.Time = v
}

// GetDayOfWeek returns value of DayOfWeek
func (o *DatabaseSettingBackupv2View) GetDayOfWeek() []types.EDayOfTheWeek {
	return o.DayOfWeek
}

// SetDayOfWeek sets value to DayOfWeek
func (o *DatabaseSettingBackupv2View) SetDayOfWeek(v []types.EDayOfTheWeek) {
	o.DayOfWeek = v
}

// GetConnect returns value of Connect
func (o *DatabaseSettingBackupv2View) GetConnect() string {
	return o.Connect
}

// SetConnect sets value to Connect
func (o *DatabaseSettingBackupv2View) SetConnect(v string) {
	o.Connect = v
}

// GetFirstEnabledAt returns value of FirstEnabledAt
func (o *DatabaseSettingBackupv2View) GetFirstEnabledAt() time.Time {
	return o.FirstEnabledAt
}

// SetFirstEnabledAt sets value to FirstEnabledAt
func (o *DatabaseSettingBackupv2View) SetFirstEnabledAt(v time.Time) {
	o.FirstEnabledAt = v
}

/*************************************************
* DatabaseReplicationSetting
*************************************************/

// DatabaseReplicationSetting represents API parameter/response structure
type DatabaseReplicationSetting struct {
	Model       types.EDatabaseReplicationModel
	IPAddress   string
	Port        int
	User        string
	Password    string
	ApplianceID types.ID `mapconv:"Appliance.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseReplicationSetting) setDefaults() interface{} {
	return &struct {
		Model       types.EDatabaseReplicationModel
		IPAddress   string
		Port        int
		User        string
		Password    string
		ApplianceID types.ID `mapconv:"Appliance.ID"`
	}{
		Model:       o.GetModel(),
		IPAddress:   o.GetIPAddress(),
		Port:        o.GetPort(),
		User:        o.GetUser(),
		Password:    o.GetPassword(),
		ApplianceID: o.GetApplianceID(),
	}
}

// GetModel returns value of Model
func (o *DatabaseReplicationSetting) GetModel() types.EDatabaseReplicationModel {
	return o.Model
}

// SetModel sets value to Model
func (o *DatabaseReplicationSetting) SetModel(v types.EDatabaseReplicationModel) {
	o.Model = v
}

// GetIPAddress returns value of IPAddress
func (o *DatabaseReplicationSetting) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *DatabaseReplicationSetting) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetPort returns value of Port
func (o *DatabaseReplicationSetting) GetPort() int {
	return o.Port
}

// SetPort sets value to Port
func (o *DatabaseReplicationSetting) SetPort(v int) {
	o.Port = v
}

// GetUser returns value of User
func (o *DatabaseReplicationSetting) GetUser() string {
	return o.User
}

// SetUser sets value to User
func (o *DatabaseReplicationSetting) SetUser(v string) {
	o.User = v
}

// GetPassword returns value of Password
func (o *DatabaseReplicationSetting) GetPassword() string {
	return o.Password
}

// SetPassword sets value to Password
func (o *DatabaseReplicationSetting) SetPassword(v string) {
	o.Password = v
}

// GetApplianceID returns value of ApplianceID
func (o *DatabaseReplicationSetting) GetApplianceID() types.ID {
	return o.ApplianceID
}

// SetApplianceID sets value to ApplianceID
func (o *DatabaseReplicationSetting) SetApplianceID(v types.ID) {
	o.ApplianceID = v
}

/*************************************************
* DatabaseSettingsInterface
*************************************************/

// DatabaseSettingsInterface represents API parameter/response structure
type DatabaseSettingsInterface struct {
	VirtualIPAddress string
	Index            int
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseSettingsInterface) setDefaults() interface{} {
	return &struct {
		VirtualIPAddress string
		Index            int
	}{
		VirtualIPAddress: o.GetVirtualIPAddress(),
		Index:            o.GetIndex(),
	}
}

// GetVirtualIPAddress returns value of VirtualIPAddress
func (o *DatabaseSettingsInterface) GetVirtualIPAddress() string {
	return o.VirtualIPAddress
}

// SetVirtualIPAddress sets value to VirtualIPAddress
func (o *DatabaseSettingsInterface) SetVirtualIPAddress(v string) {
	o.VirtualIPAddress = v
}

// GetIndex returns value of Index
func (o *DatabaseSettingsInterface) GetIndex() int {
	return o.Index
}

// SetIndex sets value to Index
func (o *DatabaseSettingsInterface) SetIndex(v int) {
	o.Index = v
}

/*************************************************
* MonitoringSuite
*************************************************/

// MonitoringSuite represents API parameter/response structure
type MonitoringSuite struct {
	Enabled bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitoringSuite) setDefaults() interface{} {
	return &struct {
		Enabled bool
	}{
		Enabled: o.GetEnabled(),
	}
}

// GetEnabled returns value of Enabled
func (o *MonitoringSuite) GetEnabled() bool {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *MonitoringSuite) SetEnabled(v bool) {
	o.Enabled = v
}

/*************************************************
* DatabaseRemarkDBConfCommon
*************************************************/

// DatabaseRemarkDBConfCommon represents API parameter/response structure
type DatabaseRemarkDBConfCommon struct {
	DatabaseName     string
	DatabaseVersion  string
	DatabaseRevision string
	DefaultUser      string
	UserPassword     string
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseRemarkDBConfCommon) setDefaults() interface{} {
	return &struct {
		DatabaseName     string
		DatabaseVersion  string
		DatabaseRevision string
		DefaultUser      string
		UserPassword     string
	}{
		DatabaseName:     o.GetDatabaseName(),
		DatabaseVersion:  o.GetDatabaseVersion(),
		DatabaseRevision: o.GetDatabaseRevision(),
		DefaultUser:      o.GetDefaultUser(),
		UserPassword:     o.GetUserPassword(),
	}
}

// GetDatabaseName returns value of DatabaseName
func (o *DatabaseRemarkDBConfCommon) GetDatabaseName() string {
	return o.DatabaseName
}

// SetDatabaseName sets value to DatabaseName
func (o *DatabaseRemarkDBConfCommon) SetDatabaseName(v string) {
	o.DatabaseName = v
}

// GetDatabaseVersion returns value of DatabaseVersion
func (o *DatabaseRemarkDBConfCommon) GetDatabaseVersion() string {
	return o.DatabaseVersion
}

// SetDatabaseVersion sets value to DatabaseVersion
func (o *DatabaseRemarkDBConfCommon) SetDatabaseVersion(v string) {
	o.DatabaseVersion = v
}

// GetDatabaseRevision returns value of DatabaseRevision
func (o *DatabaseRemarkDBConfCommon) GetDatabaseRevision() string {
	return o.DatabaseRevision
}

// SetDatabaseRevision sets value to DatabaseRevision
func (o *DatabaseRemarkDBConfCommon) SetDatabaseRevision(v string) {
	o.DatabaseRevision = v
}

// GetDefaultUser returns value of DefaultUser
func (o *DatabaseRemarkDBConfCommon) GetDefaultUser() string {
	return o.DefaultUser
}

// SetDefaultUser sets value to DefaultUser
func (o *DatabaseRemarkDBConfCommon) SetDefaultUser(v string) {
	o.DefaultUser = v
}

// GetUserPassword returns value of UserPassword
func (o *DatabaseRemarkDBConfCommon) GetUserPassword() string {
	return o.UserPassword
}

// SetUserPassword sets value to UserPassword
func (o *DatabaseRemarkDBConfCommon) SetUserPassword(v string) {
	o.UserPassword = v
}

/*************************************************
* InterfaceView
*************************************************/

// InterfaceView represents API parameter/response structure
type InterfaceView struct {
	ID                              types.ID
	MACAddress                      string
	IPAddress                       string
	UserIPAddress                   string
	HostName                        string
	SwitchID                        types.ID           `mapconv:"Switch.ID"`
	SwitchName                      string             `mapconv:"Switch.Name"`
	SwitchScope                     types.EScope       `mapconv:"Switch.Scope"`
	UserSubnetDefaultRoute          string             `mapconv:"Switch.UserSubnet.DefaultRoute"`
	UserSubnetNetworkMaskLen        int                `mapconv:"Switch.UserSubnet.NetworkMaskLen"`
	SubnetDefaultRoute              string             `mapconv:"Switch.Subnet.DefaultRoute"`
	SubnetNetworkMaskLen            int                `mapconv:"Switch.Subnet.NetworkMaskLen"`
	SubnetNetworkAddress            string             `mapconv:"Switch.Subnet.NetworkAddress"`
	SubnetBandWidthMbps             int                `mapconv:"Switch.Subnet.Internet.BandWidthMbps"`
	PacketFilterID                  types.ID           `mapconv:"PacketFilter.ID"`
	PacketFilterName                string             `mapconv:"PacketFilter.Name"`
	PacketFilterRequiredHostVersion types.StringNumber `mapconv:"PacketFilter.RequiredHostVersionn"`
	UpstreamType                    types.EUpstreamNetworkType
}

// setDefaults implements iaas.argumentDefaulter
func (o *InterfaceView) setDefaults() interface{} {
	return &struct {
		ID                              types.ID
		MACAddress                      string
		IPAddress                       string
		UserIPAddress                   string
		HostName                        string
		SwitchID                        types.ID           `mapconv:"Switch.ID"`
		SwitchName                      string             `mapconv:"Switch.Name"`
		SwitchScope                     types.EScope       `mapconv:"Switch.Scope"`
		UserSubnetDefaultRoute          string             `mapconv:"Switch.UserSubnet.DefaultRoute"`
		UserSubnetNetworkMaskLen        int                `mapconv:"Switch.UserSubnet.NetworkMaskLen"`
		SubnetDefaultRoute              string             `mapconv:"Switch.Subnet.DefaultRoute"`
		SubnetNetworkMaskLen            int                `mapconv:"Switch.Subnet.NetworkMaskLen"`
		SubnetNetworkAddress            string             `mapconv:"Switch.Subnet.NetworkAddress"`
		SubnetBandWidthMbps             int                `mapconv:"Switch.Subnet.Internet.BandWidthMbps"`
		PacketFilterID                  types.ID           `mapconv:"PacketFilter.ID"`
		PacketFilterName                string             `mapconv:"PacketFilter.Name"`
		PacketFilterRequiredHostVersion types.StringNumber `mapconv:"PacketFilter.RequiredHostVersionn"`
		UpstreamType                    types.EUpstreamNetworkType
	}{
		ID:                              o.GetID(),
		MACAddress:                      o.GetMACAddress(),
		IPAddress:                       o.GetIPAddress(),
		UserIPAddress:                   o.GetUserIPAddress(),
		HostName:                        o.GetHostName(),
		SwitchID:                        o.GetSwitchID(),
		SwitchName:                      o.GetSwitchName(),
		SwitchScope:                     o.GetSwitchScope(),
		UserSubnetDefaultRoute:          o.GetUserSubnetDefaultRoute(),
		UserSubnetNetworkMaskLen:        o.GetUserSubnetNetworkMaskLen(),
		SubnetDefaultRoute:              o.GetSubnetDefaultRoute(),
		SubnetNetworkMaskLen:            o.GetSubnetNetworkMaskLen(),
		SubnetNetworkAddress:            o.GetSubnetNetworkAddress(),
		SubnetBandWidthMbps:             o.GetSubnetBandWidthMbps(),
		PacketFilterID:                  o.GetPacketFilterID(),
		PacketFilterName:                o.GetPacketFilterName(),
		PacketFilterRequiredHostVersion: o.GetPacketFilterRequiredHostVersion(),
		UpstreamType:                    o.GetUpstreamType(),
	}
}

// GetID returns value of ID
func (o *InterfaceView) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *InterfaceView) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *InterfaceView) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *InterfaceView) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *InterfaceView) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *InterfaceView) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetMACAddress returns value of MACAddress
func (o *InterfaceView) GetMACAddress() string {
	return o.MACAddress
}

// SetMACAddress sets value to MACAddress
func (o *InterfaceView) SetMACAddress(v string) {
	o.MACAddress = v
}

// GetIPAddress returns value of IPAddress
func (o *InterfaceView) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *InterfaceView) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetUserIPAddress returns value of UserIPAddress
func (o *InterfaceView) GetUserIPAddress() string {
	return o.UserIPAddress
}

// SetUserIPAddress sets value to UserIPAddress
func (o *InterfaceView) SetUserIPAddress(v string) {
	o.UserIPAddress = v
}

// GetHostName returns value of HostName
func (o *InterfaceView) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *InterfaceView) SetHostName(v string) {
	o.HostName = v
}

// GetSwitchID returns value of SwitchID
func (o *InterfaceView) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *InterfaceView) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetSwitchName returns value of SwitchName
func (o *InterfaceView) GetSwitchName() string {
	return o.SwitchName
}

// SetSwitchName sets value to SwitchName
func (o *InterfaceView) SetSwitchName(v string) {
	o.SwitchName = v
}

// GetSwitchScope returns value of SwitchScope
func (o *InterfaceView) GetSwitchScope() types.EScope {
	return o.SwitchScope
}

// SetSwitchScope sets value to SwitchScope
func (o *InterfaceView) SetSwitchScope(v types.EScope) {
	o.SwitchScope = v
}

// GetUserSubnetDefaultRoute returns value of UserSubnetDefaultRoute
func (o *InterfaceView) GetUserSubnetDefaultRoute() string {
	return o.UserSubnetDefaultRoute
}

// SetUserSubnetDefaultRoute sets value to UserSubnetDefaultRoute
func (o *InterfaceView) SetUserSubnetDefaultRoute(v string) {
	o.UserSubnetDefaultRoute = v
}

// GetUserSubnetNetworkMaskLen returns value of UserSubnetNetworkMaskLen
func (o *InterfaceView) GetUserSubnetNetworkMaskLen() int {
	return o.UserSubnetNetworkMaskLen
}

// SetUserSubnetNetworkMaskLen sets value to UserSubnetNetworkMaskLen
func (o *InterfaceView) SetUserSubnetNetworkMaskLen(v int) {
	o.UserSubnetNetworkMaskLen = v
}

// GetSubnetDefaultRoute returns value of SubnetDefaultRoute
func (o *InterfaceView) GetSubnetDefaultRoute() string {
	return o.SubnetDefaultRoute
}

// SetSubnetDefaultRoute sets value to SubnetDefaultRoute
func (o *InterfaceView) SetSubnetDefaultRoute(v string) {
	o.SubnetDefaultRoute = v
}

// GetSubnetNetworkMaskLen returns value of SubnetNetworkMaskLen
func (o *InterfaceView) GetSubnetNetworkMaskLen() int {
	return o.SubnetNetworkMaskLen
}

// SetSubnetNetworkMaskLen sets value to SubnetNetworkMaskLen
func (o *InterfaceView) SetSubnetNetworkMaskLen(v int) {
	o.SubnetNetworkMaskLen = v
}

// GetSubnetNetworkAddress returns value of SubnetNetworkAddress
func (o *InterfaceView) GetSubnetNetworkAddress() string {
	return o.SubnetNetworkAddress
}

// SetSubnetNetworkAddress sets value to SubnetNetworkAddress
func (o *InterfaceView) SetSubnetNetworkAddress(v string) {
	o.SubnetNetworkAddress = v
}

// GetSubnetBandWidthMbps returns value of SubnetBandWidthMbps
func (o *InterfaceView) GetSubnetBandWidthMbps() int {
	return o.SubnetBandWidthMbps
}

// SetSubnetBandWidthMbps sets value to SubnetBandWidthMbps
func (o *InterfaceView) SetSubnetBandWidthMbps(v int) {
	o.SubnetBandWidthMbps = v
}

// GetPacketFilterID returns value of PacketFilterID
func (o *InterfaceView) GetPacketFilterID() types.ID {
	return o.PacketFilterID
}

// SetPacketFilterID sets value to PacketFilterID
func (o *InterfaceView) SetPacketFilterID(v types.ID) {
	o.PacketFilterID = v
}

// GetPacketFilterName returns value of PacketFilterName
func (o *InterfaceView) GetPacketFilterName() string {
	return o.PacketFilterName
}

// SetPacketFilterName sets value to PacketFilterName
func (o *InterfaceView) SetPacketFilterName(v string) {
	o.PacketFilterName = v
}

// GetPacketFilterRequiredHostVersion returns value of PacketFilterRequiredHostVersion
func (o *InterfaceView) GetPacketFilterRequiredHostVersion() types.StringNumber {
	return o.PacketFilterRequiredHostVersion
}

// SetPacketFilterRequiredHostVersion sets value to PacketFilterRequiredHostVersion
func (o *InterfaceView) SetPacketFilterRequiredHostVersion(v types.StringNumber) {
	o.PacketFilterRequiredHostVersion = v
}

// GetUpstreamType returns value of UpstreamType
func (o *InterfaceView) GetUpstreamType() types.EUpstreamNetworkType {
	return o.UpstreamType
}

// SetUpstreamType sets value to UpstreamType
func (o *InterfaceView) SetUpstreamType(v types.EUpstreamNetworkType) {
	o.UpstreamType = v
}

/*************************************************
* DatabaseDisk
*************************************************/

// DatabaseDisk represents API parameter/response structure
type DatabaseDisk struct {
	EncryptionAlgorithm types.EDiskEncryptionAlgorithm
	EncryptionKeyID     types.ID `mapconv:"EncryptionKey.KMSKeyID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseDisk) setDefaults() interface{} {
	return &struct {
		EncryptionAlgorithm types.EDiskEncryptionAlgorithm
		EncryptionKeyID     types.ID `mapconv:"EncryptionKey.KMSKeyID"`
	}{
		EncryptionAlgorithm: o.GetEncryptionAlgorithm(),
		EncryptionKeyID:     o.GetEncryptionKeyID(),
	}
}

// GetEncryptionAlgorithm returns value of EncryptionAlgorithm
func (o *DatabaseDisk) GetEncryptionAlgorithm() types.EDiskEncryptionAlgorithm {
	return o.EncryptionAlgorithm
}

// SetEncryptionAlgorithm sets value to EncryptionAlgorithm
func (o *DatabaseDisk) SetEncryptionAlgorithm(v types.EDiskEncryptionAlgorithm) {
	o.EncryptionAlgorithm = v
}

// GetEncryptionKeyID returns value of EncryptionKeyID
func (o *DatabaseDisk) GetEncryptionKeyID() types.ID {
	return o.EncryptionKeyID
}

// SetEncryptionKeyID sets value to EncryptionKeyID
func (o *DatabaseDisk) SetEncryptionKeyID(v types.ID) {
	o.EncryptionKeyID = v
}

/*************************************************
* DatabaseCreateRequest
*************************************************/

// DatabaseCreateRequest represents API parameter/response structure
type DatabaseCreateRequest struct {
	PlanID             types.ID                     `mapconv:"Remark.Plan.ID/Plan.ID"`
	SwitchID           types.ID                     `mapconv:"Remark.Switch.ID"`
	IPAddresses        []string                     `mapconv:"Remark.[]Servers.IPAddress"`
	NetworkMaskLen     int                          `mapconv:"Remark.Network.NetworkMaskLen"`
	DefaultRoute       string                       `mapconv:"Remark.Network.DefaultRoute"`
	Conf               *DatabaseRemarkDBConfCommon  `mapconv:"Remark.DBConf.Common,recursive"`
	SourceID           types.ID                     `mapconv:"Remark.SourceAppliance.ID"`
	CommonSetting      *DatabaseSettingCommon       `mapconv:"Settings.DBConf.Common,recursive"`
	BackupSetting      *DatabaseSettingBackup       `mapconv:"Settings.DBConf.Backup,recursive"`
	Backupv2Setting    *DatabaseSettingBackupv2     `mapconv:"Settings.DBConf.Backupv2,recursive"`
	ReplicationSetting *DatabaseReplicationSetting  `mapconv:"Settings.DBConf.Replication,recursive"`
	InterfaceSettings  []*DatabaseSettingsInterface `mapconv:"Settings.DBConf.[]Interfaces,omitempty,recursive"`
	MonitoringSuite    *MonitoringSuite             `mapconv:"Settings.MonitoringSuite,omitempty,recursive"`
	Disk               *DatabaseDisk                `mapconv:"Disk,recursive"`
	Name               string
	Description        string
	Tags               types.Tags
	IconID             types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseCreateRequest) setDefaults() interface{} {
	return &struct {
		PlanID             types.ID                     `mapconv:"Remark.Plan.ID/Plan.ID"`
		SwitchID           types.ID                     `mapconv:"Remark.Switch.ID"`
		IPAddresses        []string                     `mapconv:"Remark.[]Servers.IPAddress"`
		NetworkMaskLen     int                          `mapconv:"Remark.Network.NetworkMaskLen"`
		DefaultRoute       string                       `mapconv:"Remark.Network.DefaultRoute"`
		Conf               *DatabaseRemarkDBConfCommon  `mapconv:"Remark.DBConf.Common,recursive"`
		SourceID           types.ID                     `mapconv:"Remark.SourceAppliance.ID"`
		CommonSetting      *DatabaseSettingCommon       `mapconv:"Settings.DBConf.Common,recursive"`
		BackupSetting      *DatabaseSettingBackup       `mapconv:"Settings.DBConf.Backup,recursive"`
		Backupv2Setting    *DatabaseSettingBackupv2     `mapconv:"Settings.DBConf.Backupv2,recursive"`
		ReplicationSetting *DatabaseReplicationSetting  `mapconv:"Settings.DBConf.Replication,recursive"`
		InterfaceSettings  []*DatabaseSettingsInterface `mapconv:"Settings.DBConf.[]Interfaces,omitempty,recursive"`
		MonitoringSuite    *MonitoringSuite             `mapconv:"Settings.MonitoringSuite,omitempty,recursive"`
		Disk               *DatabaseDisk                `mapconv:"Disk,recursive"`
		Name               string
		Description        string
		Tags               types.Tags
		IconID             types.ID `mapconv:"Icon.ID"`
		Class              string
	}{
		PlanID:             o.GetPlanID(),
		SwitchID:           o.GetSwitchID(),
		IPAddresses:        o.GetIPAddresses(),
		NetworkMaskLen:     o.GetNetworkMaskLen(),
		DefaultRoute:       o.GetDefaultRoute(),
		Conf:               o.GetConf(),
		SourceID:           o.GetSourceID(),
		CommonSetting:      o.GetCommonSetting(),
		BackupSetting:      o.GetBackupSetting(),
		Backupv2Setting:    o.GetBackupv2Setting(),
		ReplicationSetting: o.GetReplicationSetting(),
		InterfaceSettings:  o.GetInterfaceSettings(),
		MonitoringSuite:    o.GetMonitoringSuite(),
		Disk:               o.GetDisk(),
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		Class:              "database",
	}
}

// GetPlanID returns value of PlanID
func (o *DatabaseCreateRequest) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *DatabaseCreateRequest) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetSwitchID returns value of SwitchID
func (o *DatabaseCreateRequest) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *DatabaseCreateRequest) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetIPAddresses returns value of IPAddresses
func (o *DatabaseCreateRequest) GetIPAddresses() []string {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *DatabaseCreateRequest) SetIPAddresses(v []string) {
	o.IPAddresses = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *DatabaseCreateRequest) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *DatabaseCreateRequest) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *DatabaseCreateRequest) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *DatabaseCreateRequest) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetConf returns value of Conf
func (o *DatabaseCreateRequest) GetConf() *DatabaseRemarkDBConfCommon {
	return o.Conf
}

// SetConf sets value to Conf
func (o *DatabaseCreateRequest) SetConf(v *DatabaseRemarkDBConfCommon) {
	o.Conf = v
}

// GetSourceID returns value of SourceID
func (o *DatabaseCreateRequest) GetSourceID() types.ID {
	return o.SourceID
}

// SetSourceID sets value to SourceID
func (o *DatabaseCreateRequest) SetSourceID(v types.ID) {
	o.SourceID = v
}

// GetCommonSetting returns value of CommonSetting
func (o *DatabaseCreateRequest) GetCommonSetting() *DatabaseSettingCommon {
	return o.CommonSetting
}

// SetCommonSetting sets value to CommonSetting
func (o *DatabaseCreateRequest) SetCommonSetting(v *DatabaseSettingCommon) {
	o.CommonSetting = v
}

// GetBackupSetting returns value of BackupSetting
func (o *DatabaseCreateRequest) GetBackupSetting() *DatabaseSettingBackup {
	return o.BackupSetting
}

// SetBackupSetting sets value to BackupSetting
func (o *DatabaseCreateRequest) SetBackupSetting(v *DatabaseSettingBackup) {
	o.BackupSetting = v
}

// GetBackupv2Setting returns value of Backupv2Setting
func (o *DatabaseCreateRequest) GetBackupv2Setting() *DatabaseSettingBackupv2 {
	return o.Backupv2Setting
}

// SetBackupv2Setting sets value to Backupv2Setting
func (o *DatabaseCreateRequest) SetBackupv2Setting(v *DatabaseSettingBackupv2) {
	o.Backupv2Setting = v
}

// GetReplicationSetting returns value of ReplicationSetting
func (o *DatabaseCreateRequest) GetReplicationSetting() *DatabaseReplicationSetting {
	return o.ReplicationSetting
}

// SetReplicationSetting sets value to ReplicationSetting
func (o *DatabaseCreateRequest) SetReplicationSetting(v *DatabaseReplicationSetting) {
	o.ReplicationSetting = v
}

// GetInterfaceSettings returns value of InterfaceSettings
func (o *DatabaseCreateRequest) GetInterfaceSettings() []*DatabaseSettingsInterface {
	return o.InterfaceSettings
}

// SetInterfaceSettings sets value to InterfaceSettings
func (o *DatabaseCreateRequest) SetInterfaceSettings(v []*DatabaseSettingsInterface) {
	o.InterfaceSettings = v
}

// GetMonitoringSuite returns value of MonitoringSuite
func (o *DatabaseCreateRequest) GetMonitoringSuite() *MonitoringSuite {
	return o.MonitoringSuite
}

// SetMonitoringSuite sets value to MonitoringSuite
func (o *DatabaseCreateRequest) SetMonitoringSuite(v *MonitoringSuite) {
	o.MonitoringSuite = v
}

// GetDisk returns value of Disk
func (o *DatabaseCreateRequest) GetDisk() *DatabaseDisk {
	return o.Disk
}

// SetDisk sets value to Disk
func (o *DatabaseCreateRequest) SetDisk(v *DatabaseDisk) {
	o.Disk = v
}

// GetName returns value of Name
func (o *DatabaseCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DatabaseCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *DatabaseCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *DatabaseCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *DatabaseCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *DatabaseCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *DatabaseCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *DatabaseCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *DatabaseCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *DatabaseCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *DatabaseCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *DatabaseCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* DatabaseSettingBackupv2
*************************************************/

// DatabaseSettingBackupv2 represents API parameter/response structure
type DatabaseSettingBackupv2 struct {
	Rotate    int
	Time      string
	DayOfWeek []types.EDayOfTheWeek
	Connect   string
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseSettingBackupv2) setDefaults() interface{} {
	return &struct {
		Rotate    int
		Time      string
		DayOfWeek []types.EDayOfTheWeek
		Connect   string
	}{
		Rotate:    o.GetRotate(),
		Time:      o.GetTime(),
		DayOfWeek: o.GetDayOfWeek(),
		Connect:   o.GetConnect(),
	}
}

// GetRotate returns value of Rotate
func (o *DatabaseSettingBackupv2) GetRotate() int {
	return o.Rotate
}

// SetRotate sets value to Rotate
func (o *DatabaseSettingBackupv2) SetRotate(v int) {
	o.Rotate = v
}

// GetTime returns value of Time
func (o *DatabaseSettingBackupv2) GetTime() string {
	return o.Time
}

// SetTime sets value to Time
func (o *DatabaseSettingBackupv2) SetTime(v string) {
	o.Time = v
}

// GetDayOfWeek returns value of DayOfWeek
func (o *DatabaseSettingBackupv2) GetDayOfWeek() []types.EDayOfTheWeek {
	return o.DayOfWeek
}

// SetDayOfWeek sets value to DayOfWeek
func (o *DatabaseSettingBackupv2) SetDayOfWeek(v []types.EDayOfTheWeek) {
	o.DayOfWeek = v
}

// GetConnect returns value of Connect
func (o *DatabaseSettingBackupv2) GetConnect() string {
	return o.Connect
}

// SetConnect sets value to Connect
func (o *DatabaseSettingBackupv2) SetConnect(v string) {
	o.Connect = v
}

/*************************************************
* DatabaseUpdateRequest
*************************************************/

// DatabaseUpdateRequest represents API parameter/response structure
type DatabaseUpdateRequest struct {
	Name               string
	Description        string
	Tags               types.Tags
	IconID             types.ID                     `mapconv:"Icon.ID"`
	CommonSetting      *DatabaseSettingCommon       `mapconv:"Settings.DBConf.Common,recursive"`
	BackupSetting      *DatabaseSettingBackup       `mapconv:"Settings.DBConf.Backup,recursive"`
	Backupv2Setting    *DatabaseSettingBackupv2     `mapconv:"Settings.DBConf.Backupv2,recursive"`
	ReplicationSetting *DatabaseReplicationSetting  `mapconv:"Settings.DBConf.Replication,recursive"`
	InterfaceSettings  []*DatabaseSettingsInterface `mapconv:"Settings.DBConf.[]Interfaces,omitempty,recursive"`
	MonitoringSuite    *MonitoringSuite             `mapconv:"Settings.MonitoringSuite,omitempty,recursive"`
	SettingsHash       string                       `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name               string
		Description        string
		Tags               types.Tags
		IconID             types.ID                     `mapconv:"Icon.ID"`
		CommonSetting      *DatabaseSettingCommon       `mapconv:"Settings.DBConf.Common,recursive"`
		BackupSetting      *DatabaseSettingBackup       `mapconv:"Settings.DBConf.Backup,recursive"`
		Backupv2Setting    *DatabaseSettingBackupv2     `mapconv:"Settings.DBConf.Backupv2,recursive"`
		ReplicationSetting *DatabaseReplicationSetting  `mapconv:"Settings.DBConf.Replication,recursive"`
		InterfaceSettings  []*DatabaseSettingsInterface `mapconv:"Settings.DBConf.[]Interfaces,omitempty,recursive"`
		MonitoringSuite    *MonitoringSuite             `mapconv:"Settings.MonitoringSuite,omitempty,recursive"`
		SettingsHash       string                       `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		CommonSetting:      o.GetCommonSetting(),
		BackupSetting:      o.GetBackupSetting(),
		Backupv2Setting:    o.GetBackupv2Setting(),
		ReplicationSetting: o.GetReplicationSetting(),
		InterfaceSettings:  o.GetInterfaceSettings(),
		MonitoringSuite:    o.GetMonitoringSuite(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *DatabaseUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DatabaseUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *DatabaseUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *DatabaseUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *DatabaseUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *DatabaseUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *DatabaseUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *DatabaseUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *DatabaseUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *DatabaseUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *DatabaseUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *DatabaseUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCommonSetting returns value of CommonSetting
func (o *DatabaseUpdateRequest) GetCommonSetting() *DatabaseSettingCommon {
	return o.CommonSetting
}

// SetCommonSetting sets value to CommonSetting
func (o *DatabaseUpdateRequest) SetCommonSetting(v *DatabaseSettingCommon) {
	o.CommonSetting = v
}

// GetBackupSetting returns value of BackupSetting
func (o *DatabaseUpdateRequest) GetBackupSetting() *DatabaseSettingBackup {
	return o.BackupSetting
}

// SetBackupSetting sets value to BackupSetting
func (o *DatabaseUpdateRequest) SetBackupSetting(v *DatabaseSettingBackup) {
	o.BackupSetting = v
}

// GetBackupv2Setting returns value of Backupv2Setting
func (o *DatabaseUpdateRequest) GetBackupv2Setting() *DatabaseSettingBackupv2 {
	return o.Backupv2Setting
}

// SetBackupv2Setting sets value to Backupv2Setting
func (o *DatabaseUpdateRequest) SetBackupv2Setting(v *DatabaseSettingBackupv2) {
	o.Backupv2Setting = v
}

// GetReplicationSetting returns value of ReplicationSetting
func (o *DatabaseUpdateRequest) GetReplicationSetting() *DatabaseReplicationSetting {
	return o.ReplicationSetting
}

// SetReplicationSetting sets value to ReplicationSetting
func (o *DatabaseUpdateRequest) SetReplicationSetting(v *DatabaseReplicationSetting) {
	o.ReplicationSetting = v
}

// GetInterfaceSettings returns value of InterfaceSettings
func (o *DatabaseUpdateRequest) GetInterfaceSettings() []*DatabaseSettingsInterface {
	return o.InterfaceSettings
}

// SetInterfaceSettings sets value to InterfaceSettings
func (o *DatabaseUpdateRequest) SetInterfaceSettings(v []*DatabaseSettingsInterface) {
	o.InterfaceSettings = v
}

// GetMonitoringSuite returns value of MonitoringSuite
func (o *DatabaseUpdateRequest) GetMonitoringSuite() *MonitoringSuite {
	return o.MonitoringSuite
}

// SetMonitoringSuite sets value to MonitoringSuite
func (o *DatabaseUpdateRequest) SetMonitoringSuite(v *MonitoringSuite) {
	o.MonitoringSuite = v
}

// GetSettingsHash returns value of SettingsHash
func (o *DatabaseUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *DatabaseUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* DatabaseUpdateSettingsRequest
*************************************************/

// DatabaseUpdateSettingsRequest represents API parameter/response structure
type DatabaseUpdateSettingsRequest struct {
	CommonSetting      *DatabaseSettingCommon       `mapconv:"Settings.DBConf.Common,recursive"`
	BackupSetting      *DatabaseSettingBackup       `mapconv:"Settings.DBConf.Backup,recursive"`
	Backupv2Setting    *DatabaseSettingBackupv2     `mapconv:"Settings.DBConf.Backupv2,recursive"`
	ReplicationSetting *DatabaseReplicationSetting  `mapconv:"Settings.DBConf.Replication,recursive"`
	InterfaceSettings  []*DatabaseSettingsInterface `mapconv:"Settings.DBConf.[]Interfaces,omitempty,recursive"`
	MonitoringSuite    *MonitoringSuite             `mapconv:"Settings.MonitoringSuite,omitempty,recursive"`
	SettingsHash       string                       `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		CommonSetting      *DatabaseSettingCommon       `mapconv:"Settings.DBConf.Common,recursive"`
		BackupSetting      *DatabaseSettingBackup       `mapconv:"Settings.DBConf.Backup,recursive"`
		Backupv2Setting    *DatabaseSettingBackupv2     `mapconv:"Settings.DBConf.Backupv2,recursive"`
		ReplicationSetting *DatabaseReplicationSetting  `mapconv:"Settings.DBConf.Replication,recursive"`
		InterfaceSettings  []*DatabaseSettingsInterface `mapconv:"Settings.DBConf.[]Interfaces,omitempty,recursive"`
		MonitoringSuite    *MonitoringSuite             `mapconv:"Settings.MonitoringSuite,omitempty,recursive"`
		SettingsHash       string                       `json:",omitempty" mapconv:",omitempty"`
	}{
		CommonSetting:      o.GetCommonSetting(),
		BackupSetting:      o.GetBackupSetting(),
		Backupv2Setting:    o.GetBackupv2Setting(),
		ReplicationSetting: o.GetReplicationSetting(),
		InterfaceSettings:  o.GetInterfaceSettings(),
		MonitoringSuite:    o.GetMonitoringSuite(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetCommonSetting returns value of CommonSetting
func (o *DatabaseUpdateSettingsRequest) GetCommonSetting() *DatabaseSettingCommon {
	return o.CommonSetting
}

// SetCommonSetting sets value to CommonSetting
func (o *DatabaseUpdateSettingsRequest) SetCommonSetting(v *DatabaseSettingCommon) {
	o.CommonSetting = v
}

// GetBackupSetting returns value of BackupSetting
func (o *DatabaseUpdateSettingsRequest) GetBackupSetting() *DatabaseSettingBackup {
	return o.BackupSetting
}

// SetBackupSetting sets value to BackupSetting
func (o *DatabaseUpdateSettingsRequest) SetBackupSetting(v *DatabaseSettingBackup) {
	o.BackupSetting = v
}

// GetBackupv2Setting returns value of Backupv2Setting
func (o *DatabaseUpdateSettingsRequest) GetBackupv2Setting() *DatabaseSettingBackupv2 {
	return o.Backupv2Setting
}

// SetBackupv2Setting sets value to Backupv2Setting
func (o *DatabaseUpdateSettingsRequest) SetBackupv2Setting(v *DatabaseSettingBackupv2) {
	o.Backupv2Setting = v
}

// GetReplicationSetting returns value of ReplicationSetting
func (o *DatabaseUpdateSettingsRequest) GetReplicationSetting() *DatabaseReplicationSetting {
	return o.ReplicationSetting
}

// SetReplicationSetting sets value to ReplicationSetting
func (o *DatabaseUpdateSettingsRequest) SetReplicationSetting(v *DatabaseReplicationSetting) {
	o.ReplicationSetting = v
}

// GetInterfaceSettings returns value of InterfaceSettings
func (o *DatabaseUpdateSettingsRequest) GetInterfaceSettings() []*DatabaseSettingsInterface {
	return o.InterfaceSettings
}

// SetInterfaceSettings sets value to InterfaceSettings
func (o *DatabaseUpdateSettingsRequest) SetInterfaceSettings(v []*DatabaseSettingsInterface) {
	o.InterfaceSettings = v
}

// GetMonitoringSuite returns value of MonitoringSuite
func (o *DatabaseUpdateSettingsRequest) GetMonitoringSuite() *MonitoringSuite {
	return o.MonitoringSuite
}

// SetMonitoringSuite sets value to MonitoringSuite
func (o *DatabaseUpdateSettingsRequest) SetMonitoringSuite(v *MonitoringSuite) {
	o.MonitoringSuite = v
}

// GetSettingsHash returns value of SettingsHash
func (o *DatabaseUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *DatabaseUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* ShutdownOption
*************************************************/

// ShutdownOption represents API parameter/response structure
type ShutdownOption struct {
	Force bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *ShutdownOption) setDefaults() interface{} {
	return &struct {
		Force bool
	}{
		Force: o.GetForce(),
	}
}

// GetForce returns value of Force
func (o *ShutdownOption) GetForce() bool {
	return o.Force
}

// SetForce sets value to Force
func (o *ShutdownOption) SetForce(v bool) {
	o.Force = v
}

/*************************************************
* CPUTimeActivity
*************************************************/

// CPUTimeActivity represents API parameter/response structure
type CPUTimeActivity struct {
	Values []*MonitorCPUTimeValue `mapconv:"[]CPU"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *CPUTimeActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorCPUTimeValue `mapconv:"[]CPU"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *CPUTimeActivity) GetValues() []*MonitorCPUTimeValue {
	return o.Values
}

// SetValues sets value to Values
func (o *CPUTimeActivity) SetValues(v []*MonitorCPUTimeValue) {
	o.Values = v
}

/*************************************************
* MonitorCPUTimeValue
*************************************************/

// MonitorCPUTimeValue represents API parameter/response structure
type MonitorCPUTimeValue struct {
	Time    time.Time `mapconv:",omitempty"`
	CPUTime float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorCPUTimeValue) setDefaults() interface{} {
	return &struct {
		Time    time.Time `mapconv:",omitempty"`
		CPUTime float64   `mapconv:",omitempty"`
	}{
		Time:    o.GetTime(),
		CPUTime: o.GetCPUTime(),
	}
}

// GetTime returns value of Time
func (o *MonitorCPUTimeValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorCPUTimeValue) SetTime(v time.Time) {
	o.Time = v
}

// GetCPUTime returns value of CPUTime
func (o *MonitorCPUTimeValue) GetCPUTime() float64 {
	return o.CPUTime
}

// SetCPUTime sets value to CPUTime
func (o *MonitorCPUTimeValue) SetCPUTime(v float64) {
	o.CPUTime = v
}

/*************************************************
* MonitorCondition
*************************************************/

// MonitorCondition represents API parameter/response structure
type MonitorCondition struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorCondition) setDefaults() interface{} {
	return &struct {
		Start time.Time `json:",omitempty"`
		End   time.Time `json:",omitempty"`
	}{
		Start: o.GetStart(),
		End:   o.GetEnd(),
	}
}

// GetStart returns value of Start
func (o *MonitorCondition) GetStart() time.Time {
	if o.Start.IsZero() {
		return time.Now().Truncate(time.Second).Add(-time.Hour)
	}
	return o.Start
}

// SetStart sets value to Start
func (o *MonitorCondition) SetStart(v time.Time) {
	o.Start = v
}

// GetEnd returns value of End
func (o *MonitorCondition) GetEnd() time.Time {
	if o.End.IsZero() {
		return time.Now().Truncate(time.Second)
	}
	return o.End
}

// SetEnd sets value to End
func (o *MonitorCondition) SetEnd(v time.Time) {
	o.End = v
}

/*************************************************
* DiskActivity
*************************************************/

// DiskActivity represents API parameter/response structure
type DiskActivity struct {
	Values []*MonitorDiskValue `mapconv:"[]Disk"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorDiskValue `mapconv:"[]Disk"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *DiskActivity) GetValues() []*MonitorDiskValue {
	return o.Values
}

// SetValues sets value to Values
func (o *DiskActivity) SetValues(v []*MonitorDiskValue) {
	o.Values = v
}

/*************************************************
* MonitorDiskValue
*************************************************/

// MonitorDiskValue represents API parameter/response structure
type MonitorDiskValue struct {
	Time  time.Time `mapconv:",omitempty"`
	Read  float64   `mapconv:",omitempty"`
	Write float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorDiskValue) setDefaults() interface{} {
	return &struct {
		Time  time.Time `mapconv:",omitempty"`
		Read  float64   `mapconv:",omitempty"`
		Write float64   `mapconv:",omitempty"`
	}{
		Time:  o.GetTime(),
		Read:  o.GetRead(),
		Write: o.GetWrite(),
	}
}

// GetTime returns value of Time
func (o *MonitorDiskValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorDiskValue) SetTime(v time.Time) {
	o.Time = v
}

// GetRead returns value of Read
func (o *MonitorDiskValue) GetRead() float64 {
	return o.Read
}

// SetRead sets value to Read
func (o *MonitorDiskValue) SetRead(v float64) {
	o.Read = v
}

// GetWrite returns value of Write
func (o *MonitorDiskValue) GetWrite() float64 {
	return o.Write
}

// SetWrite sets value to Write
func (o *MonitorDiskValue) SetWrite(v float64) {
	o.Write = v
}

/*************************************************
* InterfaceActivity
*************************************************/

// InterfaceActivity represents API parameter/response structure
type InterfaceActivity struct {
	Values []*MonitorInterfaceValue `mapconv:"[]Interface"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *InterfaceActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorInterfaceValue `mapconv:"[]Interface"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *InterfaceActivity) GetValues() []*MonitorInterfaceValue {
	return o.Values
}

// SetValues sets value to Values
func (o *InterfaceActivity) SetValues(v []*MonitorInterfaceValue) {
	o.Values = v
}

/*************************************************
* MonitorInterfaceValue
*************************************************/

// MonitorInterfaceValue represents API parameter/response structure
type MonitorInterfaceValue struct {
	Time    time.Time `mapconv:",omitempty"`
	Receive float64   `mapconv:",omitempty"`
	Send    float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorInterfaceValue) setDefaults() interface{} {
	return &struct {
		Time    time.Time `mapconv:",omitempty"`
		Receive float64   `mapconv:",omitempty"`
		Send    float64   `mapconv:",omitempty"`
	}{
		Time:    o.GetTime(),
		Receive: o.GetReceive(),
		Send:    o.GetSend(),
	}
}

// GetTime returns value of Time
func (o *MonitorInterfaceValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorInterfaceValue) SetTime(v time.Time) {
	o.Time = v
}

// GetReceive returns value of Receive
func (o *MonitorInterfaceValue) GetReceive() float64 {
	return o.Receive
}

// SetReceive sets value to Receive
func (o *MonitorInterfaceValue) SetReceive(v float64) {
	o.Receive = v
}

// GetSend returns value of Send
func (o *MonitorInterfaceValue) GetSend() float64 {
	return o.Send
}

// SetSend sets value to Send
func (o *MonitorInterfaceValue) SetSend(v float64) {
	o.Send = v
}

/*************************************************
* DatabaseActivity
*************************************************/

// DatabaseActivity represents API parameter/response structure
type DatabaseActivity struct {
	Values []*MonitorDatabaseValue `mapconv:"[]Database"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorDatabaseValue `mapconv:"[]Database"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *DatabaseActivity) GetValues() []*MonitorDatabaseValue {
	return o.Values
}

// SetValues sets value to Values
func (o *DatabaseActivity) SetValues(v []*MonitorDatabaseValue) {
	o.Values = v
}

/*************************************************
* MonitorDatabaseValue
*************************************************/

// MonitorDatabaseValue represents API parameter/response structure
type MonitorDatabaseValue struct {
	Time              time.Time `mapconv:",omitempty"`
	TotalMemorySize   float64   `mapconv:",omitempty"`
	UsedMemorySize    float64   `mapconv:",omitempty"`
	TotalDisk1Size    float64   `mapconv:",omitempty"`
	UsedDisk1Size     float64   `mapconv:",omitempty"`
	TotalDisk2Size    float64   `mapconv:",omitempty"`
	UsedDisk2Size     float64   `mapconv:",omitempty"`
	BinlogUsedSizeKiB float64   `mapconv:",omitempty"`
	DelayTimeSec      float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorDatabaseValue) setDefaults() interface{} {
	return &struct {
		Time              time.Time `mapconv:",omitempty"`
		TotalMemorySize   float64   `mapconv:",omitempty"`
		UsedMemorySize    float64   `mapconv:",omitempty"`
		TotalDisk1Size    float64   `mapconv:",omitempty"`
		UsedDisk1Size     float64   `mapconv:",omitempty"`
		TotalDisk2Size    float64   `mapconv:",omitempty"`
		UsedDisk2Size     float64   `mapconv:",omitempty"`
		BinlogUsedSizeKiB float64   `mapconv:",omitempty"`
		DelayTimeSec      float64   `mapconv:",omitempty"`
	}{
		Time:              o.GetTime(),
		TotalMemorySize:   o.GetTotalMemorySize(),
		UsedMemorySize:    o.GetUsedMemorySize(),
		TotalDisk1Size:    o.GetTotalDisk1Size(),
		UsedDisk1Size:     o.GetUsedDisk1Size(),
		TotalDisk2Size:    o.GetTotalDisk2Size(),
		UsedDisk2Size:     o.GetUsedDisk2Size(),
		BinlogUsedSizeKiB: o.GetBinlogUsedSizeKiB(),
		DelayTimeSec:      o.GetDelayTimeSec(),
	}
}

// GetTime returns value of Time
func (o *MonitorDatabaseValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorDatabaseValue) SetTime(v time.Time) {
	o.Time = v
}

// GetTotalMemorySize  returns value of TotalMemorySize
func (o *MonitorDatabaseValue) GetTotalMemorySize() float64 {
	return o.TotalMemorySize
}

// SetTotalMemorySize  sets value to TotalMemorySize
func (o *MonitorDatabaseValue) SetTotalMemorySize(v float64) {
	o.TotalMemorySize = v
}

// GetUsedMemorySize returns value of UsedMemorySize
func (o *MonitorDatabaseValue) GetUsedMemorySize() float64 {
	return o.UsedMemorySize
}

// SetUsedMemorySize sets value to UsedMemorySize
func (o *MonitorDatabaseValue) SetUsedMemorySize(v float64) {
	o.UsedMemorySize = v
}

// GetTotalDisk1Size returns value of TotalDisk1Size
func (o *MonitorDatabaseValue) GetTotalDisk1Size() float64 {
	return o.TotalDisk1Size
}

// SetTotalDisk1Size sets value to TotalDisk1Size
func (o *MonitorDatabaseValue) SetTotalDisk1Size(v float64) {
	o.TotalDisk1Size = v
}

// GetUsedDisk1Size returns value of UsedDisk1Size
func (o *MonitorDatabaseValue) GetUsedDisk1Size() float64 {
	return o.UsedDisk1Size
}

// SetUsedDisk1Size sets value to UsedDisk1Size
func (o *MonitorDatabaseValue) SetUsedDisk1Size(v float64) {
	o.UsedDisk1Size = v
}

// GetTotalDisk2Size returns value of TotalDisk2Size
func (o *MonitorDatabaseValue) GetTotalDisk2Size() float64 {
	return o.TotalDisk2Size
}

// SetTotalDisk2Size sets value to TotalDisk2Size
func (o *MonitorDatabaseValue) SetTotalDisk2Size(v float64) {
	o.TotalDisk2Size = v
}

// GetUsedDisk2Size returns value of UsedDisk2Size
func (o *MonitorDatabaseValue) GetUsedDisk2Size() float64 {
	return o.UsedDisk2Size
}

// SetUsedDisk2Size sets value to UsedDisk2Size
func (o *MonitorDatabaseValue) SetUsedDisk2Size(v float64) {
	o.UsedDisk2Size = v
}

// GetBinlogUsedSizeKiB returns value of BinlogUsedSizeKiB
func (o *MonitorDatabaseValue) GetBinlogUsedSizeKiB() float64 {
	return o.BinlogUsedSizeKiB
}

// SetBinlogUsedSizeKiB sets value to BinlogUsedSizeKiB
func (o *MonitorDatabaseValue) SetBinlogUsedSizeKiB(v float64) {
	o.BinlogUsedSizeKiB = v
}

// GetDelayTimeSec returns value of DelayTimeSec
func (o *MonitorDatabaseValue) GetDelayTimeSec() float64 {
	return o.DelayTimeSec
}

// SetDelayTimeSec sets value to DelayTimeSec
func (o *MonitorDatabaseValue) SetDelayTimeSec(v float64) {
	o.DelayTimeSec = v
}

/*************************************************
* DatabaseStatus
*************************************************/

// DatabaseStatus represents API parameter/response structure
type DatabaseStatus struct {
	Status         types.EServerInstanceStatus `mapconv:"SettingsResponse.Status"`
	MariaDBStatus  string                      `mapconv:"SettingsResponse.DBConf.MariaDB.Status"`
	PostgresStatus string                      `mapconv:"SettingsResponse.DBConf.Postgres.Status"`
	IsFatal        bool                        `mapconv:"SettingsResponse.IsFatal"`
	Version        *DatabaseVersionInfo        `mapconv:"SettingsResponse.DBConf.Version,recursive"`
	Logs           []*DatabaseLog              `mapconv:"SettingsResponse.DBConf.[]Log,recursive"`
	Backups        []*DatabaseBackupHistory    `mapconv:"SettingsResponse.DBConf.Backup.[]History,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseStatus) setDefaults() interface{} {
	return &struct {
		Status         types.EServerInstanceStatus `mapconv:"SettingsResponse.Status"`
		MariaDBStatus  string                      `mapconv:"SettingsResponse.DBConf.MariaDB.Status"`
		PostgresStatus string                      `mapconv:"SettingsResponse.DBConf.Postgres.Status"`
		IsFatal        bool                        `mapconv:"SettingsResponse.IsFatal"`
		Version        *DatabaseVersionInfo        `mapconv:"SettingsResponse.DBConf.Version,recursive"`
		Logs           []*DatabaseLog              `mapconv:"SettingsResponse.DBConf.[]Log,recursive"`
		Backups        []*DatabaseBackupHistory    `mapconv:"SettingsResponse.DBConf.Backup.[]History,recursive"`
	}{
		Status:         o.GetStatus(),
		MariaDBStatus:  o.GetMariaDBStatus(),
		PostgresStatus: o.GetPostgresStatus(),
		IsFatal:        o.GetIsFatal(),
		Version:        o.GetVersion(),
		Logs:           o.GetLogs(),
		Backups:        o.GetBackups(),
	}
}

// GetStatus returns value of Status
func (o *DatabaseStatus) GetStatus() types.EServerInstanceStatus {
	return o.Status
}

// SetStatus sets value to Status
func (o *DatabaseStatus) SetStatus(v types.EServerInstanceStatus) {
	o.Status = v
}

// GetMariaDBStatus returns value of MariaDBStatus
func (o *DatabaseStatus) GetMariaDBStatus() string {
	return o.MariaDBStatus
}

// SetMariaDBStatus sets value to MariaDBStatus
func (o *DatabaseStatus) SetMariaDBStatus(v string) {
	o.MariaDBStatus = v
}

// GetPostgresStatus returns value of PostgresStatus
func (o *DatabaseStatus) GetPostgresStatus() string {
	return o.PostgresStatus
}

// SetPostgresStatus sets value to PostgresStatus
func (o *DatabaseStatus) SetPostgresStatus(v string) {
	o.PostgresStatus = v
}

// GetIsFatal returns value of IsFatal
func (o *DatabaseStatus) GetIsFatal() bool {
	return o.IsFatal
}

// SetIsFatal sets value to IsFatal
func (o *DatabaseStatus) SetIsFatal(v bool) {
	o.IsFatal = v
}

// GetVersion returns value of Version
func (o *DatabaseStatus) GetVersion() *DatabaseVersionInfo {
	return o.Version
}

// SetVersion sets value to Version
func (o *DatabaseStatus) SetVersion(v *DatabaseVersionInfo) {
	o.Version = v
}

// GetLogs returns value of Logs
func (o *DatabaseStatus) GetLogs() []*DatabaseLog {
	return o.Logs
}

// SetLogs sets value to Logs
func (o *DatabaseStatus) SetLogs(v []*DatabaseLog) {
	o.Logs = v
}

// GetBackups returns value of Backups
func (o *DatabaseStatus) GetBackups() []*DatabaseBackupHistory {
	return o.Backups
}

// SetBackups sets value to Backups
func (o *DatabaseStatus) SetBackups(v []*DatabaseBackupHistory) {
	o.Backups = v
}

/*************************************************
* DatabaseVersionInfo
*************************************************/

// DatabaseVersionInfo represents API parameter/response structure
type DatabaseVersionInfo struct {
	LastModified string
	CommitHash   string
	Status       string
	Tag          string
	Expire       string
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseVersionInfo) setDefaults() interface{} {
	return &struct {
		LastModified string
		CommitHash   string
		Status       string
		Tag          string
		Expire       string
	}{
		LastModified: o.GetLastModified(),
		CommitHash:   o.GetCommitHash(),
		Status:       o.GetStatus(),
		Tag:          o.GetTag(),
		Expire:       o.GetExpire(),
	}
}

// GetLastModified returns value of LastModified
func (o *DatabaseVersionInfo) GetLastModified() string {
	return o.LastModified
}

// SetLastModified sets value to LastModified
func (o *DatabaseVersionInfo) SetLastModified(v string) {
	o.LastModified = v
}

// GetCommitHash returns value of CommitHash
func (o *DatabaseVersionInfo) GetCommitHash() string {
	return o.CommitHash
}

// SetCommitHash sets value to CommitHash
func (o *DatabaseVersionInfo) SetCommitHash(v string) {
	o.CommitHash = v
}

// GetStatus returns value of Status
func (o *DatabaseVersionInfo) GetStatus() string {
	return o.Status
}

// SetStatus sets value to Status
func (o *DatabaseVersionInfo) SetStatus(v string) {
	o.Status = v
}

// GetTag returns value of Tag
func (o *DatabaseVersionInfo) GetTag() string {
	return o.Tag
}

// SetTag sets value to Tag
func (o *DatabaseVersionInfo) SetTag(v string) {
	o.Tag = v
}

// GetExpire returns value of Expire
func (o *DatabaseVersionInfo) GetExpire() string {
	return o.Expire
}

// SetExpire sets value to Expire
func (o *DatabaseVersionInfo) SetExpire(v string) {
	o.Expire = v
}

/*************************************************
* DatabaseLog
*************************************************/

// DatabaseLog represents API parameter/response structure
type DatabaseLog struct {
	Name string
	Data string
	Size types.StringNumber
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseLog) setDefaults() interface{} {
	return &struct {
		Name string
		Data string
		Size types.StringNumber
	}{
		Name: o.GetName(),
		Data: o.GetData(),
		Size: o.GetSize(),
	}
}

// GetName returns value of Name
func (o *DatabaseLog) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DatabaseLog) SetName(v string) {
	o.Name = v
}

// GetData returns value of Data
func (o *DatabaseLog) GetData() string {
	return o.Data
}

// SetData sets value to Data
func (o *DatabaseLog) SetData(v string) {
	o.Data = v
}

// GetSize returns value of Size
func (o *DatabaseLog) GetSize() types.StringNumber {
	return o.Size
}

// SetSize sets value to Size
func (o *DatabaseLog) SetSize(v types.StringNumber) {
	o.Size = v
}

/*************************************************
* DatabaseBackupHistory
*************************************************/

// DatabaseBackupHistory represents API parameter/response structure
type DatabaseBackupHistory struct {
	CreatedAt    time.Time
	Availability string
	RecoveredAt  time.Time
	Size         int64
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseBackupHistory) setDefaults() interface{} {
	return &struct {
		CreatedAt    time.Time
		Availability string
		RecoveredAt  time.Time
		Size         int64
	}{
		CreatedAt:    o.GetCreatedAt(),
		Availability: o.GetAvailability(),
		RecoveredAt:  o.GetRecoveredAt(),
		Size:         o.GetSize(),
	}
}

// GetCreatedAt returns value of CreatedAt
func (o *DatabaseBackupHistory) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *DatabaseBackupHistory) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetAvailability returns value of Availability
func (o *DatabaseBackupHistory) GetAvailability() string {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *DatabaseBackupHistory) SetAvailability(v string) {
	o.Availability = v
}

// GetRecoveredAt returns value of RecoveredAt
func (o *DatabaseBackupHistory) GetRecoveredAt() time.Time {
	return o.RecoveredAt
}

// SetRecoveredAt sets value to RecoveredAt
func (o *DatabaseBackupHistory) SetRecoveredAt(v time.Time) {
	o.RecoveredAt = v
}

// GetSize returns value of Size
func (o *DatabaseBackupHistory) GetSize() int64 {
	return o.Size
}

// SetSize sets value to Size
func (o *DatabaseBackupHistory) SetSize(v int64) {
	o.Size = v
}

/*************************************************
* DatabaseParameter
*************************************************/

// DatabaseParameter represents API parameter/response structure
type DatabaseParameter struct {
	Settings map[string]interface{}   `mapconv:"Parameter.Attr"`
	MetaInfo []*DatabaseParameterMeta `mapconv:"Remark.[]Form,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseParameter) setDefaults() interface{} {
	return &struct {
		Settings map[string]interface{}   `mapconv:"Parameter.Attr"`
		MetaInfo []*DatabaseParameterMeta `mapconv:"Remark.[]Form,recursive"`
	}{
		Settings: o.GetSettings(),
		MetaInfo: o.GetMetaInfo(),
	}
}

// GetSettings returns value of Settings
func (o *DatabaseParameter) GetSettings() map[string]interface{} {
	return o.Settings
}

// SetSettings sets value to Settings
func (o *DatabaseParameter) SetSettings(v map[string]interface{}) {
	o.Settings = v
}

// GetMetaInfo returns value of MetaInfo
func (o *DatabaseParameter) GetMetaInfo() []*DatabaseParameterMeta {
	return o.MetaInfo
}

// SetMetaInfo sets value to MetaInfo
func (o *DatabaseParameter) SetMetaInfo(v []*DatabaseParameterMeta) {
	o.MetaInfo = v
}

/*************************************************
* DatabaseParameterMeta
*************************************************/

// DatabaseParameterMeta represents API parameter/response structure
type DatabaseParameterMeta struct {
	Type    string `mapconv:"Options.Type"`
	Name    string
	Label   string
	Text    string  `mapconv:"Options.Text"`
	Example string  `mapconv:"Options.Example"`
	Min     float64 `mapconv:"Options.Min"`
	Max     float64 `mapconv:"Options.Max"`
	MaxLen  int     `mapconv:"Options.MaxLen"`
	Reboot  string  `mapconv:"Options.Reboot"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DatabaseParameterMeta) setDefaults() interface{} {
	return &struct {
		Type    string `mapconv:"Options.Type"`
		Name    string
		Label   string
		Text    string  `mapconv:"Options.Text"`
		Example string  `mapconv:"Options.Example"`
		Min     float64 `mapconv:"Options.Min"`
		Max     float64 `mapconv:"Options.Max"`
		MaxLen  int     `mapconv:"Options.MaxLen"`
		Reboot  string  `mapconv:"Options.Reboot"`
	}{
		Type:    o.GetType(),
		Name:    o.GetName(),
		Label:   o.GetLabel(),
		Text:    o.GetText(),
		Example: o.GetExample(),
		Min:     o.GetMin(),
		Max:     o.GetMax(),
		MaxLen:  o.GetMaxLen(),
		Reboot:  o.GetReboot(),
	}
}

// GetType returns value of Type
func (o *DatabaseParameterMeta) GetType() string {
	return o.Type
}

// SetType sets value to Type
func (o *DatabaseParameterMeta) SetType(v string) {
	o.Type = v
}

// GetName returns value of Name
func (o *DatabaseParameterMeta) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DatabaseParameterMeta) SetName(v string) {
	o.Name = v
}

// GetLabel returns value of Label
func (o *DatabaseParameterMeta) GetLabel() string {
	return o.Label
}

// SetLabel sets value to Label
func (o *DatabaseParameterMeta) SetLabel(v string) {
	o.Label = v
}

// GetText returns value of Text
func (o *DatabaseParameterMeta) GetText() string {
	return o.Text
}

// SetText sets value to Text
func (o *DatabaseParameterMeta) SetText(v string) {
	o.Text = v
}

// GetExample returns value of Example
func (o *DatabaseParameterMeta) GetExample() string {
	return o.Example
}

// SetExample sets value to Example
func (o *DatabaseParameterMeta) SetExample(v string) {
	o.Example = v
}

// GetMin returns value of Min
func (o *DatabaseParameterMeta) GetMin() float64 {
	return o.Min
}

// SetMin sets value to Min
func (o *DatabaseParameterMeta) SetMin(v float64) {
	o.Min = v
}

// GetMax returns value of Max
func (o *DatabaseParameterMeta) GetMax() float64 {
	return o.Max
}

// SetMax sets value to Max
func (o *DatabaseParameterMeta) SetMax(v float64) {
	o.Max = v
}

// GetMaxLen returns value of MaxLen
func (o *DatabaseParameterMeta) GetMaxLen() int {
	return o.MaxLen
}

// SetMaxLen sets value to MaxLen
func (o *DatabaseParameterMeta) SetMaxLen(v int) {
	o.MaxLen = v
}

// GetReboot returns value of Reboot
func (o *DatabaseParameterMeta) GetReboot() string {
	return o.Reboot
}

// SetReboot sets value to Reboot
func (o *DatabaseParameterMeta) SetReboot(v string) {
	o.Reboot = v
}

/*************************************************
* Disk
*************************************************/

// Disk represents API parameter/response structure
type Disk struct {
	ID                        types.ID
	Name                      string
	Description               string
	Tags                      types.Tags
	Availability              types.EAvailability
	Connection                types.EDiskConnection `json:",omitempty" mapconv:",omitempty"`
	ConnectionOrder           int
	EncryptionAlgorithm       types.EDiskEncryptionAlgorithm `json:",omitempty" mapconv:",omitempty"`
	KMSKeyID                  types.ID                       `mapconv:"EncryptionKey.KMSKeyID"`
	ReinstallCount            int
	JobStatus                 *JobStatus
	SizeMB                    int
	MigratedMB                int
	DiskPlanID                types.ID            `mapconv:"Plan.ID"`
	DiskPlanName              string              `mapconv:"Plan.Name"`
	DiskPlanStorageClass      string              `mapconv:"Plan.StorageClass"`
	SourceDiskID              types.ID            `mapconv:"SourceDisk.ID,omitempty"`
	SourceDiskAvailability    types.EAvailability `mapconv:"SourceDisk.Availability,omitempty"`
	SourceArchiveID           types.ID            `mapconv:"SourceArchive.ID,omitempty"`
	SourceArchiveAvailability types.EAvailability `mapconv:"SourceArchive.Availability,omitempty"`
	BundleInfo                *BundleInfo         `json:",omitempty" mapconv:",omitempty,recursive"`
	Storage                   *Storage            `json:",omitempty" mapconv:",omitempty,recursive"`
	ServerID                  types.ID            `mapconv:"Server.ID,omitempty"`
	ServerName                string              `mapconv:"Server.Name,omitempty"`
	IconID                    types.ID            `mapconv:"Icon.ID"`
	CreatedAt                 time.Time
	ModifiedAt                time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *Disk) setDefaults() interface{} {
	return &struct {
		ID                        types.ID
		Name                      string
		Description               string
		Tags                      types.Tags
		Availability              types.EAvailability
		Connection                types.EDiskConnection `json:",omitempty" mapconv:",omitempty"`
		ConnectionOrder           int
		EncryptionAlgorithm       types.EDiskEncryptionAlgorithm `json:",omitempty" mapconv:",omitempty"`
		KMSKeyID                  types.ID                       `mapconv:"EncryptionKey.KMSKeyID"`
		ReinstallCount            int
		JobStatus                 *JobStatus
		SizeMB                    int
		MigratedMB                int
		DiskPlanID                types.ID            `mapconv:"Plan.ID"`
		DiskPlanName              string              `mapconv:"Plan.Name"`
		DiskPlanStorageClass      string              `mapconv:"Plan.StorageClass"`
		SourceDiskID              types.ID            `mapconv:"SourceDisk.ID,omitempty"`
		SourceDiskAvailability    types.EAvailability `mapconv:"SourceDisk.Availability,omitempty"`
		SourceArchiveID           types.ID            `mapconv:"SourceArchive.ID,omitempty"`
		SourceArchiveAvailability types.EAvailability `mapconv:"SourceArchive.Availability,omitempty"`
		BundleInfo                *BundleInfo         `json:",omitempty" mapconv:",omitempty,recursive"`
		Storage                   *Storage            `json:",omitempty" mapconv:",omitempty,recursive"`
		ServerID                  types.ID            `mapconv:"Server.ID,omitempty"`
		ServerName                string              `mapconv:"Server.Name,omitempty"`
		IconID                    types.ID            `mapconv:"Icon.ID"`
		CreatedAt                 time.Time
		ModifiedAt                time.Time
	}{
		ID:                        o.GetID(),
		Name:                      o.GetName(),
		Description:               o.GetDescription(),
		Tags:                      o.GetTags(),
		Availability:              o.GetAvailability(),
		Connection:                o.GetConnection(),
		ConnectionOrder:           o.GetConnectionOrder(),
		EncryptionAlgorithm:       o.GetEncryptionAlgorithm(),
		KMSKeyID:                  o.GetKMSKeyID(),
		ReinstallCount:            o.GetReinstallCount(),
		JobStatus:                 o.GetJobStatus(),
		SizeMB:                    o.GetSizeMB(),
		MigratedMB:                o.GetMigratedMB(),
		DiskPlanID:                o.GetDiskPlanID(),
		DiskPlanName:              o.GetDiskPlanName(),
		DiskPlanStorageClass:      o.GetDiskPlanStorageClass(),
		SourceDiskID:              o.GetSourceDiskID(),
		SourceDiskAvailability:    o.GetSourceDiskAvailability(),
		SourceArchiveID:           o.GetSourceArchiveID(),
		SourceArchiveAvailability: o.GetSourceArchiveAvailability(),
		BundleInfo:                o.GetBundleInfo(),
		Storage:                   o.GetStorage(),
		ServerID:                  o.GetServerID(),
		ServerName:                o.GetServerName(),
		IconID:                    o.GetIconID(),
		CreatedAt:                 o.GetCreatedAt(),
		ModifiedAt:                o.GetModifiedAt(),
	}
}

// GetID returns value of ID
func (o *Disk) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Disk) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Disk) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Disk) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Disk) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Disk) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Disk) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Disk) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Disk) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Disk) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *Disk) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *Disk) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *Disk) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *Disk) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *Disk) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *Disk) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *Disk) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *Disk) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetConnection returns value of Connection
func (o *Disk) GetConnection() types.EDiskConnection {
	return o.Connection
}

// SetConnection sets value to Connection
func (o *Disk) SetConnection(v types.EDiskConnection) {
	o.Connection = v
}

// GetConnectionOrder returns value of ConnectionOrder
func (o *Disk) GetConnectionOrder() int {
	return o.ConnectionOrder
}

// SetConnectionOrder sets value to ConnectionOrder
func (o *Disk) SetConnectionOrder(v int) {
	o.ConnectionOrder = v
}

// GetEncryptionAlgorithm returns value of EncryptionAlgorithm
func (o *Disk) GetEncryptionAlgorithm() types.EDiskEncryptionAlgorithm {
	return o.EncryptionAlgorithm
}

// SetEncryptionAlgorithm sets value to EncryptionAlgorithm
func (o *Disk) SetEncryptionAlgorithm(v types.EDiskEncryptionAlgorithm) {
	o.EncryptionAlgorithm = v
}

// GetKMSKeyID returns value of KMSKeyID
func (o *Disk) GetKMSKeyID() types.ID {
	return o.KMSKeyID
}

// SetKMSKeyID sets value to KMSKeyID
func (o *Disk) SetKMSKeyID(v types.ID) {
	o.KMSKeyID = v
}

// GetReinstallCount returns value of ReinstallCount
func (o *Disk) GetReinstallCount() int {
	return o.ReinstallCount
}

// SetReinstallCount sets value to ReinstallCount
func (o *Disk) SetReinstallCount(v int) {
	o.ReinstallCount = v
}

// GetJobStatus returns value of JobStatus
func (o *Disk) GetJobStatus() *JobStatus {
	return o.JobStatus
}

// SetJobStatus sets value to JobStatus
func (o *Disk) SetJobStatus(v *JobStatus) {
	o.JobStatus = v
}

// GetSizeMB returns value of SizeMB
func (o *Disk) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *Disk) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *Disk) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *Disk) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

// GetMigratedMB returns value of MigratedMB
func (o *Disk) GetMigratedMB() int {
	return o.MigratedMB
}

// SetMigratedMB sets value to MigratedMB
func (o *Disk) SetMigratedMB(v int) {
	o.MigratedMB = v
}

// GetMigratedGB .
func (o *Disk) GetMigratedGB() int {
	return accessor.GetMigratedGB(o)
}

// GetDiskPlanID returns value of DiskPlanID
func (o *Disk) GetDiskPlanID() types.ID {
	return o.DiskPlanID
}

// SetDiskPlanID sets value to DiskPlanID
func (o *Disk) SetDiskPlanID(v types.ID) {
	o.DiskPlanID = v
}

// GetDiskPlanName returns value of DiskPlanName
func (o *Disk) GetDiskPlanName() string {
	return o.DiskPlanName
}

// SetDiskPlanName sets value to DiskPlanName
func (o *Disk) SetDiskPlanName(v string) {
	o.DiskPlanName = v
}

// GetDiskPlanStorageClass returns value of DiskPlanStorageClass
func (o *Disk) GetDiskPlanStorageClass() string {
	return o.DiskPlanStorageClass
}

// SetDiskPlanStorageClass sets value to DiskPlanStorageClass
func (o *Disk) SetDiskPlanStorageClass(v string) {
	o.DiskPlanStorageClass = v
}

// GetSourceDiskID returns value of SourceDiskID
func (o *Disk) GetSourceDiskID() types.ID {
	return o.SourceDiskID
}

// SetSourceDiskID sets value to SourceDiskID
func (o *Disk) SetSourceDiskID(v types.ID) {
	o.SourceDiskID = v
}

// GetSourceDiskAvailability returns value of SourceDiskAvailability
func (o *Disk) GetSourceDiskAvailability() types.EAvailability {
	return o.SourceDiskAvailability
}

// SetSourceDiskAvailability sets value to SourceDiskAvailability
func (o *Disk) SetSourceDiskAvailability(v types.EAvailability) {
	o.SourceDiskAvailability = v
}

// GetSourceArchiveID returns value of SourceArchiveID
func (o *Disk) GetSourceArchiveID() types.ID {
	return o.SourceArchiveID
}

// SetSourceArchiveID sets value to SourceArchiveID
func (o *Disk) SetSourceArchiveID(v types.ID) {
	o.SourceArchiveID = v
}

// GetSourceArchiveAvailability returns value of SourceArchiveAvailability
func (o *Disk) GetSourceArchiveAvailability() types.EAvailability {
	return o.SourceArchiveAvailability
}

// SetSourceArchiveAvailability sets value to SourceArchiveAvailability
func (o *Disk) SetSourceArchiveAvailability(v types.EAvailability) {
	o.SourceArchiveAvailability = v
}

// GetBundleInfo returns value of BundleInfo
func (o *Disk) GetBundleInfo() *BundleInfo {
	return o.BundleInfo
}

// SetBundleInfo sets value to BundleInfo
func (o *Disk) SetBundleInfo(v *BundleInfo) {
	o.BundleInfo = v
}

// GetStorage returns value of Storage
func (o *Disk) GetStorage() *Storage {
	return o.Storage
}

// SetStorage sets value to Storage
func (o *Disk) SetStorage(v *Storage) {
	o.Storage = v
}

// GetServerID returns value of ServerID
func (o *Disk) GetServerID() types.ID {
	return o.ServerID
}

// SetServerID sets value to ServerID
func (o *Disk) SetServerID(v types.ID) {
	o.ServerID = v
}

// GetServerName returns value of ServerName
func (o *Disk) GetServerName() string {
	return o.ServerName
}

// SetServerName sets value to ServerName
func (o *Disk) SetServerName(v string) {
	o.ServerName = v
}

// GetIconID returns value of IconID
func (o *Disk) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *Disk) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Disk) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Disk) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *Disk) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *Disk) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* JobStatus
*************************************************/

// JobStatus represents API parameter/response structure
type JobStatus struct {
	Status      string
	ConfigError *JobConfigError
}

// setDefaults implements iaas.argumentDefaulter
func (o *JobStatus) setDefaults() interface{} {
	return &struct {
		Status      string
		ConfigError *JobConfigError
	}{
		Status:      o.GetStatus(),
		ConfigError: o.GetConfigError(),
	}
}

// GetStatus returns value of Status
func (o *JobStatus) GetStatus() string {
	return o.Status
}

// SetStatus sets value to Status
func (o *JobStatus) SetStatus(v string) {
	o.Status = v
}

// GetConfigError returns value of ConfigError
func (o *JobStatus) GetConfigError() *JobConfigError {
	return o.ConfigError
}

// SetConfigError sets value to ConfigError
func (o *JobStatus) SetConfigError(v *JobConfigError) {
	o.ConfigError = v
}

/*************************************************
* JobConfigError
*************************************************/

// JobConfigError represents API parameter/response structure
type JobConfigError struct {
	ErrorCode string
	ErrorMsg  string
	Status    string
}

// setDefaults implements iaas.argumentDefaulter
func (o *JobConfigError) setDefaults() interface{} {
	return &struct {
		ErrorCode string
		ErrorMsg  string
		Status    string
	}{
		ErrorCode: o.GetErrorCode(),
		ErrorMsg:  o.GetErrorMsg(),
		Status:    o.GetStatus(),
	}
}

// GetErrorCode returns value of ErrorCode
func (o *JobConfigError) GetErrorCode() string {
	return o.ErrorCode
}

// SetErrorCode sets value to ErrorCode
func (o *JobConfigError) SetErrorCode(v string) {
	o.ErrorCode = v
}

// GetErrorMsg returns value of ErrorMsg
func (o *JobConfigError) GetErrorMsg() string {
	return o.ErrorMsg
}

// SetErrorMsg sets value to ErrorMsg
func (o *JobConfigError) SetErrorMsg(v string) {
	o.ErrorMsg = v
}

// GetStatus returns value of Status
func (o *JobConfigError) GetStatus() string {
	return o.Status
}

// SetStatus sets value to Status
func (o *JobConfigError) SetStatus(v string) {
	o.Status = v
}

/*************************************************
* DiskCreateRequest
*************************************************/

// DiskCreateRequest represents API parameter/response structure
type DiskCreateRequest struct {
	DiskPlanID          types.ID                       `mapconv:"Plan.ID"`
	Connection          types.EDiskConnection          `json:",omitempty" mapconv:",omitempty"`
	EncryptionAlgorithm types.EDiskEncryptionAlgorithm `json:",omitempty" mapconv:",omitempty"`
	SourceDiskID        types.ID                       `mapconv:"SourceDisk.ID,omitempty"`
	SourceArchiveID     types.ID                       `mapconv:"SourceArchive.ID,omitempty"`
	ServerID            types.ID                       `mapconv:"Server.ID,omitempty"`
	SizeMB              int
	Name                string
	Description         string
	Tags                types.Tags
	IconID              types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskCreateRequest) setDefaults() interface{} {
	return &struct {
		DiskPlanID          types.ID                       `mapconv:"Plan.ID"`
		Connection          types.EDiskConnection          `json:",omitempty" mapconv:",omitempty"`
		EncryptionAlgorithm types.EDiskEncryptionAlgorithm `json:",omitempty" mapconv:",omitempty"`
		SourceDiskID        types.ID                       `mapconv:"SourceDisk.ID,omitempty"`
		SourceArchiveID     types.ID                       `mapconv:"SourceArchive.ID,omitempty"`
		ServerID            types.ID                       `mapconv:"Server.ID,omitempty"`
		SizeMB              int
		Name                string
		Description         string
		Tags                types.Tags
		IconID              types.ID `mapconv:"Icon.ID"`
	}{
		DiskPlanID:          o.GetDiskPlanID(),
		Connection:          o.GetConnection(),
		EncryptionAlgorithm: o.GetEncryptionAlgorithm(),
		SourceDiskID:        o.GetSourceDiskID(),
		SourceArchiveID:     o.GetSourceArchiveID(),
		ServerID:            o.GetServerID(),
		SizeMB:              o.GetSizeMB(),
		Name:                o.GetName(),
		Description:         o.GetDescription(),
		Tags:                o.GetTags(),
		IconID:              o.GetIconID(),
	}
}

// GetDiskPlanID returns value of DiskPlanID
func (o *DiskCreateRequest) GetDiskPlanID() types.ID {
	return o.DiskPlanID
}

// SetDiskPlanID sets value to DiskPlanID
func (o *DiskCreateRequest) SetDiskPlanID(v types.ID) {
	o.DiskPlanID = v
}

// GetConnection returns value of Connection
func (o *DiskCreateRequest) GetConnection() types.EDiskConnection {
	return o.Connection
}

// SetConnection sets value to Connection
func (o *DiskCreateRequest) SetConnection(v types.EDiskConnection) {
	o.Connection = v
}

// GetEncryptionAlgorithm returns value of EncryptionAlgorithm
func (o *DiskCreateRequest) GetEncryptionAlgorithm() types.EDiskEncryptionAlgorithm {
	return o.EncryptionAlgorithm
}

// SetEncryptionAlgorithm sets value to EncryptionAlgorithm
func (o *DiskCreateRequest) SetEncryptionAlgorithm(v types.EDiskEncryptionAlgorithm) {
	o.EncryptionAlgorithm = v
}

// GetSourceDiskID returns value of SourceDiskID
func (o *DiskCreateRequest) GetSourceDiskID() types.ID {
	return o.SourceDiskID
}

// SetSourceDiskID sets value to SourceDiskID
func (o *DiskCreateRequest) SetSourceDiskID(v types.ID) {
	o.SourceDiskID = v
}

// GetSourceArchiveID returns value of SourceArchiveID
func (o *DiskCreateRequest) GetSourceArchiveID() types.ID {
	return o.SourceArchiveID
}

// SetSourceArchiveID sets value to SourceArchiveID
func (o *DiskCreateRequest) SetSourceArchiveID(v types.ID) {
	o.SourceArchiveID = v
}

// GetServerID returns value of ServerID
func (o *DiskCreateRequest) GetServerID() types.ID {
	return o.ServerID
}

// SetServerID sets value to ServerID
func (o *DiskCreateRequest) SetServerID(v types.ID) {
	o.ServerID = v
}

// GetSizeMB returns value of SizeMB
func (o *DiskCreateRequest) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *DiskCreateRequest) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *DiskCreateRequest) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *DiskCreateRequest) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

// GetName returns value of Name
func (o *DiskCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DiskCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *DiskCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *DiskCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *DiskCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *DiskCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *DiskCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *DiskCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *DiskCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *DiskCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *DiskCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *DiskCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* DiskEditRequest
*************************************************/

// DiskEditRequest represents API parameter/response structure
type DiskEditRequest struct {
	Background          bool                `json:",omitempty" mapconv:",omitempty"`
	Password            string              `json:",omitempty" mapconv:",omitempty"`
	SSHKey              *DiskEditSSHKey     `json:",omitempty" mapconv:",omitempty,recursive"`
	SSHKeys             []*DiskEditSSHKey   `json:",omitempty" mapconv:"[]SSHKeys,omitempty,recursive"`
	DisablePWAuth       bool                `json:",omitempty" mapconv:",omitempty"`
	EnableDHCP          bool                `json:",omitempty" mapconv:",omitempty"`
	ChangePartitionUUID bool                `json:",omitempty" mapconv:",omitempty"`
	HostName            string              `json:",omitempty" mapconv:",omitempty"`
	Notes               []*DiskEditNote     `json:",omitempty" mapconv:"[]Notes,omitempty,recursive"`
	UserIPAddress       string              `json:",omitempty" mapconv:",omitempty"`
	UserSubnet          *DiskEditUserSubnet `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskEditRequest) setDefaults() interface{} {
	return &struct {
		Background          bool                `json:",omitempty" mapconv:",omitempty"`
		Password            string              `json:",omitempty" mapconv:",omitempty"`
		SSHKey              *DiskEditSSHKey     `json:",omitempty" mapconv:",omitempty,recursive"`
		SSHKeys             []*DiskEditSSHKey   `json:",omitempty" mapconv:"[]SSHKeys,omitempty,recursive"`
		DisablePWAuth       bool                `json:",omitempty" mapconv:",omitempty"`
		EnableDHCP          bool                `json:",omitempty" mapconv:",omitempty"`
		ChangePartitionUUID bool                `json:",omitempty" mapconv:",omitempty"`
		HostName            string              `json:",omitempty" mapconv:",omitempty"`
		Notes               []*DiskEditNote     `json:",omitempty" mapconv:"[]Notes,omitempty,recursive"`
		UserIPAddress       string              `json:",omitempty" mapconv:",omitempty"`
		UserSubnet          *DiskEditUserSubnet `json:",omitempty" mapconv:",omitempty"`
	}{
		Background:          o.GetBackground(),
		Password:            o.GetPassword(),
		SSHKey:              o.GetSSHKey(),
		SSHKeys:             o.GetSSHKeys(),
		DisablePWAuth:       o.GetDisablePWAuth(),
		EnableDHCP:          o.GetEnableDHCP(),
		ChangePartitionUUID: o.GetChangePartitionUUID(),
		HostName:            o.GetHostName(),
		Notes:               o.GetNotes(),
		UserIPAddress:       o.GetUserIPAddress(),
		UserSubnet:          o.GetUserSubnet(),
	}
}

// GetBackground returns value of Background
func (o *DiskEditRequest) GetBackground() bool {
	return o.Background
}

// SetBackground sets value to Background
func (o *DiskEditRequest) SetBackground(v bool) {
	o.Background = v
}

// GetPassword returns value of Password
func (o *DiskEditRequest) GetPassword() string {
	return o.Password
}

// SetPassword sets value to Password
func (o *DiskEditRequest) SetPassword(v string) {
	o.Password = v
}

// GetSSHKey returns value of SSHKey
func (o *DiskEditRequest) GetSSHKey() *DiskEditSSHKey {
	return o.SSHKey
}

// SetSSHKey sets value to SSHKey
func (o *DiskEditRequest) SetSSHKey(v *DiskEditSSHKey) {
	o.SSHKey = v
}

// GetSSHKeys returns value of SSHKeys
func (o *DiskEditRequest) GetSSHKeys() []*DiskEditSSHKey {
	return o.SSHKeys
}

// SetSSHKeys sets value to SSHKeys
func (o *DiskEditRequest) SetSSHKeys(v []*DiskEditSSHKey) {
	o.SSHKeys = v
}

// GetDisablePWAuth returns value of DisablePWAuth
func (o *DiskEditRequest) GetDisablePWAuth() bool {
	return o.DisablePWAuth
}

// SetDisablePWAuth sets value to DisablePWAuth
func (o *DiskEditRequest) SetDisablePWAuth(v bool) {
	o.DisablePWAuth = v
}

// GetEnableDHCP returns value of EnableDHCP
func (o *DiskEditRequest) GetEnableDHCP() bool {
	return o.EnableDHCP
}

// SetEnableDHCP sets value to EnableDHCP
func (o *DiskEditRequest) SetEnableDHCP(v bool) {
	o.EnableDHCP = v
}

// GetChangePartitionUUID returns value of ChangePartitionUUID
func (o *DiskEditRequest) GetChangePartitionUUID() bool {
	return o.ChangePartitionUUID
}

// SetChangePartitionUUID sets value to ChangePartitionUUID
func (o *DiskEditRequest) SetChangePartitionUUID(v bool) {
	o.ChangePartitionUUID = v
}

// GetHostName returns value of HostName
func (o *DiskEditRequest) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *DiskEditRequest) SetHostName(v string) {
	o.HostName = v
}

// GetNotes returns value of Notes
func (o *DiskEditRequest) GetNotes() []*DiskEditNote {
	return o.Notes
}

// SetNotes sets value to Notes
func (o *DiskEditRequest) SetNotes(v []*DiskEditNote) {
	o.Notes = v
}

// GetUserIPAddress returns value of UserIPAddress
func (o *DiskEditRequest) GetUserIPAddress() string {
	return o.UserIPAddress
}

// SetUserIPAddress sets value to UserIPAddress
func (o *DiskEditRequest) SetUserIPAddress(v string) {
	o.UserIPAddress = v
}

// GetUserSubnet returns value of UserSubnet
func (o *DiskEditRequest) GetUserSubnet() *DiskEditUserSubnet {
	return o.UserSubnet
}

// SetUserSubnet sets value to UserSubnet
func (o *DiskEditRequest) SetUserSubnet(v *DiskEditUserSubnet) {
	o.UserSubnet = v
}

/*************************************************
* DiskEditSSHKey
*************************************************/

// DiskEditSSHKey represents API parameter/response structure
type DiskEditSSHKey struct {
	ID        types.ID `json:",omitempty" mapconv:",omitempty"`
	PublicKey string   `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskEditSSHKey) setDefaults() interface{} {
	return &struct {
		ID        types.ID `json:",omitempty" mapconv:",omitempty"`
		PublicKey string   `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:        o.GetID(),
		PublicKey: o.GetPublicKey(),
	}
}

// GetID returns value of ID
func (o *DiskEditSSHKey) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *DiskEditSSHKey) SetID(v types.ID) {
	o.ID = v
}

// GetPublicKey returns value of PublicKey
func (o *DiskEditSSHKey) GetPublicKey() string {
	return o.PublicKey
}

// SetPublicKey sets value to PublicKey
func (o *DiskEditSSHKey) SetPublicKey(v string) {
	o.PublicKey = v
}

/*************************************************
* DiskEditNote
*************************************************/

// DiskEditNote represents API parameter/response structure
type DiskEditNote struct {
	ID        types.ID               `json:",omitempty" mapconv:",omitempty"`
	APIKeyID  types.ID               `json:",omitempty" mapconv:"APIKey.ID,omitempty"`
	Variables map[string]interface{} `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskEditNote) setDefaults() interface{} {
	return &struct {
		ID        types.ID               `json:",omitempty" mapconv:",omitempty"`
		APIKeyID  types.ID               `json:",omitempty" mapconv:"APIKey.ID,omitempty"`
		Variables map[string]interface{} `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:        o.GetID(),
		APIKeyID:  o.GetAPIKeyID(),
		Variables: o.GetVariables(),
	}
}

// GetID returns value of ID
func (o *DiskEditNote) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *DiskEditNote) SetID(v types.ID) {
	o.ID = v
}

// GetAPIKeyID returns value of APIKeyID
func (o *DiskEditNote) GetAPIKeyID() types.ID {
	return o.APIKeyID
}

// SetAPIKeyID sets value to APIKeyID
func (o *DiskEditNote) SetAPIKeyID(v types.ID) {
	o.APIKeyID = v
}

// GetVariables returns value of Variables
func (o *DiskEditNote) GetVariables() map[string]interface{} {
	return o.Variables
}

// SetVariables sets value to Variables
func (o *DiskEditNote) SetVariables(v map[string]interface{}) {
	o.Variables = v
}

/*************************************************
* DiskEditUserSubnet
*************************************************/

// DiskEditUserSubnet represents API parameter/response structure
type DiskEditUserSubnet struct {
	DefaultRoute   string `json:",omitempty" mapconv:",omitempty"`
	NetworkMaskLen int    `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskEditUserSubnet) setDefaults() interface{} {
	return &struct {
		DefaultRoute   string `json:",omitempty" mapconv:",omitempty"`
		NetworkMaskLen int    `json:",omitempty" mapconv:",omitempty"`
	}{
		DefaultRoute:   o.GetDefaultRoute(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
	}
}

// GetDefaultRoute returns value of DefaultRoute
func (o *DiskEditUserSubnet) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *DiskEditUserSubnet) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *DiskEditUserSubnet) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *DiskEditUserSubnet) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

/*************************************************
* DiskResizePartitionRequest
*************************************************/

// DiskResizePartitionRequest represents API parameter/response structure
type DiskResizePartitionRequest struct {
	Background bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskResizePartitionRequest) setDefaults() interface{} {
	return &struct {
		Background bool
	}{
		Background: o.GetBackground(),
	}
}

// GetBackground returns value of Background
func (o *DiskResizePartitionRequest) GetBackground() bool {
	return o.Background
}

// SetBackground sets value to Background
func (o *DiskResizePartitionRequest) SetBackground(v bool) {
	o.Background = v
}

/*************************************************
* DiskUpdateRequest
*************************************************/

// DiskUpdateRequest represents API parameter/response structure
type DiskUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID              `mapconv:"Icon.ID"`
	Connection  types.EDiskConnection `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID              `mapconv:"Icon.ID"`
		Connection  types.EDiskConnection `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
		Connection:  o.GetConnection(),
	}
}

// GetName returns value of Name
func (o *DiskUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DiskUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *DiskUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *DiskUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *DiskUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *DiskUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *DiskUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *DiskUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *DiskUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *DiskUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *DiskUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *DiskUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetConnection returns value of Connection
func (o *DiskUpdateRequest) GetConnection() types.EDiskConnection {
	return o.Connection
}

// SetConnection sets value to Connection
func (o *DiskUpdateRequest) SetConnection(v types.EDiskConnection) {
	o.Connection = v
}

/*************************************************
* DiskPlan
*************************************************/

// DiskPlan represents API parameter/response structure
type DiskPlan struct {
	ID           types.ID
	Name         string
	StorageClass string
	Availability types.EAvailability
	Size         []*DiskPlanSizeInfo `mapconv:"[]Size,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskPlan) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		StorageClass string
		Availability types.EAvailability
		Size         []*DiskPlanSizeInfo `mapconv:"[]Size,recursive"`
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		StorageClass: o.GetStorageClass(),
		Availability: o.GetAvailability(),
		Size:         o.GetSize(),
	}
}

// GetID returns value of ID
func (o *DiskPlan) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *DiskPlan) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *DiskPlan) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *DiskPlan) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *DiskPlan) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *DiskPlan) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *DiskPlan) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DiskPlan) SetName(v string) {
	o.Name = v
}

// GetStorageClass returns value of StorageClass
func (o *DiskPlan) GetStorageClass() string {
	return o.StorageClass
}

// SetStorageClass sets value to StorageClass
func (o *DiskPlan) SetStorageClass(v string) {
	o.StorageClass = v
}

// GetAvailability returns value of Availability
func (o *DiskPlan) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *DiskPlan) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetSize returns value of Size
func (o *DiskPlan) GetSize() []*DiskPlanSizeInfo {
	return o.Size
}

// SetSize sets value to Size
func (o *DiskPlan) SetSize(v []*DiskPlanSizeInfo) {
	o.Size = v
}

/*************************************************
* DiskPlanSizeInfo
*************************************************/

// DiskPlanSizeInfo represents API parameter/response structure
type DiskPlanSizeInfo struct {
	Availability  types.EAvailability
	DisplaySize   int
	DisplaySuffix string
	SizeMB        int
}

// setDefaults implements iaas.argumentDefaulter
func (o *DiskPlanSizeInfo) setDefaults() interface{} {
	return &struct {
		Availability  types.EAvailability
		DisplaySize   int
		DisplaySuffix string
		SizeMB        int
	}{
		Availability:  o.GetAvailability(),
		DisplaySize:   o.GetDisplaySize(),
		DisplaySuffix: o.GetDisplaySuffix(),
		SizeMB:        o.GetSizeMB(),
	}
}

// GetAvailability returns value of Availability
func (o *DiskPlanSizeInfo) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *DiskPlanSizeInfo) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetDisplaySize returns value of DisplaySize
func (o *DiskPlanSizeInfo) GetDisplaySize() int {
	return o.DisplaySize
}

// SetDisplaySize sets value to DisplaySize
func (o *DiskPlanSizeInfo) SetDisplaySize(v int) {
	o.DisplaySize = v
}

// GetDisplaySuffix returns value of DisplaySuffix
func (o *DiskPlanSizeInfo) GetDisplaySuffix() string {
	return o.DisplaySuffix
}

// SetDisplaySuffix sets value to DisplaySuffix
func (o *DiskPlanSizeInfo) SetDisplaySuffix(v string) {
	o.DisplaySuffix = v
}

// GetSizeMB returns value of SizeMB
func (o *DiskPlanSizeInfo) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *DiskPlanSizeInfo) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *DiskPlanSizeInfo) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *DiskPlanSizeInfo) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

/*************************************************
* DNS
*************************************************/

// DNS represents API parameter/response structure
type DNS struct {
	ID                 types.ID
	Name               string
	Description        string
	Tags               types.Tags
	Availability       types.EAvailability
	IconID             types.ID `mapconv:"Icon.ID"`
	CreatedAt          time.Time
	ModifiedAt         time.Time
	Records            DNSRecords          `mapconv:"Settings.DNS.[]ResourceRecordSets,recursive"`
	MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.DNS.MonitoringSuiteLog,recursive"`
	SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
	DNSZone            string              `mapconv:"Status.Zone"`
	DNSNameServers     []string            `mapconv:"Status.NS"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DNS) setDefaults() interface{} {
	return &struct {
		ID                 types.ID
		Name               string
		Description        string
		Tags               types.Tags
		Availability       types.EAvailability
		IconID             types.ID `mapconv:"Icon.ID"`
		CreatedAt          time.Time
		ModifiedAt         time.Time
		Records            DNSRecords          `mapconv:"Settings.DNS.[]ResourceRecordSets,recursive"`
		MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.DNS.MonitoringSuiteLog,recursive"`
		SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
		DNSZone            string              `mapconv:"Status.Zone"`
		DNSNameServers     []string            `mapconv:"Status.NS"`
	}{
		ID:                 o.GetID(),
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		Availability:       o.GetAvailability(),
		IconID:             o.GetIconID(),
		CreatedAt:          o.GetCreatedAt(),
		ModifiedAt:         o.GetModifiedAt(),
		Records:            o.GetRecords(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		SettingsHash:       o.GetSettingsHash(),
		DNSZone:            o.GetDNSZone(),
		DNSNameServers:     o.GetDNSNameServers(),
	}
}

// GetID returns value of ID
func (o *DNS) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *DNS) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *DNS) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *DNS) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *DNS) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *DNS) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *DNS) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DNS) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *DNS) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *DNS) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *DNS) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *DNS) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *DNS) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *DNS) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *DNS) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *DNS) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *DNS) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *DNS) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *DNS) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *DNS) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *DNS) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *DNS) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *DNS) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *DNS) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetRecords returns value of Records
func (o *DNS) GetRecords() DNSRecords {
	return o.Records
}

// SetRecords sets value to Records
func (o *DNS) SetRecords(v DNSRecords) {
	o.Records = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *DNS) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *DNS) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetSettingsHash returns value of SettingsHash
func (o *DNS) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *DNS) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetDNSZone returns value of DNSZone
func (o *DNS) GetDNSZone() string {
	return o.DNSZone
}

// SetDNSZone sets value to DNSZone
func (o *DNS) SetDNSZone(v string) {
	o.DNSZone = v
}

// GetDNSNameServers returns value of DNSNameServers
func (o *DNS) GetDNSNameServers() []string {
	return o.DNSNameServers
}

// SetDNSNameServers sets value to DNSNameServers
func (o *DNS) SetDNSNameServers(v []string) {
	o.DNSNameServers = v
}

/*************************************************
* DNSRecord
*************************************************/

// DNSRecord represents API parameter/response structure
type DNSRecord struct {
	Name  string
	Type  types.EDNSRecordType
	RData string
	TTL   int
}

// setDefaults implements iaas.argumentDefaulter
func (o *DNSRecord) setDefaults() interface{} {
	return &struct {
		Name  string
		Type  types.EDNSRecordType
		RData string
		TTL   int
	}{
		Name:  o.GetName(),
		Type:  o.GetType(),
		RData: o.GetRData(),
		TTL:   o.GetTTL(),
	}
}

// GetName returns value of Name
func (o *DNSRecord) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DNSRecord) SetName(v string) {
	o.Name = v
}

// GetType returns value of Type
func (o *DNSRecord) GetType() types.EDNSRecordType {
	return o.Type
}

// SetType sets value to Type
func (o *DNSRecord) SetType(v types.EDNSRecordType) {
	o.Type = v
}

// GetRData returns value of RData
func (o *DNSRecord) GetRData() string {
	return o.RData
}

// SetRData sets value to RData
func (o *DNSRecord) SetRData(v string) {
	o.RData = v
}

// GetTTL returns value of TTL
func (o *DNSRecord) GetTTL() int {
	return o.TTL
}

// SetTTL sets value to TTL
func (o *DNSRecord) SetTTL(v int) {
	o.TTL = v
}

/*************************************************
* MonitoringSuiteLog
*************************************************/

// MonitoringSuiteLog represents API parameter/response structure
type MonitoringSuiteLog struct {
	Enabled bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitoringSuiteLog) setDefaults() interface{} {
	return &struct {
		Enabled bool
	}{
		Enabled: o.GetEnabled(),
	}
}

// GetEnabled returns value of Enabled
func (o *MonitoringSuiteLog) GetEnabled() bool {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *MonitoringSuiteLog) SetEnabled(v bool) {
	o.Enabled = v
}

/*************************************************
* DNSCreateRequest
*************************************************/

// DNSCreateRequest represents API parameter/response structure
type DNSCreateRequest struct {
	Name               string              `mapconv:"Name/Status.Zone"`
	Records            DNSRecords          `mapconv:"Settings.DNS.[]ResourceRecordSets,recursive"`
	MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.DNS.MonitoringSuiteLog,recursive"`
	Description        string
	Tags               types.Tags
	IconID             types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DNSCreateRequest) setDefaults() interface{} {
	return &struct {
		Name               string              `mapconv:"Name/Status.Zone"`
		Records            DNSRecords          `mapconv:"Settings.DNS.[]ResourceRecordSets,recursive"`
		MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.DNS.MonitoringSuiteLog,recursive"`
		Description        string
		Tags               types.Tags
		IconID             types.ID `mapconv:"Icon.ID"`
		Class              string   `mapconv:"Provider.Class"`
	}{
		Name:               o.GetName(),
		Records:            o.GetRecords(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		Class:              "dns",
	}
}

// GetName returns value of Name
func (o *DNSCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *DNSCreateRequest) SetName(v string) {
	o.Name = v
}

// GetRecords returns value of Records
func (o *DNSCreateRequest) GetRecords() DNSRecords {
	return o.Records
}

// SetRecords sets value to Records
func (o *DNSCreateRequest) SetRecords(v DNSRecords) {
	o.Records = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *DNSCreateRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *DNSCreateRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetDescription returns value of Description
func (o *DNSCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *DNSCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *DNSCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *DNSCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *DNSCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *DNSCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *DNSCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *DNSCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *DNSCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *DNSCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* DNSUpdateRequest
*************************************************/

// DNSUpdateRequest represents API parameter/response structure
type DNSUpdateRequest struct {
	Description        string
	Tags               types.Tags
	IconID             types.ID            `mapconv:"Icon.ID"`
	Records            DNSRecords          `mapconv:"Settings.DNS.[]ResourceRecordSets,recursive"`
	MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.DNS.MonitoringSuiteLog,recursive"`
	SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DNSUpdateRequest) setDefaults() interface{} {
	return &struct {
		Description        string
		Tags               types.Tags
		IconID             types.ID            `mapconv:"Icon.ID"`
		Records            DNSRecords          `mapconv:"Settings.DNS.[]ResourceRecordSets,recursive"`
		MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.DNS.MonitoringSuiteLog,recursive"`
		SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
	}{
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		Records:            o.GetRecords(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetDescription returns value of Description
func (o *DNSUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *DNSUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *DNSUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *DNSUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *DNSUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *DNSUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *DNSUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *DNSUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *DNSUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *DNSUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetRecords returns value of Records
func (o *DNSUpdateRequest) GetRecords() DNSRecords {
	return o.Records
}

// SetRecords sets value to Records
func (o *DNSUpdateRequest) SetRecords(v DNSRecords) {
	o.Records = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *DNSUpdateRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *DNSUpdateRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetSettingsHash returns value of SettingsHash
func (o *DNSUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *DNSUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* DNSUpdateSettingsRequest
*************************************************/

// DNSUpdateSettingsRequest represents API parameter/response structure
type DNSUpdateSettingsRequest struct {
	Records            DNSRecords          `mapconv:"Settings.DNS.[]ResourceRecordSets,recursive"`
	MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.DNS.MonitoringSuiteLog,recursive"`
	SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *DNSUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		Records            DNSRecords          `mapconv:"Settings.DNS.[]ResourceRecordSets,recursive"`
		MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.DNS.MonitoringSuiteLog,recursive"`
		SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
	}{
		Records:            o.GetRecords(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetRecords returns value of Records
func (o *DNSUpdateSettingsRequest) GetRecords() DNSRecords {
	return o.Records
}

// SetRecords sets value to Records
func (o *DNSUpdateSettingsRequest) SetRecords(v DNSRecords) {
	o.Records = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *DNSUpdateSettingsRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *DNSUpdateSettingsRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetSettingsHash returns value of SettingsHash
func (o *DNSUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *DNSUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* EnhancedDB
*************************************************/

// EnhancedDB represents API parameter/response structure
type EnhancedDB struct {
	ID           types.ID
	Name         string
	Description  string
	Tags         types.Tags
	Availability types.EAvailability
	IconID       types.ID `mapconv:"Icon.ID"`
	CreatedAt    time.Time
	ModifiedAt   time.Time
	SettingsHash string                 `json:",omitempty" mapconv:",omitempty"`
	DatabaseName string                 `mapconv:"Status.DatabaseName"`
	DatabaseType types.EnhancedDBType   `mapconv:"Status.DatabaseType"`
	Region       types.EnhancedDBRegion `mapconv:"Status.Region"`
	HostName     string                 `mapconv:"Status.HostName"`
	Port         int                    `mapconv:"Status.Port"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *EnhancedDB) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		Tags         types.Tags
		Availability types.EAvailability
		IconID       types.ID `mapconv:"Icon.ID"`
		CreatedAt    time.Time
		ModifiedAt   time.Time
		SettingsHash string                 `json:",omitempty" mapconv:",omitempty"`
		DatabaseName string                 `mapconv:"Status.DatabaseName"`
		DatabaseType types.EnhancedDBType   `mapconv:"Status.DatabaseType"`
		Region       types.EnhancedDBRegion `mapconv:"Status.Region"`
		HostName     string                 `mapconv:"Status.HostName"`
		Port         int                    `mapconv:"Status.Port"`
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		IconID:       o.GetIconID(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
		SettingsHash: o.GetSettingsHash(),
		DatabaseName: o.GetDatabaseName(),
		DatabaseType: o.GetDatabaseType(),
		Region:       o.GetRegion(),
		HostName:     o.GetHostName(),
		Port:         o.GetPort(),
	}
}

// GetID returns value of ID
func (o *EnhancedDB) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *EnhancedDB) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *EnhancedDB) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *EnhancedDB) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *EnhancedDB) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *EnhancedDB) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *EnhancedDB) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *EnhancedDB) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *EnhancedDB) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *EnhancedDB) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *EnhancedDB) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *EnhancedDB) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *EnhancedDB) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *EnhancedDB) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *EnhancedDB) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *EnhancedDB) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *EnhancedDB) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *EnhancedDB) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *EnhancedDB) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *EnhancedDB) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *EnhancedDB) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *EnhancedDB) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *EnhancedDB) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *EnhancedDB) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetSettingsHash returns value of SettingsHash
func (o *EnhancedDB) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *EnhancedDB) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetDatabaseName returns value of DatabaseName
func (o *EnhancedDB) GetDatabaseName() string {
	return o.DatabaseName
}

// SetDatabaseName sets value to DatabaseName
func (o *EnhancedDB) SetDatabaseName(v string) {
	o.DatabaseName = v
}

// GetDatabaseType returns value of DatabaseType
func (o *EnhancedDB) GetDatabaseType() types.EnhancedDBType {
	return o.DatabaseType
}

// SetDatabaseType sets value to DatabaseType
func (o *EnhancedDB) SetDatabaseType(v types.EnhancedDBType) {
	o.DatabaseType = v
}

// GetRegion returns value of Region
func (o *EnhancedDB) GetRegion() types.EnhancedDBRegion {
	return o.Region
}

// SetRegion sets value to Region
func (o *EnhancedDB) SetRegion(v types.EnhancedDBRegion) {
	o.Region = v
}

// GetHostName returns value of HostName
func (o *EnhancedDB) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *EnhancedDB) SetHostName(v string) {
	o.HostName = v
}

// GetPort returns value of Port
func (o *EnhancedDB) GetPort() int {
	return o.Port
}

// SetPort sets value to Port
func (o *EnhancedDB) SetPort(v int) {
	o.Port = v
}

/*************************************************
* EnhancedDBCreateRequest
*************************************************/

// EnhancedDBCreateRequest represents API parameter/response structure
type EnhancedDBCreateRequest struct {
	Name         string
	Description  string
	Tags         types.Tags
	IconID       types.ID               `mapconv:"Icon.ID"`
	DatabaseName string                 `mapconv:"Status.DatabaseName"`
	DatabaseType types.EnhancedDBType   `mapconv:"Status.DatabaseType"`
	Region       types.EnhancedDBRegion `mapconv:"Status.Region"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *EnhancedDBCreateRequest) setDefaults() interface{} {
	return &struct {
		Name            string
		Description     string
		Tags            types.Tags
		IconID          types.ID               `mapconv:"Icon.ID"`
		DatabaseName    string                 `mapconv:"Status.DatabaseName"`
		DatabaseType    types.EnhancedDBType   `mapconv:"Status.DatabaseType"`
		Region          types.EnhancedDBRegion `mapconv:"Status.Region"`
		Class           string                 `mapconv:"Provider.Class"`
		MaxConnections  int                    `mapconv:"Config.MaxConnections"`
		AllowedNetworks []string               `mapconv:"Config.AllowedNetworks"`
	}{
		Name:            o.GetName(),
		Description:     o.GetDescription(),
		Tags:            o.GetTags(),
		IconID:          o.GetIconID(),
		DatabaseName:    o.GetDatabaseName(),
		DatabaseType:    o.GetDatabaseType(),
		Region:          o.GetRegion(),
		Class:           "enhanceddb",
		MaxConnections:  50,
		AllowedNetworks: []string{},
	}
}

// GetName returns value of Name
func (o *EnhancedDBCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *EnhancedDBCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *EnhancedDBCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *EnhancedDBCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *EnhancedDBCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *EnhancedDBCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *EnhancedDBCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *EnhancedDBCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *EnhancedDBCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *EnhancedDBCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *EnhancedDBCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *EnhancedDBCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetDatabaseName returns value of DatabaseName
func (o *EnhancedDBCreateRequest) GetDatabaseName() string {
	return o.DatabaseName
}

// SetDatabaseName sets value to DatabaseName
func (o *EnhancedDBCreateRequest) SetDatabaseName(v string) {
	o.DatabaseName = v
}

// GetDatabaseType returns value of DatabaseType
func (o *EnhancedDBCreateRequest) GetDatabaseType() types.EnhancedDBType {
	return o.DatabaseType
}

// SetDatabaseType sets value to DatabaseType
func (o *EnhancedDBCreateRequest) SetDatabaseType(v types.EnhancedDBType) {
	o.DatabaseType = v
}

// GetRegion returns value of Region
func (o *EnhancedDBCreateRequest) GetRegion() types.EnhancedDBRegion {
	return o.Region
}

// SetRegion sets value to Region
func (o *EnhancedDBCreateRequest) SetRegion(v types.EnhancedDBRegion) {
	o.Region = v
}

/*************************************************
* EnhancedDBUpdateRequest
*************************************************/

// EnhancedDBUpdateRequest represents API parameter/response structure
type EnhancedDBUpdateRequest struct {
	Name         string
	Description  string
	Tags         types.Tags
	IconID       types.ID `mapconv:"Icon.ID"`
	SettingsHash string   `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *EnhancedDBUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name         string
		Description  string
		Tags         types.Tags
		IconID       types.ID `mapconv:"Icon.ID"`
		SettingsHash string   `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		IconID:       o.GetIconID(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *EnhancedDBUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *EnhancedDBUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *EnhancedDBUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *EnhancedDBUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *EnhancedDBUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *EnhancedDBUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *EnhancedDBUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *EnhancedDBUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *EnhancedDBUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *EnhancedDBUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *EnhancedDBUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *EnhancedDBUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetSettingsHash returns value of SettingsHash
func (o *EnhancedDBUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *EnhancedDBUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* EnhancedDBSetPasswordRequest
*************************************************/

// EnhancedDBSetPasswordRequest represents API parameter/response structure
type EnhancedDBSetPasswordRequest struct {
	Password string `mapconv:"EnhancedDB.Password"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *EnhancedDBSetPasswordRequest) setDefaults() interface{} {
	return &struct {
		Password string `mapconv:"EnhancedDB.Password"`
	}{
		Password: o.GetPassword(),
	}
}

// GetPassword returns value of Password
func (o *EnhancedDBSetPasswordRequest) GetPassword() string {
	return o.Password
}

// SetPassword sets value to Password
func (o *EnhancedDBSetPasswordRequest) SetPassword(v string) {
	o.Password = v
}

/*************************************************
* EnhancedDBConfig
*************************************************/

// EnhancedDBConfig represents API parameter/response structure
type EnhancedDBConfig struct {
	MaxConnections  int
	AllowedNetworks []string
}

// setDefaults implements iaas.argumentDefaulter
func (o *EnhancedDBConfig) setDefaults() interface{} {
	return &struct {
		MaxConnections  int
		AllowedNetworks []string
	}{
		MaxConnections:  o.GetMaxConnections(),
		AllowedNetworks: o.GetAllowedNetworks(),
	}
}

// GetMaxConnections returns value of MaxConnections
func (o *EnhancedDBConfig) GetMaxConnections() int {
	return o.MaxConnections
}

// SetMaxConnections sets value to MaxConnections
func (o *EnhancedDBConfig) SetMaxConnections(v int) {
	o.MaxConnections = v
}

// GetAllowedNetworks returns value of AllowedNetworks
func (o *EnhancedDBConfig) GetAllowedNetworks() []string {
	return o.AllowedNetworks
}

// SetAllowedNetworks sets value to AllowedNetworks
func (o *EnhancedDBConfig) SetAllowedNetworks(v []string) {
	o.AllowedNetworks = v
}

/*************************************************
* EnhancedDBSetConfigRequest
*************************************************/

// EnhancedDBSetConfigRequest represents API parameter/response structure
type EnhancedDBSetConfigRequest struct {
	AllowedNetworks []string `mapconv:"EnhancedDB.AllowedNetworks"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *EnhancedDBSetConfigRequest) setDefaults() interface{} {
	return &struct {
		AllowedNetworks []string `mapconv:"EnhancedDB.AllowedNetworks"`
		MaxConnections  int      `mapconv:"EnhancedDB.MaxConnections"`
	}{
		AllowedNetworks: o.GetAllowedNetworks(),
		MaxConnections:  50,
	}
}

// GetAllowedNetworks returns value of AllowedNetworks
func (o *EnhancedDBSetConfigRequest) GetAllowedNetworks() []string {
	return o.AllowedNetworks
}

// SetAllowedNetworks sets value to AllowedNetworks
func (o *EnhancedDBSetConfigRequest) SetAllowedNetworks(v []string) {
	o.AllowedNetworks = v
}

/*************************************************
* ESME
*************************************************/

// ESME represents API parameter/response structure
type ESME struct {
	ID           types.ID
	Name         string
	Description  string
	Tags         types.Tags
	Availability types.EAvailability
	IconID       types.ID `mapconv:"Icon.ID"`
	CreatedAt    time.Time
	ModifiedAt   time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *ESME) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		Tags         types.Tags
		Availability types.EAvailability
		IconID       types.ID `mapconv:"Icon.ID"`
		CreatedAt    time.Time
		ModifiedAt   time.Time
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		IconID:       o.GetIconID(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
	}
}

// GetID returns value of ID
func (o *ESME) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ESME) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ESME) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ESME) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ESME) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ESME) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *ESME) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ESME) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ESME) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ESME) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ESME) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ESME) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ESME) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ESME) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ESME) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ESME) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *ESME) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *ESME) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *ESME) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ESME) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *ESME) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *ESME) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *ESME) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *ESME) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* ESMECreateRequest
*************************************************/

// ESMECreateRequest represents API parameter/response structure
type ESMECreateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ESMECreateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
		Class       string   `mapconv:"Provider.Class"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
		Class:       "esme",
	}
}

// GetName returns value of Name
func (o *ESMECreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ESMECreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ESMECreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ESMECreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ESMECreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ESMECreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ESMECreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ESMECreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ESMECreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ESMECreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ESMECreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ESMECreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* ESMEUpdateRequest
*************************************************/

// ESMEUpdateRequest represents API parameter/response structure
type ESMEUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ESMEUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *ESMEUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ESMEUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ESMEUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ESMEUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ESMEUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ESMEUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ESMEUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ESMEUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ESMEUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ESMEUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ESMEUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ESMEUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* ESMESendMessageResult
*************************************************/

// ESMESendMessageResult represents API parameter/response structure
type ESMESendMessageResult struct {
	MessageID string
	Status    string
	OTP       string
}

// setDefaults implements iaas.argumentDefaulter
func (o *ESMESendMessageResult) setDefaults() interface{} {
	return &struct {
		MessageID string
		Status    string
		OTP       string
	}{
		MessageID: o.GetMessageID(),
		Status:    o.GetStatus(),
		OTP:       o.GetOTP(),
	}
}

// GetMessageID returns value of MessageID
func (o *ESMESendMessageResult) GetMessageID() string {
	return o.MessageID
}

// SetMessageID sets value to MessageID
func (o *ESMESendMessageResult) SetMessageID(v string) {
	o.MessageID = v
}

// GetStatus returns value of Status
func (o *ESMESendMessageResult) GetStatus() string {
	return o.Status
}

// SetStatus sets value to Status
func (o *ESMESendMessageResult) SetStatus(v string) {
	o.Status = v
}

// GetOTP returns value of OTP
func (o *ESMESendMessageResult) GetOTP() string {
	return o.OTP
}

// SetOTP sets value to OTP
func (o *ESMESendMessageResult) SetOTP(v string) {
	o.OTP = v
}

/*************************************************
* ESMESendMessageWithGeneratedOTPRequest
*************************************************/

// ESMESendMessageWithGeneratedOTPRequest represents API parameter/response structure
type ESMESendMessageWithGeneratedOTPRequest struct {
	Destination string
	Sender      string
	DomainName  string
}

// setDefaults implements iaas.argumentDefaulter
func (o *ESMESendMessageWithGeneratedOTPRequest) setDefaults() interface{} {
	return &struct {
		Destination  string
		Sender       string
		DomainName   string
		OTPOperation types.EOTPOperation
	}{
		Destination:  o.GetDestination(),
		Sender:       o.GetSender(),
		DomainName:   o.GetDomainName(),
		OTPOperation: "generate",
	}
}

// GetDestination returns value of Destination
func (o *ESMESendMessageWithGeneratedOTPRequest) GetDestination() string {
	return o.Destination
}

// SetDestination sets value to Destination
func (o *ESMESendMessageWithGeneratedOTPRequest) SetDestination(v string) {
	o.Destination = v
}

// GetSender returns value of Sender
func (o *ESMESendMessageWithGeneratedOTPRequest) GetSender() string {
	return o.Sender
}

// SetSender sets value to Sender
func (o *ESMESendMessageWithGeneratedOTPRequest) SetSender(v string) {
	o.Sender = v
}

// GetDomainName returns value of DomainName
func (o *ESMESendMessageWithGeneratedOTPRequest) GetDomainName() string {
	return o.DomainName
}

// SetDomainName sets value to DomainName
func (o *ESMESendMessageWithGeneratedOTPRequest) SetDomainName(v string) {
	o.DomainName = v
}

/*************************************************
* ESMESendMessageWithInputtedOTPRequest
*************************************************/

// ESMESendMessageWithInputtedOTPRequest represents API parameter/response structure
type ESMESendMessageWithInputtedOTPRequest struct {
	Destination string
	Sender      string
	DomainName  string
	OTP         string
}

// setDefaults implements iaas.argumentDefaulter
func (o *ESMESendMessageWithInputtedOTPRequest) setDefaults() interface{} {
	return &struct {
		Destination  string
		Sender       string
		DomainName   string
		OTP          string
		OTPOperation types.EOTPOperation
	}{
		Destination:  o.GetDestination(),
		Sender:       o.GetSender(),
		DomainName:   o.GetDomainName(),
		OTP:          o.GetOTP(),
		OTPOperation: "input",
	}
}

// GetDestination returns value of Destination
func (o *ESMESendMessageWithInputtedOTPRequest) GetDestination() string {
	return o.Destination
}

// SetDestination sets value to Destination
func (o *ESMESendMessageWithInputtedOTPRequest) SetDestination(v string) {
	o.Destination = v
}

// GetSender returns value of Sender
func (o *ESMESendMessageWithInputtedOTPRequest) GetSender() string {
	return o.Sender
}

// SetSender sets value to Sender
func (o *ESMESendMessageWithInputtedOTPRequest) SetSender(v string) {
	o.Sender = v
}

// GetDomainName returns value of DomainName
func (o *ESMESendMessageWithInputtedOTPRequest) GetDomainName() string {
	return o.DomainName
}

// SetDomainName sets value to DomainName
func (o *ESMESendMessageWithInputtedOTPRequest) SetDomainName(v string) {
	o.DomainName = v
}

// GetOTP returns value of OTP
func (o *ESMESendMessageWithInputtedOTPRequest) GetOTP() string {
	return o.OTP
}

// SetOTP sets value to OTP
func (o *ESMESendMessageWithInputtedOTPRequest) SetOTP(v string) {
	o.OTP = v
}

/*************************************************
* ESMELogs
*************************************************/

// ESMELogs represents API parameter/response structure
type ESMELogs struct {
	MessageID   string
	Status      string
	OTP         string
	Destination string
	SentAt      time.Time
	DoneAt      time.Time
	RetryCount  int
}

// setDefaults implements iaas.argumentDefaulter
func (o *ESMELogs) setDefaults() interface{} {
	return &struct {
		MessageID   string
		Status      string
		OTP         string
		Destination string
		SentAt      time.Time
		DoneAt      time.Time
		RetryCount  int
	}{
		MessageID:   o.GetMessageID(),
		Status:      o.GetStatus(),
		OTP:         o.GetOTP(),
		Destination: o.GetDestination(),
		SentAt:      o.GetSentAt(),
		DoneAt:      o.GetDoneAt(),
		RetryCount:  o.GetRetryCount(),
	}
}

// GetMessageID returns value of MessageID
func (o *ESMELogs) GetMessageID() string {
	return o.MessageID
}

// SetMessageID sets value to MessageID
func (o *ESMELogs) SetMessageID(v string) {
	o.MessageID = v
}

// GetStatus returns value of Status
func (o *ESMELogs) GetStatus() string {
	return o.Status
}

// SetStatus sets value to Status
func (o *ESMELogs) SetStatus(v string) {
	o.Status = v
}

// GetOTP returns value of OTP
func (o *ESMELogs) GetOTP() string {
	return o.OTP
}

// SetOTP sets value to OTP
func (o *ESMELogs) SetOTP(v string) {
	o.OTP = v
}

// GetDestination returns value of Destination
func (o *ESMELogs) GetDestination() string {
	return o.Destination
}

// SetDestination sets value to Destination
func (o *ESMELogs) SetDestination(v string) {
	o.Destination = v
}

// GetSentAt returns value of SentAt
func (o *ESMELogs) GetSentAt() time.Time {
	return o.SentAt
}

// SetSentAt sets value to SentAt
func (o *ESMELogs) SetSentAt(v time.Time) {
	o.SentAt = v
}

// GetDoneAt returns value of DoneAt
func (o *ESMELogs) GetDoneAt() time.Time {
	return o.DoneAt
}

// SetDoneAt sets value to DoneAt
func (o *ESMELogs) SetDoneAt(v time.Time) {
	o.DoneAt = v
}

// GetRetryCount returns value of RetryCount
func (o *ESMELogs) GetRetryCount() int {
	return o.RetryCount
}

// SetRetryCount sets value to RetryCount
func (o *ESMELogs) SetRetryCount(v int) {
	o.RetryCount = v
}

/*************************************************
* GSLB
*************************************************/

// GSLB represents API parameter/response structure
type GSLB struct {
	ID                 types.ID
	Name               string
	Description        string
	Tags               types.Tags
	Availability       types.EAvailability
	IconID             types.ID `mapconv:"Icon.ID"`
	CreatedAt          time.Time
	ModifiedAt         time.Time
	SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
	FQDN               string              `mapconv:"Status.FQDN"`
	DelayLoop          int                 `mapconv:"Settings.GSLB.DelayLoop"`
	Weighted           types.StringFlag    `mapconv:"Settings.GSLB.Weighted"`
	HealthCheck        *GSLBHealthCheck    `mapconv:"Settings.GSLB.HealthCheck,recursive"`
	SorryServer        string              `mapconv:"Settings.GSLB.SorryServer"`
	MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.GSLB.MonitoringSuiteLog,recursive"`
	DestinationServers GSLBServers         `mapconv:"Settings.GSLB.[]Servers,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *GSLB) setDefaults() interface{} {
	return &struct {
		ID                 types.ID
		Name               string
		Description        string
		Tags               types.Tags
		Availability       types.EAvailability
		IconID             types.ID `mapconv:"Icon.ID"`
		CreatedAt          time.Time
		ModifiedAt         time.Time
		SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
		FQDN               string              `mapconv:"Status.FQDN"`
		DelayLoop          int                 `mapconv:"Settings.GSLB.DelayLoop"`
		Weighted           types.StringFlag    `mapconv:"Settings.GSLB.Weighted"`
		HealthCheck        *GSLBHealthCheck    `mapconv:"Settings.GSLB.HealthCheck,recursive"`
		SorryServer        string              `mapconv:"Settings.GSLB.SorryServer"`
		MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.GSLB.MonitoringSuiteLog,recursive"`
		DestinationServers GSLBServers         `mapconv:"Settings.GSLB.[]Servers,recursive"`
	}{
		ID:                 o.GetID(),
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		Availability:       o.GetAvailability(),
		IconID:             o.GetIconID(),
		CreatedAt:          o.GetCreatedAt(),
		ModifiedAt:         o.GetModifiedAt(),
		SettingsHash:       o.GetSettingsHash(),
		FQDN:               o.GetFQDN(),
		DelayLoop:          o.GetDelayLoop(),
		Weighted:           o.GetWeighted(),
		HealthCheck:        o.GetHealthCheck(),
		SorryServer:        o.GetSorryServer(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		DestinationServers: o.GetDestinationServers(),
	}
}

// GetID returns value of ID
func (o *GSLB) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *GSLB) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *GSLB) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *GSLB) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *GSLB) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *GSLB) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *GSLB) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *GSLB) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *GSLB) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *GSLB) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *GSLB) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *GSLB) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *GSLB) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *GSLB) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *GSLB) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *GSLB) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *GSLB) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *GSLB) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *GSLB) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *GSLB) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *GSLB) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *GSLB) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *GSLB) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *GSLB) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetSettingsHash returns value of SettingsHash
func (o *GSLB) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *GSLB) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetFQDN returns value of FQDN
func (o *GSLB) GetFQDN() string {
	return o.FQDN
}

// SetFQDN sets value to FQDN
func (o *GSLB) SetFQDN(v string) {
	o.FQDN = v
}

// GetDelayLoop returns value of DelayLoop
func (o *GSLB) GetDelayLoop() int {
	if o.DelayLoop == 0 {
		return 10
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *GSLB) SetDelayLoop(v int) {
	o.DelayLoop = v
}

// GetWeighted returns value of Weighted
func (o *GSLB) GetWeighted() types.StringFlag {
	return o.Weighted
}

// SetWeighted sets value to Weighted
func (o *GSLB) SetWeighted(v types.StringFlag) {
	o.Weighted = v
}

// GetHealthCheck returns value of HealthCheck
func (o *GSLB) GetHealthCheck() *GSLBHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *GSLB) SetHealthCheck(v *GSLBHealthCheck) {
	o.HealthCheck = v
}

// GetSorryServer returns value of SorryServer
func (o *GSLB) GetSorryServer() string {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *GSLB) SetSorryServer(v string) {
	o.SorryServer = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *GSLB) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *GSLB) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetDestinationServers returns value of DestinationServers
func (o *GSLB) GetDestinationServers() GSLBServers {
	return o.DestinationServers
}

// SetDestinationServers sets value to DestinationServers
func (o *GSLB) SetDestinationServers(v GSLBServers) {
	o.DestinationServers = v
}

/*************************************************
* GSLBHealthCheck
*************************************************/

// GSLBHealthCheck represents API parameter/response structure
type GSLBHealthCheck struct {
	Protocol     types.EGSLBHealthCheckProtocol
	HostHeader   string             `mapconv:"Host"`
	Path         string             `mapconv:"Path"`
	ResponseCode types.StringNumber `mapconv:"Status"`
	Port         types.StringNumber `mapconv:"Port"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *GSLBHealthCheck) setDefaults() interface{} {
	return &struct {
		Protocol     types.EGSLBHealthCheckProtocol
		HostHeader   string             `mapconv:"Host"`
		Path         string             `mapconv:"Path"`
		ResponseCode types.StringNumber `mapconv:"Status"`
		Port         types.StringNumber `mapconv:"Port"`
	}{
		Protocol:     o.GetProtocol(),
		HostHeader:   o.GetHostHeader(),
		Path:         o.GetPath(),
		ResponseCode: o.GetResponseCode(),
		Port:         o.GetPort(),
	}
}

// GetProtocol returns value of Protocol
func (o *GSLBHealthCheck) GetProtocol() types.EGSLBHealthCheckProtocol {
	return o.Protocol
}

// SetProtocol sets value to Protocol
func (o *GSLBHealthCheck) SetProtocol(v types.EGSLBHealthCheckProtocol) {
	o.Protocol = v
}

// GetHostHeader returns value of HostHeader
func (o *GSLBHealthCheck) GetHostHeader() string {
	return o.HostHeader
}

// SetHostHeader sets value to HostHeader
func (o *GSLBHealthCheck) SetHostHeader(v string) {
	o.HostHeader = v
}

// GetPath returns value of Path
func (o *GSLBHealthCheck) GetPath() string {
	return o.Path
}

// SetPath sets value to Path
func (o *GSLBHealthCheck) SetPath(v string) {
	o.Path = v
}

// GetResponseCode returns value of ResponseCode
func (o *GSLBHealthCheck) GetResponseCode() types.StringNumber {
	return o.ResponseCode
}

// SetResponseCode sets value to ResponseCode
func (o *GSLBHealthCheck) SetResponseCode(v types.StringNumber) {
	o.ResponseCode = v
}

// GetPort returns value of Port
func (o *GSLBHealthCheck) GetPort() types.StringNumber {
	return o.Port
}

// SetPort sets value to Port
func (o *GSLBHealthCheck) SetPort(v types.StringNumber) {
	o.Port = v
}

/*************************************************
* GSLBServer
*************************************************/

// GSLBServer represents API parameter/response structure
type GSLBServer struct {
	IPAddress string
	Enabled   types.StringFlag
	Weight    types.StringNumber
}

// setDefaults implements iaas.argumentDefaulter
func (o *GSLBServer) setDefaults() interface{} {
	return &struct {
		IPAddress string
		Enabled   types.StringFlag
		Weight    types.StringNumber
	}{
		IPAddress: o.GetIPAddress(),
		Enabled:   o.GetEnabled(),
		Weight:    o.GetWeight(),
	}
}

// GetIPAddress returns value of IPAddress
func (o *GSLBServer) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *GSLBServer) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetEnabled returns value of Enabled
func (o *GSLBServer) GetEnabled() types.StringFlag {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *GSLBServer) SetEnabled(v types.StringFlag) {
	o.Enabled = v
}

// GetWeight returns value of Weight
func (o *GSLBServer) GetWeight() types.StringNumber {
	return o.Weight
}

// SetWeight sets value to Weight
func (o *GSLBServer) SetWeight(v types.StringNumber) {
	o.Weight = v
}

/*************************************************
* GSLBCreateRequest
*************************************************/

// GSLBCreateRequest represents API parameter/response structure
type GSLBCreateRequest struct {
	HealthCheck        *GSLBHealthCheck    `mapconv:"Settings.GSLB.HealthCheck,recursive"`
	DelayLoop          int                 `mapconv:"Settings.GSLB.DelayLoop"`
	Weighted           types.StringFlag    `mapconv:"Settings.GSLB.Weighted"`
	SorryServer        string              `mapconv:"Settings.GSLB.SorryServer"`
	MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.GSLB.MonitoringSuiteLog,recursive"`
	DestinationServers GSLBServers         `mapconv:"Settings.GSLB.[]Servers,recursive"`
	Name               string
	Description        string
	Tags               types.Tags
	IconID             types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *GSLBCreateRequest) setDefaults() interface{} {
	return &struct {
		HealthCheck        *GSLBHealthCheck    `mapconv:"Settings.GSLB.HealthCheck,recursive"`
		DelayLoop          int                 `mapconv:"Settings.GSLB.DelayLoop"`
		Weighted           types.StringFlag    `mapconv:"Settings.GSLB.Weighted"`
		SorryServer        string              `mapconv:"Settings.GSLB.SorryServer"`
		MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.GSLB.MonitoringSuiteLog,recursive"`
		DestinationServers GSLBServers         `mapconv:"Settings.GSLB.[]Servers,recursive"`
		Name               string
		Description        string
		Tags               types.Tags
		IconID             types.ID `mapconv:"Icon.ID"`
		Class              string   `mapconv:"Provider.Class"`
	}{
		HealthCheck:        o.GetHealthCheck(),
		DelayLoop:          o.GetDelayLoop(),
		Weighted:           o.GetWeighted(),
		SorryServer:        o.GetSorryServer(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		DestinationServers: o.GetDestinationServers(),
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		Class:              "gslb",
	}
}

// GetHealthCheck returns value of HealthCheck
func (o *GSLBCreateRequest) GetHealthCheck() *GSLBHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *GSLBCreateRequest) SetHealthCheck(v *GSLBHealthCheck) {
	o.HealthCheck = v
}

// GetDelayLoop returns value of DelayLoop
func (o *GSLBCreateRequest) GetDelayLoop() int {
	if o.DelayLoop == 0 {
		return 10
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *GSLBCreateRequest) SetDelayLoop(v int) {
	o.DelayLoop = v
}

// GetWeighted returns value of Weighted
func (o *GSLBCreateRequest) GetWeighted() types.StringFlag {
	return o.Weighted
}

// SetWeighted sets value to Weighted
func (o *GSLBCreateRequest) SetWeighted(v types.StringFlag) {
	o.Weighted = v
}

// GetSorryServer returns value of SorryServer
func (o *GSLBCreateRequest) GetSorryServer() string {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *GSLBCreateRequest) SetSorryServer(v string) {
	o.SorryServer = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *GSLBCreateRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *GSLBCreateRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetDestinationServers returns value of DestinationServers
func (o *GSLBCreateRequest) GetDestinationServers() GSLBServers {
	return o.DestinationServers
}

// SetDestinationServers sets value to DestinationServers
func (o *GSLBCreateRequest) SetDestinationServers(v GSLBServers) {
	o.DestinationServers = v
}

// GetName returns value of Name
func (o *GSLBCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *GSLBCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *GSLBCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *GSLBCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *GSLBCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *GSLBCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *GSLBCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *GSLBCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *GSLBCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *GSLBCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *GSLBCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *GSLBCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* GSLBUpdateRequest
*************************************************/

// GSLBUpdateRequest represents API parameter/response structure
type GSLBUpdateRequest struct {
	Name               string
	Description        string
	Tags               types.Tags
	IconID             types.ID            `mapconv:"Icon.ID"`
	HealthCheck        *GSLBHealthCheck    `mapconv:"Settings.GSLB.HealthCheck,recursive"`
	DelayLoop          int                 `mapconv:"Settings.GSLB.DelayLoop"`
	Weighted           types.StringFlag    `mapconv:"Settings.GSLB.Weighted"`
	SorryServer        string              `mapconv:"Settings.GSLB.SorryServer"`
	MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.GSLB.MonitoringSuiteLog,recursive"`
	DestinationServers GSLBServers         `mapconv:"Settings.GSLB.[]Servers,recursive"`
	SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *GSLBUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name               string
		Description        string
		Tags               types.Tags
		IconID             types.ID            `mapconv:"Icon.ID"`
		HealthCheck        *GSLBHealthCheck    `mapconv:"Settings.GSLB.HealthCheck,recursive"`
		DelayLoop          int                 `mapconv:"Settings.GSLB.DelayLoop"`
		Weighted           types.StringFlag    `mapconv:"Settings.GSLB.Weighted"`
		SorryServer        string              `mapconv:"Settings.GSLB.SorryServer"`
		MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.GSLB.MonitoringSuiteLog,recursive"`
		DestinationServers GSLBServers         `mapconv:"Settings.GSLB.[]Servers,recursive"`
		SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		HealthCheck:        o.GetHealthCheck(),
		DelayLoop:          o.GetDelayLoop(),
		Weighted:           o.GetWeighted(),
		SorryServer:        o.GetSorryServer(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		DestinationServers: o.GetDestinationServers(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *GSLBUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *GSLBUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *GSLBUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *GSLBUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *GSLBUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *GSLBUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *GSLBUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *GSLBUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *GSLBUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *GSLBUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *GSLBUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *GSLBUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetHealthCheck returns value of HealthCheck
func (o *GSLBUpdateRequest) GetHealthCheck() *GSLBHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *GSLBUpdateRequest) SetHealthCheck(v *GSLBHealthCheck) {
	o.HealthCheck = v
}

// GetDelayLoop returns value of DelayLoop
func (o *GSLBUpdateRequest) GetDelayLoop() int {
	if o.DelayLoop == 0 {
		return 10
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *GSLBUpdateRequest) SetDelayLoop(v int) {
	o.DelayLoop = v
}

// GetWeighted returns value of Weighted
func (o *GSLBUpdateRequest) GetWeighted() types.StringFlag {
	return o.Weighted
}

// SetWeighted sets value to Weighted
func (o *GSLBUpdateRequest) SetWeighted(v types.StringFlag) {
	o.Weighted = v
}

// GetSorryServer returns value of SorryServer
func (o *GSLBUpdateRequest) GetSorryServer() string {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *GSLBUpdateRequest) SetSorryServer(v string) {
	o.SorryServer = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *GSLBUpdateRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *GSLBUpdateRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetDestinationServers returns value of DestinationServers
func (o *GSLBUpdateRequest) GetDestinationServers() GSLBServers {
	return o.DestinationServers
}

// SetDestinationServers sets value to DestinationServers
func (o *GSLBUpdateRequest) SetDestinationServers(v GSLBServers) {
	o.DestinationServers = v
}

// GetSettingsHash returns value of SettingsHash
func (o *GSLBUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *GSLBUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* GSLBUpdateSettingsRequest
*************************************************/

// GSLBUpdateSettingsRequest represents API parameter/response structure
type GSLBUpdateSettingsRequest struct {
	HealthCheck        *GSLBHealthCheck    `mapconv:"Settings.GSLB.HealthCheck,recursive"`
	DelayLoop          int                 `mapconv:"Settings.GSLB.DelayLoop"`
	Weighted           types.StringFlag    `mapconv:"Settings.GSLB.Weighted"`
	SorryServer        string              `mapconv:"Settings.GSLB.SorryServer"`
	MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.GSLB.MonitoringSuiteLog,recursive"`
	DestinationServers GSLBServers         `mapconv:"Settings.GSLB.[]Servers,recursive"`
	SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *GSLBUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		HealthCheck        *GSLBHealthCheck    `mapconv:"Settings.GSLB.HealthCheck,recursive"`
		DelayLoop          int                 `mapconv:"Settings.GSLB.DelayLoop"`
		Weighted           types.StringFlag    `mapconv:"Settings.GSLB.Weighted"`
		SorryServer        string              `mapconv:"Settings.GSLB.SorryServer"`
		MonitoringSuiteLog *MonitoringSuiteLog `mapconv:"Settings.GSLB.MonitoringSuiteLog,recursive"`
		DestinationServers GSLBServers         `mapconv:"Settings.GSLB.[]Servers,recursive"`
		SettingsHash       string              `json:",omitempty" mapconv:",omitempty"`
	}{
		HealthCheck:        o.GetHealthCheck(),
		DelayLoop:          o.GetDelayLoop(),
		Weighted:           o.GetWeighted(),
		SorryServer:        o.GetSorryServer(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		DestinationServers: o.GetDestinationServers(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetHealthCheck returns value of HealthCheck
func (o *GSLBUpdateSettingsRequest) GetHealthCheck() *GSLBHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *GSLBUpdateSettingsRequest) SetHealthCheck(v *GSLBHealthCheck) {
	o.HealthCheck = v
}

// GetDelayLoop returns value of DelayLoop
func (o *GSLBUpdateSettingsRequest) GetDelayLoop() int {
	if o.DelayLoop == 0 {
		return 10
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *GSLBUpdateSettingsRequest) SetDelayLoop(v int) {
	o.DelayLoop = v
}

// GetWeighted returns value of Weighted
func (o *GSLBUpdateSettingsRequest) GetWeighted() types.StringFlag {
	return o.Weighted
}

// SetWeighted sets value to Weighted
func (o *GSLBUpdateSettingsRequest) SetWeighted(v types.StringFlag) {
	o.Weighted = v
}

// GetSorryServer returns value of SorryServer
func (o *GSLBUpdateSettingsRequest) GetSorryServer() string {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *GSLBUpdateSettingsRequest) SetSorryServer(v string) {
	o.SorryServer = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *GSLBUpdateSettingsRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *GSLBUpdateSettingsRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetDestinationServers returns value of DestinationServers
func (o *GSLBUpdateSettingsRequest) GetDestinationServers() GSLBServers {
	return o.DestinationServers
}

// SetDestinationServers sets value to DestinationServers
func (o *GSLBUpdateSettingsRequest) SetDestinationServers(v GSLBServers) {
	o.DestinationServers = v
}

// GetSettingsHash returns value of SettingsHash
func (o *GSLBUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *GSLBUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* Icon
*************************************************/

// Icon represents API parameter/response structure
type Icon struct {
	ID           types.ID
	Name         string
	Tags         types.Tags
	Availability types.EAvailability
	Scope        types.EScope
	URL          string
	CreatedAt    time.Time
	ModifiedAt   time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *Icon) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Tags         types.Tags
		Availability types.EAvailability
		Scope        types.EScope
		URL          string
		CreatedAt    time.Time
		ModifiedAt   time.Time
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		Scope:        o.GetScope(),
		URL:          o.GetURL(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
	}
}

// GetID returns value of ID
func (o *Icon) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Icon) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Icon) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Icon) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Icon) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Icon) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Icon) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Icon) SetName(v string) {
	o.Name = v
}

// GetTags returns value of Tags
func (o *Icon) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *Icon) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *Icon) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *Icon) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *Icon) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *Icon) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *Icon) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *Icon) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetScope returns value of Scope
func (o *Icon) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *Icon) SetScope(v types.EScope) {
	o.Scope = v
}

// GetURL returns value of URL
func (o *Icon) GetURL() string {
	return o.URL
}

// SetURL sets value to URL
func (o *Icon) SetURL(v string) {
	o.URL = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Icon) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Icon) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *Icon) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *Icon) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* IconCreateRequest
*************************************************/

// IconCreateRequest represents API parameter/response structure
type IconCreateRequest struct {
	Name  string
	Tags  types.Tags
	Image string
}

// setDefaults implements iaas.argumentDefaulter
func (o *IconCreateRequest) setDefaults() interface{} {
	return &struct {
		Name  string
		Tags  types.Tags
		Image string
	}{
		Name:  o.GetName(),
		Tags:  o.GetTags(),
		Image: o.GetImage(),
	}
}

// GetName returns value of Name
func (o *IconCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *IconCreateRequest) SetName(v string) {
	o.Name = v
}

// GetTags returns value of Tags
func (o *IconCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *IconCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *IconCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *IconCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *IconCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *IconCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetImage returns value of Image
func (o *IconCreateRequest) GetImage() string {
	return o.Image
}

// SetImage sets value to Image
func (o *IconCreateRequest) SetImage(v string) {
	o.Image = v
}

/*************************************************
* IconUpdateRequest
*************************************************/

// IconUpdateRequest represents API parameter/response structure
type IconUpdateRequest struct {
	Name string
	Tags types.Tags
}

// setDefaults implements iaas.argumentDefaulter
func (o *IconUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name string
		Tags types.Tags
	}{
		Name: o.GetName(),
		Tags: o.GetTags(),
	}
}

// GetName returns value of Name
func (o *IconUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *IconUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetTags returns value of Tags
func (o *IconUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *IconUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *IconUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *IconUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *IconUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *IconUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

/*************************************************
* Interface
*************************************************/

// Interface represents API parameter/response structure
type Interface struct {
	ID             types.ID
	MACAddress     string
	IPAddress      string
	UserIPAddress  string
	HostName       string
	SwitchID       types.ID     `mapconv:"Switch.ID,omitempty"`
	SwitchScope    types.EScope `mapconv:"Switch.Scope,omitempty"`
	PacketFilterID types.ID     `mapconv:"PacketFilter.ID,omitempty"`
	ServerID       types.ID     `mapconv:"Server.ID,omitempty"`
	CreatedAt      time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *Interface) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		MACAddress     string
		IPAddress      string
		UserIPAddress  string
		HostName       string
		SwitchID       types.ID     `mapconv:"Switch.ID,omitempty"`
		SwitchScope    types.EScope `mapconv:"Switch.Scope,omitempty"`
		PacketFilterID types.ID     `mapconv:"PacketFilter.ID,omitempty"`
		ServerID       types.ID     `mapconv:"Server.ID,omitempty"`
		CreatedAt      time.Time
	}{
		ID:             o.GetID(),
		MACAddress:     o.GetMACAddress(),
		IPAddress:      o.GetIPAddress(),
		UserIPAddress:  o.GetUserIPAddress(),
		HostName:       o.GetHostName(),
		SwitchID:       o.GetSwitchID(),
		SwitchScope:    o.GetSwitchScope(),
		PacketFilterID: o.GetPacketFilterID(),
		ServerID:       o.GetServerID(),
		CreatedAt:      o.GetCreatedAt(),
	}
}

// GetID returns value of ID
func (o *Interface) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Interface) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Interface) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Interface) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Interface) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Interface) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetMACAddress returns value of MACAddress
func (o *Interface) GetMACAddress() string {
	return o.MACAddress
}

// SetMACAddress sets value to MACAddress
func (o *Interface) SetMACAddress(v string) {
	o.MACAddress = v
}

// GetIPAddress returns value of IPAddress
func (o *Interface) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *Interface) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetUserIPAddress returns value of UserIPAddress
func (o *Interface) GetUserIPAddress() string {
	return o.UserIPAddress
}

// SetUserIPAddress sets value to UserIPAddress
func (o *Interface) SetUserIPAddress(v string) {
	o.UserIPAddress = v
}

// GetHostName returns value of HostName
func (o *Interface) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *Interface) SetHostName(v string) {
	o.HostName = v
}

// GetSwitchID returns value of SwitchID
func (o *Interface) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *Interface) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetSwitchScope returns value of SwitchScope
func (o *Interface) GetSwitchScope() types.EScope {
	return o.SwitchScope
}

// SetSwitchScope sets value to SwitchScope
func (o *Interface) SetSwitchScope(v types.EScope) {
	o.SwitchScope = v
}

// GetPacketFilterID returns value of PacketFilterID
func (o *Interface) GetPacketFilterID() types.ID {
	return o.PacketFilterID
}

// SetPacketFilterID sets value to PacketFilterID
func (o *Interface) SetPacketFilterID(v types.ID) {
	o.PacketFilterID = v
}

// GetServerID returns value of ServerID
func (o *Interface) GetServerID() types.ID {
	return o.ServerID
}

// SetServerID sets value to ServerID
func (o *Interface) SetServerID(v types.ID) {
	o.ServerID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Interface) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Interface) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

/*************************************************
* InterfaceCreateRequest
*************************************************/

// InterfaceCreateRequest represents API parameter/response structure
type InterfaceCreateRequest struct {
	ServerID types.ID `mapconv:"Server.ID,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *InterfaceCreateRequest) setDefaults() interface{} {
	return &struct {
		ServerID types.ID `mapconv:"Server.ID,omitempty"`
	}{
		ServerID: o.GetServerID(),
	}
}

// GetServerID returns value of ServerID
func (o *InterfaceCreateRequest) GetServerID() types.ID {
	return o.ServerID
}

// SetServerID sets value to ServerID
func (o *InterfaceCreateRequest) SetServerID(v types.ID) {
	o.ServerID = v
}

/*************************************************
* InterfaceUpdateRequest
*************************************************/

// InterfaceUpdateRequest represents API parameter/response structure
type InterfaceUpdateRequest struct {
	UserIPAddress string
}

// setDefaults implements iaas.argumentDefaulter
func (o *InterfaceUpdateRequest) setDefaults() interface{} {
	return &struct {
		UserIPAddress string
	}{
		UserIPAddress: o.GetUserIPAddress(),
	}
}

// GetUserIPAddress returns value of UserIPAddress
func (o *InterfaceUpdateRequest) GetUserIPAddress() string {
	return o.UserIPAddress
}

// SetUserIPAddress sets value to UserIPAddress
func (o *InterfaceUpdateRequest) SetUserIPAddress(v string) {
	o.UserIPAddress = v
}

/*************************************************
* Internet
*************************************************/

// Internet represents API parameter/response structure
type Internet struct {
	ID             types.ID
	Name           string
	Description    string
	Tags           types.Tags
	IconID         types.ID `mapconv:"Icon.ID"`
	CreatedAt      time.Time
	BandWidthMbps  int
	NetworkMaskLen int
	Switch         *SwitchInfo `mapconv:",recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *Internet) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		Name           string
		Description    string
		Tags           types.Tags
		IconID         types.ID `mapconv:"Icon.ID"`
		CreatedAt      time.Time
		BandWidthMbps  int
		NetworkMaskLen int
		Switch         *SwitchInfo `mapconv:",recursive"`
	}{
		ID:             o.GetID(),
		Name:           o.GetName(),
		Description:    o.GetDescription(),
		Tags:           o.GetTags(),
		IconID:         o.GetIconID(),
		CreatedAt:      o.GetCreatedAt(),
		BandWidthMbps:  o.GetBandWidthMbps(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
		Switch:         o.GetSwitch(),
	}
}

// GetID returns value of ID
func (o *Internet) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Internet) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Internet) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Internet) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Internet) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Internet) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Internet) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Internet) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Internet) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Internet) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *Internet) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *Internet) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *Internet) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *Internet) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *Internet) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *Internet) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *Internet) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *Internet) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Internet) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Internet) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetBandWidthMbps returns value of BandWidthMbps
func (o *Internet) GetBandWidthMbps() int {
	return o.BandWidthMbps
}

// SetBandWidthMbps sets value to BandWidthMbps
func (o *Internet) SetBandWidthMbps(v int) {
	o.BandWidthMbps = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *Internet) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *Internet) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetSwitch returns value of Switch
func (o *Internet) GetSwitch() *SwitchInfo {
	return o.Switch
}

// SetSwitch sets value to Switch
func (o *Internet) SetSwitch(v *SwitchInfo) {
	o.Switch = v
}

/*************************************************
* SwitchInfo
*************************************************/

// SwitchInfo represents API parameter/response structure
type SwitchInfo struct {
	ID          types.ID
	Name        string
	Description string
	Tags        types.Tags
	Scope       types.EScope
	Subnets     []*InternetSubnet `mapconv:"[]Subnets,recursive"`
	IPv6Nets    []*IPv6NetInfo    `mapconv:"[]IPv6Nets,recursive,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SwitchInfo) setDefaults() interface{} {
	return &struct {
		ID          types.ID
		Name        string
		Description string
		Tags        types.Tags
		Scope       types.EScope
		Subnets     []*InternetSubnet `mapconv:"[]Subnets,recursive"`
		IPv6Nets    []*IPv6NetInfo    `mapconv:"[]IPv6Nets,recursive,omitempty"`
	}{
		ID:          o.GetID(),
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		Scope:       o.GetScope(),
		Subnets:     o.GetSubnets(),
		IPv6Nets:    o.GetIPv6Nets(),
	}
}

// GetID returns value of ID
func (o *SwitchInfo) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *SwitchInfo) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *SwitchInfo) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *SwitchInfo) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *SwitchInfo) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *SwitchInfo) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *SwitchInfo) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SwitchInfo) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SwitchInfo) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SwitchInfo) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SwitchInfo) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SwitchInfo) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SwitchInfo) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SwitchInfo) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SwitchInfo) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SwitchInfo) ClearTags() {
	accessor.ClearTags(o)
}

// GetScope returns value of Scope
func (o *SwitchInfo) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *SwitchInfo) SetScope(v types.EScope) {
	o.Scope = v
}

// GetSubnets returns value of Subnets
func (o *SwitchInfo) GetSubnets() []*InternetSubnet {
	return o.Subnets
}

// SetSubnets sets value to Subnets
func (o *SwitchInfo) SetSubnets(v []*InternetSubnet) {
	o.Subnets = v
}

// GetIPv6Nets returns value of IPv6Nets
func (o *SwitchInfo) GetIPv6Nets() []*IPv6NetInfo {
	return o.IPv6Nets
}

// SetIPv6Nets sets value to IPv6Nets
func (o *SwitchInfo) SetIPv6Nets(v []*IPv6NetInfo) {
	o.IPv6Nets = v
}

/*************************************************
* InternetSubnet
*************************************************/

// InternetSubnet represents API parameter/response structure
type InternetSubnet struct {
	ID             types.ID
	DefaultRoute   string
	NextHop        string
	StaticRoute    string
	NetworkAddress string
	NetworkMaskLen int
}

// setDefaults implements iaas.argumentDefaulter
func (o *InternetSubnet) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		DefaultRoute   string
		NextHop        string
		StaticRoute    string
		NetworkAddress string
		NetworkMaskLen int
	}{
		ID:             o.GetID(),
		DefaultRoute:   o.GetDefaultRoute(),
		NextHop:        o.GetNextHop(),
		StaticRoute:    o.GetStaticRoute(),
		NetworkAddress: o.GetNetworkAddress(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
	}
}

// GetID returns value of ID
func (o *InternetSubnet) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *InternetSubnet) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *InternetSubnet) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *InternetSubnet) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *InternetSubnet) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *InternetSubnet) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetDefaultRoute returns value of DefaultRoute
func (o *InternetSubnet) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *InternetSubnet) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetNextHop returns value of NextHop
func (o *InternetSubnet) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *InternetSubnet) SetNextHop(v string) {
	o.NextHop = v
}

// GetStaticRoute returns value of StaticRoute
func (o *InternetSubnet) GetStaticRoute() string {
	return o.StaticRoute
}

// SetStaticRoute sets value to StaticRoute
func (o *InternetSubnet) SetStaticRoute(v string) {
	o.StaticRoute = v
}

// GetNetworkAddress returns value of NetworkAddress
func (o *InternetSubnet) GetNetworkAddress() string {
	return o.NetworkAddress
}

// SetNetworkAddress sets value to NetworkAddress
func (o *InternetSubnet) SetNetworkAddress(v string) {
	o.NetworkAddress = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *InternetSubnet) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *InternetSubnet) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

/*************************************************
* IPv6NetInfo
*************************************************/

// IPv6NetInfo represents API parameter/response structure
type IPv6NetInfo struct {
	ID            types.ID
	IPv6Prefix    string
	IPv6PrefixLen int
}

// setDefaults implements iaas.argumentDefaulter
func (o *IPv6NetInfo) setDefaults() interface{} {
	return &struct {
		ID            types.ID
		IPv6Prefix    string
		IPv6PrefixLen int
	}{
		ID:            o.GetID(),
		IPv6Prefix:    o.GetIPv6Prefix(),
		IPv6PrefixLen: o.GetIPv6PrefixLen(),
	}
}

// GetID returns value of ID
func (o *IPv6NetInfo) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *IPv6NetInfo) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *IPv6NetInfo) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *IPv6NetInfo) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *IPv6NetInfo) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *IPv6NetInfo) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetIPv6Prefix returns value of IPv6Prefix
func (o *IPv6NetInfo) GetIPv6Prefix() string {
	return o.IPv6Prefix
}

// SetIPv6Prefix sets value to IPv6Prefix
func (o *IPv6NetInfo) SetIPv6Prefix(v string) {
	o.IPv6Prefix = v
}

// GetIPv6PrefixLen returns value of IPv6PrefixLen
func (o *IPv6NetInfo) GetIPv6PrefixLen() int {
	return o.IPv6PrefixLen
}

// SetIPv6PrefixLen sets value to IPv6PrefixLen
func (o *IPv6NetInfo) SetIPv6PrefixLen(v int) {
	o.IPv6PrefixLen = v
}

/*************************************************
* InternetCreateRequest
*************************************************/

// InternetCreateRequest represents API parameter/response structure
type InternetCreateRequest struct {
	Name           string
	Description    string
	Tags           types.Tags
	IconID         types.ID `mapconv:"Icon.ID"`
	NetworkMaskLen int
	BandWidthMbps  int
}

// setDefaults implements iaas.argumentDefaulter
func (o *InternetCreateRequest) setDefaults() interface{} {
	return &struct {
		Name           string
		Description    string
		Tags           types.Tags
		IconID         types.ID `mapconv:"Icon.ID"`
		NetworkMaskLen int
		BandWidthMbps  int
	}{
		Name:           o.GetName(),
		Description:    o.GetDescription(),
		Tags:           o.GetTags(),
		IconID:         o.GetIconID(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
		BandWidthMbps:  o.GetBandWidthMbps(),
	}
}

// GetName returns value of Name
func (o *InternetCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *InternetCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *InternetCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *InternetCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *InternetCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *InternetCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *InternetCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *InternetCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *InternetCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *InternetCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *InternetCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *InternetCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *InternetCreateRequest) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *InternetCreateRequest) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetBandWidthMbps returns value of BandWidthMbps
func (o *InternetCreateRequest) GetBandWidthMbps() int {
	return o.BandWidthMbps
}

// SetBandWidthMbps sets value to BandWidthMbps
func (o *InternetCreateRequest) SetBandWidthMbps(v int) {
	o.BandWidthMbps = v
}

/*************************************************
* InternetUpdateRequest
*************************************************/

// InternetUpdateRequest represents API parameter/response structure
type InternetUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *InternetUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *InternetUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *InternetUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *InternetUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *InternetUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *InternetUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *InternetUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *InternetUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *InternetUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *InternetUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *InternetUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *InternetUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *InternetUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* InternetUpdateBandWidthRequest
*************************************************/

// InternetUpdateBandWidthRequest represents API parameter/response structure
type InternetUpdateBandWidthRequest struct {
	BandWidthMbps int
}

// setDefaults implements iaas.argumentDefaulter
func (o *InternetUpdateBandWidthRequest) setDefaults() interface{} {
	return &struct {
		BandWidthMbps int
	}{
		BandWidthMbps: o.GetBandWidthMbps(),
	}
}

// GetBandWidthMbps returns value of BandWidthMbps
func (o *InternetUpdateBandWidthRequest) GetBandWidthMbps() int {
	return o.BandWidthMbps
}

// SetBandWidthMbps sets value to BandWidthMbps
func (o *InternetUpdateBandWidthRequest) SetBandWidthMbps(v int) {
	o.BandWidthMbps = v
}

/*************************************************
* InternetSubnetOperationResult
*************************************************/

// InternetSubnetOperationResult represents API parameter/response structure
type InternetSubnetOperationResult struct {
	ID             types.ID
	DefaultRoute   string
	NextHop        string
	StaticRoute    string
	NetworkAddress string
	NetworkMaskLen int
	IPAddresses    []string `mapconv:"[]IPAddresses.IPAddress"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *InternetSubnetOperationResult) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		DefaultRoute   string
		NextHop        string
		StaticRoute    string
		NetworkAddress string
		NetworkMaskLen int
		IPAddresses    []string `mapconv:"[]IPAddresses.IPAddress"`
	}{
		ID:             o.GetID(),
		DefaultRoute:   o.GetDefaultRoute(),
		NextHop:        o.GetNextHop(),
		StaticRoute:    o.GetStaticRoute(),
		NetworkAddress: o.GetNetworkAddress(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
		IPAddresses:    o.GetIPAddresses(),
	}
}

// GetID returns value of ID
func (o *InternetSubnetOperationResult) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *InternetSubnetOperationResult) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *InternetSubnetOperationResult) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *InternetSubnetOperationResult) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *InternetSubnetOperationResult) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *InternetSubnetOperationResult) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetDefaultRoute returns value of DefaultRoute
func (o *InternetSubnetOperationResult) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *InternetSubnetOperationResult) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetNextHop returns value of NextHop
func (o *InternetSubnetOperationResult) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *InternetSubnetOperationResult) SetNextHop(v string) {
	o.NextHop = v
}

// GetStaticRoute returns value of StaticRoute
func (o *InternetSubnetOperationResult) GetStaticRoute() string {
	return o.StaticRoute
}

// SetStaticRoute sets value to StaticRoute
func (o *InternetSubnetOperationResult) SetStaticRoute(v string) {
	o.StaticRoute = v
}

// GetNetworkAddress returns value of NetworkAddress
func (o *InternetSubnetOperationResult) GetNetworkAddress() string {
	return o.NetworkAddress
}

// SetNetworkAddress sets value to NetworkAddress
func (o *InternetSubnetOperationResult) SetNetworkAddress(v string) {
	o.NetworkAddress = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *InternetSubnetOperationResult) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *InternetSubnetOperationResult) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetIPAddresses returns value of IPAddresses
func (o *InternetSubnetOperationResult) GetIPAddresses() []string {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *InternetSubnetOperationResult) SetIPAddresses(v []string) {
	o.IPAddresses = v
}

/*************************************************
* InternetAddSubnetRequest
*************************************************/

// InternetAddSubnetRequest represents API parameter/response structure
type InternetAddSubnetRequest struct {
	NetworkMaskLen int
	NextHop        string
}

// setDefaults implements iaas.argumentDefaulter
func (o *InternetAddSubnetRequest) setDefaults() interface{} {
	return &struct {
		NetworkMaskLen int
		NextHop        string
	}{
		NetworkMaskLen: o.GetNetworkMaskLen(),
		NextHop:        o.GetNextHop(),
	}
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *InternetAddSubnetRequest) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *InternetAddSubnetRequest) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetNextHop returns value of NextHop
func (o *InternetAddSubnetRequest) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *InternetAddSubnetRequest) SetNextHop(v string) {
	o.NextHop = v
}

/*************************************************
* InternetUpdateSubnetRequest
*************************************************/

// InternetUpdateSubnetRequest represents API parameter/response structure
type InternetUpdateSubnetRequest struct {
	NextHop string
}

// setDefaults implements iaas.argumentDefaulter
func (o *InternetUpdateSubnetRequest) setDefaults() interface{} {
	return &struct {
		NextHop string
	}{
		NextHop: o.GetNextHop(),
	}
}

// GetNextHop returns value of NextHop
func (o *InternetUpdateSubnetRequest) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *InternetUpdateSubnetRequest) SetNextHop(v string) {
	o.NextHop = v
}

/*************************************************
* RouterActivity
*************************************************/

// RouterActivity represents API parameter/response structure
type RouterActivity struct {
	Values []*MonitorRouterValue `mapconv:"[]Router"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *RouterActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorRouterValue `mapconv:"[]Router"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *RouterActivity) GetValues() []*MonitorRouterValue {
	return o.Values
}

// SetValues sets value to Values
func (o *RouterActivity) SetValues(v []*MonitorRouterValue) {
	o.Values = v
}

/*************************************************
* MonitorRouterValue
*************************************************/

// MonitorRouterValue represents API parameter/response structure
type MonitorRouterValue struct {
	Time time.Time `mapconv:",omitempty"`
	In   float64   `mapconv:",omitempty"`
	Out  float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorRouterValue) setDefaults() interface{} {
	return &struct {
		Time time.Time `mapconv:",omitempty"`
		In   float64   `mapconv:",omitempty"`
		Out  float64   `mapconv:",omitempty"`
	}{
		Time: o.GetTime(),
		In:   o.GetIn(),
		Out:  o.GetOut(),
	}
}

// GetTime returns value of Time
func (o *MonitorRouterValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorRouterValue) SetTime(v time.Time) {
	o.Time = v
}

// GetIn returns value of In
func (o *MonitorRouterValue) GetIn() float64 {
	return o.In
}

// SetIn sets value to In
func (o *MonitorRouterValue) SetIn(v float64) {
	o.In = v
}

// GetOut returns value of Out
func (o *MonitorRouterValue) GetOut() float64 {
	return o.Out
}

// SetOut sets value to Out
func (o *MonitorRouterValue) SetOut(v float64) {
	o.Out = v
}

/*************************************************
* InternetPlan
*************************************************/

// InternetPlan represents API parameter/response structure
type InternetPlan struct {
	ID            types.ID
	Name          string
	BandWidthMbps int
	Availability  types.EAvailability
}

// setDefaults implements iaas.argumentDefaulter
func (o *InternetPlan) setDefaults() interface{} {
	return &struct {
		ID            types.ID
		Name          string
		BandWidthMbps int
		Availability  types.EAvailability
	}{
		ID:            o.GetID(),
		Name:          o.GetName(),
		BandWidthMbps: o.GetBandWidthMbps(),
		Availability:  o.GetAvailability(),
	}
}

// GetID returns value of ID
func (o *InternetPlan) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *InternetPlan) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *InternetPlan) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *InternetPlan) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *InternetPlan) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *InternetPlan) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *InternetPlan) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *InternetPlan) SetName(v string) {
	o.Name = v
}

// GetBandWidthMbps returns value of BandWidthMbps
func (o *InternetPlan) GetBandWidthMbps() int {
	return o.BandWidthMbps
}

// SetBandWidthMbps sets value to BandWidthMbps
func (o *InternetPlan) SetBandWidthMbps(v int) {
	o.BandWidthMbps = v
}

// GetAvailability returns value of Availability
func (o *InternetPlan) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *InternetPlan) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

/*************************************************
* IPAddress
*************************************************/

// IPAddress represents API parameter/response structure
type IPAddress struct {
	HostName    string
	IPAddress   string
	InterfaceID types.ID `mapconv:"Interface.ID,omitempty"`
	SubnetID    types.ID `mapconv:"Subnet.ID,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *IPAddress) setDefaults() interface{} {
	return &struct {
		HostName    string
		IPAddress   string
		InterfaceID types.ID `mapconv:"Interface.ID,omitempty"`
		SubnetID    types.ID `mapconv:"Subnet.ID,omitempty"`
	}{
		HostName:    o.GetHostName(),
		IPAddress:   o.GetIPAddress(),
		InterfaceID: o.GetInterfaceID(),
		SubnetID:    o.GetSubnetID(),
	}
}

// GetHostName returns value of HostName
func (o *IPAddress) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *IPAddress) SetHostName(v string) {
	o.HostName = v
}

// GetIPAddress returns value of IPAddress
func (o *IPAddress) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *IPAddress) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetInterfaceID returns value of InterfaceID
func (o *IPAddress) GetInterfaceID() types.ID {
	return o.InterfaceID
}

// SetInterfaceID sets value to InterfaceID
func (o *IPAddress) SetInterfaceID(v types.ID) {
	o.InterfaceID = v
}

// GetSubnetID returns value of SubnetID
func (o *IPAddress) GetSubnetID() types.ID {
	return o.SubnetID
}

// SetSubnetID sets value to SubnetID
func (o *IPAddress) SetSubnetID(v types.ID) {
	o.SubnetID = v
}

/*************************************************
* IPv6Net
*************************************************/

// IPv6Net represents API parameter/response structure
type IPv6Net struct {
	ID                 types.ID
	ServiceID          types.ID
	IPv6Prefix         string
	IPv6PrefixLen      int
	IPv6PrefixTail     string
	ServiceClass       string
	IPv6TableID        types.ID `mapconv:"IPv6Table.ID"`
	NamedIPv6AddrCount int
	CreatedAt          time.Time
	SwitchID           types.ID `mapconv:"Switch.ID,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *IPv6Net) setDefaults() interface{} {
	return &struct {
		ID                 types.ID
		ServiceID          types.ID
		IPv6Prefix         string
		IPv6PrefixLen      int
		IPv6PrefixTail     string
		ServiceClass       string
		IPv6TableID        types.ID `mapconv:"IPv6Table.ID"`
		NamedIPv6AddrCount int
		CreatedAt          time.Time
		SwitchID           types.ID `mapconv:"Switch.ID,omitempty"`
	}{
		ID:                 o.GetID(),
		ServiceID:          o.GetServiceID(),
		IPv6Prefix:         o.GetIPv6Prefix(),
		IPv6PrefixLen:      o.GetIPv6PrefixLen(),
		IPv6PrefixTail:     o.GetIPv6PrefixTail(),
		ServiceClass:       o.GetServiceClass(),
		IPv6TableID:        o.GetIPv6TableID(),
		NamedIPv6AddrCount: o.GetNamedIPv6AddrCount(),
		CreatedAt:          o.GetCreatedAt(),
		SwitchID:           o.GetSwitchID(),
	}
}

// GetID returns value of ID
func (o *IPv6Net) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *IPv6Net) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *IPv6Net) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *IPv6Net) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *IPv6Net) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *IPv6Net) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetServiceID returns value of ServiceID
func (o *IPv6Net) GetServiceID() types.ID {
	return o.ServiceID
}

// SetServiceID sets value to ServiceID
func (o *IPv6Net) SetServiceID(v types.ID) {
	o.ServiceID = v
}

// GetIPv6Prefix returns value of IPv6Prefix
func (o *IPv6Net) GetIPv6Prefix() string {
	return o.IPv6Prefix
}

// SetIPv6Prefix sets value to IPv6Prefix
func (o *IPv6Net) SetIPv6Prefix(v string) {
	o.IPv6Prefix = v
}

// GetIPv6PrefixLen returns value of IPv6PrefixLen
func (o *IPv6Net) GetIPv6PrefixLen() int {
	return o.IPv6PrefixLen
}

// SetIPv6PrefixLen sets value to IPv6PrefixLen
func (o *IPv6Net) SetIPv6PrefixLen(v int) {
	o.IPv6PrefixLen = v
}

// GetIPv6PrefixTail returns value of IPv6PrefixTail
func (o *IPv6Net) GetIPv6PrefixTail() string {
	return o.IPv6PrefixTail
}

// SetIPv6PrefixTail sets value to IPv6PrefixTail
func (o *IPv6Net) SetIPv6PrefixTail(v string) {
	o.IPv6PrefixTail = v
}

// GetServiceClass returns value of ServiceClass
func (o *IPv6Net) GetServiceClass() string {
	return o.ServiceClass
}

// SetServiceClass sets value to ServiceClass
func (o *IPv6Net) SetServiceClass(v string) {
	o.ServiceClass = v
}

// GetIPv6TableID returns value of IPv6TableID
func (o *IPv6Net) GetIPv6TableID() types.ID {
	return o.IPv6TableID
}

// SetIPv6TableID sets value to IPv6TableID
func (o *IPv6Net) SetIPv6TableID(v types.ID) {
	o.IPv6TableID = v
}

// GetNamedIPv6AddrCount returns value of NamedIPv6AddrCount
func (o *IPv6Net) GetNamedIPv6AddrCount() int {
	return o.NamedIPv6AddrCount
}

// SetNamedIPv6AddrCount sets value to NamedIPv6AddrCount
func (o *IPv6Net) SetNamedIPv6AddrCount(v int) {
	o.NamedIPv6AddrCount = v
}

// GetCreatedAt returns value of CreatedAt
func (o *IPv6Net) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *IPv6Net) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetSwitchID returns value of SwitchID
func (o *IPv6Net) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *IPv6Net) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

/*************************************************
* IPv6Addr
*************************************************/

// IPv6Addr represents API parameter/response structure
type IPv6Addr struct {
	IPv6Addr    string
	HostName    string
	IPv6NetID   types.ID `mapconv:"IPv6Net.ID"`
	SwitchID    types.ID `mapconv:"IPv6Net.Switch.ID"`
	InterfaceID types.ID `mapconv:"Interface.ID,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *IPv6Addr) setDefaults() interface{} {
	return &struct {
		IPv6Addr    string
		HostName    string
		IPv6NetID   types.ID `mapconv:"IPv6Net.ID"`
		SwitchID    types.ID `mapconv:"IPv6Net.Switch.ID"`
		InterfaceID types.ID `mapconv:"Interface.ID,omitempty"`
	}{
		IPv6Addr:    o.GetIPv6Addr(),
		HostName:    o.GetHostName(),
		IPv6NetID:   o.GetIPv6NetID(),
		SwitchID:    o.GetSwitchID(),
		InterfaceID: o.GetInterfaceID(),
	}
}

// GetIPv6Addr returns value of IPv6Addr
func (o *IPv6Addr) GetIPv6Addr() string {
	return o.IPv6Addr
}

// SetIPv6Addr sets value to IPv6Addr
func (o *IPv6Addr) SetIPv6Addr(v string) {
	o.IPv6Addr = v
}

// GetHostName returns value of HostName
func (o *IPv6Addr) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *IPv6Addr) SetHostName(v string) {
	o.HostName = v
}

// GetIPv6NetID returns value of IPv6NetID
func (o *IPv6Addr) GetIPv6NetID() types.ID {
	return o.IPv6NetID
}

// SetIPv6NetID sets value to IPv6NetID
func (o *IPv6Addr) SetIPv6NetID(v types.ID) {
	o.IPv6NetID = v
}

// GetSwitchID returns value of SwitchID
func (o *IPv6Addr) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *IPv6Addr) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetInterfaceID returns value of InterfaceID
func (o *IPv6Addr) GetInterfaceID() types.ID {
	return o.InterfaceID
}

// SetInterfaceID sets value to InterfaceID
func (o *IPv6Addr) SetInterfaceID(v types.ID) {
	o.InterfaceID = v
}

/*************************************************
* IPv6AddrCreateRequest
*************************************************/

// IPv6AddrCreateRequest represents API parameter/response structure
type IPv6AddrCreateRequest struct {
	IPv6Addr string
	HostName string
}

// setDefaults implements iaas.argumentDefaulter
func (o *IPv6AddrCreateRequest) setDefaults() interface{} {
	return &struct {
		IPv6Addr string
		HostName string
	}{
		IPv6Addr: o.GetIPv6Addr(),
		HostName: o.GetHostName(),
	}
}

// GetIPv6Addr returns value of IPv6Addr
func (o *IPv6AddrCreateRequest) GetIPv6Addr() string {
	return o.IPv6Addr
}

// SetIPv6Addr sets value to IPv6Addr
func (o *IPv6AddrCreateRequest) SetIPv6Addr(v string) {
	o.IPv6Addr = v
}

// GetHostName returns value of HostName
func (o *IPv6AddrCreateRequest) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *IPv6AddrCreateRequest) SetHostName(v string) {
	o.HostName = v
}

/*************************************************
* IPv6AddrUpdateRequest
*************************************************/

// IPv6AddrUpdateRequest represents API parameter/response structure
type IPv6AddrUpdateRequest struct {
	HostName string
}

// setDefaults implements iaas.argumentDefaulter
func (o *IPv6AddrUpdateRequest) setDefaults() interface{} {
	return &struct {
		HostName string
	}{
		HostName: o.GetHostName(),
	}
}

// GetHostName returns value of HostName
func (o *IPv6AddrUpdateRequest) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *IPv6AddrUpdateRequest) SetHostName(v string) {
	o.HostName = v
}

/*************************************************
* License
*************************************************/

// License represents API parameter/response structure
type License struct {
	ID              types.ID
	Name            string
	LicenseInfoID   types.ID `mapconv:"LicenseInfo.ID"`
	LicenseInfoName string   `mapconv:"LicenseInfo.Name"`
	CreatedAt       time.Time
	ModifiedAt      time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *License) setDefaults() interface{} {
	return &struct {
		ID              types.ID
		Name            string
		LicenseInfoID   types.ID `mapconv:"LicenseInfo.ID"`
		LicenseInfoName string   `mapconv:"LicenseInfo.Name"`
		CreatedAt       time.Time
		ModifiedAt      time.Time
	}{
		ID:              o.GetID(),
		Name:            o.GetName(),
		LicenseInfoID:   o.GetLicenseInfoID(),
		LicenseInfoName: o.GetLicenseInfoName(),
		CreatedAt:       o.GetCreatedAt(),
		ModifiedAt:      o.GetModifiedAt(),
	}
}

// GetID returns value of ID
func (o *License) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *License) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *License) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *License) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *License) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *License) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *License) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *License) SetName(v string) {
	o.Name = v
}

// GetLicenseInfoID returns value of LicenseInfoID
func (o *License) GetLicenseInfoID() types.ID {
	return o.LicenseInfoID
}

// SetLicenseInfoID sets value to LicenseInfoID
func (o *License) SetLicenseInfoID(v types.ID) {
	o.LicenseInfoID = v
}

// GetLicenseInfoName returns value of LicenseInfoName
func (o *License) GetLicenseInfoName() string {
	return o.LicenseInfoName
}

// SetLicenseInfoName sets value to LicenseInfoName
func (o *License) SetLicenseInfoName(v string) {
	o.LicenseInfoName = v
}

// GetCreatedAt returns value of CreatedAt
func (o *License) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *License) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *License) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *License) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* LicenseCreateRequest
*************************************************/

// LicenseCreateRequest represents API parameter/response structure
type LicenseCreateRequest struct {
	Name          string
	LicenseInfoID types.ID `mapconv:"LicenseInfo.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LicenseCreateRequest) setDefaults() interface{} {
	return &struct {
		Name          string
		LicenseInfoID types.ID `mapconv:"LicenseInfo.ID"`
	}{
		Name:          o.GetName(),
		LicenseInfoID: o.GetLicenseInfoID(),
	}
}

// GetName returns value of Name
func (o *LicenseCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LicenseCreateRequest) SetName(v string) {
	o.Name = v
}

// GetLicenseInfoID returns value of LicenseInfoID
func (o *LicenseCreateRequest) GetLicenseInfoID() types.ID {
	return o.LicenseInfoID
}

// SetLicenseInfoID sets value to LicenseInfoID
func (o *LicenseCreateRequest) SetLicenseInfoID(v types.ID) {
	o.LicenseInfoID = v
}

/*************************************************
* LicenseUpdateRequest
*************************************************/

// LicenseUpdateRequest represents API parameter/response structure
type LicenseUpdateRequest struct {
	Name string
}

// setDefaults implements iaas.argumentDefaulter
func (o *LicenseUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name string
	}{
		Name: o.GetName(),
	}
}

// GetName returns value of Name
func (o *LicenseUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LicenseUpdateRequest) SetName(v string) {
	o.Name = v
}

/*************************************************
* LicenseInfo
*************************************************/

// LicenseInfo represents API parameter/response structure
type LicenseInfo struct {
	ID         types.ID
	Name       string
	CreatedAt  time.Time
	ModifiedAt time.Time
	TermsOfUse string
}

// setDefaults implements iaas.argumentDefaulter
func (o *LicenseInfo) setDefaults() interface{} {
	return &struct {
		ID         types.ID
		Name       string
		CreatedAt  time.Time
		ModifiedAt time.Time
		TermsOfUse string
	}{
		ID:         o.GetID(),
		Name:       o.GetName(),
		CreatedAt:  o.GetCreatedAt(),
		ModifiedAt: o.GetModifiedAt(),
		TermsOfUse: o.GetTermsOfUse(),
	}
}

// GetID returns value of ID
func (o *LicenseInfo) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *LicenseInfo) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *LicenseInfo) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *LicenseInfo) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *LicenseInfo) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *LicenseInfo) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *LicenseInfo) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LicenseInfo) SetName(v string) {
	o.Name = v
}

// GetCreatedAt returns value of CreatedAt
func (o *LicenseInfo) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *LicenseInfo) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *LicenseInfo) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *LicenseInfo) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetTermsOfUse returns value of TermsOfUse
func (o *LicenseInfo) GetTermsOfUse() string {
	return o.TermsOfUse
}

// SetTermsOfUse sets value to TermsOfUse
func (o *LicenseInfo) SetTermsOfUse(v string) {
	o.TermsOfUse = v
}

/*************************************************
* LoadBalancer
*************************************************/

// LoadBalancer represents API parameter/response structure
type LoadBalancer struct {
	ID                      types.ID
	Name                    string
	Description             string
	Tags                    types.Tags
	Availability            types.EAvailability
	Class                   string
	IconID                  types.ID `mapconv:"Icon.ID"`
	CreatedAt               time.Time
	ModifiedAt              time.Time
	InstanceHostName        string                         `mapconv:"Instance.Host.Name"`
	InstanceHostInfoURL     string                         `mapconv:"Instance.Host.InfoURL"`
	InstanceStatus          types.EServerInstanceStatus    `mapconv:"Instance.Status"`
	InstanceStatusChangedAt time.Time                      `mapconv:"Instance.StatusChangedAt"`
	PlanID                  types.ID                       `mapconv:"Remark.Plan.ID/Plan.ID"`
	SwitchID                types.ID                       `mapconv:"Remark.Switch.ID"`
	DefaultRoute            string                         `mapconv:"Remark.Network.DefaultRoute"`
	NetworkMaskLen          int                            `mapconv:"Remark.Network.NetworkMaskLen"`
	IPAddresses             []string                       `mapconv:"Remark.[]Servers.IPAddress"`
	ZoneID                  types.ID                       `mapconv:"Remark.Zone.ID"`
	VRID                    int                            `mapconv:"Remark.VRRP.VRID"`
	VirtualIPAddresses      LoadBalancerVirtualIPAddresses `mapconv:"Settings.[]LoadBalancer,recursive"`
	SettingsHash            string                         `json:",omitempty" mapconv:",omitempty"`
	Interfaces              []*InterfaceView               `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancer) setDefaults() interface{} {
	return &struct {
		ID                      types.ID
		Name                    string
		Description             string
		Tags                    types.Tags
		Availability            types.EAvailability
		Class                   string
		IconID                  types.ID `mapconv:"Icon.ID"`
		CreatedAt               time.Time
		ModifiedAt              time.Time
		InstanceHostName        string                         `mapconv:"Instance.Host.Name"`
		InstanceHostInfoURL     string                         `mapconv:"Instance.Host.InfoURL"`
		InstanceStatus          types.EServerInstanceStatus    `mapconv:"Instance.Status"`
		InstanceStatusChangedAt time.Time                      `mapconv:"Instance.StatusChangedAt"`
		PlanID                  types.ID                       `mapconv:"Remark.Plan.ID/Plan.ID"`
		SwitchID                types.ID                       `mapconv:"Remark.Switch.ID"`
		DefaultRoute            string                         `mapconv:"Remark.Network.DefaultRoute"`
		NetworkMaskLen          int                            `mapconv:"Remark.Network.NetworkMaskLen"`
		IPAddresses             []string                       `mapconv:"Remark.[]Servers.IPAddress"`
		ZoneID                  types.ID                       `mapconv:"Remark.Zone.ID"`
		VRID                    int                            `mapconv:"Remark.VRRP.VRID"`
		VirtualIPAddresses      LoadBalancerVirtualIPAddresses `mapconv:"Settings.[]LoadBalancer,recursive"`
		SettingsHash            string                         `json:",omitempty" mapconv:",omitempty"`
		Interfaces              []*InterfaceView               `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
	}{
		ID:                      o.GetID(),
		Name:                    o.GetName(),
		Description:             o.GetDescription(),
		Tags:                    o.GetTags(),
		Availability:            o.GetAvailability(),
		Class:                   o.GetClass(),
		IconID:                  o.GetIconID(),
		CreatedAt:               o.GetCreatedAt(),
		ModifiedAt:              o.GetModifiedAt(),
		InstanceHostName:        o.GetInstanceHostName(),
		InstanceHostInfoURL:     o.GetInstanceHostInfoURL(),
		InstanceStatus:          o.GetInstanceStatus(),
		InstanceStatusChangedAt: o.GetInstanceStatusChangedAt(),
		PlanID:                  o.GetPlanID(),
		SwitchID:                o.GetSwitchID(),
		DefaultRoute:            o.GetDefaultRoute(),
		NetworkMaskLen:          o.GetNetworkMaskLen(),
		IPAddresses:             o.GetIPAddresses(),
		ZoneID:                  o.GetZoneID(),
		VRID:                    o.GetVRID(),
		VirtualIPAddresses:      o.GetVirtualIPAddresses(),
		SettingsHash:            o.GetSettingsHash(),
		Interfaces:              o.GetInterfaces(),
	}
}

// GetID returns value of ID
func (o *LoadBalancer) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *LoadBalancer) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *LoadBalancer) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *LoadBalancer) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *LoadBalancer) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *LoadBalancer) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *LoadBalancer) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LoadBalancer) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *LoadBalancer) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *LoadBalancer) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *LoadBalancer) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *LoadBalancer) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *LoadBalancer) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *LoadBalancer) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *LoadBalancer) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *LoadBalancer) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *LoadBalancer) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *LoadBalancer) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetClass returns value of Class
func (o *LoadBalancer) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *LoadBalancer) SetClass(v string) {
	o.Class = v
}

// GetIconID returns value of IconID
func (o *LoadBalancer) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *LoadBalancer) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *LoadBalancer) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *LoadBalancer) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *LoadBalancer) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *LoadBalancer) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetInstanceHostName returns value of InstanceHostName
func (o *LoadBalancer) GetInstanceHostName() string {
	return o.InstanceHostName
}

// SetInstanceHostName sets value to InstanceHostName
func (o *LoadBalancer) SetInstanceHostName(v string) {
	o.InstanceHostName = v
}

// GetInstanceHostInfoURL returns value of InstanceHostInfoURL
func (o *LoadBalancer) GetInstanceHostInfoURL() string {
	return o.InstanceHostInfoURL
}

// SetInstanceHostInfoURL sets value to InstanceHostInfoURL
func (o *LoadBalancer) SetInstanceHostInfoURL(v string) {
	o.InstanceHostInfoURL = v
}

// GetInstanceStatus returns value of InstanceStatus
func (o *LoadBalancer) GetInstanceStatus() types.EServerInstanceStatus {
	return o.InstanceStatus
}

// SetInstanceStatus sets value to InstanceStatus
func (o *LoadBalancer) SetInstanceStatus(v types.EServerInstanceStatus) {
	o.InstanceStatus = v
}

// GetInstanceStatusChangedAt returns value of InstanceStatusChangedAt
func (o *LoadBalancer) GetInstanceStatusChangedAt() time.Time {
	return o.InstanceStatusChangedAt
}

// SetInstanceStatusChangedAt sets value to InstanceStatusChangedAt
func (o *LoadBalancer) SetInstanceStatusChangedAt(v time.Time) {
	o.InstanceStatusChangedAt = v
}

// GetPlanID returns value of PlanID
func (o *LoadBalancer) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *LoadBalancer) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetSwitchID returns value of SwitchID
func (o *LoadBalancer) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *LoadBalancer) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *LoadBalancer) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *LoadBalancer) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *LoadBalancer) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *LoadBalancer) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetIPAddresses returns value of IPAddresses
func (o *LoadBalancer) GetIPAddresses() []string {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *LoadBalancer) SetIPAddresses(v []string) {
	o.IPAddresses = v
}

// GetZoneID returns value of ZoneID
func (o *LoadBalancer) GetZoneID() types.ID {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *LoadBalancer) SetZoneID(v types.ID) {
	o.ZoneID = v
}

// GetVRID returns value of VRID
func (o *LoadBalancer) GetVRID() int {
	return o.VRID
}

// SetVRID sets value to VRID
func (o *LoadBalancer) SetVRID(v int) {
	o.VRID = v
}

// GetVirtualIPAddresses returns value of VirtualIPAddresses
func (o *LoadBalancer) GetVirtualIPAddresses() LoadBalancerVirtualIPAddresses {
	return o.VirtualIPAddresses
}

// SetVirtualIPAddresses sets value to VirtualIPAddresses
func (o *LoadBalancer) SetVirtualIPAddresses(v LoadBalancerVirtualIPAddresses) {
	o.VirtualIPAddresses = v
}

// GetSettingsHash returns value of SettingsHash
func (o *LoadBalancer) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *LoadBalancer) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetInterfaces returns value of Interfaces
func (o *LoadBalancer) GetInterfaces() []*InterfaceView {
	return o.Interfaces
}

// SetInterfaces sets value to Interfaces
func (o *LoadBalancer) SetInterfaces(v []*InterfaceView) {
	o.Interfaces = v
}

/*************************************************
* LoadBalancerVirtualIPAddress
*************************************************/

// LoadBalancerVirtualIPAddress represents API parameter/response structure
type LoadBalancerVirtualIPAddress struct {
	VirtualIPAddress string
	Port             types.StringNumber
	DelayLoop        types.StringNumber `mapconv:",default=10"`
	SorryServer      string
	Description      string
	Servers          LoadBalancerServers `mapconv:"[]Servers,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancerVirtualIPAddress) setDefaults() interface{} {
	return &struct {
		VirtualIPAddress string
		Port             types.StringNumber
		DelayLoop        types.StringNumber `mapconv:",default=10"`
		SorryServer      string
		Description      string
		Servers          LoadBalancerServers `mapconv:"[]Servers,recursive"`
	}{
		VirtualIPAddress: o.GetVirtualIPAddress(),
		Port:             o.GetPort(),
		DelayLoop:        o.GetDelayLoop(),
		SorryServer:      o.GetSorryServer(),
		Description:      o.GetDescription(),
		Servers:          o.GetServers(),
	}
}

// GetVirtualIPAddress returns value of VirtualIPAddress
func (o *LoadBalancerVirtualIPAddress) GetVirtualIPAddress() string {
	return o.VirtualIPAddress
}

// SetVirtualIPAddress sets value to VirtualIPAddress
func (o *LoadBalancerVirtualIPAddress) SetVirtualIPAddress(v string) {
	o.VirtualIPAddress = v
}

// GetPort returns value of Port
func (o *LoadBalancerVirtualIPAddress) GetPort() types.StringNumber {
	return o.Port
}

// SetPort sets value to Port
func (o *LoadBalancerVirtualIPAddress) SetPort(v types.StringNumber) {
	o.Port = v
}

// GetDelayLoop returns value of DelayLoop
func (o *LoadBalancerVirtualIPAddress) GetDelayLoop() types.StringNumber {
	if o.DelayLoop == types.StringNumber(float64(0)) {
		return 10
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *LoadBalancerVirtualIPAddress) SetDelayLoop(v types.StringNumber) {
	o.DelayLoop = v
}

// GetSorryServer returns value of SorryServer
func (o *LoadBalancerVirtualIPAddress) GetSorryServer() string {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *LoadBalancerVirtualIPAddress) SetSorryServer(v string) {
	o.SorryServer = v
}

// GetDescription returns value of Description
func (o *LoadBalancerVirtualIPAddress) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *LoadBalancerVirtualIPAddress) SetDescription(v string) {
	o.Description = v
}

// GetServers returns value of Servers
func (o *LoadBalancerVirtualIPAddress) GetServers() LoadBalancerServers {
	return o.Servers
}

// SetServers sets value to Servers
func (o *LoadBalancerVirtualIPAddress) SetServers(v LoadBalancerServers) {
	o.Servers = v
}

/*************************************************
* LoadBalancerServer
*************************************************/

// LoadBalancerServer represents API parameter/response structure
type LoadBalancerServer struct {
	IPAddress   string
	Port        types.StringNumber
	Enabled     types.StringFlag
	HealthCheck *LoadBalancerServerHealthCheck `mapconv:"HealthCheck,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancerServer) setDefaults() interface{} {
	return &struct {
		IPAddress   string
		Port        types.StringNumber
		Enabled     types.StringFlag
		HealthCheck *LoadBalancerServerHealthCheck `mapconv:"HealthCheck,recursive"`
	}{
		IPAddress:   o.GetIPAddress(),
		Port:        o.GetPort(),
		Enabled:     o.GetEnabled(),
		HealthCheck: o.GetHealthCheck(),
	}
}

// GetIPAddress returns value of IPAddress
func (o *LoadBalancerServer) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *LoadBalancerServer) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetPort returns value of Port
func (o *LoadBalancerServer) GetPort() types.StringNumber {
	return o.Port
}

// SetPort sets value to Port
func (o *LoadBalancerServer) SetPort(v types.StringNumber) {
	o.Port = v
}

// GetEnabled returns value of Enabled
func (o *LoadBalancerServer) GetEnabled() types.StringFlag {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *LoadBalancerServer) SetEnabled(v types.StringFlag) {
	o.Enabled = v
}

// GetHealthCheck returns value of HealthCheck
func (o *LoadBalancerServer) GetHealthCheck() *LoadBalancerServerHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *LoadBalancerServer) SetHealthCheck(v *LoadBalancerServerHealthCheck) {
	o.HealthCheck = v
}

/*************************************************
* LoadBalancerServerHealthCheck
*************************************************/

// LoadBalancerServerHealthCheck represents API parameter/response structure
type LoadBalancerServerHealthCheck struct {
	Protocol       types.ELoadBalancerHealthCheckProtocol
	Path           string
	ResponseCode   types.StringNumber `mapconv:"Status"`
	Retry          types.StringNumber
	ConnectTimeout types.StringNumber
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancerServerHealthCheck) setDefaults() interface{} {
	return &struct {
		Protocol       types.ELoadBalancerHealthCheckProtocol
		Path           string
		ResponseCode   types.StringNumber `mapconv:"Status"`
		Retry          types.StringNumber
		ConnectTimeout types.StringNumber
	}{
		Protocol:       o.GetProtocol(),
		Path:           o.GetPath(),
		ResponseCode:   o.GetResponseCode(),
		Retry:          o.GetRetry(),
		ConnectTimeout: o.GetConnectTimeout(),
	}
}

// GetProtocol returns value of Protocol
func (o *LoadBalancerServerHealthCheck) GetProtocol() types.ELoadBalancerHealthCheckProtocol {
	return o.Protocol
}

// SetProtocol sets value to Protocol
func (o *LoadBalancerServerHealthCheck) SetProtocol(v types.ELoadBalancerHealthCheckProtocol) {
	o.Protocol = v
}

// GetPath returns value of Path
func (o *LoadBalancerServerHealthCheck) GetPath() string {
	return o.Path
}

// SetPath sets value to Path
func (o *LoadBalancerServerHealthCheck) SetPath(v string) {
	o.Path = v
}

// GetResponseCode returns value of ResponseCode
func (o *LoadBalancerServerHealthCheck) GetResponseCode() types.StringNumber {
	return o.ResponseCode
}

// SetResponseCode sets value to ResponseCode
func (o *LoadBalancerServerHealthCheck) SetResponseCode(v types.StringNumber) {
	o.ResponseCode = v
}

// GetRetry returns value of Retry
func (o *LoadBalancerServerHealthCheck) GetRetry() types.StringNumber {
	return o.Retry
}

// SetRetry sets value to Retry
func (o *LoadBalancerServerHealthCheck) SetRetry(v types.StringNumber) {
	o.Retry = v
}

// GetConnectTimeout returns value of ConnectTimeout
func (o *LoadBalancerServerHealthCheck) GetConnectTimeout() types.StringNumber {
	return o.ConnectTimeout
}

// SetConnectTimeout sets value to ConnectTimeout
func (o *LoadBalancerServerHealthCheck) SetConnectTimeout(v types.StringNumber) {
	o.ConnectTimeout = v
}

/*************************************************
* LoadBalancerCreateRequest
*************************************************/

// LoadBalancerCreateRequest represents API parameter/response structure
type LoadBalancerCreateRequest struct {
	SwitchID           types.ID `mapconv:"Remark.Switch.ID"`
	PlanID             types.ID `mapconv:"Remark.Plan.ID/Plan.ID"`
	VRID               int      `mapconv:"Remark.VRRP.VRID"`
	IPAddresses        []string `mapconv:"Remark.[]Servers.IPAddress"`
	NetworkMaskLen     int      `mapconv:"Remark.Network.NetworkMaskLen"`
	DefaultRoute       string   `mapconv:"Remark.Network.DefaultRoute"`
	Name               string
	Description        string
	Tags               types.Tags
	IconID             types.ID                       `mapconv:"Icon.ID"`
	VirtualIPAddresses LoadBalancerVirtualIPAddresses `mapconv:"Settings.[]LoadBalancer,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancerCreateRequest) setDefaults() interface{} {
	return &struct {
		SwitchID           types.ID `mapconv:"Remark.Switch.ID"`
		PlanID             types.ID `mapconv:"Remark.Plan.ID/Plan.ID"`
		VRID               int      `mapconv:"Remark.VRRP.VRID"`
		IPAddresses        []string `mapconv:"Remark.[]Servers.IPAddress"`
		NetworkMaskLen     int      `mapconv:"Remark.Network.NetworkMaskLen"`
		DefaultRoute       string   `mapconv:"Remark.Network.DefaultRoute"`
		Name               string
		Description        string
		Tags               types.Tags
		IconID             types.ID                       `mapconv:"Icon.ID"`
		VirtualIPAddresses LoadBalancerVirtualIPAddresses `mapconv:"Settings.[]LoadBalancer,recursive"`
		Class              string
	}{
		SwitchID:           o.GetSwitchID(),
		PlanID:             o.GetPlanID(),
		VRID:               o.GetVRID(),
		IPAddresses:        o.GetIPAddresses(),
		NetworkMaskLen:     o.GetNetworkMaskLen(),
		DefaultRoute:       o.GetDefaultRoute(),
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		VirtualIPAddresses: o.GetVirtualIPAddresses(),
		Class:              "loadbalancer",
	}
}

// GetSwitchID returns value of SwitchID
func (o *LoadBalancerCreateRequest) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *LoadBalancerCreateRequest) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetPlanID returns value of PlanID
func (o *LoadBalancerCreateRequest) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *LoadBalancerCreateRequest) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetVRID returns value of VRID
func (o *LoadBalancerCreateRequest) GetVRID() int {
	return o.VRID
}

// SetVRID sets value to VRID
func (o *LoadBalancerCreateRequest) SetVRID(v int) {
	o.VRID = v
}

// GetIPAddresses returns value of IPAddresses
func (o *LoadBalancerCreateRequest) GetIPAddresses() []string {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *LoadBalancerCreateRequest) SetIPAddresses(v []string) {
	o.IPAddresses = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *LoadBalancerCreateRequest) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *LoadBalancerCreateRequest) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *LoadBalancerCreateRequest) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *LoadBalancerCreateRequest) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetName returns value of Name
func (o *LoadBalancerCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LoadBalancerCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *LoadBalancerCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *LoadBalancerCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *LoadBalancerCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *LoadBalancerCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *LoadBalancerCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *LoadBalancerCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *LoadBalancerCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *LoadBalancerCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *LoadBalancerCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *LoadBalancerCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetVirtualIPAddresses returns value of VirtualIPAddresses
func (o *LoadBalancerCreateRequest) GetVirtualIPAddresses() LoadBalancerVirtualIPAddresses {
	return o.VirtualIPAddresses
}

// SetVirtualIPAddresses sets value to VirtualIPAddresses
func (o *LoadBalancerCreateRequest) SetVirtualIPAddresses(v LoadBalancerVirtualIPAddresses) {
	o.VirtualIPAddresses = v
}

/*************************************************
* LoadBalancerUpdateRequest
*************************************************/

// LoadBalancerUpdateRequest represents API parameter/response structure
type LoadBalancerUpdateRequest struct {
	Name               string
	Description        string
	Tags               types.Tags
	IconID             types.ID                       `mapconv:"Icon.ID"`
	VirtualIPAddresses LoadBalancerVirtualIPAddresses `mapconv:"Settings.[]LoadBalancer,recursive"`
	SettingsHash       string                         `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancerUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name               string
		Description        string
		Tags               types.Tags
		IconID             types.ID                       `mapconv:"Icon.ID"`
		VirtualIPAddresses LoadBalancerVirtualIPAddresses `mapconv:"Settings.[]LoadBalancer,recursive"`
		SettingsHash       string                         `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		VirtualIPAddresses: o.GetVirtualIPAddresses(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *LoadBalancerUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LoadBalancerUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *LoadBalancerUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *LoadBalancerUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *LoadBalancerUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *LoadBalancerUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *LoadBalancerUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *LoadBalancerUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *LoadBalancerUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *LoadBalancerUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *LoadBalancerUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *LoadBalancerUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetVirtualIPAddresses returns value of VirtualIPAddresses
func (o *LoadBalancerUpdateRequest) GetVirtualIPAddresses() LoadBalancerVirtualIPAddresses {
	return o.VirtualIPAddresses
}

// SetVirtualIPAddresses sets value to VirtualIPAddresses
func (o *LoadBalancerUpdateRequest) SetVirtualIPAddresses(v LoadBalancerVirtualIPAddresses) {
	o.VirtualIPAddresses = v
}

// GetSettingsHash returns value of SettingsHash
func (o *LoadBalancerUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *LoadBalancerUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* LoadBalancerUpdateSettingsRequest
*************************************************/

// LoadBalancerUpdateSettingsRequest represents API parameter/response structure
type LoadBalancerUpdateSettingsRequest struct {
	VirtualIPAddresses LoadBalancerVirtualIPAddresses `mapconv:"Settings.[]LoadBalancer,recursive"`
	SettingsHash       string                         `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancerUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		VirtualIPAddresses LoadBalancerVirtualIPAddresses `mapconv:"Settings.[]LoadBalancer,recursive"`
		SettingsHash       string                         `json:",omitempty" mapconv:",omitempty"`
	}{
		VirtualIPAddresses: o.GetVirtualIPAddresses(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetVirtualIPAddresses returns value of VirtualIPAddresses
func (o *LoadBalancerUpdateSettingsRequest) GetVirtualIPAddresses() LoadBalancerVirtualIPAddresses {
	return o.VirtualIPAddresses
}

// SetVirtualIPAddresses sets value to VirtualIPAddresses
func (o *LoadBalancerUpdateSettingsRequest) SetVirtualIPAddresses(v LoadBalancerVirtualIPAddresses) {
	o.VirtualIPAddresses = v
}

// GetSettingsHash returns value of SettingsHash
func (o *LoadBalancerUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *LoadBalancerUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* LoadBalancerStatus
*************************************************/

// LoadBalancerStatus represents API parameter/response structure
type LoadBalancerStatus struct {
	VirtualIPAddress string
	Port             types.StringNumber
	CPS              types.StringNumber
	Servers          []*LoadBalancerServerStatus `mapconv:",recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancerStatus) setDefaults() interface{} {
	return &struct {
		VirtualIPAddress string
		Port             types.StringNumber
		CPS              types.StringNumber
		Servers          []*LoadBalancerServerStatus `mapconv:",recursive"`
	}{
		VirtualIPAddress: o.GetVirtualIPAddress(),
		Port:             o.GetPort(),
		CPS:              o.GetCPS(),
		Servers:          o.GetServers(),
	}
}

// GetVirtualIPAddress returns value of VirtualIPAddress
func (o *LoadBalancerStatus) GetVirtualIPAddress() string {
	return o.VirtualIPAddress
}

// SetVirtualIPAddress sets value to VirtualIPAddress
func (o *LoadBalancerStatus) SetVirtualIPAddress(v string) {
	o.VirtualIPAddress = v
}

// GetPort returns value of Port
func (o *LoadBalancerStatus) GetPort() types.StringNumber {
	return o.Port
}

// SetPort sets value to Port
func (o *LoadBalancerStatus) SetPort(v types.StringNumber) {
	o.Port = v
}

// GetCPS returns value of CPS
func (o *LoadBalancerStatus) GetCPS() types.StringNumber {
	return o.CPS
}

// SetCPS sets value to CPS
func (o *LoadBalancerStatus) SetCPS(v types.StringNumber) {
	o.CPS = v
}

// GetServers returns value of Servers
func (o *LoadBalancerStatus) GetServers() []*LoadBalancerServerStatus {
	return o.Servers
}

// SetServers sets value to Servers
func (o *LoadBalancerStatus) SetServers(v []*LoadBalancerServerStatus) {
	o.Servers = v
}

/*************************************************
* LoadBalancerServerStatus
*************************************************/

// LoadBalancerServerStatus represents API parameter/response structure
type LoadBalancerServerStatus struct {
	ActiveConn types.StringNumber
	Status     types.EServerInstanceStatus
	IPAddress  string
	Port       types.StringNumber
	CPS        types.StringNumber
}

// setDefaults implements iaas.argumentDefaulter
func (o *LoadBalancerServerStatus) setDefaults() interface{} {
	return &struct {
		ActiveConn types.StringNumber
		Status     types.EServerInstanceStatus
		IPAddress  string
		Port       types.StringNumber
		CPS        types.StringNumber
	}{
		ActiveConn: o.GetActiveConn(),
		Status:     o.GetStatus(),
		IPAddress:  o.GetIPAddress(),
		Port:       o.GetPort(),
		CPS:        o.GetCPS(),
	}
}

// GetActiveConn returns value of ActiveConn
func (o *LoadBalancerServerStatus) GetActiveConn() types.StringNumber {
	return o.ActiveConn
}

// SetActiveConn sets value to ActiveConn
func (o *LoadBalancerServerStatus) SetActiveConn(v types.StringNumber) {
	o.ActiveConn = v
}

// GetStatus returns value of Status
func (o *LoadBalancerServerStatus) GetStatus() types.EServerInstanceStatus {
	return o.Status
}

// SetStatus sets value to Status
func (o *LoadBalancerServerStatus) SetStatus(v types.EServerInstanceStatus) {
	o.Status = v
}

// GetIPAddress returns value of IPAddress
func (o *LoadBalancerServerStatus) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *LoadBalancerServerStatus) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetPort returns value of Port
func (o *LoadBalancerServerStatus) GetPort() types.StringNumber {
	return o.Port
}

// SetPort sets value to Port
func (o *LoadBalancerServerStatus) SetPort(v types.StringNumber) {
	o.Port = v
}

// GetCPS returns value of CPS
func (o *LoadBalancerServerStatus) GetCPS() types.StringNumber {
	return o.CPS
}

// SetCPS sets value to CPS
func (o *LoadBalancerServerStatus) SetCPS(v types.StringNumber) {
	o.CPS = v
}

/*************************************************
* LocalRouter
*************************************************/

// LocalRouter represents API parameter/response structure
type LocalRouter struct {
	ID           types.ID
	Name         string
	Description  string
	Tags         types.Tags
	Availability types.EAvailability
	IconID       types.ID `mapconv:"Icon.ID"`
	CreatedAt    time.Time
	ModifiedAt   time.Time
	Switch       *LocalRouterSwitch        `mapconv:"Settings.LocalRouter.Switch,recursive"`
	Interface    *LocalRouterInterface     `mapconv:"Settings.LocalRouter.Interface,recursive"`
	Peers        []*LocalRouterPeer        `mapconv:"Settings.LocalRouter.[]Peers,recursive"`
	StaticRoutes []*LocalRouterStaticRoute `mapconv:"Settings.LocalRouter.[]StaticRoutes,recursive"`
	SettingsHash string                    `json:",omitempty" mapconv:",omitempty"`
	SecretKeys   []string                  `mapconv:"Status.SecretKeys"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouter) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		Tags         types.Tags
		Availability types.EAvailability
		IconID       types.ID `mapconv:"Icon.ID"`
		CreatedAt    time.Time
		ModifiedAt   time.Time
		Switch       *LocalRouterSwitch        `mapconv:"Settings.LocalRouter.Switch,recursive"`
		Interface    *LocalRouterInterface     `mapconv:"Settings.LocalRouter.Interface,recursive"`
		Peers        []*LocalRouterPeer        `mapconv:"Settings.LocalRouter.[]Peers,recursive"`
		StaticRoutes []*LocalRouterStaticRoute `mapconv:"Settings.LocalRouter.[]StaticRoutes,recursive"`
		SettingsHash string                    `json:",omitempty" mapconv:",omitempty"`
		SecretKeys   []string                  `mapconv:"Status.SecretKeys"`
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		IconID:       o.GetIconID(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
		Switch:       o.GetSwitch(),
		Interface:    o.GetInterface(),
		Peers:        o.GetPeers(),
		StaticRoutes: o.GetStaticRoutes(),
		SettingsHash: o.GetSettingsHash(),
		SecretKeys:   o.GetSecretKeys(),
	}
}

// GetID returns value of ID
func (o *LocalRouter) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *LocalRouter) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *LocalRouter) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *LocalRouter) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *LocalRouter) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *LocalRouter) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *LocalRouter) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LocalRouter) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *LocalRouter) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *LocalRouter) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *LocalRouter) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *LocalRouter) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *LocalRouter) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *LocalRouter) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *LocalRouter) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *LocalRouter) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *LocalRouter) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *LocalRouter) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *LocalRouter) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *LocalRouter) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *LocalRouter) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *LocalRouter) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *LocalRouter) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *LocalRouter) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetSwitch returns value of Switch
func (o *LocalRouter) GetSwitch() *LocalRouterSwitch {
	return o.Switch
}

// SetSwitch sets value to Switch
func (o *LocalRouter) SetSwitch(v *LocalRouterSwitch) {
	o.Switch = v
}

// GetInterface returns value of Interface
func (o *LocalRouter) GetInterface() *LocalRouterInterface {
	return o.Interface
}

// SetInterface sets value to Interface
func (o *LocalRouter) SetInterface(v *LocalRouterInterface) {
	o.Interface = v
}

// GetPeers returns value of Peers
func (o *LocalRouter) GetPeers() []*LocalRouterPeer {
	return o.Peers
}

// SetPeers sets value to Peers
func (o *LocalRouter) SetPeers(v []*LocalRouterPeer) {
	o.Peers = v
}

// GetStaticRoutes returns value of StaticRoutes
func (o *LocalRouter) GetStaticRoutes() []*LocalRouterStaticRoute {
	return o.StaticRoutes
}

// SetStaticRoutes sets value to StaticRoutes
func (o *LocalRouter) SetStaticRoutes(v []*LocalRouterStaticRoute) {
	o.StaticRoutes = v
}

// GetSettingsHash returns value of SettingsHash
func (o *LocalRouter) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *LocalRouter) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetSecretKeys returns value of SecretKeys
func (o *LocalRouter) GetSecretKeys() []string {
	return o.SecretKeys
}

// SetSecretKeys sets value to SecretKeys
func (o *LocalRouter) SetSecretKeys(v []string) {
	o.SecretKeys = v
}

/*************************************************
* LocalRouterSwitch
*************************************************/

// LocalRouterSwitch represents API parameter/response structure
type LocalRouterSwitch struct {
	Code     string
	Category string
	ZoneID   string
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterSwitch) setDefaults() interface{} {
	return &struct {
		Code     string
		Category string
		ZoneID   string
	}{
		Code:     o.GetCode(),
		Category: o.GetCategory(),
		ZoneID:   o.GetZoneID(),
	}
}

// GetCode returns value of Code
func (o *LocalRouterSwitch) GetCode() string {
	return o.Code
}

// SetCode sets value to Code
func (o *LocalRouterSwitch) SetCode(v string) {
	o.Code = v
}

// GetCategory returns value of Category
func (o *LocalRouterSwitch) GetCategory() string {
	return o.Category
}

// SetCategory sets value to Category
func (o *LocalRouterSwitch) SetCategory(v string) {
	o.Category = v
}

// GetZoneID returns value of ZoneID
func (o *LocalRouterSwitch) GetZoneID() string {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *LocalRouterSwitch) SetZoneID(v string) {
	o.ZoneID = v
}

/*************************************************
* LocalRouterInterface
*************************************************/

// LocalRouterInterface represents API parameter/response structure
type LocalRouterInterface struct {
	VirtualIPAddress string
	IPAddress        []string
	NetworkMaskLen   int
	VRID             int
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterInterface) setDefaults() interface{} {
	return &struct {
		VirtualIPAddress string
		IPAddress        []string
		NetworkMaskLen   int
		VRID             int
	}{
		VirtualIPAddress: o.GetVirtualIPAddress(),
		IPAddress:        o.GetIPAddress(),
		NetworkMaskLen:   o.GetNetworkMaskLen(),
		VRID:             o.GetVRID(),
	}
}

// GetVirtualIPAddress returns value of VirtualIPAddress
func (o *LocalRouterInterface) GetVirtualIPAddress() string {
	return o.VirtualIPAddress
}

// SetVirtualIPAddress sets value to VirtualIPAddress
func (o *LocalRouterInterface) SetVirtualIPAddress(v string) {
	o.VirtualIPAddress = v
}

// GetIPAddress returns value of IPAddress
func (o *LocalRouterInterface) GetIPAddress() []string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *LocalRouterInterface) SetIPAddress(v []string) {
	o.IPAddress = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *LocalRouterInterface) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *LocalRouterInterface) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetVRID returns value of VRID
func (o *LocalRouterInterface) GetVRID() int {
	return o.VRID
}

// SetVRID sets value to VRID
func (o *LocalRouterInterface) SetVRID(v int) {
	o.VRID = v
}

/*************************************************
* LocalRouterPeer
*************************************************/

// LocalRouterPeer represents API parameter/response structure
type LocalRouterPeer struct {
	ID          types.ID
	SecretKey   string
	Enabled     bool
	Description string
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterPeer) setDefaults() interface{} {
	return &struct {
		ID          types.ID
		SecretKey   string
		Enabled     bool
		Description string
	}{
		ID:          o.GetID(),
		SecretKey:   o.GetSecretKey(),
		Enabled:     o.GetEnabled(),
		Description: o.GetDescription(),
	}
}

// GetID returns value of ID
func (o *LocalRouterPeer) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *LocalRouterPeer) SetID(v types.ID) {
	o.ID = v
}

// GetSecretKey returns value of SecretKey
func (o *LocalRouterPeer) GetSecretKey() string {
	return o.SecretKey
}

// SetSecretKey sets value to SecretKey
func (o *LocalRouterPeer) SetSecretKey(v string) {
	o.SecretKey = v
}

// GetEnabled returns value of Enabled
func (o *LocalRouterPeer) GetEnabled() bool {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *LocalRouterPeer) SetEnabled(v bool) {
	o.Enabled = v
}

// GetDescription returns value of Description
func (o *LocalRouterPeer) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *LocalRouterPeer) SetDescription(v string) {
	o.Description = v
}

/*************************************************
* LocalRouterStaticRoute
*************************************************/

// LocalRouterStaticRoute represents API parameter/response structure
type LocalRouterStaticRoute struct {
	Prefix  string
	NextHop string
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterStaticRoute) setDefaults() interface{} {
	return &struct {
		Prefix  string
		NextHop string
	}{
		Prefix:  o.GetPrefix(),
		NextHop: o.GetNextHop(),
	}
}

// GetPrefix returns value of Prefix
func (o *LocalRouterStaticRoute) GetPrefix() string {
	return o.Prefix
}

// SetPrefix sets value to Prefix
func (o *LocalRouterStaticRoute) SetPrefix(v string) {
	o.Prefix = v
}

// GetNextHop returns value of NextHop
func (o *LocalRouterStaticRoute) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *LocalRouterStaticRoute) SetNextHop(v string) {
	o.NextHop = v
}

/*************************************************
* LocalRouterCreateRequest
*************************************************/

// LocalRouterCreateRequest represents API parameter/response structure
type LocalRouterCreateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterCreateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
		Class       string   `mapconv:"Provider.Class"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
		Class:       "localrouter",
	}
}

// GetName returns value of Name
func (o *LocalRouterCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LocalRouterCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *LocalRouterCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *LocalRouterCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *LocalRouterCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *LocalRouterCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *LocalRouterCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *LocalRouterCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *LocalRouterCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *LocalRouterCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *LocalRouterCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *LocalRouterCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* LocalRouterUpdateRequest
*************************************************/

// LocalRouterUpdateRequest represents API parameter/response structure
type LocalRouterUpdateRequest struct {
	Switch       *LocalRouterSwitch        `mapconv:"Settings.LocalRouter.Switch,recursive"`
	Interface    *LocalRouterInterface     `mapconv:"Settings.LocalRouter.Interface,recursive"`
	Peers        []*LocalRouterPeer        `mapconv:"Settings.LocalRouter.[]Peers,recursive"`
	StaticRoutes []*LocalRouterStaticRoute `mapconv:"Settings.LocalRouter.[]StaticRoutes,recursive"`
	SettingsHash string                    `json:",omitempty" mapconv:",omitempty"`
	Name         string
	Description  string
	Tags         types.Tags
	IconID       types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterUpdateRequest) setDefaults() interface{} {
	return &struct {
		Switch       *LocalRouterSwitch        `mapconv:"Settings.LocalRouter.Switch,recursive"`
		Interface    *LocalRouterInterface     `mapconv:"Settings.LocalRouter.Interface,recursive"`
		Peers        []*LocalRouterPeer        `mapconv:"Settings.LocalRouter.[]Peers,recursive"`
		StaticRoutes []*LocalRouterStaticRoute `mapconv:"Settings.LocalRouter.[]StaticRoutes,recursive"`
		SettingsHash string                    `json:",omitempty" mapconv:",omitempty"`
		Name         string
		Description  string
		Tags         types.Tags
		IconID       types.ID `mapconv:"Icon.ID"`
	}{
		Switch:       o.GetSwitch(),
		Interface:    o.GetInterface(),
		Peers:        o.GetPeers(),
		StaticRoutes: o.GetStaticRoutes(),
		SettingsHash: o.GetSettingsHash(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		IconID:       o.GetIconID(),
	}
}

// GetSwitch returns value of Switch
func (o *LocalRouterUpdateRequest) GetSwitch() *LocalRouterSwitch {
	return o.Switch
}

// SetSwitch sets value to Switch
func (o *LocalRouterUpdateRequest) SetSwitch(v *LocalRouterSwitch) {
	o.Switch = v
}

// GetInterface returns value of Interface
func (o *LocalRouterUpdateRequest) GetInterface() *LocalRouterInterface {
	return o.Interface
}

// SetInterface sets value to Interface
func (o *LocalRouterUpdateRequest) SetInterface(v *LocalRouterInterface) {
	o.Interface = v
}

// GetPeers returns value of Peers
func (o *LocalRouterUpdateRequest) GetPeers() []*LocalRouterPeer {
	return o.Peers
}

// SetPeers sets value to Peers
func (o *LocalRouterUpdateRequest) SetPeers(v []*LocalRouterPeer) {
	o.Peers = v
}

// GetStaticRoutes returns value of StaticRoutes
func (o *LocalRouterUpdateRequest) GetStaticRoutes() []*LocalRouterStaticRoute {
	return o.StaticRoutes
}

// SetStaticRoutes sets value to StaticRoutes
func (o *LocalRouterUpdateRequest) SetStaticRoutes(v []*LocalRouterStaticRoute) {
	o.StaticRoutes = v
}

// GetSettingsHash returns value of SettingsHash
func (o *LocalRouterUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *LocalRouterUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetName returns value of Name
func (o *LocalRouterUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *LocalRouterUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *LocalRouterUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *LocalRouterUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *LocalRouterUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *LocalRouterUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *LocalRouterUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *LocalRouterUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *LocalRouterUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *LocalRouterUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *LocalRouterUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *LocalRouterUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* LocalRouterUpdateSettingsRequest
*************************************************/

// LocalRouterUpdateSettingsRequest represents API parameter/response structure
type LocalRouterUpdateSettingsRequest struct {
	Switch       *LocalRouterSwitch        `mapconv:"Settings.LocalRouter.Switch,recursive"`
	Interface    *LocalRouterInterface     `mapconv:"Settings.LocalRouter.Interface,recursive"`
	Peers        []*LocalRouterPeer        `mapconv:"Settings.LocalRouter.[]Peers,recursive"`
	StaticRoutes []*LocalRouterStaticRoute `mapconv:"Settings.LocalRouter.[]StaticRoutes,recursive"`
	SettingsHash string                    `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		Switch       *LocalRouterSwitch        `mapconv:"Settings.LocalRouter.Switch,recursive"`
		Interface    *LocalRouterInterface     `mapconv:"Settings.LocalRouter.Interface,recursive"`
		Peers        []*LocalRouterPeer        `mapconv:"Settings.LocalRouter.[]Peers,recursive"`
		StaticRoutes []*LocalRouterStaticRoute `mapconv:"Settings.LocalRouter.[]StaticRoutes,recursive"`
		SettingsHash string                    `json:",omitempty" mapconv:",omitempty"`
	}{
		Switch:       o.GetSwitch(),
		Interface:    o.GetInterface(),
		Peers:        o.GetPeers(),
		StaticRoutes: o.GetStaticRoutes(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetSwitch returns value of Switch
func (o *LocalRouterUpdateSettingsRequest) GetSwitch() *LocalRouterSwitch {
	return o.Switch
}

// SetSwitch sets value to Switch
func (o *LocalRouterUpdateSettingsRequest) SetSwitch(v *LocalRouterSwitch) {
	o.Switch = v
}

// GetInterface returns value of Interface
func (o *LocalRouterUpdateSettingsRequest) GetInterface() *LocalRouterInterface {
	return o.Interface
}

// SetInterface sets value to Interface
func (o *LocalRouterUpdateSettingsRequest) SetInterface(v *LocalRouterInterface) {
	o.Interface = v
}

// GetPeers returns value of Peers
func (o *LocalRouterUpdateSettingsRequest) GetPeers() []*LocalRouterPeer {
	return o.Peers
}

// SetPeers sets value to Peers
func (o *LocalRouterUpdateSettingsRequest) SetPeers(v []*LocalRouterPeer) {
	o.Peers = v
}

// GetStaticRoutes returns value of StaticRoutes
func (o *LocalRouterUpdateSettingsRequest) GetStaticRoutes() []*LocalRouterStaticRoute {
	return o.StaticRoutes
}

// SetStaticRoutes sets value to StaticRoutes
func (o *LocalRouterUpdateSettingsRequest) SetStaticRoutes(v []*LocalRouterStaticRoute) {
	o.StaticRoutes = v
}

// GetSettingsHash returns value of SettingsHash
func (o *LocalRouterUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *LocalRouterUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* LocalRouterHealth
*************************************************/

// LocalRouterHealth represents API parameter/response structure
type LocalRouterHealth struct {
	Peers []*LocalRouterHealthPeer `mapconv:"[]Peers,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterHealth) setDefaults() interface{} {
	return &struct {
		Peers []*LocalRouterHealthPeer `mapconv:"[]Peers,recursive"`
	}{
		Peers: o.GetPeers(),
	}
}

// GetPeers returns value of Peers
func (o *LocalRouterHealth) GetPeers() []*LocalRouterHealthPeer {
	return o.Peers
}

// SetPeers sets value to Peers
func (o *LocalRouterHealth) SetPeers(v []*LocalRouterHealthPeer) {
	o.Peers = v
}

/*************************************************
* LocalRouterHealthPeer
*************************************************/

// LocalRouterHealthPeer represents API parameter/response structure
type LocalRouterHealthPeer struct {
	ID     types.ID
	Status types.EServerInstanceStatus
	Routes []string
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterHealthPeer) setDefaults() interface{} {
	return &struct {
		ID     types.ID
		Status types.EServerInstanceStatus
		Routes []string
	}{
		ID:     o.GetID(),
		Status: o.GetStatus(),
		Routes: o.GetRoutes(),
	}
}

// GetID returns value of ID
func (o *LocalRouterHealthPeer) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *LocalRouterHealthPeer) SetID(v types.ID) {
	o.ID = v
}

// GetStatus returns value of Status
func (o *LocalRouterHealthPeer) GetStatus() types.EServerInstanceStatus {
	return o.Status
}

// SetStatus sets value to Status
func (o *LocalRouterHealthPeer) SetStatus(v types.EServerInstanceStatus) {
	o.Status = v
}

// GetRoutes returns value of Routes
func (o *LocalRouterHealthPeer) GetRoutes() []string {
	return o.Routes
}

// SetRoutes sets value to Routes
func (o *LocalRouterHealthPeer) SetRoutes(v []string) {
	o.Routes = v
}

/*************************************************
* LocalRouterActivity
*************************************************/

// LocalRouterActivity represents API parameter/response structure
type LocalRouterActivity struct {
	Values []*MonitorLocalRouterValue `mapconv:"[]LocalRouter"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LocalRouterActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorLocalRouterValue `mapconv:"[]LocalRouter"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *LocalRouterActivity) GetValues() []*MonitorLocalRouterValue {
	return o.Values
}

// SetValues sets value to Values
func (o *LocalRouterActivity) SetValues(v []*MonitorLocalRouterValue) {
	o.Values = v
}

/*************************************************
* MonitorLocalRouterValue
*************************************************/

// MonitorLocalRouterValue represents API parameter/response structure
type MonitorLocalRouterValue struct {
	Time               time.Time `mapconv:",omitempty"`
	ReceiveBytesPerSec float64   `mapconv:",omitempty"`
	SendBytesPerSec    float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorLocalRouterValue) setDefaults() interface{} {
	return &struct {
		Time               time.Time `mapconv:",omitempty"`
		ReceiveBytesPerSec float64   `mapconv:",omitempty"`
		SendBytesPerSec    float64   `mapconv:",omitempty"`
	}{
		Time:               o.GetTime(),
		ReceiveBytesPerSec: o.GetReceiveBytesPerSec(),
		SendBytesPerSec:    o.GetSendBytesPerSec(),
	}
}

// GetTime returns value of Time
func (o *MonitorLocalRouterValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorLocalRouterValue) SetTime(v time.Time) {
	o.Time = v
}

// GetReceiveBytesPerSec returns value of ReceiveBytesPerSec
func (o *MonitorLocalRouterValue) GetReceiveBytesPerSec() float64 {
	return o.ReceiveBytesPerSec
}

// SetReceiveBytesPerSec sets value to ReceiveBytesPerSec
func (o *MonitorLocalRouterValue) SetReceiveBytesPerSec(v float64) {
	o.ReceiveBytesPerSec = v
}

// GetSendBytesPerSec returns value of SendBytesPerSec
func (o *MonitorLocalRouterValue) GetSendBytesPerSec() float64 {
	return o.SendBytesPerSec
}

// SetSendBytesPerSec sets value to SendBytesPerSec
func (o *MonitorLocalRouterValue) SetSendBytesPerSec(v float64) {
	o.SendBytesPerSec = v
}

/*************************************************
* MobileGateway
*************************************************/

// MobileGateway represents API parameter/response structure
type MobileGateway struct {
	ID                              types.ID
	Name                            string
	Description                     string
	Tags                            types.Tags
	Availability                    types.EAvailability
	Class                           string
	IconID                          types.ID `mapconv:"Icon.ID"`
	CreatedAt                       time.Time
	InstanceHostName                string                           `mapconv:"Instance.Host.Name"`
	InstanceHostInfoURL             string                           `mapconv:"Instance.Host.InfoURL"`
	InstanceStatus                  types.EServerInstanceStatus      `mapconv:"Instance.Status"`
	InstanceStatusChangedAt         time.Time                        `mapconv:"Instance.StatusChangedAt"`
	Interfaces                      []*MobileGatewayInterface        `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
	ZoneID                          types.ID                         `mapconv:"Remark.Zone.ID"`
	GlobalAddress                   string                           `mapconv:"Remark.MobileGateway.GlobalAddress"`
	InterfaceSettings               []*MobileGatewayInterfaceSetting `mapconv:"Settings.MobileGateway.[]Interfaces,recursive"`
	StaticRoutes                    []*MobileGatewayStaticRoute      `mapconv:"Settings.MobileGateway.[]StaticRoutes,recursive"`
	InternetConnectionEnabled       types.StringFlag                 `mapconv:"Settings.MobileGateway.InternetConnection.Enabled"`
	InterDeviceCommunicationEnabled types.StringFlag                 `mapconv:"Settings.MobileGateway.InterDeviceCommunication.Enabled"`
	SettingsHash                    string                           `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGateway) setDefaults() interface{} {
	return &struct {
		ID                              types.ID
		Name                            string
		Description                     string
		Tags                            types.Tags
		Availability                    types.EAvailability
		Class                           string
		IconID                          types.ID `mapconv:"Icon.ID"`
		CreatedAt                       time.Time
		InstanceHostName                string                           `mapconv:"Instance.Host.Name"`
		InstanceHostInfoURL             string                           `mapconv:"Instance.Host.InfoURL"`
		InstanceStatus                  types.EServerInstanceStatus      `mapconv:"Instance.Status"`
		InstanceStatusChangedAt         time.Time                        `mapconv:"Instance.StatusChangedAt"`
		Interfaces                      []*MobileGatewayInterface        `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
		ZoneID                          types.ID                         `mapconv:"Remark.Zone.ID"`
		GlobalAddress                   string                           `mapconv:"Remark.MobileGateway.GlobalAddress"`
		InterfaceSettings               []*MobileGatewayInterfaceSetting `mapconv:"Settings.MobileGateway.[]Interfaces,recursive"`
		StaticRoutes                    []*MobileGatewayStaticRoute      `mapconv:"Settings.MobileGateway.[]StaticRoutes,recursive"`
		InternetConnectionEnabled       types.StringFlag                 `mapconv:"Settings.MobileGateway.InternetConnection.Enabled"`
		InterDeviceCommunicationEnabled types.StringFlag                 `mapconv:"Settings.MobileGateway.InterDeviceCommunication.Enabled"`
		SettingsHash                    string                           `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:                              o.GetID(),
		Name:                            o.GetName(),
		Description:                     o.GetDescription(),
		Tags:                            o.GetTags(),
		Availability:                    o.GetAvailability(),
		Class:                           o.GetClass(),
		IconID:                          o.GetIconID(),
		CreatedAt:                       o.GetCreatedAt(),
		InstanceHostName:                o.GetInstanceHostName(),
		InstanceHostInfoURL:             o.GetInstanceHostInfoURL(),
		InstanceStatus:                  o.GetInstanceStatus(),
		InstanceStatusChangedAt:         o.GetInstanceStatusChangedAt(),
		Interfaces:                      o.GetInterfaces(),
		ZoneID:                          o.GetZoneID(),
		GlobalAddress:                   o.GetGlobalAddress(),
		InterfaceSettings:               o.GetInterfaceSettings(),
		StaticRoutes:                    o.GetStaticRoutes(),
		InternetConnectionEnabled:       o.GetInternetConnectionEnabled(),
		InterDeviceCommunicationEnabled: o.GetInterDeviceCommunicationEnabled(),
		SettingsHash:                    o.GetSettingsHash(),
	}
}

// GetID returns value of ID
func (o *MobileGateway) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *MobileGateway) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *MobileGateway) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *MobileGateway) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *MobileGateway) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *MobileGateway) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *MobileGateway) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *MobileGateway) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *MobileGateway) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *MobileGateway) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *MobileGateway) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *MobileGateway) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *MobileGateway) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *MobileGateway) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *MobileGateway) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *MobileGateway) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *MobileGateway) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *MobileGateway) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetClass returns value of Class
func (o *MobileGateway) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *MobileGateway) SetClass(v string) {
	o.Class = v
}

// GetIconID returns value of IconID
func (o *MobileGateway) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *MobileGateway) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *MobileGateway) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *MobileGateway) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetInstanceHostName returns value of InstanceHostName
func (o *MobileGateway) GetInstanceHostName() string {
	return o.InstanceHostName
}

// SetInstanceHostName sets value to InstanceHostName
func (o *MobileGateway) SetInstanceHostName(v string) {
	o.InstanceHostName = v
}

// GetInstanceHostInfoURL returns value of InstanceHostInfoURL
func (o *MobileGateway) GetInstanceHostInfoURL() string {
	return o.InstanceHostInfoURL
}

// SetInstanceHostInfoURL sets value to InstanceHostInfoURL
func (o *MobileGateway) SetInstanceHostInfoURL(v string) {
	o.InstanceHostInfoURL = v
}

// GetInstanceStatus returns value of InstanceStatus
func (o *MobileGateway) GetInstanceStatus() types.EServerInstanceStatus {
	return o.InstanceStatus
}

// SetInstanceStatus sets value to InstanceStatus
func (o *MobileGateway) SetInstanceStatus(v types.EServerInstanceStatus) {
	o.InstanceStatus = v
}

// GetInstanceStatusChangedAt returns value of InstanceStatusChangedAt
func (o *MobileGateway) GetInstanceStatusChangedAt() time.Time {
	return o.InstanceStatusChangedAt
}

// SetInstanceStatusChangedAt sets value to InstanceStatusChangedAt
func (o *MobileGateway) SetInstanceStatusChangedAt(v time.Time) {
	o.InstanceStatusChangedAt = v
}

// GetInterfaces returns value of Interfaces
func (o *MobileGateway) GetInterfaces() []*MobileGatewayInterface {
	return o.Interfaces
}

// SetInterfaces sets value to Interfaces
func (o *MobileGateway) SetInterfaces(v []*MobileGatewayInterface) {
	o.Interfaces = v
}

// GetZoneID returns value of ZoneID
func (o *MobileGateway) GetZoneID() types.ID {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *MobileGateway) SetZoneID(v types.ID) {
	o.ZoneID = v
}

// GetGlobalAddress returns value of GlobalAddress
func (o *MobileGateway) GetGlobalAddress() string {
	return o.GlobalAddress
}

// SetGlobalAddress sets value to GlobalAddress
func (o *MobileGateway) SetGlobalAddress(v string) {
	o.GlobalAddress = v
}

// GetInterfaceSettings returns value of InterfaceSettings
func (o *MobileGateway) GetInterfaceSettings() []*MobileGatewayInterfaceSetting {
	return o.InterfaceSettings
}

// SetInterfaceSettings sets value to InterfaceSettings
func (o *MobileGateway) SetInterfaceSettings(v []*MobileGatewayInterfaceSetting) {
	o.InterfaceSettings = v
}

// GetStaticRoutes returns value of StaticRoutes
func (o *MobileGateway) GetStaticRoutes() []*MobileGatewayStaticRoute {
	return o.StaticRoutes
}

// SetStaticRoutes sets value to StaticRoutes
func (o *MobileGateway) SetStaticRoutes(v []*MobileGatewayStaticRoute) {
	o.StaticRoutes = v
}

// GetInternetConnectionEnabled returns value of InternetConnectionEnabled
func (o *MobileGateway) GetInternetConnectionEnabled() types.StringFlag {
	return o.InternetConnectionEnabled
}

// SetInternetConnectionEnabled sets value to InternetConnectionEnabled
func (o *MobileGateway) SetInternetConnectionEnabled(v types.StringFlag) {
	o.InternetConnectionEnabled = v
}

// GetInterDeviceCommunicationEnabled returns value of InterDeviceCommunicationEnabled
func (o *MobileGateway) GetInterDeviceCommunicationEnabled() types.StringFlag {
	return o.InterDeviceCommunicationEnabled
}

// SetInterDeviceCommunicationEnabled sets value to InterDeviceCommunicationEnabled
func (o *MobileGateway) SetInterDeviceCommunicationEnabled(v types.StringFlag) {
	o.InterDeviceCommunicationEnabled = v
}

// GetSettingsHash returns value of SettingsHash
func (o *MobileGateway) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *MobileGateway) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* MobileGatewayInterface
*************************************************/

// MobileGatewayInterface represents API parameter/response structure
type MobileGatewayInterface struct {
	ID                              types.ID
	MACAddress                      string
	IPAddress                       string
	UserIPAddress                   string
	HostName                        string
	SwitchID                        types.ID           `mapconv:"Switch.ID"`
	SwitchName                      string             `mapconv:"Switch.Name"`
	SwitchScope                     types.EScope       `mapconv:"Switch.Scope"`
	UserSubnetDefaultRoute          string             `mapconv:"Switch.UserSubnet.DefaultRoute"`
	UserSubnetNetworkMaskLen        int                `mapconv:"Switch.UserSubnet.NetworkMaskLen"`
	SubnetDefaultRoute              string             `mapconv:"Switch.Subnet.DefaultRoute"`
	SubnetNetworkMaskLen            int                `mapconv:"Switch.Subnet.NetworkMaskLen"`
	SubnetNetworkAddress            string             `mapconv:"Switch.Subnet.NetworkAddress"`
	SubnetBandWidthMbps             int                `mapconv:"Switch.Subnet.Internet.BandWidthMbps"`
	PacketFilterID                  types.ID           `mapconv:"PacketFilter.ID"`
	PacketFilterName                string             `mapconv:"PacketFilter.Name"`
	PacketFilterRequiredHostVersion types.StringNumber `mapconv:"PacketFilter.RequiredHostVersionn"`
	UpstreamType                    types.EUpstreamNetworkType
	Index                           int `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayInterface) setDefaults() interface{} {
	return &struct {
		ID                              types.ID
		MACAddress                      string
		IPAddress                       string
		UserIPAddress                   string
		HostName                        string
		SwitchID                        types.ID           `mapconv:"Switch.ID"`
		SwitchName                      string             `mapconv:"Switch.Name"`
		SwitchScope                     types.EScope       `mapconv:"Switch.Scope"`
		UserSubnetDefaultRoute          string             `mapconv:"Switch.UserSubnet.DefaultRoute"`
		UserSubnetNetworkMaskLen        int                `mapconv:"Switch.UserSubnet.NetworkMaskLen"`
		SubnetDefaultRoute              string             `mapconv:"Switch.Subnet.DefaultRoute"`
		SubnetNetworkMaskLen            int                `mapconv:"Switch.Subnet.NetworkMaskLen"`
		SubnetNetworkAddress            string             `mapconv:"Switch.Subnet.NetworkAddress"`
		SubnetBandWidthMbps             int                `mapconv:"Switch.Subnet.Internet.BandWidthMbps"`
		PacketFilterID                  types.ID           `mapconv:"PacketFilter.ID"`
		PacketFilterName                string             `mapconv:"PacketFilter.Name"`
		PacketFilterRequiredHostVersion types.StringNumber `mapconv:"PacketFilter.RequiredHostVersionn"`
		UpstreamType                    types.EUpstreamNetworkType
		Index                           int `mapconv:",omitempty"`
	}{
		ID:                              o.GetID(),
		MACAddress:                      o.GetMACAddress(),
		IPAddress:                       o.GetIPAddress(),
		UserIPAddress:                   o.GetUserIPAddress(),
		HostName:                        o.GetHostName(),
		SwitchID:                        o.GetSwitchID(),
		SwitchName:                      o.GetSwitchName(),
		SwitchScope:                     o.GetSwitchScope(),
		UserSubnetDefaultRoute:          o.GetUserSubnetDefaultRoute(),
		UserSubnetNetworkMaskLen:        o.GetUserSubnetNetworkMaskLen(),
		SubnetDefaultRoute:              o.GetSubnetDefaultRoute(),
		SubnetNetworkMaskLen:            o.GetSubnetNetworkMaskLen(),
		SubnetNetworkAddress:            o.GetSubnetNetworkAddress(),
		SubnetBandWidthMbps:             o.GetSubnetBandWidthMbps(),
		PacketFilterID:                  o.GetPacketFilterID(),
		PacketFilterName:                o.GetPacketFilterName(),
		PacketFilterRequiredHostVersion: o.GetPacketFilterRequiredHostVersion(),
		UpstreamType:                    o.GetUpstreamType(),
		Index:                           o.GetIndex(),
	}
}

// GetID returns value of ID
func (o *MobileGatewayInterface) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *MobileGatewayInterface) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *MobileGatewayInterface) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *MobileGatewayInterface) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *MobileGatewayInterface) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *MobileGatewayInterface) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetMACAddress returns value of MACAddress
func (o *MobileGatewayInterface) GetMACAddress() string {
	return o.MACAddress
}

// SetMACAddress sets value to MACAddress
func (o *MobileGatewayInterface) SetMACAddress(v string) {
	o.MACAddress = v
}

// GetIPAddress returns value of IPAddress
func (o *MobileGatewayInterface) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *MobileGatewayInterface) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetUserIPAddress returns value of UserIPAddress
func (o *MobileGatewayInterface) GetUserIPAddress() string {
	return o.UserIPAddress
}

// SetUserIPAddress sets value to UserIPAddress
func (o *MobileGatewayInterface) SetUserIPAddress(v string) {
	o.UserIPAddress = v
}

// GetHostName returns value of HostName
func (o *MobileGatewayInterface) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *MobileGatewayInterface) SetHostName(v string) {
	o.HostName = v
}

// GetSwitchID returns value of SwitchID
func (o *MobileGatewayInterface) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *MobileGatewayInterface) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetSwitchName returns value of SwitchName
func (o *MobileGatewayInterface) GetSwitchName() string {
	return o.SwitchName
}

// SetSwitchName sets value to SwitchName
func (o *MobileGatewayInterface) SetSwitchName(v string) {
	o.SwitchName = v
}

// GetSwitchScope returns value of SwitchScope
func (o *MobileGatewayInterface) GetSwitchScope() types.EScope {
	return o.SwitchScope
}

// SetSwitchScope sets value to SwitchScope
func (o *MobileGatewayInterface) SetSwitchScope(v types.EScope) {
	o.SwitchScope = v
}

// GetUserSubnetDefaultRoute returns value of UserSubnetDefaultRoute
func (o *MobileGatewayInterface) GetUserSubnetDefaultRoute() string {
	return o.UserSubnetDefaultRoute
}

// SetUserSubnetDefaultRoute sets value to UserSubnetDefaultRoute
func (o *MobileGatewayInterface) SetUserSubnetDefaultRoute(v string) {
	o.UserSubnetDefaultRoute = v
}

// GetUserSubnetNetworkMaskLen returns value of UserSubnetNetworkMaskLen
func (o *MobileGatewayInterface) GetUserSubnetNetworkMaskLen() int {
	return o.UserSubnetNetworkMaskLen
}

// SetUserSubnetNetworkMaskLen sets value to UserSubnetNetworkMaskLen
func (o *MobileGatewayInterface) SetUserSubnetNetworkMaskLen(v int) {
	o.UserSubnetNetworkMaskLen = v
}

// GetSubnetDefaultRoute returns value of SubnetDefaultRoute
func (o *MobileGatewayInterface) GetSubnetDefaultRoute() string {
	return o.SubnetDefaultRoute
}

// SetSubnetDefaultRoute sets value to SubnetDefaultRoute
func (o *MobileGatewayInterface) SetSubnetDefaultRoute(v string) {
	o.SubnetDefaultRoute = v
}

// GetSubnetNetworkMaskLen returns value of SubnetNetworkMaskLen
func (o *MobileGatewayInterface) GetSubnetNetworkMaskLen() int {
	return o.SubnetNetworkMaskLen
}

// SetSubnetNetworkMaskLen sets value to SubnetNetworkMaskLen
func (o *MobileGatewayInterface) SetSubnetNetworkMaskLen(v int) {
	o.SubnetNetworkMaskLen = v
}

// GetSubnetNetworkAddress returns value of SubnetNetworkAddress
func (o *MobileGatewayInterface) GetSubnetNetworkAddress() string {
	return o.SubnetNetworkAddress
}

// SetSubnetNetworkAddress sets value to SubnetNetworkAddress
func (o *MobileGatewayInterface) SetSubnetNetworkAddress(v string) {
	o.SubnetNetworkAddress = v
}

// GetSubnetBandWidthMbps returns value of SubnetBandWidthMbps
func (o *MobileGatewayInterface) GetSubnetBandWidthMbps() int {
	return o.SubnetBandWidthMbps
}

// SetSubnetBandWidthMbps sets value to SubnetBandWidthMbps
func (o *MobileGatewayInterface) SetSubnetBandWidthMbps(v int) {
	o.SubnetBandWidthMbps = v
}

// GetPacketFilterID returns value of PacketFilterID
func (o *MobileGatewayInterface) GetPacketFilterID() types.ID {
	return o.PacketFilterID
}

// SetPacketFilterID sets value to PacketFilterID
func (o *MobileGatewayInterface) SetPacketFilterID(v types.ID) {
	o.PacketFilterID = v
}

// GetPacketFilterName returns value of PacketFilterName
func (o *MobileGatewayInterface) GetPacketFilterName() string {
	return o.PacketFilterName
}

// SetPacketFilterName sets value to PacketFilterName
func (o *MobileGatewayInterface) SetPacketFilterName(v string) {
	o.PacketFilterName = v
}

// GetPacketFilterRequiredHostVersion returns value of PacketFilterRequiredHostVersion
func (o *MobileGatewayInterface) GetPacketFilterRequiredHostVersion() types.StringNumber {
	return o.PacketFilterRequiredHostVersion
}

// SetPacketFilterRequiredHostVersion sets value to PacketFilterRequiredHostVersion
func (o *MobileGatewayInterface) SetPacketFilterRequiredHostVersion(v types.StringNumber) {
	o.PacketFilterRequiredHostVersion = v
}

// GetUpstreamType returns value of UpstreamType
func (o *MobileGatewayInterface) GetUpstreamType() types.EUpstreamNetworkType {
	return o.UpstreamType
}

// SetUpstreamType sets value to UpstreamType
func (o *MobileGatewayInterface) SetUpstreamType(v types.EUpstreamNetworkType) {
	o.UpstreamType = v
}

// GetIndex returns value of Index
func (o *MobileGatewayInterface) GetIndex() int {
	return o.Index
}

// SetIndex sets value to Index
func (o *MobileGatewayInterface) SetIndex(v int) {
	o.Index = v
}

/*************************************************
* MobileGatewayInterfaceSetting
*************************************************/

// MobileGatewayInterfaceSetting represents API parameter/response structure
type MobileGatewayInterfaceSetting struct {
	IPAddress      []string
	NetworkMaskLen int
	Index          int
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayInterfaceSetting) setDefaults() interface{} {
	return &struct {
		IPAddress      []string
		NetworkMaskLen int
		Index          int
	}{
		IPAddress:      o.GetIPAddress(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
		Index:          o.GetIndex(),
	}
}

// GetIPAddress returns value of IPAddress
func (o *MobileGatewayInterfaceSetting) GetIPAddress() []string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *MobileGatewayInterfaceSetting) SetIPAddress(v []string) {
	o.IPAddress = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *MobileGatewayInterfaceSetting) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *MobileGatewayInterfaceSetting) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetIndex returns value of Index
func (o *MobileGatewayInterfaceSetting) GetIndex() int {
	return o.Index
}

// SetIndex sets value to Index
func (o *MobileGatewayInterfaceSetting) SetIndex(v int) {
	o.Index = v
}

/*************************************************
* MobileGatewayStaticRoute
*************************************************/

// MobileGatewayStaticRoute represents API parameter/response structure
type MobileGatewayStaticRoute struct {
	Prefix  string
	NextHop string
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayStaticRoute) setDefaults() interface{} {
	return &struct {
		Prefix  string
		NextHop string
	}{
		Prefix:  o.GetPrefix(),
		NextHop: o.GetNextHop(),
	}
}

// GetPrefix returns value of Prefix
func (o *MobileGatewayStaticRoute) GetPrefix() string {
	return o.Prefix
}

// SetPrefix sets value to Prefix
func (o *MobileGatewayStaticRoute) SetPrefix(v string) {
	o.Prefix = v
}

// GetNextHop returns value of NextHop
func (o *MobileGatewayStaticRoute) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *MobileGatewayStaticRoute) SetNextHop(v string) {
	o.NextHop = v
}

/*************************************************
* MobileGatewayCreateRequest
*************************************************/

// MobileGatewayCreateRequest represents API parameter/response structure
type MobileGatewayCreateRequest struct {
	Name                            string
	Description                     string
	Tags                            types.Tags
	IconID                          types.ID                    `mapconv:"Icon.ID"`
	StaticRoutes                    []*MobileGatewayStaticRoute `json:",omitempty" mapconv:"Settings.MobileGateway.[]StaticRoutes,omitempty,recursive"`
	InternetConnectionEnabled       types.StringFlag            `mapconv:"Settings.MobileGateway.InternetConnection.Enabled"`
	InterDeviceCommunicationEnabled types.StringFlag            `mapconv:"Settings.MobileGateway.InterDeviceCommunication.Enabled"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayCreateRequest) setDefaults() interface{} {
	return &struct {
		Name                            string
		Description                     string
		Tags                            types.Tags
		IconID                          types.ID                    `mapconv:"Icon.ID"`
		StaticRoutes                    []*MobileGatewayStaticRoute `json:",omitempty" mapconv:"Settings.MobileGateway.[]StaticRoutes,omitempty,recursive"`
		InternetConnectionEnabled       types.StringFlag            `mapconv:"Settings.MobileGateway.InternetConnection.Enabled"`
		InterDeviceCommunicationEnabled types.StringFlag            `mapconv:"Settings.MobileGateway.InterDeviceCommunication.Enabled"`
		Class                           string
		PlanID                          types.ID `mapconv:"Remark.Plan.ID/Plan.ID"`
		SwitchID                        string   `mapconv:"Remark.Switch.Scope"`
	}{
		Name:                            o.GetName(),
		Description:                     o.GetDescription(),
		Tags:                            o.GetTags(),
		IconID:                          o.GetIconID(),
		StaticRoutes:                    o.GetStaticRoutes(),
		InternetConnectionEnabled:       o.GetInternetConnectionEnabled(),
		InterDeviceCommunicationEnabled: o.GetInterDeviceCommunicationEnabled(),
		Class:                           "mobilegateway",
		PlanID:                          types.ID(2),
		SwitchID:                        "shared",
	}
}

// GetName returns value of Name
func (o *MobileGatewayCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *MobileGatewayCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *MobileGatewayCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *MobileGatewayCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *MobileGatewayCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *MobileGatewayCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *MobileGatewayCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *MobileGatewayCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *MobileGatewayCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *MobileGatewayCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *MobileGatewayCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *MobileGatewayCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetStaticRoutes returns value of StaticRoutes
func (o *MobileGatewayCreateRequest) GetStaticRoutes() []*MobileGatewayStaticRoute {
	return o.StaticRoutes
}

// SetStaticRoutes sets value to StaticRoutes
func (o *MobileGatewayCreateRequest) SetStaticRoutes(v []*MobileGatewayStaticRoute) {
	o.StaticRoutes = v
}

// GetInternetConnectionEnabled returns value of InternetConnectionEnabled
func (o *MobileGatewayCreateRequest) GetInternetConnectionEnabled() types.StringFlag {
	return o.InternetConnectionEnabled
}

// SetInternetConnectionEnabled sets value to InternetConnectionEnabled
func (o *MobileGatewayCreateRequest) SetInternetConnectionEnabled(v types.StringFlag) {
	o.InternetConnectionEnabled = v
}

// GetInterDeviceCommunicationEnabled returns value of InterDeviceCommunicationEnabled
func (o *MobileGatewayCreateRequest) GetInterDeviceCommunicationEnabled() types.StringFlag {
	return o.InterDeviceCommunicationEnabled
}

// SetInterDeviceCommunicationEnabled sets value to InterDeviceCommunicationEnabled
func (o *MobileGatewayCreateRequest) SetInterDeviceCommunicationEnabled(v types.StringFlag) {
	o.InterDeviceCommunicationEnabled = v
}

/*************************************************
* MobileGatewayUpdateRequest
*************************************************/

// MobileGatewayUpdateRequest represents API parameter/response structure
type MobileGatewayUpdateRequest struct {
	Name                            string
	Description                     string
	Tags                            types.Tags
	IconID                          types.ID                         `mapconv:"Icon.ID"`
	InterfaceSettings               []*MobileGatewayInterfaceSetting `mapconv:"Settings.MobileGateway.[]Interfaces,recursive"`
	StaticRoutes                    []*MobileGatewayStaticRoute      `mapconv:"Settings.MobileGateway.[]StaticRoutes,recursive"`
	InternetConnectionEnabled       types.StringFlag                 `mapconv:"Settings.MobileGateway.InternetConnection.Enabled"`
	InterDeviceCommunicationEnabled types.StringFlag                 `mapconv:"Settings.MobileGateway.InterDeviceCommunication.Enabled"`
	SettingsHash                    string                           `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name                            string
		Description                     string
		Tags                            types.Tags
		IconID                          types.ID                         `mapconv:"Icon.ID"`
		InterfaceSettings               []*MobileGatewayInterfaceSetting `mapconv:"Settings.MobileGateway.[]Interfaces,recursive"`
		StaticRoutes                    []*MobileGatewayStaticRoute      `mapconv:"Settings.MobileGateway.[]StaticRoutes,recursive"`
		InternetConnectionEnabled       types.StringFlag                 `mapconv:"Settings.MobileGateway.InternetConnection.Enabled"`
		InterDeviceCommunicationEnabled types.StringFlag                 `mapconv:"Settings.MobileGateway.InterDeviceCommunication.Enabled"`
		SettingsHash                    string                           `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:                            o.GetName(),
		Description:                     o.GetDescription(),
		Tags:                            o.GetTags(),
		IconID:                          o.GetIconID(),
		InterfaceSettings:               o.GetInterfaceSettings(),
		StaticRoutes:                    o.GetStaticRoutes(),
		InternetConnectionEnabled:       o.GetInternetConnectionEnabled(),
		InterDeviceCommunicationEnabled: o.GetInterDeviceCommunicationEnabled(),
		SettingsHash:                    o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *MobileGatewayUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *MobileGatewayUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *MobileGatewayUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *MobileGatewayUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *MobileGatewayUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *MobileGatewayUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *MobileGatewayUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *MobileGatewayUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *MobileGatewayUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *MobileGatewayUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *MobileGatewayUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *MobileGatewayUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetInterfaceSettings returns value of InterfaceSettings
func (o *MobileGatewayUpdateRequest) GetInterfaceSettings() []*MobileGatewayInterfaceSetting {
	return o.InterfaceSettings
}

// SetInterfaceSettings sets value to InterfaceSettings
func (o *MobileGatewayUpdateRequest) SetInterfaceSettings(v []*MobileGatewayInterfaceSetting) {
	o.InterfaceSettings = v
}

// GetStaticRoutes returns value of StaticRoutes
func (o *MobileGatewayUpdateRequest) GetStaticRoutes() []*MobileGatewayStaticRoute {
	return o.StaticRoutes
}

// SetStaticRoutes sets value to StaticRoutes
func (o *MobileGatewayUpdateRequest) SetStaticRoutes(v []*MobileGatewayStaticRoute) {
	o.StaticRoutes = v
}

// GetInternetConnectionEnabled returns value of InternetConnectionEnabled
func (o *MobileGatewayUpdateRequest) GetInternetConnectionEnabled() types.StringFlag {
	return o.InternetConnectionEnabled
}

// SetInternetConnectionEnabled sets value to InternetConnectionEnabled
func (o *MobileGatewayUpdateRequest) SetInternetConnectionEnabled(v types.StringFlag) {
	o.InternetConnectionEnabled = v
}

// GetInterDeviceCommunicationEnabled returns value of InterDeviceCommunicationEnabled
func (o *MobileGatewayUpdateRequest) GetInterDeviceCommunicationEnabled() types.StringFlag {
	return o.InterDeviceCommunicationEnabled
}

// SetInterDeviceCommunicationEnabled sets value to InterDeviceCommunicationEnabled
func (o *MobileGatewayUpdateRequest) SetInterDeviceCommunicationEnabled(v types.StringFlag) {
	o.InterDeviceCommunicationEnabled = v
}

// GetSettingsHash returns value of SettingsHash
func (o *MobileGatewayUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *MobileGatewayUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* MobileGatewayUpdateSettingsRequest
*************************************************/

// MobileGatewayUpdateSettingsRequest represents API parameter/response structure
type MobileGatewayUpdateSettingsRequest struct {
	InterfaceSettings               []*MobileGatewayInterfaceSetting `mapconv:"Settings.MobileGateway.[]Interfaces,recursive"`
	StaticRoutes                    []*MobileGatewayStaticRoute      `mapconv:"Settings.MobileGateway.[]StaticRoutes,recursive"`
	InternetConnectionEnabled       types.StringFlag                 `mapconv:"Settings.MobileGateway.InternetConnection.Enabled"`
	InterDeviceCommunicationEnabled types.StringFlag                 `mapconv:"Settings.MobileGateway.InterDeviceCommunication.Enabled"`
	SettingsHash                    string                           `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		InterfaceSettings               []*MobileGatewayInterfaceSetting `mapconv:"Settings.MobileGateway.[]Interfaces,recursive"`
		StaticRoutes                    []*MobileGatewayStaticRoute      `mapconv:"Settings.MobileGateway.[]StaticRoutes,recursive"`
		InternetConnectionEnabled       types.StringFlag                 `mapconv:"Settings.MobileGateway.InternetConnection.Enabled"`
		InterDeviceCommunicationEnabled types.StringFlag                 `mapconv:"Settings.MobileGateway.InterDeviceCommunication.Enabled"`
		SettingsHash                    string                           `json:",omitempty" mapconv:",omitempty"`
	}{
		InterfaceSettings:               o.GetInterfaceSettings(),
		StaticRoutes:                    o.GetStaticRoutes(),
		InternetConnectionEnabled:       o.GetInternetConnectionEnabled(),
		InterDeviceCommunicationEnabled: o.GetInterDeviceCommunicationEnabled(),
		SettingsHash:                    o.GetSettingsHash(),
	}
}

// GetInterfaceSettings returns value of InterfaceSettings
func (o *MobileGatewayUpdateSettingsRequest) GetInterfaceSettings() []*MobileGatewayInterfaceSetting {
	return o.InterfaceSettings
}

// SetInterfaceSettings sets value to InterfaceSettings
func (o *MobileGatewayUpdateSettingsRequest) SetInterfaceSettings(v []*MobileGatewayInterfaceSetting) {
	o.InterfaceSettings = v
}

// GetStaticRoutes returns value of StaticRoutes
func (o *MobileGatewayUpdateSettingsRequest) GetStaticRoutes() []*MobileGatewayStaticRoute {
	return o.StaticRoutes
}

// SetStaticRoutes sets value to StaticRoutes
func (o *MobileGatewayUpdateSettingsRequest) SetStaticRoutes(v []*MobileGatewayStaticRoute) {
	o.StaticRoutes = v
}

// GetInternetConnectionEnabled returns value of InternetConnectionEnabled
func (o *MobileGatewayUpdateSettingsRequest) GetInternetConnectionEnabled() types.StringFlag {
	return o.InternetConnectionEnabled
}

// SetInternetConnectionEnabled sets value to InternetConnectionEnabled
func (o *MobileGatewayUpdateSettingsRequest) SetInternetConnectionEnabled(v types.StringFlag) {
	o.InternetConnectionEnabled = v
}

// GetInterDeviceCommunicationEnabled returns value of InterDeviceCommunicationEnabled
func (o *MobileGatewayUpdateSettingsRequest) GetInterDeviceCommunicationEnabled() types.StringFlag {
	return o.InterDeviceCommunicationEnabled
}

// SetInterDeviceCommunicationEnabled sets value to InterDeviceCommunicationEnabled
func (o *MobileGatewayUpdateSettingsRequest) SetInterDeviceCommunicationEnabled(v types.StringFlag) {
	o.InterDeviceCommunicationEnabled = v
}

// GetSettingsHash returns value of SettingsHash
func (o *MobileGatewayUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *MobileGatewayUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* MobileGatewayDNSSetting
*************************************************/

// MobileGatewayDNSSetting represents API parameter/response structure
type MobileGatewayDNSSetting struct {
	DNS1 string
	DNS2 string
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayDNSSetting) setDefaults() interface{} {
	return &struct {
		DNS1 string
		DNS2 string
	}{
		DNS1: o.GetDNS1(),
		DNS2: o.GetDNS2(),
	}
}

// GetDNS1 returns value of DNS1
func (o *MobileGatewayDNSSetting) GetDNS1() string {
	return o.DNS1
}

// SetDNS1 sets value to DNS1
func (o *MobileGatewayDNSSetting) SetDNS1(v string) {
	o.DNS1 = v
}

// GetDNS2 returns value of DNS2
func (o *MobileGatewayDNSSetting) GetDNS2() string {
	return o.DNS2
}

// SetDNS2 sets value to DNS2
func (o *MobileGatewayDNSSetting) SetDNS2(v string) {
	o.DNS2 = v
}

/*************************************************
* MobileGatewaySIMRoute
*************************************************/

// MobileGatewaySIMRoute represents API parameter/response structure
type MobileGatewaySIMRoute struct {
	ResourceID string
	Prefix     string
	ICCID      string
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewaySIMRoute) setDefaults() interface{} {
	return &struct {
		ResourceID string
		Prefix     string
		ICCID      string
	}{
		ResourceID: o.GetResourceID(),
		Prefix:     o.GetPrefix(),
		ICCID:      o.GetICCID(),
	}
}

// GetResourceID returns value of ResourceID
func (o *MobileGatewaySIMRoute) GetResourceID() string {
	return o.ResourceID
}

// SetResourceID sets value to ResourceID
func (o *MobileGatewaySIMRoute) SetResourceID(v string) {
	o.ResourceID = v
}

// GetPrefix returns value of Prefix
func (o *MobileGatewaySIMRoute) GetPrefix() string {
	return o.Prefix
}

// SetPrefix sets value to Prefix
func (o *MobileGatewaySIMRoute) SetPrefix(v string) {
	o.Prefix = v
}

// GetICCID returns value of ICCID
func (o *MobileGatewaySIMRoute) GetICCID() string {
	return o.ICCID
}

// SetICCID sets value to ICCID
func (o *MobileGatewaySIMRoute) SetICCID(v string) {
	o.ICCID = v
}

/*************************************************
* MobileGatewaySIMRouteParam
*************************************************/

// MobileGatewaySIMRouteParam represents API parameter/response structure
type MobileGatewaySIMRouteParam struct {
	ResourceID string
	Prefix     string
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewaySIMRouteParam) setDefaults() interface{} {
	return &struct {
		ResourceID string
		Prefix     string
	}{
		ResourceID: o.GetResourceID(),
		Prefix:     o.GetPrefix(),
	}
}

// GetResourceID returns value of ResourceID
func (o *MobileGatewaySIMRouteParam) GetResourceID() string {
	return o.ResourceID
}

// SetResourceID sets value to ResourceID
func (o *MobileGatewaySIMRouteParam) SetResourceID(v string) {
	o.ResourceID = v
}

// GetPrefix returns value of Prefix
func (o *MobileGatewaySIMRouteParam) GetPrefix() string {
	return o.Prefix
}

// SetPrefix sets value to Prefix
func (o *MobileGatewaySIMRouteParam) SetPrefix(v string) {
	o.Prefix = v
}

/*************************************************
* MobileGatewaySIMInfo
*************************************************/

// MobileGatewaySIMInfo represents API parameter/response structure
type MobileGatewaySIMInfo struct {
	ICCID                      string
	IMSI                       []string
	IMEI                       string
	IP                         string
	SessionStatus              string
	IMEILock                   bool
	Registered                 bool
	Activated                  bool
	ResourceID                 string
	RegisteredDate             time.Time
	ActivatedDate              time.Time
	DeactivatedDate            time.Time
	SIMGroupID                 string
	TrafficBytesOfCurrentMonth *SIMTrafficBytes `mapconv:",recursive"`
	ConnectedIMEI              string
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewaySIMInfo) setDefaults() interface{} {
	return &struct {
		ICCID                      string
		IMSI                       []string
		IMEI                       string
		IP                         string
		SessionStatus              string
		IMEILock                   bool
		Registered                 bool
		Activated                  bool
		ResourceID                 string
		RegisteredDate             time.Time
		ActivatedDate              time.Time
		DeactivatedDate            time.Time
		SIMGroupID                 string
		TrafficBytesOfCurrentMonth *SIMTrafficBytes `mapconv:",recursive"`
		ConnectedIMEI              string
	}{
		ICCID:                      o.GetICCID(),
		IMSI:                       o.GetIMSI(),
		IMEI:                       o.GetIMEI(),
		IP:                         o.GetIP(),
		SessionStatus:              o.GetSessionStatus(),
		IMEILock:                   o.GetIMEILock(),
		Registered:                 o.GetRegistered(),
		Activated:                  o.GetActivated(),
		ResourceID:                 o.GetResourceID(),
		RegisteredDate:             o.GetRegisteredDate(),
		ActivatedDate:              o.GetActivatedDate(),
		DeactivatedDate:            o.GetDeactivatedDate(),
		SIMGroupID:                 o.GetSIMGroupID(),
		TrafficBytesOfCurrentMonth: o.GetTrafficBytesOfCurrentMonth(),
		ConnectedIMEI:              o.GetConnectedIMEI(),
	}
}

// GetICCID returns value of ICCID
func (o *MobileGatewaySIMInfo) GetICCID() string {
	return o.ICCID
}

// SetICCID sets value to ICCID
func (o *MobileGatewaySIMInfo) SetICCID(v string) {
	o.ICCID = v
}

// GetIMSI returns value of IMSI
func (o *MobileGatewaySIMInfo) GetIMSI() []string {
	return o.IMSI
}

// SetIMSI sets value to IMSI
func (o *MobileGatewaySIMInfo) SetIMSI(v []string) {
	o.IMSI = v
}

// GetIMEI returns value of IMEI
func (o *MobileGatewaySIMInfo) GetIMEI() string {
	return o.IMEI
}

// SetIMEI sets value to IMEI
func (o *MobileGatewaySIMInfo) SetIMEI(v string) {
	o.IMEI = v
}

// GetIP returns value of IP
func (o *MobileGatewaySIMInfo) GetIP() string {
	return o.IP
}

// SetIP sets value to IP
func (o *MobileGatewaySIMInfo) SetIP(v string) {
	o.IP = v
}

// GetSessionStatus returns value of SessionStatus
func (o *MobileGatewaySIMInfo) GetSessionStatus() string {
	return o.SessionStatus
}

// SetSessionStatus sets value to SessionStatus
func (o *MobileGatewaySIMInfo) SetSessionStatus(v string) {
	o.SessionStatus = v
}

// GetIMEILock returns value of IMEILock
func (o *MobileGatewaySIMInfo) GetIMEILock() bool {
	return o.IMEILock
}

// SetIMEILock sets value to IMEILock
func (o *MobileGatewaySIMInfo) SetIMEILock(v bool) {
	o.IMEILock = v
}

// GetRegistered returns value of Registered
func (o *MobileGatewaySIMInfo) GetRegistered() bool {
	return o.Registered
}

// SetRegistered sets value to Registered
func (o *MobileGatewaySIMInfo) SetRegistered(v bool) {
	o.Registered = v
}

// GetActivated returns value of Activated
func (o *MobileGatewaySIMInfo) GetActivated() bool {
	return o.Activated
}

// SetActivated sets value to Activated
func (o *MobileGatewaySIMInfo) SetActivated(v bool) {
	o.Activated = v
}

// GetResourceID returns value of ResourceID
func (o *MobileGatewaySIMInfo) GetResourceID() string {
	return o.ResourceID
}

// SetResourceID sets value to ResourceID
func (o *MobileGatewaySIMInfo) SetResourceID(v string) {
	o.ResourceID = v
}

// GetRegisteredDate returns value of RegisteredDate
func (o *MobileGatewaySIMInfo) GetRegisteredDate() time.Time {
	return o.RegisteredDate
}

// SetRegisteredDate sets value to RegisteredDate
func (o *MobileGatewaySIMInfo) SetRegisteredDate(v time.Time) {
	o.RegisteredDate = v
}

// GetActivatedDate returns value of ActivatedDate
func (o *MobileGatewaySIMInfo) GetActivatedDate() time.Time {
	return o.ActivatedDate
}

// SetActivatedDate sets value to ActivatedDate
func (o *MobileGatewaySIMInfo) SetActivatedDate(v time.Time) {
	o.ActivatedDate = v
}

// GetDeactivatedDate returns value of DeactivatedDate
func (o *MobileGatewaySIMInfo) GetDeactivatedDate() time.Time {
	return o.DeactivatedDate
}

// SetDeactivatedDate sets value to DeactivatedDate
func (o *MobileGatewaySIMInfo) SetDeactivatedDate(v time.Time) {
	o.DeactivatedDate = v
}

// GetSIMGroupID returns value of SIMGroupID
func (o *MobileGatewaySIMInfo) GetSIMGroupID() string {
	return o.SIMGroupID
}

// SetSIMGroupID sets value to SIMGroupID
func (o *MobileGatewaySIMInfo) SetSIMGroupID(v string) {
	o.SIMGroupID = v
}

// GetTrafficBytesOfCurrentMonth returns value of TrafficBytesOfCurrentMonth
func (o *MobileGatewaySIMInfo) GetTrafficBytesOfCurrentMonth() *SIMTrafficBytes {
	return o.TrafficBytesOfCurrentMonth
}

// SetTrafficBytesOfCurrentMonth sets value to TrafficBytesOfCurrentMonth
func (o *MobileGatewaySIMInfo) SetTrafficBytesOfCurrentMonth(v *SIMTrafficBytes) {
	o.TrafficBytesOfCurrentMonth = v
}

// GetConnectedIMEI returns value of ConnectedIMEI
func (o *MobileGatewaySIMInfo) GetConnectedIMEI() string {
	return o.ConnectedIMEI
}

// SetConnectedIMEI sets value to ConnectedIMEI
func (o *MobileGatewaySIMInfo) SetConnectedIMEI(v string) {
	o.ConnectedIMEI = v
}

/*************************************************
* SIMTrafficBytes
*************************************************/

// SIMTrafficBytes represents API parameter/response structure
type SIMTrafficBytes struct {
	UplinkBytes   int64
	DownlinkBytes int64
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIMTrafficBytes) setDefaults() interface{} {
	return &struct {
		UplinkBytes   int64
		DownlinkBytes int64
	}{
		UplinkBytes:   o.GetUplinkBytes(),
		DownlinkBytes: o.GetDownlinkBytes(),
	}
}

// GetUplinkBytes returns value of UplinkBytes
func (o *SIMTrafficBytes) GetUplinkBytes() int64 {
	return o.UplinkBytes
}

// SetUplinkBytes sets value to UplinkBytes
func (o *SIMTrafficBytes) SetUplinkBytes(v int64) {
	o.UplinkBytes = v
}

// GetDownlinkBytes returns value of DownlinkBytes
func (o *SIMTrafficBytes) GetDownlinkBytes() int64 {
	return o.DownlinkBytes
}

// SetDownlinkBytes sets value to DownlinkBytes
func (o *SIMTrafficBytes) SetDownlinkBytes(v int64) {
	o.DownlinkBytes = v
}

/*************************************************
* MobileGatewayAddSIMRequest
*************************************************/

// MobileGatewayAddSIMRequest represents API parameter/response structure
type MobileGatewayAddSIMRequest struct {
	SIMID string `json:"resource_id" mapconv:"ResourceID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayAddSIMRequest) setDefaults() interface{} {
	return &struct {
		SIMID string `json:"resource_id" mapconv:"ResourceID"`
	}{
		SIMID: o.GetSIMID(),
	}
}

// GetSIMID returns value of SIMID
func (o *MobileGatewayAddSIMRequest) GetSIMID() string {
	return o.SIMID
}

// SetSIMID sets value to SIMID
func (o *MobileGatewayAddSIMRequest) SetSIMID(v string) {
	o.SIMID = v
}

/*************************************************
* MobileGatewaySIMLogs
*************************************************/

// MobileGatewaySIMLogs represents API parameter/response structure
type MobileGatewaySIMLogs struct {
	Date          time.Time
	SessionStatus string
	ResourceID    string
	IMEI          string
	IMSI          string
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewaySIMLogs) setDefaults() interface{} {
	return &struct {
		Date          time.Time
		SessionStatus string
		ResourceID    string
		IMEI          string
		IMSI          string
	}{
		Date:          o.GetDate(),
		SessionStatus: o.GetSessionStatus(),
		ResourceID:    o.GetResourceID(),
		IMEI:          o.GetIMEI(),
		IMSI:          o.GetIMSI(),
	}
}

// GetDate returns value of Date
func (o *MobileGatewaySIMLogs) GetDate() time.Time {
	return o.Date
}

// SetDate sets value to Date
func (o *MobileGatewaySIMLogs) SetDate(v time.Time) {
	o.Date = v
}

// GetSessionStatus returns value of SessionStatus
func (o *MobileGatewaySIMLogs) GetSessionStatus() string {
	return o.SessionStatus
}

// SetSessionStatus sets value to SessionStatus
func (o *MobileGatewaySIMLogs) SetSessionStatus(v string) {
	o.SessionStatus = v
}

// GetResourceID returns value of ResourceID
func (o *MobileGatewaySIMLogs) GetResourceID() string {
	return o.ResourceID
}

// SetResourceID sets value to ResourceID
func (o *MobileGatewaySIMLogs) SetResourceID(v string) {
	o.ResourceID = v
}

// GetIMEI returns value of IMEI
func (o *MobileGatewaySIMLogs) GetIMEI() string {
	return o.IMEI
}

// SetIMEI sets value to IMEI
func (o *MobileGatewaySIMLogs) SetIMEI(v string) {
	o.IMEI = v
}

// GetIMSI returns value of IMSI
func (o *MobileGatewaySIMLogs) GetIMSI() string {
	return o.IMSI
}

// SetIMSI sets value to IMSI
func (o *MobileGatewaySIMLogs) SetIMSI(v string) {
	o.IMSI = v
}

/*************************************************
* MobileGatewayTrafficControl
*************************************************/

// MobileGatewayTrafficControl represents API parameter/response structure
type MobileGatewayTrafficControl struct {
	TrafficQuotaInMB       int
	BandWidthLimitInKbps   int
	EmailNotifyEnabled     bool   `mapconv:"EMailConfig.Enabled"`
	SlackNotifyEnabled     bool   `mapconv:"SlackConfig.Enabled"`
	SlackNotifyWebhooksURL string `mapconv:"SlackConfig.IncomingWebhooksURL"`
	AutoTrafficShaping     bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayTrafficControl) setDefaults() interface{} {
	return &struct {
		TrafficQuotaInMB       int
		BandWidthLimitInKbps   int
		EmailNotifyEnabled     bool   `mapconv:"EMailConfig.Enabled"`
		SlackNotifyEnabled     bool   `mapconv:"SlackConfig.Enabled"`
		SlackNotifyWebhooksURL string `mapconv:"SlackConfig.IncomingWebhooksURL"`
		AutoTrafficShaping     bool
	}{
		TrafficQuotaInMB:       o.GetTrafficQuotaInMB(),
		BandWidthLimitInKbps:   o.GetBandWidthLimitInKbps(),
		EmailNotifyEnabled:     o.GetEmailNotifyEnabled(),
		SlackNotifyEnabled:     o.GetSlackNotifyEnabled(),
		SlackNotifyWebhooksURL: o.GetSlackNotifyWebhooksURL(),
		AutoTrafficShaping:     o.GetAutoTrafficShaping(),
	}
}

// GetTrafficQuotaInMB returns value of TrafficQuotaInMB
func (o *MobileGatewayTrafficControl) GetTrafficQuotaInMB() int {
	return o.TrafficQuotaInMB
}

// SetTrafficQuotaInMB sets value to TrafficQuotaInMB
func (o *MobileGatewayTrafficControl) SetTrafficQuotaInMB(v int) {
	o.TrafficQuotaInMB = v
}

// GetBandWidthLimitInKbps returns value of BandWidthLimitInKbps
func (o *MobileGatewayTrafficControl) GetBandWidthLimitInKbps() int {
	return o.BandWidthLimitInKbps
}

// SetBandWidthLimitInKbps sets value to BandWidthLimitInKbps
func (o *MobileGatewayTrafficControl) SetBandWidthLimitInKbps(v int) {
	o.BandWidthLimitInKbps = v
}

// GetEmailNotifyEnabled returns value of EmailNotifyEnabled
func (o *MobileGatewayTrafficControl) GetEmailNotifyEnabled() bool {
	return o.EmailNotifyEnabled
}

// SetEmailNotifyEnabled sets value to EmailNotifyEnabled
func (o *MobileGatewayTrafficControl) SetEmailNotifyEnabled(v bool) {
	o.EmailNotifyEnabled = v
}

// GetSlackNotifyEnabled returns value of SlackNotifyEnabled
func (o *MobileGatewayTrafficControl) GetSlackNotifyEnabled() bool {
	return o.SlackNotifyEnabled
}

// SetSlackNotifyEnabled sets value to SlackNotifyEnabled
func (o *MobileGatewayTrafficControl) SetSlackNotifyEnabled(v bool) {
	o.SlackNotifyEnabled = v
}

// GetSlackNotifyWebhooksURL returns value of SlackNotifyWebhooksURL
func (o *MobileGatewayTrafficControl) GetSlackNotifyWebhooksURL() string {
	return o.SlackNotifyWebhooksURL
}

// SetSlackNotifyWebhooksURL sets value to SlackNotifyWebhooksURL
func (o *MobileGatewayTrafficControl) SetSlackNotifyWebhooksURL(v string) {
	o.SlackNotifyWebhooksURL = v
}

// GetAutoTrafficShaping returns value of AutoTrafficShaping
func (o *MobileGatewayTrafficControl) GetAutoTrafficShaping() bool {
	return o.AutoTrafficShaping
}

// SetAutoTrafficShaping sets value to AutoTrafficShaping
func (o *MobileGatewayTrafficControl) SetAutoTrafficShaping(v bool) {
	o.AutoTrafficShaping = v
}

/*************************************************
* MobileGatewayTrafficStatus
*************************************************/

// MobileGatewayTrafficStatus represents API parameter/response structure
type MobileGatewayTrafficStatus struct {
	UplinkBytes    types.StringNumber
	DownlinkBytes  types.StringNumber
	TrafficShaping bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *MobileGatewayTrafficStatus) setDefaults() interface{} {
	return &struct {
		UplinkBytes    types.StringNumber
		DownlinkBytes  types.StringNumber
		TrafficShaping bool
	}{
		UplinkBytes:    o.GetUplinkBytes(),
		DownlinkBytes:  o.GetDownlinkBytes(),
		TrafficShaping: o.GetTrafficShaping(),
	}
}

// GetUplinkBytes returns value of UplinkBytes
func (o *MobileGatewayTrafficStatus) GetUplinkBytes() types.StringNumber {
	return o.UplinkBytes
}

// SetUplinkBytes sets value to UplinkBytes
func (o *MobileGatewayTrafficStatus) SetUplinkBytes(v types.StringNumber) {
	o.UplinkBytes = v
}

// GetDownlinkBytes returns value of DownlinkBytes
func (o *MobileGatewayTrafficStatus) GetDownlinkBytes() types.StringNumber {
	return o.DownlinkBytes
}

// SetDownlinkBytes sets value to DownlinkBytes
func (o *MobileGatewayTrafficStatus) SetDownlinkBytes(v types.StringNumber) {
	o.DownlinkBytes = v
}

// GetTrafficShaping returns value of TrafficShaping
func (o *MobileGatewayTrafficStatus) GetTrafficShaping() bool {
	return o.TrafficShaping
}

// SetTrafficShaping sets value to TrafficShaping
func (o *MobileGatewayTrafficStatus) SetTrafficShaping(v bool) {
	o.TrafficShaping = v
}

/*************************************************
* NFS
*************************************************/

// NFS represents API parameter/response structure
type NFS struct {
	ID                      types.ID
	Name                    string
	Description             string
	Tags                    types.Tags
	Availability            types.EAvailability
	Class                   string
	InstanceHostName        string                      `mapconv:"Instance.Host.Name"`
	InstanceHostInfoURL     string                      `mapconv:"Instance.Host.InfoURL"`
	InstanceStatus          types.EServerInstanceStatus `mapconv:"Instance.Status"`
	InstanceStatusChangedAt time.Time                   `mapconv:"Instance.StatusChangedAt"`
	Interfaces              []*InterfaceView            `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
	PlanID                  types.ID                    `mapconv:"Remark.Plan.ID/Plan.ID"`
	SwitchID                types.ID                    `mapconv:"Remark.Switch.ID"`
	DefaultRoute            string                      `mapconv:"Remark.Network.DefaultRoute"`
	NetworkMaskLen          int                         `mapconv:"Remark.Network.NetworkMaskLen"`
	IPAddresses             []string                    `mapconv:"Remark.[]Servers.IPAddress"`
	ZoneID                  types.ID                    `mapconv:"Remark.Zone.ID"`
	IconID                  types.ID                    `mapconv:"Icon.ID"`
	CreatedAt               time.Time
	ModifiedAt              time.Time
	SwitchName              string `mapconv:"Switch.Name"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *NFS) setDefaults() interface{} {
	return &struct {
		ID                      types.ID
		Name                    string
		Description             string
		Tags                    types.Tags
		Availability            types.EAvailability
		Class                   string
		InstanceHostName        string                      `mapconv:"Instance.Host.Name"`
		InstanceHostInfoURL     string                      `mapconv:"Instance.Host.InfoURL"`
		InstanceStatus          types.EServerInstanceStatus `mapconv:"Instance.Status"`
		InstanceStatusChangedAt time.Time                   `mapconv:"Instance.StatusChangedAt"`
		Interfaces              []*InterfaceView            `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
		PlanID                  types.ID                    `mapconv:"Remark.Plan.ID/Plan.ID"`
		SwitchID                types.ID                    `mapconv:"Remark.Switch.ID"`
		DefaultRoute            string                      `mapconv:"Remark.Network.DefaultRoute"`
		NetworkMaskLen          int                         `mapconv:"Remark.Network.NetworkMaskLen"`
		IPAddresses             []string                    `mapconv:"Remark.[]Servers.IPAddress"`
		ZoneID                  types.ID                    `mapconv:"Remark.Zone.ID"`
		IconID                  types.ID                    `mapconv:"Icon.ID"`
		CreatedAt               time.Time
		ModifiedAt              time.Time
		SwitchName              string `mapconv:"Switch.Name"`
	}{
		ID:                      o.GetID(),
		Name:                    o.GetName(),
		Description:             o.GetDescription(),
		Tags:                    o.GetTags(),
		Availability:            o.GetAvailability(),
		Class:                   o.GetClass(),
		InstanceHostName:        o.GetInstanceHostName(),
		InstanceHostInfoURL:     o.GetInstanceHostInfoURL(),
		InstanceStatus:          o.GetInstanceStatus(),
		InstanceStatusChangedAt: o.GetInstanceStatusChangedAt(),
		Interfaces:              o.GetInterfaces(),
		PlanID:                  o.GetPlanID(),
		SwitchID:                o.GetSwitchID(),
		DefaultRoute:            o.GetDefaultRoute(),
		NetworkMaskLen:          o.GetNetworkMaskLen(),
		IPAddresses:             o.GetIPAddresses(),
		ZoneID:                  o.GetZoneID(),
		IconID:                  o.GetIconID(),
		CreatedAt:               o.GetCreatedAt(),
		ModifiedAt:              o.GetModifiedAt(),
		SwitchName:              o.GetSwitchName(),
	}
}

// GetID returns value of ID
func (o *NFS) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *NFS) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *NFS) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *NFS) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *NFS) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *NFS) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *NFS) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *NFS) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *NFS) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *NFS) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *NFS) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *NFS) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *NFS) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *NFS) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *NFS) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *NFS) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *NFS) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *NFS) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetClass returns value of Class
func (o *NFS) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *NFS) SetClass(v string) {
	o.Class = v
}

// GetInstanceHostName returns value of InstanceHostName
func (o *NFS) GetInstanceHostName() string {
	return o.InstanceHostName
}

// SetInstanceHostName sets value to InstanceHostName
func (o *NFS) SetInstanceHostName(v string) {
	o.InstanceHostName = v
}

// GetInstanceHostInfoURL returns value of InstanceHostInfoURL
func (o *NFS) GetInstanceHostInfoURL() string {
	return o.InstanceHostInfoURL
}

// SetInstanceHostInfoURL sets value to InstanceHostInfoURL
func (o *NFS) SetInstanceHostInfoURL(v string) {
	o.InstanceHostInfoURL = v
}

// GetInstanceStatus returns value of InstanceStatus
func (o *NFS) GetInstanceStatus() types.EServerInstanceStatus {
	return o.InstanceStatus
}

// SetInstanceStatus sets value to InstanceStatus
func (o *NFS) SetInstanceStatus(v types.EServerInstanceStatus) {
	o.InstanceStatus = v
}

// GetInstanceStatusChangedAt returns value of InstanceStatusChangedAt
func (o *NFS) GetInstanceStatusChangedAt() time.Time {
	return o.InstanceStatusChangedAt
}

// SetInstanceStatusChangedAt sets value to InstanceStatusChangedAt
func (o *NFS) SetInstanceStatusChangedAt(v time.Time) {
	o.InstanceStatusChangedAt = v
}

// GetInterfaces returns value of Interfaces
func (o *NFS) GetInterfaces() []*InterfaceView {
	return o.Interfaces
}

// SetInterfaces sets value to Interfaces
func (o *NFS) SetInterfaces(v []*InterfaceView) {
	o.Interfaces = v
}

// GetPlanID returns value of PlanID
func (o *NFS) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *NFS) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetSwitchID returns value of SwitchID
func (o *NFS) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *NFS) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *NFS) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *NFS) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *NFS) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *NFS) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetIPAddresses returns value of IPAddresses
func (o *NFS) GetIPAddresses() []string {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *NFS) SetIPAddresses(v []string) {
	o.IPAddresses = v
}

// GetZoneID returns value of ZoneID
func (o *NFS) GetZoneID() types.ID {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *NFS) SetZoneID(v types.ID) {
	o.ZoneID = v
}

// GetIconID returns value of IconID
func (o *NFS) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *NFS) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *NFS) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *NFS) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *NFS) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *NFS) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetSwitchName returns value of SwitchName
func (o *NFS) GetSwitchName() string {
	return o.SwitchName
}

// SetSwitchName sets value to SwitchName
func (o *NFS) SetSwitchName(v string) {
	o.SwitchName = v
}

/*************************************************
* NFSCreateRequest
*************************************************/

// NFSCreateRequest represents API parameter/response structure
type NFSCreateRequest struct {
	SwitchID       types.ID `mapconv:"Remark.Switch.ID"`
	PlanID         types.ID `mapconv:"Remark.Plan.ID/Plan.ID"`
	IPAddresses    []string `mapconv:"Remark.[]Servers.IPAddress"`
	NetworkMaskLen int      `mapconv:"Remark.Network.NetworkMaskLen"`
	DefaultRoute   string   `mapconv:"Remark.Network.DefaultRoute"`
	Name           string
	Description    string
	Tags           types.Tags
	IconID         types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *NFSCreateRequest) setDefaults() interface{} {
	return &struct {
		SwitchID       types.ID `mapconv:"Remark.Switch.ID"`
		PlanID         types.ID `mapconv:"Remark.Plan.ID/Plan.ID"`
		IPAddresses    []string `mapconv:"Remark.[]Servers.IPAddress"`
		NetworkMaskLen int      `mapconv:"Remark.Network.NetworkMaskLen"`
		DefaultRoute   string   `mapconv:"Remark.Network.DefaultRoute"`
		Name           string
		Description    string
		Tags           types.Tags
		IconID         types.ID `mapconv:"Icon.ID"`
		Class          string
	}{
		SwitchID:       o.GetSwitchID(),
		PlanID:         o.GetPlanID(),
		IPAddresses:    o.GetIPAddresses(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
		DefaultRoute:   o.GetDefaultRoute(),
		Name:           o.GetName(),
		Description:    o.GetDescription(),
		Tags:           o.GetTags(),
		IconID:         o.GetIconID(),
		Class:          "nfs",
	}
}

// GetSwitchID returns value of SwitchID
func (o *NFSCreateRequest) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *NFSCreateRequest) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetPlanID returns value of PlanID
func (o *NFSCreateRequest) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *NFSCreateRequest) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetIPAddresses returns value of IPAddresses
func (o *NFSCreateRequest) GetIPAddresses() []string {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *NFSCreateRequest) SetIPAddresses(v []string) {
	o.IPAddresses = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *NFSCreateRequest) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *NFSCreateRequest) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *NFSCreateRequest) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *NFSCreateRequest) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetName returns value of Name
func (o *NFSCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *NFSCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *NFSCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *NFSCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *NFSCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *NFSCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *NFSCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *NFSCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *NFSCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *NFSCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *NFSCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *NFSCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* NFSUpdateRequest
*************************************************/

// NFSUpdateRequest represents API parameter/response structure
type NFSUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *NFSUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *NFSUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *NFSUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *NFSUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *NFSUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *NFSUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *NFSUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *NFSUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *NFSUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *NFSUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *NFSUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *NFSUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *NFSUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* FreeDiskSizeActivity
*************************************************/

// FreeDiskSizeActivity represents API parameter/response structure
type FreeDiskSizeActivity struct {
	Values []*MonitorFreeDiskSizeValue `mapconv:"[]FreeDiskSize"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *FreeDiskSizeActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorFreeDiskSizeValue `mapconv:"[]FreeDiskSize"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *FreeDiskSizeActivity) GetValues() []*MonitorFreeDiskSizeValue {
	return o.Values
}

// SetValues sets value to Values
func (o *FreeDiskSizeActivity) SetValues(v []*MonitorFreeDiskSizeValue) {
	o.Values = v
}

/*************************************************
* MonitorFreeDiskSizeValue
*************************************************/

// MonitorFreeDiskSizeValue represents API parameter/response structure
type MonitorFreeDiskSizeValue struct {
	Time         time.Time `mapconv:",omitempty"`
	FreeDiskSize float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorFreeDiskSizeValue) setDefaults() interface{} {
	return &struct {
		Time         time.Time `mapconv:",omitempty"`
		FreeDiskSize float64   `mapconv:",omitempty"`
	}{
		Time:         o.GetTime(),
		FreeDiskSize: o.GetFreeDiskSize(),
	}
}

// GetTime returns value of Time
func (o *MonitorFreeDiskSizeValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorFreeDiskSizeValue) SetTime(v time.Time) {
	o.Time = v
}

// GetFreeDiskSize returns value of FreeDiskSize
func (o *MonitorFreeDiskSizeValue) GetFreeDiskSize() float64 {
	return o.FreeDiskSize
}

// SetFreeDiskSize sets value to FreeDiskSize
func (o *MonitorFreeDiskSizeValue) SetFreeDiskSize(v float64) {
	o.FreeDiskSize = v
}

/*************************************************
* Note
*************************************************/

// Note represents API parameter/response structure
type Note struct {
	ID           types.ID
	Name         string
	Description  string
	Tags         types.Tags
	Availability types.EAvailability
	Scope        types.EScope
	Class        string
	Content      string
	IconID       types.ID `mapconv:"Icon.ID"`
	CreatedAt    time.Time
	ModifiedAt   time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *Note) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		Tags         types.Tags
		Availability types.EAvailability
		Scope        types.EScope
		Class        string
		Content      string
		IconID       types.ID `mapconv:"Icon.ID"`
		CreatedAt    time.Time
		ModifiedAt   time.Time
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		Scope:        o.GetScope(),
		Class:        o.GetClass(),
		Content:      o.GetContent(),
		IconID:       o.GetIconID(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
	}
}

// GetID returns value of ID
func (o *Note) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Note) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Note) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Note) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Note) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Note) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Note) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Note) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Note) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Note) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *Note) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *Note) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *Note) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *Note) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *Note) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *Note) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *Note) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *Note) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetScope returns value of Scope
func (o *Note) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *Note) SetScope(v types.EScope) {
	o.Scope = v
}

// GetClass returns value of Class
func (o *Note) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *Note) SetClass(v string) {
	o.Class = v
}

// GetContent returns value of Content
func (o *Note) GetContent() string {
	return o.Content
}

// SetContent sets value to Content
func (o *Note) SetContent(v string) {
	o.Content = v
}

// GetIconID returns value of IconID
func (o *Note) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *Note) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Note) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Note) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *Note) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *Note) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* NoteCreateRequest
*************************************************/

// NoteCreateRequest represents API parameter/response structure
type NoteCreateRequest struct {
	Name    string
	Tags    types.Tags
	IconID  types.ID `mapconv:"Icon.ID"`
	Class   string
	Content string
}

// setDefaults implements iaas.argumentDefaulter
func (o *NoteCreateRequest) setDefaults() interface{} {
	return &struct {
		Name    string
		Tags    types.Tags
		IconID  types.ID `mapconv:"Icon.ID"`
		Class   string
		Content string
	}{
		Name:    o.GetName(),
		Tags:    o.GetTags(),
		IconID:  o.GetIconID(),
		Class:   o.GetClass(),
		Content: o.GetContent(),
	}
}

// GetName returns value of Name
func (o *NoteCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *NoteCreateRequest) SetName(v string) {
	o.Name = v
}

// GetTags returns value of Tags
func (o *NoteCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *NoteCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *NoteCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *NoteCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *NoteCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *NoteCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *NoteCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *NoteCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetClass returns value of Class
func (o *NoteCreateRequest) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *NoteCreateRequest) SetClass(v string) {
	o.Class = v
}

// GetContent returns value of Content
func (o *NoteCreateRequest) GetContent() string {
	return o.Content
}

// SetContent sets value to Content
func (o *NoteCreateRequest) SetContent(v string) {
	o.Content = v
}

/*************************************************
* NoteUpdateRequest
*************************************************/

// NoteUpdateRequest represents API parameter/response structure
type NoteUpdateRequest struct {
	Name    string
	Tags    types.Tags
	IconID  types.ID `mapconv:"Icon.ID"`
	Class   string
	Content string
}

// setDefaults implements iaas.argumentDefaulter
func (o *NoteUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name    string
		Tags    types.Tags
		IconID  types.ID `mapconv:"Icon.ID"`
		Class   string
		Content string
	}{
		Name:    o.GetName(),
		Tags:    o.GetTags(),
		IconID:  o.GetIconID(),
		Class:   o.GetClass(),
		Content: o.GetContent(),
	}
}

// GetName returns value of Name
func (o *NoteUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *NoteUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetTags returns value of Tags
func (o *NoteUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *NoteUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *NoteUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *NoteUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *NoteUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *NoteUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *NoteUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *NoteUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetClass returns value of Class
func (o *NoteUpdateRequest) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *NoteUpdateRequest) SetClass(v string) {
	o.Class = v
}

// GetContent returns value of Content
func (o *NoteUpdateRequest) GetContent() string {
	return o.Content
}

// SetContent sets value to Content
func (o *NoteUpdateRequest) SetContent(v string) {
	o.Content = v
}

/*************************************************
* PacketFilter
*************************************************/

// PacketFilter represents API parameter/response structure
type PacketFilter struct {
	ID                  types.ID
	Name                string
	Description         string
	RequiredHostVersion types.StringNumber
	Expression          []*PacketFilterExpression `mapconv:"[]Expression,recursive"`
	ExpressionHash      string
	CreatedAt           time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *PacketFilter) setDefaults() interface{} {
	return &struct {
		ID                  types.ID
		Name                string
		Description         string
		RequiredHostVersion types.StringNumber
		Expression          []*PacketFilterExpression `mapconv:"[]Expression,recursive"`
		ExpressionHash      string
		CreatedAt           time.Time
	}{
		ID:                  o.GetID(),
		Name:                o.GetName(),
		Description:         o.GetDescription(),
		RequiredHostVersion: o.GetRequiredHostVersion(),
		Expression:          o.GetExpression(),
		ExpressionHash:      o.GetExpressionHash(),
		CreatedAt:           o.GetCreatedAt(),
	}
}

// GetID returns value of ID
func (o *PacketFilter) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *PacketFilter) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *PacketFilter) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *PacketFilter) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *PacketFilter) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *PacketFilter) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *PacketFilter) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *PacketFilter) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *PacketFilter) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *PacketFilter) SetDescription(v string) {
	o.Description = v
}

// GetRequiredHostVersion returns value of RequiredHostVersion
func (o *PacketFilter) GetRequiredHostVersion() types.StringNumber {
	return o.RequiredHostVersion
}

// SetRequiredHostVersion sets value to RequiredHostVersion
func (o *PacketFilter) SetRequiredHostVersion(v types.StringNumber) {
	o.RequiredHostVersion = v
}

// GetExpression returns value of Expression
func (o *PacketFilter) GetExpression() []*PacketFilterExpression {
	return o.Expression
}

// SetExpression sets value to Expression
func (o *PacketFilter) SetExpression(v []*PacketFilterExpression) {
	o.Expression = v
}

// GetExpressionHash returns value of ExpressionHash
func (o *PacketFilter) GetExpressionHash() string {
	return o.ExpressionHash
}

// SetExpressionHash sets value to ExpressionHash
func (o *PacketFilter) SetExpressionHash(v string) {
	o.ExpressionHash = v
}

// GetCreatedAt returns value of CreatedAt
func (o *PacketFilter) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *PacketFilter) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

/*************************************************
* PacketFilterExpression
*************************************************/

// PacketFilterExpression represents API parameter/response structure
type PacketFilterExpression struct {
	Protocol        types.Protocol
	SourceNetwork   types.PacketFilterNetwork
	SourcePort      types.PacketFilterPort
	DestinationPort types.PacketFilterPort
	Action          types.Action
	Description     string
}

// setDefaults implements iaas.argumentDefaulter
func (o *PacketFilterExpression) setDefaults() interface{} {
	return &struct {
		Protocol        types.Protocol
		SourceNetwork   types.PacketFilterNetwork
		SourcePort      types.PacketFilterPort
		DestinationPort types.PacketFilterPort
		Action          types.Action
		Description     string
	}{
		Protocol:        o.GetProtocol(),
		SourceNetwork:   o.GetSourceNetwork(),
		SourcePort:      o.GetSourcePort(),
		DestinationPort: o.GetDestinationPort(),
		Action:          o.GetAction(),
		Description:     o.GetDescription(),
	}
}

// GetProtocol returns value of Protocol
func (o *PacketFilterExpression) GetProtocol() types.Protocol {
	return o.Protocol
}

// SetProtocol sets value to Protocol
func (o *PacketFilterExpression) SetProtocol(v types.Protocol) {
	o.Protocol = v
}

// GetSourceNetwork returns value of SourceNetwork
func (o *PacketFilterExpression) GetSourceNetwork() types.PacketFilterNetwork {
	return o.SourceNetwork
}

// SetSourceNetwork sets value to SourceNetwork
func (o *PacketFilterExpression) SetSourceNetwork(v types.PacketFilterNetwork) {
	o.SourceNetwork = v
}

// GetSourcePort returns value of SourcePort
func (o *PacketFilterExpression) GetSourcePort() types.PacketFilterPort {
	return o.SourcePort
}

// SetSourcePort sets value to SourcePort
func (o *PacketFilterExpression) SetSourcePort(v types.PacketFilterPort) {
	o.SourcePort = v
}

// GetDestinationPort returns value of DestinationPort
func (o *PacketFilterExpression) GetDestinationPort() types.PacketFilterPort {
	return o.DestinationPort
}

// SetDestinationPort sets value to DestinationPort
func (o *PacketFilterExpression) SetDestinationPort(v types.PacketFilterPort) {
	o.DestinationPort = v
}

// GetAction returns value of Action
func (o *PacketFilterExpression) GetAction() types.Action {
	return o.Action
}

// SetAction sets value to Action
func (o *PacketFilterExpression) SetAction(v types.Action) {
	o.Action = v
}

// GetDescription returns value of Description
func (o *PacketFilterExpression) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *PacketFilterExpression) SetDescription(v string) {
	o.Description = v
}

/*************************************************
* PacketFilterCreateRequest
*************************************************/

// PacketFilterCreateRequest represents API parameter/response structure
type PacketFilterCreateRequest struct {
	Name        string
	Description string
	Expression  []*PacketFilterExpression `mapconv:"[]Expression,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *PacketFilterCreateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Expression  []*PacketFilterExpression `mapconv:"[]Expression,recursive"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Expression:  o.GetExpression(),
	}
}

// GetName returns value of Name
func (o *PacketFilterCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *PacketFilterCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *PacketFilterCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *PacketFilterCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetExpression returns value of Expression
func (o *PacketFilterCreateRequest) GetExpression() []*PacketFilterExpression {
	return o.Expression
}

// SetExpression sets value to Expression
func (o *PacketFilterCreateRequest) SetExpression(v []*PacketFilterExpression) {
	o.Expression = v
}

/*************************************************
* PacketFilterUpdateRequest
*************************************************/

// PacketFilterUpdateRequest represents API parameter/response structure
type PacketFilterUpdateRequest struct {
	Name        string
	Description string
	Expression  []*PacketFilterExpression `mapconv:"[]Expression,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *PacketFilterUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Expression  []*PacketFilterExpression `mapconv:"[]Expression,recursive"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Expression:  o.GetExpression(),
	}
}

// GetName returns value of Name
func (o *PacketFilterUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *PacketFilterUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *PacketFilterUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *PacketFilterUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetExpression returns value of Expression
func (o *PacketFilterUpdateRequest) GetExpression() []*PacketFilterExpression {
	return o.Expression
}

// SetExpression sets value to Expression
func (o *PacketFilterUpdateRequest) SetExpression(v []*PacketFilterExpression) {
	o.Expression = v
}

/*************************************************
* PrivateHost
*************************************************/

// PrivateHost represents API parameter/response structure
type PrivateHost struct {
	ID               types.ID
	Name             string
	Description      string
	Tags             types.Tags
	IconID           types.ID `mapconv:"Icon.ID"`
	CreatedAt        time.Time
	PlanID           types.ID `mapconv:"Plan.ID,omitempty"`
	PlanName         string   `mapconv:"Plan.Name"`
	PlanClass        string   `mapconv:"Plan.Class"`
	CPU              int      `mapconv:"Plan.CPU"`
	MemoryMB         int      `mapconv:"Plan.MemoryMB"`
	AssignedCPU      int
	AssignedMemoryMB int
	HostName         string `mapconv:"Host.Name"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *PrivateHost) setDefaults() interface{} {
	return &struct {
		ID               types.ID
		Name             string
		Description      string
		Tags             types.Tags
		IconID           types.ID `mapconv:"Icon.ID"`
		CreatedAt        time.Time
		PlanID           types.ID `mapconv:"Plan.ID,omitempty"`
		PlanName         string   `mapconv:"Plan.Name"`
		PlanClass        string   `mapconv:"Plan.Class"`
		CPU              int      `mapconv:"Plan.CPU"`
		MemoryMB         int      `mapconv:"Plan.MemoryMB"`
		AssignedCPU      int
		AssignedMemoryMB int
		HostName         string `mapconv:"Host.Name"`
	}{
		ID:               o.GetID(),
		Name:             o.GetName(),
		Description:      o.GetDescription(),
		Tags:             o.GetTags(),
		IconID:           o.GetIconID(),
		CreatedAt:        o.GetCreatedAt(),
		PlanID:           o.GetPlanID(),
		PlanName:         o.GetPlanName(),
		PlanClass:        o.GetPlanClass(),
		CPU:              o.GetCPU(),
		MemoryMB:         o.GetMemoryMB(),
		AssignedCPU:      o.GetAssignedCPU(),
		AssignedMemoryMB: o.GetAssignedMemoryMB(),
		HostName:         o.GetHostName(),
	}
}

// GetID returns value of ID
func (o *PrivateHost) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *PrivateHost) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *PrivateHost) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *PrivateHost) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *PrivateHost) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *PrivateHost) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *PrivateHost) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *PrivateHost) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *PrivateHost) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *PrivateHost) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *PrivateHost) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *PrivateHost) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *PrivateHost) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *PrivateHost) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *PrivateHost) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *PrivateHost) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *PrivateHost) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *PrivateHost) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *PrivateHost) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *PrivateHost) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetPlanID returns value of PlanID
func (o *PrivateHost) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *PrivateHost) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetPlanName returns value of PlanName
func (o *PrivateHost) GetPlanName() string {
	return o.PlanName
}

// SetPlanName sets value to PlanName
func (o *PrivateHost) SetPlanName(v string) {
	o.PlanName = v
}

// GetPlanClass returns value of PlanClass
func (o *PrivateHost) GetPlanClass() string {
	return o.PlanClass
}

// SetPlanClass sets value to PlanClass
func (o *PrivateHost) SetPlanClass(v string) {
	o.PlanClass = v
}

// GetCPU returns value of CPU
func (o *PrivateHost) GetCPU() int {
	return o.CPU
}

// SetCPU sets value to CPU
func (o *PrivateHost) SetCPU(v int) {
	o.CPU = v
}

// GetMemoryMB returns value of MemoryMB
func (o *PrivateHost) GetMemoryMB() int {
	return o.MemoryMB
}

// SetMemoryMB sets value to MemoryMB
func (o *PrivateHost) SetMemoryMB(v int) {
	o.MemoryMB = v
}

// GetMemoryGB .
func (o *PrivateHost) GetMemoryGB() int {
	return accessor.GetMemoryGB(o)
}

// SetMemoryGB .
func (o *PrivateHost) SetMemoryGB(memory int) {
	accessor.SetMemoryGB(o, memory)
}

// GetAssignedCPU returns value of AssignedCPU
func (o *PrivateHost) GetAssignedCPU() int {
	return o.AssignedCPU
}

// SetAssignedCPU sets value to AssignedCPU
func (o *PrivateHost) SetAssignedCPU(v int) {
	o.AssignedCPU = v
}

// GetAssignedMemoryMB returns value of AssignedMemoryMB
func (o *PrivateHost) GetAssignedMemoryMB() int {
	return o.AssignedMemoryMB
}

// SetAssignedMemoryMB sets value to AssignedMemoryMB
func (o *PrivateHost) SetAssignedMemoryMB(v int) {
	o.AssignedMemoryMB = v
}

// GetAssignedMemoryGB .
func (o *PrivateHost) GetAssignedMemoryGB() int {
	return accessor.GetAssignedMemoryGB(o)
}

// SetAssignedMemoryGB .
func (o *PrivateHost) SetAssignedMemoryGB(memory int) {
	accessor.SetAssignedMemoryGB(o, memory)
}

// GetHostName returns value of HostName
func (o *PrivateHost) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *PrivateHost) SetHostName(v string) {
	o.HostName = v
}

/*************************************************
* PrivateHostCreateRequest
*************************************************/

// PrivateHostCreateRequest represents API parameter/response structure
type PrivateHostCreateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
	PlanID      types.ID `mapconv:"Plan.ID,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *PrivateHostCreateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
		PlanID      types.ID `mapconv:"Plan.ID,omitempty"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
		PlanID:      o.GetPlanID(),
	}
}

// GetName returns value of Name
func (o *PrivateHostCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *PrivateHostCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *PrivateHostCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *PrivateHostCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *PrivateHostCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *PrivateHostCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *PrivateHostCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *PrivateHostCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *PrivateHostCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *PrivateHostCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *PrivateHostCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *PrivateHostCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetPlanID returns value of PlanID
func (o *PrivateHostCreateRequest) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *PrivateHostCreateRequest) SetPlanID(v types.ID) {
	o.PlanID = v
}

/*************************************************
* PrivateHostUpdateRequest
*************************************************/

// PrivateHostUpdateRequest represents API parameter/response structure
type PrivateHostUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *PrivateHostUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *PrivateHostUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *PrivateHostUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *PrivateHostUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *PrivateHostUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *PrivateHostUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *PrivateHostUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *PrivateHostUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *PrivateHostUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *PrivateHostUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *PrivateHostUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *PrivateHostUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *PrivateHostUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* PrivateHostPlan
*************************************************/

// PrivateHostPlan represents API parameter/response structure
type PrivateHostPlan struct {
	ID           types.ID
	Name         string
	Class        string
	CPU          int
	MemoryMB     int
	Availability types.EAvailability
}

// setDefaults implements iaas.argumentDefaulter
func (o *PrivateHostPlan) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Class        string
		CPU          int
		MemoryMB     int
		Availability types.EAvailability
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Class:        o.GetClass(),
		CPU:          o.GetCPU(),
		MemoryMB:     o.GetMemoryMB(),
		Availability: o.GetAvailability(),
	}
}

// GetID returns value of ID
func (o *PrivateHostPlan) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *PrivateHostPlan) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *PrivateHostPlan) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *PrivateHostPlan) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *PrivateHostPlan) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *PrivateHostPlan) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *PrivateHostPlan) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *PrivateHostPlan) SetName(v string) {
	o.Name = v
}

// GetClass returns value of Class
func (o *PrivateHostPlan) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *PrivateHostPlan) SetClass(v string) {
	o.Class = v
}

// GetCPU returns value of CPU
func (o *PrivateHostPlan) GetCPU() int {
	return o.CPU
}

// SetCPU sets value to CPU
func (o *PrivateHostPlan) SetCPU(v int) {
	o.CPU = v
}

// GetMemoryMB returns value of MemoryMB
func (o *PrivateHostPlan) GetMemoryMB() int {
	return o.MemoryMB
}

// SetMemoryMB sets value to MemoryMB
func (o *PrivateHostPlan) SetMemoryMB(v int) {
	o.MemoryMB = v
}

// GetMemoryGB .
func (o *PrivateHostPlan) GetMemoryGB() int {
	return accessor.GetMemoryGB(o)
}

// SetMemoryGB .
func (o *PrivateHostPlan) SetMemoryGB(memory int) {
	accessor.SetMemoryGB(o, memory)
}

// GetAvailability returns value of Availability
func (o *PrivateHostPlan) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *PrivateHostPlan) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

/*************************************************
* ProxyLB
*************************************************/

// ProxyLB represents API parameter/response structure
type ProxyLB struct {
	ID                   types.ID
	Name                 string
	Description          string
	Tags                 types.Tags
	Availability         types.EAvailability
	IconID               types.ID `mapconv:"Icon.ID"`
	CreatedAt            time.Time
	ModifiedAt           time.Time
	Plan                 types.EProxyLBPlan
	HealthCheck          *ProxyLBHealthCheck          `mapconv:"Settings.ProxyLB.HealthCheck,recursive"`
	SorryServer          *ProxyLBSorryServer          `mapconv:"Settings.ProxyLB.SorryServer,recursive"`
	BindPorts            []*ProxyLBBindPort           `mapconv:"Settings.ProxyLB.[]BindPorts,recursive"`
	Servers              []*ProxyLBServer             `mapconv:"Settings.ProxyLB.[]Servers,recursive"`
	Rules                []*ProxyLBRule               `mapconv:"Settings.ProxyLB.[]Rules,recursive"`
	LetsEncrypt          *ProxyLBACMESetting          `mapconv:"Settings.ProxyLB.LetsEncrypt,recursive"`
	StickySession        *ProxyLBStickySession        `mapconv:"Settings.ProxyLB.StickySession,recursive"`
	Gzip                 *ProxyLBGzip                 `mapconv:"Settings.ProxyLB.Gzip,recursive"`
	BackendHttpKeepAlive *ProxyLBBackendHttpKeepAlive `mapconv:"Settings.ProxyLB.BackendHttpKeepAlive,recursive"`
	MonitoringSuiteLog   *MonitoringSuiteLog          `mapconv:"Settings.ProxyLB.MonitoringSuiteLog,recursive"`
	ProxyProtocol        *ProxyLBProxyProtocol        `mapconv:"Settings.ProxyLB.ProxyProtocol,recursive"`
	Syslog               *ProxyLBSyslog               `mapconv:"Settings.ProxyLB.Syslog,recursive"`
	Timeout              *ProxyLBTimeout              `json:",omitempty" mapconv:"Settings.ProxyLB.Timeout,recursive,omitempty"`
	SettingsHash         string                       `json:",omitempty" mapconv:",omitempty"`
	UseVIPFailover       bool                         `mapconv:"Status.UseVIPFailover"`
	Region               types.EProxyLBRegion         `mapconv:"Status.Region"`
	ProxyNetworks        []string                     `mapconv:"Status.ProxyNetworks"`
	FQDN                 string                       `mapconv:"Status.FQDN"`
	VirtualIPAddress     string                       `mapconv:"Status.VirtualIPAddress"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLB) setDefaults() interface{} {
	return &struct {
		ID                   types.ID
		Name                 string
		Description          string
		Tags                 types.Tags
		Availability         types.EAvailability
		IconID               types.ID `mapconv:"Icon.ID"`
		CreatedAt            time.Time
		ModifiedAt           time.Time
		Plan                 types.EProxyLBPlan
		HealthCheck          *ProxyLBHealthCheck          `mapconv:"Settings.ProxyLB.HealthCheck,recursive"`
		SorryServer          *ProxyLBSorryServer          `mapconv:"Settings.ProxyLB.SorryServer,recursive"`
		BindPorts            []*ProxyLBBindPort           `mapconv:"Settings.ProxyLB.[]BindPorts,recursive"`
		Servers              []*ProxyLBServer             `mapconv:"Settings.ProxyLB.[]Servers,recursive"`
		Rules                []*ProxyLBRule               `mapconv:"Settings.ProxyLB.[]Rules,recursive"`
		LetsEncrypt          *ProxyLBACMESetting          `mapconv:"Settings.ProxyLB.LetsEncrypt,recursive"`
		StickySession        *ProxyLBStickySession        `mapconv:"Settings.ProxyLB.StickySession,recursive"`
		Gzip                 *ProxyLBGzip                 `mapconv:"Settings.ProxyLB.Gzip,recursive"`
		BackendHttpKeepAlive *ProxyLBBackendHttpKeepAlive `mapconv:"Settings.ProxyLB.BackendHttpKeepAlive,recursive"`
		MonitoringSuiteLog   *MonitoringSuiteLog          `mapconv:"Settings.ProxyLB.MonitoringSuiteLog,recursive"`
		ProxyProtocol        *ProxyLBProxyProtocol        `mapconv:"Settings.ProxyLB.ProxyProtocol,recursive"`
		Syslog               *ProxyLBSyslog               `mapconv:"Settings.ProxyLB.Syslog,recursive"`
		Timeout              *ProxyLBTimeout              `json:",omitempty" mapconv:"Settings.ProxyLB.Timeout,recursive,omitempty"`
		SettingsHash         string                       `json:",omitempty" mapconv:",omitempty"`
		UseVIPFailover       bool                         `mapconv:"Status.UseVIPFailover"`
		Region               types.EProxyLBRegion         `mapconv:"Status.Region"`
		ProxyNetworks        []string                     `mapconv:"Status.ProxyNetworks"`
		FQDN                 string                       `mapconv:"Status.FQDN"`
		VirtualIPAddress     string                       `mapconv:"Status.VirtualIPAddress"`
	}{
		ID:                   o.GetID(),
		Name:                 o.GetName(),
		Description:          o.GetDescription(),
		Tags:                 o.GetTags(),
		Availability:         o.GetAvailability(),
		IconID:               o.GetIconID(),
		CreatedAt:            o.GetCreatedAt(),
		ModifiedAt:           o.GetModifiedAt(),
		Plan:                 o.GetPlan(),
		HealthCheck:          o.GetHealthCheck(),
		SorryServer:          o.GetSorryServer(),
		BindPorts:            o.GetBindPorts(),
		Servers:              o.GetServers(),
		Rules:                o.GetRules(),
		LetsEncrypt:          o.GetLetsEncrypt(),
		StickySession:        o.GetStickySession(),
		Gzip:                 o.GetGzip(),
		BackendHttpKeepAlive: o.GetBackendHttpKeepAlive(),
		MonitoringSuiteLog:   o.GetMonitoringSuiteLog(),
		ProxyProtocol:        o.GetProxyProtocol(),
		Syslog:               o.GetSyslog(),
		Timeout:              o.GetTimeout(),
		SettingsHash:         o.GetSettingsHash(),
		UseVIPFailover:       o.GetUseVIPFailover(),
		Region:               o.GetRegion(),
		ProxyNetworks:        o.GetProxyNetworks(),
		FQDN:                 o.GetFQDN(),
		VirtualIPAddress:     o.GetVirtualIPAddress(),
	}
}

// GetID returns value of ID
func (o *ProxyLB) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ProxyLB) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ProxyLB) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ProxyLB) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ProxyLB) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ProxyLB) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *ProxyLB) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ProxyLB) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ProxyLB) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ProxyLB) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ProxyLB) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ProxyLB) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ProxyLB) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ProxyLB) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ProxyLB) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ProxyLB) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *ProxyLB) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *ProxyLB) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *ProxyLB) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ProxyLB) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *ProxyLB) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *ProxyLB) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *ProxyLB) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *ProxyLB) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetPlan returns value of Plan
func (o *ProxyLB) GetPlan() types.EProxyLBPlan {
	return o.Plan
}

// SetPlan sets value to Plan
func (o *ProxyLB) SetPlan(v types.EProxyLBPlan) {
	o.Plan = v
}

// GetHealthCheck returns value of HealthCheck
func (o *ProxyLB) GetHealthCheck() *ProxyLBHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *ProxyLB) SetHealthCheck(v *ProxyLBHealthCheck) {
	o.HealthCheck = v
}

// GetSorryServer returns value of SorryServer
func (o *ProxyLB) GetSorryServer() *ProxyLBSorryServer {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *ProxyLB) SetSorryServer(v *ProxyLBSorryServer) {
	o.SorryServer = v
}

// GetBindPorts returns value of BindPorts
func (o *ProxyLB) GetBindPorts() []*ProxyLBBindPort {
	return o.BindPorts
}

// SetBindPorts sets value to BindPorts
func (o *ProxyLB) SetBindPorts(v []*ProxyLBBindPort) {
	o.BindPorts = v
}

// GetServers returns value of Servers
func (o *ProxyLB) GetServers() []*ProxyLBServer {
	return o.Servers
}

// SetServers sets value to Servers
func (o *ProxyLB) SetServers(v []*ProxyLBServer) {
	o.Servers = v
}

// GetRules returns value of Rules
func (o *ProxyLB) GetRules() []*ProxyLBRule {
	return o.Rules
}

// SetRules sets value to Rules
func (o *ProxyLB) SetRules(v []*ProxyLBRule) {
	o.Rules = v
}

// GetLetsEncrypt returns value of LetsEncrypt
func (o *ProxyLB) GetLetsEncrypt() *ProxyLBACMESetting {
	return o.LetsEncrypt
}

// SetLetsEncrypt sets value to LetsEncrypt
func (o *ProxyLB) SetLetsEncrypt(v *ProxyLBACMESetting) {
	o.LetsEncrypt = v
}

// GetStickySession returns value of StickySession
func (o *ProxyLB) GetStickySession() *ProxyLBStickySession {
	return o.StickySession
}

// SetStickySession sets value to StickySession
func (o *ProxyLB) SetStickySession(v *ProxyLBStickySession) {
	o.StickySession = v
}

// GetGzip returns value of Gzip
func (o *ProxyLB) GetGzip() *ProxyLBGzip {
	return o.Gzip
}

// SetGzip sets value to Gzip
func (o *ProxyLB) SetGzip(v *ProxyLBGzip) {
	o.Gzip = v
}

// GetBackendHttpKeepAlive returns value of BackendHttpKeepAlive
func (o *ProxyLB) GetBackendHttpKeepAlive() *ProxyLBBackendHttpKeepAlive {
	return o.BackendHttpKeepAlive
}

// SetBackendHttpKeepAlive sets value to BackendHttpKeepAlive
func (o *ProxyLB) SetBackendHttpKeepAlive(v *ProxyLBBackendHttpKeepAlive) {
	o.BackendHttpKeepAlive = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *ProxyLB) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *ProxyLB) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetProxyProtocol returns value of ProxyProtocol
func (o *ProxyLB) GetProxyProtocol() *ProxyLBProxyProtocol {
	return o.ProxyProtocol
}

// SetProxyProtocol sets value to ProxyProtocol
func (o *ProxyLB) SetProxyProtocol(v *ProxyLBProxyProtocol) {
	o.ProxyProtocol = v
}

// GetSyslog returns value of Syslog
func (o *ProxyLB) GetSyslog() *ProxyLBSyslog {
	return o.Syslog
}

// SetSyslog sets value to Syslog
func (o *ProxyLB) SetSyslog(v *ProxyLBSyslog) {
	o.Syslog = v
}

// GetTimeout returns value of Timeout
func (o *ProxyLB) GetTimeout() *ProxyLBTimeout {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *ProxyLB) SetTimeout(v *ProxyLBTimeout) {
	o.Timeout = v
}

// GetSettingsHash returns value of SettingsHash
func (o *ProxyLB) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *ProxyLB) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetUseVIPFailover returns value of UseVIPFailover
func (o *ProxyLB) GetUseVIPFailover() bool {
	return o.UseVIPFailover
}

// SetUseVIPFailover sets value to UseVIPFailover
func (o *ProxyLB) SetUseVIPFailover(v bool) {
	o.UseVIPFailover = v
}

// GetRegion returns value of Region
func (o *ProxyLB) GetRegion() types.EProxyLBRegion {
	return o.Region
}

// SetRegion sets value to Region
func (o *ProxyLB) SetRegion(v types.EProxyLBRegion) {
	o.Region = v
}

// GetProxyNetworks returns value of ProxyNetworks
func (o *ProxyLB) GetProxyNetworks() []string {
	return o.ProxyNetworks
}

// SetProxyNetworks sets value to ProxyNetworks
func (o *ProxyLB) SetProxyNetworks(v []string) {
	o.ProxyNetworks = v
}

// GetFQDN returns value of FQDN
func (o *ProxyLB) GetFQDN() string {
	return o.FQDN
}

// SetFQDN sets value to FQDN
func (o *ProxyLB) SetFQDN(v string) {
	o.FQDN = v
}

// GetVirtualIPAddress returns value of VirtualIPAddress
func (o *ProxyLB) GetVirtualIPAddress() string {
	return o.VirtualIPAddress
}

// SetVirtualIPAddress sets value to VirtualIPAddress
func (o *ProxyLB) SetVirtualIPAddress(v string) {
	o.VirtualIPAddress = v
}

/*************************************************
* ProxyLBHealthCheck
*************************************************/

// ProxyLBHealthCheck represents API parameter/response structure
type ProxyLBHealthCheck struct {
	Protocol  types.EProxyLBHealthCheckProtocol
	Path      string
	Host      string
	DelayLoop int
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBHealthCheck) setDefaults() interface{} {
	return &struct {
		Protocol  types.EProxyLBHealthCheckProtocol
		Path      string
		Host      string
		DelayLoop int
	}{
		Protocol:  o.GetProtocol(),
		Path:      o.GetPath(),
		Host:      o.GetHost(),
		DelayLoop: o.GetDelayLoop(),
	}
}

// GetProtocol returns value of Protocol
func (o *ProxyLBHealthCheck) GetProtocol() types.EProxyLBHealthCheckProtocol {
	return o.Protocol
}

// SetProtocol sets value to Protocol
func (o *ProxyLBHealthCheck) SetProtocol(v types.EProxyLBHealthCheckProtocol) {
	o.Protocol = v
}

// GetPath returns value of Path
func (o *ProxyLBHealthCheck) GetPath() string {
	return o.Path
}

// SetPath sets value to Path
func (o *ProxyLBHealthCheck) SetPath(v string) {
	o.Path = v
}

// GetHost returns value of Host
func (o *ProxyLBHealthCheck) GetHost() string {
	return o.Host
}

// SetHost sets value to Host
func (o *ProxyLBHealthCheck) SetHost(v string) {
	o.Host = v
}

// GetDelayLoop returns value of DelayLoop
func (o *ProxyLBHealthCheck) GetDelayLoop() int {
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *ProxyLBHealthCheck) SetDelayLoop(v int) {
	o.DelayLoop = v
}

/*************************************************
* ProxyLBSorryServer
*************************************************/

// ProxyLBSorryServer represents API parameter/response structure
type ProxyLBSorryServer struct {
	IPAddress string
	Port      int `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBSorryServer) setDefaults() interface{} {
	return &struct {
		IPAddress string
		Port      int `mapconv:",omitempty"`
	}{
		IPAddress: o.GetIPAddress(),
		Port:      o.GetPort(),
	}
}

// GetIPAddress returns value of IPAddress
func (o *ProxyLBSorryServer) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *ProxyLBSorryServer) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetPort returns value of Port
func (o *ProxyLBSorryServer) GetPort() int {
	return o.Port
}

// SetPort sets value to Port
func (o *ProxyLBSorryServer) SetPort(v int) {
	o.Port = v
}

/*************************************************
* ProxyLBBindPort
*************************************************/

// ProxyLBBindPort represents API parameter/response structure
type ProxyLBBindPort struct {
	ProxyMode         types.EProxyLBProxyMode
	Port              int
	RedirectToHTTPS   bool
	SupportHTTP2      bool
	AddResponseHeader []*ProxyLBResponseHeader `mapconv:"[]AddResponseHeader,recursive"`
	SSLPolicy         string
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBBindPort) setDefaults() interface{} {
	return &struct {
		ProxyMode         types.EProxyLBProxyMode
		Port              int
		RedirectToHTTPS   bool
		SupportHTTP2      bool
		AddResponseHeader []*ProxyLBResponseHeader `mapconv:"[]AddResponseHeader,recursive"`
		SSLPolicy         string
	}{
		ProxyMode:         o.GetProxyMode(),
		Port:              o.GetPort(),
		RedirectToHTTPS:   o.GetRedirectToHTTPS(),
		SupportHTTP2:      o.GetSupportHTTP2(),
		AddResponseHeader: o.GetAddResponseHeader(),
		SSLPolicy:         o.GetSSLPolicy(),
	}
}

// GetProxyMode returns value of ProxyMode
func (o *ProxyLBBindPort) GetProxyMode() types.EProxyLBProxyMode {
	return o.ProxyMode
}

// SetProxyMode sets value to ProxyMode
func (o *ProxyLBBindPort) SetProxyMode(v types.EProxyLBProxyMode) {
	o.ProxyMode = v
}

// GetPort returns value of Port
func (o *ProxyLBBindPort) GetPort() int {
	return o.Port
}

// SetPort sets value to Port
func (o *ProxyLBBindPort) SetPort(v int) {
	o.Port = v
}

// GetRedirectToHTTPS returns value of RedirectToHTTPS
func (o *ProxyLBBindPort) GetRedirectToHTTPS() bool {
	return o.RedirectToHTTPS
}

// SetRedirectToHTTPS sets value to RedirectToHTTPS
func (o *ProxyLBBindPort) SetRedirectToHTTPS(v bool) {
	o.RedirectToHTTPS = v
}

// GetSupportHTTP2 returns value of SupportHTTP2
func (o *ProxyLBBindPort) GetSupportHTTP2() bool {
	return o.SupportHTTP2
}

// SetSupportHTTP2 sets value to SupportHTTP2
func (o *ProxyLBBindPort) SetSupportHTTP2(v bool) {
	o.SupportHTTP2 = v
}

// GetAddResponseHeader returns value of AddResponseHeader
func (o *ProxyLBBindPort) GetAddResponseHeader() []*ProxyLBResponseHeader {
	return o.AddResponseHeader
}

// SetAddResponseHeader sets value to AddResponseHeader
func (o *ProxyLBBindPort) SetAddResponseHeader(v []*ProxyLBResponseHeader) {
	o.AddResponseHeader = v
}

// GetSSLPolicy returns value of SSLPolicy
func (o *ProxyLBBindPort) GetSSLPolicy() string {
	return o.SSLPolicy
}

// SetSSLPolicy sets value to SSLPolicy
func (o *ProxyLBBindPort) SetSSLPolicy(v string) {
	o.SSLPolicy = v
}

/*************************************************
* ProxyLBResponseHeader
*************************************************/

// ProxyLBResponseHeader represents API parameter/response structure
type ProxyLBResponseHeader struct {
	Header string
	Value  string
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBResponseHeader) setDefaults() interface{} {
	return &struct {
		Header string
		Value  string
	}{
		Header: o.GetHeader(),
		Value:  o.GetValue(),
	}
}

// GetHeader returns value of Header
func (o *ProxyLBResponseHeader) GetHeader() string {
	return o.Header
}

// SetHeader sets value to Header
func (o *ProxyLBResponseHeader) SetHeader(v string) {
	o.Header = v
}

// GetValue returns value of Value
func (o *ProxyLBResponseHeader) GetValue() string {
	return o.Value
}

// SetValue sets value to Value
func (o *ProxyLBResponseHeader) SetValue(v string) {
	o.Value = v
}

/*************************************************
* ProxyLBServer
*************************************************/

// ProxyLBServer represents API parameter/response structure
type ProxyLBServer struct {
	IPAddress   string
	Port        int
	ServerGroup string
	Enabled     bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBServer) setDefaults() interface{} {
	return &struct {
		IPAddress   string
		Port        int
		ServerGroup string
		Enabled     bool
	}{
		IPAddress:   o.GetIPAddress(),
		Port:        o.GetPort(),
		ServerGroup: o.GetServerGroup(),
		Enabled:     o.GetEnabled(),
	}
}

// GetIPAddress returns value of IPAddress
func (o *ProxyLBServer) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *ProxyLBServer) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetPort returns value of Port
func (o *ProxyLBServer) GetPort() int {
	return o.Port
}

// SetPort sets value to Port
func (o *ProxyLBServer) SetPort(v int) {
	o.Port = v
}

// GetServerGroup returns value of ServerGroup
func (o *ProxyLBServer) GetServerGroup() string {
	return o.ServerGroup
}

// SetServerGroup sets value to ServerGroup
func (o *ProxyLBServer) SetServerGroup(v string) {
	o.ServerGroup = v
}

// GetEnabled returns value of Enabled
func (o *ProxyLBServer) GetEnabled() bool {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *ProxyLBServer) SetEnabled(v bool) {
	o.Enabled = v
}

/*************************************************
* ProxyLBRule
*************************************************/

// ProxyLBRule represents API parameter/response structure
type ProxyLBRule struct {
	Host                         string
	Path                         string
	SourceIPs                    string
	RequestHeaderName            string
	RequestHeaderValue           string
	RequestHeaderValueIgnoreCase bool
	RequestHeaderValueNotMatch   bool
	ServerGroup                  string                           `json:",omitempty" mapconv:",omitempty"`
	Action                       types.EProxyLBRuleAction         `json:",omitempty" mapconv:",omitempty"`
	RedirectLocation             string                           `json:",omitempty" mapconv:",omitempty"`
	RedirectStatusCode           types.EProxyLBRedirectStatusCode `json:",omitempty" mapconv:",omitempty"`
	FixedStatusCode              types.EProxyLBFixedStatusCode    `json:",omitempty" mapconv:",omitempty"`
	FixedContentType             types.EProxyLBFixedContentType   `json:",omitempty" mapconv:",omitempty"`
	FixedMessageBody             string                           `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBRule) setDefaults() interface{} {
	return &struct {
		Host                         string
		Path                         string
		SourceIPs                    string
		RequestHeaderName            string
		RequestHeaderValue           string
		RequestHeaderValueIgnoreCase bool
		RequestHeaderValueNotMatch   bool
		ServerGroup                  string                           `json:",omitempty" mapconv:",omitempty"`
		Action                       types.EProxyLBRuleAction         `json:",omitempty" mapconv:",omitempty"`
		RedirectLocation             string                           `json:",omitempty" mapconv:",omitempty"`
		RedirectStatusCode           types.EProxyLBRedirectStatusCode `json:",omitempty" mapconv:",omitempty"`
		FixedStatusCode              types.EProxyLBFixedStatusCode    `json:",omitempty" mapconv:",omitempty"`
		FixedContentType             types.EProxyLBFixedContentType   `json:",omitempty" mapconv:",omitempty"`
		FixedMessageBody             string                           `json:",omitempty" mapconv:",omitempty"`
	}{
		Host:                         o.GetHost(),
		Path:                         o.GetPath(),
		SourceIPs:                    o.GetSourceIPs(),
		RequestHeaderName:            o.GetRequestHeaderName(),
		RequestHeaderValue:           o.GetRequestHeaderValue(),
		RequestHeaderValueIgnoreCase: o.GetRequestHeaderValueIgnoreCase(),
		RequestHeaderValueNotMatch:   o.GetRequestHeaderValueNotMatch(),
		ServerGroup:                  o.GetServerGroup(),
		Action:                       o.GetAction(),
		RedirectLocation:             o.GetRedirectLocation(),
		RedirectStatusCode:           o.GetRedirectStatusCode(),
		FixedStatusCode:              o.GetFixedStatusCode(),
		FixedContentType:             o.GetFixedContentType(),
		FixedMessageBody:             o.GetFixedMessageBody(),
	}
}

// GetHost returns value of Host
func (o *ProxyLBRule) GetHost() string {
	return o.Host
}

// SetHost sets value to Host
func (o *ProxyLBRule) SetHost(v string) {
	o.Host = v
}

// GetPath returns value of Path
func (o *ProxyLBRule) GetPath() string {
	return o.Path
}

// SetPath sets value to Path
func (o *ProxyLBRule) SetPath(v string) {
	o.Path = v
}

// GetSourceIPs returns value of SourceIPs
func (o *ProxyLBRule) GetSourceIPs() string {
	return o.SourceIPs
}

// SetSourceIPs sets value to SourceIPs
func (o *ProxyLBRule) SetSourceIPs(v string) {
	o.SourceIPs = v
}

// GetRequestHeaderName returns value of RequestHeaderName
func (o *ProxyLBRule) GetRequestHeaderName() string {
	return o.RequestHeaderName
}

// SetRequestHeaderName sets value to RequestHeaderName
func (o *ProxyLBRule) SetRequestHeaderName(v string) {
	o.RequestHeaderName = v
}

// GetRequestHeaderValue returns value of RequestHeaderValue
func (o *ProxyLBRule) GetRequestHeaderValue() string {
	return o.RequestHeaderValue
}

// SetRequestHeaderValue sets value to RequestHeaderValue
func (o *ProxyLBRule) SetRequestHeaderValue(v string) {
	o.RequestHeaderValue = v
}

// GetRequestHeaderValueIgnoreCase returns value of RequestHeaderValueIgnoreCase
func (o *ProxyLBRule) GetRequestHeaderValueIgnoreCase() bool {
	return o.RequestHeaderValueIgnoreCase
}

// SetRequestHeaderValueIgnoreCase sets value to RequestHeaderValueIgnoreCase
func (o *ProxyLBRule) SetRequestHeaderValueIgnoreCase(v bool) {
	o.RequestHeaderValueIgnoreCase = v
}

// GetRequestHeaderValueNotMatch returns value of RequestHeaderValueNotMatch
func (o *ProxyLBRule) GetRequestHeaderValueNotMatch() bool {
	return o.RequestHeaderValueNotMatch
}

// SetRequestHeaderValueNotMatch sets value to RequestHeaderValueNotMatch
func (o *ProxyLBRule) SetRequestHeaderValueNotMatch(v bool) {
	o.RequestHeaderValueNotMatch = v
}

// GetServerGroup returns value of ServerGroup
func (o *ProxyLBRule) GetServerGroup() string {
	return o.ServerGroup
}

// SetServerGroup sets value to ServerGroup
func (o *ProxyLBRule) SetServerGroup(v string) {
	o.ServerGroup = v
}

// GetAction returns value of Action
func (o *ProxyLBRule) GetAction() types.EProxyLBRuleAction {
	return o.Action
}

// SetAction sets value to Action
func (o *ProxyLBRule) SetAction(v types.EProxyLBRuleAction) {
	o.Action = v
}

// GetRedirectLocation returns value of RedirectLocation
func (o *ProxyLBRule) GetRedirectLocation() string {
	return o.RedirectLocation
}

// SetRedirectLocation sets value to RedirectLocation
func (o *ProxyLBRule) SetRedirectLocation(v string) {
	o.RedirectLocation = v
}

// GetRedirectStatusCode returns value of RedirectStatusCode
func (o *ProxyLBRule) GetRedirectStatusCode() types.EProxyLBRedirectStatusCode {
	return o.RedirectStatusCode
}

// SetRedirectStatusCode sets value to RedirectStatusCode
func (o *ProxyLBRule) SetRedirectStatusCode(v types.EProxyLBRedirectStatusCode) {
	o.RedirectStatusCode = v
}

// GetFixedStatusCode returns value of FixedStatusCode
func (o *ProxyLBRule) GetFixedStatusCode() types.EProxyLBFixedStatusCode {
	return o.FixedStatusCode
}

// SetFixedStatusCode sets value to FixedStatusCode
func (o *ProxyLBRule) SetFixedStatusCode(v types.EProxyLBFixedStatusCode) {
	o.FixedStatusCode = v
}

// GetFixedContentType returns value of FixedContentType
func (o *ProxyLBRule) GetFixedContentType() types.EProxyLBFixedContentType {
	return o.FixedContentType
}

// SetFixedContentType sets value to FixedContentType
func (o *ProxyLBRule) SetFixedContentType(v types.EProxyLBFixedContentType) {
	o.FixedContentType = v
}

// GetFixedMessageBody returns value of FixedMessageBody
func (o *ProxyLBRule) GetFixedMessageBody() string {
	return o.FixedMessageBody
}

// SetFixedMessageBody sets value to FixedMessageBody
func (o *ProxyLBRule) SetFixedMessageBody(v string) {
	o.FixedMessageBody = v
}

/*************************************************
* ProxyLBACMESetting
*************************************************/

// ProxyLBACMESetting represents API parameter/response structure
type ProxyLBACMESetting struct {
	CommonName      string
	Enabled         bool
	SubjectAltNames []string `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBACMESetting) setDefaults() interface{} {
	return &struct {
		CommonName      string
		Enabled         bool
		SubjectAltNames []string `json:",omitempty" mapconv:",omitempty"`
	}{
		CommonName:      o.GetCommonName(),
		Enabled:         o.GetEnabled(),
		SubjectAltNames: o.GetSubjectAltNames(),
	}
}

// GetCommonName returns value of CommonName
func (o *ProxyLBACMESetting) GetCommonName() string {
	return o.CommonName
}

// SetCommonName sets value to CommonName
func (o *ProxyLBACMESetting) SetCommonName(v string) {
	o.CommonName = v
}

// GetEnabled returns value of Enabled
func (o *ProxyLBACMESetting) GetEnabled() bool {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *ProxyLBACMESetting) SetEnabled(v bool) {
	o.Enabled = v
}

// GetSubjectAltNames returns value of SubjectAltNames
func (o *ProxyLBACMESetting) GetSubjectAltNames() []string {
	return o.SubjectAltNames
}

// SetSubjectAltNames sets value to SubjectAltNames
func (o *ProxyLBACMESetting) SetSubjectAltNames(v []string) {
	o.SubjectAltNames = v
}

/*************************************************
* ProxyLBStickySession
*************************************************/

// ProxyLBStickySession represents API parameter/response structure
type ProxyLBStickySession struct {
	Method  string
	Enabled bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBStickySession) setDefaults() interface{} {
	return &struct {
		Method  string
		Enabled bool
	}{
		Method:  o.GetMethod(),
		Enabled: o.GetEnabled(),
	}
}

// GetMethod returns value of Method
func (o *ProxyLBStickySession) GetMethod() string {
	return o.Method
}

// SetMethod sets value to Method
func (o *ProxyLBStickySession) SetMethod(v string) {
	o.Method = v
}

// GetEnabled returns value of Enabled
func (o *ProxyLBStickySession) GetEnabled() bool {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *ProxyLBStickySession) SetEnabled(v bool) {
	o.Enabled = v
}

/*************************************************
* ProxyLBGzip
*************************************************/

// ProxyLBGzip represents API parameter/response structure
type ProxyLBGzip struct {
	Enabled bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBGzip) setDefaults() interface{} {
	return &struct {
		Enabled bool
	}{
		Enabled: o.GetEnabled(),
	}
}

// GetEnabled returns value of Enabled
func (o *ProxyLBGzip) GetEnabled() bool {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *ProxyLBGzip) SetEnabled(v bool) {
	o.Enabled = v
}

/*************************************************
* ProxyLBBackendHttpKeepAlive
*************************************************/

// ProxyLBBackendHttpKeepAlive represents API parameter/response structure
type ProxyLBBackendHttpKeepAlive struct {
	Mode types.EProxyLBBackendHttpKeepAlive
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBBackendHttpKeepAlive) setDefaults() interface{} {
	return &struct {
		Mode types.EProxyLBBackendHttpKeepAlive
	}{
		Mode: o.GetMode(),
	}
}

// GetMode returns value of Mode
func (o *ProxyLBBackendHttpKeepAlive) GetMode() types.EProxyLBBackendHttpKeepAlive {
	return o.Mode
}

// SetMode sets value to Mode
func (o *ProxyLBBackendHttpKeepAlive) SetMode(v types.EProxyLBBackendHttpKeepAlive) {
	o.Mode = v
}

/*************************************************
* ProxyLBProxyProtocol
*************************************************/

// ProxyLBProxyProtocol represents API parameter/response structure
type ProxyLBProxyProtocol struct {
	Enabled bool
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBProxyProtocol) setDefaults() interface{} {
	return &struct {
		Enabled bool
	}{
		Enabled: o.GetEnabled(),
	}
}

// GetEnabled returns value of Enabled
func (o *ProxyLBProxyProtocol) GetEnabled() bool {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *ProxyLBProxyProtocol) SetEnabled(v bool) {
	o.Enabled = v
}

/*************************************************
* ProxyLBSyslog
*************************************************/

// ProxyLBSyslog represents API parameter/response structure
type ProxyLBSyslog struct {
	Server string
	Port   int
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBSyslog) setDefaults() interface{} {
	return &struct {
		Server string
		Port   int
	}{
		Server: o.GetServer(),
		Port:   o.GetPort(),
	}
}

// GetServer returns value of Server
func (o *ProxyLBSyslog) GetServer() string {
	return o.Server
}

// SetServer sets value to Server
func (o *ProxyLBSyslog) SetServer(v string) {
	o.Server = v
}

// GetPort returns value of Port
func (o *ProxyLBSyslog) GetPort() int {
	if o.Port == 0 {
		return 514
	}
	return o.Port
}

// SetPort sets value to Port
func (o *ProxyLBSyslog) SetPort(v int) {
	o.Port = v
}

/*************************************************
* ProxyLBTimeout
*************************************************/

// ProxyLBTimeout represents API parameter/response structure
type ProxyLBTimeout struct {
	InactiveSec int
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBTimeout) setDefaults() interface{} {
	return &struct {
		InactiveSec int
	}{
		InactiveSec: o.GetInactiveSec(),
	}
}

// GetInactiveSec returns value of InactiveSec
func (o *ProxyLBTimeout) GetInactiveSec() int {
	if o.InactiveSec == 0 {
		return 10
	}
	return o.InactiveSec
}

// SetInactiveSec sets value to InactiveSec
func (o *ProxyLBTimeout) SetInactiveSec(v int) {
	o.InactiveSec = v
}

/*************************************************
* ProxyLBCreateRequest
*************************************************/

// ProxyLBCreateRequest represents API parameter/response structure
type ProxyLBCreateRequest struct {
	Plan                 types.EProxyLBPlan
	HealthCheck          *ProxyLBHealthCheck          `mapconv:"Settings.ProxyLB.HealthCheck,recursive"`
	SorryServer          *ProxyLBSorryServer          `mapconv:"Settings.ProxyLB.SorryServer,recursive"`
	BindPorts            []*ProxyLBBindPort           `mapconv:"Settings.ProxyLB.[]BindPorts,recursive"`
	Servers              []*ProxyLBServer             `mapconv:"Settings.ProxyLB.[]Servers,recursive"`
	Rules                []*ProxyLBRule               `mapconv:"Settings.ProxyLB.[]Rules,recursive"`
	LetsEncrypt          *ProxyLBACMESetting          `mapconv:"Settings.ProxyLB.LetsEncrypt,recursive"`
	StickySession        *ProxyLBStickySession        `mapconv:"Settings.ProxyLB.StickySession,recursive"`
	Timeout              *ProxyLBTimeout              `json:",omitempty" mapconv:"Settings.ProxyLB.Timeout,recursive,omitempty"`
	Gzip                 *ProxyLBGzip                 `mapconv:"Settings.ProxyLB.Gzip,recursive"`
	BackendHttpKeepAlive *ProxyLBBackendHttpKeepAlive `mapconv:"Settings.ProxyLB.BackendHttpKeepAlive,recursive"`
	MonitoringSuiteLog   *MonitoringSuiteLog          `mapconv:"Settings.ProxyLB.MonitoringSuiteLog,recursive"`
	ProxyProtocol        *ProxyLBProxyProtocol        `mapconv:"Settings.ProxyLB.ProxyProtocol,recursive"`
	Syslog               *ProxyLBSyslog               `mapconv:"Settings.ProxyLB.Syslog,recursive"`
	UseVIPFailover       bool                         `mapconv:"Status.UseVIPFailover"`
	Region               types.EProxyLBRegion         `mapconv:"Status.Region"`
	Name                 string
	Description          string
	Tags                 types.Tags
	IconID               types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBCreateRequest) setDefaults() interface{} {
	return &struct {
		Plan                 types.EProxyLBPlan
		HealthCheck          *ProxyLBHealthCheck          `mapconv:"Settings.ProxyLB.HealthCheck,recursive"`
		SorryServer          *ProxyLBSorryServer          `mapconv:"Settings.ProxyLB.SorryServer,recursive"`
		BindPorts            []*ProxyLBBindPort           `mapconv:"Settings.ProxyLB.[]BindPorts,recursive"`
		Servers              []*ProxyLBServer             `mapconv:"Settings.ProxyLB.[]Servers,recursive"`
		Rules                []*ProxyLBRule               `mapconv:"Settings.ProxyLB.[]Rules,recursive"`
		LetsEncrypt          *ProxyLBACMESetting          `mapconv:"Settings.ProxyLB.LetsEncrypt,recursive"`
		StickySession        *ProxyLBStickySession        `mapconv:"Settings.ProxyLB.StickySession,recursive"`
		Timeout              *ProxyLBTimeout              `json:",omitempty" mapconv:"Settings.ProxyLB.Timeout,recursive,omitempty"`
		Gzip                 *ProxyLBGzip                 `mapconv:"Settings.ProxyLB.Gzip,recursive"`
		BackendHttpKeepAlive *ProxyLBBackendHttpKeepAlive `mapconv:"Settings.ProxyLB.BackendHttpKeepAlive,recursive"`
		MonitoringSuiteLog   *MonitoringSuiteLog          `mapconv:"Settings.ProxyLB.MonitoringSuiteLog,recursive"`
		ProxyProtocol        *ProxyLBProxyProtocol        `mapconv:"Settings.ProxyLB.ProxyProtocol,recursive"`
		Syslog               *ProxyLBSyslog               `mapconv:"Settings.ProxyLB.Syslog,recursive"`
		UseVIPFailover       bool                         `mapconv:"Status.UseVIPFailover"`
		Region               types.EProxyLBRegion         `mapconv:"Status.Region"`
		Name                 string
		Description          string
		Tags                 types.Tags
		IconID               types.ID `mapconv:"Icon.ID"`
		Class                string   `mapconv:"Provider.Class"`
	}{
		Plan:                 o.GetPlan(),
		HealthCheck:          o.GetHealthCheck(),
		SorryServer:          o.GetSorryServer(),
		BindPorts:            o.GetBindPorts(),
		Servers:              o.GetServers(),
		Rules:                o.GetRules(),
		LetsEncrypt:          o.GetLetsEncrypt(),
		StickySession:        o.GetStickySession(),
		Timeout:              o.GetTimeout(),
		Gzip:                 o.GetGzip(),
		BackendHttpKeepAlive: o.GetBackendHttpKeepAlive(),
		MonitoringSuiteLog:   o.GetMonitoringSuiteLog(),
		ProxyProtocol:        o.GetProxyProtocol(),
		Syslog:               o.GetSyslog(),
		UseVIPFailover:       o.GetUseVIPFailover(),
		Region:               o.GetRegion(),
		Name:                 o.GetName(),
		Description:          o.GetDescription(),
		Tags:                 o.GetTags(),
		IconID:               o.GetIconID(),
		Class:                "proxylb",
	}
}

// GetPlan returns value of Plan
func (o *ProxyLBCreateRequest) GetPlan() types.EProxyLBPlan {
	return o.Plan
}

// SetPlan sets value to Plan
func (o *ProxyLBCreateRequest) SetPlan(v types.EProxyLBPlan) {
	o.Plan = v
}

// GetHealthCheck returns value of HealthCheck
func (o *ProxyLBCreateRequest) GetHealthCheck() *ProxyLBHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *ProxyLBCreateRequest) SetHealthCheck(v *ProxyLBHealthCheck) {
	o.HealthCheck = v
}

// GetSorryServer returns value of SorryServer
func (o *ProxyLBCreateRequest) GetSorryServer() *ProxyLBSorryServer {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *ProxyLBCreateRequest) SetSorryServer(v *ProxyLBSorryServer) {
	o.SorryServer = v
}

// GetBindPorts returns value of BindPorts
func (o *ProxyLBCreateRequest) GetBindPorts() []*ProxyLBBindPort {
	return o.BindPorts
}

// SetBindPorts sets value to BindPorts
func (o *ProxyLBCreateRequest) SetBindPorts(v []*ProxyLBBindPort) {
	o.BindPorts = v
}

// GetServers returns value of Servers
func (o *ProxyLBCreateRequest) GetServers() []*ProxyLBServer {
	return o.Servers
}

// SetServers sets value to Servers
func (o *ProxyLBCreateRequest) SetServers(v []*ProxyLBServer) {
	o.Servers = v
}

// GetRules returns value of Rules
func (o *ProxyLBCreateRequest) GetRules() []*ProxyLBRule {
	return o.Rules
}

// SetRules sets value to Rules
func (o *ProxyLBCreateRequest) SetRules(v []*ProxyLBRule) {
	o.Rules = v
}

// GetLetsEncrypt returns value of LetsEncrypt
func (o *ProxyLBCreateRequest) GetLetsEncrypt() *ProxyLBACMESetting {
	return o.LetsEncrypt
}

// SetLetsEncrypt sets value to LetsEncrypt
func (o *ProxyLBCreateRequest) SetLetsEncrypt(v *ProxyLBACMESetting) {
	o.LetsEncrypt = v
}

// GetStickySession returns value of StickySession
func (o *ProxyLBCreateRequest) GetStickySession() *ProxyLBStickySession {
	return o.StickySession
}

// SetStickySession sets value to StickySession
func (o *ProxyLBCreateRequest) SetStickySession(v *ProxyLBStickySession) {
	o.StickySession = v
}

// GetTimeout returns value of Timeout
func (o *ProxyLBCreateRequest) GetTimeout() *ProxyLBTimeout {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *ProxyLBCreateRequest) SetTimeout(v *ProxyLBTimeout) {
	o.Timeout = v
}

// GetGzip returns value of Gzip
func (o *ProxyLBCreateRequest) GetGzip() *ProxyLBGzip {
	return o.Gzip
}

// SetGzip sets value to Gzip
func (o *ProxyLBCreateRequest) SetGzip(v *ProxyLBGzip) {
	o.Gzip = v
}

// GetBackendHttpKeepAlive returns value of BackendHttpKeepAlive
func (o *ProxyLBCreateRequest) GetBackendHttpKeepAlive() *ProxyLBBackendHttpKeepAlive {
	return o.BackendHttpKeepAlive
}

// SetBackendHttpKeepAlive sets value to BackendHttpKeepAlive
func (o *ProxyLBCreateRequest) SetBackendHttpKeepAlive(v *ProxyLBBackendHttpKeepAlive) {
	o.BackendHttpKeepAlive = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *ProxyLBCreateRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *ProxyLBCreateRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetProxyProtocol returns value of ProxyProtocol
func (o *ProxyLBCreateRequest) GetProxyProtocol() *ProxyLBProxyProtocol {
	return o.ProxyProtocol
}

// SetProxyProtocol sets value to ProxyProtocol
func (o *ProxyLBCreateRequest) SetProxyProtocol(v *ProxyLBProxyProtocol) {
	o.ProxyProtocol = v
}

// GetSyslog returns value of Syslog
func (o *ProxyLBCreateRequest) GetSyslog() *ProxyLBSyslog {
	return o.Syslog
}

// SetSyslog sets value to Syslog
func (o *ProxyLBCreateRequest) SetSyslog(v *ProxyLBSyslog) {
	o.Syslog = v
}

// GetUseVIPFailover returns value of UseVIPFailover
func (o *ProxyLBCreateRequest) GetUseVIPFailover() bool {
	return o.UseVIPFailover
}

// SetUseVIPFailover sets value to UseVIPFailover
func (o *ProxyLBCreateRequest) SetUseVIPFailover(v bool) {
	o.UseVIPFailover = v
}

// GetRegion returns value of Region
func (o *ProxyLBCreateRequest) GetRegion() types.EProxyLBRegion {
	return o.Region
}

// SetRegion sets value to Region
func (o *ProxyLBCreateRequest) SetRegion(v types.EProxyLBRegion) {
	o.Region = v
}

// GetName returns value of Name
func (o *ProxyLBCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ProxyLBCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ProxyLBCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ProxyLBCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ProxyLBCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ProxyLBCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ProxyLBCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ProxyLBCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ProxyLBCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ProxyLBCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ProxyLBCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ProxyLBCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* ProxyLBUpdateRequest
*************************************************/

// ProxyLBUpdateRequest represents API parameter/response structure
type ProxyLBUpdateRequest struct {
	HealthCheck          *ProxyLBHealthCheck          `mapconv:"Settings.ProxyLB.HealthCheck,recursive"`
	SorryServer          *ProxyLBSorryServer          `mapconv:"Settings.ProxyLB.SorryServer,recursive"`
	BindPorts            []*ProxyLBBindPort           `mapconv:"Settings.ProxyLB.[]BindPorts,recursive"`
	Servers              []*ProxyLBServer             `mapconv:"Settings.ProxyLB.[]Servers,recursive"`
	Rules                []*ProxyLBRule               `mapconv:"Settings.ProxyLB.[]Rules,recursive"`
	LetsEncrypt          *ProxyLBACMESetting          `mapconv:"Settings.ProxyLB.LetsEncrypt,recursive"`
	StickySession        *ProxyLBStickySession        `mapconv:"Settings.ProxyLB.StickySession,recursive"`
	Timeout              *ProxyLBTimeout              `json:",omitempty" mapconv:"Settings.ProxyLB.Timeout,recursive,omitempty"`
	Gzip                 *ProxyLBGzip                 `mapconv:"Settings.ProxyLB.Gzip,recursive"`
	BackendHttpKeepAlive *ProxyLBBackendHttpKeepAlive `mapconv:"Settings.ProxyLB.BackendHttpKeepAlive,recursive"`
	MonitoringSuiteLog   *MonitoringSuiteLog          `mapconv:"Settings.ProxyLB.MonitoringSuiteLog,recursive"`
	ProxyProtocol        *ProxyLBProxyProtocol        `mapconv:"Settings.ProxyLB.ProxyProtocol,recursive"`
	Syslog               *ProxyLBSyslog               `mapconv:"Settings.ProxyLB.Syslog,recursive"`
	SettingsHash         string                       `json:",omitempty" mapconv:",omitempty"`
	Name                 string
	Description          string
	Tags                 types.Tags
	IconID               types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBUpdateRequest) setDefaults() interface{} {
	return &struct {
		HealthCheck          *ProxyLBHealthCheck          `mapconv:"Settings.ProxyLB.HealthCheck,recursive"`
		SorryServer          *ProxyLBSorryServer          `mapconv:"Settings.ProxyLB.SorryServer,recursive"`
		BindPorts            []*ProxyLBBindPort           `mapconv:"Settings.ProxyLB.[]BindPorts,recursive"`
		Servers              []*ProxyLBServer             `mapconv:"Settings.ProxyLB.[]Servers,recursive"`
		Rules                []*ProxyLBRule               `mapconv:"Settings.ProxyLB.[]Rules,recursive"`
		LetsEncrypt          *ProxyLBACMESetting          `mapconv:"Settings.ProxyLB.LetsEncrypt,recursive"`
		StickySession        *ProxyLBStickySession        `mapconv:"Settings.ProxyLB.StickySession,recursive"`
		Timeout              *ProxyLBTimeout              `json:",omitempty" mapconv:"Settings.ProxyLB.Timeout,recursive,omitempty"`
		Gzip                 *ProxyLBGzip                 `mapconv:"Settings.ProxyLB.Gzip,recursive"`
		BackendHttpKeepAlive *ProxyLBBackendHttpKeepAlive `mapconv:"Settings.ProxyLB.BackendHttpKeepAlive,recursive"`
		MonitoringSuiteLog   *MonitoringSuiteLog          `mapconv:"Settings.ProxyLB.MonitoringSuiteLog,recursive"`
		ProxyProtocol        *ProxyLBProxyProtocol        `mapconv:"Settings.ProxyLB.ProxyProtocol,recursive"`
		Syslog               *ProxyLBSyslog               `mapconv:"Settings.ProxyLB.Syslog,recursive"`
		SettingsHash         string                       `json:",omitempty" mapconv:",omitempty"`
		Name                 string
		Description          string
		Tags                 types.Tags
		IconID               types.ID `mapconv:"Icon.ID"`
	}{
		HealthCheck:          o.GetHealthCheck(),
		SorryServer:          o.GetSorryServer(),
		BindPorts:            o.GetBindPorts(),
		Servers:              o.GetServers(),
		Rules:                o.GetRules(),
		LetsEncrypt:          o.GetLetsEncrypt(),
		StickySession:        o.GetStickySession(),
		Timeout:              o.GetTimeout(),
		Gzip:                 o.GetGzip(),
		BackendHttpKeepAlive: o.GetBackendHttpKeepAlive(),
		MonitoringSuiteLog:   o.GetMonitoringSuiteLog(),
		ProxyProtocol:        o.GetProxyProtocol(),
		Syslog:               o.GetSyslog(),
		SettingsHash:         o.GetSettingsHash(),
		Name:                 o.GetName(),
		Description:          o.GetDescription(),
		Tags:                 o.GetTags(),
		IconID:               o.GetIconID(),
	}
}

// GetHealthCheck returns value of HealthCheck
func (o *ProxyLBUpdateRequest) GetHealthCheck() *ProxyLBHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *ProxyLBUpdateRequest) SetHealthCheck(v *ProxyLBHealthCheck) {
	o.HealthCheck = v
}

// GetSorryServer returns value of SorryServer
func (o *ProxyLBUpdateRequest) GetSorryServer() *ProxyLBSorryServer {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *ProxyLBUpdateRequest) SetSorryServer(v *ProxyLBSorryServer) {
	o.SorryServer = v
}

// GetBindPorts returns value of BindPorts
func (o *ProxyLBUpdateRequest) GetBindPorts() []*ProxyLBBindPort {
	return o.BindPorts
}

// SetBindPorts sets value to BindPorts
func (o *ProxyLBUpdateRequest) SetBindPorts(v []*ProxyLBBindPort) {
	o.BindPorts = v
}

// GetServers returns value of Servers
func (o *ProxyLBUpdateRequest) GetServers() []*ProxyLBServer {
	return o.Servers
}

// SetServers sets value to Servers
func (o *ProxyLBUpdateRequest) SetServers(v []*ProxyLBServer) {
	o.Servers = v
}

// GetRules returns value of Rules
func (o *ProxyLBUpdateRequest) GetRules() []*ProxyLBRule {
	return o.Rules
}

// SetRules sets value to Rules
func (o *ProxyLBUpdateRequest) SetRules(v []*ProxyLBRule) {
	o.Rules = v
}

// GetLetsEncrypt returns value of LetsEncrypt
func (o *ProxyLBUpdateRequest) GetLetsEncrypt() *ProxyLBACMESetting {
	return o.LetsEncrypt
}

// SetLetsEncrypt sets value to LetsEncrypt
func (o *ProxyLBUpdateRequest) SetLetsEncrypt(v *ProxyLBACMESetting) {
	o.LetsEncrypt = v
}

// GetStickySession returns value of StickySession
func (o *ProxyLBUpdateRequest) GetStickySession() *ProxyLBStickySession {
	return o.StickySession
}

// SetStickySession sets value to StickySession
func (o *ProxyLBUpdateRequest) SetStickySession(v *ProxyLBStickySession) {
	o.StickySession = v
}

// GetTimeout returns value of Timeout
func (o *ProxyLBUpdateRequest) GetTimeout() *ProxyLBTimeout {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *ProxyLBUpdateRequest) SetTimeout(v *ProxyLBTimeout) {
	o.Timeout = v
}

// GetGzip returns value of Gzip
func (o *ProxyLBUpdateRequest) GetGzip() *ProxyLBGzip {
	return o.Gzip
}

// SetGzip sets value to Gzip
func (o *ProxyLBUpdateRequest) SetGzip(v *ProxyLBGzip) {
	o.Gzip = v
}

// GetBackendHttpKeepAlive returns value of BackendHttpKeepAlive
func (o *ProxyLBUpdateRequest) GetBackendHttpKeepAlive() *ProxyLBBackendHttpKeepAlive {
	return o.BackendHttpKeepAlive
}

// SetBackendHttpKeepAlive sets value to BackendHttpKeepAlive
func (o *ProxyLBUpdateRequest) SetBackendHttpKeepAlive(v *ProxyLBBackendHttpKeepAlive) {
	o.BackendHttpKeepAlive = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *ProxyLBUpdateRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *ProxyLBUpdateRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetProxyProtocol returns value of ProxyProtocol
func (o *ProxyLBUpdateRequest) GetProxyProtocol() *ProxyLBProxyProtocol {
	return o.ProxyProtocol
}

// SetProxyProtocol sets value to ProxyProtocol
func (o *ProxyLBUpdateRequest) SetProxyProtocol(v *ProxyLBProxyProtocol) {
	o.ProxyProtocol = v
}

// GetSyslog returns value of Syslog
func (o *ProxyLBUpdateRequest) GetSyslog() *ProxyLBSyslog {
	return o.Syslog
}

// SetSyslog sets value to Syslog
func (o *ProxyLBUpdateRequest) SetSyslog(v *ProxyLBSyslog) {
	o.Syslog = v
}

// GetSettingsHash returns value of SettingsHash
func (o *ProxyLBUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *ProxyLBUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetName returns value of Name
func (o *ProxyLBUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ProxyLBUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ProxyLBUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ProxyLBUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ProxyLBUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ProxyLBUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ProxyLBUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ProxyLBUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ProxyLBUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ProxyLBUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ProxyLBUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ProxyLBUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* ProxyLBUpdateSettingsRequest
*************************************************/

// ProxyLBUpdateSettingsRequest represents API parameter/response structure
type ProxyLBUpdateSettingsRequest struct {
	HealthCheck          *ProxyLBHealthCheck          `mapconv:"Settings.ProxyLB.HealthCheck,recursive"`
	SorryServer          *ProxyLBSorryServer          `mapconv:"Settings.ProxyLB.SorryServer,recursive"`
	BindPorts            []*ProxyLBBindPort           `mapconv:"Settings.ProxyLB.[]BindPorts,recursive"`
	Servers              []*ProxyLBServer             `mapconv:"Settings.ProxyLB.[]Servers,recursive"`
	Rules                []*ProxyLBRule               `mapconv:"Settings.ProxyLB.[]Rules,recursive"`
	LetsEncrypt          *ProxyLBACMESetting          `mapconv:"Settings.ProxyLB.LetsEncrypt,recursive"`
	StickySession        *ProxyLBStickySession        `mapconv:"Settings.ProxyLB.StickySession,recursive"`
	Timeout              *ProxyLBTimeout              `json:",omitempty" mapconv:"Settings.ProxyLB.Timeout,recursive,omitempty"`
	Gzip                 *ProxyLBGzip                 `mapconv:"Settings.ProxyLB.Gzip,recursive"`
	BackendHttpKeepAlive *ProxyLBBackendHttpKeepAlive `mapconv:"Settings.ProxyLB.BackendHttpKeepAlive,recursive"`
	MonitoringSuiteLog   *MonitoringSuiteLog          `mapconv:"Settings.ProxyLB.MonitoringSuiteLog,recursive"`
	ProxyProtocol        *ProxyLBProxyProtocol        `mapconv:"Settings.ProxyLB.ProxyProtocol,recursive"`
	Syslog               *ProxyLBSyslog               `mapconv:"Settings.ProxyLB.Syslog,recursive"`
	SettingsHash         string                       `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		HealthCheck          *ProxyLBHealthCheck          `mapconv:"Settings.ProxyLB.HealthCheck,recursive"`
		SorryServer          *ProxyLBSorryServer          `mapconv:"Settings.ProxyLB.SorryServer,recursive"`
		BindPorts            []*ProxyLBBindPort           `mapconv:"Settings.ProxyLB.[]BindPorts,recursive"`
		Servers              []*ProxyLBServer             `mapconv:"Settings.ProxyLB.[]Servers,recursive"`
		Rules                []*ProxyLBRule               `mapconv:"Settings.ProxyLB.[]Rules,recursive"`
		LetsEncrypt          *ProxyLBACMESetting          `mapconv:"Settings.ProxyLB.LetsEncrypt,recursive"`
		StickySession        *ProxyLBStickySession        `mapconv:"Settings.ProxyLB.StickySession,recursive"`
		Timeout              *ProxyLBTimeout              `json:",omitempty" mapconv:"Settings.ProxyLB.Timeout,recursive,omitempty"`
		Gzip                 *ProxyLBGzip                 `mapconv:"Settings.ProxyLB.Gzip,recursive"`
		BackendHttpKeepAlive *ProxyLBBackendHttpKeepAlive `mapconv:"Settings.ProxyLB.BackendHttpKeepAlive,recursive"`
		MonitoringSuiteLog   *MonitoringSuiteLog          `mapconv:"Settings.ProxyLB.MonitoringSuiteLog,recursive"`
		ProxyProtocol        *ProxyLBProxyProtocol        `mapconv:"Settings.ProxyLB.ProxyProtocol,recursive"`
		Syslog               *ProxyLBSyslog               `mapconv:"Settings.ProxyLB.Syslog,recursive"`
		SettingsHash         string                       `json:",omitempty" mapconv:",omitempty"`
	}{
		HealthCheck:          o.GetHealthCheck(),
		SorryServer:          o.GetSorryServer(),
		BindPorts:            o.GetBindPorts(),
		Servers:              o.GetServers(),
		Rules:                o.GetRules(),
		LetsEncrypt:          o.GetLetsEncrypt(),
		StickySession:        o.GetStickySession(),
		Timeout:              o.GetTimeout(),
		Gzip:                 o.GetGzip(),
		BackendHttpKeepAlive: o.GetBackendHttpKeepAlive(),
		MonitoringSuiteLog:   o.GetMonitoringSuiteLog(),
		ProxyProtocol:        o.GetProxyProtocol(),
		Syslog:               o.GetSyslog(),
		SettingsHash:         o.GetSettingsHash(),
	}
}

// GetHealthCheck returns value of HealthCheck
func (o *ProxyLBUpdateSettingsRequest) GetHealthCheck() *ProxyLBHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *ProxyLBUpdateSettingsRequest) SetHealthCheck(v *ProxyLBHealthCheck) {
	o.HealthCheck = v
}

// GetSorryServer returns value of SorryServer
func (o *ProxyLBUpdateSettingsRequest) GetSorryServer() *ProxyLBSorryServer {
	return o.SorryServer
}

// SetSorryServer sets value to SorryServer
func (o *ProxyLBUpdateSettingsRequest) SetSorryServer(v *ProxyLBSorryServer) {
	o.SorryServer = v
}

// GetBindPorts returns value of BindPorts
func (o *ProxyLBUpdateSettingsRequest) GetBindPorts() []*ProxyLBBindPort {
	return o.BindPorts
}

// SetBindPorts sets value to BindPorts
func (o *ProxyLBUpdateSettingsRequest) SetBindPorts(v []*ProxyLBBindPort) {
	o.BindPorts = v
}

// GetServers returns value of Servers
func (o *ProxyLBUpdateSettingsRequest) GetServers() []*ProxyLBServer {
	return o.Servers
}

// SetServers sets value to Servers
func (o *ProxyLBUpdateSettingsRequest) SetServers(v []*ProxyLBServer) {
	o.Servers = v
}

// GetRules returns value of Rules
func (o *ProxyLBUpdateSettingsRequest) GetRules() []*ProxyLBRule {
	return o.Rules
}

// SetRules sets value to Rules
func (o *ProxyLBUpdateSettingsRequest) SetRules(v []*ProxyLBRule) {
	o.Rules = v
}

// GetLetsEncrypt returns value of LetsEncrypt
func (o *ProxyLBUpdateSettingsRequest) GetLetsEncrypt() *ProxyLBACMESetting {
	return o.LetsEncrypt
}

// SetLetsEncrypt sets value to LetsEncrypt
func (o *ProxyLBUpdateSettingsRequest) SetLetsEncrypt(v *ProxyLBACMESetting) {
	o.LetsEncrypt = v
}

// GetStickySession returns value of StickySession
func (o *ProxyLBUpdateSettingsRequest) GetStickySession() *ProxyLBStickySession {
	return o.StickySession
}

// SetStickySession sets value to StickySession
func (o *ProxyLBUpdateSettingsRequest) SetStickySession(v *ProxyLBStickySession) {
	o.StickySession = v
}

// GetTimeout returns value of Timeout
func (o *ProxyLBUpdateSettingsRequest) GetTimeout() *ProxyLBTimeout {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *ProxyLBUpdateSettingsRequest) SetTimeout(v *ProxyLBTimeout) {
	o.Timeout = v
}

// GetGzip returns value of Gzip
func (o *ProxyLBUpdateSettingsRequest) GetGzip() *ProxyLBGzip {
	return o.Gzip
}

// SetGzip sets value to Gzip
func (o *ProxyLBUpdateSettingsRequest) SetGzip(v *ProxyLBGzip) {
	o.Gzip = v
}

// GetBackendHttpKeepAlive returns value of BackendHttpKeepAlive
func (o *ProxyLBUpdateSettingsRequest) GetBackendHttpKeepAlive() *ProxyLBBackendHttpKeepAlive {
	return o.BackendHttpKeepAlive
}

// SetBackendHttpKeepAlive sets value to BackendHttpKeepAlive
func (o *ProxyLBUpdateSettingsRequest) SetBackendHttpKeepAlive(v *ProxyLBBackendHttpKeepAlive) {
	o.BackendHttpKeepAlive = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *ProxyLBUpdateSettingsRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *ProxyLBUpdateSettingsRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetProxyProtocol returns value of ProxyProtocol
func (o *ProxyLBUpdateSettingsRequest) GetProxyProtocol() *ProxyLBProxyProtocol {
	return o.ProxyProtocol
}

// SetProxyProtocol sets value to ProxyProtocol
func (o *ProxyLBUpdateSettingsRequest) SetProxyProtocol(v *ProxyLBProxyProtocol) {
	o.ProxyProtocol = v
}

// GetSyslog returns value of Syslog
func (o *ProxyLBUpdateSettingsRequest) GetSyslog() *ProxyLBSyslog {
	return o.Syslog
}

// SetSyslog sets value to Syslog
func (o *ProxyLBUpdateSettingsRequest) SetSyslog(v *ProxyLBSyslog) {
	o.Syslog = v
}

// GetSettingsHash returns value of SettingsHash
func (o *ProxyLBUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *ProxyLBUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* ProxyLBChangePlanRequest
*************************************************/

// ProxyLBChangePlanRequest represents API parameter/response structure
type ProxyLBChangePlanRequest struct {
	ServiceClass string
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBChangePlanRequest) setDefaults() interface{} {
	return &struct {
		ServiceClass string
	}{
		ServiceClass: o.GetServiceClass(),
	}
}

// GetServiceClass returns value of ServiceClass
func (o *ProxyLBChangePlanRequest) GetServiceClass() string {
	return o.ServiceClass
}

// SetServiceClass sets value to ServiceClass
func (o *ProxyLBChangePlanRequest) SetServiceClass(v string) {
	o.ServiceClass = v
}

/*************************************************
* ProxyLBCertificates
*************************************************/

// ProxyLBCertificates represents API parameter/response structure
type ProxyLBCertificates struct {
	PrimaryCert     *ProxyLBPrimaryCert
	AdditionalCerts []*ProxyLBAdditionalCert `mapconv:"[]AdditionalCerts, recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBCertificates) setDefaults() interface{} {
	return &struct {
		PrimaryCert     *ProxyLBPrimaryCert
		AdditionalCerts []*ProxyLBAdditionalCert `mapconv:"[]AdditionalCerts, recursive"`
	}{
		PrimaryCert:     o.GetPrimaryCert(),
		AdditionalCerts: o.GetAdditionalCerts(),
	}
}

// GetPrimaryCert returns value of PrimaryCert
func (o *ProxyLBCertificates) GetPrimaryCert() *ProxyLBPrimaryCert {
	return o.PrimaryCert
}

// SetPrimaryCert sets value to PrimaryCert
func (o *ProxyLBCertificates) SetPrimaryCert(v *ProxyLBPrimaryCert) {
	o.PrimaryCert = v
}

// GetAdditionalCerts returns value of AdditionalCerts
func (o *ProxyLBCertificates) GetAdditionalCerts() []*ProxyLBAdditionalCert {
	return o.AdditionalCerts
}

// SetAdditionalCerts sets value to AdditionalCerts
func (o *ProxyLBCertificates) SetAdditionalCerts(v []*ProxyLBAdditionalCert) {
	o.AdditionalCerts = v
}

/*************************************************
* ProxyLBPrimaryCert
*************************************************/

// ProxyLBPrimaryCert represents API parameter/response structure
type ProxyLBPrimaryCert struct {
	ServerCertificate       string
	IntermediateCertificate string
	PrivateKey              string
	CertificateEndDate      time.Time
	CertificateCommonName   string
	CertificateAltNames     string
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBPrimaryCert) setDefaults() interface{} {
	return &struct {
		ServerCertificate       string
		IntermediateCertificate string
		PrivateKey              string
		CertificateEndDate      time.Time
		CertificateCommonName   string
		CertificateAltNames     string
	}{
		ServerCertificate:       o.GetServerCertificate(),
		IntermediateCertificate: o.GetIntermediateCertificate(),
		PrivateKey:              o.GetPrivateKey(),
		CertificateEndDate:      o.GetCertificateEndDate(),
		CertificateCommonName:   o.GetCertificateCommonName(),
		CertificateAltNames:     o.GetCertificateAltNames(),
	}
}

// GetServerCertificate returns value of ServerCertificate
func (o *ProxyLBPrimaryCert) GetServerCertificate() string {
	return o.ServerCertificate
}

// SetServerCertificate sets value to ServerCertificate
func (o *ProxyLBPrimaryCert) SetServerCertificate(v string) {
	o.ServerCertificate = v
}

// GetIntermediateCertificate returns value of IntermediateCertificate
func (o *ProxyLBPrimaryCert) GetIntermediateCertificate() string {
	return o.IntermediateCertificate
}

// SetIntermediateCertificate sets value to IntermediateCertificate
func (o *ProxyLBPrimaryCert) SetIntermediateCertificate(v string) {
	o.IntermediateCertificate = v
}

// GetPrivateKey returns value of PrivateKey
func (o *ProxyLBPrimaryCert) GetPrivateKey() string {
	return o.PrivateKey
}

// SetPrivateKey sets value to PrivateKey
func (o *ProxyLBPrimaryCert) SetPrivateKey(v string) {
	o.PrivateKey = v
}

// GetCertificateEndDate returns value of CertificateEndDate
func (o *ProxyLBPrimaryCert) GetCertificateEndDate() time.Time {
	return o.CertificateEndDate
}

// SetCertificateEndDate sets value to CertificateEndDate
func (o *ProxyLBPrimaryCert) SetCertificateEndDate(v time.Time) {
	o.CertificateEndDate = v
}

// GetCertificateCommonName returns value of CertificateCommonName
func (o *ProxyLBPrimaryCert) GetCertificateCommonName() string {
	return o.CertificateCommonName
}

// SetCertificateCommonName sets value to CertificateCommonName
func (o *ProxyLBPrimaryCert) SetCertificateCommonName(v string) {
	o.CertificateCommonName = v
}

// GetCertificateAltNames returns value of CertificateAltNames
func (o *ProxyLBPrimaryCert) GetCertificateAltNames() string {
	return o.CertificateAltNames
}

// SetCertificateAltNames sets value to CertificateAltNames
func (o *ProxyLBPrimaryCert) SetCertificateAltNames(v string) {
	o.CertificateAltNames = v
}

/*************************************************
* ProxyLBAdditionalCert
*************************************************/

// ProxyLBAdditionalCert represents API parameter/response structure
type ProxyLBAdditionalCert struct {
	ServerCertificate       string
	IntermediateCertificate string
	PrivateKey              string
	CertificateEndDate      time.Time
	CertificateCommonName   string
	CertificateAltNames     string
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBAdditionalCert) setDefaults() interface{} {
	return &struct {
		ServerCertificate       string
		IntermediateCertificate string
		PrivateKey              string
		CertificateEndDate      time.Time
		CertificateCommonName   string
		CertificateAltNames     string
	}{
		ServerCertificate:       o.GetServerCertificate(),
		IntermediateCertificate: o.GetIntermediateCertificate(),
		PrivateKey:              o.GetPrivateKey(),
		CertificateEndDate:      o.GetCertificateEndDate(),
		CertificateCommonName:   o.GetCertificateCommonName(),
		CertificateAltNames:     o.GetCertificateAltNames(),
	}
}

// GetServerCertificate returns value of ServerCertificate
func (o *ProxyLBAdditionalCert) GetServerCertificate() string {
	return o.ServerCertificate
}

// SetServerCertificate sets value to ServerCertificate
func (o *ProxyLBAdditionalCert) SetServerCertificate(v string) {
	o.ServerCertificate = v
}

// GetIntermediateCertificate returns value of IntermediateCertificate
func (o *ProxyLBAdditionalCert) GetIntermediateCertificate() string {
	return o.IntermediateCertificate
}

// SetIntermediateCertificate sets value to IntermediateCertificate
func (o *ProxyLBAdditionalCert) SetIntermediateCertificate(v string) {
	o.IntermediateCertificate = v
}

// GetPrivateKey returns value of PrivateKey
func (o *ProxyLBAdditionalCert) GetPrivateKey() string {
	return o.PrivateKey
}

// SetPrivateKey sets value to PrivateKey
func (o *ProxyLBAdditionalCert) SetPrivateKey(v string) {
	o.PrivateKey = v
}

// GetCertificateEndDate returns value of CertificateEndDate
func (o *ProxyLBAdditionalCert) GetCertificateEndDate() time.Time {
	return o.CertificateEndDate
}

// SetCertificateEndDate sets value to CertificateEndDate
func (o *ProxyLBAdditionalCert) SetCertificateEndDate(v time.Time) {
	o.CertificateEndDate = v
}

// GetCertificateCommonName returns value of CertificateCommonName
func (o *ProxyLBAdditionalCert) GetCertificateCommonName() string {
	return o.CertificateCommonName
}

// SetCertificateCommonName sets value to CertificateCommonName
func (o *ProxyLBAdditionalCert) SetCertificateCommonName(v string) {
	o.CertificateCommonName = v
}

// GetCertificateAltNames returns value of CertificateAltNames
func (o *ProxyLBAdditionalCert) GetCertificateAltNames() string {
	return o.CertificateAltNames
}

// SetCertificateAltNames sets value to CertificateAltNames
func (o *ProxyLBAdditionalCert) SetCertificateAltNames(v string) {
	o.CertificateAltNames = v
}

/*************************************************
* ProxyLBSetCertificatesRequest
*************************************************/

// ProxyLBSetCertificatesRequest represents API parameter/response structure
type ProxyLBSetCertificatesRequest struct {
	PrimaryCerts    *ProxyLBPrimaryCert      `mapconv:"PrimaryCert"`
	AdditionalCerts []*ProxyLBAdditionalCert `mapconv:"[]AdditionalCerts, recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBSetCertificatesRequest) setDefaults() interface{} {
	return &struct {
		PrimaryCerts    *ProxyLBPrimaryCert      `mapconv:"PrimaryCert"`
		AdditionalCerts []*ProxyLBAdditionalCert `mapconv:"[]AdditionalCerts, recursive"`
	}{
		PrimaryCerts:    o.GetPrimaryCerts(),
		AdditionalCerts: o.GetAdditionalCerts(),
	}
}

// GetPrimaryCerts returns value of PrimaryCerts
func (o *ProxyLBSetCertificatesRequest) GetPrimaryCerts() *ProxyLBPrimaryCert {
	return o.PrimaryCerts
}

// SetPrimaryCerts sets value to PrimaryCerts
func (o *ProxyLBSetCertificatesRequest) SetPrimaryCerts(v *ProxyLBPrimaryCert) {
	o.PrimaryCerts = v
}

// GetAdditionalCerts returns value of AdditionalCerts
func (o *ProxyLBSetCertificatesRequest) GetAdditionalCerts() []*ProxyLBAdditionalCert {
	return o.AdditionalCerts
}

// SetAdditionalCerts sets value to AdditionalCerts
func (o *ProxyLBSetCertificatesRequest) SetAdditionalCerts(v []*ProxyLBAdditionalCert) {
	o.AdditionalCerts = v
}

/*************************************************
* ProxyLBHealth
*************************************************/

// ProxyLBHealth represents API parameter/response structure
type ProxyLBHealth struct {
	ActiveConn int
	CPS        float64
	CurrentVIP string
	Servers    []*LoadBalancerServerStatus `mapconv:"[]Servers,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ProxyLBHealth) setDefaults() interface{} {
	return &struct {
		ActiveConn int
		CPS        float64
		CurrentVIP string
		Servers    []*LoadBalancerServerStatus `mapconv:"[]Servers,recursive"`
	}{
		ActiveConn: o.GetActiveConn(),
		CPS:        o.GetCPS(),
		CurrentVIP: o.GetCurrentVIP(),
		Servers:    o.GetServers(),
	}
}

// GetActiveConn returns value of ActiveConn
func (o *ProxyLBHealth) GetActiveConn() int {
	return o.ActiveConn
}

// SetActiveConn sets value to ActiveConn
func (o *ProxyLBHealth) SetActiveConn(v int) {
	o.ActiveConn = v
}

// GetCPS returns value of CPS
func (o *ProxyLBHealth) GetCPS() float64 {
	return o.CPS
}

// SetCPS sets value to CPS
func (o *ProxyLBHealth) SetCPS(v float64) {
	o.CPS = v
}

// GetCurrentVIP returns value of CurrentVIP
func (o *ProxyLBHealth) GetCurrentVIP() string {
	return o.CurrentVIP
}

// SetCurrentVIP sets value to CurrentVIP
func (o *ProxyLBHealth) SetCurrentVIP(v string) {
	o.CurrentVIP = v
}

// GetServers returns value of Servers
func (o *ProxyLBHealth) GetServers() []*LoadBalancerServerStatus {
	return o.Servers
}

// SetServers sets value to Servers
func (o *ProxyLBHealth) SetServers(v []*LoadBalancerServerStatus) {
	o.Servers = v
}

/*************************************************
* ConnectionActivity
*************************************************/

// ConnectionActivity represents API parameter/response structure
type ConnectionActivity struct {
	Values []*MonitorConnectionValue `mapconv:"[]Connection"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ConnectionActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorConnectionValue `mapconv:"[]Connection"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *ConnectionActivity) GetValues() []*MonitorConnectionValue {
	return o.Values
}

// SetValues sets value to Values
func (o *ConnectionActivity) SetValues(v []*MonitorConnectionValue) {
	o.Values = v
}

/*************************************************
* MonitorConnectionValue
*************************************************/

// MonitorConnectionValue represents API parameter/response structure
type MonitorConnectionValue struct {
	Time              time.Time `mapconv:",omitempty"`
	ActiveConnections float64   `mapconv:",omitempty"`
	ConnectionsPerSec float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorConnectionValue) setDefaults() interface{} {
	return &struct {
		Time              time.Time `mapconv:",omitempty"`
		ActiveConnections float64   `mapconv:",omitempty"`
		ConnectionsPerSec float64   `mapconv:",omitempty"`
	}{
		Time:              o.GetTime(),
		ActiveConnections: o.GetActiveConnections(),
		ConnectionsPerSec: o.GetConnectionsPerSec(),
	}
}

// GetTime returns value of Time
func (o *MonitorConnectionValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorConnectionValue) SetTime(v time.Time) {
	o.Time = v
}

// GetActiveConnections returns value of ActiveConnections
func (o *MonitorConnectionValue) GetActiveConnections() float64 {
	return o.ActiveConnections
}

// SetActiveConnections sets value to ActiveConnections
func (o *MonitorConnectionValue) SetActiveConnections(v float64) {
	o.ActiveConnections = v
}

// GetConnectionsPerSec returns value of ConnectionsPerSec
func (o *MonitorConnectionValue) GetConnectionsPerSec() float64 {
	return o.ConnectionsPerSec
}

// SetConnectionsPerSec sets value to ConnectionsPerSec
func (o *MonitorConnectionValue) SetConnectionsPerSec(v float64) {
	o.ConnectionsPerSec = v
}

/*************************************************
* Server
*************************************************/

// Server represents API parameter/response structure
type Server struct {
	ID                      types.ID
	Name                    string
	Description             string
	Tags                    types.Tags
	Availability            types.EAvailability
	HostName                string
	InterfaceDriver         types.EInterfaceDriver
	ServerPlanID            types.ID                    `mapconv:"ServerPlan.ID"`
	ServerPlanName          string                      `mapconv:"ServerPlan.Name"`
	CPU                     int                         `mapconv:"ServerPlan.CPU"`
	MemoryMB                int                         `mapconv:"ServerPlan.MemoryMB"`
	GPU                     int                         `mapconv:"ServerPlan.GPU"`
	GPUModel                string                      `json:",omitempty" mapconv:"ServerPlan.GPUModel"`
	CPUModel                string                      `json:",omitempty" mapconv:"ServerPlan.CPUModel"`
	Commitment              types.ECommitment           `json:",omitempty" mapconv:"ServerPlan.Commitment"`
	Generation              types.EPlanGeneration       `mapconv:"ServerPlan.Generation"`
	Zone                    *ZoneInfo                   `json:",omitempty" mapconv:",omitempty,recursive"`
	InstanceHostName        string                      `mapconv:"Instance.Host.Name"`
	InstanceHostInfoURL     string                      `mapconv:"Instance.Host.InfoURL"`
	InstanceStatus          types.EServerInstanceStatus `mapconv:"Instance.Status"`
	InstanceBeforeStatus    types.EServerInstanceStatus `mapconv:"Instance.BeforeStatus"`
	InstanceStatusChangedAt time.Time                   `mapconv:"Instance.StatusChangedAt"`
	InstanceWarnings        string                      `mapconv:"Instance.Warnings"`
	InstanceWarningsValue   int                         `mapconv:"Instance.WarningsValue"`
	Disks                   []*ServerConnectedDisk      `json:",omitempty" mapconv:",recursive"`
	Interfaces              []*InterfaceView            `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
	CDROMID                 types.ID                    `mapconv:"Instance.CDROM.ID"`
	PrivateHostID           types.ID                    `mapconv:"PrivateHost.ID"`
	PrivateHostName         string                      `mapconv:"PrivateHost.Name"`
	BundleInfo              *BundleInfo                 `json:",omitempty" mapconv:",omitempty,recursive"`
	IconID                  types.ID                    `mapconv:"Icon.ID"`
	CreatedAt               time.Time
	ModifiedAt              time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *Server) setDefaults() interface{} {
	return &struct {
		ID                      types.ID
		Name                    string
		Description             string
		Tags                    types.Tags
		Availability            types.EAvailability
		HostName                string
		InterfaceDriver         types.EInterfaceDriver
		ServerPlanID            types.ID                    `mapconv:"ServerPlan.ID"`
		ServerPlanName          string                      `mapconv:"ServerPlan.Name"`
		CPU                     int                         `mapconv:"ServerPlan.CPU"`
		MemoryMB                int                         `mapconv:"ServerPlan.MemoryMB"`
		GPU                     int                         `mapconv:"ServerPlan.GPU"`
		GPUModel                string                      `json:",omitempty" mapconv:"ServerPlan.GPUModel"`
		CPUModel                string                      `json:",omitempty" mapconv:"ServerPlan.CPUModel"`
		Commitment              types.ECommitment           `json:",omitempty" mapconv:"ServerPlan.Commitment"`
		Generation              types.EPlanGeneration       `mapconv:"ServerPlan.Generation"`
		Zone                    *ZoneInfo                   `json:",omitempty" mapconv:",omitempty,recursive"`
		InstanceHostName        string                      `mapconv:"Instance.Host.Name"`
		InstanceHostInfoURL     string                      `mapconv:"Instance.Host.InfoURL"`
		InstanceStatus          types.EServerInstanceStatus `mapconv:"Instance.Status"`
		InstanceBeforeStatus    types.EServerInstanceStatus `mapconv:"Instance.BeforeStatus"`
		InstanceStatusChangedAt time.Time                   `mapconv:"Instance.StatusChangedAt"`
		InstanceWarnings        string                      `mapconv:"Instance.Warnings"`
		InstanceWarningsValue   int                         `mapconv:"Instance.WarningsValue"`
		Disks                   []*ServerConnectedDisk      `json:",omitempty" mapconv:",recursive"`
		Interfaces              []*InterfaceView            `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
		CDROMID                 types.ID                    `mapconv:"Instance.CDROM.ID"`
		PrivateHostID           types.ID                    `mapconv:"PrivateHost.ID"`
		PrivateHostName         string                      `mapconv:"PrivateHost.Name"`
		BundleInfo              *BundleInfo                 `json:",omitempty" mapconv:",omitempty,recursive"`
		IconID                  types.ID                    `mapconv:"Icon.ID"`
		CreatedAt               time.Time
		ModifiedAt              time.Time
	}{
		ID:                      o.GetID(),
		Name:                    o.GetName(),
		Description:             o.GetDescription(),
		Tags:                    o.GetTags(),
		Availability:            o.GetAvailability(),
		HostName:                o.GetHostName(),
		InterfaceDriver:         o.GetInterfaceDriver(),
		ServerPlanID:            o.GetServerPlanID(),
		ServerPlanName:          o.GetServerPlanName(),
		CPU:                     o.GetCPU(),
		MemoryMB:                o.GetMemoryMB(),
		GPU:                     o.GetGPU(),
		GPUModel:                o.GetGPUModel(),
		CPUModel:                o.GetCPUModel(),
		Commitment:              o.GetCommitment(),
		Generation:              o.GetGeneration(),
		Zone:                    o.GetZone(),
		InstanceHostName:        o.GetInstanceHostName(),
		InstanceHostInfoURL:     o.GetInstanceHostInfoURL(),
		InstanceStatus:          o.GetInstanceStatus(),
		InstanceBeforeStatus:    o.GetInstanceBeforeStatus(),
		InstanceStatusChangedAt: o.GetInstanceStatusChangedAt(),
		InstanceWarnings:        o.GetInstanceWarnings(),
		InstanceWarningsValue:   o.GetInstanceWarningsValue(),
		Disks:                   o.GetDisks(),
		Interfaces:              o.GetInterfaces(),
		CDROMID:                 o.GetCDROMID(),
		PrivateHostID:           o.GetPrivateHostID(),
		PrivateHostName:         o.GetPrivateHostName(),
		BundleInfo:              o.GetBundleInfo(),
		IconID:                  o.GetIconID(),
		CreatedAt:               o.GetCreatedAt(),
		ModifiedAt:              o.GetModifiedAt(),
	}
}

// GetID returns value of ID
func (o *Server) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Server) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Server) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Server) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Server) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Server) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Server) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Server) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Server) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Server) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *Server) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *Server) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *Server) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *Server) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *Server) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *Server) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *Server) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *Server) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetHostName returns value of HostName
func (o *Server) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *Server) SetHostName(v string) {
	o.HostName = v
}

// GetInterfaceDriver returns value of InterfaceDriver
func (o *Server) GetInterfaceDriver() types.EInterfaceDriver {
	if o.InterfaceDriver == types.EInterfaceDriver("") {
		return types.InterfaceDrivers.VirtIO
	}
	return o.InterfaceDriver
}

// SetInterfaceDriver sets value to InterfaceDriver
func (o *Server) SetInterfaceDriver(v types.EInterfaceDriver) {
	o.InterfaceDriver = v
}

// GetServerPlanID returns value of ServerPlanID
func (o *Server) GetServerPlanID() types.ID {
	return o.ServerPlanID
}

// SetServerPlanID sets value to ServerPlanID
func (o *Server) SetServerPlanID(v types.ID) {
	o.ServerPlanID = v
}

// GetServerPlanName returns value of ServerPlanName
func (o *Server) GetServerPlanName() string {
	return o.ServerPlanName
}

// SetServerPlanName sets value to ServerPlanName
func (o *Server) SetServerPlanName(v string) {
	o.ServerPlanName = v
}

// GetCPU returns value of CPU
func (o *Server) GetCPU() int {
	return o.CPU
}

// SetCPU sets value to CPU
func (o *Server) SetCPU(v int) {
	o.CPU = v
}

// GetMemoryMB returns value of MemoryMB
func (o *Server) GetMemoryMB() int {
	return o.MemoryMB
}

// SetMemoryMB sets value to MemoryMB
func (o *Server) SetMemoryMB(v int) {
	o.MemoryMB = v
}

// GetMemoryGB .
func (o *Server) GetMemoryGB() int {
	return accessor.GetMemoryGB(o)
}

// GetGPU returns value of GPU
func (o *Server) GetGPU() int {
	return o.GPU
}

// SetGPU sets value to GPU
func (o *Server) SetGPU(v int) {
	o.GPU = v
}

// GetGPUModel returns value of GPUModel
func (o *Server) GetGPUModel() string {
	return o.GPUModel
}

// SetGPUModel sets value to GPUModel
func (o *Server) SetGPUModel(v string) {
	o.GPUModel = v
}

// GetCPUModel returns value of CPUModel
func (o *Server) GetCPUModel() string {
	return o.CPUModel
}

// SetCPUModel sets value to CPUModel
func (o *Server) SetCPUModel(v string) {
	o.CPUModel = v
}

// GetCommitment returns value of Commitment
func (o *Server) GetCommitment() types.ECommitment {
	if o.Commitment == types.ECommitment("") {
		return types.Commitments.Standard
	}
	return o.Commitment
}

// SetCommitment sets value to Commitment
func (o *Server) SetCommitment(v types.ECommitment) {
	o.Commitment = v
}

// GetGeneration returns value of Generation
func (o *Server) GetGeneration() types.EPlanGeneration {
	return o.Generation
}

// SetGeneration sets value to Generation
func (o *Server) SetGeneration(v types.EPlanGeneration) {
	o.Generation = v
}

// GetZone returns value of Zone
func (o *Server) GetZone() *ZoneInfo {
	return o.Zone
}

// SetZone sets value to Zone
func (o *Server) SetZone(v *ZoneInfo) {
	o.Zone = v
}

// GetInstanceHostName returns value of InstanceHostName
func (o *Server) GetInstanceHostName() string {
	return o.InstanceHostName
}

// SetInstanceHostName sets value to InstanceHostName
func (o *Server) SetInstanceHostName(v string) {
	o.InstanceHostName = v
}

// GetInstanceHostInfoURL returns value of InstanceHostInfoURL
func (o *Server) GetInstanceHostInfoURL() string {
	return o.InstanceHostInfoURL
}

// SetInstanceHostInfoURL sets value to InstanceHostInfoURL
func (o *Server) SetInstanceHostInfoURL(v string) {
	o.InstanceHostInfoURL = v
}

// GetInstanceStatus returns value of InstanceStatus
func (o *Server) GetInstanceStatus() types.EServerInstanceStatus {
	return o.InstanceStatus
}

// SetInstanceStatus sets value to InstanceStatus
func (o *Server) SetInstanceStatus(v types.EServerInstanceStatus) {
	o.InstanceStatus = v
}

// GetInstanceBeforeStatus returns value of InstanceBeforeStatus
func (o *Server) GetInstanceBeforeStatus() types.EServerInstanceStatus {
	return o.InstanceBeforeStatus
}

// SetInstanceBeforeStatus sets value to InstanceBeforeStatus
func (o *Server) SetInstanceBeforeStatus(v types.EServerInstanceStatus) {
	o.InstanceBeforeStatus = v
}

// GetInstanceStatusChangedAt returns value of InstanceStatusChangedAt
func (o *Server) GetInstanceStatusChangedAt() time.Time {
	return o.InstanceStatusChangedAt
}

// SetInstanceStatusChangedAt sets value to InstanceStatusChangedAt
func (o *Server) SetInstanceStatusChangedAt(v time.Time) {
	o.InstanceStatusChangedAt = v
}

// GetInstanceWarnings returns value of InstanceWarnings
func (o *Server) GetInstanceWarnings() string {
	return o.InstanceWarnings
}

// SetInstanceWarnings sets value to InstanceWarnings
func (o *Server) SetInstanceWarnings(v string) {
	o.InstanceWarnings = v
}

// GetInstanceWarningsValue returns value of InstanceWarningsValue
func (o *Server) GetInstanceWarningsValue() int {
	return o.InstanceWarningsValue
}

// SetInstanceWarningsValue sets value to InstanceWarningsValue
func (o *Server) SetInstanceWarningsValue(v int) {
	o.InstanceWarningsValue = v
}

// GetDisks returns value of Disks
func (o *Server) GetDisks() []*ServerConnectedDisk {
	return o.Disks
}

// SetDisks sets value to Disks
func (o *Server) SetDisks(v []*ServerConnectedDisk) {
	o.Disks = v
}

// GetInterfaces returns value of Interfaces
func (o *Server) GetInterfaces() []*InterfaceView {
	return o.Interfaces
}

// SetInterfaces sets value to Interfaces
func (o *Server) SetInterfaces(v []*InterfaceView) {
	o.Interfaces = v
}

// GetCDROMID returns value of CDROMID
func (o *Server) GetCDROMID() types.ID {
	return o.CDROMID
}

// SetCDROMID sets value to CDROMID
func (o *Server) SetCDROMID(v types.ID) {
	o.CDROMID = v
}

// GetPrivateHostID returns value of PrivateHostID
func (o *Server) GetPrivateHostID() types.ID {
	return o.PrivateHostID
}

// SetPrivateHostID sets value to PrivateHostID
func (o *Server) SetPrivateHostID(v types.ID) {
	o.PrivateHostID = v
}

// GetPrivateHostName returns value of PrivateHostName
func (o *Server) GetPrivateHostName() string {
	return o.PrivateHostName
}

// SetPrivateHostName sets value to PrivateHostName
func (o *Server) SetPrivateHostName(v string) {
	o.PrivateHostName = v
}

// GetBundleInfo returns value of BundleInfo
func (o *Server) GetBundleInfo() *BundleInfo {
	return o.BundleInfo
}

// SetBundleInfo sets value to BundleInfo
func (o *Server) SetBundleInfo(v *BundleInfo) {
	o.BundleInfo = v
}

// GetIconID returns value of IconID
func (o *Server) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *Server) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Server) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Server) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *Server) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *Server) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* ZoneInfo
*************************************************/

// ZoneInfo represents API parameter/response structure
type ZoneInfo struct {
	ID          types.ID
	Name        string
	DisplayName string         `json:",omitempty" mapconv:"Description,omitempty"`
	IsDummy     bool           `json:",omitempty" mapconv:",omitempty"`
	VNCProxy    *VNCProxy      `json:",omitempty" mapconv:",omitempty,recursive"`
	FTPServer   *FTPServerInfo `json:",omitempty" mapconv:",omitempty,recursive"`
	Region      *Region        `json:",omitempty" mapconv:",omitempty,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ZoneInfo) setDefaults() interface{} {
	return &struct {
		ID          types.ID
		Name        string
		DisplayName string         `json:",omitempty" mapconv:"Description,omitempty"`
		IsDummy     bool           `json:",omitempty" mapconv:",omitempty"`
		VNCProxy    *VNCProxy      `json:",omitempty" mapconv:",omitempty,recursive"`
		FTPServer   *FTPServerInfo `json:",omitempty" mapconv:",omitempty,recursive"`
		Region      *Region        `json:",omitempty" mapconv:",omitempty,recursive"`
	}{
		ID:          o.GetID(),
		Name:        o.GetName(),
		DisplayName: o.GetDisplayName(),
		IsDummy:     o.GetIsDummy(),
		VNCProxy:    o.GetVNCProxy(),
		FTPServer:   o.GetFTPServer(),
		Region:      o.GetRegion(),
	}
}

// GetID returns value of ID
func (o *ZoneInfo) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ZoneInfo) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ZoneInfo) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ZoneInfo) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ZoneInfo) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ZoneInfo) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *ZoneInfo) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ZoneInfo) SetName(v string) {
	o.Name = v
}

// GetDisplayName returns value of DisplayName
func (o *ZoneInfo) GetDisplayName() string {
	return o.DisplayName
}

// SetDisplayName sets value to DisplayName
func (o *ZoneInfo) SetDisplayName(v string) {
	o.DisplayName = v
}

// GetIsDummy returns value of IsDummy
func (o *ZoneInfo) GetIsDummy() bool {
	return o.IsDummy
}

// SetIsDummy sets value to IsDummy
func (o *ZoneInfo) SetIsDummy(v bool) {
	o.IsDummy = v
}

// GetVNCProxy returns value of VNCProxy
func (o *ZoneInfo) GetVNCProxy() *VNCProxy {
	return o.VNCProxy
}

// SetVNCProxy sets value to VNCProxy
func (o *ZoneInfo) SetVNCProxy(v *VNCProxy) {
	o.VNCProxy = v
}

// GetFTPServer returns value of FTPServer
func (o *ZoneInfo) GetFTPServer() *FTPServerInfo {
	return o.FTPServer
}

// SetFTPServer sets value to FTPServer
func (o *ZoneInfo) SetFTPServer(v *FTPServerInfo) {
	o.FTPServer = v
}

// GetRegion returns value of Region
func (o *ZoneInfo) GetRegion() *Region {
	return o.Region
}

// SetRegion sets value to Region
func (o *ZoneInfo) SetRegion(v *Region) {
	o.Region = v
}

/*************************************************
* VNCProxy
*************************************************/

// VNCProxy represents API parameter/response structure
type VNCProxy struct {
	HostName  string `json:",omitempty" mapconv:",omitempty"`
	IPAddress string `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VNCProxy) setDefaults() interface{} {
	return &struct {
		HostName  string `json:",omitempty" mapconv:",omitempty"`
		IPAddress string `json:",omitempty" mapconv:",omitempty"`
	}{
		HostName:  o.GetHostName(),
		IPAddress: o.GetIPAddress(),
	}
}

// GetHostName returns value of HostName
func (o *VNCProxy) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *VNCProxy) SetHostName(v string) {
	o.HostName = v
}

// GetIPAddress returns value of IPAddress
func (o *VNCProxy) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VNCProxy) SetIPAddress(v string) {
	o.IPAddress = v
}

/*************************************************
* FTPServerInfo
*************************************************/

// FTPServerInfo represents API parameter/response structure
type FTPServerInfo struct {
	HostName  string
	IPAddress string
}

// setDefaults implements iaas.argumentDefaulter
func (o *FTPServerInfo) setDefaults() interface{} {
	return &struct {
		HostName  string
		IPAddress string
	}{
		HostName:  o.GetHostName(),
		IPAddress: o.GetIPAddress(),
	}
}

// GetHostName returns value of HostName
func (o *FTPServerInfo) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *FTPServerInfo) SetHostName(v string) {
	o.HostName = v
}

// GetIPAddress returns value of IPAddress
func (o *FTPServerInfo) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *FTPServerInfo) SetIPAddress(v string) {
	o.IPAddress = v
}

/*************************************************
* ServerConnectedDisk
*************************************************/

// ServerConnectedDisk represents API parameter/response structure
type ServerConnectedDisk struct {
	ID                  types.ID
	Name                string
	Availability        types.EAvailability
	Connection          types.EDiskConnection `json:",omitempty" mapconv:",omitempty"`
	ConnectionOrder     int
	EncryptionAlgorithm types.EDiskEncryptionAlgorithm `json:",omitempty" mapconv:",omitempty"`
	ReinstallCount      int
	SizeMB              int
	DiskPlanID          types.ID `mapconv:"Plan.ID"`
	Storage             *Storage `json:",omitempty" mapconv:",omitempty,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ServerConnectedDisk) setDefaults() interface{} {
	return &struct {
		ID                  types.ID
		Name                string
		Availability        types.EAvailability
		Connection          types.EDiskConnection `json:",omitempty" mapconv:",omitempty"`
		ConnectionOrder     int
		EncryptionAlgorithm types.EDiskEncryptionAlgorithm `json:",omitempty" mapconv:",omitempty"`
		ReinstallCount      int
		SizeMB              int
		DiskPlanID          types.ID `mapconv:"Plan.ID"`
		Storage             *Storage `json:",omitempty" mapconv:",omitempty,recursive"`
	}{
		ID:                  o.GetID(),
		Name:                o.GetName(),
		Availability:        o.GetAvailability(),
		Connection:          o.GetConnection(),
		ConnectionOrder:     o.GetConnectionOrder(),
		EncryptionAlgorithm: o.GetEncryptionAlgorithm(),
		ReinstallCount:      o.GetReinstallCount(),
		SizeMB:              o.GetSizeMB(),
		DiskPlanID:          o.GetDiskPlanID(),
		Storage:             o.GetStorage(),
	}
}

// GetID returns value of ID
func (o *ServerConnectedDisk) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ServerConnectedDisk) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ServerConnectedDisk) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ServerConnectedDisk) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ServerConnectedDisk) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ServerConnectedDisk) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *ServerConnectedDisk) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ServerConnectedDisk) SetName(v string) {
	o.Name = v
}

// GetAvailability returns value of Availability
func (o *ServerConnectedDisk) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *ServerConnectedDisk) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetConnection returns value of Connection
func (o *ServerConnectedDisk) GetConnection() types.EDiskConnection {
	return o.Connection
}

// SetConnection sets value to Connection
func (o *ServerConnectedDisk) SetConnection(v types.EDiskConnection) {
	o.Connection = v
}

// GetConnectionOrder returns value of ConnectionOrder
func (o *ServerConnectedDisk) GetConnectionOrder() int {
	return o.ConnectionOrder
}

// SetConnectionOrder sets value to ConnectionOrder
func (o *ServerConnectedDisk) SetConnectionOrder(v int) {
	o.ConnectionOrder = v
}

// GetEncryptionAlgorithm returns value of EncryptionAlgorithm
func (o *ServerConnectedDisk) GetEncryptionAlgorithm() types.EDiskEncryptionAlgorithm {
	return o.EncryptionAlgorithm
}

// SetEncryptionAlgorithm sets value to EncryptionAlgorithm
func (o *ServerConnectedDisk) SetEncryptionAlgorithm(v types.EDiskEncryptionAlgorithm) {
	o.EncryptionAlgorithm = v
}

// GetReinstallCount returns value of ReinstallCount
func (o *ServerConnectedDisk) GetReinstallCount() int {
	return o.ReinstallCount
}

// SetReinstallCount sets value to ReinstallCount
func (o *ServerConnectedDisk) SetReinstallCount(v int) {
	o.ReinstallCount = v
}

// GetSizeMB returns value of SizeMB
func (o *ServerConnectedDisk) GetSizeMB() int {
	return o.SizeMB
}

// SetSizeMB sets value to SizeMB
func (o *ServerConnectedDisk) SetSizeMB(v int) {
	o.SizeMB = v
}

// GetSizeGB .
func (o *ServerConnectedDisk) GetSizeGB() int {
	return accessor.GetSizeGB(o)
}

// SetSizeGB .
func (o *ServerConnectedDisk) SetSizeGB(size int) {
	accessor.SetSizeGB(o, size)
}

// GetDiskPlanID returns value of DiskPlanID
func (o *ServerConnectedDisk) GetDiskPlanID() types.ID {
	return o.DiskPlanID
}

// SetDiskPlanID sets value to DiskPlanID
func (o *ServerConnectedDisk) SetDiskPlanID(v types.ID) {
	o.DiskPlanID = v
}

// GetStorage returns value of Storage
func (o *ServerConnectedDisk) GetStorage() *Storage {
	return o.Storage
}

// SetStorage sets value to Storage
func (o *ServerConnectedDisk) SetStorage(v *Storage) {
	o.Storage = v
}

/*************************************************
* ServerCreateRequest
*************************************************/

// ServerCreateRequest represents API parameter/response structure
type ServerCreateRequest struct {
	CPU               int                   `mapconv:"ServerPlan.CPU"`
	MemoryMB          int                   `mapconv:"ServerPlan.MemoryMB"`
	GPU               int                   `mapconv:"ServerPlan.GPU"`
	GPUModel          string                `json:",omitempty" mapconv:"ServerPlan.GPUModel"`
	CPUModel          string                `json:",omitempty" mapconv:"ServerPlan.CPUModel"`
	Commitment        types.ECommitment     `json:",omitempty" mapconv:"ServerPlan.Commitment"`
	Generation        types.EPlanGeneration `mapconv:"ServerPlan.Generation"`
	ConnectedSwitches []*ConnectedSwitch    `json:",omitempty" mapconv:"[]ConnectedSwitches,recursive"`
	InterfaceDriver   types.EInterfaceDriver
	Name              string
	Description       string
	Tags              types.Tags
	IconID            types.ID `mapconv:"Icon.ID"`
	WaitDiskMigration bool     `json:",omitempty" mapconv:",omitempty"`
	PrivateHostID     types.ID `mapconv:"PrivateHost.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ServerCreateRequest) setDefaults() interface{} {
	return &struct {
		CPU               int                   `mapconv:"ServerPlan.CPU"`
		MemoryMB          int                   `mapconv:"ServerPlan.MemoryMB"`
		GPU               int                   `mapconv:"ServerPlan.GPU"`
		GPUModel          string                `json:",omitempty" mapconv:"ServerPlan.GPUModel"`
		CPUModel          string                `json:",omitempty" mapconv:"ServerPlan.CPUModel"`
		Commitment        types.ECommitment     `json:",omitempty" mapconv:"ServerPlan.Commitment"`
		Generation        types.EPlanGeneration `mapconv:"ServerPlan.Generation"`
		ConnectedSwitches []*ConnectedSwitch    `json:",omitempty" mapconv:"[]ConnectedSwitches,recursive"`
		InterfaceDriver   types.EInterfaceDriver
		Name              string
		Description       string
		Tags              types.Tags
		IconID            types.ID `mapconv:"Icon.ID"`
		WaitDiskMigration bool     `json:",omitempty" mapconv:",omitempty"`
		PrivateHostID     types.ID `mapconv:"PrivateHost.ID"`
	}{
		CPU:               o.GetCPU(),
		MemoryMB:          o.GetMemoryMB(),
		GPU:               o.GetGPU(),
		GPUModel:          o.GetGPUModel(),
		CPUModel:          o.GetCPUModel(),
		Commitment:        o.GetCommitment(),
		Generation:        o.GetGeneration(),
		ConnectedSwitches: o.GetConnectedSwitches(),
		InterfaceDriver:   o.GetInterfaceDriver(),
		Name:              o.GetName(),
		Description:       o.GetDescription(),
		Tags:              o.GetTags(),
		IconID:            o.GetIconID(),
		WaitDiskMigration: o.GetWaitDiskMigration(),
		PrivateHostID:     o.GetPrivateHostID(),
	}
}

// GetCPU returns value of CPU
func (o *ServerCreateRequest) GetCPU() int {
	return o.CPU
}

// SetCPU sets value to CPU
func (o *ServerCreateRequest) SetCPU(v int) {
	o.CPU = v
}

// GetMemoryMB returns value of MemoryMB
func (o *ServerCreateRequest) GetMemoryMB() int {
	return o.MemoryMB
}

// SetMemoryMB sets value to MemoryMB
func (o *ServerCreateRequest) SetMemoryMB(v int) {
	o.MemoryMB = v
}

// GetMemoryGB .
func (o *ServerCreateRequest) GetMemoryGB() int {
	return accessor.GetMemoryGB(o)
}

// GetGPU returns value of GPU
func (o *ServerCreateRequest) GetGPU() int {
	return o.GPU
}

// SetGPU sets value to GPU
func (o *ServerCreateRequest) SetGPU(v int) {
	o.GPU = v
}

// GetGPUModel returns value of GPUModel
func (o *ServerCreateRequest) GetGPUModel() string {
	return o.GPUModel
}

// SetGPUModel sets value to GPUModel
func (o *ServerCreateRequest) SetGPUModel(v string) {
	o.GPUModel = v
}

// GetCPUModel returns value of CPUModel
func (o *ServerCreateRequest) GetCPUModel() string {
	return o.CPUModel
}

// SetCPUModel sets value to CPUModel
func (o *ServerCreateRequest) SetCPUModel(v string) {
	o.CPUModel = v
}

// GetCommitment returns value of Commitment
func (o *ServerCreateRequest) GetCommitment() types.ECommitment {
	if o.Commitment == types.ECommitment("") {
		return types.Commitments.Standard
	}
	return o.Commitment
}

// SetCommitment sets value to Commitment
func (o *ServerCreateRequest) SetCommitment(v types.ECommitment) {
	o.Commitment = v
}

// GetGeneration returns value of Generation
func (o *ServerCreateRequest) GetGeneration() types.EPlanGeneration {
	return o.Generation
}

// SetGeneration sets value to Generation
func (o *ServerCreateRequest) SetGeneration(v types.EPlanGeneration) {
	o.Generation = v
}

// GetConnectedSwitches returns value of ConnectedSwitches
func (o *ServerCreateRequest) GetConnectedSwitches() []*ConnectedSwitch {
	return o.ConnectedSwitches
}

// SetConnectedSwitches sets value to ConnectedSwitches
func (o *ServerCreateRequest) SetConnectedSwitches(v []*ConnectedSwitch) {
	o.ConnectedSwitches = v
}

// GetInterfaceDriver returns value of InterfaceDriver
func (o *ServerCreateRequest) GetInterfaceDriver() types.EInterfaceDriver {
	if o.InterfaceDriver == types.EInterfaceDriver("") {
		return types.InterfaceDrivers.VirtIO
	}
	return o.InterfaceDriver
}

// SetInterfaceDriver sets value to InterfaceDriver
func (o *ServerCreateRequest) SetInterfaceDriver(v types.EInterfaceDriver) {
	o.InterfaceDriver = v
}

// GetName returns value of Name
func (o *ServerCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ServerCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ServerCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ServerCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ServerCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ServerCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ServerCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ServerCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ServerCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ServerCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ServerCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ServerCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetWaitDiskMigration returns value of WaitDiskMigration
func (o *ServerCreateRequest) GetWaitDiskMigration() bool {
	return o.WaitDiskMigration
}

// SetWaitDiskMigration sets value to WaitDiskMigration
func (o *ServerCreateRequest) SetWaitDiskMigration(v bool) {
	o.WaitDiskMigration = v
}

// GetPrivateHostID returns value of PrivateHostID
func (o *ServerCreateRequest) GetPrivateHostID() types.ID {
	return o.PrivateHostID
}

// SetPrivateHostID sets value to PrivateHostID
func (o *ServerCreateRequest) SetPrivateHostID(v types.ID) {
	o.PrivateHostID = v
}

/*************************************************
* ConnectedSwitch
*************************************************/

// ConnectedSwitch represents API parameter/response structure
type ConnectedSwitch struct {
	ID    types.ID
	Scope types.EScope
}

// setDefaults implements iaas.argumentDefaulter
func (o *ConnectedSwitch) setDefaults() interface{} {
	return &struct {
		ID    types.ID
		Scope types.EScope
	}{
		ID:    o.GetID(),
		Scope: o.GetScope(),
	}
}

// GetID returns value of ID
func (o *ConnectedSwitch) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ConnectedSwitch) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ConnectedSwitch) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ConnectedSwitch) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ConnectedSwitch) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ConnectedSwitch) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetScope returns value of Scope
func (o *ConnectedSwitch) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *ConnectedSwitch) SetScope(v types.EScope) {
	o.Scope = v
}

/*************************************************
* ServerUpdateRequest
*************************************************/

// ServerUpdateRequest represents API parameter/response structure
type ServerUpdateRequest struct {
	Name            string
	Description     string
	Tags            types.Tags
	IconID          types.ID `mapconv:"Icon.ID"`
	PrivateHostID   types.ID `mapconv:"PrivateHost.ID"`
	InterfaceDriver types.EInterfaceDriver
}

// setDefaults implements iaas.argumentDefaulter
func (o *ServerUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name            string
		Description     string
		Tags            types.Tags
		IconID          types.ID `mapconv:"Icon.ID"`
		PrivateHostID   types.ID `mapconv:"PrivateHost.ID"`
		InterfaceDriver types.EInterfaceDriver
	}{
		Name:            o.GetName(),
		Description:     o.GetDescription(),
		Tags:            o.GetTags(),
		IconID:          o.GetIconID(),
		PrivateHostID:   o.GetPrivateHostID(),
		InterfaceDriver: o.GetInterfaceDriver(),
	}
}

// GetName returns value of Name
func (o *ServerUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ServerUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *ServerUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *ServerUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *ServerUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *ServerUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *ServerUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *ServerUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *ServerUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *ServerUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *ServerUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *ServerUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetPrivateHostID returns value of PrivateHostID
func (o *ServerUpdateRequest) GetPrivateHostID() types.ID {
	return o.PrivateHostID
}

// SetPrivateHostID sets value to PrivateHostID
func (o *ServerUpdateRequest) SetPrivateHostID(v types.ID) {
	o.PrivateHostID = v
}

// GetInterfaceDriver returns value of InterfaceDriver
func (o *ServerUpdateRequest) GetInterfaceDriver() types.EInterfaceDriver {
	if o.InterfaceDriver == types.EInterfaceDriver("") {
		return types.InterfaceDrivers.VirtIO
	}
	return o.InterfaceDriver
}

// SetInterfaceDriver sets value to InterfaceDriver
func (o *ServerUpdateRequest) SetInterfaceDriver(v types.EInterfaceDriver) {
	o.InterfaceDriver = v
}

/*************************************************
* ServerDeleteWithDisksRequest
*************************************************/

// ServerDeleteWithDisksRequest represents API parameter/response structure
type ServerDeleteWithDisksRequest struct {
	IDs []types.ID `mapconv:"WithDisk"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ServerDeleteWithDisksRequest) setDefaults() interface{} {
	return &struct {
		IDs []types.ID `mapconv:"WithDisk"`
	}{
		IDs: o.GetIDs(),
	}
}

// GetIDs returns value of IDs
func (o *ServerDeleteWithDisksRequest) GetIDs() []types.ID {
	return o.IDs
}

// SetIDs sets value to IDs
func (o *ServerDeleteWithDisksRequest) SetIDs(v []types.ID) {
	o.IDs = v
}

/*************************************************
* ServerChangePlanRequest
*************************************************/

// ServerChangePlanRequest represents API parameter/response structure
type ServerChangePlanRequest struct {
	CPU        int
	MemoryMB   int
	GPU        int
	GPUModel   string                `json:"GPUModel,omitempty"`
	CPUModel   string                `json:"CPUModel,omitempty"`
	Generation types.EPlanGeneration `json:"Generation,omitempty"`
	Commitment types.ECommitment     `json:"Commitment,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ServerChangePlanRequest) setDefaults() interface{} {
	return &struct {
		CPU        int
		MemoryMB   int
		GPU        int
		GPUModel   string                `json:"GPUModel,omitempty"`
		CPUModel   string                `json:"CPUModel,omitempty"`
		Generation types.EPlanGeneration `json:"Generation,omitempty"`
		Commitment types.ECommitment     `json:"Commitment,omitempty"`
	}{
		CPU:        o.GetCPU(),
		MemoryMB:   o.GetMemoryMB(),
		GPU:        o.GetGPU(),
		GPUModel:   o.GetGPUModel(),
		CPUModel:   o.GetCPUModel(),
		Generation: o.GetGeneration(),
		Commitment: o.GetCommitment(),
	}
}

// GetCPU returns value of CPU
func (o *ServerChangePlanRequest) GetCPU() int {
	return o.CPU
}

// SetCPU sets value to CPU
func (o *ServerChangePlanRequest) SetCPU(v int) {
	o.CPU = v
}

// GetMemoryMB returns value of MemoryMB
func (o *ServerChangePlanRequest) GetMemoryMB() int {
	return o.MemoryMB
}

// SetMemoryMB sets value to MemoryMB
func (o *ServerChangePlanRequest) SetMemoryMB(v int) {
	o.MemoryMB = v
}

// GetMemoryGB .
func (o *ServerChangePlanRequest) GetMemoryGB() int {
	return accessor.GetMemoryGB(o)
}

// SetMemoryGB .
func (o *ServerChangePlanRequest) SetMemoryGB(memory int) {
	accessor.SetMemoryGB(o, memory)
}

// GetGPU returns value of GPU
func (o *ServerChangePlanRequest) GetGPU() int {
	return o.GPU
}

// SetGPU sets value to GPU
func (o *ServerChangePlanRequest) SetGPU(v int) {
	o.GPU = v
}

// GetGPUModel returns value of GPUModel
func (o *ServerChangePlanRequest) GetGPUModel() string {
	return o.GPUModel
}

// SetGPUModel sets value to GPUModel
func (o *ServerChangePlanRequest) SetGPUModel(v string) {
	o.GPUModel = v
}

// GetCPUModel returns value of CPUModel
func (o *ServerChangePlanRequest) GetCPUModel() string {
	return o.CPUModel
}

// SetCPUModel sets value to CPUModel
func (o *ServerChangePlanRequest) SetCPUModel(v string) {
	o.CPUModel = v
}

// GetGeneration returns value of Generation
func (o *ServerChangePlanRequest) GetGeneration() types.EPlanGeneration {
	return o.Generation
}

// SetGeneration sets value to Generation
func (o *ServerChangePlanRequest) SetGeneration(v types.EPlanGeneration) {
	o.Generation = v
}

// GetCommitment returns value of Commitment
func (o *ServerChangePlanRequest) GetCommitment() types.ECommitment {
	if o.Commitment == types.ECommitment("") {
		return types.Commitments.Standard
	}
	return o.Commitment
}

// SetCommitment sets value to Commitment
func (o *ServerChangePlanRequest) SetCommitment(v types.ECommitment) {
	o.Commitment = v
}

/*************************************************
* InsertCDROMRequest
*************************************************/

// InsertCDROMRequest represents API parameter/response structure
type InsertCDROMRequest struct {
	ID types.ID
}

// setDefaults implements iaas.argumentDefaulter
func (o *InsertCDROMRequest) setDefaults() interface{} {
	return &struct {
		ID types.ID
	}{
		ID: o.GetID(),
	}
}

// GetID returns value of ID
func (o *InsertCDROMRequest) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *InsertCDROMRequest) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *InsertCDROMRequest) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *InsertCDROMRequest) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *InsertCDROMRequest) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *InsertCDROMRequest) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

/*************************************************
* EjectCDROMRequest
*************************************************/

// EjectCDROMRequest represents API parameter/response structure
type EjectCDROMRequest struct {
	ID types.ID
}

// setDefaults implements iaas.argumentDefaulter
func (o *EjectCDROMRequest) setDefaults() interface{} {
	return &struct {
		ID types.ID
	}{
		ID: o.GetID(),
	}
}

// GetID returns value of ID
func (o *EjectCDROMRequest) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *EjectCDROMRequest) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *EjectCDROMRequest) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *EjectCDROMRequest) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *EjectCDROMRequest) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *EjectCDROMRequest) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

/*************************************************
* ServerBootVariables
*************************************************/

// ServerBootVariables represents API parameter/response structure
type ServerBootVariables struct {
	UserData string `json:",omitempty" mapconv:"CloudInit.UserData,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ServerBootVariables) setDefaults() interface{} {
	return &struct {
		UserData string `json:",omitempty" mapconv:"CloudInit.UserData,omitempty"`
	}{
		UserData: o.GetUserData(),
	}
}

// GetUserData returns value of UserData
func (o *ServerBootVariables) GetUserData() string {
	return o.UserData
}

// SetUserData sets value to UserData
func (o *ServerBootVariables) SetUserData(v string) {
	o.UserData = v
}

/*************************************************
* SendKeyRequest
*************************************************/

// SendKeyRequest represents API parameter/response structure
type SendKeyRequest struct {
	Key  string
	Keys []string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SendKeyRequest) setDefaults() interface{} {
	return &struct {
		Key  string
		Keys []string
	}{
		Key:  o.GetKey(),
		Keys: o.GetKeys(),
	}
}

// GetKey returns value of Key
func (o *SendKeyRequest) GetKey() string {
	return o.Key
}

// SetKey sets value to Key
func (o *SendKeyRequest) SetKey(v string) {
	o.Key = v
}

// GetKeys returns value of Keys
func (o *SendKeyRequest) GetKeys() []string {
	return o.Keys
}

// SetKeys sets value to Keys
func (o *SendKeyRequest) SetKeys(v []string) {
	o.Keys = v
}

/*************************************************
* VNCProxyInfo
*************************************************/

// VNCProxyInfo represents API parameter/response structure
type VNCProxyInfo struct {
	Status       string
	Host         string
	IOServerHost string
	Port         types.StringNumber
	Password     string
	VNCFile      string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VNCProxyInfo) setDefaults() interface{} {
	return &struct {
		Status       string
		Host         string
		IOServerHost string
		Port         types.StringNumber
		Password     string
		VNCFile      string
	}{
		Status:       o.GetStatus(),
		Host:         o.GetHost(),
		IOServerHost: o.GetIOServerHost(),
		Port:         o.GetPort(),
		Password:     o.GetPassword(),
		VNCFile:      o.GetVNCFile(),
	}
}

// GetStatus returns value of Status
func (o *VNCProxyInfo) GetStatus() string {
	return o.Status
}

// SetStatus sets value to Status
func (o *VNCProxyInfo) SetStatus(v string) {
	o.Status = v
}

// GetHost returns value of Host
func (o *VNCProxyInfo) GetHost() string {
	return o.Host
}

// SetHost sets value to Host
func (o *VNCProxyInfo) SetHost(v string) {
	o.Host = v
}

// GetIOServerHost returns value of IOServerHost
func (o *VNCProxyInfo) GetIOServerHost() string {
	return o.IOServerHost
}

// SetIOServerHost sets value to IOServerHost
func (o *VNCProxyInfo) SetIOServerHost(v string) {
	o.IOServerHost = v
}

// GetPort returns value of Port
func (o *VNCProxyInfo) GetPort() types.StringNumber {
	return o.Port
}

// SetPort sets value to Port
func (o *VNCProxyInfo) SetPort(v types.StringNumber) {
	o.Port = v
}

// GetPassword returns value of Password
func (o *VNCProxyInfo) GetPassword() string {
	return o.Password
}

// SetPassword sets value to Password
func (o *VNCProxyInfo) SetPassword(v string) {
	o.Password = v
}

// GetVNCFile returns value of VNCFile
func (o *VNCProxyInfo) GetVNCFile() string {
	return o.VNCFile
}

// SetVNCFile sets value to VNCFile
func (o *VNCProxyInfo) SetVNCFile(v string) {
	o.VNCFile = v
}

/*************************************************
* ServerPlan
*************************************************/

// ServerPlan represents API parameter/response structure
type ServerPlan struct {
	ID           types.ID
	Name         string
	CPU          int
	MemoryMB     int
	GPU          int
	GPUModel     string
	CPUModel     string
	Commitment   types.ECommitment
	Generation   types.EPlanGeneration
	Availability types.EAvailability
}

// setDefaults implements iaas.argumentDefaulter
func (o *ServerPlan) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		CPU          int
		MemoryMB     int
		GPU          int
		GPUModel     string
		CPUModel     string
		Commitment   types.ECommitment
		Generation   types.EPlanGeneration
		Availability types.EAvailability
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		CPU:          o.GetCPU(),
		MemoryMB:     o.GetMemoryMB(),
		GPU:          o.GetGPU(),
		GPUModel:     o.GetGPUModel(),
		CPUModel:     o.GetCPUModel(),
		Commitment:   o.GetCommitment(),
		Generation:   o.GetGeneration(),
		Availability: o.GetAvailability(),
	}
}

// GetID returns value of ID
func (o *ServerPlan) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ServerPlan) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ServerPlan) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ServerPlan) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ServerPlan) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ServerPlan) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *ServerPlan) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *ServerPlan) SetName(v string) {
	o.Name = v
}

// GetCPU returns value of CPU
func (o *ServerPlan) GetCPU() int {
	return o.CPU
}

// SetCPU sets value to CPU
func (o *ServerPlan) SetCPU(v int) {
	o.CPU = v
}

// GetMemoryMB returns value of MemoryMB
func (o *ServerPlan) GetMemoryMB() int {
	return o.MemoryMB
}

// SetMemoryMB sets value to MemoryMB
func (o *ServerPlan) SetMemoryMB(v int) {
	o.MemoryMB = v
}

// GetMemoryGB .
func (o *ServerPlan) GetMemoryGB() int {
	return accessor.GetMemoryGB(o)
}

// SetMemoryGB .
func (o *ServerPlan) SetMemoryGB(memory int) {
	accessor.SetMemoryGB(o, memory)
}

// GetGPU returns value of GPU
func (o *ServerPlan) GetGPU() int {
	return o.GPU
}

// SetGPU sets value to GPU
func (o *ServerPlan) SetGPU(v int) {
	o.GPU = v
}

// GetGPUModel returns value of GPUModel
func (o *ServerPlan) GetGPUModel() string {
	return o.GPUModel
}

// SetGPUModel sets value to GPUModel
func (o *ServerPlan) SetGPUModel(v string) {
	o.GPUModel = v
}

// GetCPUModel returns value of CPUModel
func (o *ServerPlan) GetCPUModel() string {
	return o.CPUModel
}

// SetCPUModel sets value to CPUModel
func (o *ServerPlan) SetCPUModel(v string) {
	o.CPUModel = v
}

// GetCommitment returns value of Commitment
func (o *ServerPlan) GetCommitment() types.ECommitment {
	return o.Commitment
}

// SetCommitment sets value to Commitment
func (o *ServerPlan) SetCommitment(v types.ECommitment) {
	o.Commitment = v
}

// GetGeneration returns value of Generation
func (o *ServerPlan) GetGeneration() types.EPlanGeneration {
	return o.Generation
}

// SetGeneration sets value to Generation
func (o *ServerPlan) SetGeneration(v types.EPlanGeneration) {
	o.Generation = v
}

// GetAvailability returns value of Availability
func (o *ServerPlan) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *ServerPlan) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

/*************************************************
* ServiceClass
*************************************************/

// ServiceClass represents API parameter/response structure
type ServiceClass struct {
	ID               types.ID
	ServiceClassName string
	ServiceClassPath string
	DisplayName      string
	IsPublic         bool
	Price            *Price `mapconv:",recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ServiceClass) setDefaults() interface{} {
	return &struct {
		ID               types.ID
		ServiceClassName string
		ServiceClassPath string
		DisplayName      string
		IsPublic         bool
		Price            *Price `mapconv:",recursive"`
	}{
		ID:               o.GetID(),
		ServiceClassName: o.GetServiceClassName(),
		ServiceClassPath: o.GetServiceClassPath(),
		DisplayName:      o.GetDisplayName(),
		IsPublic:         o.GetIsPublic(),
		Price:            o.GetPrice(),
	}
}

// GetID returns value of ID
func (o *ServiceClass) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ServiceClass) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ServiceClass) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ServiceClass) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ServiceClass) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ServiceClass) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetServiceClassName returns value of ServiceClassName
func (o *ServiceClass) GetServiceClassName() string {
	return o.ServiceClassName
}

// SetServiceClassName sets value to ServiceClassName
func (o *ServiceClass) SetServiceClassName(v string) {
	o.ServiceClassName = v
}

// GetServiceClassPath returns value of ServiceClassPath
func (o *ServiceClass) GetServiceClassPath() string {
	return o.ServiceClassPath
}

// SetServiceClassPath sets value to ServiceClassPath
func (o *ServiceClass) SetServiceClassPath(v string) {
	o.ServiceClassPath = v
}

// GetDisplayName returns value of DisplayName
func (o *ServiceClass) GetDisplayName() string {
	return o.DisplayName
}

// SetDisplayName sets value to DisplayName
func (o *ServiceClass) SetDisplayName(v string) {
	o.DisplayName = v
}

// GetIsPublic returns value of IsPublic
func (o *ServiceClass) GetIsPublic() bool {
	return o.IsPublic
}

// SetIsPublic sets value to IsPublic
func (o *ServiceClass) SetIsPublic(v bool) {
	o.IsPublic = v
}

// GetPrice returns value of Price
func (o *ServiceClass) GetPrice() *Price {
	return o.Price
}

// SetPrice sets value to Price
func (o *ServiceClass) SetPrice(v *Price) {
	o.Price = v
}

/*************************************************
* Price
*************************************************/

// Price represents API parameter/response structure
type Price struct {
	Base          int
	Daily         int
	Hourly        int
	Monthly       int
	PerUse        int
	Basic         int
	Traffic       int
	DocomoTraffic int
	KddiTraffic   int
	SbTraffic     int
	SimSheet      int
	Zone          string
}

// setDefaults implements iaas.argumentDefaulter
func (o *Price) setDefaults() interface{} {
	return &struct {
		Base          int
		Daily         int
		Hourly        int
		Monthly       int
		PerUse        int
		Basic         int
		Traffic       int
		DocomoTraffic int
		KddiTraffic   int
		SbTraffic     int
		SimSheet      int
		Zone          string
	}{
		Base:          o.GetBase(),
		Daily:         o.GetDaily(),
		Hourly:        o.GetHourly(),
		Monthly:       o.GetMonthly(),
		PerUse:        o.GetPerUse(),
		Basic:         o.GetBasic(),
		Traffic:       o.GetTraffic(),
		DocomoTraffic: o.GetDocomoTraffic(),
		KddiTraffic:   o.GetKddiTraffic(),
		SbTraffic:     o.GetSbTraffic(),
		SimSheet:      o.GetSimSheet(),
		Zone:          o.GetZone(),
	}
}

// GetBase returns value of Base
func (o *Price) GetBase() int {
	return o.Base
}

// SetBase sets value to Base
func (o *Price) SetBase(v int) {
	o.Base = v
}

// GetDaily returns value of Daily
func (o *Price) GetDaily() int {
	return o.Daily
}

// SetDaily sets value to Daily
func (o *Price) SetDaily(v int) {
	o.Daily = v
}

// GetHourly returns value of Hourly
func (o *Price) GetHourly() int {
	return o.Hourly
}

// SetHourly sets value to Hourly
func (o *Price) SetHourly(v int) {
	o.Hourly = v
}

// GetMonthly returns value of Monthly
func (o *Price) GetMonthly() int {
	return o.Monthly
}

// SetMonthly sets value to Monthly
func (o *Price) SetMonthly(v int) {
	o.Monthly = v
}

// GetPerUse returns value of PerUse
func (o *Price) GetPerUse() int {
	return o.PerUse
}

// SetPerUse sets value to PerUse
func (o *Price) SetPerUse(v int) {
	o.PerUse = v
}

// GetBasic returns value of Basic
func (o *Price) GetBasic() int {
	return o.Basic
}

// SetBasic sets value to Basic
func (o *Price) SetBasic(v int) {
	o.Basic = v
}

// GetTraffic returns value of Traffic
func (o *Price) GetTraffic() int {
	return o.Traffic
}

// SetTraffic sets value to Traffic
func (o *Price) SetTraffic(v int) {
	o.Traffic = v
}

// GetDocomoTraffic returns value of DocomoTraffic
func (o *Price) GetDocomoTraffic() int {
	return o.DocomoTraffic
}

// SetDocomoTraffic sets value to DocomoTraffic
func (o *Price) SetDocomoTraffic(v int) {
	o.DocomoTraffic = v
}

// GetKddiTraffic returns value of KddiTraffic
func (o *Price) GetKddiTraffic() int {
	return o.KddiTraffic
}

// SetKddiTraffic sets value to KddiTraffic
func (o *Price) SetKddiTraffic(v int) {
	o.KddiTraffic = v
}

// GetSbTraffic returns value of SbTraffic
func (o *Price) GetSbTraffic() int {
	return o.SbTraffic
}

// SetSbTraffic sets value to SbTraffic
func (o *Price) SetSbTraffic(v int) {
	o.SbTraffic = v
}

// GetSimSheet returns value of SimSheet
func (o *Price) GetSimSheet() int {
	return o.SimSheet
}

// SetSimSheet sets value to SimSheet
func (o *Price) SetSimSheet(v int) {
	o.SimSheet = v
}

// GetZone returns value of Zone
func (o *Price) GetZone() string {
	return o.Zone
}

// SetZone sets value to Zone
func (o *Price) SetZone(v string) {
	o.Zone = v
}

/*************************************************
* SIM
*************************************************/

// SIM represents API parameter/response structure
type SIM struct {
	ID           types.ID
	Name         string
	Description  string
	Tags         types.Tags
	Availability types.EAvailability
	Class        string
	ICCID        string   `mapconv:"Status.ICCID"`
	Info         *SIMInfo `mapconv:"Status.SIMInfo"`
	IconID       types.ID `mapconv:"Icon.ID"`
	CreatedAt    time.Time
	ModifiedAt   time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIM) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		Tags         types.Tags
		Availability types.EAvailability
		Class        string
		ICCID        string   `mapconv:"Status.ICCID"`
		Info         *SIMInfo `mapconv:"Status.SIMInfo"`
		IconID       types.ID `mapconv:"Icon.ID"`
		CreatedAt    time.Time
		ModifiedAt   time.Time
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		Class:        o.GetClass(),
		ICCID:        o.GetICCID(),
		Info:         o.GetInfo(),
		IconID:       o.GetIconID(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
	}
}

// GetID returns value of ID
func (o *SIM) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *SIM) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *SIM) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *SIM) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *SIM) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *SIM) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *SIM) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SIM) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SIM) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SIM) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SIM) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SIM) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SIM) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SIM) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SIM) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SIM) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *SIM) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *SIM) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetClass returns value of Class
func (o *SIM) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *SIM) SetClass(v string) {
	o.Class = v
}

// GetICCID returns value of ICCID
func (o *SIM) GetICCID() string {
	return o.ICCID
}

// SetICCID sets value to ICCID
func (o *SIM) SetICCID(v string) {
	o.ICCID = v
}

// GetInfo returns value of Info
func (o *SIM) GetInfo() *SIMInfo {
	return o.Info
}

// SetInfo sets value to Info
func (o *SIM) SetInfo(v *SIMInfo) {
	o.Info = v
}

// GetIconID returns value of IconID
func (o *SIM) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SIM) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *SIM) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *SIM) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *SIM) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *SIM) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* SIMInfo
*************************************************/

// SIMInfo represents API parameter/response structure
type SIMInfo struct {
	ICCID                      string
	IMSI                       []string
	IMEI                       string
	IP                         string
	SessionStatus              string
	IMEILock                   bool
	Registered                 bool
	Activated                  bool
	ResourceID                 string
	RegisteredDate             time.Time
	ActivatedDate              time.Time
	DeactivatedDate            time.Time
	SIMGroupID                 string
	TrafficBytesOfCurrentMonth *SIMTrafficBytes `mapconv:",recursive"`
	ConnectedIMEI              string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIMInfo) setDefaults() interface{} {
	return &struct {
		ICCID                      string
		IMSI                       []string
		IMEI                       string
		IP                         string
		SessionStatus              string
		IMEILock                   bool
		Registered                 bool
		Activated                  bool
		ResourceID                 string
		RegisteredDate             time.Time
		ActivatedDate              time.Time
		DeactivatedDate            time.Time
		SIMGroupID                 string
		TrafficBytesOfCurrentMonth *SIMTrafficBytes `mapconv:",recursive"`
		ConnectedIMEI              string
	}{
		ICCID:                      o.GetICCID(),
		IMSI:                       o.GetIMSI(),
		IMEI:                       o.GetIMEI(),
		IP:                         o.GetIP(),
		SessionStatus:              o.GetSessionStatus(),
		IMEILock:                   o.GetIMEILock(),
		Registered:                 o.GetRegistered(),
		Activated:                  o.GetActivated(),
		ResourceID:                 o.GetResourceID(),
		RegisteredDate:             o.GetRegisteredDate(),
		ActivatedDate:              o.GetActivatedDate(),
		DeactivatedDate:            o.GetDeactivatedDate(),
		SIMGroupID:                 o.GetSIMGroupID(),
		TrafficBytesOfCurrentMonth: o.GetTrafficBytesOfCurrentMonth(),
		ConnectedIMEI:              o.GetConnectedIMEI(),
	}
}

// GetICCID returns value of ICCID
func (o *SIMInfo) GetICCID() string {
	return o.ICCID
}

// SetICCID sets value to ICCID
func (o *SIMInfo) SetICCID(v string) {
	o.ICCID = v
}

// GetIMSI returns value of IMSI
func (o *SIMInfo) GetIMSI() []string {
	return o.IMSI
}

// SetIMSI sets value to IMSI
func (o *SIMInfo) SetIMSI(v []string) {
	o.IMSI = v
}

// GetIMEI returns value of IMEI
func (o *SIMInfo) GetIMEI() string {
	return o.IMEI
}

// SetIMEI sets value to IMEI
func (o *SIMInfo) SetIMEI(v string) {
	o.IMEI = v
}

// GetIP returns value of IP
func (o *SIMInfo) GetIP() string {
	return o.IP
}

// SetIP sets value to IP
func (o *SIMInfo) SetIP(v string) {
	o.IP = v
}

// GetSessionStatus returns value of SessionStatus
func (o *SIMInfo) GetSessionStatus() string {
	return o.SessionStatus
}

// SetSessionStatus sets value to SessionStatus
func (o *SIMInfo) SetSessionStatus(v string) {
	o.SessionStatus = v
}

// GetIMEILock returns value of IMEILock
func (o *SIMInfo) GetIMEILock() bool {
	return o.IMEILock
}

// SetIMEILock sets value to IMEILock
func (o *SIMInfo) SetIMEILock(v bool) {
	o.IMEILock = v
}

// GetRegistered returns value of Registered
func (o *SIMInfo) GetRegistered() bool {
	return o.Registered
}

// SetRegistered sets value to Registered
func (o *SIMInfo) SetRegistered(v bool) {
	o.Registered = v
}

// GetActivated returns value of Activated
func (o *SIMInfo) GetActivated() bool {
	return o.Activated
}

// SetActivated sets value to Activated
func (o *SIMInfo) SetActivated(v bool) {
	o.Activated = v
}

// GetResourceID returns value of ResourceID
func (o *SIMInfo) GetResourceID() string {
	return o.ResourceID
}

// SetResourceID sets value to ResourceID
func (o *SIMInfo) SetResourceID(v string) {
	o.ResourceID = v
}

// GetRegisteredDate returns value of RegisteredDate
func (o *SIMInfo) GetRegisteredDate() time.Time {
	return o.RegisteredDate
}

// SetRegisteredDate sets value to RegisteredDate
func (o *SIMInfo) SetRegisteredDate(v time.Time) {
	o.RegisteredDate = v
}

// GetActivatedDate returns value of ActivatedDate
func (o *SIMInfo) GetActivatedDate() time.Time {
	return o.ActivatedDate
}

// SetActivatedDate sets value to ActivatedDate
func (o *SIMInfo) SetActivatedDate(v time.Time) {
	o.ActivatedDate = v
}

// GetDeactivatedDate returns value of DeactivatedDate
func (o *SIMInfo) GetDeactivatedDate() time.Time {
	return o.DeactivatedDate
}

// SetDeactivatedDate sets value to DeactivatedDate
func (o *SIMInfo) SetDeactivatedDate(v time.Time) {
	o.DeactivatedDate = v
}

// GetSIMGroupID returns value of SIMGroupID
func (o *SIMInfo) GetSIMGroupID() string {
	return o.SIMGroupID
}

// SetSIMGroupID sets value to SIMGroupID
func (o *SIMInfo) SetSIMGroupID(v string) {
	o.SIMGroupID = v
}

// GetTrafficBytesOfCurrentMonth returns value of TrafficBytesOfCurrentMonth
func (o *SIMInfo) GetTrafficBytesOfCurrentMonth() *SIMTrafficBytes {
	return o.TrafficBytesOfCurrentMonth
}

// SetTrafficBytesOfCurrentMonth sets value to TrafficBytesOfCurrentMonth
func (o *SIMInfo) SetTrafficBytesOfCurrentMonth(v *SIMTrafficBytes) {
	o.TrafficBytesOfCurrentMonth = v
}

// GetConnectedIMEI returns value of ConnectedIMEI
func (o *SIMInfo) GetConnectedIMEI() string {
	return o.ConnectedIMEI
}

// SetConnectedIMEI sets value to ConnectedIMEI
func (o *SIMInfo) SetConnectedIMEI(v string) {
	o.ConnectedIMEI = v
}

/*************************************************
* SIMCreateRequest
*************************************************/

// SIMCreateRequest represents API parameter/response structure
type SIMCreateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
	ICCID       string   `mapconv:"Status.ICCID"`
	PassCode    string   `mapconv:"Remark.PassCode"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIMCreateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
		ICCID       string   `mapconv:"Status.ICCID"`
		PassCode    string   `mapconv:"Remark.PassCode"`
		Class       string   `mapconv:"Provider.Class"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
		ICCID:       o.GetICCID(),
		PassCode:    o.GetPassCode(),
		Class:       "sim",
	}
}

// GetName returns value of Name
func (o *SIMCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SIMCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SIMCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SIMCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SIMCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SIMCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SIMCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SIMCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SIMCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SIMCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SIMCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SIMCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetICCID returns value of ICCID
func (o *SIMCreateRequest) GetICCID() string {
	return o.ICCID
}

// SetICCID sets value to ICCID
func (o *SIMCreateRequest) SetICCID(v string) {
	o.ICCID = v
}

// GetPassCode returns value of PassCode
func (o *SIMCreateRequest) GetPassCode() string {
	return o.PassCode
}

// SetPassCode sets value to PassCode
func (o *SIMCreateRequest) SetPassCode(v string) {
	o.PassCode = v
}

/*************************************************
* SIMUpdateRequest
*************************************************/

// SIMUpdateRequest represents API parameter/response structure
type SIMUpdateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIMUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID `mapconv:"Icon.ID"`
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *SIMUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SIMUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SIMUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SIMUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SIMUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SIMUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SIMUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SIMUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SIMUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SIMUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SIMUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SIMUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* SIMAssignIPRequest
*************************************************/

// SIMAssignIPRequest represents API parameter/response structure
type SIMAssignIPRequest struct {
	IP string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIMAssignIPRequest) setDefaults() interface{} {
	return &struct {
		IP string
	}{
		IP: o.GetIP(),
	}
}

// GetIP returns value of IP
func (o *SIMAssignIPRequest) GetIP() string {
	return o.IP
}

// SetIP sets value to IP
func (o *SIMAssignIPRequest) SetIP(v string) {
	o.IP = v
}

/*************************************************
* SIMIMEILockRequest
*************************************************/

// SIMIMEILockRequest represents API parameter/response structure
type SIMIMEILockRequest struct {
	IMEI string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIMIMEILockRequest) setDefaults() interface{} {
	return &struct {
		IMEI string
	}{
		IMEI: o.GetIMEI(),
	}
}

// GetIMEI returns value of IMEI
func (o *SIMIMEILockRequest) GetIMEI() string {
	return o.IMEI
}

// SetIMEI sets value to IMEI
func (o *SIMIMEILockRequest) SetIMEI(v string) {
	o.IMEI = v
}

/*************************************************
* SIMLog
*************************************************/

// SIMLog represents API parameter/response structure
type SIMLog struct {
	Date          time.Time
	SessionStatus string
	ResourceID    string
	IMEI          string
	IMSI          string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIMLog) setDefaults() interface{} {
	return &struct {
		Date          time.Time
		SessionStatus string
		ResourceID    string
		IMEI          string
		IMSI          string
	}{
		Date:          o.GetDate(),
		SessionStatus: o.GetSessionStatus(),
		ResourceID:    o.GetResourceID(),
		IMEI:          o.GetIMEI(),
		IMSI:          o.GetIMSI(),
	}
}

// GetDate returns value of Date
func (o *SIMLog) GetDate() time.Time {
	return o.Date
}

// SetDate sets value to Date
func (o *SIMLog) SetDate(v time.Time) {
	o.Date = v
}

// GetSessionStatus returns value of SessionStatus
func (o *SIMLog) GetSessionStatus() string {
	return o.SessionStatus
}

// SetSessionStatus sets value to SessionStatus
func (o *SIMLog) SetSessionStatus(v string) {
	o.SessionStatus = v
}

// GetResourceID returns value of ResourceID
func (o *SIMLog) GetResourceID() string {
	return o.ResourceID
}

// SetResourceID sets value to ResourceID
func (o *SIMLog) SetResourceID(v string) {
	o.ResourceID = v
}

// GetIMEI returns value of IMEI
func (o *SIMLog) GetIMEI() string {
	return o.IMEI
}

// SetIMEI sets value to IMEI
func (o *SIMLog) SetIMEI(v string) {
	o.IMEI = v
}

// GetIMSI returns value of IMSI
func (o *SIMLog) GetIMSI() string {
	return o.IMSI
}

// SetIMSI sets value to IMSI
func (o *SIMLog) SetIMSI(v string) {
	o.IMSI = v
}

/*************************************************
* SIMNetworkOperatorConfig
*************************************************/

// SIMNetworkOperatorConfig represents API parameter/response structure
type SIMNetworkOperatorConfig struct {
	Allow       bool
	CountryCode string
	Name        string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SIMNetworkOperatorConfig) setDefaults() interface{} {
	return &struct {
		Allow       bool
		CountryCode string
		Name        string
	}{
		Allow:       o.GetAllow(),
		CountryCode: o.GetCountryCode(),
		Name:        o.GetName(),
	}
}

// GetAllow returns value of Allow
func (o *SIMNetworkOperatorConfig) GetAllow() bool {
	return o.Allow
}

// SetAllow sets value to Allow
func (o *SIMNetworkOperatorConfig) SetAllow(v bool) {
	o.Allow = v
}

// GetCountryCode returns value of CountryCode
func (o *SIMNetworkOperatorConfig) GetCountryCode() string {
	return o.CountryCode
}

// SetCountryCode sets value to CountryCode
func (o *SIMNetworkOperatorConfig) SetCountryCode(v string) {
	o.CountryCode = v
}

// GetName returns value of Name
func (o *SIMNetworkOperatorConfig) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SIMNetworkOperatorConfig) SetName(v string) {
	o.Name = v
}

/*************************************************
* LinkActivity
*************************************************/

// LinkActivity represents API parameter/response structure
type LinkActivity struct {
	Values []*MonitorLinkValue `mapconv:"[]Link"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *LinkActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorLinkValue `mapconv:"[]Link"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *LinkActivity) GetValues() []*MonitorLinkValue {
	return o.Values
}

// SetValues sets value to Values
func (o *LinkActivity) SetValues(v []*MonitorLinkValue) {
	o.Values = v
}

/*************************************************
* MonitorLinkValue
*************************************************/

// MonitorLinkValue represents API parameter/response structure
type MonitorLinkValue struct {
	Time        time.Time `mapconv:",omitempty"`
	UplinkBPS   float64   `mapconv:",omitempty"`
	DownlinkBPS float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorLinkValue) setDefaults() interface{} {
	return &struct {
		Time        time.Time `mapconv:",omitempty"`
		UplinkBPS   float64   `mapconv:",omitempty"`
		DownlinkBPS float64   `mapconv:",omitempty"`
	}{
		Time:        o.GetTime(),
		UplinkBPS:   o.GetUplinkBPS(),
		DownlinkBPS: o.GetDownlinkBPS(),
	}
}

// GetTime returns value of Time
func (o *MonitorLinkValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorLinkValue) SetTime(v time.Time) {
	o.Time = v
}

// GetUplinkBPS returns value of UplinkBPS
func (o *MonitorLinkValue) GetUplinkBPS() float64 {
	return o.UplinkBPS
}

// SetUplinkBPS sets value to UplinkBPS
func (o *MonitorLinkValue) SetUplinkBPS(v float64) {
	o.UplinkBPS = v
}

// GetDownlinkBPS returns value of DownlinkBPS
func (o *MonitorLinkValue) GetDownlinkBPS() float64 {
	return o.DownlinkBPS
}

// SetDownlinkBPS sets value to DownlinkBPS
func (o *MonitorLinkValue) SetDownlinkBPS(v float64) {
	o.DownlinkBPS = v
}

/*************************************************
* SimpleMonitor
*************************************************/

// SimpleMonitor represents API parameter/response structure
type SimpleMonitor struct {
	ID                 types.ID
	Name               string
	Description        string
	Tags               types.Tags
	Availability       types.EAvailability
	IconID             types.ID `mapconv:"Icon.ID"`
	CreatedAt          time.Time
	ModifiedAt         time.Time
	Class              string
	Target             string                    `mapconv:"Status.Target"`
	DelayLoop          int                       `mapconv:"Settings.SimpleMonitor.DelayLoop"`
	MaxCheckAttempts   int                       `mapconv:"Settings.SimpleMonitor.MaxCheckAttempts"`
	RetryInterval      int                       `mapconv:"Settings.SimpleMonitor.RetryInterval"`
	Enabled            types.StringFlag          `mapconv:"Settings.SimpleMonitor.Enabled"`
	HealthCheck        *SimpleMonitorHealthCheck `mapconv:"Settings.SimpleMonitor.HealthCheck,recursive"`
	NotifyEmailEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.Enabled"`
	NotifyEmailHTML    types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.HTML"`
	NotifySlackEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifySlack.Enabled"`
	SlackWebhooksURL   string                    `mapconv:"Settings.SimpleMonitor.NotifySlack.IncomingWebhooksURL"`
	NotifyInterval     int                       `mapconv:"Settings.SimpleMonitor.NotifyInterval"`
	Timeout            int                       `mapconv:"Settings.SimpleMonitor.Timeout"`
	MonitoringSuiteLog *MonitoringSuiteLog       `mapconv:"Settings.SimpleMonitor.MonitoringSuiteLog,recursive"`
	SettingsHash       string                    `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleMonitor) setDefaults() interface{} {
	return &struct {
		ID                 types.ID
		Name               string
		Description        string
		Tags               types.Tags
		Availability       types.EAvailability
		IconID             types.ID `mapconv:"Icon.ID"`
		CreatedAt          time.Time
		ModifiedAt         time.Time
		Class              string
		Target             string                    `mapconv:"Status.Target"`
		DelayLoop          int                       `mapconv:"Settings.SimpleMonitor.DelayLoop"`
		MaxCheckAttempts   int                       `mapconv:"Settings.SimpleMonitor.MaxCheckAttempts"`
		RetryInterval      int                       `mapconv:"Settings.SimpleMonitor.RetryInterval"`
		Enabled            types.StringFlag          `mapconv:"Settings.SimpleMonitor.Enabled"`
		HealthCheck        *SimpleMonitorHealthCheck `mapconv:"Settings.SimpleMonitor.HealthCheck,recursive"`
		NotifyEmailEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.Enabled"`
		NotifyEmailHTML    types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.HTML"`
		NotifySlackEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifySlack.Enabled"`
		SlackWebhooksURL   string                    `mapconv:"Settings.SimpleMonitor.NotifySlack.IncomingWebhooksURL"`
		NotifyInterval     int                       `mapconv:"Settings.SimpleMonitor.NotifyInterval"`
		Timeout            int                       `mapconv:"Settings.SimpleMonitor.Timeout"`
		MonitoringSuiteLog *MonitoringSuiteLog       `mapconv:"Settings.SimpleMonitor.MonitoringSuiteLog,recursive"`
		SettingsHash       string                    `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:                 o.GetID(),
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		Availability:       o.GetAvailability(),
		IconID:             o.GetIconID(),
		CreatedAt:          o.GetCreatedAt(),
		ModifiedAt:         o.GetModifiedAt(),
		Class:              o.GetClass(),
		Target:             o.GetTarget(),
		DelayLoop:          o.GetDelayLoop(),
		MaxCheckAttempts:   o.GetMaxCheckAttempts(),
		RetryInterval:      o.GetRetryInterval(),
		Enabled:            o.GetEnabled(),
		HealthCheck:        o.GetHealthCheck(),
		NotifyEmailEnabled: o.GetNotifyEmailEnabled(),
		NotifyEmailHTML:    o.GetNotifyEmailHTML(),
		NotifySlackEnabled: o.GetNotifySlackEnabled(),
		SlackWebhooksURL:   o.GetSlackWebhooksURL(),
		NotifyInterval:     o.GetNotifyInterval(),
		Timeout:            o.GetTimeout(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetID returns value of ID
func (o *SimpleMonitor) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *SimpleMonitor) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *SimpleMonitor) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *SimpleMonitor) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *SimpleMonitor) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *SimpleMonitor) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *SimpleMonitor) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SimpleMonitor) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SimpleMonitor) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleMonitor) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleMonitor) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleMonitor) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleMonitor) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleMonitor) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleMonitor) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleMonitor) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *SimpleMonitor) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *SimpleMonitor) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *SimpleMonitor) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleMonitor) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *SimpleMonitor) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *SimpleMonitor) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *SimpleMonitor) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *SimpleMonitor) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetClass returns value of Class
func (o *SimpleMonitor) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *SimpleMonitor) SetClass(v string) {
	o.Class = v
}

// GetTarget returns value of Target
func (o *SimpleMonitor) GetTarget() string {
	return o.Target
}

// SetTarget sets value to Target
func (o *SimpleMonitor) SetTarget(v string) {
	o.Target = v
}

// GetDelayLoop returns value of DelayLoop
func (o *SimpleMonitor) GetDelayLoop() int {
	if o.DelayLoop == 0 {
		return 60
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *SimpleMonitor) SetDelayLoop(v int) {
	o.DelayLoop = v
}

// GetMaxCheckAttempts returns value of MaxCheckAttempts
func (o *SimpleMonitor) GetMaxCheckAttempts() int {
	if o.MaxCheckAttempts == 0 {
		return 3
	}
	return o.MaxCheckAttempts
}

// SetMaxCheckAttempts sets value to MaxCheckAttempts
func (o *SimpleMonitor) SetMaxCheckAttempts(v int) {
	o.MaxCheckAttempts = v
}

// GetRetryInterval returns value of RetryInterval
func (o *SimpleMonitor) GetRetryInterval() int {
	if o.RetryInterval == 0 {
		return 10
	}
	return o.RetryInterval
}

// SetRetryInterval sets value to RetryInterval
func (o *SimpleMonitor) SetRetryInterval(v int) {
	o.RetryInterval = v
}

// GetEnabled returns value of Enabled
func (o *SimpleMonitor) GetEnabled() types.StringFlag {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *SimpleMonitor) SetEnabled(v types.StringFlag) {
	o.Enabled = v
}

// GetHealthCheck returns value of HealthCheck
func (o *SimpleMonitor) GetHealthCheck() *SimpleMonitorHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *SimpleMonitor) SetHealthCheck(v *SimpleMonitorHealthCheck) {
	o.HealthCheck = v
}

// GetNotifyEmailEnabled returns value of NotifyEmailEnabled
func (o *SimpleMonitor) GetNotifyEmailEnabled() types.StringFlag {
	return o.NotifyEmailEnabled
}

// SetNotifyEmailEnabled sets value to NotifyEmailEnabled
func (o *SimpleMonitor) SetNotifyEmailEnabled(v types.StringFlag) {
	o.NotifyEmailEnabled = v
}

// GetNotifyEmailHTML returns value of NotifyEmailHTML
func (o *SimpleMonitor) GetNotifyEmailHTML() types.StringFlag {
	return o.NotifyEmailHTML
}

// SetNotifyEmailHTML sets value to NotifyEmailHTML
func (o *SimpleMonitor) SetNotifyEmailHTML(v types.StringFlag) {
	o.NotifyEmailHTML = v
}

// GetNotifySlackEnabled returns value of NotifySlackEnabled
func (o *SimpleMonitor) GetNotifySlackEnabled() types.StringFlag {
	return o.NotifySlackEnabled
}

// SetNotifySlackEnabled sets value to NotifySlackEnabled
func (o *SimpleMonitor) SetNotifySlackEnabled(v types.StringFlag) {
	o.NotifySlackEnabled = v
}

// GetSlackWebhooksURL returns value of SlackWebhooksURL
func (o *SimpleMonitor) GetSlackWebhooksURL() string {
	return o.SlackWebhooksURL
}

// SetSlackWebhooksURL sets value to SlackWebhooksURL
func (o *SimpleMonitor) SetSlackWebhooksURL(v string) {
	o.SlackWebhooksURL = v
}

// GetNotifyInterval returns value of NotifyInterval
func (o *SimpleMonitor) GetNotifyInterval() int {
	if o.NotifyInterval == 0 {
		return 7200
	}
	return o.NotifyInterval
}

// SetNotifyInterval sets value to NotifyInterval
func (o *SimpleMonitor) SetNotifyInterval(v int) {
	o.NotifyInterval = v
}

// GetTimeout returns value of Timeout
func (o *SimpleMonitor) GetTimeout() int {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *SimpleMonitor) SetTimeout(v int) {
	o.Timeout = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *SimpleMonitor) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *SimpleMonitor) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleMonitor) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleMonitor) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* SimpleMonitorHealthCheck
*************************************************/

// SimpleMonitorHealthCheck represents API parameter/response structure
type SimpleMonitorHealthCheck struct {
	Protocol          types.ESimpleMonitorProtocol
	Port              types.StringNumber
	Path              string
	Status            types.StringNumber
	SNI               types.StringFlag
	Host              string
	BasicAuthUsername string
	BasicAuthPassword string
	ContainsString    string
	QName             string
	ExpectedData      string
	Community         string
	SNMPVersion       string
	OID               string
	RemainingDays     int
	HTTP2             types.StringFlag
	FTPS              types.ESimpleMonitorFTPS
	VerifySNI         types.StringFlag
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleMonitorHealthCheck) setDefaults() interface{} {
	return &struct {
		Protocol          types.ESimpleMonitorProtocol
		Port              types.StringNumber
		Path              string
		Status            types.StringNumber
		SNI               types.StringFlag
		Host              string
		BasicAuthUsername string
		BasicAuthPassword string
		ContainsString    string
		QName             string
		ExpectedData      string
		Community         string
		SNMPVersion       string
		OID               string
		RemainingDays     int
		HTTP2             types.StringFlag
		FTPS              types.ESimpleMonitorFTPS
		VerifySNI         types.StringFlag
	}{
		Protocol:          o.GetProtocol(),
		Port:              o.GetPort(),
		Path:              o.GetPath(),
		Status:            o.GetStatus(),
		SNI:               o.GetSNI(),
		Host:              o.GetHost(),
		BasicAuthUsername: o.GetBasicAuthUsername(),
		BasicAuthPassword: o.GetBasicAuthPassword(),
		ContainsString:    o.GetContainsString(),
		QName:             o.GetQName(),
		ExpectedData:      o.GetExpectedData(),
		Community:         o.GetCommunity(),
		SNMPVersion:       o.GetSNMPVersion(),
		OID:               o.GetOID(),
		RemainingDays:     o.GetRemainingDays(),
		HTTP2:             o.GetHTTP2(),
		FTPS:              o.GetFTPS(),
		VerifySNI:         o.GetVerifySNI(),
	}
}

// GetProtocol returns value of Protocol
func (o *SimpleMonitorHealthCheck) GetProtocol() types.ESimpleMonitorProtocol {
	return o.Protocol
}

// SetProtocol sets value to Protocol
func (o *SimpleMonitorHealthCheck) SetProtocol(v types.ESimpleMonitorProtocol) {
	o.Protocol = v
}

// GetPort returns value of Port
func (o *SimpleMonitorHealthCheck) GetPort() types.StringNumber {
	return o.Port
}

// SetPort sets value to Port
func (o *SimpleMonitorHealthCheck) SetPort(v types.StringNumber) {
	o.Port = v
}

// GetPath returns value of Path
func (o *SimpleMonitorHealthCheck) GetPath() string {
	return o.Path
}

// SetPath sets value to Path
func (o *SimpleMonitorHealthCheck) SetPath(v string) {
	o.Path = v
}

// GetStatus returns value of Status
func (o *SimpleMonitorHealthCheck) GetStatus() types.StringNumber {
	return o.Status
}

// SetStatus sets value to Status
func (o *SimpleMonitorHealthCheck) SetStatus(v types.StringNumber) {
	o.Status = v
}

// GetSNI returns value of SNI
func (o *SimpleMonitorHealthCheck) GetSNI() types.StringFlag {
	return o.SNI
}

// SetSNI sets value to SNI
func (o *SimpleMonitorHealthCheck) SetSNI(v types.StringFlag) {
	o.SNI = v
}

// GetHost returns value of Host
func (o *SimpleMonitorHealthCheck) GetHost() string {
	return o.Host
}

// SetHost sets value to Host
func (o *SimpleMonitorHealthCheck) SetHost(v string) {
	o.Host = v
}

// GetBasicAuthUsername returns value of BasicAuthUsername
func (o *SimpleMonitorHealthCheck) GetBasicAuthUsername() string {
	return o.BasicAuthUsername
}

// SetBasicAuthUsername sets value to BasicAuthUsername
func (o *SimpleMonitorHealthCheck) SetBasicAuthUsername(v string) {
	o.BasicAuthUsername = v
}

// GetBasicAuthPassword returns value of BasicAuthPassword
func (o *SimpleMonitorHealthCheck) GetBasicAuthPassword() string {
	return o.BasicAuthPassword
}

// SetBasicAuthPassword sets value to BasicAuthPassword
func (o *SimpleMonitorHealthCheck) SetBasicAuthPassword(v string) {
	o.BasicAuthPassword = v
}

// GetContainsString returns value of ContainsString
func (o *SimpleMonitorHealthCheck) GetContainsString() string {
	return o.ContainsString
}

// SetContainsString sets value to ContainsString
func (o *SimpleMonitorHealthCheck) SetContainsString(v string) {
	o.ContainsString = v
}

// GetQName returns value of QName
func (o *SimpleMonitorHealthCheck) GetQName() string {
	return o.QName
}

// SetQName sets value to QName
func (o *SimpleMonitorHealthCheck) SetQName(v string) {
	o.QName = v
}

// GetExpectedData returns value of ExpectedData
func (o *SimpleMonitorHealthCheck) GetExpectedData() string {
	return o.ExpectedData
}

// SetExpectedData sets value to ExpectedData
func (o *SimpleMonitorHealthCheck) SetExpectedData(v string) {
	o.ExpectedData = v
}

// GetCommunity returns value of Community
func (o *SimpleMonitorHealthCheck) GetCommunity() string {
	return o.Community
}

// SetCommunity sets value to Community
func (o *SimpleMonitorHealthCheck) SetCommunity(v string) {
	o.Community = v
}

// GetSNMPVersion returns value of SNMPVersion
func (o *SimpleMonitorHealthCheck) GetSNMPVersion() string {
	return o.SNMPVersion
}

// SetSNMPVersion sets value to SNMPVersion
func (o *SimpleMonitorHealthCheck) SetSNMPVersion(v string) {
	o.SNMPVersion = v
}

// GetOID returns value of OID
func (o *SimpleMonitorHealthCheck) GetOID() string {
	return o.OID
}

// SetOID sets value to OID
func (o *SimpleMonitorHealthCheck) SetOID(v string) {
	o.OID = v
}

// GetRemainingDays returns value of RemainingDays
func (o *SimpleMonitorHealthCheck) GetRemainingDays() int {
	return o.RemainingDays
}

// SetRemainingDays sets value to RemainingDays
func (o *SimpleMonitorHealthCheck) SetRemainingDays(v int) {
	o.RemainingDays = v
}

// GetHTTP2 returns value of HTTP2
func (o *SimpleMonitorHealthCheck) GetHTTP2() types.StringFlag {
	return o.HTTP2
}

// SetHTTP2 sets value to HTTP2
func (o *SimpleMonitorHealthCheck) SetHTTP2(v types.StringFlag) {
	o.HTTP2 = v
}

// GetFTPS returns value of FTPS
func (o *SimpleMonitorHealthCheck) GetFTPS() types.ESimpleMonitorFTPS {
	return o.FTPS
}

// SetFTPS sets value to FTPS
func (o *SimpleMonitorHealthCheck) SetFTPS(v types.ESimpleMonitorFTPS) {
	o.FTPS = v
}

// GetVerifySNI returns value of VerifySNI
func (o *SimpleMonitorHealthCheck) GetVerifySNI() types.StringFlag {
	return o.VerifySNI
}

// SetVerifySNI sets value to VerifySNI
func (o *SimpleMonitorHealthCheck) SetVerifySNI(v types.StringFlag) {
	o.VerifySNI = v
}

/*************************************************
* SimpleMonitorCreateRequest
*************************************************/

// SimpleMonitorCreateRequest represents API parameter/response structure
type SimpleMonitorCreateRequest struct {
	Target             string                    `mapconv:"Name/Status.Target"`
	MaxCheckAttempts   int                       `mapconv:"Settings.SimpleMonitor.MaxCheckAttempts"`
	RetryInterval      int                       `mapconv:"Settings.SimpleMonitor.RetryInterval"`
	DelayLoop          int                       `mapconv:"Settings.SimpleMonitor.DelayLoop"`
	Enabled            types.StringFlag          `mapconv:"Settings.SimpleMonitor.Enabled"`
	HealthCheck        *SimpleMonitorHealthCheck `mapconv:"Settings.SimpleMonitor.HealthCheck,recursive"`
	NotifyEmailEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.Enabled"`
	NotifyEmailHTML    types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.HTML"`
	NotifySlackEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifySlack.Enabled"`
	SlackWebhooksURL   string                    `mapconv:"Settings.SimpleMonitor.NotifySlack.IncomingWebhooksURL"`
	NotifyInterval     int                       `mapconv:"Settings.SimpleMonitor.NotifyInterval"`
	Timeout            int                       `mapconv:"Settings.SimpleMonitor.Timeout"`
	MonitoringSuiteLog *MonitoringSuiteLog       `mapconv:"Settings.SimpleMonitor.MonitoringSuiteLog,recursive"`
	Description        string
	Tags               types.Tags
	IconID             types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleMonitorCreateRequest) setDefaults() interface{} {
	return &struct {
		Target             string                    `mapconv:"Name/Status.Target"`
		MaxCheckAttempts   int                       `mapconv:"Settings.SimpleMonitor.MaxCheckAttempts"`
		RetryInterval      int                       `mapconv:"Settings.SimpleMonitor.RetryInterval"`
		DelayLoop          int                       `mapconv:"Settings.SimpleMonitor.DelayLoop"`
		Enabled            types.StringFlag          `mapconv:"Settings.SimpleMonitor.Enabled"`
		HealthCheck        *SimpleMonitorHealthCheck `mapconv:"Settings.SimpleMonitor.HealthCheck,recursive"`
		NotifyEmailEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.Enabled"`
		NotifyEmailHTML    types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.HTML"`
		NotifySlackEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifySlack.Enabled"`
		SlackWebhooksURL   string                    `mapconv:"Settings.SimpleMonitor.NotifySlack.IncomingWebhooksURL"`
		NotifyInterval     int                       `mapconv:"Settings.SimpleMonitor.NotifyInterval"`
		Timeout            int                       `mapconv:"Settings.SimpleMonitor.Timeout"`
		MonitoringSuiteLog *MonitoringSuiteLog       `mapconv:"Settings.SimpleMonitor.MonitoringSuiteLog,recursive"`
		Description        string
		Tags               types.Tags
		IconID             types.ID `mapconv:"Icon.ID"`
		Class              string   `mapconv:"Provider.Class"`
	}{
		Target:             o.GetTarget(),
		MaxCheckAttempts:   o.GetMaxCheckAttempts(),
		RetryInterval:      o.GetRetryInterval(),
		DelayLoop:          o.GetDelayLoop(),
		Enabled:            o.GetEnabled(),
		HealthCheck:        o.GetHealthCheck(),
		NotifyEmailEnabled: o.GetNotifyEmailEnabled(),
		NotifyEmailHTML:    o.GetNotifyEmailHTML(),
		NotifySlackEnabled: o.GetNotifySlackEnabled(),
		SlackWebhooksURL:   o.GetSlackWebhooksURL(),
		NotifyInterval:     o.GetNotifyInterval(),
		Timeout:            o.GetTimeout(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		Class:              "simplemon",
	}
}

// GetTarget returns value of Target
func (o *SimpleMonitorCreateRequest) GetTarget() string {
	return o.Target
}

// SetTarget sets value to Target
func (o *SimpleMonitorCreateRequest) SetTarget(v string) {
	o.Target = v
}

// GetMaxCheckAttempts returns value of MaxCheckAttempts
func (o *SimpleMonitorCreateRequest) GetMaxCheckAttempts() int {
	if o.MaxCheckAttempts == 0 {
		return 3
	}
	return o.MaxCheckAttempts
}

// SetMaxCheckAttempts sets value to MaxCheckAttempts
func (o *SimpleMonitorCreateRequest) SetMaxCheckAttempts(v int) {
	o.MaxCheckAttempts = v
}

// GetRetryInterval returns value of RetryInterval
func (o *SimpleMonitorCreateRequest) GetRetryInterval() int {
	if o.RetryInterval == 0 {
		return 10
	}
	return o.RetryInterval
}

// SetRetryInterval sets value to RetryInterval
func (o *SimpleMonitorCreateRequest) SetRetryInterval(v int) {
	o.RetryInterval = v
}

// GetDelayLoop returns value of DelayLoop
func (o *SimpleMonitorCreateRequest) GetDelayLoop() int {
	if o.DelayLoop == 0 {
		return 60
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *SimpleMonitorCreateRequest) SetDelayLoop(v int) {
	o.DelayLoop = v
}

// GetEnabled returns value of Enabled
func (o *SimpleMonitorCreateRequest) GetEnabled() types.StringFlag {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *SimpleMonitorCreateRequest) SetEnabled(v types.StringFlag) {
	o.Enabled = v
}

// GetHealthCheck returns value of HealthCheck
func (o *SimpleMonitorCreateRequest) GetHealthCheck() *SimpleMonitorHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *SimpleMonitorCreateRequest) SetHealthCheck(v *SimpleMonitorHealthCheck) {
	o.HealthCheck = v
}

// GetNotifyEmailEnabled returns value of NotifyEmailEnabled
func (o *SimpleMonitorCreateRequest) GetNotifyEmailEnabled() types.StringFlag {
	return o.NotifyEmailEnabled
}

// SetNotifyEmailEnabled sets value to NotifyEmailEnabled
func (o *SimpleMonitorCreateRequest) SetNotifyEmailEnabled(v types.StringFlag) {
	o.NotifyEmailEnabled = v
}

// GetNotifyEmailHTML returns value of NotifyEmailHTML
func (o *SimpleMonitorCreateRequest) GetNotifyEmailHTML() types.StringFlag {
	return o.NotifyEmailHTML
}

// SetNotifyEmailHTML sets value to NotifyEmailHTML
func (o *SimpleMonitorCreateRequest) SetNotifyEmailHTML(v types.StringFlag) {
	o.NotifyEmailHTML = v
}

// GetNotifySlackEnabled returns value of NotifySlackEnabled
func (o *SimpleMonitorCreateRequest) GetNotifySlackEnabled() types.StringFlag {
	return o.NotifySlackEnabled
}

// SetNotifySlackEnabled sets value to NotifySlackEnabled
func (o *SimpleMonitorCreateRequest) SetNotifySlackEnabled(v types.StringFlag) {
	o.NotifySlackEnabled = v
}

// GetSlackWebhooksURL returns value of SlackWebhooksURL
func (o *SimpleMonitorCreateRequest) GetSlackWebhooksURL() string {
	return o.SlackWebhooksURL
}

// SetSlackWebhooksURL sets value to SlackWebhooksURL
func (o *SimpleMonitorCreateRequest) SetSlackWebhooksURL(v string) {
	o.SlackWebhooksURL = v
}

// GetNotifyInterval returns value of NotifyInterval
func (o *SimpleMonitorCreateRequest) GetNotifyInterval() int {
	if o.NotifyInterval == 0 {
		return 7200
	}
	return o.NotifyInterval
}

// SetNotifyInterval sets value to NotifyInterval
func (o *SimpleMonitorCreateRequest) SetNotifyInterval(v int) {
	o.NotifyInterval = v
}

// GetTimeout returns value of Timeout
func (o *SimpleMonitorCreateRequest) GetTimeout() int {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *SimpleMonitorCreateRequest) SetTimeout(v int) {
	o.Timeout = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *SimpleMonitorCreateRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *SimpleMonitorCreateRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetDescription returns value of Description
func (o *SimpleMonitorCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleMonitorCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleMonitorCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleMonitorCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleMonitorCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleMonitorCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleMonitorCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleMonitorCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SimpleMonitorCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleMonitorCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* SimpleMonitorUpdateRequest
*************************************************/

// SimpleMonitorUpdateRequest represents API parameter/response structure
type SimpleMonitorUpdateRequest struct {
	Description        string
	Tags               types.Tags
	IconID             types.ID                  `mapconv:"Icon.ID"`
	MaxCheckAttempts   int                       `mapconv:"Settings.SimpleMonitor.MaxCheckAttempts"`
	RetryInterval      int                       `mapconv:"Settings.SimpleMonitor.RetryInterval"`
	DelayLoop          int                       `mapconv:"Settings.SimpleMonitor.DelayLoop"`
	Enabled            types.StringFlag          `mapconv:"Settings.SimpleMonitor.Enabled"`
	HealthCheck        *SimpleMonitorHealthCheck `mapconv:"Settings.SimpleMonitor.HealthCheck,recursive"`
	NotifyEmailEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.Enabled"`
	NotifyEmailHTML    types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.HTML"`
	NotifySlackEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifySlack.Enabled"`
	SlackWebhooksURL   string                    `mapconv:"Settings.SimpleMonitor.NotifySlack.IncomingWebhooksURL"`
	NotifyInterval     int                       `mapconv:"Settings.SimpleMonitor.NotifyInterval"`
	Timeout            int                       `mapconv:"Settings.SimpleMonitor.Timeout"`
	MonitoringSuiteLog *MonitoringSuiteLog       `mapconv:"Settings.SimpleMonitor.MonitoringSuiteLog,recursive"`
	SettingsHash       string                    `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleMonitorUpdateRequest) setDefaults() interface{} {
	return &struct {
		Description        string
		Tags               types.Tags
		IconID             types.ID                  `mapconv:"Icon.ID"`
		MaxCheckAttempts   int                       `mapconv:"Settings.SimpleMonitor.MaxCheckAttempts"`
		RetryInterval      int                       `mapconv:"Settings.SimpleMonitor.RetryInterval"`
		DelayLoop          int                       `mapconv:"Settings.SimpleMonitor.DelayLoop"`
		Enabled            types.StringFlag          `mapconv:"Settings.SimpleMonitor.Enabled"`
		HealthCheck        *SimpleMonitorHealthCheck `mapconv:"Settings.SimpleMonitor.HealthCheck,recursive"`
		NotifyEmailEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.Enabled"`
		NotifyEmailHTML    types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.HTML"`
		NotifySlackEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifySlack.Enabled"`
		SlackWebhooksURL   string                    `mapconv:"Settings.SimpleMonitor.NotifySlack.IncomingWebhooksURL"`
		NotifyInterval     int                       `mapconv:"Settings.SimpleMonitor.NotifyInterval"`
		Timeout            int                       `mapconv:"Settings.SimpleMonitor.Timeout"`
		MonitoringSuiteLog *MonitoringSuiteLog       `mapconv:"Settings.SimpleMonitor.MonitoringSuiteLog,recursive"`
		SettingsHash       string                    `json:",omitempty" mapconv:",omitempty"`
	}{
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		MaxCheckAttempts:   o.GetMaxCheckAttempts(),
		RetryInterval:      o.GetRetryInterval(),
		DelayLoop:          o.GetDelayLoop(),
		Enabled:            o.GetEnabled(),
		HealthCheck:        o.GetHealthCheck(),
		NotifyEmailEnabled: o.GetNotifyEmailEnabled(),
		NotifyEmailHTML:    o.GetNotifyEmailHTML(),
		NotifySlackEnabled: o.GetNotifySlackEnabled(),
		SlackWebhooksURL:   o.GetSlackWebhooksURL(),
		NotifyInterval:     o.GetNotifyInterval(),
		Timeout:            o.GetTimeout(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetDescription returns value of Description
func (o *SimpleMonitorUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleMonitorUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleMonitorUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleMonitorUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleMonitorUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleMonitorUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleMonitorUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleMonitorUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SimpleMonitorUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleMonitorUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetMaxCheckAttempts returns value of MaxCheckAttempts
func (o *SimpleMonitorUpdateRequest) GetMaxCheckAttempts() int {
	if o.MaxCheckAttempts == 0 {
		return 3
	}
	return o.MaxCheckAttempts
}

// SetMaxCheckAttempts sets value to MaxCheckAttempts
func (o *SimpleMonitorUpdateRequest) SetMaxCheckAttempts(v int) {
	o.MaxCheckAttempts = v
}

// GetRetryInterval returns value of RetryInterval
func (o *SimpleMonitorUpdateRequest) GetRetryInterval() int {
	if o.RetryInterval == 0 {
		return 10
	}
	return o.RetryInterval
}

// SetRetryInterval sets value to RetryInterval
func (o *SimpleMonitorUpdateRequest) SetRetryInterval(v int) {
	o.RetryInterval = v
}

// GetDelayLoop returns value of DelayLoop
func (o *SimpleMonitorUpdateRequest) GetDelayLoop() int {
	if o.DelayLoop == 0 {
		return 60
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *SimpleMonitorUpdateRequest) SetDelayLoop(v int) {
	o.DelayLoop = v
}

// GetEnabled returns value of Enabled
func (o *SimpleMonitorUpdateRequest) GetEnabled() types.StringFlag {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *SimpleMonitorUpdateRequest) SetEnabled(v types.StringFlag) {
	o.Enabled = v
}

// GetHealthCheck returns value of HealthCheck
func (o *SimpleMonitorUpdateRequest) GetHealthCheck() *SimpleMonitorHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *SimpleMonitorUpdateRequest) SetHealthCheck(v *SimpleMonitorHealthCheck) {
	o.HealthCheck = v
}

// GetNotifyEmailEnabled returns value of NotifyEmailEnabled
func (o *SimpleMonitorUpdateRequest) GetNotifyEmailEnabled() types.StringFlag {
	return o.NotifyEmailEnabled
}

// SetNotifyEmailEnabled sets value to NotifyEmailEnabled
func (o *SimpleMonitorUpdateRequest) SetNotifyEmailEnabled(v types.StringFlag) {
	o.NotifyEmailEnabled = v
}

// GetNotifyEmailHTML returns value of NotifyEmailHTML
func (o *SimpleMonitorUpdateRequest) GetNotifyEmailHTML() types.StringFlag {
	return o.NotifyEmailHTML
}

// SetNotifyEmailHTML sets value to NotifyEmailHTML
func (o *SimpleMonitorUpdateRequest) SetNotifyEmailHTML(v types.StringFlag) {
	o.NotifyEmailHTML = v
}

// GetNotifySlackEnabled returns value of NotifySlackEnabled
func (o *SimpleMonitorUpdateRequest) GetNotifySlackEnabled() types.StringFlag {
	return o.NotifySlackEnabled
}

// SetNotifySlackEnabled sets value to NotifySlackEnabled
func (o *SimpleMonitorUpdateRequest) SetNotifySlackEnabled(v types.StringFlag) {
	o.NotifySlackEnabled = v
}

// GetSlackWebhooksURL returns value of SlackWebhooksURL
func (o *SimpleMonitorUpdateRequest) GetSlackWebhooksURL() string {
	return o.SlackWebhooksURL
}

// SetSlackWebhooksURL sets value to SlackWebhooksURL
func (o *SimpleMonitorUpdateRequest) SetSlackWebhooksURL(v string) {
	o.SlackWebhooksURL = v
}

// GetNotifyInterval returns value of NotifyInterval
func (o *SimpleMonitorUpdateRequest) GetNotifyInterval() int {
	if o.NotifyInterval == 0 {
		return 7200
	}
	return o.NotifyInterval
}

// SetNotifyInterval sets value to NotifyInterval
func (o *SimpleMonitorUpdateRequest) SetNotifyInterval(v int) {
	o.NotifyInterval = v
}

// GetTimeout returns value of Timeout
func (o *SimpleMonitorUpdateRequest) GetTimeout() int {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *SimpleMonitorUpdateRequest) SetTimeout(v int) {
	o.Timeout = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *SimpleMonitorUpdateRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *SimpleMonitorUpdateRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleMonitorUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleMonitorUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* SimpleMonitorUpdateSettingsRequest
*************************************************/

// SimpleMonitorUpdateSettingsRequest represents API parameter/response structure
type SimpleMonitorUpdateSettingsRequest struct {
	MaxCheckAttempts   int                       `mapconv:"Settings.SimpleMonitor.MaxCheckAttempts"`
	RetryInterval      int                       `mapconv:"Settings.SimpleMonitor.RetryInterval"`
	DelayLoop          int                       `mapconv:"Settings.SimpleMonitor.DelayLoop"`
	Enabled            types.StringFlag          `mapconv:"Settings.SimpleMonitor.Enabled"`
	HealthCheck        *SimpleMonitorHealthCheck `mapconv:"Settings.SimpleMonitor.HealthCheck,recursive"`
	NotifyEmailEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.Enabled"`
	NotifyEmailHTML    types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.HTML"`
	NotifySlackEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifySlack.Enabled"`
	SlackWebhooksURL   string                    `mapconv:"Settings.SimpleMonitor.NotifySlack.IncomingWebhooksURL"`
	NotifyInterval     int                       `mapconv:"Settings.SimpleMonitor.NotifyInterval"`
	Timeout            int                       `mapconv:"Settings.SimpleMonitor.Timeout"`
	MonitoringSuiteLog *MonitoringSuiteLog       `mapconv:"Settings.SimpleMonitor.MonitoringSuiteLog,recursive"`
	SettingsHash       string                    `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleMonitorUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		MaxCheckAttempts   int                       `mapconv:"Settings.SimpleMonitor.MaxCheckAttempts"`
		RetryInterval      int                       `mapconv:"Settings.SimpleMonitor.RetryInterval"`
		DelayLoop          int                       `mapconv:"Settings.SimpleMonitor.DelayLoop"`
		Enabled            types.StringFlag          `mapconv:"Settings.SimpleMonitor.Enabled"`
		HealthCheck        *SimpleMonitorHealthCheck `mapconv:"Settings.SimpleMonitor.HealthCheck,recursive"`
		NotifyEmailEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.Enabled"`
		NotifyEmailHTML    types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifyEmail.HTML"`
		NotifySlackEnabled types.StringFlag          `mapconv:"Settings.SimpleMonitor.NotifySlack.Enabled"`
		SlackWebhooksURL   string                    `mapconv:"Settings.SimpleMonitor.NotifySlack.IncomingWebhooksURL"`
		NotifyInterval     int                       `mapconv:"Settings.SimpleMonitor.NotifyInterval"`
		Timeout            int                       `mapconv:"Settings.SimpleMonitor.Timeout"`
		MonitoringSuiteLog *MonitoringSuiteLog       `mapconv:"Settings.SimpleMonitor.MonitoringSuiteLog,recursive"`
		SettingsHash       string                    `json:",omitempty" mapconv:",omitempty"`
	}{
		MaxCheckAttempts:   o.GetMaxCheckAttempts(),
		RetryInterval:      o.GetRetryInterval(),
		DelayLoop:          o.GetDelayLoop(),
		Enabled:            o.GetEnabled(),
		HealthCheck:        o.GetHealthCheck(),
		NotifyEmailEnabled: o.GetNotifyEmailEnabled(),
		NotifyEmailHTML:    o.GetNotifyEmailHTML(),
		NotifySlackEnabled: o.GetNotifySlackEnabled(),
		SlackWebhooksURL:   o.GetSlackWebhooksURL(),
		NotifyInterval:     o.GetNotifyInterval(),
		Timeout:            o.GetTimeout(),
		MonitoringSuiteLog: o.GetMonitoringSuiteLog(),
		SettingsHash:       o.GetSettingsHash(),
	}
}

// GetMaxCheckAttempts returns value of MaxCheckAttempts
func (o *SimpleMonitorUpdateSettingsRequest) GetMaxCheckAttempts() int {
	if o.MaxCheckAttempts == 0 {
		return 3
	}
	return o.MaxCheckAttempts
}

// SetMaxCheckAttempts sets value to MaxCheckAttempts
func (o *SimpleMonitorUpdateSettingsRequest) SetMaxCheckAttempts(v int) {
	o.MaxCheckAttempts = v
}

// GetRetryInterval returns value of RetryInterval
func (o *SimpleMonitorUpdateSettingsRequest) GetRetryInterval() int {
	if o.RetryInterval == 0 {
		return 10
	}
	return o.RetryInterval
}

// SetRetryInterval sets value to RetryInterval
func (o *SimpleMonitorUpdateSettingsRequest) SetRetryInterval(v int) {
	o.RetryInterval = v
}

// GetDelayLoop returns value of DelayLoop
func (o *SimpleMonitorUpdateSettingsRequest) GetDelayLoop() int {
	if o.DelayLoop == 0 {
		return 60
	}
	return o.DelayLoop
}

// SetDelayLoop sets value to DelayLoop
func (o *SimpleMonitorUpdateSettingsRequest) SetDelayLoop(v int) {
	o.DelayLoop = v
}

// GetEnabled returns value of Enabled
func (o *SimpleMonitorUpdateSettingsRequest) GetEnabled() types.StringFlag {
	return o.Enabled
}

// SetEnabled sets value to Enabled
func (o *SimpleMonitorUpdateSettingsRequest) SetEnabled(v types.StringFlag) {
	o.Enabled = v
}

// GetHealthCheck returns value of HealthCheck
func (o *SimpleMonitorUpdateSettingsRequest) GetHealthCheck() *SimpleMonitorHealthCheck {
	return o.HealthCheck
}

// SetHealthCheck sets value to HealthCheck
func (o *SimpleMonitorUpdateSettingsRequest) SetHealthCheck(v *SimpleMonitorHealthCheck) {
	o.HealthCheck = v
}

// GetNotifyEmailEnabled returns value of NotifyEmailEnabled
func (o *SimpleMonitorUpdateSettingsRequest) GetNotifyEmailEnabled() types.StringFlag {
	return o.NotifyEmailEnabled
}

// SetNotifyEmailEnabled sets value to NotifyEmailEnabled
func (o *SimpleMonitorUpdateSettingsRequest) SetNotifyEmailEnabled(v types.StringFlag) {
	o.NotifyEmailEnabled = v
}

// GetNotifyEmailHTML returns value of NotifyEmailHTML
func (o *SimpleMonitorUpdateSettingsRequest) GetNotifyEmailHTML() types.StringFlag {
	return o.NotifyEmailHTML
}

// SetNotifyEmailHTML sets value to NotifyEmailHTML
func (o *SimpleMonitorUpdateSettingsRequest) SetNotifyEmailHTML(v types.StringFlag) {
	o.NotifyEmailHTML = v
}

// GetNotifySlackEnabled returns value of NotifySlackEnabled
func (o *SimpleMonitorUpdateSettingsRequest) GetNotifySlackEnabled() types.StringFlag {
	return o.NotifySlackEnabled
}

// SetNotifySlackEnabled sets value to NotifySlackEnabled
func (o *SimpleMonitorUpdateSettingsRequest) SetNotifySlackEnabled(v types.StringFlag) {
	o.NotifySlackEnabled = v
}

// GetSlackWebhooksURL returns value of SlackWebhooksURL
func (o *SimpleMonitorUpdateSettingsRequest) GetSlackWebhooksURL() string {
	return o.SlackWebhooksURL
}

// SetSlackWebhooksURL sets value to SlackWebhooksURL
func (o *SimpleMonitorUpdateSettingsRequest) SetSlackWebhooksURL(v string) {
	o.SlackWebhooksURL = v
}

// GetNotifyInterval returns value of NotifyInterval
func (o *SimpleMonitorUpdateSettingsRequest) GetNotifyInterval() int {
	if o.NotifyInterval == 0 {
		return 7200
	}
	return o.NotifyInterval
}

// SetNotifyInterval sets value to NotifyInterval
func (o *SimpleMonitorUpdateSettingsRequest) SetNotifyInterval(v int) {
	o.NotifyInterval = v
}

// GetTimeout returns value of Timeout
func (o *SimpleMonitorUpdateSettingsRequest) GetTimeout() int {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *SimpleMonitorUpdateSettingsRequest) SetTimeout(v int) {
	o.Timeout = v
}

// GetMonitoringSuiteLog returns value of MonitoringSuiteLog
func (o *SimpleMonitorUpdateSettingsRequest) GetMonitoringSuiteLog() *MonitoringSuiteLog {
	return o.MonitoringSuiteLog
}

// SetMonitoringSuiteLog sets value to MonitoringSuiteLog
func (o *SimpleMonitorUpdateSettingsRequest) SetMonitoringSuiteLog(v *MonitoringSuiteLog) {
	o.MonitoringSuiteLog = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleMonitorUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleMonitorUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* ResponseTimeSecActivity
*************************************************/

// ResponseTimeSecActivity represents API parameter/response structure
type ResponseTimeSecActivity struct {
	Values []*MonitorResponseTimeSecValue `mapconv:"[]ResponseTimeSec"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *ResponseTimeSecActivity) setDefaults() interface{} {
	return &struct {
		Values []*MonitorResponseTimeSecValue `mapconv:"[]ResponseTimeSec"`
	}{
		Values: o.GetValues(),
	}
}

// GetValues returns value of Values
func (o *ResponseTimeSecActivity) GetValues() []*MonitorResponseTimeSecValue {
	return o.Values
}

// SetValues sets value to Values
func (o *ResponseTimeSecActivity) SetValues(v []*MonitorResponseTimeSecValue) {
	o.Values = v
}

/*************************************************
* MonitorResponseTimeSecValue
*************************************************/

// MonitorResponseTimeSecValue represents API parameter/response structure
type MonitorResponseTimeSecValue struct {
	Time            time.Time `mapconv:",omitempty"`
	ResponseTimeSec float64   `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *MonitorResponseTimeSecValue) setDefaults() interface{} {
	return &struct {
		Time            time.Time `mapconv:",omitempty"`
		ResponseTimeSec float64   `mapconv:",omitempty"`
	}{
		Time:            o.GetTime(),
		ResponseTimeSec: o.GetResponseTimeSec(),
	}
}

// GetTime returns value of Time
func (o *MonitorResponseTimeSecValue) GetTime() time.Time {
	return o.Time
}

// SetTime sets value to Time
func (o *MonitorResponseTimeSecValue) SetTime(v time.Time) {
	o.Time = v
}

// GetResponseTimeSec returns value of ResponseTimeSec
func (o *MonitorResponseTimeSecValue) GetResponseTimeSec() float64 {
	return o.ResponseTimeSec
}

// SetResponseTimeSec sets value to ResponseTimeSec
func (o *MonitorResponseTimeSecValue) SetResponseTimeSec(v float64) {
	o.ResponseTimeSec = v
}

/*************************************************
* SimpleMonitorHealthStatus
*************************************************/

// SimpleMonitorHealthStatus represents API parameter/response structure
type SimpleMonitorHealthStatus struct {
	LastCheckedAt       time.Time
	LastHealthChangedAt time.Time
	Health              types.ESimpleMonitorHealth
	LatestLogs          []string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleMonitorHealthStatus) setDefaults() interface{} {
	return &struct {
		LastCheckedAt       time.Time
		LastHealthChangedAt time.Time
		Health              types.ESimpleMonitorHealth
		LatestLogs          []string
	}{
		LastCheckedAt:       o.GetLastCheckedAt(),
		LastHealthChangedAt: o.GetLastHealthChangedAt(),
		Health:              o.GetHealth(),
		LatestLogs:          o.GetLatestLogs(),
	}
}

// GetLastCheckedAt returns value of LastCheckedAt
func (o *SimpleMonitorHealthStatus) GetLastCheckedAt() time.Time {
	return o.LastCheckedAt
}

// SetLastCheckedAt sets value to LastCheckedAt
func (o *SimpleMonitorHealthStatus) SetLastCheckedAt(v time.Time) {
	o.LastCheckedAt = v
}

// GetLastHealthChangedAt returns value of LastHealthChangedAt
func (o *SimpleMonitorHealthStatus) GetLastHealthChangedAt() time.Time {
	return o.LastHealthChangedAt
}

// SetLastHealthChangedAt sets value to LastHealthChangedAt
func (o *SimpleMonitorHealthStatus) SetLastHealthChangedAt(v time.Time) {
	o.LastHealthChangedAt = v
}

// GetHealth returns value of Health
func (o *SimpleMonitorHealthStatus) GetHealth() types.ESimpleMonitorHealth {
	return o.Health
}

// SetHealth sets value to Health
func (o *SimpleMonitorHealthStatus) SetHealth(v types.ESimpleMonitorHealth) {
	o.Health = v
}

// GetLatestLogs returns value of LatestLogs
func (o *SimpleMonitorHealthStatus) GetLatestLogs() []string {
	return o.LatestLogs
}

// SetLatestLogs sets value to LatestLogs
func (o *SimpleMonitorHealthStatus) SetLatestLogs(v []string) {
	o.LatestLogs = v
}

/*************************************************
* SimpleNotificationDestination
*************************************************/

// SimpleNotificationDestination represents API parameter/response structure
type SimpleNotificationDestination struct {
	ID           types.ID
	Name         string
	Description  string
	Tags         types.Tags
	Availability types.EAvailability
	IconID       types.ID `mapconv:"Icon.ID"`
	CreatedAt    time.Time
	ModifiedAt   time.Time
	Type         types.ESimpleNotificationDestinationTypes `mapconv:"Settings.Type"`
	Disabled     bool                                      `mapconv:"Settings.Disabled"`
	Value        string                                    `mapconv:"Settings.Value"`
	SettingsHash string                                    `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationDestination) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		Tags         types.Tags
		Availability types.EAvailability
		IconID       types.ID `mapconv:"Icon.ID"`
		CreatedAt    time.Time
		ModifiedAt   time.Time
		Type         types.ESimpleNotificationDestinationTypes `mapconv:"Settings.Type"`
		Disabled     bool                                      `mapconv:"Settings.Disabled"`
		Value        string                                    `mapconv:"Settings.Value"`
		SettingsHash string                                    `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		IconID:       o.GetIconID(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
		Type:         o.GetType(),
		Disabled:     o.GetDisabled(),
		Value:        o.GetValue(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetID returns value of ID
func (o *SimpleNotificationDestination) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *SimpleNotificationDestination) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *SimpleNotificationDestination) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *SimpleNotificationDestination) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *SimpleNotificationDestination) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *SimpleNotificationDestination) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *SimpleNotificationDestination) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SimpleNotificationDestination) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SimpleNotificationDestination) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleNotificationDestination) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleNotificationDestination) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleNotificationDestination) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleNotificationDestination) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleNotificationDestination) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleNotificationDestination) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleNotificationDestination) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *SimpleNotificationDestination) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *SimpleNotificationDestination) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *SimpleNotificationDestination) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleNotificationDestination) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *SimpleNotificationDestination) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *SimpleNotificationDestination) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *SimpleNotificationDestination) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *SimpleNotificationDestination) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetType returns value of Type
func (o *SimpleNotificationDestination) GetType() types.ESimpleNotificationDestinationTypes {
	return o.Type
}

// SetType sets value to Type
func (o *SimpleNotificationDestination) SetType(v types.ESimpleNotificationDestinationTypes) {
	o.Type = v
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationDestination) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationDestination) SetDisabled(v bool) {
	o.Disabled = v
}

// GetValue returns value of Value
func (o *SimpleNotificationDestination) GetValue() string {
	return o.Value
}

// SetValue sets value to Value
func (o *SimpleNotificationDestination) SetValue(v string) {
	o.Value = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleNotificationDestination) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleNotificationDestination) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* SimpleNotificationDestinationCreateRequest
*************************************************/

// SimpleNotificationDestinationCreateRequest represents API parameter/response structure
type SimpleNotificationDestinationCreateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID                                  `mapconv:"Icon.ID"`
	Type        types.ESimpleNotificationDestinationTypes `mapconv:"Settings.Type"`
	Disabled    bool                                      `mapconv:"Settings.Disabled"`
	Value       string                                    `mapconv:"Settings.Value"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationDestinationCreateRequest) setDefaults() interface{} {
	return &struct {
		Name         string
		Description  string
		Tags         types.Tags
		IconID       types.ID                                  `mapconv:"Icon.ID"`
		Type         types.ESimpleNotificationDestinationTypes `mapconv:"Settings.Type"`
		Disabled     bool                                      `mapconv:"Settings.Disabled"`
		Value        string                                    `mapconv:"Settings.Value"`
		Class        string                                    `mapconv:"Provider.Class"`
		ServiceClass string
	}{
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		IconID:       o.GetIconID(),
		Type:         o.GetType(),
		Disabled:     o.GetDisabled(),
		Value:        o.GetValue(),
		Class:        "saknoticedestination",
		ServiceClass: "cloud/saknoticedestination/1",
	}
}

// GetName returns value of Name
func (o *SimpleNotificationDestinationCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SimpleNotificationDestinationCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SimpleNotificationDestinationCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleNotificationDestinationCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleNotificationDestinationCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleNotificationDestinationCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleNotificationDestinationCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleNotificationDestinationCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleNotificationDestinationCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleNotificationDestinationCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SimpleNotificationDestinationCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleNotificationDestinationCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetType returns value of Type
func (o *SimpleNotificationDestinationCreateRequest) GetType() types.ESimpleNotificationDestinationTypes {
	return o.Type
}

// SetType sets value to Type
func (o *SimpleNotificationDestinationCreateRequest) SetType(v types.ESimpleNotificationDestinationTypes) {
	o.Type = v
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationDestinationCreateRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationDestinationCreateRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetValue returns value of Value
func (o *SimpleNotificationDestinationCreateRequest) GetValue() string {
	return o.Value
}

// SetValue sets value to Value
func (o *SimpleNotificationDestinationCreateRequest) SetValue(v string) {
	o.Value = v
}

/*************************************************
* SimpleNotificationDestinationUpdateRequest
*************************************************/

// SimpleNotificationDestinationUpdateRequest represents API parameter/response structure
type SimpleNotificationDestinationUpdateRequest struct {
	Name         string
	Description  string
	Tags         types.Tags
	IconID       types.ID `mapconv:"Icon.ID"`
	Disabled     bool     `mapconv:"Settings.Disabled"`
	SettingsHash string   `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationDestinationUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name         string
		Description  string
		Tags         types.Tags
		IconID       types.ID `mapconv:"Icon.ID"`
		Disabled     bool     `mapconv:"Settings.Disabled"`
		SettingsHash string   `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		IconID:       o.GetIconID(),
		Disabled:     o.GetDisabled(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *SimpleNotificationDestinationUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SimpleNotificationDestinationUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SimpleNotificationDestinationUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleNotificationDestinationUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleNotificationDestinationUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleNotificationDestinationUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleNotificationDestinationUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleNotificationDestinationUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleNotificationDestinationUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleNotificationDestinationUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SimpleNotificationDestinationUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleNotificationDestinationUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationDestinationUpdateRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationDestinationUpdateRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleNotificationDestinationUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleNotificationDestinationUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* SimpleNotificationDestinationUpdateSettingsRequest
*************************************************/

// SimpleNotificationDestinationUpdateSettingsRequest represents API parameter/response structure
type SimpleNotificationDestinationUpdateSettingsRequest struct {
	Disabled     bool   `mapconv:"Settings.Disabled"`
	SettingsHash string `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationDestinationUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		Disabled     bool   `mapconv:"Settings.Disabled"`
		SettingsHash string `json:",omitempty" mapconv:",omitempty"`
	}{
		Disabled:     o.GetDisabled(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationDestinationUpdateSettingsRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationDestinationUpdateSettingsRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleNotificationDestinationUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleNotificationDestinationUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* SimpleNotificationDestinationStatus
*************************************************/

// SimpleNotificationDestinationStatus represents API parameter/response structure
type SimpleNotificationDestinationStatus struct {
	Disabled   bool
	ModifiedAt time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationDestinationStatus) setDefaults() interface{} {
	return &struct {
		Disabled   bool
		ModifiedAt time.Time
	}{
		Disabled:   o.GetDisabled(),
		ModifiedAt: o.GetModifiedAt(),
	}
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationDestinationStatus) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationDestinationStatus) SetDisabled(v bool) {
	o.Disabled = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *SimpleNotificationDestinationStatus) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *SimpleNotificationDestinationStatus) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

/*************************************************
* SimpleNotificationGroup
*************************************************/

// SimpleNotificationGroup represents API parameter/response structure
type SimpleNotificationGroup struct {
	ID           types.ID
	Name         string
	Description  string
	Tags         types.Tags
	Availability types.EAvailability
	IconID       types.ID `mapconv:"Icon.ID"`
	CreatedAt    time.Time
	ModifiedAt   time.Time
	Destinations []string `mapconv:"Settings.Destinations"`
	Disabled     bool     `mapconv:"Settings.Disabled"`
	Sources      []string `mapconv:"Settings.Sources"`
	SettingsHash string   `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationGroup) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		Tags         types.Tags
		Availability types.EAvailability
		IconID       types.ID `mapconv:"Icon.ID"`
		CreatedAt    time.Time
		ModifiedAt   time.Time
		Destinations []string `mapconv:"Settings.Destinations"`
		Disabled     bool     `mapconv:"Settings.Disabled"`
		Sources      []string `mapconv:"Settings.Sources"`
		SettingsHash string   `json:",omitempty" mapconv:",omitempty"`
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		Availability: o.GetAvailability(),
		IconID:       o.GetIconID(),
		CreatedAt:    o.GetCreatedAt(),
		ModifiedAt:   o.GetModifiedAt(),
		Destinations: o.GetDestinations(),
		Disabled:     o.GetDisabled(),
		Sources:      o.GetSources(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetID returns value of ID
func (o *SimpleNotificationGroup) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *SimpleNotificationGroup) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *SimpleNotificationGroup) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *SimpleNotificationGroup) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *SimpleNotificationGroup) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *SimpleNotificationGroup) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *SimpleNotificationGroup) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SimpleNotificationGroup) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SimpleNotificationGroup) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleNotificationGroup) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleNotificationGroup) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleNotificationGroup) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleNotificationGroup) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleNotificationGroup) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleNotificationGroup) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleNotificationGroup) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *SimpleNotificationGroup) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *SimpleNotificationGroup) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetIconID returns value of IconID
func (o *SimpleNotificationGroup) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleNotificationGroup) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *SimpleNotificationGroup) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *SimpleNotificationGroup) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *SimpleNotificationGroup) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *SimpleNotificationGroup) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetDestinations returns value of Destinations
func (o *SimpleNotificationGroup) GetDestinations() []string {
	return o.Destinations
}

// SetDestinations sets value to Destinations
func (o *SimpleNotificationGroup) SetDestinations(v []string) {
	o.Destinations = v
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationGroup) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationGroup) SetDisabled(v bool) {
	o.Disabled = v
}

// GetSources returns value of Sources
func (o *SimpleNotificationGroup) GetSources() []string {
	return o.Sources
}

// SetSources sets value to Sources
func (o *SimpleNotificationGroup) SetSources(v []string) {
	o.Sources = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleNotificationGroup) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleNotificationGroup) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* SimpleNotificationGroupCreateRequest
*************************************************/

// SimpleNotificationGroupCreateRequest represents API parameter/response structure
type SimpleNotificationGroupCreateRequest struct {
	Name         string
	Description  string
	Tags         types.Tags
	IconID       types.ID `mapconv:"Icon.ID"`
	Destinations []string `mapconv:"Settings.Destinations"`
	Disabled     bool     `mapconv:"Settings.Disabled"`
	Sources      []string `mapconv:"Settings.Sources"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationGroupCreateRequest) setDefaults() interface{} {
	return &struct {
		Name         string
		Description  string
		Tags         types.Tags
		IconID       types.ID `mapconv:"Icon.ID"`
		Destinations []string `mapconv:"Settings.Destinations"`
		Disabled     bool     `mapconv:"Settings.Disabled"`
		Sources      []string `mapconv:"Settings.Sources"`
		Class        string   `mapconv:"Provider.Class"`
		ServiceClass string
	}{
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		IconID:       o.GetIconID(),
		Destinations: o.GetDestinations(),
		Disabled:     o.GetDisabled(),
		Sources:      o.GetSources(),
		Class:        "saknoticegroup",
		ServiceClass: "cloud/saknoticegroup/1",
	}
}

// GetName returns value of Name
func (o *SimpleNotificationGroupCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SimpleNotificationGroupCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SimpleNotificationGroupCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleNotificationGroupCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleNotificationGroupCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleNotificationGroupCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleNotificationGroupCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleNotificationGroupCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleNotificationGroupCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleNotificationGroupCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SimpleNotificationGroupCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleNotificationGroupCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetDestinations returns value of Destinations
func (o *SimpleNotificationGroupCreateRequest) GetDestinations() []string {
	return o.Destinations
}

// SetDestinations sets value to Destinations
func (o *SimpleNotificationGroupCreateRequest) SetDestinations(v []string) {
	o.Destinations = v
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationGroupCreateRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationGroupCreateRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetSources returns value of Sources
func (o *SimpleNotificationGroupCreateRequest) GetSources() []string {
	return o.Sources
}

// SetSources sets value to Sources
func (o *SimpleNotificationGroupCreateRequest) SetSources(v []string) {
	o.Sources = v
}

/*************************************************
* SimpleNotificationGroupUpdateRequest
*************************************************/

// SimpleNotificationGroupUpdateRequest represents API parameter/response structure
type SimpleNotificationGroupUpdateRequest struct {
	Name         string
	Description  string
	Tags         types.Tags
	IconID       types.ID `mapconv:"Icon.ID"`
	Destinations []string `mapconv:"Settings.Destinations"`
	Disabled     bool     `mapconv:"Settings.Disabled"`
	Sources      []string `mapconv:"Settings.Sources"`
	SettingsHash string   `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationGroupUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name         string
		Description  string
		Tags         types.Tags
		IconID       types.ID `mapconv:"Icon.ID"`
		Destinations []string `mapconv:"Settings.Destinations"`
		Disabled     bool     `mapconv:"Settings.Disabled"`
		Sources      []string `mapconv:"Settings.Sources"`
		SettingsHash string   `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		IconID:       o.GetIconID(),
		Destinations: o.GetDestinations(),
		Disabled:     o.GetDisabled(),
		Sources:      o.GetSources(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *SimpleNotificationGroupUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SimpleNotificationGroupUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SimpleNotificationGroupUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SimpleNotificationGroupUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SimpleNotificationGroupUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SimpleNotificationGroupUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SimpleNotificationGroupUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SimpleNotificationGroupUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SimpleNotificationGroupUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SimpleNotificationGroupUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SimpleNotificationGroupUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SimpleNotificationGroupUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetDestinations returns value of Destinations
func (o *SimpleNotificationGroupUpdateRequest) GetDestinations() []string {
	return o.Destinations
}

// SetDestinations sets value to Destinations
func (o *SimpleNotificationGroupUpdateRequest) SetDestinations(v []string) {
	o.Destinations = v
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationGroupUpdateRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationGroupUpdateRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetSources returns value of Sources
func (o *SimpleNotificationGroupUpdateRequest) GetSources() []string {
	return o.Sources
}

// SetSources sets value to Sources
func (o *SimpleNotificationGroupUpdateRequest) SetSources(v []string) {
	o.Sources = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleNotificationGroupUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleNotificationGroupUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* SimpleNotificationGroupUpdateSettingsRequest
*************************************************/

// SimpleNotificationGroupUpdateSettingsRequest represents API parameter/response structure
type SimpleNotificationGroupUpdateSettingsRequest struct {
	Disabled     bool   `mapconv:"Settings.Disabled"`
	SettingsHash string `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationGroupUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		Disabled     bool   `mapconv:"Settings.Disabled"`
		SettingsHash string `json:",omitempty" mapconv:",omitempty"`
	}{
		Disabled:     o.GetDisabled(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetDisabled returns value of Disabled
func (o *SimpleNotificationGroupUpdateSettingsRequest) GetDisabled() bool {
	return o.Disabled
}

// SetDisabled sets value to Disabled
func (o *SimpleNotificationGroupUpdateSettingsRequest) SetDisabled(v bool) {
	o.Disabled = v
}

// GetSettingsHash returns value of SettingsHash
func (o *SimpleNotificationGroupUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *SimpleNotificationGroupUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* SimpleNotificationHistories
*************************************************/

// SimpleNotificationHistories represents API parameter/response structure
type SimpleNotificationHistories struct {
	NotificationHistories []*SimpleNotificationHistory
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationHistories) setDefaults() interface{} {
	return &struct {
		NotificationHistories []*SimpleNotificationHistory
	}{
		NotificationHistories: o.GetNotificationHistories(),
	}
}

// GetNotificationHistories returns value of NotificationHistories
func (o *SimpleNotificationHistories) GetNotificationHistories() []*SimpleNotificationHistory {
	return o.NotificationHistories
}

// SetNotificationHistories sets value to NotificationHistories
func (o *SimpleNotificationHistories) SetNotificationHistories(v []*SimpleNotificationHistory) {
	o.NotificationHistories = v
}

/*************************************************
* SimpleNotificationHistory
*************************************************/

// SimpleNotificationHistory represents API parameter/response structure
type SimpleNotificationHistory struct {
	RequestID  string
	SourceID   string
	ReceivedAt time.Time
	Message    *SimpleNotificationHistoryMessage
	Statuses   []*SimpleNotificationHistoryStatus
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationHistory) setDefaults() interface{} {
	return &struct {
		RequestID  string
		SourceID   string
		ReceivedAt time.Time
		Message    *SimpleNotificationHistoryMessage
		Statuses   []*SimpleNotificationHistoryStatus
	}{
		RequestID:  o.GetRequestID(),
		SourceID:   o.GetSourceID(),
		ReceivedAt: o.GetReceivedAt(),
		Message:    o.GetMessage(),
		Statuses:   o.GetStatuses(),
	}
}

// GetRequestID returns value of RequestID
func (o *SimpleNotificationHistory) GetRequestID() string {
	return o.RequestID
}

// SetRequestID sets value to RequestID
func (o *SimpleNotificationHistory) SetRequestID(v string) {
	o.RequestID = v
}

// GetSourceID returns value of SourceID
func (o *SimpleNotificationHistory) GetSourceID() string {
	return o.SourceID
}

// SetSourceID sets value to SourceID
func (o *SimpleNotificationHistory) SetSourceID(v string) {
	o.SourceID = v
}

// GetReceivedAt returns value of ReceivedAt
func (o *SimpleNotificationHistory) GetReceivedAt() time.Time {
	return o.ReceivedAt
}

// SetReceivedAt sets value to ReceivedAt
func (o *SimpleNotificationHistory) SetReceivedAt(v time.Time) {
	o.ReceivedAt = v
}

// GetMessage returns value of Message
func (o *SimpleNotificationHistory) GetMessage() *SimpleNotificationHistoryMessage {
	return o.Message
}

// SetMessage sets value to Message
func (o *SimpleNotificationHistory) SetMessage(v *SimpleNotificationHistoryMessage) {
	o.Message = v
}

// GetStatuses returns value of Statuses
func (o *SimpleNotificationHistory) GetStatuses() []*SimpleNotificationHistoryStatus {
	return o.Statuses
}

// SetStatuses sets value to Statuses
func (o *SimpleNotificationHistory) SetStatuses(v []*SimpleNotificationHistoryStatus) {
	o.Statuses = v
}

/*************************************************
* SimpleNotificationHistoryMessage
*************************************************/

// SimpleNotificationHistoryMessage represents API parameter/response structure
type SimpleNotificationHistoryMessage struct {
	Body      string
	Color     string
	ColorCode string
	IconURL   string
	ImageURL  string
	Title     string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationHistoryMessage) setDefaults() interface{} {
	return &struct {
		Body      string
		Color     string
		ColorCode string
		IconURL   string
		ImageURL  string
		Title     string
	}{
		Body:      o.GetBody(),
		Color:     o.GetColor(),
		ColorCode: o.GetColorCode(),
		IconURL:   o.GetIconURL(),
		ImageURL:  o.GetImageURL(),
		Title:     o.GetTitle(),
	}
}

// GetBody returns value of Body
func (o *SimpleNotificationHistoryMessage) GetBody() string {
	return o.Body
}

// SetBody sets value to Body
func (o *SimpleNotificationHistoryMessage) SetBody(v string) {
	o.Body = v
}

// GetColor returns value of Color
func (o *SimpleNotificationHistoryMessage) GetColor() string {
	return o.Color
}

// SetColor sets value to Color
func (o *SimpleNotificationHistoryMessage) SetColor(v string) {
	o.Color = v
}

// GetColorCode returns value of ColorCode
func (o *SimpleNotificationHistoryMessage) GetColorCode() string {
	return o.ColorCode
}

// SetColorCode sets value to ColorCode
func (o *SimpleNotificationHistoryMessage) SetColorCode(v string) {
	o.ColorCode = v
}

// GetIconURL returns value of IconURL
func (o *SimpleNotificationHistoryMessage) GetIconURL() string {
	return o.IconURL
}

// SetIconURL sets value to IconURL
func (o *SimpleNotificationHistoryMessage) SetIconURL(v string) {
	o.IconURL = v
}

// GetImageURL returns value of ImageURL
func (o *SimpleNotificationHistoryMessage) GetImageURL() string {
	return o.ImageURL
}

// SetImageURL sets value to ImageURL
func (o *SimpleNotificationHistoryMessage) SetImageURL(v string) {
	o.ImageURL = v
}

// GetTitle returns value of Title
func (o *SimpleNotificationHistoryMessage) GetTitle() string {
	return o.Title
}

// SetTitle sets value to Title
func (o *SimpleNotificationHistoryMessage) SetTitle(v string) {
	o.Title = v
}

/*************************************************
* SimpleNotificationHistoryStatus
*************************************************/

// SimpleNotificationHistoryStatus represents API parameter/response structure
type SimpleNotificationHistoryStatus struct {
	ID                    string
	Status                int
	ErrorInfo             string
	NotificationRequestID string
	GroupID               string
	CreatedAt             time.Time
	UpdatedAt             time.Time
}

// setDefaults implements iaas.argumentDefaulter
func (o *SimpleNotificationHistoryStatus) setDefaults() interface{} {
	return &struct {
		ID                    string
		Status                int
		ErrorInfo             string
		NotificationRequestID string
		GroupID               string
		CreatedAt             time.Time
		UpdatedAt             time.Time
	}{
		ID:                    o.GetID(),
		Status:                o.GetStatus(),
		ErrorInfo:             o.GetErrorInfo(),
		NotificationRequestID: o.GetNotificationRequestID(),
		GroupID:               o.GetGroupID(),
		CreatedAt:             o.GetCreatedAt(),
		UpdatedAt:             o.GetUpdatedAt(),
	}
}

// GetID returns value of ID
func (o *SimpleNotificationHistoryStatus) GetID() string {
	return o.ID
}

// SetID sets value to ID
func (o *SimpleNotificationHistoryStatus) SetID(v string) {
	o.ID = v
}

// GetStatus returns value of Status
func (o *SimpleNotificationHistoryStatus) GetStatus() int {
	return o.Status
}

// SetStatus sets value to Status
func (o *SimpleNotificationHistoryStatus) SetStatus(v int) {
	o.Status = v
}

// GetErrorInfo returns value of ErrorInfo
func (o *SimpleNotificationHistoryStatus) GetErrorInfo() string {
	return o.ErrorInfo
}

// SetErrorInfo sets value to ErrorInfo
func (o *SimpleNotificationHistoryStatus) SetErrorInfo(v string) {
	o.ErrorInfo = v
}

// GetNotificationRequestID returns value of NotificationRequestID
func (o *SimpleNotificationHistoryStatus) GetNotificationRequestID() string {
	return o.NotificationRequestID
}

// SetNotificationRequestID sets value to NotificationRequestID
func (o *SimpleNotificationHistoryStatus) SetNotificationRequestID(v string) {
	o.NotificationRequestID = v
}

// GetGroupID returns value of GroupID
func (o *SimpleNotificationHistoryStatus) GetGroupID() string {
	return o.GroupID
}

// SetGroupID sets value to GroupID
func (o *SimpleNotificationHistoryStatus) SetGroupID(v string) {
	o.GroupID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *SimpleNotificationHistoryStatus) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *SimpleNotificationHistoryStatus) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetUpdatedAt returns value of UpdatedAt
func (o *SimpleNotificationHistoryStatus) GetUpdatedAt() time.Time {
	return o.UpdatedAt
}

// SetUpdatedAt sets value to UpdatedAt
func (o *SimpleNotificationHistoryStatus) SetUpdatedAt(v time.Time) {
	o.UpdatedAt = v
}

/*************************************************
* SSHKey
*************************************************/

// SSHKey represents API parameter/response structure
type SSHKey struct {
	ID          types.ID
	Name        string
	Description string
	CreatedAt   time.Time
	PublicKey   string
	Fingerprint string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SSHKey) setDefaults() interface{} {
	return &struct {
		ID          types.ID
		Name        string
		Description string
		CreatedAt   time.Time
		PublicKey   string
		Fingerprint string
	}{
		ID:          o.GetID(),
		Name:        o.GetName(),
		Description: o.GetDescription(),
		CreatedAt:   o.GetCreatedAt(),
		PublicKey:   o.GetPublicKey(),
		Fingerprint: o.GetFingerprint(),
	}
}

// GetID returns value of ID
func (o *SSHKey) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *SSHKey) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *SSHKey) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *SSHKey) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *SSHKey) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *SSHKey) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *SSHKey) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SSHKey) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SSHKey) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SSHKey) SetDescription(v string) {
	o.Description = v
}

// GetCreatedAt returns value of CreatedAt
func (o *SSHKey) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *SSHKey) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetPublicKey returns value of PublicKey
func (o *SSHKey) GetPublicKey() string {
	return o.PublicKey
}

// SetPublicKey sets value to PublicKey
func (o *SSHKey) SetPublicKey(v string) {
	o.PublicKey = v
}

// GetFingerprint returns value of Fingerprint
func (o *SSHKey) GetFingerprint() string {
	return o.Fingerprint
}

// SetFingerprint sets value to Fingerprint
func (o *SSHKey) SetFingerprint(v string) {
	o.Fingerprint = v
}

/*************************************************
* SSHKeyCreateRequest
*************************************************/

// SSHKeyCreateRequest represents API parameter/response structure
type SSHKeyCreateRequest struct {
	Name        string
	Description string
	PublicKey   string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SSHKeyCreateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		PublicKey   string
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		PublicKey:   o.GetPublicKey(),
	}
}

// GetName returns value of Name
func (o *SSHKeyCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SSHKeyCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SSHKeyCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SSHKeyCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetPublicKey returns value of PublicKey
func (o *SSHKeyCreateRequest) GetPublicKey() string {
	return o.PublicKey
}

// SetPublicKey sets value to PublicKey
func (o *SSHKeyCreateRequest) SetPublicKey(v string) {
	o.PublicKey = v
}

/*************************************************
* SSHKeyUpdateRequest
*************************************************/

// SSHKeyUpdateRequest represents API parameter/response structure
type SSHKeyUpdateRequest struct {
	Name        string
	Description string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SSHKeyUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
	}
}

// GetName returns value of Name
func (o *SSHKeyUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SSHKeyUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *SSHKeyUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SSHKeyUpdateRequest) SetDescription(v string) {
	o.Description = v
}

/*************************************************
* Subnet
*************************************************/

// Subnet represents API parameter/response structure
type Subnet struct {
	ID             types.ID
	SwitchID       types.ID `mapconv:"Switch.ID,omitempty"`
	InternetID     types.ID `mapconv:"Switch.Internet.ID,omitempty"`
	DefaultRoute   string
	NextHop        string
	StaticRoute    string
	NetworkAddress string
	NetworkMaskLen int
	IPAddresses    []*SubnetIPAddress `mapconv:"[]IPAddresses,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *Subnet) setDefaults() interface{} {
	return &struct {
		ID             types.ID
		SwitchID       types.ID `mapconv:"Switch.ID,omitempty"`
		InternetID     types.ID `mapconv:"Switch.Internet.ID,omitempty"`
		DefaultRoute   string
		NextHop        string
		StaticRoute    string
		NetworkAddress string
		NetworkMaskLen int
		IPAddresses    []*SubnetIPAddress `mapconv:"[]IPAddresses,recursive"`
	}{
		ID:             o.GetID(),
		SwitchID:       o.GetSwitchID(),
		InternetID:     o.GetInternetID(),
		DefaultRoute:   o.GetDefaultRoute(),
		NextHop:        o.GetNextHop(),
		StaticRoute:    o.GetStaticRoute(),
		NetworkAddress: o.GetNetworkAddress(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
		IPAddresses:    o.GetIPAddresses(),
	}
}

// GetID returns value of ID
func (o *Subnet) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Subnet) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Subnet) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Subnet) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Subnet) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Subnet) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetSwitchID returns value of SwitchID
func (o *Subnet) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *Subnet) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetInternetID returns value of InternetID
func (o *Subnet) GetInternetID() types.ID {
	return o.InternetID
}

// SetInternetID sets value to InternetID
func (o *Subnet) SetInternetID(v types.ID) {
	o.InternetID = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *Subnet) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *Subnet) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetNextHop returns value of NextHop
func (o *Subnet) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *Subnet) SetNextHop(v string) {
	o.NextHop = v
}

// GetStaticRoute returns value of StaticRoute
func (o *Subnet) GetStaticRoute() string {
	return o.StaticRoute
}

// SetStaticRoute sets value to StaticRoute
func (o *Subnet) SetStaticRoute(v string) {
	o.StaticRoute = v
}

// GetNetworkAddress returns value of NetworkAddress
func (o *Subnet) GetNetworkAddress() string {
	return o.NetworkAddress
}

// SetNetworkAddress sets value to NetworkAddress
func (o *Subnet) SetNetworkAddress(v string) {
	o.NetworkAddress = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *Subnet) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *Subnet) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetIPAddresses returns value of IPAddresses
func (o *Subnet) GetIPAddresses() []*SubnetIPAddress {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *Subnet) SetIPAddresses(v []*SubnetIPAddress) {
	o.IPAddresses = v
}

/*************************************************
* SubnetIPAddress
*************************************************/

// SubnetIPAddress represents API parameter/response structure
type SubnetIPAddress struct {
	HostName  string
	IPAddress string
}

// setDefaults implements iaas.argumentDefaulter
func (o *SubnetIPAddress) setDefaults() interface{} {
	return &struct {
		HostName  string
		IPAddress string
	}{
		HostName:  o.GetHostName(),
		IPAddress: o.GetIPAddress(),
	}
}

// GetHostName returns value of HostName
func (o *SubnetIPAddress) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *SubnetIPAddress) SetHostName(v string) {
	o.HostName = v
}

// GetIPAddress returns value of IPAddress
func (o *SubnetIPAddress) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *SubnetIPAddress) SetIPAddress(v string) {
	o.IPAddress = v
}

/*************************************************
* Switch
*************************************************/

// Switch represents API parameter/response structure
type Switch struct {
	ID                 types.ID
	Name               string
	Description        string
	Tags               types.Tags
	IconID             types.ID `mapconv:"Icon.ID"`
	CreatedAt          time.Time
	ModifiedAt         time.Time
	Scope              types.EScope
	ServerCount        int
	NetworkMaskLen     int             `mapconv:"UserSubnet.NetworkMaskLen"`
	DefaultRoute       string          `mapconv:"UserSubnet.DefaultRoute"`
	Subnets            []*SwitchSubnet `json:",omitempty" mapconv:"[]Subnets,omitempty,recursive"`
	BridgeID           types.ID        `mapconv:"Bridge.ID,omitempty"`
	HybridConnectionID types.ID        `mapconv:"HybridConnection.ID,omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *Switch) setDefaults() interface{} {
	return &struct {
		ID                 types.ID
		Name               string
		Description        string
		Tags               types.Tags
		IconID             types.ID `mapconv:"Icon.ID"`
		CreatedAt          time.Time
		ModifiedAt         time.Time
		Scope              types.EScope
		ServerCount        int
		NetworkMaskLen     int             `mapconv:"UserSubnet.NetworkMaskLen"`
		DefaultRoute       string          `mapconv:"UserSubnet.DefaultRoute"`
		Subnets            []*SwitchSubnet `json:",omitempty" mapconv:"[]Subnets,omitempty,recursive"`
		BridgeID           types.ID        `mapconv:"Bridge.ID,omitempty"`
		HybridConnectionID types.ID        `mapconv:"HybridConnection.ID,omitempty"`
	}{
		ID:                 o.GetID(),
		Name:               o.GetName(),
		Description:        o.GetDescription(),
		Tags:               o.GetTags(),
		IconID:             o.GetIconID(),
		CreatedAt:          o.GetCreatedAt(),
		ModifiedAt:         o.GetModifiedAt(),
		Scope:              o.GetScope(),
		ServerCount:        o.GetServerCount(),
		NetworkMaskLen:     o.GetNetworkMaskLen(),
		DefaultRoute:       o.GetDefaultRoute(),
		Subnets:            o.GetSubnets(),
		BridgeID:           o.GetBridgeID(),
		HybridConnectionID: o.GetHybridConnectionID(),
	}
}

// GetID returns value of ID
func (o *Switch) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Switch) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Switch) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Switch) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Switch) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Switch) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Switch) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Switch) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Switch) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Switch) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *Switch) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *Switch) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *Switch) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *Switch) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *Switch) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *Switch) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *Switch) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *Switch) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *Switch) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *Switch) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetModifiedAt returns value of ModifiedAt
func (o *Switch) GetModifiedAt() time.Time {
	return o.ModifiedAt
}

// SetModifiedAt sets value to ModifiedAt
func (o *Switch) SetModifiedAt(v time.Time) {
	o.ModifiedAt = v
}

// GetScope returns value of Scope
func (o *Switch) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *Switch) SetScope(v types.EScope) {
	o.Scope = v
}

// GetServerCount returns value of ServerCount
func (o *Switch) GetServerCount() int {
	return o.ServerCount
}

// SetServerCount sets value to ServerCount
func (o *Switch) SetServerCount(v int) {
	o.ServerCount = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *Switch) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *Switch) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *Switch) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *Switch) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetSubnets returns value of Subnets
func (o *Switch) GetSubnets() []*SwitchSubnet {
	return o.Subnets
}

// SetSubnets sets value to Subnets
func (o *Switch) SetSubnets(v []*SwitchSubnet) {
	o.Subnets = v
}

// GetBridgeID returns value of BridgeID
func (o *Switch) GetBridgeID() types.ID {
	return o.BridgeID
}

// SetBridgeID sets value to BridgeID
func (o *Switch) SetBridgeID(v types.ID) {
	o.BridgeID = v
}

// GetHybridConnectionID returns value of HybridConnectionID
func (o *Switch) GetHybridConnectionID() types.ID {
	return o.HybridConnectionID
}

// SetHybridConnectionID sets value to HybridConnectionID
func (o *Switch) SetHybridConnectionID(v types.ID) {
	o.HybridConnectionID = v
}

/*************************************************
* SwitchSubnet
*************************************************/

// SwitchSubnet represents API parameter/response structure
type SwitchSubnet struct {
	ID                   types.ID
	DefaultRoute         string
	NextHop              string
	StaticRoute          string
	NetworkAddress       string
	NetworkMaskLen       int
	Internet             *Internet
	AssignedIPAddressMax string `mapconv:"IPAddresses.Max"`
	AssignedIPAddressMin string `mapconv:"IPAddresses.Min"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SwitchSubnet) setDefaults() interface{} {
	return &struct {
		ID                   types.ID
		DefaultRoute         string
		NextHop              string
		StaticRoute          string
		NetworkAddress       string
		NetworkMaskLen       int
		Internet             *Internet
		AssignedIPAddressMax string `mapconv:"IPAddresses.Max"`
		AssignedIPAddressMin string `mapconv:"IPAddresses.Min"`
	}{
		ID:                   o.GetID(),
		DefaultRoute:         o.GetDefaultRoute(),
		NextHop:              o.GetNextHop(),
		StaticRoute:          o.GetStaticRoute(),
		NetworkAddress:       o.GetNetworkAddress(),
		NetworkMaskLen:       o.GetNetworkMaskLen(),
		Internet:             o.GetInternet(),
		AssignedIPAddressMax: o.GetAssignedIPAddressMax(),
		AssignedIPAddressMin: o.GetAssignedIPAddressMin(),
	}
}

// GetAssignedIPAddresses 割り当てられたIPアドレスのリスト
func (o *SwitchSubnet) GetAssignedIPAddresses() []string {
	return accessor.GetAssignedIPAddresses(o)
}

// GetID returns value of ID
func (o *SwitchSubnet) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *SwitchSubnet) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *SwitchSubnet) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *SwitchSubnet) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *SwitchSubnet) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *SwitchSubnet) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetDefaultRoute returns value of DefaultRoute
func (o *SwitchSubnet) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *SwitchSubnet) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetNextHop returns value of NextHop
func (o *SwitchSubnet) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *SwitchSubnet) SetNextHop(v string) {
	o.NextHop = v
}

// GetStaticRoute returns value of StaticRoute
func (o *SwitchSubnet) GetStaticRoute() string {
	return o.StaticRoute
}

// SetStaticRoute sets value to StaticRoute
func (o *SwitchSubnet) SetStaticRoute(v string) {
	o.StaticRoute = v
}

// GetNetworkAddress returns value of NetworkAddress
func (o *SwitchSubnet) GetNetworkAddress() string {
	return o.NetworkAddress
}

// SetNetworkAddress sets value to NetworkAddress
func (o *SwitchSubnet) SetNetworkAddress(v string) {
	o.NetworkAddress = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *SwitchSubnet) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *SwitchSubnet) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetInternet returns value of Internet
func (o *SwitchSubnet) GetInternet() *Internet {
	return o.Internet
}

// SetInternet sets value to Internet
func (o *SwitchSubnet) SetInternet(v *Internet) {
	o.Internet = v
}

// GetAssignedIPAddressMax returns value of AssignedIPAddressMax
func (o *SwitchSubnet) GetAssignedIPAddressMax() string {
	return o.AssignedIPAddressMax
}

// SetAssignedIPAddressMax sets value to AssignedIPAddressMax
func (o *SwitchSubnet) SetAssignedIPAddressMax(v string) {
	o.AssignedIPAddressMax = v
}

// GetAssignedIPAddressMin returns value of AssignedIPAddressMin
func (o *SwitchSubnet) GetAssignedIPAddressMin() string {
	return o.AssignedIPAddressMin
}

// SetAssignedIPAddressMin sets value to AssignedIPAddressMin
func (o *SwitchSubnet) SetAssignedIPAddressMin(v string) {
	o.AssignedIPAddressMin = v
}

/*************************************************
* SwitchCreateRequest
*************************************************/

// SwitchCreateRequest represents API parameter/response structure
type SwitchCreateRequest struct {
	Name           string
	NetworkMaskLen int    `mapconv:"UserSubnet.NetworkMaskLen"`
	DefaultRoute   string `mapconv:"UserSubnet.DefaultRoute"`
	Description    string
	Tags           types.Tags
	IconID         types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SwitchCreateRequest) setDefaults() interface{} {
	return &struct {
		Name           string
		NetworkMaskLen int    `mapconv:"UserSubnet.NetworkMaskLen"`
		DefaultRoute   string `mapconv:"UserSubnet.DefaultRoute"`
		Description    string
		Tags           types.Tags
		IconID         types.ID `mapconv:"Icon.ID"`
	}{
		Name:           o.GetName(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
		DefaultRoute:   o.GetDefaultRoute(),
		Description:    o.GetDescription(),
		Tags:           o.GetTags(),
		IconID:         o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *SwitchCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SwitchCreateRequest) SetName(v string) {
	o.Name = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *SwitchCreateRequest) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *SwitchCreateRequest) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *SwitchCreateRequest) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *SwitchCreateRequest) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetDescription returns value of Description
func (o *SwitchCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SwitchCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SwitchCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SwitchCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SwitchCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SwitchCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SwitchCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SwitchCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SwitchCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SwitchCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* SwitchUpdateRequest
*************************************************/

// SwitchUpdateRequest represents API parameter/response structure
type SwitchUpdateRequest struct {
	Name           string
	NetworkMaskLen int    `mapconv:"UserSubnet.NetworkMaskLen"`
	DefaultRoute   string `mapconv:"UserSubnet.DefaultRoute"`
	Description    string
	Tags           types.Tags
	IconID         types.ID `mapconv:"Icon.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *SwitchUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name           string
		NetworkMaskLen int    `mapconv:"UserSubnet.NetworkMaskLen"`
		DefaultRoute   string `mapconv:"UserSubnet.DefaultRoute"`
		Description    string
		Tags           types.Tags
		IconID         types.ID `mapconv:"Icon.ID"`
	}{
		Name:           o.GetName(),
		NetworkMaskLen: o.GetNetworkMaskLen(),
		DefaultRoute:   o.GetDefaultRoute(),
		Description:    o.GetDescription(),
		Tags:           o.GetTags(),
		IconID:         o.GetIconID(),
	}
}

// GetName returns value of Name
func (o *SwitchUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *SwitchUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *SwitchUpdateRequest) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *SwitchUpdateRequest) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetDefaultRoute returns value of DefaultRoute
func (o *SwitchUpdateRequest) GetDefaultRoute() string {
	return o.DefaultRoute
}

// SetDefaultRoute sets value to DefaultRoute
func (o *SwitchUpdateRequest) SetDefaultRoute(v string) {
	o.DefaultRoute = v
}

// GetDescription returns value of Description
func (o *SwitchUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *SwitchUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *SwitchUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *SwitchUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *SwitchUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *SwitchUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *SwitchUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *SwitchUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *SwitchUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *SwitchUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

/*************************************************
* VPCRouter
*************************************************/

// VPCRouter represents API parameter/response structure
type VPCRouter struct {
	ID                      types.ID
	Name                    string
	Description             string
	Tags                    types.Tags
	Availability            types.EAvailability
	Class                   string
	IconID                  types.ID `mapconv:"Icon.ID"`
	CreatedAt               time.Time
	PlanID                  types.ID                    `mapconv:"Remark.Plan.ID/Plan.ID"`
	Version                 int                         `mapconv:"Remark.Router.VPCRouterVersion"`
	Settings                *VPCRouterSetting           `mapconv:",omitempty,recursive"`
	SettingsHash            string                      `json:",omitempty" mapconv:",omitempty"`
	InstanceHostName        string                      `mapconv:"Instance.Host.Name"`
	InstanceHostInfoURL     string                      `mapconv:"Instance.Host.InfoURL"`
	InstanceStatus          types.EServerInstanceStatus `mapconv:"Instance.Status"`
	InstanceStatusChangedAt time.Time                   `mapconv:"Instance.StatusChangedAt"`
	Interfaces              []*VPCRouterInterface       `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
	ZoneID                  types.ID                    `mapconv:"Remark.Zone.ID"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouter) setDefaults() interface{} {
	return &struct {
		ID                      types.ID
		Name                    string
		Description             string
		Tags                    types.Tags
		Availability            types.EAvailability
		Class                   string
		IconID                  types.ID `mapconv:"Icon.ID"`
		CreatedAt               time.Time
		PlanID                  types.ID                    `mapconv:"Remark.Plan.ID/Plan.ID"`
		Version                 int                         `mapconv:"Remark.Router.VPCRouterVersion"`
		Settings                *VPCRouterSetting           `mapconv:",omitempty,recursive"`
		SettingsHash            string                      `json:",omitempty" mapconv:",omitempty"`
		InstanceHostName        string                      `mapconv:"Instance.Host.Name"`
		InstanceHostInfoURL     string                      `mapconv:"Instance.Host.InfoURL"`
		InstanceStatus          types.EServerInstanceStatus `mapconv:"Instance.Status"`
		InstanceStatusChangedAt time.Time                   `mapconv:"Instance.StatusChangedAt"`
		Interfaces              []*VPCRouterInterface       `json:",omitempty" mapconv:"[]Interfaces,recursive,omitempty"`
		ZoneID                  types.ID                    `mapconv:"Remark.Zone.ID"`
	}{
		ID:                      o.GetID(),
		Name:                    o.GetName(),
		Description:             o.GetDescription(),
		Tags:                    o.GetTags(),
		Availability:            o.GetAvailability(),
		Class:                   o.GetClass(),
		IconID:                  o.GetIconID(),
		CreatedAt:               o.GetCreatedAt(),
		PlanID:                  o.GetPlanID(),
		Version:                 o.GetVersion(),
		Settings:                o.GetSettings(),
		SettingsHash:            o.GetSettingsHash(),
		InstanceHostName:        o.GetInstanceHostName(),
		InstanceHostInfoURL:     o.GetInstanceHostInfoURL(),
		InstanceStatus:          o.GetInstanceStatus(),
		InstanceStatusChangedAt: o.GetInstanceStatusChangedAt(),
		Interfaces:              o.GetInterfaces(),
		ZoneID:                  o.GetZoneID(),
	}
}

// GetID returns value of ID
func (o *VPCRouter) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *VPCRouter) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *VPCRouter) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *VPCRouter) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *VPCRouter) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *VPCRouter) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *VPCRouter) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *VPCRouter) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *VPCRouter) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *VPCRouter) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *VPCRouter) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *VPCRouter) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *VPCRouter) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *VPCRouter) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *VPCRouter) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *VPCRouter) ClearTags() {
	accessor.ClearTags(o)
}

// GetAvailability returns value of Availability
func (o *VPCRouter) GetAvailability() types.EAvailability {
	return o.Availability
}

// SetAvailability sets value to Availability
func (o *VPCRouter) SetAvailability(v types.EAvailability) {
	o.Availability = v
}

// GetClass returns value of Class
func (o *VPCRouter) GetClass() string {
	return o.Class
}

// SetClass sets value to Class
func (o *VPCRouter) SetClass(v string) {
	o.Class = v
}

// GetIconID returns value of IconID
func (o *VPCRouter) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *VPCRouter) SetIconID(v types.ID) {
	o.IconID = v
}

// GetCreatedAt returns value of CreatedAt
func (o *VPCRouter) GetCreatedAt() time.Time {
	return o.CreatedAt
}

// SetCreatedAt sets value to CreatedAt
func (o *VPCRouter) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetPlanID returns value of PlanID
func (o *VPCRouter) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *VPCRouter) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetVersion returns value of Version
func (o *VPCRouter) GetVersion() int {
	if o.Version == 0 {
		return 2
	}
	return o.Version
}

// SetVersion sets value to Version
func (o *VPCRouter) SetVersion(v int) {
	o.Version = v
}

// GetSettings returns value of Settings
func (o *VPCRouter) GetSettings() *VPCRouterSetting {
	return o.Settings
}

// SetSettings sets value to Settings
func (o *VPCRouter) SetSettings(v *VPCRouterSetting) {
	o.Settings = v
}

// GetSettingsHash returns value of SettingsHash
func (o *VPCRouter) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *VPCRouter) SetSettingsHash(v string) {
	o.SettingsHash = v
}

// GetInstanceHostName returns value of InstanceHostName
func (o *VPCRouter) GetInstanceHostName() string {
	return o.InstanceHostName
}

// SetInstanceHostName sets value to InstanceHostName
func (o *VPCRouter) SetInstanceHostName(v string) {
	o.InstanceHostName = v
}

// GetInstanceHostInfoURL returns value of InstanceHostInfoURL
func (o *VPCRouter) GetInstanceHostInfoURL() string {
	return o.InstanceHostInfoURL
}

// SetInstanceHostInfoURL sets value to InstanceHostInfoURL
func (o *VPCRouter) SetInstanceHostInfoURL(v string) {
	o.InstanceHostInfoURL = v
}

// GetInstanceStatus returns value of InstanceStatus
func (o *VPCRouter) GetInstanceStatus() types.EServerInstanceStatus {
	return o.InstanceStatus
}

// SetInstanceStatus sets value to InstanceStatus
func (o *VPCRouter) SetInstanceStatus(v types.EServerInstanceStatus) {
	o.InstanceStatus = v
}

// GetInstanceStatusChangedAt returns value of InstanceStatusChangedAt
func (o *VPCRouter) GetInstanceStatusChangedAt() time.Time {
	return o.InstanceStatusChangedAt
}

// SetInstanceStatusChangedAt sets value to InstanceStatusChangedAt
func (o *VPCRouter) SetInstanceStatusChangedAt(v time.Time) {
	o.InstanceStatusChangedAt = v
}

// GetInterfaces returns value of Interfaces
func (o *VPCRouter) GetInterfaces() []*VPCRouterInterface {
	return o.Interfaces
}

// SetInterfaces sets value to Interfaces
func (o *VPCRouter) SetInterfaces(v []*VPCRouterInterface) {
	o.Interfaces = v
}

// GetZoneID returns value of ZoneID
func (o *VPCRouter) GetZoneID() types.ID {
	return o.ZoneID
}

// SetZoneID sets value to ZoneID
func (o *VPCRouter) SetZoneID(v types.ID) {
	o.ZoneID = v
}

/*************************************************
* VPCRouterSetting
*************************************************/

// VPCRouterSetting represents API parameter/response structure
type VPCRouterSetting struct {
	VRID                      int                            `json:",omitempty" mapconv:"Router.VRID"`
	InternetConnectionEnabled types.StringFlag               `mapconv:"Router.InternetConnection.Enabled"`
	Interfaces                []*VPCRouterInterfaceSetting   `mapconv:"Router.[]Interfaces,omitempty,recursive"`
	StaticNAT                 []*VPCRouterStaticNAT          `mapconv:"Router.StaticNAT.[]Config,omitempty,recursive"`
	PortForwarding            []*VPCRouterPortForwarding     `mapconv:"Router.PortForwarding.[]Config,omitempty,recursive"`
	Firewall                  []*VPCRouterFirewall           `mapconv:"Router.Firewall.[]Config,omitempty,recursive"`
	DHCPServer                []*VPCRouterDHCPServer         `mapconv:"Router.DHCPServer.[]Config,omitempty,recursive"`
	DHCPStaticMapping         []*VPCRouterDHCPStaticMapping  `mapconv:"Router.DHCPStaticMapping.[]Config,omitempty,recursive"`
	DNSForwarding             *VPCRouterDNSForwarding        `mapconv:"Router.DNSForwarding,omitempty,recursive"`
	PPTPServer                *VPCRouterPPTPServer           `mapconv:"Router.PPTPServer.Config,omitempty,recursive"`
	PPTPServerEnabled         types.StringFlag               `mapconv:"Router.PPTPServer.Enabled"`
	L2TPIPsecServer           *VPCRouterL2TPIPsecServer      `mapconv:"Router.L2TPIPsecServer.Config,omitempty,recursive"`
	L2TPIPsecServerEnabled    types.StringFlag               `mapconv:"Router.L2TPIPsecServer.Enabled"`
	WireGuard                 *VPCRouterWireGuard            `mapconv:"Router.WireGuard.Config,omitempty,recursive"`
	WireGuardEnabled          types.StringFlag               `mapconv:"Router.WireGuard.Enabled"`
	RemoteAccessUsers         []*VPCRouterRemoteAccessUser   `mapconv:"Router.RemoteAccessUsers.[]Config,omitempty,recursive"`
	SiteToSiteIPsecVPN        *VPCRouterSiteToSiteIPsecVPN   `mapconv:"Router.SiteToSiteIPsecVPN,omitempty,recursive"`
	StaticRoute               []*VPCRouterStaticRoute        `mapconv:"Router.StaticRoutes.[]Config,omitempty,recursive"`
	SyslogHost                string                         `mapconv:"Router.SyslogHost"`
	ScheduledMaintenance      *VPCRouterScheduledMaintenance `mapconv:"Router.ScheduledMaintenance,omitempty,recursive"`
	MonitoringSuite           *MonitoringSuite               `mapconv:"Router.MonitoringSuite,omitempty,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterSetting) setDefaults() interface{} {
	return &struct {
		VRID                      int                            `json:",omitempty" mapconv:"Router.VRID"`
		InternetConnectionEnabled types.StringFlag               `mapconv:"Router.InternetConnection.Enabled"`
		Interfaces                []*VPCRouterInterfaceSetting   `mapconv:"Router.[]Interfaces,omitempty,recursive"`
		StaticNAT                 []*VPCRouterStaticNAT          `mapconv:"Router.StaticNAT.[]Config,omitempty,recursive"`
		PortForwarding            []*VPCRouterPortForwarding     `mapconv:"Router.PortForwarding.[]Config,omitempty,recursive"`
		Firewall                  []*VPCRouterFirewall           `mapconv:"Router.Firewall.[]Config,omitempty,recursive"`
		DHCPServer                []*VPCRouterDHCPServer         `mapconv:"Router.DHCPServer.[]Config,omitempty,recursive"`
		DHCPStaticMapping         []*VPCRouterDHCPStaticMapping  `mapconv:"Router.DHCPStaticMapping.[]Config,omitempty,recursive"`
		DNSForwarding             *VPCRouterDNSForwarding        `mapconv:"Router.DNSForwarding,omitempty,recursive"`
		PPTPServer                *VPCRouterPPTPServer           `mapconv:"Router.PPTPServer.Config,omitempty,recursive"`
		PPTPServerEnabled         types.StringFlag               `mapconv:"Router.PPTPServer.Enabled"`
		L2TPIPsecServer           *VPCRouterL2TPIPsecServer      `mapconv:"Router.L2TPIPsecServer.Config,omitempty,recursive"`
		L2TPIPsecServerEnabled    types.StringFlag               `mapconv:"Router.L2TPIPsecServer.Enabled"`
		WireGuard                 *VPCRouterWireGuard            `mapconv:"Router.WireGuard.Config,omitempty,recursive"`
		WireGuardEnabled          types.StringFlag               `mapconv:"Router.WireGuard.Enabled"`
		RemoteAccessUsers         []*VPCRouterRemoteAccessUser   `mapconv:"Router.RemoteAccessUsers.[]Config,omitempty,recursive"`
		SiteToSiteIPsecVPN        *VPCRouterSiteToSiteIPsecVPN   `mapconv:"Router.SiteToSiteIPsecVPN,omitempty,recursive"`
		StaticRoute               []*VPCRouterStaticRoute        `mapconv:"Router.StaticRoutes.[]Config,omitempty,recursive"`
		SyslogHost                string                         `mapconv:"Router.SyslogHost"`
		ScheduledMaintenance      *VPCRouterScheduledMaintenance `mapconv:"Router.ScheduledMaintenance,omitempty,recursive"`
		MonitoringSuite           *MonitoringSuite               `mapconv:"Router.MonitoringSuite,omitempty,recursive"`
	}{
		VRID:                      o.GetVRID(),
		InternetConnectionEnabled: o.GetInternetConnectionEnabled(),
		Interfaces:                o.GetInterfaces(),
		StaticNAT:                 o.GetStaticNAT(),
		PortForwarding:            o.GetPortForwarding(),
		Firewall:                  o.GetFirewall(),
		DHCPServer:                o.GetDHCPServer(),
		DHCPStaticMapping:         o.GetDHCPStaticMapping(),
		DNSForwarding:             o.GetDNSForwarding(),
		PPTPServer:                o.GetPPTPServer(),
		PPTPServerEnabled:         o.GetPPTPServerEnabled(),
		L2TPIPsecServer:           o.GetL2TPIPsecServer(),
		L2TPIPsecServerEnabled:    o.GetL2TPIPsecServerEnabled(),
		WireGuard:                 o.GetWireGuard(),
		WireGuardEnabled:          o.GetWireGuardEnabled(),
		RemoteAccessUsers:         o.GetRemoteAccessUsers(),
		SiteToSiteIPsecVPN:        o.GetSiteToSiteIPsecVPN(),
		StaticRoute:               o.GetStaticRoute(),
		SyslogHost:                o.GetSyslogHost(),
		ScheduledMaintenance:      o.GetScheduledMaintenance(),
		MonitoringSuite:           o.GetMonitoringSuite(),
	}
}

// GetVRID returns value of VRID
func (o *VPCRouterSetting) GetVRID() int {
	return o.VRID
}

// SetVRID sets value to VRID
func (o *VPCRouterSetting) SetVRID(v int) {
	o.VRID = v
}

// GetInternetConnectionEnabled returns value of InternetConnectionEnabled
func (o *VPCRouterSetting) GetInternetConnectionEnabled() types.StringFlag {
	return o.InternetConnectionEnabled
}

// SetInternetConnectionEnabled sets value to InternetConnectionEnabled
func (o *VPCRouterSetting) SetInternetConnectionEnabled(v types.StringFlag) {
	o.InternetConnectionEnabled = v
}

// GetInterfaces returns value of Interfaces
func (o *VPCRouterSetting) GetInterfaces() []*VPCRouterInterfaceSetting {
	return o.Interfaces
}

// SetInterfaces sets value to Interfaces
func (o *VPCRouterSetting) SetInterfaces(v []*VPCRouterInterfaceSetting) {
	o.Interfaces = v
}

// GetStaticNAT returns value of StaticNAT
func (o *VPCRouterSetting) GetStaticNAT() []*VPCRouterStaticNAT {
	return o.StaticNAT
}

// SetStaticNAT sets value to StaticNAT
func (o *VPCRouterSetting) SetStaticNAT(v []*VPCRouterStaticNAT) {
	o.StaticNAT = v
}

// GetPortForwarding returns value of PortForwarding
func (o *VPCRouterSetting) GetPortForwarding() []*VPCRouterPortForwarding {
	return o.PortForwarding
}

// SetPortForwarding sets value to PortForwarding
func (o *VPCRouterSetting) SetPortForwarding(v []*VPCRouterPortForwarding) {
	o.PortForwarding = v
}

// GetFirewall returns value of Firewall
func (o *VPCRouterSetting) GetFirewall() []*VPCRouterFirewall {
	return o.Firewall
}

// SetFirewall sets value to Firewall
func (o *VPCRouterSetting) SetFirewall(v []*VPCRouterFirewall) {
	o.Firewall = v
}

// GetDHCPServer returns value of DHCPServer
func (o *VPCRouterSetting) GetDHCPServer() []*VPCRouterDHCPServer {
	return o.DHCPServer
}

// SetDHCPServer sets value to DHCPServer
func (o *VPCRouterSetting) SetDHCPServer(v []*VPCRouterDHCPServer) {
	o.DHCPServer = v
}

// GetDHCPStaticMapping returns value of DHCPStaticMapping
func (o *VPCRouterSetting) GetDHCPStaticMapping() []*VPCRouterDHCPStaticMapping {
	return o.DHCPStaticMapping
}

// SetDHCPStaticMapping sets value to DHCPStaticMapping
func (o *VPCRouterSetting) SetDHCPStaticMapping(v []*VPCRouterDHCPStaticMapping) {
	o.DHCPStaticMapping = v
}

// GetDNSForwarding returns value of DNSForwarding
func (o *VPCRouterSetting) GetDNSForwarding() *VPCRouterDNSForwarding {
	return o.DNSForwarding
}

// SetDNSForwarding sets value to DNSForwarding
func (o *VPCRouterSetting) SetDNSForwarding(v *VPCRouterDNSForwarding) {
	o.DNSForwarding = v
}

// GetPPTPServer returns value of PPTPServer
func (o *VPCRouterSetting) GetPPTPServer() *VPCRouterPPTPServer {
	return o.PPTPServer
}

// SetPPTPServer sets value to PPTPServer
func (o *VPCRouterSetting) SetPPTPServer(v *VPCRouterPPTPServer) {
	o.PPTPServer = v
}

// GetPPTPServerEnabled returns value of PPTPServerEnabled
func (o *VPCRouterSetting) GetPPTPServerEnabled() types.StringFlag {
	return o.PPTPServerEnabled
}

// SetPPTPServerEnabled sets value to PPTPServerEnabled
func (o *VPCRouterSetting) SetPPTPServerEnabled(v types.StringFlag) {
	o.PPTPServerEnabled = v
}

// GetL2TPIPsecServer returns value of L2TPIPsecServer
func (o *VPCRouterSetting) GetL2TPIPsecServer() *VPCRouterL2TPIPsecServer {
	return o.L2TPIPsecServer
}

// SetL2TPIPsecServer sets value to L2TPIPsecServer
func (o *VPCRouterSetting) SetL2TPIPsecServer(v *VPCRouterL2TPIPsecServer) {
	o.L2TPIPsecServer = v
}

// GetL2TPIPsecServerEnabled returns value of L2TPIPsecServerEnabled
func (o *VPCRouterSetting) GetL2TPIPsecServerEnabled() types.StringFlag {
	return o.L2TPIPsecServerEnabled
}

// SetL2TPIPsecServerEnabled sets value to L2TPIPsecServerEnabled
func (o *VPCRouterSetting) SetL2TPIPsecServerEnabled(v types.StringFlag) {
	o.L2TPIPsecServerEnabled = v
}

// GetWireGuard returns value of WireGuard
func (o *VPCRouterSetting) GetWireGuard() *VPCRouterWireGuard {
	return o.WireGuard
}

// SetWireGuard sets value to WireGuard
func (o *VPCRouterSetting) SetWireGuard(v *VPCRouterWireGuard) {
	o.WireGuard = v
}

// GetWireGuardEnabled returns value of WireGuardEnabled
func (o *VPCRouterSetting) GetWireGuardEnabled() types.StringFlag {
	return o.WireGuardEnabled
}

// SetWireGuardEnabled sets value to WireGuardEnabled
func (o *VPCRouterSetting) SetWireGuardEnabled(v types.StringFlag) {
	o.WireGuardEnabled = v
}

// GetRemoteAccessUsers returns value of RemoteAccessUsers
func (o *VPCRouterSetting) GetRemoteAccessUsers() []*VPCRouterRemoteAccessUser {
	return o.RemoteAccessUsers
}

// SetRemoteAccessUsers sets value to RemoteAccessUsers
func (o *VPCRouterSetting) SetRemoteAccessUsers(v []*VPCRouterRemoteAccessUser) {
	o.RemoteAccessUsers = v
}

// GetSiteToSiteIPsecVPN returns value of SiteToSiteIPsecVPN
func (o *VPCRouterSetting) GetSiteToSiteIPsecVPN() *VPCRouterSiteToSiteIPsecVPN {
	return o.SiteToSiteIPsecVPN
}

// SetSiteToSiteIPsecVPN sets value to SiteToSiteIPsecVPN
func (o *VPCRouterSetting) SetSiteToSiteIPsecVPN(v *VPCRouterSiteToSiteIPsecVPN) {
	o.SiteToSiteIPsecVPN = v
}

// GetStaticRoute returns value of StaticRoute
func (o *VPCRouterSetting) GetStaticRoute() []*VPCRouterStaticRoute {
	return o.StaticRoute
}

// SetStaticRoute sets value to StaticRoute
func (o *VPCRouterSetting) SetStaticRoute(v []*VPCRouterStaticRoute) {
	o.StaticRoute = v
}

// GetSyslogHost returns value of SyslogHost
func (o *VPCRouterSetting) GetSyslogHost() string {
	return o.SyslogHost
}

// SetSyslogHost sets value to SyslogHost
func (o *VPCRouterSetting) SetSyslogHost(v string) {
	o.SyslogHost = v
}

// GetScheduledMaintenance returns value of ScheduledMaintenance
func (o *VPCRouterSetting) GetScheduledMaintenance() *VPCRouterScheduledMaintenance {
	return o.ScheduledMaintenance
}

// SetScheduledMaintenance sets value to ScheduledMaintenance
func (o *VPCRouterSetting) SetScheduledMaintenance(v *VPCRouterScheduledMaintenance) {
	o.ScheduledMaintenance = v
}

// GetMonitoringSuite returns value of MonitoringSuite
func (o *VPCRouterSetting) GetMonitoringSuite() *MonitoringSuite {
	return o.MonitoringSuite
}

// SetMonitoringSuite sets value to MonitoringSuite
func (o *VPCRouterSetting) SetMonitoringSuite(v *MonitoringSuite) {
	o.MonitoringSuite = v
}

/*************************************************
* VPCRouterInterfaceSetting
*************************************************/

// VPCRouterInterfaceSetting represents API parameter/response structure
type VPCRouterInterfaceSetting struct {
	IPAddress        []string
	VirtualIPAddress string
	IPAliases        []string
	NetworkMaskLen   int
	Index            int
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterInterfaceSetting) setDefaults() interface{} {
	return &struct {
		IPAddress        []string
		VirtualIPAddress string
		IPAliases        []string
		NetworkMaskLen   int
		Index            int
	}{
		IPAddress:        o.GetIPAddress(),
		VirtualIPAddress: o.GetVirtualIPAddress(),
		IPAliases:        o.GetIPAliases(),
		NetworkMaskLen:   o.GetNetworkMaskLen(),
		Index:            o.GetIndex(),
	}
}

// GetIPAddress returns value of IPAddress
func (o *VPCRouterInterfaceSetting) GetIPAddress() []string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VPCRouterInterfaceSetting) SetIPAddress(v []string) {
	o.IPAddress = v
}

// GetVirtualIPAddress returns value of VirtualIPAddress
func (o *VPCRouterInterfaceSetting) GetVirtualIPAddress() string {
	return o.VirtualIPAddress
}

// SetVirtualIPAddress sets value to VirtualIPAddress
func (o *VPCRouterInterfaceSetting) SetVirtualIPAddress(v string) {
	o.VirtualIPAddress = v
}

// GetIPAliases returns value of IPAliases
func (o *VPCRouterInterfaceSetting) GetIPAliases() []string {
	return o.IPAliases
}

// SetIPAliases sets value to IPAliases
func (o *VPCRouterInterfaceSetting) SetIPAliases(v []string) {
	o.IPAliases = v
}

// GetNetworkMaskLen returns value of NetworkMaskLen
func (o *VPCRouterInterfaceSetting) GetNetworkMaskLen() int {
	return o.NetworkMaskLen
}

// SetNetworkMaskLen sets value to NetworkMaskLen
func (o *VPCRouterInterfaceSetting) SetNetworkMaskLen(v int) {
	o.NetworkMaskLen = v
}

// GetIndex returns value of Index
func (o *VPCRouterInterfaceSetting) GetIndex() int {
	return o.Index
}

// SetIndex sets value to Index
func (o *VPCRouterInterfaceSetting) SetIndex(v int) {
	o.Index = v
}

/*************************************************
* VPCRouterStaticNAT
*************************************************/

// VPCRouterStaticNAT represents API parameter/response structure
type VPCRouterStaticNAT struct {
	GlobalAddress  string `mapconv:"GlobalAddress"`
	PrivateAddress string `mapconv:"PrivateAddress"`
	Description    string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterStaticNAT) setDefaults() interface{} {
	return &struct {
		GlobalAddress  string `mapconv:"GlobalAddress"`
		PrivateAddress string `mapconv:"PrivateAddress"`
		Description    string
	}{
		GlobalAddress:  o.GetGlobalAddress(),
		PrivateAddress: o.GetPrivateAddress(),
		Description:    o.GetDescription(),
	}
}

// GetGlobalAddress returns value of GlobalAddress
func (o *VPCRouterStaticNAT) GetGlobalAddress() string {
	return o.GlobalAddress
}

// SetGlobalAddress sets value to GlobalAddress
func (o *VPCRouterStaticNAT) SetGlobalAddress(v string) {
	o.GlobalAddress = v
}

// GetPrivateAddress returns value of PrivateAddress
func (o *VPCRouterStaticNAT) GetPrivateAddress() string {
	return o.PrivateAddress
}

// SetPrivateAddress sets value to PrivateAddress
func (o *VPCRouterStaticNAT) SetPrivateAddress(v string) {
	o.PrivateAddress = v
}

// GetDescription returns value of Description
func (o *VPCRouterStaticNAT) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *VPCRouterStaticNAT) SetDescription(v string) {
	o.Description = v
}

/*************************************************
* VPCRouterPortForwarding
*************************************************/

// VPCRouterPortForwarding represents API parameter/response structure
type VPCRouterPortForwarding struct {
	Protocol       types.EVPCRouterPortForwardingProtocol
	GlobalPort     types.StringNumber
	PrivateAddress string `mapconv:"PrivateAddress"`
	PrivatePort    types.StringNumber
	Description    string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterPortForwarding) setDefaults() interface{} {
	return &struct {
		Protocol       types.EVPCRouterPortForwardingProtocol
		GlobalPort     types.StringNumber
		PrivateAddress string `mapconv:"PrivateAddress"`
		PrivatePort    types.StringNumber
		Description    string
	}{
		Protocol:       o.GetProtocol(),
		GlobalPort:     o.GetGlobalPort(),
		PrivateAddress: o.GetPrivateAddress(),
		PrivatePort:    o.GetPrivatePort(),
		Description:    o.GetDescription(),
	}
}

// GetProtocol returns value of Protocol
func (o *VPCRouterPortForwarding) GetProtocol() types.EVPCRouterPortForwardingProtocol {
	return o.Protocol
}

// SetProtocol sets value to Protocol
func (o *VPCRouterPortForwarding) SetProtocol(v types.EVPCRouterPortForwardingProtocol) {
	o.Protocol = v
}

// GetGlobalPort returns value of GlobalPort
func (o *VPCRouterPortForwarding) GetGlobalPort() types.StringNumber {
	return o.GlobalPort
}

// SetGlobalPort sets value to GlobalPort
func (o *VPCRouterPortForwarding) SetGlobalPort(v types.StringNumber) {
	o.GlobalPort = v
}

// GetPrivateAddress returns value of PrivateAddress
func (o *VPCRouterPortForwarding) GetPrivateAddress() string {
	return o.PrivateAddress
}

// SetPrivateAddress sets value to PrivateAddress
func (o *VPCRouterPortForwarding) SetPrivateAddress(v string) {
	o.PrivateAddress = v
}

// GetPrivatePort returns value of PrivatePort
func (o *VPCRouterPortForwarding) GetPrivatePort() types.StringNumber {
	return o.PrivatePort
}

// SetPrivatePort sets value to PrivatePort
func (o *VPCRouterPortForwarding) SetPrivatePort(v types.StringNumber) {
	o.PrivatePort = v
}

// GetDescription returns value of Description
func (o *VPCRouterPortForwarding) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *VPCRouterPortForwarding) SetDescription(v string) {
	o.Description = v
}

/*************************************************
* VPCRouterFirewall
*************************************************/

// VPCRouterFirewall represents API parameter/response structure
type VPCRouterFirewall struct {
	Send    []*VPCRouterFirewallRule
	Receive []*VPCRouterFirewallRule
	Index   int
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterFirewall) setDefaults() interface{} {
	return &struct {
		Send    []*VPCRouterFirewallRule
		Receive []*VPCRouterFirewallRule
		Index   int
	}{
		Send:    o.GetSend(),
		Receive: o.GetReceive(),
		Index:   o.GetIndex(),
	}
}

// GetSend returns value of Send
func (o *VPCRouterFirewall) GetSend() []*VPCRouterFirewallRule {
	return o.Send
}

// SetSend sets value to Send
func (o *VPCRouterFirewall) SetSend(v []*VPCRouterFirewallRule) {
	o.Send = v
}

// GetReceive returns value of Receive
func (o *VPCRouterFirewall) GetReceive() []*VPCRouterFirewallRule {
	return o.Receive
}

// SetReceive sets value to Receive
func (o *VPCRouterFirewall) SetReceive(v []*VPCRouterFirewallRule) {
	o.Receive = v
}

// GetIndex returns value of Index
func (o *VPCRouterFirewall) GetIndex() int {
	return o.Index
}

// SetIndex sets value to Index
func (o *VPCRouterFirewall) SetIndex(v int) {
	o.Index = v
}

/*************************************************
* VPCRouterFirewallRule
*************************************************/

// VPCRouterFirewallRule represents API parameter/response structure
type VPCRouterFirewallRule struct {
	Protocol           types.Protocol
	SourceNetwork      types.VPCFirewallNetwork
	SourcePort         types.VPCFirewallPort
	DestinationNetwork types.VPCFirewallNetwork
	DestinationPort    types.VPCFirewallPort
	Action             types.Action
	Logging            types.StringFlag
	Description        string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterFirewallRule) setDefaults() interface{} {
	return &struct {
		Protocol           types.Protocol
		SourceNetwork      types.VPCFirewallNetwork
		SourcePort         types.VPCFirewallPort
		DestinationNetwork types.VPCFirewallNetwork
		DestinationPort    types.VPCFirewallPort
		Action             types.Action
		Logging            types.StringFlag
		Description        string
	}{
		Protocol:           o.GetProtocol(),
		SourceNetwork:      o.GetSourceNetwork(),
		SourcePort:         o.GetSourcePort(),
		DestinationNetwork: o.GetDestinationNetwork(),
		DestinationPort:    o.GetDestinationPort(),
		Action:             o.GetAction(),
		Logging:            o.GetLogging(),
		Description:        o.GetDescription(),
	}
}

// GetProtocol returns value of Protocol
func (o *VPCRouterFirewallRule) GetProtocol() types.Protocol {
	return o.Protocol
}

// SetProtocol sets value to Protocol
func (o *VPCRouterFirewallRule) SetProtocol(v types.Protocol) {
	o.Protocol = v
}

// GetSourceNetwork returns value of SourceNetwork
func (o *VPCRouterFirewallRule) GetSourceNetwork() types.VPCFirewallNetwork {
	return o.SourceNetwork
}

// SetSourceNetwork sets value to SourceNetwork
func (o *VPCRouterFirewallRule) SetSourceNetwork(v types.VPCFirewallNetwork) {
	o.SourceNetwork = v
}

// GetSourcePort returns value of SourcePort
func (o *VPCRouterFirewallRule) GetSourcePort() types.VPCFirewallPort {
	return o.SourcePort
}

// SetSourcePort sets value to SourcePort
func (o *VPCRouterFirewallRule) SetSourcePort(v types.VPCFirewallPort) {
	o.SourcePort = v
}

// GetDestinationNetwork returns value of DestinationNetwork
func (o *VPCRouterFirewallRule) GetDestinationNetwork() types.VPCFirewallNetwork {
	return o.DestinationNetwork
}

// SetDestinationNetwork sets value to DestinationNetwork
func (o *VPCRouterFirewallRule) SetDestinationNetwork(v types.VPCFirewallNetwork) {
	o.DestinationNetwork = v
}

// GetDestinationPort returns value of DestinationPort
func (o *VPCRouterFirewallRule) GetDestinationPort() types.VPCFirewallPort {
	return o.DestinationPort
}

// SetDestinationPort sets value to DestinationPort
func (o *VPCRouterFirewallRule) SetDestinationPort(v types.VPCFirewallPort) {
	o.DestinationPort = v
}

// GetAction returns value of Action
func (o *VPCRouterFirewallRule) GetAction() types.Action {
	return o.Action
}

// SetAction sets value to Action
func (o *VPCRouterFirewallRule) SetAction(v types.Action) {
	o.Action = v
}

// GetLogging returns value of Logging
func (o *VPCRouterFirewallRule) GetLogging() types.StringFlag {
	return o.Logging
}

// SetLogging sets value to Logging
func (o *VPCRouterFirewallRule) SetLogging(v types.StringFlag) {
	o.Logging = v
}

// GetDescription returns value of Description
func (o *VPCRouterFirewallRule) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *VPCRouterFirewallRule) SetDescription(v string) {
	o.Description = v
}

/*************************************************
* VPCRouterDHCPServer
*************************************************/

// VPCRouterDHCPServer represents API parameter/response structure
type VPCRouterDHCPServer struct {
	Interface  string
	RangeStart string
	RangeStop  string
	DNSServers []string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterDHCPServer) setDefaults() interface{} {
	return &struct {
		Interface  string
		RangeStart string
		RangeStop  string
		DNSServers []string
	}{
		Interface:  o.GetInterface(),
		RangeStart: o.GetRangeStart(),
		RangeStop:  o.GetRangeStop(),
		DNSServers: o.GetDNSServers(),
	}
}

// GetInterface returns value of Interface
func (o *VPCRouterDHCPServer) GetInterface() string {
	return o.Interface
}

// SetInterface sets value to Interface
func (o *VPCRouterDHCPServer) SetInterface(v string) {
	o.Interface = v
}

// GetRangeStart returns value of RangeStart
func (o *VPCRouterDHCPServer) GetRangeStart() string {
	return o.RangeStart
}

// SetRangeStart sets value to RangeStart
func (o *VPCRouterDHCPServer) SetRangeStart(v string) {
	o.RangeStart = v
}

// GetRangeStop returns value of RangeStop
func (o *VPCRouterDHCPServer) GetRangeStop() string {
	return o.RangeStop
}

// SetRangeStop sets value to RangeStop
func (o *VPCRouterDHCPServer) SetRangeStop(v string) {
	o.RangeStop = v
}

// GetDNSServers returns value of DNSServers
func (o *VPCRouterDHCPServer) GetDNSServers() []string {
	return o.DNSServers
}

// SetDNSServers sets value to DNSServers
func (o *VPCRouterDHCPServer) SetDNSServers(v []string) {
	o.DNSServers = v
}

/*************************************************
* VPCRouterDHCPStaticMapping
*************************************************/

// VPCRouterDHCPStaticMapping represents API parameter/response structure
type VPCRouterDHCPStaticMapping struct {
	MACAddress string
	IPAddress  string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterDHCPStaticMapping) setDefaults() interface{} {
	return &struct {
		MACAddress string
		IPAddress  string
	}{
		MACAddress: o.GetMACAddress(),
		IPAddress:  o.GetIPAddress(),
	}
}

// GetMACAddress returns value of MACAddress
func (o *VPCRouterDHCPStaticMapping) GetMACAddress() string {
	return o.MACAddress
}

// SetMACAddress sets value to MACAddress
func (o *VPCRouterDHCPStaticMapping) SetMACAddress(v string) {
	o.MACAddress = v
}

// GetIPAddress returns value of IPAddress
func (o *VPCRouterDHCPStaticMapping) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VPCRouterDHCPStaticMapping) SetIPAddress(v string) {
	o.IPAddress = v
}

/*************************************************
* VPCRouterDNSForwarding
*************************************************/

// VPCRouterDNSForwarding represents API parameter/response structure
type VPCRouterDNSForwarding struct {
	Interface  string
	DNSServers []string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterDNSForwarding) setDefaults() interface{} {
	return &struct {
		Interface  string
		DNSServers []string
	}{
		Interface:  o.GetInterface(),
		DNSServers: o.GetDNSServers(),
	}
}

// GetInterface returns value of Interface
func (o *VPCRouterDNSForwarding) GetInterface() string {
	return o.Interface
}

// SetInterface sets value to Interface
func (o *VPCRouterDNSForwarding) SetInterface(v string) {
	o.Interface = v
}

// GetDNSServers returns value of DNSServers
func (o *VPCRouterDNSForwarding) GetDNSServers() []string {
	return o.DNSServers
}

// SetDNSServers sets value to DNSServers
func (o *VPCRouterDNSForwarding) SetDNSServers(v []string) {
	o.DNSServers = v
}

/*************************************************
* VPCRouterPPTPServer
*************************************************/

// VPCRouterPPTPServer represents API parameter/response structure
type VPCRouterPPTPServer struct {
	RangeStart string
	RangeStop  string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterPPTPServer) setDefaults() interface{} {
	return &struct {
		RangeStart string
		RangeStop  string
	}{
		RangeStart: o.GetRangeStart(),
		RangeStop:  o.GetRangeStop(),
	}
}

// GetRangeStart returns value of RangeStart
func (o *VPCRouterPPTPServer) GetRangeStart() string {
	return o.RangeStart
}

// SetRangeStart sets value to RangeStart
func (o *VPCRouterPPTPServer) SetRangeStart(v string) {
	o.RangeStart = v
}

// GetRangeStop returns value of RangeStop
func (o *VPCRouterPPTPServer) GetRangeStop() string {
	return o.RangeStop
}

// SetRangeStop sets value to RangeStop
func (o *VPCRouterPPTPServer) SetRangeStop(v string) {
	o.RangeStop = v
}

/*************************************************
* VPCRouterL2TPIPsecServer
*************************************************/

// VPCRouterL2TPIPsecServer represents API parameter/response structure
type VPCRouterL2TPIPsecServer struct {
	RangeStart      string
	RangeStop       string
	PreSharedSecret string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterL2TPIPsecServer) setDefaults() interface{} {
	return &struct {
		RangeStart      string
		RangeStop       string
		PreSharedSecret string
	}{
		RangeStart:      o.GetRangeStart(),
		RangeStop:       o.GetRangeStop(),
		PreSharedSecret: o.GetPreSharedSecret(),
	}
}

// GetRangeStart returns value of RangeStart
func (o *VPCRouterL2TPIPsecServer) GetRangeStart() string {
	return o.RangeStart
}

// SetRangeStart sets value to RangeStart
func (o *VPCRouterL2TPIPsecServer) SetRangeStart(v string) {
	o.RangeStart = v
}

// GetRangeStop returns value of RangeStop
func (o *VPCRouterL2TPIPsecServer) GetRangeStop() string {
	return o.RangeStop
}

// SetRangeStop sets value to RangeStop
func (o *VPCRouterL2TPIPsecServer) SetRangeStop(v string) {
	o.RangeStop = v
}

// GetPreSharedSecret returns value of PreSharedSecret
func (o *VPCRouterL2TPIPsecServer) GetPreSharedSecret() string {
	return o.PreSharedSecret
}

// SetPreSharedSecret sets value to PreSharedSecret
func (o *VPCRouterL2TPIPsecServer) SetPreSharedSecret(v string) {
	o.PreSharedSecret = v
}

/*************************************************
* VPCRouterWireGuard
*************************************************/

// VPCRouterWireGuard represents API parameter/response structure
type VPCRouterWireGuard struct {
	IPAddress string
	Peers     []*VPCRouterWireGuardPeer `mapconv:"[]Peers,omitempty,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterWireGuard) setDefaults() interface{} {
	return &struct {
		IPAddress string
		Peers     []*VPCRouterWireGuardPeer `mapconv:"[]Peers,omitempty,recursive"`
	}{
		IPAddress: o.GetIPAddress(),
		Peers:     o.GetPeers(),
	}
}

// GetIPAddress returns value of IPAddress
func (o *VPCRouterWireGuard) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VPCRouterWireGuard) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetPeers returns value of Peers
func (o *VPCRouterWireGuard) GetPeers() []*VPCRouterWireGuardPeer {
	return o.Peers
}

// SetPeers sets value to Peers
func (o *VPCRouterWireGuard) SetPeers(v []*VPCRouterWireGuardPeer) {
	o.Peers = v
}

/*************************************************
* VPCRouterWireGuardPeer
*************************************************/

// VPCRouterWireGuardPeer represents API parameter/response structure
type VPCRouterWireGuardPeer struct {
	Name      string
	IPAddress string
	PublicKey string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterWireGuardPeer) setDefaults() interface{} {
	return &struct {
		Name      string
		IPAddress string
		PublicKey string
	}{
		Name:      o.GetName(),
		IPAddress: o.GetIPAddress(),
		PublicKey: o.GetPublicKey(),
	}
}

// GetName returns value of Name
func (o *VPCRouterWireGuardPeer) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *VPCRouterWireGuardPeer) SetName(v string) {
	o.Name = v
}

// GetIPAddress returns value of IPAddress
func (o *VPCRouterWireGuardPeer) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VPCRouterWireGuardPeer) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetPublicKey returns value of PublicKey
func (o *VPCRouterWireGuardPeer) GetPublicKey() string {
	return o.PublicKey
}

// SetPublicKey sets value to PublicKey
func (o *VPCRouterWireGuardPeer) SetPublicKey(v string) {
	o.PublicKey = v
}

/*************************************************
* VPCRouterRemoteAccessUser
*************************************************/

// VPCRouterRemoteAccessUser represents API parameter/response structure
type VPCRouterRemoteAccessUser struct {
	UserName string
	Password string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterRemoteAccessUser) setDefaults() interface{} {
	return &struct {
		UserName string
		Password string
	}{
		UserName: o.GetUserName(),
		Password: o.GetPassword(),
	}
}

// GetUserName returns value of UserName
func (o *VPCRouterRemoteAccessUser) GetUserName() string {
	return o.UserName
}

// SetUserName sets value to UserName
func (o *VPCRouterRemoteAccessUser) SetUserName(v string) {
	o.UserName = v
}

// GetPassword returns value of Password
func (o *VPCRouterRemoteAccessUser) GetPassword() string {
	return o.Password
}

// SetPassword sets value to Password
func (o *VPCRouterRemoteAccessUser) SetPassword(v string) {
	o.Password = v
}

/*************************************************
* VPCRouterSiteToSiteIPsecVPN
*************************************************/

// VPCRouterSiteToSiteIPsecVPN represents API parameter/response structure
type VPCRouterSiteToSiteIPsecVPN struct {
	Config         []*VPCRouterSiteToSiteIPsecVPNConfig `mapconv:"[]Config,omitempty,recursive"`
	IKE            *VPCRouterSiteToSiteIPsecVPNIKE      `mapconv:",omitempty,recursive"`
	ESP            *VPCRouterSiteToSiteIPsecVPNESP      `mapconv:",omitempty,recursive"`
	EncryptionAlgo string
	HashAlgo       string
	DHGroup        string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterSiteToSiteIPsecVPN) setDefaults() interface{} {
	return &struct {
		Config         []*VPCRouterSiteToSiteIPsecVPNConfig `mapconv:"[]Config,omitempty,recursive"`
		IKE            *VPCRouterSiteToSiteIPsecVPNIKE      `mapconv:",omitempty,recursive"`
		ESP            *VPCRouterSiteToSiteIPsecVPNESP      `mapconv:",omitempty,recursive"`
		EncryptionAlgo string
		HashAlgo       string
		DHGroup        string
	}{
		Config:         o.GetConfig(),
		IKE:            o.GetIKE(),
		ESP:            o.GetESP(),
		EncryptionAlgo: o.GetEncryptionAlgo(),
		HashAlgo:       o.GetHashAlgo(),
		DHGroup:        o.GetDHGroup(),
	}
}

// GetConfig returns value of Config
func (o *VPCRouterSiteToSiteIPsecVPN) GetConfig() []*VPCRouterSiteToSiteIPsecVPNConfig {
	return o.Config
}

// SetConfig sets value to Config
func (o *VPCRouterSiteToSiteIPsecVPN) SetConfig(v []*VPCRouterSiteToSiteIPsecVPNConfig) {
	o.Config = v
}

// GetIKE returns value of IKE
func (o *VPCRouterSiteToSiteIPsecVPN) GetIKE() *VPCRouterSiteToSiteIPsecVPNIKE {
	return o.IKE
}

// SetIKE sets value to IKE
func (o *VPCRouterSiteToSiteIPsecVPN) SetIKE(v *VPCRouterSiteToSiteIPsecVPNIKE) {
	o.IKE = v
}

// GetESP returns value of ESP
func (o *VPCRouterSiteToSiteIPsecVPN) GetESP() *VPCRouterSiteToSiteIPsecVPNESP {
	return o.ESP
}

// SetESP sets value to ESP
func (o *VPCRouterSiteToSiteIPsecVPN) SetESP(v *VPCRouterSiteToSiteIPsecVPNESP) {
	o.ESP = v
}

// GetEncryptionAlgo returns value of EncryptionAlgo
func (o *VPCRouterSiteToSiteIPsecVPN) GetEncryptionAlgo() string {
	return o.EncryptionAlgo
}

// SetEncryptionAlgo sets value to EncryptionAlgo
func (o *VPCRouterSiteToSiteIPsecVPN) SetEncryptionAlgo(v string) {
	o.EncryptionAlgo = v
}

// GetHashAlgo returns value of HashAlgo
func (o *VPCRouterSiteToSiteIPsecVPN) GetHashAlgo() string {
	return o.HashAlgo
}

// SetHashAlgo sets value to HashAlgo
func (o *VPCRouterSiteToSiteIPsecVPN) SetHashAlgo(v string) {
	o.HashAlgo = v
}

// GetDHGroup returns value of DHGroup
func (o *VPCRouterSiteToSiteIPsecVPN) GetDHGroup() string {
	return o.DHGroup
}

// SetDHGroup sets value to DHGroup
func (o *VPCRouterSiteToSiteIPsecVPN) SetDHGroup(v string) {
	o.DHGroup = v
}

/*************************************************
* VPCRouterSiteToSiteIPsecVPNConfig
*************************************************/

// VPCRouterSiteToSiteIPsecVPNConfig represents API parameter/response structure
type VPCRouterSiteToSiteIPsecVPNConfig struct {
	Peer            string
	PreSharedSecret string
	RemoteID        string
	Routes          []string
	LocalPrefix     []string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterSiteToSiteIPsecVPNConfig) setDefaults() interface{} {
	return &struct {
		Peer            string
		PreSharedSecret string
		RemoteID        string
		Routes          []string
		LocalPrefix     []string
	}{
		Peer:            o.GetPeer(),
		PreSharedSecret: o.GetPreSharedSecret(),
		RemoteID:        o.GetRemoteID(),
		Routes:          o.GetRoutes(),
		LocalPrefix:     o.GetLocalPrefix(),
	}
}

// GetPeer returns value of Peer
func (o *VPCRouterSiteToSiteIPsecVPNConfig) GetPeer() string {
	return o.Peer
}

// SetPeer sets value to Peer
func (o *VPCRouterSiteToSiteIPsecVPNConfig) SetPeer(v string) {
	o.Peer = v
}

// GetPreSharedSecret returns value of PreSharedSecret
func (o *VPCRouterSiteToSiteIPsecVPNConfig) GetPreSharedSecret() string {
	return o.PreSharedSecret
}

// SetPreSharedSecret sets value to PreSharedSecret
func (o *VPCRouterSiteToSiteIPsecVPNConfig) SetPreSharedSecret(v string) {
	o.PreSharedSecret = v
}

// GetRemoteID returns value of RemoteID
func (o *VPCRouterSiteToSiteIPsecVPNConfig) GetRemoteID() string {
	return o.RemoteID
}

// SetRemoteID sets value to RemoteID
func (o *VPCRouterSiteToSiteIPsecVPNConfig) SetRemoteID(v string) {
	o.RemoteID = v
}

// GetRoutes returns value of Routes
func (o *VPCRouterSiteToSiteIPsecVPNConfig) GetRoutes() []string {
	return o.Routes
}

// SetRoutes sets value to Routes
func (o *VPCRouterSiteToSiteIPsecVPNConfig) SetRoutes(v []string) {
	o.Routes = v
}

// GetLocalPrefix returns value of LocalPrefix
func (o *VPCRouterSiteToSiteIPsecVPNConfig) GetLocalPrefix() []string {
	return o.LocalPrefix
}

// SetLocalPrefix sets value to LocalPrefix
func (o *VPCRouterSiteToSiteIPsecVPNConfig) SetLocalPrefix(v []string) {
	o.LocalPrefix = v
}

/*************************************************
* VPCRouterSiteToSiteIPsecVPNIKE
*************************************************/

// VPCRouterSiteToSiteIPsecVPNIKE represents API parameter/response structure
type VPCRouterSiteToSiteIPsecVPNIKE struct {
	Lifetime int
	DPD      *VPCRouterSiteToSiteIPsecVPNIKEDPD `mapconv:",omitempty,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterSiteToSiteIPsecVPNIKE) setDefaults() interface{} {
	return &struct {
		Lifetime int
		DPD      *VPCRouterSiteToSiteIPsecVPNIKEDPD `mapconv:",omitempty,recursive"`
	}{
		Lifetime: o.GetLifetime(),
		DPD:      o.GetDPD(),
	}
}

// GetLifetime returns value of Lifetime
func (o *VPCRouterSiteToSiteIPsecVPNIKE) GetLifetime() int {
	return o.Lifetime
}

// SetLifetime sets value to Lifetime
func (o *VPCRouterSiteToSiteIPsecVPNIKE) SetLifetime(v int) {
	o.Lifetime = v
}

// GetDPD returns value of DPD
func (o *VPCRouterSiteToSiteIPsecVPNIKE) GetDPD() *VPCRouterSiteToSiteIPsecVPNIKEDPD {
	return o.DPD
}

// SetDPD sets value to DPD
func (o *VPCRouterSiteToSiteIPsecVPNIKE) SetDPD(v *VPCRouterSiteToSiteIPsecVPNIKEDPD) {
	o.DPD = v
}

/*************************************************
* VPCRouterSiteToSiteIPsecVPNIKEDPD
*************************************************/

// VPCRouterSiteToSiteIPsecVPNIKEDPD represents API parameter/response structure
type VPCRouterSiteToSiteIPsecVPNIKEDPD struct {
	Interval int
	Timeout  int
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterSiteToSiteIPsecVPNIKEDPD) setDefaults() interface{} {
	return &struct {
		Interval int
		Timeout  int
	}{
		Interval: o.GetInterval(),
		Timeout:  o.GetTimeout(),
	}
}

// GetInterval returns value of Interval
func (o *VPCRouterSiteToSiteIPsecVPNIKEDPD) GetInterval() int {
	return o.Interval
}

// SetInterval sets value to Interval
func (o *VPCRouterSiteToSiteIPsecVPNIKEDPD) SetInterval(v int) {
	o.Interval = v
}

// GetTimeout returns value of Timeout
func (o *VPCRouterSiteToSiteIPsecVPNIKEDPD) GetTimeout() int {
	return o.Timeout
}

// SetTimeout sets value to Timeout
func (o *VPCRouterSiteToSiteIPsecVPNIKEDPD) SetTimeout(v int) {
	o.Timeout = v
}

/*************************************************
* VPCRouterSiteToSiteIPsecVPNESP
*************************************************/

// VPCRouterSiteToSiteIPsecVPNESP represents API parameter/response structure
type VPCRouterSiteToSiteIPsecVPNESP struct {
	Lifetime int
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterSiteToSiteIPsecVPNESP) setDefaults() interface{} {
	return &struct {
		Lifetime int
	}{
		Lifetime: o.GetLifetime(),
	}
}

// GetLifetime returns value of Lifetime
func (o *VPCRouterSiteToSiteIPsecVPNESP) GetLifetime() int {
	return o.Lifetime
}

// SetLifetime sets value to Lifetime
func (o *VPCRouterSiteToSiteIPsecVPNESP) SetLifetime(v int) {
	o.Lifetime = v
}

/*************************************************
* VPCRouterStaticRoute
*************************************************/

// VPCRouterStaticRoute represents API parameter/response structure
type VPCRouterStaticRoute struct {
	Prefix  string
	NextHop string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterStaticRoute) setDefaults() interface{} {
	return &struct {
		Prefix  string
		NextHop string
	}{
		Prefix:  o.GetPrefix(),
		NextHop: o.GetNextHop(),
	}
}

// GetPrefix returns value of Prefix
func (o *VPCRouterStaticRoute) GetPrefix() string {
	return o.Prefix
}

// SetPrefix sets value to Prefix
func (o *VPCRouterStaticRoute) SetPrefix(v string) {
	o.Prefix = v
}

// GetNextHop returns value of NextHop
func (o *VPCRouterStaticRoute) GetNextHop() string {
	return o.NextHop
}

// SetNextHop sets value to NextHop
func (o *VPCRouterStaticRoute) SetNextHop(v string) {
	o.NextHop = v
}

/*************************************************
* VPCRouterScheduledMaintenance
*************************************************/

// VPCRouterScheduledMaintenance represents API parameter/response structure
type VPCRouterScheduledMaintenance struct {
	DayOfWeek int
	Hour      int
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterScheduledMaintenance) setDefaults() interface{} {
	return &struct {
		DayOfWeek int
		Hour      int
	}{
		DayOfWeek: o.GetDayOfWeek(),
		Hour:      o.GetHour(),
	}
}

// GetDayOfWeek returns value of DayOfWeek
func (o *VPCRouterScheduledMaintenance) GetDayOfWeek() int {
	return o.DayOfWeek
}

// SetDayOfWeek sets value to DayOfWeek
func (o *VPCRouterScheduledMaintenance) SetDayOfWeek(v int) {
	o.DayOfWeek = v
}

// GetHour returns value of Hour
func (o *VPCRouterScheduledMaintenance) GetHour() int {
	return o.Hour
}

// SetHour sets value to Hour
func (o *VPCRouterScheduledMaintenance) SetHour(v int) {
	o.Hour = v
}

/*************************************************
* VPCRouterInterface
*************************************************/

// VPCRouterInterface represents API parameter/response structure
type VPCRouterInterface struct {
	ID                              types.ID
	MACAddress                      string
	IPAddress                       string
	UserIPAddress                   string
	HostName                        string
	SwitchID                        types.ID           `mapconv:"Switch.ID"`
	SwitchName                      string             `mapconv:"Switch.Name"`
	SwitchScope                     types.EScope       `mapconv:"Switch.Scope"`
	UserSubnetDefaultRoute          string             `mapconv:"Switch.UserSubnet.DefaultRoute"`
	UserSubnetNetworkMaskLen        int                `mapconv:"Switch.UserSubnet.NetworkMaskLen"`
	SubnetDefaultRoute              string             `mapconv:"Switch.Subnet.DefaultRoute"`
	SubnetNetworkMaskLen            int                `mapconv:"Switch.Subnet.NetworkMaskLen"`
	SubnetNetworkAddress            string             `mapconv:"Switch.Subnet.NetworkAddress"`
	SubnetBandWidthMbps             int                `mapconv:"Switch.Subnet.Internet.BandWidthMbps"`
	PacketFilterID                  types.ID           `mapconv:"PacketFilter.ID"`
	PacketFilterName                string             `mapconv:"PacketFilter.Name"`
	PacketFilterRequiredHostVersion types.StringNumber `mapconv:"PacketFilter.RequiredHostVersionn"`
	UpstreamType                    types.EUpstreamNetworkType
	Index                           int `mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterInterface) setDefaults() interface{} {
	return &struct {
		ID                              types.ID
		MACAddress                      string
		IPAddress                       string
		UserIPAddress                   string
		HostName                        string
		SwitchID                        types.ID           `mapconv:"Switch.ID"`
		SwitchName                      string             `mapconv:"Switch.Name"`
		SwitchScope                     types.EScope       `mapconv:"Switch.Scope"`
		UserSubnetDefaultRoute          string             `mapconv:"Switch.UserSubnet.DefaultRoute"`
		UserSubnetNetworkMaskLen        int                `mapconv:"Switch.UserSubnet.NetworkMaskLen"`
		SubnetDefaultRoute              string             `mapconv:"Switch.Subnet.DefaultRoute"`
		SubnetNetworkMaskLen            int                `mapconv:"Switch.Subnet.NetworkMaskLen"`
		SubnetNetworkAddress            string             `mapconv:"Switch.Subnet.NetworkAddress"`
		SubnetBandWidthMbps             int                `mapconv:"Switch.Subnet.Internet.BandWidthMbps"`
		PacketFilterID                  types.ID           `mapconv:"PacketFilter.ID"`
		PacketFilterName                string             `mapconv:"PacketFilter.Name"`
		PacketFilterRequiredHostVersion types.StringNumber `mapconv:"PacketFilter.RequiredHostVersionn"`
		UpstreamType                    types.EUpstreamNetworkType
		Index                           int `mapconv:",omitempty"`
	}{
		ID:                              o.GetID(),
		MACAddress:                      o.GetMACAddress(),
		IPAddress:                       o.GetIPAddress(),
		UserIPAddress:                   o.GetUserIPAddress(),
		HostName:                        o.GetHostName(),
		SwitchID:                        o.GetSwitchID(),
		SwitchName:                      o.GetSwitchName(),
		SwitchScope:                     o.GetSwitchScope(),
		UserSubnetDefaultRoute:          o.GetUserSubnetDefaultRoute(),
		UserSubnetNetworkMaskLen:        o.GetUserSubnetNetworkMaskLen(),
		SubnetDefaultRoute:              o.GetSubnetDefaultRoute(),
		SubnetNetworkMaskLen:            o.GetSubnetNetworkMaskLen(),
		SubnetNetworkAddress:            o.GetSubnetNetworkAddress(),
		SubnetBandWidthMbps:             o.GetSubnetBandWidthMbps(),
		PacketFilterID:                  o.GetPacketFilterID(),
		PacketFilterName:                o.GetPacketFilterName(),
		PacketFilterRequiredHostVersion: o.GetPacketFilterRequiredHostVersion(),
		UpstreamType:                    o.GetUpstreamType(),
		Index:                           o.GetIndex(),
	}
}

// GetID returns value of ID
func (o *VPCRouterInterface) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *VPCRouterInterface) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *VPCRouterInterface) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *VPCRouterInterface) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *VPCRouterInterface) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *VPCRouterInterface) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetMACAddress returns value of MACAddress
func (o *VPCRouterInterface) GetMACAddress() string {
	return o.MACAddress
}

// SetMACAddress sets value to MACAddress
func (o *VPCRouterInterface) SetMACAddress(v string) {
	o.MACAddress = v
}

// GetIPAddress returns value of IPAddress
func (o *VPCRouterInterface) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VPCRouterInterface) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetUserIPAddress returns value of UserIPAddress
func (o *VPCRouterInterface) GetUserIPAddress() string {
	return o.UserIPAddress
}

// SetUserIPAddress sets value to UserIPAddress
func (o *VPCRouterInterface) SetUserIPAddress(v string) {
	o.UserIPAddress = v
}

// GetHostName returns value of HostName
func (o *VPCRouterInterface) GetHostName() string {
	return o.HostName
}

// SetHostName sets value to HostName
func (o *VPCRouterInterface) SetHostName(v string) {
	o.HostName = v
}

// GetSwitchID returns value of SwitchID
func (o *VPCRouterInterface) GetSwitchID() types.ID {
	return o.SwitchID
}

// SetSwitchID sets value to SwitchID
func (o *VPCRouterInterface) SetSwitchID(v types.ID) {
	o.SwitchID = v
}

// GetSwitchName returns value of SwitchName
func (o *VPCRouterInterface) GetSwitchName() string {
	return o.SwitchName
}

// SetSwitchName sets value to SwitchName
func (o *VPCRouterInterface) SetSwitchName(v string) {
	o.SwitchName = v
}

// GetSwitchScope returns value of SwitchScope
func (o *VPCRouterInterface) GetSwitchScope() types.EScope {
	return o.SwitchScope
}

// SetSwitchScope sets value to SwitchScope
func (o *VPCRouterInterface) SetSwitchScope(v types.EScope) {
	o.SwitchScope = v
}

// GetUserSubnetDefaultRoute returns value of UserSubnetDefaultRoute
func (o *VPCRouterInterface) GetUserSubnetDefaultRoute() string {
	return o.UserSubnetDefaultRoute
}

// SetUserSubnetDefaultRoute sets value to UserSubnetDefaultRoute
func (o *VPCRouterInterface) SetUserSubnetDefaultRoute(v string) {
	o.UserSubnetDefaultRoute = v
}

// GetUserSubnetNetworkMaskLen returns value of UserSubnetNetworkMaskLen
func (o *VPCRouterInterface) GetUserSubnetNetworkMaskLen() int {
	return o.UserSubnetNetworkMaskLen
}

// SetUserSubnetNetworkMaskLen sets value to UserSubnetNetworkMaskLen
func (o *VPCRouterInterface) SetUserSubnetNetworkMaskLen(v int) {
	o.UserSubnetNetworkMaskLen = v
}

// GetSubnetDefaultRoute returns value of SubnetDefaultRoute
func (o *VPCRouterInterface) GetSubnetDefaultRoute() string {
	return o.SubnetDefaultRoute
}

// SetSubnetDefaultRoute sets value to SubnetDefaultRoute
func (o *VPCRouterInterface) SetSubnetDefaultRoute(v string) {
	o.SubnetDefaultRoute = v
}

// GetSubnetNetworkMaskLen returns value of SubnetNetworkMaskLen
func (o *VPCRouterInterface) GetSubnetNetworkMaskLen() int {
	return o.SubnetNetworkMaskLen
}

// SetSubnetNetworkMaskLen sets value to SubnetNetworkMaskLen
func (o *VPCRouterInterface) SetSubnetNetworkMaskLen(v int) {
	o.SubnetNetworkMaskLen = v
}

// GetSubnetNetworkAddress returns value of SubnetNetworkAddress
func (o *VPCRouterInterface) GetSubnetNetworkAddress() string {
	return o.SubnetNetworkAddress
}

// SetSubnetNetworkAddress sets value to SubnetNetworkAddress
func (o *VPCRouterInterface) SetSubnetNetworkAddress(v string) {
	o.SubnetNetworkAddress = v
}

// GetSubnetBandWidthMbps returns value of SubnetBandWidthMbps
func (o *VPCRouterInterface) GetSubnetBandWidthMbps() int {
	return o.SubnetBandWidthMbps
}

// SetSubnetBandWidthMbps sets value to SubnetBandWidthMbps
func (o *VPCRouterInterface) SetSubnetBandWidthMbps(v int) {
	o.SubnetBandWidthMbps = v
}

// GetPacketFilterID returns value of PacketFilterID
func (o *VPCRouterInterface) GetPacketFilterID() types.ID {
	return o.PacketFilterID
}

// SetPacketFilterID sets value to PacketFilterID
func (o *VPCRouterInterface) SetPacketFilterID(v types.ID) {
	o.PacketFilterID = v
}

// GetPacketFilterName returns value of PacketFilterName
func (o *VPCRouterInterface) GetPacketFilterName() string {
	return o.PacketFilterName
}

// SetPacketFilterName sets value to PacketFilterName
func (o *VPCRouterInterface) SetPacketFilterName(v string) {
	o.PacketFilterName = v
}

// GetPacketFilterRequiredHostVersion returns value of PacketFilterRequiredHostVersion
func (o *VPCRouterInterface) GetPacketFilterRequiredHostVersion() types.StringNumber {
	return o.PacketFilterRequiredHostVersion
}

// SetPacketFilterRequiredHostVersion sets value to PacketFilterRequiredHostVersion
func (o *VPCRouterInterface) SetPacketFilterRequiredHostVersion(v types.StringNumber) {
	o.PacketFilterRequiredHostVersion = v
}

// GetUpstreamType returns value of UpstreamType
func (o *VPCRouterInterface) GetUpstreamType() types.EUpstreamNetworkType {
	return o.UpstreamType
}

// SetUpstreamType sets value to UpstreamType
func (o *VPCRouterInterface) SetUpstreamType(v types.EUpstreamNetworkType) {
	o.UpstreamType = v
}

// GetIndex returns value of Index
func (o *VPCRouterInterface) GetIndex() int {
	return o.Index
}

// SetIndex sets value to Index
func (o *VPCRouterInterface) SetIndex(v int) {
	o.Index = v
}

/*************************************************
* VPCRouterCreateRequest
*************************************************/

// VPCRouterCreateRequest represents API parameter/response structure
type VPCRouterCreateRequest struct {
	Name        string
	Description string
	Tags        types.Tags
	IconID      types.ID                  `mapconv:"Icon.ID"`
	PlanID      types.ID                  `mapconv:"Plan.ID"`
	Switch      *ApplianceConnectedSwitch `json:",omitempty" mapconv:"Remark.Switch,recursive"`
	IPAddresses []string                  `mapconv:"Remark.[]Servers.IPAddress"`
	Version     int                       `mapconv:"Remark.Router.VPCRouterVersion"`
	Settings    *VPCRouterSetting         `mapconv:",omitempty,recursive"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterCreateRequest) setDefaults() interface{} {
	return &struct {
		Name        string
		Description string
		Tags        types.Tags
		IconID      types.ID                  `mapconv:"Icon.ID"`
		PlanID      types.ID                  `mapconv:"Plan.ID"`
		Switch      *ApplianceConnectedSwitch `json:",omitempty" mapconv:"Remark.Switch,recursive"`
		IPAddresses []string                  `mapconv:"Remark.[]Servers.IPAddress"`
		Version     int                       `mapconv:"Remark.Router.VPCRouterVersion"`
		Settings    *VPCRouterSetting         `mapconv:",omitempty,recursive"`
		Class       string
	}{
		Name:        o.GetName(),
		Description: o.GetDescription(),
		Tags:        o.GetTags(),
		IconID:      o.GetIconID(),
		PlanID:      o.GetPlanID(),
		Switch:      o.GetSwitch(),
		IPAddresses: o.GetIPAddresses(),
		Version:     o.GetVersion(),
		Settings:    o.GetSettings(),
		Class:       "vpcrouter",
	}
}

// GetName returns value of Name
func (o *VPCRouterCreateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *VPCRouterCreateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *VPCRouterCreateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *VPCRouterCreateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *VPCRouterCreateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *VPCRouterCreateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *VPCRouterCreateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *VPCRouterCreateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *VPCRouterCreateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *VPCRouterCreateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *VPCRouterCreateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *VPCRouterCreateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetPlanID returns value of PlanID
func (o *VPCRouterCreateRequest) GetPlanID() types.ID {
	return o.PlanID
}

// SetPlanID sets value to PlanID
func (o *VPCRouterCreateRequest) SetPlanID(v types.ID) {
	o.PlanID = v
}

// GetSwitch returns value of Switch
func (o *VPCRouterCreateRequest) GetSwitch() *ApplianceConnectedSwitch {
	return o.Switch
}

// SetSwitch sets value to Switch
func (o *VPCRouterCreateRequest) SetSwitch(v *ApplianceConnectedSwitch) {
	o.Switch = v
}

// GetIPAddresses returns value of IPAddresses
func (o *VPCRouterCreateRequest) GetIPAddresses() []string {
	return o.IPAddresses
}

// SetIPAddresses sets value to IPAddresses
func (o *VPCRouterCreateRequest) SetIPAddresses(v []string) {
	o.IPAddresses = v
}

// GetVersion returns value of Version
func (o *VPCRouterCreateRequest) GetVersion() int {
	if o.Version == 0 {
		return 2
	}
	return o.Version
}

// SetVersion sets value to Version
func (o *VPCRouterCreateRequest) SetVersion(v int) {
	o.Version = v
}

// GetSettings returns value of Settings
func (o *VPCRouterCreateRequest) GetSettings() *VPCRouterSetting {
	return o.Settings
}

// SetSettings sets value to Settings
func (o *VPCRouterCreateRequest) SetSettings(v *VPCRouterSetting) {
	o.Settings = v
}

/*************************************************
* ApplianceConnectedSwitch
*************************************************/

// ApplianceConnectedSwitch represents API parameter/response structure
type ApplianceConnectedSwitch struct {
	ID    types.ID
	Scope types.EScope
}

// setDefaults implements iaas.argumentDefaulter
func (o *ApplianceConnectedSwitch) setDefaults() interface{} {
	return &struct {
		ID    types.ID
		Scope types.EScope
	}{
		ID:    o.GetID(),
		Scope: o.GetScope(),
	}
}

// GetID returns value of ID
func (o *ApplianceConnectedSwitch) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *ApplianceConnectedSwitch) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *ApplianceConnectedSwitch) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *ApplianceConnectedSwitch) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *ApplianceConnectedSwitch) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *ApplianceConnectedSwitch) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetScope returns value of Scope
func (o *ApplianceConnectedSwitch) GetScope() types.EScope {
	return o.Scope
}

// SetScope sets value to Scope
func (o *ApplianceConnectedSwitch) SetScope(v types.EScope) {
	o.Scope = v
}

/*************************************************
* VPCRouterUpdateRequest
*************************************************/

// VPCRouterUpdateRequest represents API parameter/response structure
type VPCRouterUpdateRequest struct {
	Name         string
	Description  string
	Tags         types.Tags
	IconID       types.ID          `mapconv:"Icon.ID"`
	Settings     *VPCRouterSetting `mapconv:",omitempty,recursive"`
	SettingsHash string            `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterUpdateRequest) setDefaults() interface{} {
	return &struct {
		Name         string
		Description  string
		Tags         types.Tags
		IconID       types.ID          `mapconv:"Icon.ID"`
		Settings     *VPCRouterSetting `mapconv:",omitempty,recursive"`
		SettingsHash string            `json:",omitempty" mapconv:",omitempty"`
	}{
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		Tags:         o.GetTags(),
		IconID:       o.GetIconID(),
		Settings:     o.GetSettings(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetName returns value of Name
func (o *VPCRouterUpdateRequest) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *VPCRouterUpdateRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *VPCRouterUpdateRequest) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *VPCRouterUpdateRequest) SetDescription(v string) {
	o.Description = v
}

// GetTags returns value of Tags
func (o *VPCRouterUpdateRequest) GetTags() types.Tags {
	return o.Tags
}

// SetTags sets value to Tags
func (o *VPCRouterUpdateRequest) SetTags(v types.Tags) {
	o.Tags = v
}

// HasTag 指定のタグが存在する場合trueを返す
func (o *VPCRouterUpdateRequest) HasTag(tag string) bool {
	return accessor.HasTag(o, tag)
}

// AppendTag 指定のタグを追加
func (o *VPCRouterUpdateRequest) AppendTag(tag string) {
	accessor.AppendTag(o, tag)
}

// RemoveTag 指定のタグを削除
func (o *VPCRouterUpdateRequest) RemoveTag(tag string) {
	accessor.RemoveTag(o, tag)
}

// ClearTags タグを全クリア
func (o *VPCRouterUpdateRequest) ClearTags() {
	accessor.ClearTags(o)
}

// GetIconID returns value of IconID
func (o *VPCRouterUpdateRequest) GetIconID() types.ID {
	return o.IconID
}

// SetIconID sets value to IconID
func (o *VPCRouterUpdateRequest) SetIconID(v types.ID) {
	o.IconID = v
}

// GetSettings returns value of Settings
func (o *VPCRouterUpdateRequest) GetSettings() *VPCRouterSetting {
	return o.Settings
}

// SetSettings sets value to Settings
func (o *VPCRouterUpdateRequest) SetSettings(v *VPCRouterSetting) {
	o.Settings = v
}

// GetSettingsHash returns value of SettingsHash
func (o *VPCRouterUpdateRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *VPCRouterUpdateRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* VPCRouterUpdateSettingsRequest
*************************************************/

// VPCRouterUpdateSettingsRequest represents API parameter/response structure
type VPCRouterUpdateSettingsRequest struct {
	Settings     *VPCRouterSetting `mapconv:",omitempty,recursive"`
	SettingsHash string            `json:",omitempty" mapconv:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterUpdateSettingsRequest) setDefaults() interface{} {
	return &struct {
		Settings     *VPCRouterSetting `mapconv:",omitempty,recursive"`
		SettingsHash string            `json:",omitempty" mapconv:",omitempty"`
	}{
		Settings:     o.GetSettings(),
		SettingsHash: o.GetSettingsHash(),
	}
}

// GetSettings returns value of Settings
func (o *VPCRouterUpdateSettingsRequest) GetSettings() *VPCRouterSetting {
	return o.Settings
}

// SetSettings sets value to Settings
func (o *VPCRouterUpdateSettingsRequest) SetSettings(v *VPCRouterSetting) {
	o.Settings = v
}

// GetSettingsHash returns value of SettingsHash
func (o *VPCRouterUpdateSettingsRequest) GetSettingsHash() string {
	return o.SettingsHash
}

// SetSettingsHash sets value to SettingsHash
func (o *VPCRouterUpdateSettingsRequest) SetSettingsHash(v string) {
	o.SettingsHash = v
}

/*************************************************
* VPCRouterStatus
*************************************************/

// VPCRouterStatus represents API parameter/response structure
type VPCRouterStatus struct {
	FirewallReceiveLogs     []string
	FirewallSendLogs        []string
	VPNLogs                 []string
	SessionCount            int
	PercentageOfMemoryFree  []types.StringNumber
	WireGuard               *WireGuardStatus
	DHCPServerLeases        []*VPCRouterDHCPServerLease        `mapconv:"[]DHCPServerLeases,recursive"`
	L2TPIPsecServerSessions []*VPCRouterL2TPIPsecServerSession `mapconv:"[]L2TPIPsecServerSessions,recursive"`
	PPTPServerSessions      []*VPCRouterPPTPServerSession      `mapconv:"[]PPTPServerSessions,recursive"`
	SiteToSiteIPsecVPNPeers []*VPCRouterSiteToSiteIPsecVPNPeer `mapconv:"[]SiteToSiteIPsecVPNPeers,recursive"`
	SessionAnalysis         *VPCRouterSessionAnalysis
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterStatus) setDefaults() interface{} {
	return &struct {
		FirewallReceiveLogs     []string
		FirewallSendLogs        []string
		VPNLogs                 []string
		SessionCount            int
		PercentageOfMemoryFree  []types.StringNumber
		WireGuard               *WireGuardStatus
		DHCPServerLeases        []*VPCRouterDHCPServerLease        `mapconv:"[]DHCPServerLeases,recursive"`
		L2TPIPsecServerSessions []*VPCRouterL2TPIPsecServerSession `mapconv:"[]L2TPIPsecServerSessions,recursive"`
		PPTPServerSessions      []*VPCRouterPPTPServerSession      `mapconv:"[]PPTPServerSessions,recursive"`
		SiteToSiteIPsecVPNPeers []*VPCRouterSiteToSiteIPsecVPNPeer `mapconv:"[]SiteToSiteIPsecVPNPeers,recursive"`
		SessionAnalysis         *VPCRouterSessionAnalysis
	}{
		FirewallReceiveLogs:     o.GetFirewallReceiveLogs(),
		FirewallSendLogs:        o.GetFirewallSendLogs(),
		VPNLogs:                 o.GetVPNLogs(),
		SessionCount:            o.GetSessionCount(),
		PercentageOfMemoryFree:  o.GetPercentageOfMemoryFree(),
		WireGuard:               o.GetWireGuard(),
		DHCPServerLeases:        o.GetDHCPServerLeases(),
		L2TPIPsecServerSessions: o.GetL2TPIPsecServerSessions(),
		PPTPServerSessions:      o.GetPPTPServerSessions(),
		SiteToSiteIPsecVPNPeers: o.GetSiteToSiteIPsecVPNPeers(),
		SessionAnalysis:         o.GetSessionAnalysis(),
	}
}

// GetFirewallReceiveLogs returns value of FirewallReceiveLogs
func (o *VPCRouterStatus) GetFirewallReceiveLogs() []string {
	return o.FirewallReceiveLogs
}

// SetFirewallReceiveLogs sets value to FirewallReceiveLogs
func (o *VPCRouterStatus) SetFirewallReceiveLogs(v []string) {
	o.FirewallReceiveLogs = v
}

// GetFirewallSendLogs returns value of FirewallSendLogs
func (o *VPCRouterStatus) GetFirewallSendLogs() []string {
	return o.FirewallSendLogs
}

// SetFirewallSendLogs sets value to FirewallSendLogs
func (o *VPCRouterStatus) SetFirewallSendLogs(v []string) {
	o.FirewallSendLogs = v
}

// GetVPNLogs returns value of VPNLogs
func (o *VPCRouterStatus) GetVPNLogs() []string {
	return o.VPNLogs
}

// SetVPNLogs sets value to VPNLogs
func (o *VPCRouterStatus) SetVPNLogs(v []string) {
	o.VPNLogs = v
}

// GetSessionCount returns value of SessionCount
func (o *VPCRouterStatus) GetSessionCount() int {
	return o.SessionCount
}

// SetSessionCount sets value to SessionCount
func (o *VPCRouterStatus) SetSessionCount(v int) {
	o.SessionCount = v
}

// GetPercentageOfMemoryFree returns value of PercentageOfMemoryFree
func (o *VPCRouterStatus) GetPercentageOfMemoryFree() []types.StringNumber {
	return o.PercentageOfMemoryFree
}

// SetPercentageOfMemoryFree sets value to PercentageOfMemoryFree
func (o *VPCRouterStatus) SetPercentageOfMemoryFree(v []types.StringNumber) {
	o.PercentageOfMemoryFree = v
}

// GetWireGuard returns value of WireGuard
func (o *VPCRouterStatus) GetWireGuard() *WireGuardStatus {
	return o.WireGuard
}

// SetWireGuard sets value to WireGuard
func (o *VPCRouterStatus) SetWireGuard(v *WireGuardStatus) {
	o.WireGuard = v
}

// GetDHCPServerLeases returns value of DHCPServerLeases
func (o *VPCRouterStatus) GetDHCPServerLeases() []*VPCRouterDHCPServerLease {
	return o.DHCPServerLeases
}

// SetDHCPServerLeases sets value to DHCPServerLeases
func (o *VPCRouterStatus) SetDHCPServerLeases(v []*VPCRouterDHCPServerLease) {
	o.DHCPServerLeases = v
}

// GetL2TPIPsecServerSessions returns value of L2TPIPsecServerSessions
func (o *VPCRouterStatus) GetL2TPIPsecServerSessions() []*VPCRouterL2TPIPsecServerSession {
	return o.L2TPIPsecServerSessions
}

// SetL2TPIPsecServerSessions sets value to L2TPIPsecServerSessions
func (o *VPCRouterStatus) SetL2TPIPsecServerSessions(v []*VPCRouterL2TPIPsecServerSession) {
	o.L2TPIPsecServerSessions = v
}

// GetPPTPServerSessions returns value of PPTPServerSessions
func (o *VPCRouterStatus) GetPPTPServerSessions() []*VPCRouterPPTPServerSession {
	return o.PPTPServerSessions
}

// SetPPTPServerSessions sets value to PPTPServerSessions
func (o *VPCRouterStatus) SetPPTPServerSessions(v []*VPCRouterPPTPServerSession) {
	o.PPTPServerSessions = v
}

// GetSiteToSiteIPsecVPNPeers returns value of SiteToSiteIPsecVPNPeers
func (o *VPCRouterStatus) GetSiteToSiteIPsecVPNPeers() []*VPCRouterSiteToSiteIPsecVPNPeer {
	return o.SiteToSiteIPsecVPNPeers
}

// SetSiteToSiteIPsecVPNPeers sets value to SiteToSiteIPsecVPNPeers
func (o *VPCRouterStatus) SetSiteToSiteIPsecVPNPeers(v []*VPCRouterSiteToSiteIPsecVPNPeer) {
	o.SiteToSiteIPsecVPNPeers = v
}

// GetSessionAnalysis returns value of SessionAnalysis
func (o *VPCRouterStatus) GetSessionAnalysis() *VPCRouterSessionAnalysis {
	return o.SessionAnalysis
}

// SetSessionAnalysis sets value to SessionAnalysis
func (o *VPCRouterStatus) SetSessionAnalysis(v *VPCRouterSessionAnalysis) {
	o.SessionAnalysis = v
}

/*************************************************
* WireGuardStatus
*************************************************/

// WireGuardStatus represents API parameter/response structure
type WireGuardStatus struct {
	PublicKey string
}

// setDefaults implements iaas.argumentDefaulter
func (o *WireGuardStatus) setDefaults() interface{} {
	return &struct {
		PublicKey string
	}{
		PublicKey: o.GetPublicKey(),
	}
}

// GetPublicKey returns value of PublicKey
func (o *WireGuardStatus) GetPublicKey() string {
	return o.PublicKey
}

// SetPublicKey sets value to PublicKey
func (o *WireGuardStatus) SetPublicKey(v string) {
	o.PublicKey = v
}

/*************************************************
* VPCRouterDHCPServerLease
*************************************************/

// VPCRouterDHCPServerLease represents API parameter/response structure
type VPCRouterDHCPServerLease struct {
	IPAddress  string
	MACAddress string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterDHCPServerLease) setDefaults() interface{} {
	return &struct {
		IPAddress  string
		MACAddress string
	}{
		IPAddress:  o.GetIPAddress(),
		MACAddress: o.GetMACAddress(),
	}
}

// GetIPAddress returns value of IPAddress
func (o *VPCRouterDHCPServerLease) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VPCRouterDHCPServerLease) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetMACAddress returns value of MACAddress
func (o *VPCRouterDHCPServerLease) GetMACAddress() string {
	return o.MACAddress
}

// SetMACAddress sets value to MACAddress
func (o *VPCRouterDHCPServerLease) SetMACAddress(v string) {
	o.MACAddress = v
}

/*************************************************
* VPCRouterL2TPIPsecServerSession
*************************************************/

// VPCRouterL2TPIPsecServerSession represents API parameter/response structure
type VPCRouterL2TPIPsecServerSession struct {
	User      string
	IPAddress string
	TimeSec   int
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterL2TPIPsecServerSession) setDefaults() interface{} {
	return &struct {
		User      string
		IPAddress string
		TimeSec   int
	}{
		User:      o.GetUser(),
		IPAddress: o.GetIPAddress(),
		TimeSec:   o.GetTimeSec(),
	}
}

// GetUser returns value of User
func (o *VPCRouterL2TPIPsecServerSession) GetUser() string {
	return o.User
}

// SetUser sets value to User
func (o *VPCRouterL2TPIPsecServerSession) SetUser(v string) {
	o.User = v
}

// GetIPAddress returns value of IPAddress
func (o *VPCRouterL2TPIPsecServerSession) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VPCRouterL2TPIPsecServerSession) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetTimeSec returns value of TimeSec
func (o *VPCRouterL2TPIPsecServerSession) GetTimeSec() int {
	return o.TimeSec
}

// SetTimeSec sets value to TimeSec
func (o *VPCRouterL2TPIPsecServerSession) SetTimeSec(v int) {
	o.TimeSec = v
}

/*************************************************
* VPCRouterPPTPServerSession
*************************************************/

// VPCRouterPPTPServerSession represents API parameter/response structure
type VPCRouterPPTPServerSession struct {
	User      string
	IPAddress string
	TimeSec   int
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterPPTPServerSession) setDefaults() interface{} {
	return &struct {
		User      string
		IPAddress string
		TimeSec   int
	}{
		User:      o.GetUser(),
		IPAddress: o.GetIPAddress(),
		TimeSec:   o.GetTimeSec(),
	}
}

// GetUser returns value of User
func (o *VPCRouterPPTPServerSession) GetUser() string {
	return o.User
}

// SetUser sets value to User
func (o *VPCRouterPPTPServerSession) SetUser(v string) {
	o.User = v
}

// GetIPAddress returns value of IPAddress
func (o *VPCRouterPPTPServerSession) GetIPAddress() string {
	return o.IPAddress
}

// SetIPAddress sets value to IPAddress
func (o *VPCRouterPPTPServerSession) SetIPAddress(v string) {
	o.IPAddress = v
}

// GetTimeSec returns value of TimeSec
func (o *VPCRouterPPTPServerSession) GetTimeSec() int {
	return o.TimeSec
}

// SetTimeSec sets value to TimeSec
func (o *VPCRouterPPTPServerSession) SetTimeSec(v int) {
	o.TimeSec = v
}

/*************************************************
* VPCRouterSiteToSiteIPsecVPNPeer
*************************************************/

// VPCRouterSiteToSiteIPsecVPNPeer represents API parameter/response structure
type VPCRouterSiteToSiteIPsecVPNPeer struct {
	Status string
	Peer   string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterSiteToSiteIPsecVPNPeer) setDefaults() interface{} {
	return &struct {
		Status string
		Peer   string
	}{
		Status: o.GetStatus(),
		Peer:   o.GetPeer(),
	}
}

// GetStatus returns value of Status
func (o *VPCRouterSiteToSiteIPsecVPNPeer) GetStatus() string {
	return o.Status
}

// SetStatus sets value to Status
func (o *VPCRouterSiteToSiteIPsecVPNPeer) SetStatus(v string) {
	o.Status = v
}

// GetPeer returns value of Peer
func (o *VPCRouterSiteToSiteIPsecVPNPeer) GetPeer() string {
	return o.Peer
}

// SetPeer sets value to Peer
func (o *VPCRouterSiteToSiteIPsecVPNPeer) SetPeer(v string) {
	o.Peer = v
}

/*************************************************
* VPCRouterSessionAnalysis
*************************************************/

// VPCRouterSessionAnalysis represents API parameter/response structure
type VPCRouterSessionAnalysis struct {
	SourceAndDestination []*VPCRouterStatisticsValue
	DestinationAddress   []*VPCRouterStatisticsValue
	DestinationPort      []*VPCRouterStatisticsValue
	SourceAddress        []*VPCRouterStatisticsValue
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterSessionAnalysis) setDefaults() interface{} {
	return &struct {
		SourceAndDestination []*VPCRouterStatisticsValue
		DestinationAddress   []*VPCRouterStatisticsValue
		DestinationPort      []*VPCRouterStatisticsValue
		SourceAddress        []*VPCRouterStatisticsValue
	}{
		SourceAndDestination: o.GetSourceAndDestination(),
		DestinationAddress:   o.GetDestinationAddress(),
		DestinationPort:      o.GetDestinationPort(),
		SourceAddress:        o.GetSourceAddress(),
	}
}

// GetSourceAndDestination returns value of SourceAndDestination
func (o *VPCRouterSessionAnalysis) GetSourceAndDestination() []*VPCRouterStatisticsValue {
	return o.SourceAndDestination
}

// SetSourceAndDestination sets value to SourceAndDestination
func (o *VPCRouterSessionAnalysis) SetSourceAndDestination(v []*VPCRouterStatisticsValue) {
	o.SourceAndDestination = v
}

// GetDestinationAddress returns value of DestinationAddress
func (o *VPCRouterSessionAnalysis) GetDestinationAddress() []*VPCRouterStatisticsValue {
	return o.DestinationAddress
}

// SetDestinationAddress sets value to DestinationAddress
func (o *VPCRouterSessionAnalysis) SetDestinationAddress(v []*VPCRouterStatisticsValue) {
	o.DestinationAddress = v
}

// GetDestinationPort returns value of DestinationPort
func (o *VPCRouterSessionAnalysis) GetDestinationPort() []*VPCRouterStatisticsValue {
	return o.DestinationPort
}

// SetDestinationPort sets value to DestinationPort
func (o *VPCRouterSessionAnalysis) SetDestinationPort(v []*VPCRouterStatisticsValue) {
	o.DestinationPort = v
}

// GetSourceAddress returns value of SourceAddress
func (o *VPCRouterSessionAnalysis) GetSourceAddress() []*VPCRouterStatisticsValue {
	return o.SourceAddress
}

// SetSourceAddress sets value to SourceAddress
func (o *VPCRouterSessionAnalysis) SetSourceAddress(v []*VPCRouterStatisticsValue) {
	o.SourceAddress = v
}

/*************************************************
* VPCRouterStatisticsValue
*************************************************/

// VPCRouterStatisticsValue represents API parameter/response structure
type VPCRouterStatisticsValue struct {
	Name  string
	Count int
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterStatisticsValue) setDefaults() interface{} {
	return &struct {
		Name  string
		Count int
	}{
		Name:  o.GetName(),
		Count: o.GetCount(),
	}
}

// GetName returns value of Name
func (o *VPCRouterStatisticsValue) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *VPCRouterStatisticsValue) SetName(v string) {
	o.Name = v
}

// GetCount returns value of Count
func (o *VPCRouterStatisticsValue) GetCount() int {
	return o.Count
}

// SetCount sets value to Count
func (o *VPCRouterStatisticsValue) SetCount(v int) {
	o.Count = v
}

/*************************************************
* VPCRouterLog
*************************************************/

// VPCRouterLog represents API parameter/response structure
type VPCRouterLog struct {
	Log string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterLog) setDefaults() interface{} {
	return &struct {
		Log string
	}{
		Log: o.GetLog(),
	}
}

// GetLog returns value of Log
func (o *VPCRouterLog) GetLog() string {
	return o.Log
}

// SetLog sets value to Log
func (o *VPCRouterLog) SetLog(v string) {
	o.Log = v
}

/*************************************************
* VPCRouterPingResults
*************************************************/

// VPCRouterPingResults represents API parameter/response structure
type VPCRouterPingResults struct {
	Result []string
}

// setDefaults implements iaas.argumentDefaulter
func (o *VPCRouterPingResults) setDefaults() interface{} {
	return &struct {
		Result []string
	}{
		Result: o.GetResult(),
	}
}

// GetResult returns value of Result
func (o *VPCRouterPingResults) GetResult() []string {
	return o.Result
}

// SetResult sets value to Result
func (o *VPCRouterPingResults) SetResult(v []string) {
	o.Result = v
}

/*************************************************
* Zone
*************************************************/

// Zone represents API parameter/response structure
type Zone struct {
	ID           types.ID
	Name         string
	Description  string
	DisplayOrder int64
	IsDummy      bool
	VNCProxy     *VNCProxy      `json:",omitempty"`
	FTPServer    *FTPServerInfo `json:",omitempty"`
	Region       *Region        `json:",omitempty"`
}

// setDefaults implements iaas.argumentDefaulter
func (o *Zone) setDefaults() interface{} {
	return &struct {
		ID           types.ID
		Name         string
		Description  string
		DisplayOrder int64
		IsDummy      bool
		VNCProxy     *VNCProxy      `json:",omitempty"`
		FTPServer    *FTPServerInfo `json:",omitempty"`
		Region       *Region        `json:",omitempty"`
	}{
		ID:           o.GetID(),
		Name:         o.GetName(),
		Description:  o.GetDescription(),
		DisplayOrder: o.GetDisplayOrder(),
		IsDummy:      o.GetIsDummy(),
		VNCProxy:     o.GetVNCProxy(),
		FTPServer:    o.GetFTPServer(),
		Region:       o.GetRegion(),
	}
}

// GetID returns value of ID
func (o *Zone) GetID() types.ID {
	return o.ID
}

// SetID sets value to ID
func (o *Zone) SetID(v types.ID) {
	o.ID = v
}

// SetStringID .
func (o *Zone) SetStringID(id string) {
	accessor.SetStringID(o, id)
}

// GetStringID .
func (o *Zone) GetStringID() string {
	return accessor.GetStringID(o)
}

// SetInt64ID .
func (o *Zone) SetInt64ID(id int64) {
	accessor.SetInt64ID(o, id)
}

// GetInt64ID .
func (o *Zone) GetInt64ID() int64 {
	return accessor.GetInt64ID(o)
}

// GetName returns value of Name
func (o *Zone) GetName() string {
	return o.Name
}

// SetName sets value to Name
func (o *Zone) SetName(v string) {
	o.Name = v
}

// GetDescription returns value of Description
func (o *Zone) GetDescription() string {
	return o.Description
}

// SetDescription sets value to Description
func (o *Zone) SetDescription(v string) {
	o.Description = v
}

// GetDisplayOrder returns value of DisplayOrder
func (o *Zone) GetDisplayOrder() int64 {
	return o.DisplayOrder
}

// SetDisplayOrder sets value to DisplayOrder
func (o *Zone) SetDisplayOrder(v int64) {
	o.DisplayOrder = v
}

// GetIsDummy returns value of IsDummy
func (o *Zone) GetIsDummy() bool {
	return o.IsDummy
}

// SetIsDummy sets value to IsDummy
func (o *Zone) SetIsDummy(v bool) {
	o.IsDummy = v
}

// GetVNCProxy returns value of VNCProxy
func (o *Zone) GetVNCProxy() *VNCProxy {
	return o.VNCProxy
}

// SetVNCProxy sets value to VNCProxy
func (o *Zone) SetVNCProxy(v *VNCProxy) {
	o.VNCProxy = v
}

// GetFTPServer returns value of FTPServer
func (o *Zone) GetFTPServer() *FTPServerInfo {
	return o.FTPServer
}

// SetFTPServer sets value to FTPServer
func (o *Zone) SetFTPServer(v *FTPServerInfo) {
	o.FTPServer = v
}

// GetRegion returns value of Region
func (o *Zone) GetRegion() *Region {
	return o.Region
}

// SetRegion sets value to Region
func (o *Zone) SetRegion(v *Region) {
	o.Region = v
}
