// Code generated by go-swagger; DO NOT EDIT.

package modelscapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DecisionsSyncRequestItem Signal
//
// swagger:model DecisionsSyncRequestItem
type DecisionsSyncRequestItem struct {

	// alert id
	AlertID int64 `json:"alert_id,omitempty"`

	// created at
	CreatedAt string `json:"created_at,omitempty"`

	// decisions
	Decisions DecisionsSyncRequestItemDecisions `json:"decisions,omitempty"`

	// machine id
	MachineID string `json:"machine_id,omitempty"`

	// a human readable message
	// Required: true
	Message *string `json:"message"`

	// scenario
	// Required: true
	Scenario *string `json:"scenario"`

	// scenario hash
	// Required: true
	ScenarioHash *string `json:"scenario_hash"`

	// scenario trust
	ScenarioTrust string `json:"scenario_trust,omitempty"`

	// scenario version
	// Required: true
	ScenarioVersion *string `json:"scenario_version"`

	// source
	// Required: true
	Source *DecisionsSyncRequestItemSource `json:"source"`

	// start at
	// Required: true
	StartAt *string `json:"start_at"`

	// stop at
	// Required: true
	StopAt *string `json:"stop_at"`
}

// Validate validates this decisions sync request item
func (m *DecisionsSyncRequestItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDecisions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScenario(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScenarioHash(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScenarioVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DecisionsSyncRequestItem) validateDecisions(formats strfmt.Registry) error {
	if swag.IsZero(m.Decisions) { // not required
		return nil
	}

	if err := m.Decisions.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("decisions")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("decisions")
		}
		return err
	}

	return nil
}

func (m *DecisionsSyncRequestItem) validateMessage(formats strfmt.Registry) error {

	if err := validate.Required("message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *DecisionsSyncRequestItem) validateScenario(formats strfmt.Registry) error {

	if err := validate.Required("scenario", "body", m.Scenario); err != nil {
		return err
	}

	return nil
}

func (m *DecisionsSyncRequestItem) validateScenarioHash(formats strfmt.Registry) error {

	if err := validate.Required("scenario_hash", "body", m.ScenarioHash); err != nil {
		return err
	}

	return nil
}

func (m *DecisionsSyncRequestItem) validateScenarioVersion(formats strfmt.Registry) error {

	if err := validate.Required("scenario_version", "body", m.ScenarioVersion); err != nil {
		return err
	}

	return nil
}

func (m *DecisionsSyncRequestItem) validateSource(formats strfmt.Registry) error {

	if err := validate.Required("source", "body", m.Source); err != nil {
		return err
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *DecisionsSyncRequestItem) validateStartAt(formats strfmt.Registry) error {

	if err := validate.Required("start_at", "body", m.StartAt); err != nil {
		return err
	}

	return nil
}

func (m *DecisionsSyncRequestItem) validateStopAt(formats strfmt.Registry) error {

	if err := validate.Required("stop_at", "body", m.StopAt); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this decisions sync request item based on the context it is used
func (m *DecisionsSyncRequestItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDecisions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DecisionsSyncRequestItem) contextValidateDecisions(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Decisions.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("decisions")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("decisions")
		}
		return err
	}

	return nil
}

func (m *DecisionsSyncRequestItem) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {

		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DecisionsSyncRequestItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DecisionsSyncRequestItem) UnmarshalBinary(b []byte) error {
	var res DecisionsSyncRequestItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
