// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/pubsub/v1/pubsub.proto

package pubsubpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible states for ingestion from Amazon Kinesis Data Streams.
type IngestionDataSourceSettings_AwsKinesis_State int32

const (
	// Default value. This value is unused.
	IngestionDataSourceSettings_AwsKinesis_STATE_UNSPECIFIED IngestionDataSourceSettings_AwsKinesis_State = 0
	// Ingestion is active.
	IngestionDataSourceSettings_AwsKinesis_ACTIVE IngestionDataSourceSettings_AwsKinesis_State = 1
	// Permission denied encountered while consuming data from Kinesis.
	// This can happen if:
	//   - The provided `aws_role_arn` does not exist or does not have the
	//     appropriate permissions attached.
	//   - The provided `aws_role_arn` is not set up properly for Identity
	//     Federation using `gcp_service_account`.
	//   - The Pub/Sub SA is not granted the
	//     `iam.serviceAccounts.getOpenIdToken` permission on
	//     `gcp_service_account`.
	IngestionDataSourceSettings_AwsKinesis_KINESIS_PERMISSION_DENIED IngestionDataSourceSettings_AwsKinesis_State = 2
	// Permission denied encountered while publishing to the topic. This can
	// happen if the Pub/Sub SA has not been granted the [appropriate publish
	// permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
	IngestionDataSourceSettings_AwsKinesis_PUBLISH_PERMISSION_DENIED IngestionDataSourceSettings_AwsKinesis_State = 3
	// The Kinesis stream does not exist.
	IngestionDataSourceSettings_AwsKinesis_STREAM_NOT_FOUND IngestionDataSourceSettings_AwsKinesis_State = 4
	// The Kinesis consumer does not exist.
	IngestionDataSourceSettings_AwsKinesis_CONSUMER_NOT_FOUND IngestionDataSourceSettings_AwsKinesis_State = 5
)

// Enum value maps for IngestionDataSourceSettings_AwsKinesis_State.
var (
	IngestionDataSourceSettings_AwsKinesis_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "KINESIS_PERMISSION_DENIED",
		3: "PUBLISH_PERMISSION_DENIED",
		4: "STREAM_NOT_FOUND",
		5: "CONSUMER_NOT_FOUND",
	}
	IngestionDataSourceSettings_AwsKinesis_State_value = map[string]int32{
		"STATE_UNSPECIFIED":         0,
		"ACTIVE":                    1,
		"KINESIS_PERMISSION_DENIED": 2,
		"PUBLISH_PERMISSION_DENIED": 3,
		"STREAM_NOT_FOUND":          4,
		"CONSUMER_NOT_FOUND":        5,
	}
)

func (x IngestionDataSourceSettings_AwsKinesis_State) Enum() *IngestionDataSourceSettings_AwsKinesis_State {
	p := new(IngestionDataSourceSettings_AwsKinesis_State)
	*p = x
	return p
}

func (x IngestionDataSourceSettings_AwsKinesis_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestionDataSourceSettings_AwsKinesis_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[0].Descriptor()
}

func (IngestionDataSourceSettings_AwsKinesis_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[0]
}

func (x IngestionDataSourceSettings_AwsKinesis_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestionDataSourceSettings_AwsKinesis_State.Descriptor instead.
func (IngestionDataSourceSettings_AwsKinesis_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 0, 0}
}

// Possible states for ingestion from Cloud Storage.
type IngestionDataSourceSettings_CloudStorage_State int32

const (
	// Default value. This value is unused.
	IngestionDataSourceSettings_CloudStorage_STATE_UNSPECIFIED IngestionDataSourceSettings_CloudStorage_State = 0
	// Ingestion is active.
	IngestionDataSourceSettings_CloudStorage_ACTIVE IngestionDataSourceSettings_CloudStorage_State = 1
	// Permission denied encountered while calling the Cloud Storage API. This
	// can happen if the Pub/Sub SA has not been granted the
	// [appropriate
	// permissions](https://cloud.google.com/storage/docs/access-control/iam-permissions):
	// - storage.objects.list: to list the objects in a bucket.
	// - storage.objects.get: to read the objects in a bucket.
	// - storage.buckets.get: to verify the bucket exists.
	IngestionDataSourceSettings_CloudStorage_CLOUD_STORAGE_PERMISSION_DENIED IngestionDataSourceSettings_CloudStorage_State = 2
	// Permission denied encountered while publishing to the topic. This can
	// happen if the Pub/Sub SA has not been granted the [appropriate publish
	// permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
	IngestionDataSourceSettings_CloudStorage_PUBLISH_PERMISSION_DENIED IngestionDataSourceSettings_CloudStorage_State = 3
	// The provided Cloud Storage bucket doesn't exist.
	IngestionDataSourceSettings_CloudStorage_BUCKET_NOT_FOUND IngestionDataSourceSettings_CloudStorage_State = 4
	// The Cloud Storage bucket has too many objects, ingestion will be
	// paused.
	IngestionDataSourceSettings_CloudStorage_TOO_MANY_OBJECTS IngestionDataSourceSettings_CloudStorage_State = 5
)

// Enum value maps for IngestionDataSourceSettings_CloudStorage_State.
var (
	IngestionDataSourceSettings_CloudStorage_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CLOUD_STORAGE_PERMISSION_DENIED",
		3: "PUBLISH_PERMISSION_DENIED",
		4: "BUCKET_NOT_FOUND",
		5: "TOO_MANY_OBJECTS",
	}
	IngestionDataSourceSettings_CloudStorage_State_value = map[string]int32{
		"STATE_UNSPECIFIED":               0,
		"ACTIVE":                          1,
		"CLOUD_STORAGE_PERMISSION_DENIED": 2,
		"PUBLISH_PERMISSION_DENIED":       3,
		"BUCKET_NOT_FOUND":                4,
		"TOO_MANY_OBJECTS":                5,
	}
)

func (x IngestionDataSourceSettings_CloudStorage_State) Enum() *IngestionDataSourceSettings_CloudStorage_State {
	p := new(IngestionDataSourceSettings_CloudStorage_State)
	*p = x
	return p
}

func (x IngestionDataSourceSettings_CloudStorage_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestionDataSourceSettings_CloudStorage_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[1].Descriptor()
}

func (IngestionDataSourceSettings_CloudStorage_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[1]
}

func (x IngestionDataSourceSettings_CloudStorage_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestionDataSourceSettings_CloudStorage_State.Descriptor instead.
func (IngestionDataSourceSettings_CloudStorage_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 1, 0}
}

// Possible states for managed ingestion from Event Hubs.
type IngestionDataSourceSettings_AzureEventHubs_State int32

const (
	// Default value. This value is unused.
	IngestionDataSourceSettings_AzureEventHubs_STATE_UNSPECIFIED IngestionDataSourceSettings_AzureEventHubs_State = 0
	// Ingestion is active.
	IngestionDataSourceSettings_AzureEventHubs_ACTIVE IngestionDataSourceSettings_AzureEventHubs_State = 1
	// Permission denied encountered while consuming data from Event Hubs.
	// This can happen when `client_id`, or `tenant_id` are invalid. Or the
	// right permissions haven't been granted.
	IngestionDataSourceSettings_AzureEventHubs_EVENT_HUBS_PERMISSION_DENIED IngestionDataSourceSettings_AzureEventHubs_State = 2
	// Permission denied encountered while publishing to the topic.
	IngestionDataSourceSettings_AzureEventHubs_PUBLISH_PERMISSION_DENIED IngestionDataSourceSettings_AzureEventHubs_State = 3
	// The provided Event Hubs namespace couldn't be found.
	IngestionDataSourceSettings_AzureEventHubs_NAMESPACE_NOT_FOUND IngestionDataSourceSettings_AzureEventHubs_State = 4
	// The provided Event Hub couldn't be found.
	IngestionDataSourceSettings_AzureEventHubs_EVENT_HUB_NOT_FOUND IngestionDataSourceSettings_AzureEventHubs_State = 5
	// The provided Event Hubs subscription couldn't be found.
	IngestionDataSourceSettings_AzureEventHubs_SUBSCRIPTION_NOT_FOUND IngestionDataSourceSettings_AzureEventHubs_State = 6
	// The provided Event Hubs resource group couldn't be found.
	IngestionDataSourceSettings_AzureEventHubs_RESOURCE_GROUP_NOT_FOUND IngestionDataSourceSettings_AzureEventHubs_State = 7
)

// Enum value maps for IngestionDataSourceSettings_AzureEventHubs_State.
var (
	IngestionDataSourceSettings_AzureEventHubs_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "EVENT_HUBS_PERMISSION_DENIED",
		3: "PUBLISH_PERMISSION_DENIED",
		4: "NAMESPACE_NOT_FOUND",
		5: "EVENT_HUB_NOT_FOUND",
		6: "SUBSCRIPTION_NOT_FOUND",
		7: "RESOURCE_GROUP_NOT_FOUND",
	}
	IngestionDataSourceSettings_AzureEventHubs_State_value = map[string]int32{
		"STATE_UNSPECIFIED":            0,
		"ACTIVE":                       1,
		"EVENT_HUBS_PERMISSION_DENIED": 2,
		"PUBLISH_PERMISSION_DENIED":    3,
		"NAMESPACE_NOT_FOUND":          4,
		"EVENT_HUB_NOT_FOUND":          5,
		"SUBSCRIPTION_NOT_FOUND":       6,
		"RESOURCE_GROUP_NOT_FOUND":     7,
	}
)

func (x IngestionDataSourceSettings_AzureEventHubs_State) Enum() *IngestionDataSourceSettings_AzureEventHubs_State {
	p := new(IngestionDataSourceSettings_AzureEventHubs_State)
	*p = x
	return p
}

func (x IngestionDataSourceSettings_AzureEventHubs_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestionDataSourceSettings_AzureEventHubs_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[2].Descriptor()
}

func (IngestionDataSourceSettings_AzureEventHubs_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[2]
}

func (x IngestionDataSourceSettings_AzureEventHubs_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestionDataSourceSettings_AzureEventHubs_State.Descriptor instead.
func (IngestionDataSourceSettings_AzureEventHubs_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 2, 0}
}

// Possible states for managed ingestion from Amazon MSK.
type IngestionDataSourceSettings_AwsMsk_State int32

const (
	// Default value. This value is unused.
	IngestionDataSourceSettings_AwsMsk_STATE_UNSPECIFIED IngestionDataSourceSettings_AwsMsk_State = 0
	// Ingestion is active.
	IngestionDataSourceSettings_AwsMsk_ACTIVE IngestionDataSourceSettings_AwsMsk_State = 1
	// Permission denied encountered while consuming data from Amazon MSK.
	IngestionDataSourceSettings_AwsMsk_MSK_PERMISSION_DENIED IngestionDataSourceSettings_AwsMsk_State = 2
	// Permission denied encountered while publishing to the topic.
	IngestionDataSourceSettings_AwsMsk_PUBLISH_PERMISSION_DENIED IngestionDataSourceSettings_AwsMsk_State = 3
	// The provided MSK cluster wasn't found.
	IngestionDataSourceSettings_AwsMsk_CLUSTER_NOT_FOUND IngestionDataSourceSettings_AwsMsk_State = 4
	// The provided topic wasn't found.
	IngestionDataSourceSettings_AwsMsk_TOPIC_NOT_FOUND IngestionDataSourceSettings_AwsMsk_State = 5
)

// Enum value maps for IngestionDataSourceSettings_AwsMsk_State.
var (
	IngestionDataSourceSettings_AwsMsk_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "MSK_PERMISSION_DENIED",
		3: "PUBLISH_PERMISSION_DENIED",
		4: "CLUSTER_NOT_FOUND",
		5: "TOPIC_NOT_FOUND",
	}
	IngestionDataSourceSettings_AwsMsk_State_value = map[string]int32{
		"STATE_UNSPECIFIED":         0,
		"ACTIVE":                    1,
		"MSK_PERMISSION_DENIED":     2,
		"PUBLISH_PERMISSION_DENIED": 3,
		"CLUSTER_NOT_FOUND":         4,
		"TOPIC_NOT_FOUND":           5,
	}
)

func (x IngestionDataSourceSettings_AwsMsk_State) Enum() *IngestionDataSourceSettings_AwsMsk_State {
	p := new(IngestionDataSourceSettings_AwsMsk_State)
	*p = x
	return p
}

func (x IngestionDataSourceSettings_AwsMsk_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestionDataSourceSettings_AwsMsk_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[3].Descriptor()
}

func (IngestionDataSourceSettings_AwsMsk_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[3]
}

func (x IngestionDataSourceSettings_AwsMsk_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestionDataSourceSettings_AwsMsk_State.Descriptor instead.
func (IngestionDataSourceSettings_AwsMsk_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 3, 0}
}

// Possible states for managed ingestion from Confluent Cloud.
type IngestionDataSourceSettings_ConfluentCloud_State int32

const (
	// Default value. This value is unused.
	IngestionDataSourceSettings_ConfluentCloud_STATE_UNSPECIFIED IngestionDataSourceSettings_ConfluentCloud_State = 0
	// Ingestion is active.
	IngestionDataSourceSettings_ConfluentCloud_ACTIVE IngestionDataSourceSettings_ConfluentCloud_State = 1
	// Permission denied encountered while consuming data from Confluent
	// Cloud.
	IngestionDataSourceSettings_ConfluentCloud_CONFLUENT_CLOUD_PERMISSION_DENIED IngestionDataSourceSettings_ConfluentCloud_State = 2
	// Permission denied encountered while publishing to the topic.
	IngestionDataSourceSettings_ConfluentCloud_PUBLISH_PERMISSION_DENIED IngestionDataSourceSettings_ConfluentCloud_State = 3
	// The provided bootstrap server address is unreachable.
	IngestionDataSourceSettings_ConfluentCloud_UNREACHABLE_BOOTSTRAP_SERVER IngestionDataSourceSettings_ConfluentCloud_State = 4
	// The provided cluster wasn't found.
	IngestionDataSourceSettings_ConfluentCloud_CLUSTER_NOT_FOUND IngestionDataSourceSettings_ConfluentCloud_State = 5
	// The provided topic wasn't found.
	IngestionDataSourceSettings_ConfluentCloud_TOPIC_NOT_FOUND IngestionDataSourceSettings_ConfluentCloud_State = 6
)

// Enum value maps for IngestionDataSourceSettings_ConfluentCloud_State.
var (
	IngestionDataSourceSettings_ConfluentCloud_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CONFLUENT_CLOUD_PERMISSION_DENIED",
		3: "PUBLISH_PERMISSION_DENIED",
		4: "UNREACHABLE_BOOTSTRAP_SERVER",
		5: "CLUSTER_NOT_FOUND",
		6: "TOPIC_NOT_FOUND",
	}
	IngestionDataSourceSettings_ConfluentCloud_State_value = map[string]int32{
		"STATE_UNSPECIFIED":                 0,
		"ACTIVE":                            1,
		"CONFLUENT_CLOUD_PERMISSION_DENIED": 2,
		"PUBLISH_PERMISSION_DENIED":         3,
		"UNREACHABLE_BOOTSTRAP_SERVER":      4,
		"CLUSTER_NOT_FOUND":                 5,
		"TOPIC_NOT_FOUND":                   6,
	}
)

func (x IngestionDataSourceSettings_ConfluentCloud_State) Enum() *IngestionDataSourceSettings_ConfluentCloud_State {
	p := new(IngestionDataSourceSettings_ConfluentCloud_State)
	*p = x
	return p
}

func (x IngestionDataSourceSettings_ConfluentCloud_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestionDataSourceSettings_ConfluentCloud_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[4].Descriptor()
}

func (IngestionDataSourceSettings_ConfluentCloud_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[4]
}

func (x IngestionDataSourceSettings_ConfluentCloud_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestionDataSourceSettings_ConfluentCloud_State.Descriptor instead.
func (IngestionDataSourceSettings_ConfluentCloud_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 4, 0}
}

// Severity levels of Platform Logs.
type PlatformLogsSettings_Severity int32

const (
	// Default value. Logs level is unspecified. Logs will be disabled.
	PlatformLogsSettings_SEVERITY_UNSPECIFIED PlatformLogsSettings_Severity = 0
	// Logs will be disabled.
	PlatformLogsSettings_DISABLED PlatformLogsSettings_Severity = 1
	// Debug logs and higher-severity logs will be written.
	PlatformLogsSettings_DEBUG PlatformLogsSettings_Severity = 2
	// Info logs and higher-severity logs will be written.
	PlatformLogsSettings_INFO PlatformLogsSettings_Severity = 3
	// Warning logs and higher-severity logs will be written.
	PlatformLogsSettings_WARNING PlatformLogsSettings_Severity = 4
	// Only error logs will be written.
	PlatformLogsSettings_ERROR PlatformLogsSettings_Severity = 5
)

// Enum value maps for PlatformLogsSettings_Severity.
var (
	PlatformLogsSettings_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "DISABLED",
		2: "DEBUG",
		3: "INFO",
		4: "WARNING",
		5: "ERROR",
	}
	PlatformLogsSettings_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"DISABLED":             1,
		"DEBUG":                2,
		"INFO":                 3,
		"WARNING":              4,
		"ERROR":                5,
	}
)

func (x PlatformLogsSettings_Severity) Enum() *PlatformLogsSettings_Severity {
	p := new(PlatformLogsSettings_Severity)
	*p = x
	return p
}

func (x PlatformLogsSettings_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PlatformLogsSettings_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[5].Descriptor()
}

func (PlatformLogsSettings_Severity) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[5]
}

func (x PlatformLogsSettings_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PlatformLogsSettings_Severity.Descriptor instead.
func (PlatformLogsSettings_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{3, 0}
}

// The state of the topic.
type Topic_State int32

const (
	// Default value. This value is unused.
	Topic_STATE_UNSPECIFIED Topic_State = 0
	// The topic does not have any persistent errors.
	Topic_ACTIVE Topic_State = 1
	// Ingestion from the data source has encountered a permanent error.
	// See the more detailed error state in the corresponding ingestion
	// source configuration.
	Topic_INGESTION_RESOURCE_ERROR Topic_State = 2
)

// Enum value maps for Topic_State.
var (
	Topic_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "INGESTION_RESOURCE_ERROR",
	}
	Topic_State_value = map[string]int32{
		"STATE_UNSPECIFIED":        0,
		"ACTIVE":                   1,
		"INGESTION_RESOURCE_ERROR": 2,
	}
)

func (x Topic_State) Enum() *Topic_State {
	p := new(Topic_State)
	*p = x
	return p
}

func (x Topic_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Topic_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[6].Descriptor()
}

func (Topic_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[6]
}

func (x Topic_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Topic_State.Descriptor instead.
func (Topic_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{7, 0}
}

// Possible states for a subscription.
type Subscription_State int32

const (
	// Default value. This value is unused.
	Subscription_STATE_UNSPECIFIED Subscription_State = 0
	// The subscription can actively receive messages
	Subscription_ACTIVE Subscription_State = 1
	// The subscription cannot receive messages because of an error with the
	// resource to which it pushes messages. See the more detailed error state
	// in the corresponding configuration.
	Subscription_RESOURCE_ERROR Subscription_State = 2
)

// Enum value maps for Subscription_State.
var (
	Subscription_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "RESOURCE_ERROR",
	}
	Subscription_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"RESOURCE_ERROR":    2,
	}
)

func (x Subscription_State) Enum() *Subscription_State {
	p := new(Subscription_State)
	*p = x
	return p
}

func (x Subscription_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subscription_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[7].Descriptor()
}

func (Subscription_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[7]
}

func (x Subscription_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subscription_State.Descriptor instead.
func (Subscription_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{22, 0}
}

// Possible states for a BigQuery subscription.
type BigQueryConfig_State int32

const (
	// Default value. This value is unused.
	BigQueryConfig_STATE_UNSPECIFIED BigQueryConfig_State = 0
	// The subscription can actively send messages to BigQuery
	BigQueryConfig_ACTIVE BigQueryConfig_State = 1
	// Cannot write to the BigQuery table because of permission denied errors.
	// This can happen if
	// - Pub/Sub SA has not been granted the [appropriate BigQuery IAM
	// permissions](https://cloud.google.com/pubsub/docs/create-subscription#assign_bigquery_service_account)
	// - bigquery.googleapis.com API is not enabled for the project
	// ([instructions](https://cloud.google.com/service-usage/docs/enable-disable))
	BigQueryConfig_PERMISSION_DENIED BigQueryConfig_State = 2
	// Cannot write to the BigQuery table because it does not exist.
	BigQueryConfig_NOT_FOUND BigQueryConfig_State = 3
	// Cannot write to the BigQuery table due to a schema mismatch.
	BigQueryConfig_SCHEMA_MISMATCH BigQueryConfig_State = 4
	// Cannot write to the destination because enforce_in_transit is set to true
	// and the destination locations are not in the allowed regions.
	BigQueryConfig_IN_TRANSIT_LOCATION_RESTRICTION BigQueryConfig_State = 5
)

// Enum value maps for BigQueryConfig_State.
var (
	BigQueryConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "PERMISSION_DENIED",
		3: "NOT_FOUND",
		4: "SCHEMA_MISMATCH",
		5: "IN_TRANSIT_LOCATION_RESTRICTION",
	}
	BigQueryConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED":               0,
		"ACTIVE":                          1,
		"PERMISSION_DENIED":               2,
		"NOT_FOUND":                       3,
		"SCHEMA_MISMATCH":                 4,
		"IN_TRANSIT_LOCATION_RESTRICTION": 5,
	}
)

func (x BigQueryConfig_State) Enum() *BigQueryConfig_State {
	p := new(BigQueryConfig_State)
	*p = x
	return p
}

func (x BigQueryConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[8].Descriptor()
}

func (BigQueryConfig_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[8]
}

func (x BigQueryConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryConfig_State.Descriptor instead.
func (BigQueryConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{27, 0}
}

// Possible states for a Cloud Storage subscription.
type CloudStorageConfig_State int32

const (
	// Default value. This value is unused.
	CloudStorageConfig_STATE_UNSPECIFIED CloudStorageConfig_State = 0
	// The subscription can actively send messages to Cloud Storage.
	CloudStorageConfig_ACTIVE CloudStorageConfig_State = 1
	// Cannot write to the Cloud Storage bucket because of permission denied
	// errors.
	CloudStorageConfig_PERMISSION_DENIED CloudStorageConfig_State = 2
	// Cannot write to the Cloud Storage bucket because it does not exist.
	CloudStorageConfig_NOT_FOUND CloudStorageConfig_State = 3
	// Cannot write to the destination because enforce_in_transit is set to true
	// and the destination locations are not in the allowed regions.
	CloudStorageConfig_IN_TRANSIT_LOCATION_RESTRICTION CloudStorageConfig_State = 4
	// Cannot write to the Cloud Storage bucket due to an incompatibility
	// between the topic schema and subscription settings.
	CloudStorageConfig_SCHEMA_MISMATCH CloudStorageConfig_State = 5
)

// Enum value maps for CloudStorageConfig_State.
var (
	CloudStorageConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "PERMISSION_DENIED",
		3: "NOT_FOUND",
		4: "IN_TRANSIT_LOCATION_RESTRICTION",
		5: "SCHEMA_MISMATCH",
	}
	CloudStorageConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED":               0,
		"ACTIVE":                          1,
		"PERMISSION_DENIED":               2,
		"NOT_FOUND":                       3,
		"IN_TRANSIT_LOCATION_RESTRICTION": 4,
		"SCHEMA_MISMATCH":                 5,
	}
)

func (x CloudStorageConfig_State) Enum() *CloudStorageConfig_State {
	p := new(CloudStorageConfig_State)
	*p = x
	return p
}

func (x CloudStorageConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudStorageConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_pubsub_v1_pubsub_proto_enumTypes[9].Descriptor()
}

func (CloudStorageConfig_State) Type() protoreflect.EnumType {
	return &file_google_pubsub_v1_pubsub_proto_enumTypes[9]
}

func (x CloudStorageConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudStorageConfig_State.Descriptor instead.
func (CloudStorageConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{28, 0}
}

// A policy constraining the storage of messages published to the topic.
type MessageStoragePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of IDs of Google Cloud regions where messages that are
	// published to the topic may be persisted in storage. Messages published by
	// publishers running in non-allowed Google Cloud regions (or running outside
	// of Google Cloud altogether) are routed for storage in one of the allowed
	// regions. An empty list means that no regions are allowed, and is not a
	// valid configuration.
	AllowedPersistenceRegions []string `protobuf:"bytes,1,rep,name=allowed_persistence_regions,json=allowedPersistenceRegions,proto3" json:"allowed_persistence_regions,omitempty"`
	// Optional. If true, `allowed_persistence_regions` is also used to enforce
	// in-transit guarantees for messages. That is, Pub/Sub will fail
	// Publish operations on this topic and subscribe operations
	// on any subscription attached to this topic in any region that is
	// not in `allowed_persistence_regions`.
	EnforceInTransit bool `protobuf:"varint,2,opt,name=enforce_in_transit,json=enforceInTransit,proto3" json:"enforce_in_transit,omitempty"`
}

func (x *MessageStoragePolicy) Reset() {
	*x = MessageStoragePolicy{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageStoragePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageStoragePolicy) ProtoMessage() {}

func (x *MessageStoragePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageStoragePolicy.ProtoReflect.Descriptor instead.
func (*MessageStoragePolicy) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{0}
}

func (x *MessageStoragePolicy) GetAllowedPersistenceRegions() []string {
	if x != nil {
		return x.AllowedPersistenceRegions
	}
	return nil
}

func (x *MessageStoragePolicy) GetEnforceInTransit() bool {
	if x != nil {
		return x.EnforceInTransit
	}
	return false
}

// Settings for validating messages published against a schema.
type SchemaSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the schema that messages published should be
	// validated against. Format is `projects/{project}/schemas/{schema}`. The
	// value of this field will be `_deleted-schema_` if the schema has been
	// deleted.
	Schema string `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
	// Optional. The encoding of messages validated against `schema`.
	Encoding Encoding `protobuf:"varint,2,opt,name=encoding,proto3,enum=google.pubsub.v1.Encoding" json:"encoding,omitempty"`
	// Optional. The minimum (inclusive) revision allowed for validating messages.
	// If empty or not present, allow any revision to be validated against
	// last_revision or any revision created before.
	FirstRevisionId string `protobuf:"bytes,3,opt,name=first_revision_id,json=firstRevisionId,proto3" json:"first_revision_id,omitempty"`
	// Optional. The maximum (inclusive) revision allowed for validating messages.
	// If empty or not present, allow any revision to be validated against
	// first_revision or any revision created after.
	LastRevisionId string `protobuf:"bytes,4,opt,name=last_revision_id,json=lastRevisionId,proto3" json:"last_revision_id,omitempty"`
}

func (x *SchemaSettings) Reset() {
	*x = SchemaSettings{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchemaSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaSettings) ProtoMessage() {}

func (x *SchemaSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaSettings.ProtoReflect.Descriptor instead.
func (*SchemaSettings) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{1}
}

func (x *SchemaSettings) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *SchemaSettings) GetEncoding() Encoding {
	if x != nil {
		return x.Encoding
	}
	return Encoding_ENCODING_UNSPECIFIED
}

func (x *SchemaSettings) GetFirstRevisionId() string {
	if x != nil {
		return x.FirstRevisionId
	}
	return ""
}

func (x *SchemaSettings) GetLastRevisionId() string {
	if x != nil {
		return x.LastRevisionId
	}
	return ""
}

// Settings for an ingestion data source on a topic.
type IngestionDataSourceSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only one source type can have settings set.
	//
	// Types that are assignable to Source:
	//
	//	*IngestionDataSourceSettings_AwsKinesis_
	//	*IngestionDataSourceSettings_CloudStorage_
	//	*IngestionDataSourceSettings_AzureEventHubs_
	//	*IngestionDataSourceSettings_AwsMsk_
	//	*IngestionDataSourceSettings_ConfluentCloud_
	Source isIngestionDataSourceSettings_Source `protobuf_oneof:"source"`
	// Optional. Platform Logs settings. If unset, no Platform Logs will be
	// generated.
	PlatformLogsSettings *PlatformLogsSettings `protobuf:"bytes,4,opt,name=platform_logs_settings,json=platformLogsSettings,proto3" json:"platform_logs_settings,omitempty"`
}

func (x *IngestionDataSourceSettings) Reset() {
	*x = IngestionDataSourceSettings{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings) ProtoMessage() {}

func (x *IngestionDataSourceSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2}
}

func (m *IngestionDataSourceSettings) GetSource() isIngestionDataSourceSettings_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *IngestionDataSourceSettings) GetAwsKinesis() *IngestionDataSourceSettings_AwsKinesis {
	if x, ok := x.GetSource().(*IngestionDataSourceSettings_AwsKinesis_); ok {
		return x.AwsKinesis
	}
	return nil
}

func (x *IngestionDataSourceSettings) GetCloudStorage() *IngestionDataSourceSettings_CloudStorage {
	if x, ok := x.GetSource().(*IngestionDataSourceSettings_CloudStorage_); ok {
		return x.CloudStorage
	}
	return nil
}

func (x *IngestionDataSourceSettings) GetAzureEventHubs() *IngestionDataSourceSettings_AzureEventHubs {
	if x, ok := x.GetSource().(*IngestionDataSourceSettings_AzureEventHubs_); ok {
		return x.AzureEventHubs
	}
	return nil
}

func (x *IngestionDataSourceSettings) GetAwsMsk() *IngestionDataSourceSettings_AwsMsk {
	if x, ok := x.GetSource().(*IngestionDataSourceSettings_AwsMsk_); ok {
		return x.AwsMsk
	}
	return nil
}

func (x *IngestionDataSourceSettings) GetConfluentCloud() *IngestionDataSourceSettings_ConfluentCloud {
	if x, ok := x.GetSource().(*IngestionDataSourceSettings_ConfluentCloud_); ok {
		return x.ConfluentCloud
	}
	return nil
}

func (x *IngestionDataSourceSettings) GetPlatformLogsSettings() *PlatformLogsSettings {
	if x != nil {
		return x.PlatformLogsSettings
	}
	return nil
}

type isIngestionDataSourceSettings_Source interface {
	isIngestionDataSourceSettings_Source()
}

type IngestionDataSourceSettings_AwsKinesis_ struct {
	// Optional. Amazon Kinesis Data Streams.
	AwsKinesis *IngestionDataSourceSettings_AwsKinesis `protobuf:"bytes,1,opt,name=aws_kinesis,json=awsKinesis,proto3,oneof"`
}

type IngestionDataSourceSettings_CloudStorage_ struct {
	// Optional. Cloud Storage.
	CloudStorage *IngestionDataSourceSettings_CloudStorage `protobuf:"bytes,2,opt,name=cloud_storage,json=cloudStorage,proto3,oneof"`
}

type IngestionDataSourceSettings_AzureEventHubs_ struct {
	// Optional. Azure Event Hubs.
	AzureEventHubs *IngestionDataSourceSettings_AzureEventHubs `protobuf:"bytes,3,opt,name=azure_event_hubs,json=azureEventHubs,proto3,oneof"`
}

type IngestionDataSourceSettings_AwsMsk_ struct {
	// Optional. Amazon MSK.
	AwsMsk *IngestionDataSourceSettings_AwsMsk `protobuf:"bytes,5,opt,name=aws_msk,json=awsMsk,proto3,oneof"`
}

type IngestionDataSourceSettings_ConfluentCloud_ struct {
	// Optional. Confluent Cloud.
	ConfluentCloud *IngestionDataSourceSettings_ConfluentCloud `protobuf:"bytes,6,opt,name=confluent_cloud,json=confluentCloud,proto3,oneof"`
}

func (*IngestionDataSourceSettings_AwsKinesis_) isIngestionDataSourceSettings_Source() {}

func (*IngestionDataSourceSettings_CloudStorage_) isIngestionDataSourceSettings_Source() {}

func (*IngestionDataSourceSettings_AzureEventHubs_) isIngestionDataSourceSettings_Source() {}

func (*IngestionDataSourceSettings_AwsMsk_) isIngestionDataSourceSettings_Source() {}

func (*IngestionDataSourceSettings_ConfluentCloud_) isIngestionDataSourceSettings_Source() {}

// Settings for Platform Logs produced by Pub/Sub.
type PlatformLogsSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The minimum severity level of Platform Logs that will be written.
	Severity PlatformLogsSettings_Severity `protobuf:"varint,1,opt,name=severity,proto3,enum=google.pubsub.v1.PlatformLogsSettings_Severity" json:"severity,omitempty"`
}

func (x *PlatformLogsSettings) Reset() {
	*x = PlatformLogsSettings{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlatformLogsSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformLogsSettings) ProtoMessage() {}

func (x *PlatformLogsSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformLogsSettings.ProtoReflect.Descriptor instead.
func (*PlatformLogsSettings) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{3}
}

func (x *PlatformLogsSettings) GetSeverity() PlatformLogsSettings_Severity {
	if x != nil {
		return x.Severity
	}
	return PlatformLogsSettings_SEVERITY_UNSPECIFIED
}

// Payload of the Platform Log entry sent when a failure is encountered while
// ingesting.
type IngestionFailureEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the import topic. Format is:
	// projects/{project_name}/topics/{topic_name}.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Required. Error details explaining why ingestion to Pub/Sub has failed.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Types that are assignable to Failure:
	//
	//	*IngestionFailureEvent_CloudStorageFailure_
	//	*IngestionFailureEvent_AwsMskFailure
	//	*IngestionFailureEvent_AzureEventHubsFailure
	//	*IngestionFailureEvent_ConfluentCloudFailure
	//	*IngestionFailureEvent_AwsKinesisFailure
	Failure isIngestionFailureEvent_Failure `protobuf_oneof:"failure"`
}

func (x *IngestionFailureEvent) Reset() {
	*x = IngestionFailureEvent{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent) ProtoMessage() {}

func (x *IngestionFailureEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4}
}

func (x *IngestionFailureEvent) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *IngestionFailureEvent) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (m *IngestionFailureEvent) GetFailure() isIngestionFailureEvent_Failure {
	if m != nil {
		return m.Failure
	}
	return nil
}

func (x *IngestionFailureEvent) GetCloudStorageFailure() *IngestionFailureEvent_CloudStorageFailure {
	if x, ok := x.GetFailure().(*IngestionFailureEvent_CloudStorageFailure_); ok {
		return x.CloudStorageFailure
	}
	return nil
}

func (x *IngestionFailureEvent) GetAwsMskFailure() *IngestionFailureEvent_AwsMskFailureReason {
	if x, ok := x.GetFailure().(*IngestionFailureEvent_AwsMskFailure); ok {
		return x.AwsMskFailure
	}
	return nil
}

func (x *IngestionFailureEvent) GetAzureEventHubsFailure() *IngestionFailureEvent_AzureEventHubsFailureReason {
	if x, ok := x.GetFailure().(*IngestionFailureEvent_AzureEventHubsFailure); ok {
		return x.AzureEventHubsFailure
	}
	return nil
}

func (x *IngestionFailureEvent) GetConfluentCloudFailure() *IngestionFailureEvent_ConfluentCloudFailureReason {
	if x, ok := x.GetFailure().(*IngestionFailureEvent_ConfluentCloudFailure); ok {
		return x.ConfluentCloudFailure
	}
	return nil
}

func (x *IngestionFailureEvent) GetAwsKinesisFailure() *IngestionFailureEvent_AwsKinesisFailureReason {
	if x, ok := x.GetFailure().(*IngestionFailureEvent_AwsKinesisFailure); ok {
		return x.AwsKinesisFailure
	}
	return nil
}

type isIngestionFailureEvent_Failure interface {
	isIngestionFailureEvent_Failure()
}

type IngestionFailureEvent_CloudStorageFailure_ struct {
	// Optional. Failure when ingesting from Cloud Storage.
	CloudStorageFailure *IngestionFailureEvent_CloudStorageFailure `protobuf:"bytes,3,opt,name=cloud_storage_failure,json=cloudStorageFailure,proto3,oneof"`
}

type IngestionFailureEvent_AwsMskFailure struct {
	// Optional. Failure when ingesting from Amazon MSK.
	AwsMskFailure *IngestionFailureEvent_AwsMskFailureReason `protobuf:"bytes,4,opt,name=aws_msk_failure,json=awsMskFailure,proto3,oneof"`
}

type IngestionFailureEvent_AzureEventHubsFailure struct {
	// Optional. Failure when ingesting from Azure Event Hubs.
	AzureEventHubsFailure *IngestionFailureEvent_AzureEventHubsFailureReason `protobuf:"bytes,5,opt,name=azure_event_hubs_failure,json=azureEventHubsFailure,proto3,oneof"`
}

type IngestionFailureEvent_ConfluentCloudFailure struct {
	// Optional. Failure when ingesting from Confluent Cloud.
	ConfluentCloudFailure *IngestionFailureEvent_ConfluentCloudFailureReason `protobuf:"bytes,6,opt,name=confluent_cloud_failure,json=confluentCloudFailure,proto3,oneof"`
}

type IngestionFailureEvent_AwsKinesisFailure struct {
	// Optional. Failure when ingesting from AWS Kinesis.
	AwsKinesisFailure *IngestionFailureEvent_AwsKinesisFailureReason `protobuf:"bytes,7,opt,name=aws_kinesis_failure,json=awsKinesisFailure,proto3,oneof"`
}

func (*IngestionFailureEvent_CloudStorageFailure_) isIngestionFailureEvent_Failure() {}

func (*IngestionFailureEvent_AwsMskFailure) isIngestionFailureEvent_Failure() {}

func (*IngestionFailureEvent_AzureEventHubsFailure) isIngestionFailureEvent_Failure() {}

func (*IngestionFailureEvent_ConfluentCloudFailure) isIngestionFailureEvent_Failure() {}

func (*IngestionFailureEvent_AwsKinesisFailure) isIngestionFailureEvent_Failure() {}

// User-defined JavaScript function that can transform or filter a Pub/Sub
// message.
type JavaScriptUDF struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the JavasScript function that should applied to Pub/Sub
	// messages.
	FunctionName string `protobuf:"bytes,1,opt,name=function_name,json=functionName,proto3" json:"function_name,omitempty"`
	// Required. JavaScript code that contains a function `function_name` with the
	// below signature:
	//
	// ```
	//
	//	/**
	//	* Transforms a Pub/Sub message.
	//
	//	* @return {(Object<string, (string | Object<string, string>)>|null)} - To
	//	* filter a message, return `null`. To transform a message return a map
	//	* with the following keys:
	//	*   - (required) 'data' : {string}
	//	*   - (optional) 'attributes' : {Object<string, string>}
	//	* Returning empty `attributes` will remove all attributes from the
	//	* message.
	//	*
	//	* @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
	//	* message. Keys:
	//	*   - (required) 'data' : {string}
	//	*   - (required) 'attributes' : {Object<string, string>}
	//	*
	//	* @param  {Object<string, any>} metadata - Pub/Sub message metadata.
	//	* Keys:
	//	*   - (optional) 'message_id'  : {string}
	//	*   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
	//	*   - (optional) 'ordering_key': {string}
	//	*/
	//
	//	function <function_name>(message, metadata) {
	//	}
	//
	// ```
	Code string `protobuf:"bytes,2,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *JavaScriptUDF) Reset() {
	*x = JavaScriptUDF{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JavaScriptUDF) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JavaScriptUDF) ProtoMessage() {}

func (x *JavaScriptUDF) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JavaScriptUDF.ProtoReflect.Descriptor instead.
func (*JavaScriptUDF) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{5}
}

func (x *JavaScriptUDF) GetFunctionName() string {
	if x != nil {
		return x.FunctionName
	}
	return ""
}

func (x *JavaScriptUDF) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// All supported message transforms types.
type MessageTransform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of transform to apply to messages.
	//
	// Types that are assignable to Transform:
	//
	//	*MessageTransform_JavascriptUdf
	Transform isMessageTransform_Transform `protobuf_oneof:"transform"`
	// Optional. This field is deprecated, use the `disabled` field to disable
	// transforms.
	//
	// Deprecated: Marked as deprecated in google/pubsub/v1/pubsub.proto.
	Enabled bool `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. If true, the transform is disabled and will not be applied to
	// messages. Defaults to `false`.
	Disabled bool `protobuf:"varint,4,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *MessageTransform) Reset() {
	*x = MessageTransform{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageTransform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageTransform) ProtoMessage() {}

func (x *MessageTransform) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageTransform.ProtoReflect.Descriptor instead.
func (*MessageTransform) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{6}
}

func (m *MessageTransform) GetTransform() isMessageTransform_Transform {
	if m != nil {
		return m.Transform
	}
	return nil
}

func (x *MessageTransform) GetJavascriptUdf() *JavaScriptUDF {
	if x, ok := x.GetTransform().(*MessageTransform_JavascriptUdf); ok {
		return x.JavascriptUdf
	}
	return nil
}

// Deprecated: Marked as deprecated in google/pubsub/v1/pubsub.proto.
func (x *MessageTransform) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *MessageTransform) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

type isMessageTransform_Transform interface {
	isMessageTransform_Transform()
}

type MessageTransform_JavascriptUdf struct {
	// Optional. JavaScript User Defined Function. If multiple JavaScriptUDF's
	// are specified on a resource, each must have a unique `function_name`.
	JavascriptUdf *JavaScriptUDF `protobuf:"bytes,2,opt,name=javascript_udf,json=javascriptUdf,proto3,oneof"`
}

func (*MessageTransform_JavascriptUdf) isMessageTransform_Transform() {}

// A topic resource.
type Topic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the topic. It must have the format
	// `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
	// and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
	// underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
	// signs (`%`). It must be between 3 and 255 characters in length, and it
	// must not start with `"goog"`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. See [Creating and managing labels]
	// (https://cloud.google.com/pubsub/docs/labels).
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Policy constraining the set of Google Cloud Platform regions
	// where messages published to the topic may be stored. If not present, then
	// no constraints are in effect.
	MessageStoragePolicy *MessageStoragePolicy `protobuf:"bytes,3,opt,name=message_storage_policy,json=messageStoragePolicy,proto3" json:"message_storage_policy,omitempty"`
	// Optional. The resource name of the Cloud KMS CryptoKey to be used to
	// protect access to messages published on this topic.
	//
	// The expected format is `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	KmsKeyName string `protobuf:"bytes,5,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Optional. Settings for validating messages published against a schema.
	SchemaSettings *SchemaSettings `protobuf:"bytes,6,opt,name=schema_settings,json=schemaSettings,proto3" json:"schema_settings,omitempty"`
	// Optional. Reserved for future use. This field is set only in responses from
	// the server; it is ignored if it is set in any requests.
	SatisfiesPzs bool `protobuf:"varint,7,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Optional. Indicates the minimum duration to retain a message after it is
	// published to the topic. If this field is set, messages published to the
	// topic in the last `message_retention_duration` are always available to
	// subscribers. For instance, it allows any attached subscription to [seek to
	// a
	// timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
	// that is up to `message_retention_duration` in the past. If this field is
	// not set, message retention is controlled by settings on individual
	// subscriptions. Cannot be more than 31 days or less than 10 minutes.
	MessageRetentionDuration *durationpb.Duration `protobuf:"bytes,8,opt,name=message_retention_duration,json=messageRetentionDuration,proto3" json:"message_retention_duration,omitempty"`
	// Output only. An output-only field indicating the state of the topic.
	State Topic_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.pubsub.v1.Topic_State" json:"state,omitempty"`
	// Optional. Settings for ingestion from a data source into this topic.
	IngestionDataSourceSettings *IngestionDataSourceSettings `protobuf:"bytes,10,opt,name=ingestion_data_source_settings,json=ingestionDataSourceSettings,proto3" json:"ingestion_data_source_settings,omitempty"`
	// Optional. Transforms to be applied to messages published to the topic.
	// Transforms are applied in the order specified.
	MessageTransforms []*MessageTransform `protobuf:"bytes,13,rep,name=message_transforms,json=messageTransforms,proto3" json:"message_transforms,omitempty"`
	// Optional. Input only. Immutable. Tag keys/values directly bound to this
	// resource. For example:
	//
	//	"123/environment": "production",
	//	"123/costCenter": "marketing"
	Tags map[string]string `protobuf:"bytes,14,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Topic) Reset() {
	*x = Topic{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Topic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic) ProtoMessage() {}

func (x *Topic) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic.ProtoReflect.Descriptor instead.
func (*Topic) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{7}
}

func (x *Topic) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Topic) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Topic) GetMessageStoragePolicy() *MessageStoragePolicy {
	if x != nil {
		return x.MessageStoragePolicy
	}
	return nil
}

func (x *Topic) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Topic) GetSchemaSettings() *SchemaSettings {
	if x != nil {
		return x.SchemaSettings
	}
	return nil
}

func (x *Topic) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *Topic) GetMessageRetentionDuration() *durationpb.Duration {
	if x != nil {
		return x.MessageRetentionDuration
	}
	return nil
}

func (x *Topic) GetState() Topic_State {
	if x != nil {
		return x.State
	}
	return Topic_STATE_UNSPECIFIED
}

func (x *Topic) GetIngestionDataSourceSettings() *IngestionDataSourceSettings {
	if x != nil {
		return x.IngestionDataSourceSettings
	}
	return nil
}

func (x *Topic) GetMessageTransforms() []*MessageTransform {
	if x != nil {
		return x.MessageTransforms
	}
	return nil
}

func (x *Topic) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// A message that is published by publishers and consumed by subscribers. The
// message must contain either a non-empty data field or at least one attribute.
// Note that client libraries represent this object differently
// depending on the language. See the corresponding [client library
// documentation](https://cloud.google.com/pubsub/docs/reference/libraries) for
// more information. See [quotas and limits]
// (https://cloud.google.com/pubsub/quotas) for more information about message
// limits.
type PubsubMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The message data field. If this field is empty, the message must
	// contain at least one attribute.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Optional. Attributes for this message. If this field is empty, the message
	// must contain non-empty data. This can be used to filter messages on the
	// subscription.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of this message, assigned by the server when the message is published.
	// Guaranteed to be unique within the topic. This value may be read by a
	// subscriber that receives a `PubsubMessage` via a `Pull` call or a push
	// delivery. It must not be populated by the publisher in a `Publish` call.
	MessageId string `protobuf:"bytes,3,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// The time at which the message was published, populated by the server when
	// it receives the `Publish` call. It must not be populated by the
	// publisher in a `Publish` call.
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// Optional. If non-empty, identifies related messages for which publish order
	// should be respected. If a `Subscription` has `enable_message_ordering` set
	// to `true`, messages published with the same non-empty `ordering_key` value
	// will be delivered to subscribers in the order in which they are received by
	// the Pub/Sub system. All `PubsubMessage`s published in a given
	// `PublishRequest` must specify the same `ordering_key` value. For more
	// information, see [ordering
	// messages](https://cloud.google.com/pubsub/docs/ordering).
	OrderingKey string `protobuf:"bytes,5,opt,name=ordering_key,json=orderingKey,proto3" json:"ordering_key,omitempty"`
}

func (x *PubsubMessage) Reset() {
	*x = PubsubMessage{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PubsubMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubMessage) ProtoMessage() {}

func (x *PubsubMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubMessage.ProtoReflect.Descriptor instead.
func (*PubsubMessage) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{8}
}

func (x *PubsubMessage) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *PubsubMessage) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *PubsubMessage) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *PubsubMessage) GetPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishTime
	}
	return nil
}

func (x *PubsubMessage) GetOrderingKey() string {
	if x != nil {
		return x.OrderingKey
	}
	return ""
}

// Request for the GetTopic method.
type GetTopicRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the topic to get.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *GetTopicRequest) Reset() {
	*x = GetTopicRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTopicRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTopicRequest) ProtoMessage() {}

func (x *GetTopicRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTopicRequest.ProtoReflect.Descriptor instead.
func (*GetTopicRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{9}
}

func (x *GetTopicRequest) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Request for the UpdateTopic method.
type UpdateTopicRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated topic object.
	Topic *Topic `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Required. Indicates which fields in the provided topic to update. Must be
	// specified and non-empty. Note that if `update_mask` contains
	// "message_storage_policy" but the `message_storage_policy` is not set in
	// the `topic` provided above, then the updated value is determined by the
	// policy configured at the project or organization level.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTopicRequest) Reset() {
	*x = UpdateTopicRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTopicRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTopicRequest) ProtoMessage() {}

func (x *UpdateTopicRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTopicRequest.ProtoReflect.Descriptor instead.
func (*UpdateTopicRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateTopicRequest) GetTopic() *Topic {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *UpdateTopicRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the Publish method.
type PublishRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The messages in the request will be published on this topic.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Required. The messages to publish.
	Messages []*PubsubMessage `protobuf:"bytes,2,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (x *PublishRequest) Reset() {
	*x = PublishRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublishRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishRequest) ProtoMessage() {}

func (x *PublishRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishRequest.ProtoReflect.Descriptor instead.
func (*PublishRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{11}
}

func (x *PublishRequest) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *PublishRequest) GetMessages() []*PubsubMessage {
	if x != nil {
		return x.Messages
	}
	return nil
}

// Response for the `Publish` method.
type PublishResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The server-assigned ID of each published message, in the same
	// order as the messages in the request. IDs are guaranteed to be unique
	// within the topic.
	MessageIds []string `protobuf:"bytes,1,rep,name=message_ids,json=messageIds,proto3" json:"message_ids,omitempty"`
}

func (x *PublishResponse) Reset() {
	*x = PublishResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublishResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishResponse) ProtoMessage() {}

func (x *PublishResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishResponse.ProtoReflect.Descriptor instead.
func (*PublishResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{12}
}

func (x *PublishResponse) GetMessageIds() []string {
	if x != nil {
		return x.MessageIds
	}
	return nil
}

// Request for the `ListTopics` method.
type ListTopicsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which to list topics.
	// Format is `projects/{project-id}`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Optional. Maximum number of topics to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListTopicsResponse`; indicates
	// that this is a continuation of a prior `ListTopics` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTopicsRequest) Reset() {
	*x = ListTopicsRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTopicsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTopicsRequest) ProtoMessage() {}

func (x *ListTopicsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTopicsRequest.ProtoReflect.Descriptor instead.
func (*ListTopicsRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{13}
}

func (x *ListTopicsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ListTopicsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTopicsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the `ListTopics` method.
type ListTopicsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The resulting topics.
	Topics []*Topic `protobuf:"bytes,1,rep,name=topics,proto3" json:"topics,omitempty"`
	// Optional. If not empty, indicates that there may be more topics that match
	// the request; this value should be passed in a new `ListTopicsRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTopicsResponse) Reset() {
	*x = ListTopicsResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTopicsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTopicsResponse) ProtoMessage() {}

func (x *ListTopicsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTopicsResponse.ProtoReflect.Descriptor instead.
func (*ListTopicsResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{14}
}

func (x *ListTopicsResponse) GetTopics() []*Topic {
	if x != nil {
		return x.Topics
	}
	return nil
}

func (x *ListTopicsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the `ListTopicSubscriptions` method.
type ListTopicSubscriptionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the topic that subscriptions are attached to.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Optional. Maximum number of subscription names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListTopicSubscriptionsResponse`;
	// indicates that this is a continuation of a prior `ListTopicSubscriptions`
	// call, and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTopicSubscriptionsRequest) Reset() {
	*x = ListTopicSubscriptionsRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTopicSubscriptionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTopicSubscriptionsRequest) ProtoMessage() {}

func (x *ListTopicSubscriptionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTopicSubscriptionsRequest.ProtoReflect.Descriptor instead.
func (*ListTopicSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{15}
}

func (x *ListTopicSubscriptionsRequest) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *ListTopicSubscriptionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTopicSubscriptionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the `ListTopicSubscriptions` method.
type ListTopicSubscriptionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The names of subscriptions attached to the topic specified in the
	// request.
	Subscriptions []string `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Optional. If not empty, indicates that there may be more subscriptions that
	// match the request; this value should be passed in a new
	// `ListTopicSubscriptionsRequest` to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTopicSubscriptionsResponse) Reset() {
	*x = ListTopicSubscriptionsResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTopicSubscriptionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTopicSubscriptionsResponse) ProtoMessage() {}

func (x *ListTopicSubscriptionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTopicSubscriptionsResponse.ProtoReflect.Descriptor instead.
func (*ListTopicSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{16}
}

func (x *ListTopicSubscriptionsResponse) GetSubscriptions() []string {
	if x != nil {
		return x.Subscriptions
	}
	return nil
}

func (x *ListTopicSubscriptionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the `ListTopicSnapshots` method.
type ListTopicSnapshotsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the topic that snapshots are attached to.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Optional. Maximum number of snapshot names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListTopicSnapshotsResponse`;
	// indicates that this is a continuation of a prior `ListTopicSnapshots` call,
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTopicSnapshotsRequest) Reset() {
	*x = ListTopicSnapshotsRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTopicSnapshotsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTopicSnapshotsRequest) ProtoMessage() {}

func (x *ListTopicSnapshotsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTopicSnapshotsRequest.ProtoReflect.Descriptor instead.
func (*ListTopicSnapshotsRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{17}
}

func (x *ListTopicSnapshotsRequest) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *ListTopicSnapshotsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTopicSnapshotsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the `ListTopicSnapshots` method.
type ListTopicSnapshotsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The names of the snapshots that match the request.
	Snapshots []string `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// Optional. If not empty, indicates that there may be more snapshots that
	// match the request; this value should be passed in a new
	// `ListTopicSnapshotsRequest` to get more snapshots.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTopicSnapshotsResponse) Reset() {
	*x = ListTopicSnapshotsResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTopicSnapshotsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTopicSnapshotsResponse) ProtoMessage() {}

func (x *ListTopicSnapshotsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTopicSnapshotsResponse.ProtoReflect.Descriptor instead.
func (*ListTopicSnapshotsResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{18}
}

func (x *ListTopicSnapshotsResponse) GetSnapshots() []string {
	if x != nil {
		return x.Snapshots
	}
	return nil
}

func (x *ListTopicSnapshotsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the `DeleteTopic` method.
type DeleteTopicRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the topic to delete.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *DeleteTopicRequest) Reset() {
	*x = DeleteTopicRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTopicRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTopicRequest) ProtoMessage() {}

func (x *DeleteTopicRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTopicRequest.ProtoReflect.Descriptor instead.
func (*DeleteTopicRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteTopicRequest) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Request for the DetachSubscription method.
type DetachSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subscription to detach.
	// Format is `projects/{project}/subscriptions/{subscription}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *DetachSubscriptionRequest) Reset() {
	*x = DetachSubscriptionRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DetachSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetachSubscriptionRequest) ProtoMessage() {}

func (x *DetachSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetachSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*DetachSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{20}
}

func (x *DetachSubscriptionRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

// Response for the DetachSubscription method.
// Reserved for future use.
type DetachSubscriptionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DetachSubscriptionResponse) Reset() {
	*x = DetachSubscriptionResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DetachSubscriptionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetachSubscriptionResponse) ProtoMessage() {}

func (x *DetachSubscriptionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetachSubscriptionResponse.ProtoReflect.Descriptor instead.
func (*DetachSubscriptionResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{21}
}

// A subscription resource. If none of `push_config`, `bigquery_config`, or
// `cloud_storage_config` is set, then the subscriber will pull and ack messages
// using API methods. At most one of these fields may be set.
type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the subscription. It must have the format
	// `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
	// start with a letter, and contain only letters (`[A-Za-z]`), numbers
	// (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
	// plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
	// in length, and it must not start with `"goog"`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the topic from which this subscription is receiving
	// messages. Format is `projects/{project}/topics/{topic}`. The value of this
	// field will be `_deleted-topic_` if the topic has been deleted.
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// Optional. If push delivery is used with this subscription, this field is
	// used to configure it.
	PushConfig *PushConfig `protobuf:"bytes,4,opt,name=push_config,json=pushConfig,proto3" json:"push_config,omitempty"`
	// Optional. If delivery to BigQuery is used with this subscription, this
	// field is used to configure it.
	BigqueryConfig *BigQueryConfig `protobuf:"bytes,18,opt,name=bigquery_config,json=bigqueryConfig,proto3" json:"bigquery_config,omitempty"`
	// Optional. If delivery to Google Cloud Storage is used with this
	// subscription, this field is used to configure it.
	CloudStorageConfig *CloudStorageConfig `protobuf:"bytes,22,opt,name=cloud_storage_config,json=cloudStorageConfig,proto3" json:"cloud_storage_config,omitempty"`
	// Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
	// waits for the subscriber to acknowledge receipt before resending the
	// message. In the interval after the message is delivered and before it is
	// acknowledged, it is considered to be _outstanding_. During that time
	// period, the message will not be redelivered (on a best-effort basis).
	//
	// For pull subscriptions, this value is used as the initial value for the ack
	// deadline. To override this value for a given message, call
	// `ModifyAckDeadline` with the corresponding `ack_id` if using
	// non-streaming pull or send the `ack_id` in a
	// `StreamingModifyAckDeadlineRequest` if using streaming pull.
	// The minimum custom deadline you can specify is 10 seconds.
	// The maximum custom deadline you can specify is 600 seconds (10 minutes).
	// If this parameter is 0, a default value of 10 seconds is used.
	//
	// For push delivery, this value is also used to set the request timeout for
	// the call to the push endpoint.
	//
	// If the subscriber never acknowledges the message, the Pub/Sub
	// system will eventually redeliver the message.
	AckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds,proto3" json:"ack_deadline_seconds,omitempty"`
	// Optional. Indicates whether to retain acknowledged messages. If true, then
	// messages are not expunged from the subscription's backlog, even if they are
	// acknowledged, until they fall out of the `message_retention_duration`
	// window. This must be true if you would like to [`Seek` to a timestamp]
	// (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
	// the past to replay previously-acknowledged messages.
	RetainAckedMessages bool `protobuf:"varint,7,opt,name=retain_acked_messages,json=retainAckedMessages,proto3" json:"retain_acked_messages,omitempty"`
	// Optional. How long to retain unacknowledged messages in the subscription's
	// backlog, from the moment a message is published. If `retain_acked_messages`
	// is true, then this also configures the retention of acknowledged messages,
	// and thus configures how far back in time a `Seek` can be done. Defaults to
	// 7 days. Cannot be more than 31 days or less than 10 minutes.
	MessageRetentionDuration *durationpb.Duration `protobuf:"bytes,8,opt,name=message_retention_duration,json=messageRetentionDuration,proto3" json:"message_retention_duration,omitempty"`
	// Optional. See [Creating and managing
	// labels](https://cloud.google.com/pubsub/docs/labels).
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. If true, messages published with the same `ordering_key` in
	// `PubsubMessage` will be delivered to the subscribers in the order in which
	// they are received by the Pub/Sub system. Otherwise, they may be delivered
	// in any order.
	EnableMessageOrdering bool `protobuf:"varint,10,opt,name=enable_message_ordering,json=enableMessageOrdering,proto3" json:"enable_message_ordering,omitempty"`
	// Optional. A policy that specifies the conditions for this subscription's
	// expiration. A subscription is considered active as long as any connected
	// subscriber is successfully consuming messages from the subscription or is
	// issuing operations on the subscription. If `expiration_policy` is not set,
	// a *default policy* with `ttl` of 31 days will be used. The minimum allowed
	// value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
	// but `expiration_policy.ttl` is not set, the subscription never expires.
	ExpirationPolicy *ExpirationPolicy `protobuf:"bytes,11,opt,name=expiration_policy,json=expirationPolicy,proto3" json:"expiration_policy,omitempty"`
	// Optional. An expression written in the Pub/Sub [filter
	// language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
	// then only `PubsubMessage`s whose `attributes` field matches the filter are
	// delivered on this subscription. If empty, then no messages are filtered
	// out.
	Filter string `protobuf:"bytes,12,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. A policy that specifies the conditions for dead lettering
	// messages in this subscription. If dead_letter_policy is not set, dead
	// lettering is disabled.
	//
	// The Pub/Sub service account associated with this subscriptions's
	// parent project (i.e.,
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
	// permission to Acknowledge() messages on this subscription.
	DeadLetterPolicy *DeadLetterPolicy `protobuf:"bytes,13,opt,name=dead_letter_policy,json=deadLetterPolicy,proto3" json:"dead_letter_policy,omitempty"`
	// Optional. A policy that specifies how Pub/Sub retries message delivery for
	// this subscription.
	//
	// If not set, the default retry policy is applied. This generally implies
	// that messages will be retried as soon as possible for healthy subscribers.
	// RetryPolicy will be triggered on NACKs or acknowledgment deadline exceeded
	// events for a given message.
	RetryPolicy *RetryPolicy `protobuf:"bytes,14,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
	// Optional. Indicates whether the subscription is detached from its topic.
	// Detached subscriptions don't receive messages from their topic and don't
	// retain any backlog. `Pull` and `StreamingPull` requests will return
	// FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
	// the endpoint will not be made.
	Detached bool `protobuf:"varint,15,opt,name=detached,proto3" json:"detached,omitempty"`
	// Optional. If true, Pub/Sub provides the following guarantees for the
	// delivery of a message with a given value of `message_id` on this
	// subscription:
	//
	// * The message sent to a subscriber is guaranteed not to be resent
	// before the message's acknowledgment deadline expires.
	// * An acknowledged message will not be resent to a subscriber.
	//
	// Note that subscribers may still receive multiple copies of a message
	// when `enable_exactly_once_delivery` is true if the message was published
	// multiple times by a publisher client. These copies are  considered distinct
	// by Pub/Sub and have distinct `message_id` values.
	EnableExactlyOnceDelivery bool `protobuf:"varint,16,opt,name=enable_exactly_once_delivery,json=enableExactlyOnceDelivery,proto3" json:"enable_exactly_once_delivery,omitempty"`
	// Output only. Indicates the minimum duration for which a message is retained
	// after it is published to the subscription's topic. If this field is set,
	// messages published to the subscription's topic in the last
	// `topic_message_retention_duration` are always available to subscribers. See
	// the `message_retention_duration` field in `Topic`. This field is set only
	// in responses from the server; it is ignored if it is set in any requests.
	TopicMessageRetentionDuration *durationpb.Duration `protobuf:"bytes,17,opt,name=topic_message_retention_duration,json=topicMessageRetentionDuration,proto3" json:"topic_message_retention_duration,omitempty"`
	// Output only. An output-only field indicating whether or not the
	// subscription can receive messages.
	State Subscription_State `protobuf:"varint,19,opt,name=state,proto3,enum=google.pubsub.v1.Subscription_State" json:"state,omitempty"`
	// Output only. Information about the associated Analytics Hub subscription.
	// Only set if the subscritpion is created by Analytics Hub.
	AnalyticsHubSubscriptionInfo *Subscription_AnalyticsHubSubscriptionInfo `protobuf:"bytes,23,opt,name=analytics_hub_subscription_info,json=analyticsHubSubscriptionInfo,proto3" json:"analytics_hub_subscription_info,omitempty"`
	// Optional. Transforms to be applied to messages before they are delivered to
	// subscribers. Transforms are applied in the order specified.
	MessageTransforms []*MessageTransform `protobuf:"bytes,25,rep,name=message_transforms,json=messageTransforms,proto3" json:"message_transforms,omitempty"`
	// Optional. Input only. Immutable. Tag keys/values directly bound to this
	// resource. For example:
	//
	//	"123/environment": "production",
	//	"123/costCenter": "marketing"
	Tags map[string]string `protobuf:"bytes,26,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{22}
}

func (x *Subscription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subscription) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *Subscription) GetPushConfig() *PushConfig {
	if x != nil {
		return x.PushConfig
	}
	return nil
}

func (x *Subscription) GetBigqueryConfig() *BigQueryConfig {
	if x != nil {
		return x.BigqueryConfig
	}
	return nil
}

func (x *Subscription) GetCloudStorageConfig() *CloudStorageConfig {
	if x != nil {
		return x.CloudStorageConfig
	}
	return nil
}

func (x *Subscription) GetAckDeadlineSeconds() int32 {
	if x != nil {
		return x.AckDeadlineSeconds
	}
	return 0
}

func (x *Subscription) GetRetainAckedMessages() bool {
	if x != nil {
		return x.RetainAckedMessages
	}
	return false
}

func (x *Subscription) GetMessageRetentionDuration() *durationpb.Duration {
	if x != nil {
		return x.MessageRetentionDuration
	}
	return nil
}

func (x *Subscription) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Subscription) GetEnableMessageOrdering() bool {
	if x != nil {
		return x.EnableMessageOrdering
	}
	return false
}

func (x *Subscription) GetExpirationPolicy() *ExpirationPolicy {
	if x != nil {
		return x.ExpirationPolicy
	}
	return nil
}

func (x *Subscription) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *Subscription) GetDeadLetterPolicy() *DeadLetterPolicy {
	if x != nil {
		return x.DeadLetterPolicy
	}
	return nil
}

func (x *Subscription) GetRetryPolicy() *RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

func (x *Subscription) GetDetached() bool {
	if x != nil {
		return x.Detached
	}
	return false
}

func (x *Subscription) GetEnableExactlyOnceDelivery() bool {
	if x != nil {
		return x.EnableExactlyOnceDelivery
	}
	return false
}

func (x *Subscription) GetTopicMessageRetentionDuration() *durationpb.Duration {
	if x != nil {
		return x.TopicMessageRetentionDuration
	}
	return nil
}

func (x *Subscription) GetState() Subscription_State {
	if x != nil {
		return x.State
	}
	return Subscription_STATE_UNSPECIFIED
}

func (x *Subscription) GetAnalyticsHubSubscriptionInfo() *Subscription_AnalyticsHubSubscriptionInfo {
	if x != nil {
		return x.AnalyticsHubSubscriptionInfo
	}
	return nil
}

func (x *Subscription) GetMessageTransforms() []*MessageTransform {
	if x != nil {
		return x.MessageTransforms
	}
	return nil
}

func (x *Subscription) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// A policy that specifies how Pub/Sub retries message delivery.
//
// Retry delay will be exponential based on provided minimum and maximum
// backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
//
// RetryPolicy will be triggered on NACKs or acknowledgment deadline exceeded
// events for a given message.
//
// Retry Policy is implemented on a best effort basis. At times, the delay
// between consecutive deliveries may not match the configuration. That is,
// delay can be more or less than configured backoff.
type RetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The minimum delay between consecutive deliveries of a given
	// message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
	MinimumBackoff *durationpb.Duration `protobuf:"bytes,1,opt,name=minimum_backoff,json=minimumBackoff,proto3" json:"minimum_backoff,omitempty"`
	// Optional. The maximum delay between consecutive deliveries of a given
	// message. Value should be between 0 and 600 seconds. Defaults to 600
	// seconds.
	MaximumBackoff *durationpb.Duration `protobuf:"bytes,2,opt,name=maximum_backoff,json=maximumBackoff,proto3" json:"maximum_backoff,omitempty"`
}

func (x *RetryPolicy) Reset() {
	*x = RetryPolicy{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryPolicy) ProtoMessage() {}

func (x *RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryPolicy.ProtoReflect.Descriptor instead.
func (*RetryPolicy) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{23}
}

func (x *RetryPolicy) GetMinimumBackoff() *durationpb.Duration {
	if x != nil {
		return x.MinimumBackoff
	}
	return nil
}

func (x *RetryPolicy) GetMaximumBackoff() *durationpb.Duration {
	if x != nil {
		return x.MaximumBackoff
	}
	return nil
}

// Dead lettering is done on a best effort basis. The same message might be
// dead lettered multiple times.
//
// If validation on any of the fields fails at subscription creation/updation,
// the create/update subscription request will fail.
type DeadLetterPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the topic to which dead letter messages should be
	// published. Format is `projects/{project}/topics/{topic}`.The Pub/Sub
	// service account associated with the enclosing subscription's parent project
	// (i.e., service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must
	// have permission to Publish() to this topic.
	//
	// The operation will fail if the topic does not exist.
	// Users should ensure that there is a subscription attached to this topic
	// since messages published to a topic with no subscriptions are lost.
	DeadLetterTopic string `protobuf:"bytes,1,opt,name=dead_letter_topic,json=deadLetterTopic,proto3" json:"dead_letter_topic,omitempty"`
	// Optional. The maximum number of delivery attempts for any message. The
	// value must be between 5 and 100.
	//
	// The number of delivery attempts is defined as 1 + (the sum of number of
	// NACKs and number of times the acknowledgment deadline has been exceeded
	// for the message).
	//
	// A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
	// client libraries may automatically extend ack_deadlines.
	//
	// This field will be honored on a best effort basis.
	//
	// If this parameter is 0, a default value of 5 is used.
	MaxDeliveryAttempts int32 `protobuf:"varint,2,opt,name=max_delivery_attempts,json=maxDeliveryAttempts,proto3" json:"max_delivery_attempts,omitempty"`
}

func (x *DeadLetterPolicy) Reset() {
	*x = DeadLetterPolicy{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeadLetterPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeadLetterPolicy) ProtoMessage() {}

func (x *DeadLetterPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeadLetterPolicy.ProtoReflect.Descriptor instead.
func (*DeadLetterPolicy) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{24}
}

func (x *DeadLetterPolicy) GetDeadLetterTopic() string {
	if x != nil {
		return x.DeadLetterTopic
	}
	return ""
}

func (x *DeadLetterPolicy) GetMaxDeliveryAttempts() int32 {
	if x != nil {
		return x.MaxDeliveryAttempts
	}
	return 0
}

// A policy that specifies the conditions for resource expiration (i.e.,
// automatic resource deletion).
type ExpirationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the "time-to-live" duration for an associated resource.
	// The resource expires if it is not active for a period of `ttl`. The
	// definition of "activity" depends on the type of the associated resource.
	// The minimum and maximum allowed values for `ttl` depend on the type of the
	// associated resource, as well. If `ttl` is not set, the associated resource
	// never expires.
	Ttl *durationpb.Duration `protobuf:"bytes,1,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (x *ExpirationPolicy) Reset() {
	*x = ExpirationPolicy{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExpirationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpirationPolicy) ProtoMessage() {}

func (x *ExpirationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpirationPolicy.ProtoReflect.Descriptor instead.
func (*ExpirationPolicy) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{25}
}

func (x *ExpirationPolicy) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

// Configuration for a push delivery endpoint.
type PushConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A URL locating the endpoint to which messages should be pushed.
	// For example, a Webhook endpoint might use `https://example.com/push`.
	PushEndpoint string `protobuf:"bytes,1,opt,name=push_endpoint,json=pushEndpoint,proto3" json:"push_endpoint,omitempty"`
	// Optional. Endpoint configuration attributes that can be used to control
	// different aspects of the message delivery.
	//
	// The only currently supported attribute is `x-goog-version`, which you can
	// use to change the format of the pushed message. This attribute
	// indicates the version of the data expected by the endpoint. This
	// controls the shape of the pushed message (i.e., its fields and metadata).
	//
	// If not present during the `CreateSubscription` call, it will default to
	// the version of the Pub/Sub API used to make such call. If not present in a
	// `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
	// calls will always return a valid version, even if the subscription was
	// created without this attribute.
	//
	// The only supported values for the `x-goog-version` attribute are:
	//
	// * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
	// * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
	//
	// For example:
	// `attributes { "x-goog-version": "v1" }`
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An authentication method used by push endpoints to verify the source of
	// push requests. This can be used with push endpoints that are private by
	// default to allow requests only from the Pub/Sub system, for example.
	// This field is optional and should be set only by users interested in
	// authenticated push.
	//
	// Types that are assignable to AuthenticationMethod:
	//
	//	*PushConfig_OidcToken_
	AuthenticationMethod isPushConfig_AuthenticationMethod `protobuf_oneof:"authentication_method"`
	// The format of the delivered message to the push endpoint is defined by
	// the chosen wrapper. When unset, `PubsubWrapper` is used.
	//
	// Types that are assignable to Wrapper:
	//
	//	*PushConfig_PubsubWrapper_
	//	*PushConfig_NoWrapper_
	Wrapper isPushConfig_Wrapper `protobuf_oneof:"wrapper"`
}

func (x *PushConfig) Reset() {
	*x = PushConfig{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushConfig) ProtoMessage() {}

func (x *PushConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushConfig.ProtoReflect.Descriptor instead.
func (*PushConfig) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{26}
}

func (x *PushConfig) GetPushEndpoint() string {
	if x != nil {
		return x.PushEndpoint
	}
	return ""
}

func (x *PushConfig) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (m *PushConfig) GetAuthenticationMethod() isPushConfig_AuthenticationMethod {
	if m != nil {
		return m.AuthenticationMethod
	}
	return nil
}

func (x *PushConfig) GetOidcToken() *PushConfig_OidcToken {
	if x, ok := x.GetAuthenticationMethod().(*PushConfig_OidcToken_); ok {
		return x.OidcToken
	}
	return nil
}

func (m *PushConfig) GetWrapper() isPushConfig_Wrapper {
	if m != nil {
		return m.Wrapper
	}
	return nil
}

func (x *PushConfig) GetPubsubWrapper() *PushConfig_PubsubWrapper {
	if x, ok := x.GetWrapper().(*PushConfig_PubsubWrapper_); ok {
		return x.PubsubWrapper
	}
	return nil
}

func (x *PushConfig) GetNoWrapper() *PushConfig_NoWrapper {
	if x, ok := x.GetWrapper().(*PushConfig_NoWrapper_); ok {
		return x.NoWrapper
	}
	return nil
}

type isPushConfig_AuthenticationMethod interface {
	isPushConfig_AuthenticationMethod()
}

type PushConfig_OidcToken_ struct {
	// Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
	// token as an `Authorization` header in the HTTP request for every pushed
	// message.
	OidcToken *PushConfig_OidcToken `protobuf:"bytes,3,opt,name=oidc_token,json=oidcToken,proto3,oneof"`
}

func (*PushConfig_OidcToken_) isPushConfig_AuthenticationMethod() {}

type isPushConfig_Wrapper interface {
	isPushConfig_Wrapper()
}

type PushConfig_PubsubWrapper_ struct {
	// Optional. When set, the payload to the push endpoint is in the form of
	// the JSON representation of a PubsubMessage
	// (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
	PubsubWrapper *PushConfig_PubsubWrapper `protobuf:"bytes,4,opt,name=pubsub_wrapper,json=pubsubWrapper,proto3,oneof"`
}

type PushConfig_NoWrapper_ struct {
	// Optional. When set, the payload to the push endpoint is not wrapped.
	NoWrapper *PushConfig_NoWrapper `protobuf:"bytes,5,opt,name=no_wrapper,json=noWrapper,proto3,oneof"`
}

func (*PushConfig_PubsubWrapper_) isPushConfig_Wrapper() {}

func (*PushConfig_NoWrapper_) isPushConfig_Wrapper() {}

// Configuration for a BigQuery subscription.
type BigQueryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the table to which to write data, of the form
	// {projectId}.{datasetId}.{tableId}
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Optional. When true, use the topic's schema as the columns to write to in
	// BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
	// enabled at the same time.
	UseTopicSchema bool `protobuf:"varint,2,opt,name=use_topic_schema,json=useTopicSchema,proto3" json:"use_topic_schema,omitempty"`
	// Optional. When true, write the subscription name, message_id, publish_time,
	// attributes, and ordering_key to additional columns in the table. The
	// subscription name, message_id, and publish_time fields are put in their own
	// columns while all other message properties (other than data) are written to
	// a JSON object in the attributes column.
	WriteMetadata bool `protobuf:"varint,3,opt,name=write_metadata,json=writeMetadata,proto3" json:"write_metadata,omitempty"`
	// Optional. When true and use_topic_schema is true, any fields that are a
	// part of the topic schema that are not part of the BigQuery table schema are
	// dropped when writing to BigQuery. Otherwise, the schemas must be kept in
	// sync and any messages with extra fields are not written and remain in the
	// subscription's backlog.
	DropUnknownFields bool `protobuf:"varint,4,opt,name=drop_unknown_fields,json=dropUnknownFields,proto3" json:"drop_unknown_fields,omitempty"`
	// Output only. An output-only field that indicates whether or not the
	// subscription can receive messages.
	State BigQueryConfig_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.pubsub.v1.BigQueryConfig_State" json:"state,omitempty"`
	// Optional. When true, use the BigQuery table's schema as the columns to
	// write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
	// enabled at the same time.
	UseTableSchema bool `protobuf:"varint,6,opt,name=use_table_schema,json=useTableSchema,proto3" json:"use_table_schema,omitempty"`
	// Optional. The service account to use to write to BigQuery. The subscription
	// creator or updater that specifies this field must have
	// `iam.serviceAccounts.actAs` permission on the service account. If not
	// specified, the Pub/Sub [service
	// agent](https://cloud.google.com/iam/docs/service-agents),
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
	ServiceAccountEmail string `protobuf:"bytes,7,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
}

func (x *BigQueryConfig) Reset() {
	*x = BigQueryConfig{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigQueryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryConfig) ProtoMessage() {}

func (x *BigQueryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryConfig.ProtoReflect.Descriptor instead.
func (*BigQueryConfig) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{27}
}

func (x *BigQueryConfig) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *BigQueryConfig) GetUseTopicSchema() bool {
	if x != nil {
		return x.UseTopicSchema
	}
	return false
}

func (x *BigQueryConfig) GetWriteMetadata() bool {
	if x != nil {
		return x.WriteMetadata
	}
	return false
}

func (x *BigQueryConfig) GetDropUnknownFields() bool {
	if x != nil {
		return x.DropUnknownFields
	}
	return false
}

func (x *BigQueryConfig) GetState() BigQueryConfig_State {
	if x != nil {
		return x.State
	}
	return BigQueryConfig_STATE_UNSPECIFIED
}

func (x *BigQueryConfig) GetUseTableSchema() bool {
	if x != nil {
		return x.UseTableSchema
	}
	return false
}

func (x *BigQueryConfig) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

// Configuration for a Cloud Storage subscription.
type CloudStorageConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User-provided name for the Cloud Storage bucket.
	// The bucket must be created by the user. The bucket name must be without
	// any prefix like "gs://". See the [bucket naming
	// requirements] (https://cloud.google.com/storage/docs/buckets#naming).
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Optional. User-provided prefix for Cloud Storage filename. See the [object
	// naming requirements](https://cloud.google.com/storage/docs/objects#naming).
	FilenamePrefix string `protobuf:"bytes,2,opt,name=filename_prefix,json=filenamePrefix,proto3" json:"filename_prefix,omitempty"`
	// Optional. User-provided suffix for Cloud Storage filename. See the [object
	// naming requirements](https://cloud.google.com/storage/docs/objects#naming).
	// Must not end in "/".
	FilenameSuffix string `protobuf:"bytes,3,opt,name=filename_suffix,json=filenameSuffix,proto3" json:"filename_suffix,omitempty"`
	// Optional. User-provided format string specifying how to represent datetimes
	// in Cloud Storage filenames. See the [datetime format
	// guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
	FilenameDatetimeFormat string `protobuf:"bytes,10,opt,name=filename_datetime_format,json=filenameDatetimeFormat,proto3" json:"filename_datetime_format,omitempty"`
	// Defaults to text format.
	//
	// Types that are assignable to OutputFormat:
	//
	//	*CloudStorageConfig_TextConfig_
	//	*CloudStorageConfig_AvroConfig_
	OutputFormat isCloudStorageConfig_OutputFormat `protobuf_oneof:"output_format"`
	// Optional. The maximum duration that can elapse before a new Cloud Storage
	// file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
	// exceed the subscription's acknowledgment deadline.
	MaxDuration *durationpb.Duration `protobuf:"bytes,6,opt,name=max_duration,json=maxDuration,proto3" json:"max_duration,omitempty"`
	// Optional. The maximum bytes that can be written to a Cloud Storage file
	// before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit may
	// be exceeded in cases where messages are larger than the limit.
	MaxBytes int64 `protobuf:"varint,7,opt,name=max_bytes,json=maxBytes,proto3" json:"max_bytes,omitempty"`
	// Optional. The maximum number of messages that can be written to a Cloud
	// Storage file before a new file is created. Min 1000 messages.
	MaxMessages int64 `protobuf:"varint,8,opt,name=max_messages,json=maxMessages,proto3" json:"max_messages,omitempty"`
	// Output only. An output-only field that indicates whether or not the
	// subscription can receive messages.
	State CloudStorageConfig_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.pubsub.v1.CloudStorageConfig_State" json:"state,omitempty"`
	// Optional. The service account to use to write to Cloud Storage. The
	// subscription creator or updater that specifies this field must have
	// `iam.serviceAccounts.actAs` permission on the service account. If not
	// specified, the Pub/Sub
	// [service agent](https://cloud.google.com/iam/docs/service-agents),
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
	ServiceAccountEmail string `protobuf:"bytes,11,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
}

func (x *CloudStorageConfig) Reset() {
	*x = CloudStorageConfig{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageConfig) ProtoMessage() {}

func (x *CloudStorageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageConfig.ProtoReflect.Descriptor instead.
func (*CloudStorageConfig) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{28}
}

func (x *CloudStorageConfig) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *CloudStorageConfig) GetFilenamePrefix() string {
	if x != nil {
		return x.FilenamePrefix
	}
	return ""
}

func (x *CloudStorageConfig) GetFilenameSuffix() string {
	if x != nil {
		return x.FilenameSuffix
	}
	return ""
}

func (x *CloudStorageConfig) GetFilenameDatetimeFormat() string {
	if x != nil {
		return x.FilenameDatetimeFormat
	}
	return ""
}

func (m *CloudStorageConfig) GetOutputFormat() isCloudStorageConfig_OutputFormat {
	if m != nil {
		return m.OutputFormat
	}
	return nil
}

func (x *CloudStorageConfig) GetTextConfig() *CloudStorageConfig_TextConfig {
	if x, ok := x.GetOutputFormat().(*CloudStorageConfig_TextConfig_); ok {
		return x.TextConfig
	}
	return nil
}

func (x *CloudStorageConfig) GetAvroConfig() *CloudStorageConfig_AvroConfig {
	if x, ok := x.GetOutputFormat().(*CloudStorageConfig_AvroConfig_); ok {
		return x.AvroConfig
	}
	return nil
}

func (x *CloudStorageConfig) GetMaxDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxDuration
	}
	return nil
}

func (x *CloudStorageConfig) GetMaxBytes() int64 {
	if x != nil {
		return x.MaxBytes
	}
	return 0
}

func (x *CloudStorageConfig) GetMaxMessages() int64 {
	if x != nil {
		return x.MaxMessages
	}
	return 0
}

func (x *CloudStorageConfig) GetState() CloudStorageConfig_State {
	if x != nil {
		return x.State
	}
	return CloudStorageConfig_STATE_UNSPECIFIED
}

func (x *CloudStorageConfig) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

type isCloudStorageConfig_OutputFormat interface {
	isCloudStorageConfig_OutputFormat()
}

type CloudStorageConfig_TextConfig_ struct {
	// Optional. If set, message data will be written to Cloud Storage in text
	// format.
	TextConfig *CloudStorageConfig_TextConfig `protobuf:"bytes,4,opt,name=text_config,json=textConfig,proto3,oneof"`
}

type CloudStorageConfig_AvroConfig_ struct {
	// Optional. If set, message data will be written to Cloud Storage in Avro
	// format.
	AvroConfig *CloudStorageConfig_AvroConfig `protobuf:"bytes,5,opt,name=avro_config,json=avroConfig,proto3,oneof"`
}

func (*CloudStorageConfig_TextConfig_) isCloudStorageConfig_OutputFormat() {}

func (*CloudStorageConfig_AvroConfig_) isCloudStorageConfig_OutputFormat() {}

// A message and its corresponding acknowledgment ID.
type ReceivedMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. This ID can be used to acknowledge the received message.
	AckId string `protobuf:"bytes,1,opt,name=ack_id,json=ackId,proto3" json:"ack_id,omitempty"`
	// Optional. The message.
	Message *PubsubMessage `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Optional. The approximate number of times that Pub/Sub has attempted to
	// deliver the associated message to a subscriber.
	//
	// More precisely, this is 1 + (number of NACKs) +
	// (number of ack_deadline exceeds) for this message.
	//
	// A NACK is any call to ModifyAckDeadline with a 0 deadline. An ack_deadline
	// exceeds event is whenever a message is not acknowledged within
	// ack_deadline. Note that ack_deadline is initially
	// Subscription.ackDeadlineSeconds, but may get extended automatically by
	// the client library.
	//
	// Upon the first delivery of a given message, `delivery_attempt` will have a
	// value of 1. The value is calculated at best effort and is approximate.
	//
	// If a DeadLetterPolicy is not set on the subscription, this will be 0.
	DeliveryAttempt int32 `protobuf:"varint,3,opt,name=delivery_attempt,json=deliveryAttempt,proto3" json:"delivery_attempt,omitempty"`
}

func (x *ReceivedMessage) Reset() {
	*x = ReceivedMessage{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReceivedMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceivedMessage) ProtoMessage() {}

func (x *ReceivedMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceivedMessage.ProtoReflect.Descriptor instead.
func (*ReceivedMessage) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{29}
}

func (x *ReceivedMessage) GetAckId() string {
	if x != nil {
		return x.AckId
	}
	return ""
}

func (x *ReceivedMessage) GetMessage() *PubsubMessage {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *ReceivedMessage) GetDeliveryAttempt() int32 {
	if x != nil {
		return x.DeliveryAttempt
	}
	return 0
}

// Request for the GetSubscription method.
type GetSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the subscription to get.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *GetSubscriptionRequest) Reset() {
	*x = GetSubscriptionRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSubscriptionRequest) ProtoMessage() {}

func (x *GetSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*GetSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{30}
}

func (x *GetSubscriptionRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

// Request for the UpdateSubscription method.
type UpdateSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated subscription object.
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Required. Indicates which fields in the provided subscription to update.
	// Must be specified and non-empty.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSubscriptionRequest) Reset() {
	*x = UpdateSubscriptionRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSubscriptionRequest) ProtoMessage() {}

func (x *UpdateSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*UpdateSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{31}
}

func (x *UpdateSubscriptionRequest) GetSubscription() *Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

func (x *UpdateSubscriptionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `ListSubscriptions` method.
type ListSubscriptionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which to list subscriptions.
	// Format is `projects/{project-id}`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Optional. Maximum number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListSubscriptionsResponse`;
	// indicates that this is a continuation of a prior `ListSubscriptions` call,
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSubscriptionsRequest) Reset() {
	*x = ListSubscriptionsRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSubscriptionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubscriptionsRequest) ProtoMessage() {}

func (x *ListSubscriptionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubscriptionsRequest.ProtoReflect.Descriptor instead.
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{32}
}

func (x *ListSubscriptionsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ListSubscriptionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSubscriptionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the `ListSubscriptions` method.
type ListSubscriptionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The subscriptions that match the request.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Optional. If not empty, indicates that there may be more subscriptions that
	// match the request; this value should be passed in a new
	// `ListSubscriptionsRequest` to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSubscriptionsResponse) Reset() {
	*x = ListSubscriptionsResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSubscriptionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubscriptionsResponse) ProtoMessage() {}

func (x *ListSubscriptionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubscriptionsResponse.ProtoReflect.Descriptor instead.
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{33}
}

func (x *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if x != nil {
		return x.Subscriptions
	}
	return nil
}

func (x *ListSubscriptionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the DeleteSubscription method.
type DeleteSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subscription to delete.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *DeleteSubscriptionRequest) Reset() {
	*x = DeleteSubscriptionRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSubscriptionRequest) ProtoMessage() {}

func (x *DeleteSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{34}
}

func (x *DeleteSubscriptionRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

// Request for the ModifyPushConfig method.
type ModifyPushConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the subscription.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Required. The push configuration for future deliveries.
	//
	// An empty `pushConfig` indicates that the Pub/Sub system should
	// stop pushing messages from the given subscription and allow
	// messages to be pulled and acknowledged - effectively pausing
	// the subscription if `Pull` or `StreamingPull` is not called.
	PushConfig *PushConfig `protobuf:"bytes,2,opt,name=push_config,json=pushConfig,proto3" json:"push_config,omitempty"`
}

func (x *ModifyPushConfigRequest) Reset() {
	*x = ModifyPushConfigRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModifyPushConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyPushConfigRequest) ProtoMessage() {}

func (x *ModifyPushConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyPushConfigRequest.ProtoReflect.Descriptor instead.
func (*ModifyPushConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{35}
}

func (x *ModifyPushConfigRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *ModifyPushConfigRequest) GetPushConfig() *PushConfig {
	if x != nil {
		return x.PushConfig
	}
	return nil
}

// Request for the `Pull` method.
type PullRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subscription from which messages should be pulled.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Optional. If this field set to true, the system will respond immediately
	// even if it there are no messages available to return in the `Pull`
	// response. Otherwise, the system may wait (for a bounded amount of time)
	// until at least one message is available, rather than returning no messages.
	// Warning: setting this field to `true` is discouraged because it adversely
	// impacts the performance of `Pull` operations. We recommend that users do
	// not set this field.
	//
	// Deprecated: Marked as deprecated in google/pubsub/v1/pubsub.proto.
	ReturnImmediately bool `protobuf:"varint,2,opt,name=return_immediately,json=returnImmediately,proto3" json:"return_immediately,omitempty"`
	// Required. The maximum number of messages to return for this request. Must
	// be a positive integer. The Pub/Sub system may return fewer than the number
	// specified.
	MaxMessages int32 `protobuf:"varint,3,opt,name=max_messages,json=maxMessages,proto3" json:"max_messages,omitempty"`
}

func (x *PullRequest) Reset() {
	*x = PullRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullRequest) ProtoMessage() {}

func (x *PullRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullRequest.ProtoReflect.Descriptor instead.
func (*PullRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{36}
}

func (x *PullRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

// Deprecated: Marked as deprecated in google/pubsub/v1/pubsub.proto.
func (x *PullRequest) GetReturnImmediately() bool {
	if x != nil {
		return x.ReturnImmediately
	}
	return false
}

func (x *PullRequest) GetMaxMessages() int32 {
	if x != nil {
		return x.MaxMessages
	}
	return 0
}

// Response for the `Pull` method.
type PullResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Received Pub/Sub messages. The list will be empty if there are no
	// more messages available in the backlog, or if no messages could be returned
	// before the request timeout. For JSON, the response can be entirely
	// empty. The Pub/Sub system may return fewer than the `maxMessages` requested
	// even if there are more messages available in the backlog.
	ReceivedMessages []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages,proto3" json:"received_messages,omitempty"`
}

func (x *PullResponse) Reset() {
	*x = PullResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullResponse) ProtoMessage() {}

func (x *PullResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullResponse.ProtoReflect.Descriptor instead.
func (*PullResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{37}
}

func (x *PullResponse) GetReceivedMessages() []*ReceivedMessage {
	if x != nil {
		return x.ReceivedMessages
	}
	return nil
}

// Request for the ModifyAckDeadline method.
type ModifyAckDeadlineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the subscription.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Required. List of acknowledgment IDs.
	AckIds []string `protobuf:"bytes,4,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
	// Required. The new ack deadline with respect to the time this request was
	// sent to the Pub/Sub system. For example, if the value is 10, the new ack
	// deadline will expire 10 seconds after the `ModifyAckDeadline` call was
	// made. Specifying zero might immediately make the message available for
	// delivery to another subscriber client. This typically results in an
	// increase in the rate of message redeliveries (that is, duplicates).
	// The minimum deadline you can specify is 0 seconds.
	// The maximum deadline you can specify in a single request is 600 seconds
	// (10 minutes).
	AckDeadlineSeconds int32 `protobuf:"varint,3,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds,proto3" json:"ack_deadline_seconds,omitempty"`
}

func (x *ModifyAckDeadlineRequest) Reset() {
	*x = ModifyAckDeadlineRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModifyAckDeadlineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyAckDeadlineRequest) ProtoMessage() {}

func (x *ModifyAckDeadlineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyAckDeadlineRequest.ProtoReflect.Descriptor instead.
func (*ModifyAckDeadlineRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{38}
}

func (x *ModifyAckDeadlineRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *ModifyAckDeadlineRequest) GetAckIds() []string {
	if x != nil {
		return x.AckIds
	}
	return nil
}

func (x *ModifyAckDeadlineRequest) GetAckDeadlineSeconds() int32 {
	if x != nil {
		return x.AckDeadlineSeconds
	}
	return 0
}

// Request for the Acknowledge method.
type AcknowledgeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subscription whose message is being acknowledged.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Required. The acknowledgment ID for the messages being acknowledged that
	// was returned by the Pub/Sub system in the `Pull` response. Must not be
	// empty.
	AckIds []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
}

func (x *AcknowledgeRequest) Reset() {
	*x = AcknowledgeRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcknowledgeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeRequest) ProtoMessage() {}

func (x *AcknowledgeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeRequest.ProtoReflect.Descriptor instead.
func (*AcknowledgeRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{39}
}

func (x *AcknowledgeRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *AcknowledgeRequest) GetAckIds() []string {
	if x != nil {
		return x.AckIds
	}
	return nil
}

// Request for the `StreamingPull` streaming RPC method. This request is used to
// establish the initial stream as well as to stream acknowledgments and ack
// deadline modifications from the client to the server.
type StreamingPullRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subscription for which to initialize the new stream. This
	// must be provided in the first request on the stream, and must not be set in
	// subsequent requests from client to server.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Optional. List of acknowledgment IDs for acknowledging previously received
	// messages (received on this stream or a different stream). If an ack ID has
	// expired, the corresponding message may be redelivered later. Acknowledging
	// a message more than once will not result in an error. If the acknowledgment
	// ID is malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
	AckIds []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
	// Optional. The list of new ack deadlines for the IDs listed in
	// `modify_deadline_ack_ids`. The size of this list must be the same as the
	// size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
	// with `INVALID_ARGUMENT`. Each element in this list is applied to the
	// element in the same position in `modify_deadline_ack_ids`. The new ack
	// deadline is with respect to the time this request was sent to the Pub/Sub
	// system. Must be >= 0. For example, if the value is 10, the new ack deadline
	// will expire 10 seconds after this request is received. If the value is 0,
	// the message is immediately made available for another streaming or
	// non-streaming pull request. If the value is < 0 (an error), the stream will
	// be aborted with status `INVALID_ARGUMENT`.
	ModifyDeadlineSeconds []int32 `protobuf:"varint,3,rep,packed,name=modify_deadline_seconds,json=modifyDeadlineSeconds,proto3" json:"modify_deadline_seconds,omitempty"`
	// Optional. List of acknowledgment IDs whose deadline will be modified based
	// on the corresponding element in `modify_deadline_seconds`. This field can
	// be used to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted.
	ModifyDeadlineAckIds []string `protobuf:"bytes,4,rep,name=modify_deadline_ack_ids,json=modifyDeadlineAckIds,proto3" json:"modify_deadline_ack_ids,omitempty"`
	// Required. The ack deadline to use for the stream. This must be provided in
	// the first request on the stream, but it can also be updated on subsequent
	// requests from client to server. The minimum deadline you can specify is 10
	// seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
	StreamAckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=stream_ack_deadline_seconds,json=streamAckDeadlineSeconds,proto3" json:"stream_ack_deadline_seconds,omitempty"`
	// Optional. A unique identifier that is used to distinguish client instances
	// from each other. Only needs to be provided on the initial request. When a
	// stream disconnects and reconnects for the same stream, the client_id should
	// be set to the same value so that state associated with the old stream can
	// be transferred to the new stream. The same client_id should not be used for
	// different client instances.
	ClientId string `protobuf:"bytes,6,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Optional. Flow control settings for the maximum number of outstanding
	// messages. When there are `max_outstanding_messages` currently sent to the
	// streaming pull client that have not yet been acked or nacked, the server
	// stops sending more messages. The sending of messages resumes once the
	// number of outstanding messages is less than this value. If the value is
	// <= 0, there is no limit to the number of outstanding messages. This
	// property can only be set on the initial StreamingPullRequest. If it is set
	// on a subsequent request, the stream will be aborted with status
	// `INVALID_ARGUMENT`.
	MaxOutstandingMessages int64 `protobuf:"varint,7,opt,name=max_outstanding_messages,json=maxOutstandingMessages,proto3" json:"max_outstanding_messages,omitempty"`
	// Optional. Flow control settings for the maximum number of outstanding
	// bytes. When there are `max_outstanding_bytes` or more worth of messages
	// currently sent to the streaming pull client that have not yet been acked or
	// nacked, the server will stop sending more messages. The sending of messages
	// resumes once the number of outstanding bytes is less than this value. If
	// the value is <= 0, there is no limit to the number of outstanding bytes.
	// This property can only be set on the initial StreamingPullRequest. If it is
	// set on a subsequent request, the stream will be aborted with status
	// `INVALID_ARGUMENT`.
	MaxOutstandingBytes int64 `protobuf:"varint,8,opt,name=max_outstanding_bytes,json=maxOutstandingBytes,proto3" json:"max_outstanding_bytes,omitempty"`
	// Optional. The protocol version used by the client. This property can only
	// be set on the initial StreamingPullRequest. If it is set on a subsequent
	// request, the stream will be aborted with status `INVALID_ARGUMENT`.
	ProtocolVersion int64 `protobuf:"varint,10,opt,name=protocol_version,json=protocolVersion,proto3" json:"protocol_version,omitempty"`
}

func (x *StreamingPullRequest) Reset() {
	*x = StreamingPullRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingPullRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingPullRequest) ProtoMessage() {}

func (x *StreamingPullRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingPullRequest.ProtoReflect.Descriptor instead.
func (*StreamingPullRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{40}
}

func (x *StreamingPullRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *StreamingPullRequest) GetAckIds() []string {
	if x != nil {
		return x.AckIds
	}
	return nil
}

func (x *StreamingPullRequest) GetModifyDeadlineSeconds() []int32 {
	if x != nil {
		return x.ModifyDeadlineSeconds
	}
	return nil
}

func (x *StreamingPullRequest) GetModifyDeadlineAckIds() []string {
	if x != nil {
		return x.ModifyDeadlineAckIds
	}
	return nil
}

func (x *StreamingPullRequest) GetStreamAckDeadlineSeconds() int32 {
	if x != nil {
		return x.StreamAckDeadlineSeconds
	}
	return 0
}

func (x *StreamingPullRequest) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *StreamingPullRequest) GetMaxOutstandingMessages() int64 {
	if x != nil {
		return x.MaxOutstandingMessages
	}
	return 0
}

func (x *StreamingPullRequest) GetMaxOutstandingBytes() int64 {
	if x != nil {
		return x.MaxOutstandingBytes
	}
	return 0
}

func (x *StreamingPullRequest) GetProtocolVersion() int64 {
	if x != nil {
		return x.ProtocolVersion
	}
	return 0
}

// Response for the `StreamingPull` method. This response is used to stream
// messages from the server to the client.
type StreamingPullResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Received Pub/Sub messages.
	ReceivedMessages []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages,proto3" json:"received_messages,omitempty"`
	// Optional. This field will only be set if `enable_exactly_once_delivery` is
	// set to `true` and is not guaranteed to be populated.
	AcknowledgeConfirmation *StreamingPullResponse_AcknowledgeConfirmation `protobuf:"bytes,5,opt,name=acknowledge_confirmation,json=acknowledgeConfirmation,proto3" json:"acknowledge_confirmation,omitempty"`
	// Optional. This field will only be set if `enable_exactly_once_delivery` is
	// set to `true` and is not guaranteed to be populated.
	ModifyAckDeadlineConfirmation *StreamingPullResponse_ModifyAckDeadlineConfirmation `protobuf:"bytes,3,opt,name=modify_ack_deadline_confirmation,json=modifyAckDeadlineConfirmation,proto3" json:"modify_ack_deadline_confirmation,omitempty"`
	// Optional. Properties associated with this subscription.
	SubscriptionProperties *StreamingPullResponse_SubscriptionProperties `protobuf:"bytes,4,opt,name=subscription_properties,json=subscriptionProperties,proto3" json:"subscription_properties,omitempty"`
}

func (x *StreamingPullResponse) Reset() {
	*x = StreamingPullResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingPullResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingPullResponse) ProtoMessage() {}

func (x *StreamingPullResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingPullResponse.ProtoReflect.Descriptor instead.
func (*StreamingPullResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{41}
}

func (x *StreamingPullResponse) GetReceivedMessages() []*ReceivedMessage {
	if x != nil {
		return x.ReceivedMessages
	}
	return nil
}

func (x *StreamingPullResponse) GetAcknowledgeConfirmation() *StreamingPullResponse_AcknowledgeConfirmation {
	if x != nil {
		return x.AcknowledgeConfirmation
	}
	return nil
}

func (x *StreamingPullResponse) GetModifyAckDeadlineConfirmation() *StreamingPullResponse_ModifyAckDeadlineConfirmation {
	if x != nil {
		return x.ModifyAckDeadlineConfirmation
	}
	return nil
}

func (x *StreamingPullResponse) GetSubscriptionProperties() *StreamingPullResponse_SubscriptionProperties {
	if x != nil {
		return x.SubscriptionProperties
	}
	return nil
}

// Request for the `CreateSnapshot` method.
type CreateSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User-provided name for this snapshot. If the name is not provided
	// in the request, the server will assign a random name for this snapshot on
	// the same project as the subscription. Note that for REST API requests, you
	// must specify a name.  See the [resource name
	// rules](https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
	// Format is `projects/{project}/snapshots/{snap}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The subscription whose backlog the snapshot retains.
	// Specifically, the created snapshot is guaranteed to retain:
	//
	//	(a) The existing backlog on the subscription. More precisely, this is
	//	    defined as the messages in the subscription's backlog that are
	//	    unacknowledged upon the successful completion of the
	//	    `CreateSnapshot` request; as well as:
	//	(b) Any messages published to the subscription's topic following the
	//	    successful completion of the CreateSnapshot request.
	//
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Optional. See [Creating and managing
	// labels](https://cloud.google.com/pubsub/docs/labels).
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Input only. Immutable. Tag keys/values directly bound to this
	// resource. For example:
	//
	//	"123/environment": "production",
	//	"123/costCenter": "marketing"
	Tags map[string]string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CreateSnapshotRequest) Reset() {
	*x = CreateSnapshotRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSnapshotRequest) ProtoMessage() {}

func (x *CreateSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSnapshotRequest.ProtoReflect.Descriptor instead.
func (*CreateSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{42}
}

func (x *CreateSnapshotRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateSnapshotRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *CreateSnapshotRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateSnapshotRequest) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// Request for the UpdateSnapshot method.
type UpdateSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated snapshot object.
	Snapshot *Snapshot `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	// Required. Indicates which fields in the provided snapshot to update.
	// Must be specified and non-empty.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSnapshotRequest) Reset() {
	*x = UpdateSnapshotRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSnapshotRequest) ProtoMessage() {}

func (x *UpdateSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSnapshotRequest.ProtoReflect.Descriptor instead.
func (*UpdateSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{43}
}

func (x *UpdateSnapshotRequest) GetSnapshot() *Snapshot {
	if x != nil {
		return x.Snapshot
	}
	return nil
}

func (x *UpdateSnapshotRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A snapshot resource. Snapshots are used in
// [Seek](https://cloud.google.com/pubsub/docs/replay-overview)
// operations, which allow you to manage message acknowledgments in bulk. That
// is, you can set the acknowledgment state of messages in an existing
// subscription to the state captured by a snapshot.
type Snapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the snapshot.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The name of the topic from which this snapshot is retaining
	// messages.
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// Optional. The snapshot is guaranteed to exist up until this time.
	// A newly-created snapshot expires no later than 7 days from the time of its
	// creation. Its exact lifetime is determined at creation by the existing
	// backlog in the source subscription. Specifically, the lifetime of the
	// snapshot is `7 days - (age of oldest unacked message in the subscription)`.
	// For example, consider a subscription whose oldest unacked message is 3 days
	// old. If a snapshot is created from this subscription, the snapshot -- which
	// will always capture this 3-day-old backlog as long as the snapshot
	// exists -- will expire in 4 days. The service will refuse to create a
	// snapshot that would expire in less than 1 hour after creation.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Optional. See [Creating and managing labels]
	// (https://cloud.google.com/pubsub/docs/labels).
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Snapshot) Reset() {
	*x = Snapshot{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Snapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Snapshot) ProtoMessage() {}

func (x *Snapshot) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Snapshot.ProtoReflect.Descriptor instead.
func (*Snapshot) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{44}
}

func (x *Snapshot) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Snapshot) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *Snapshot) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Snapshot) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Request for the GetSnapshot method.
type GetSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the snapshot to get.
	// Format is `projects/{project}/snapshots/{snap}`.
	Snapshot string `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (x *GetSnapshotRequest) Reset() {
	*x = GetSnapshotRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshotRequest) ProtoMessage() {}

func (x *GetSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshotRequest.ProtoReflect.Descriptor instead.
func (*GetSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{45}
}

func (x *GetSnapshotRequest) GetSnapshot() string {
	if x != nil {
		return x.Snapshot
	}
	return ""
}

// Request for the `ListSnapshots` method.
type ListSnapshotsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which to list snapshots.
	// Format is `projects/{project-id}`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Optional. Maximum number of snapshots to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListSnapshotsResponse`; indicates
	// that this is a continuation of a prior `ListSnapshots` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSnapshotsRequest) Reset() {
	*x = ListSnapshotsRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSnapshotsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSnapshotsRequest) ProtoMessage() {}

func (x *ListSnapshotsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSnapshotsRequest.ProtoReflect.Descriptor instead.
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{46}
}

func (x *ListSnapshotsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ListSnapshotsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSnapshotsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the `ListSnapshots` method.
type ListSnapshotsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The resulting snapshots.
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// Optional. If not empty, indicates that there may be more snapshot that
	// match the request; this value should be passed in a new
	// `ListSnapshotsRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSnapshotsResponse) Reset() {
	*x = ListSnapshotsResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSnapshotsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSnapshotsResponse) ProtoMessage() {}

func (x *ListSnapshotsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSnapshotsResponse.ProtoReflect.Descriptor instead.
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{47}
}

func (x *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if x != nil {
		return x.Snapshots
	}
	return nil
}

func (x *ListSnapshotsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the `DeleteSnapshot` method.
type DeleteSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the snapshot to delete.
	// Format is `projects/{project}/snapshots/{snap}`.
	Snapshot string `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (x *DeleteSnapshotRequest) Reset() {
	*x = DeleteSnapshotRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSnapshotRequest) ProtoMessage() {}

func (x *DeleteSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSnapshotRequest.ProtoReflect.Descriptor instead.
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{48}
}

func (x *DeleteSnapshotRequest) GetSnapshot() string {
	if x != nil {
		return x.Snapshot
	}
	return ""
}

// Request for the `Seek` method.
type SeekRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subscription to affect.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Types that are assignable to Target:
	//
	//	*SeekRequest_Time
	//	*SeekRequest_Snapshot
	Target isSeekRequest_Target `protobuf_oneof:"target"`
}

func (x *SeekRequest) Reset() {
	*x = SeekRequest{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SeekRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SeekRequest) ProtoMessage() {}

func (x *SeekRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SeekRequest.ProtoReflect.Descriptor instead.
func (*SeekRequest) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{49}
}

func (x *SeekRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (m *SeekRequest) GetTarget() isSeekRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *SeekRequest) GetTime() *timestamppb.Timestamp {
	if x, ok := x.GetTarget().(*SeekRequest_Time); ok {
		return x.Time
	}
	return nil
}

func (x *SeekRequest) GetSnapshot() string {
	if x, ok := x.GetTarget().(*SeekRequest_Snapshot); ok {
		return x.Snapshot
	}
	return ""
}

type isSeekRequest_Target interface {
	isSeekRequest_Target()
}

type SeekRequest_Time struct {
	// Optional. The time to seek to.
	// Messages retained in the subscription that were published before this
	// time are marked as acknowledged, and messages retained in the
	// subscription that were published after this time are marked as
	// unacknowledged. Note that this operation affects only those messages
	// retained in the subscription (configured by the combination of
	// `message_retention_duration` and `retain_acked_messages`). For example,
	// if `time` corresponds to a point before the message retention
	// window (or to a point before the system's notion of the subscription
	// creation time), only retained messages will be marked as unacknowledged,
	// and already-expunged messages will not be restored.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3,oneof"`
}

type SeekRequest_Snapshot struct {
	// Optional. The snapshot to seek to. The snapshot's topic must be the same
	// as that of the provided subscription. Format is
	// `projects/{project}/snapshots/{snap}`.
	Snapshot string `protobuf:"bytes,3,opt,name=snapshot,proto3,oneof"`
}

func (*SeekRequest_Time) isSeekRequest_Target() {}

func (*SeekRequest_Snapshot) isSeekRequest_Target() {}

// Response for the `Seek` method (this response is empty).
type SeekResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SeekResponse) Reset() {
	*x = SeekResponse{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SeekResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SeekResponse) ProtoMessage() {}

func (x *SeekResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SeekResponse.ProtoReflect.Descriptor instead.
func (*SeekResponse) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{50}
}

// Ingestion settings for Amazon Kinesis Data Streams.
type IngestionDataSourceSettings_AwsKinesis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. An output-only field that indicates the state of the Kinesis
	// ingestion source.
	State IngestionDataSourceSettings_AwsKinesis_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.pubsub.v1.IngestionDataSourceSettings_AwsKinesis_State" json:"state,omitempty"`
	// Required. The Kinesis stream ARN to ingest data from.
	StreamArn string `protobuf:"bytes,2,opt,name=stream_arn,json=streamArn,proto3" json:"stream_arn,omitempty"`
	// Required. The Kinesis consumer ARN to used for ingestion in Enhanced
	// Fan-Out mode. The consumer must be already created and ready to be used.
	ConsumerArn string `protobuf:"bytes,3,opt,name=consumer_arn,json=consumerArn,proto3" json:"consumer_arn,omitempty"`
	// Required. AWS role ARN to be used for Federated Identity authentication
	// with Kinesis. Check the Pub/Sub docs for how to set up this role and the
	// required permissions that need to be attached to it.
	AwsRoleArn string `protobuf:"bytes,4,opt,name=aws_role_arn,json=awsRoleArn,proto3" json:"aws_role_arn,omitempty"`
	// Required. The GCP service account to be used for Federated Identity
	// authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
	// the provided role). The `aws_role_arn` must be set up with
	// `accounts.google.com:sub` equals to this service account number.
	GcpServiceAccount string `protobuf:"bytes,5,opt,name=gcp_service_account,json=gcpServiceAccount,proto3" json:"gcp_service_account,omitempty"`
}

func (x *IngestionDataSourceSettings_AwsKinesis) Reset() {
	*x = IngestionDataSourceSettings_AwsKinesis{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings_AwsKinesis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings_AwsKinesis) ProtoMessage() {}

func (x *IngestionDataSourceSettings_AwsKinesis) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings_AwsKinesis.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings_AwsKinesis) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 0}
}

func (x *IngestionDataSourceSettings_AwsKinesis) GetState() IngestionDataSourceSettings_AwsKinesis_State {
	if x != nil {
		return x.State
	}
	return IngestionDataSourceSettings_AwsKinesis_STATE_UNSPECIFIED
}

func (x *IngestionDataSourceSettings_AwsKinesis) GetStreamArn() string {
	if x != nil {
		return x.StreamArn
	}
	return ""
}

func (x *IngestionDataSourceSettings_AwsKinesis) GetConsumerArn() string {
	if x != nil {
		return x.ConsumerArn
	}
	return ""
}

func (x *IngestionDataSourceSettings_AwsKinesis) GetAwsRoleArn() string {
	if x != nil {
		return x.AwsRoleArn
	}
	return ""
}

func (x *IngestionDataSourceSettings_AwsKinesis) GetGcpServiceAccount() string {
	if x != nil {
		return x.GcpServiceAccount
	}
	return ""
}

// Ingestion settings for Cloud Storage.
type IngestionDataSourceSettings_CloudStorage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. An output-only field that indicates the state of the Cloud
	// Storage ingestion source.
	State IngestionDataSourceSettings_CloudStorage_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.pubsub.v1.IngestionDataSourceSettings_CloudStorage_State" json:"state,omitempty"`
	// Optional. Cloud Storage bucket. The bucket name must be without any
	// prefix like "gs://". See the [bucket naming requirements]
	// (https://cloud.google.com/storage/docs/buckets#naming).
	Bucket string `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Defaults to text format.
	//
	// Types that are assignable to InputFormat:
	//
	//	*IngestionDataSourceSettings_CloudStorage_TextFormat_
	//	*IngestionDataSourceSettings_CloudStorage_AvroFormat_
	//	*IngestionDataSourceSettings_CloudStorage_PubsubAvroFormat
	InputFormat isIngestionDataSourceSettings_CloudStorage_InputFormat `protobuf_oneof:"input_format"`
	// Optional. Only objects with a larger or equal creation timestamp will be
	// ingested.
	MinimumObjectCreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=minimum_object_create_time,json=minimumObjectCreateTime,proto3" json:"minimum_object_create_time,omitempty"`
	// Optional. Glob pattern used to match objects that will be ingested. If
	// unset, all objects will be ingested. See the [supported
	// patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
	MatchGlob string `protobuf:"bytes,9,opt,name=match_glob,json=matchGlob,proto3" json:"match_glob,omitempty"`
}

func (x *IngestionDataSourceSettings_CloudStorage) Reset() {
	*x = IngestionDataSourceSettings_CloudStorage{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings_CloudStorage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings_CloudStorage) ProtoMessage() {}

func (x *IngestionDataSourceSettings_CloudStorage) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings_CloudStorage.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings_CloudStorage) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 1}
}

func (x *IngestionDataSourceSettings_CloudStorage) GetState() IngestionDataSourceSettings_CloudStorage_State {
	if x != nil {
		return x.State
	}
	return IngestionDataSourceSettings_CloudStorage_STATE_UNSPECIFIED
}

func (x *IngestionDataSourceSettings_CloudStorage) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (m *IngestionDataSourceSettings_CloudStorage) GetInputFormat() isIngestionDataSourceSettings_CloudStorage_InputFormat {
	if m != nil {
		return m.InputFormat
	}
	return nil
}

func (x *IngestionDataSourceSettings_CloudStorage) GetTextFormat() *IngestionDataSourceSettings_CloudStorage_TextFormat {
	if x, ok := x.GetInputFormat().(*IngestionDataSourceSettings_CloudStorage_TextFormat_); ok {
		return x.TextFormat
	}
	return nil
}

func (x *IngestionDataSourceSettings_CloudStorage) GetAvroFormat() *IngestionDataSourceSettings_CloudStorage_AvroFormat {
	if x, ok := x.GetInputFormat().(*IngestionDataSourceSettings_CloudStorage_AvroFormat_); ok {
		return x.AvroFormat
	}
	return nil
}

func (x *IngestionDataSourceSettings_CloudStorage) GetPubsubAvroFormat() *IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat {
	if x, ok := x.GetInputFormat().(*IngestionDataSourceSettings_CloudStorage_PubsubAvroFormat); ok {
		return x.PubsubAvroFormat
	}
	return nil
}

func (x *IngestionDataSourceSettings_CloudStorage) GetMinimumObjectCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MinimumObjectCreateTime
	}
	return nil
}

func (x *IngestionDataSourceSettings_CloudStorage) GetMatchGlob() string {
	if x != nil {
		return x.MatchGlob
	}
	return ""
}

type isIngestionDataSourceSettings_CloudStorage_InputFormat interface {
	isIngestionDataSourceSettings_CloudStorage_InputFormat()
}

type IngestionDataSourceSettings_CloudStorage_TextFormat_ struct {
	// Optional. Data from Cloud Storage will be interpreted as text.
	TextFormat *IngestionDataSourceSettings_CloudStorage_TextFormat `protobuf:"bytes,3,opt,name=text_format,json=textFormat,proto3,oneof"`
}

type IngestionDataSourceSettings_CloudStorage_AvroFormat_ struct {
	// Optional. Data from Cloud Storage will be interpreted in Avro format.
	AvroFormat *IngestionDataSourceSettings_CloudStorage_AvroFormat `protobuf:"bytes,4,opt,name=avro_format,json=avroFormat,proto3,oneof"`
}

type IngestionDataSourceSettings_CloudStorage_PubsubAvroFormat struct {
	// Optional. It will be assumed data from Cloud Storage was written via
	// [Cloud Storage
	// subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
	PubsubAvroFormat *IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat `protobuf:"bytes,5,opt,name=pubsub_avro_format,json=pubsubAvroFormat,proto3,oneof"`
}

func (*IngestionDataSourceSettings_CloudStorage_TextFormat_) isIngestionDataSourceSettings_CloudStorage_InputFormat() {
}

func (*IngestionDataSourceSettings_CloudStorage_AvroFormat_) isIngestionDataSourceSettings_CloudStorage_InputFormat() {
}

func (*IngestionDataSourceSettings_CloudStorage_PubsubAvroFormat) isIngestionDataSourceSettings_CloudStorage_InputFormat() {
}

// Ingestion settings for Azure Event Hubs.
type IngestionDataSourceSettings_AzureEventHubs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. An output-only field that indicates the state of the Event
	// Hubs ingestion source.
	State IngestionDataSourceSettings_AzureEventHubs_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.pubsub.v1.IngestionDataSourceSettings_AzureEventHubs_State" json:"state,omitempty"`
	// Optional. Name of the resource group within the azure subscription.
	ResourceGroup string `protobuf:"bytes,2,opt,name=resource_group,json=resourceGroup,proto3" json:"resource_group,omitempty"`
	// Optional. The name of the Event Hubs namespace.
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Optional. The name of the Event Hub.
	EventHub string `protobuf:"bytes,4,opt,name=event_hub,json=eventHub,proto3" json:"event_hub,omitempty"`
	// Optional. The client id of the Azure application that is being used to
	// authenticate Pub/Sub.
	ClientId string `protobuf:"bytes,5,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Optional. The tenant id of the Azure application that is being used to
	// authenticate Pub/Sub.
	TenantId string `protobuf:"bytes,6,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
	// Optional. The Azure subscription id.
	SubscriptionId string `protobuf:"bytes,7,opt,name=subscription_id,json=subscriptionId,proto3" json:"subscription_id,omitempty"`
	// Optional. The GCP service account to be used for Federated Identity
	// authentication.
	GcpServiceAccount string `protobuf:"bytes,8,opt,name=gcp_service_account,json=gcpServiceAccount,proto3" json:"gcp_service_account,omitempty"`
}

func (x *IngestionDataSourceSettings_AzureEventHubs) Reset() {
	*x = IngestionDataSourceSettings_AzureEventHubs{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings_AzureEventHubs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings_AzureEventHubs) ProtoMessage() {}

func (x *IngestionDataSourceSettings_AzureEventHubs) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings_AzureEventHubs.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings_AzureEventHubs) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 2}
}

func (x *IngestionDataSourceSettings_AzureEventHubs) GetState() IngestionDataSourceSettings_AzureEventHubs_State {
	if x != nil {
		return x.State
	}
	return IngestionDataSourceSettings_AzureEventHubs_STATE_UNSPECIFIED
}

func (x *IngestionDataSourceSettings_AzureEventHubs) GetResourceGroup() string {
	if x != nil {
		return x.ResourceGroup
	}
	return ""
}

func (x *IngestionDataSourceSettings_AzureEventHubs) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *IngestionDataSourceSettings_AzureEventHubs) GetEventHub() string {
	if x != nil {
		return x.EventHub
	}
	return ""
}

func (x *IngestionDataSourceSettings_AzureEventHubs) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *IngestionDataSourceSettings_AzureEventHubs) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

func (x *IngestionDataSourceSettings_AzureEventHubs) GetSubscriptionId() string {
	if x != nil {
		return x.SubscriptionId
	}
	return ""
}

func (x *IngestionDataSourceSettings_AzureEventHubs) GetGcpServiceAccount() string {
	if x != nil {
		return x.GcpServiceAccount
	}
	return ""
}

// Ingestion settings for Amazon MSK.
type IngestionDataSourceSettings_AwsMsk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. An output-only field that indicates the state of the Amazon
	// MSK ingestion source.
	State IngestionDataSourceSettings_AwsMsk_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.pubsub.v1.IngestionDataSourceSettings_AwsMsk_State" json:"state,omitempty"`
	// Required. The Amazon Resource Name (ARN) that uniquely identifies the
	// cluster.
	ClusterArn string `protobuf:"bytes,2,opt,name=cluster_arn,json=clusterArn,proto3" json:"cluster_arn,omitempty"`
	// Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
	// will import from.
	Topic string `protobuf:"bytes,3,opt,name=topic,proto3" json:"topic,omitempty"`
	// Required. AWS role ARN to be used for Federated Identity authentication
	// with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
	// the required permissions that need to be attached to it.
	AwsRoleArn string `protobuf:"bytes,4,opt,name=aws_role_arn,json=awsRoleArn,proto3" json:"aws_role_arn,omitempty"`
	// Required. The GCP service account to be used for Federated Identity
	// authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
	// for the provided role). The `aws_role_arn` must be set up with
	// `accounts.google.com:sub` equals to this service account number.
	GcpServiceAccount string `protobuf:"bytes,5,opt,name=gcp_service_account,json=gcpServiceAccount,proto3" json:"gcp_service_account,omitempty"`
}

func (x *IngestionDataSourceSettings_AwsMsk) Reset() {
	*x = IngestionDataSourceSettings_AwsMsk{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings_AwsMsk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings_AwsMsk) ProtoMessage() {}

func (x *IngestionDataSourceSettings_AwsMsk) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings_AwsMsk.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings_AwsMsk) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 3}
}

func (x *IngestionDataSourceSettings_AwsMsk) GetState() IngestionDataSourceSettings_AwsMsk_State {
	if x != nil {
		return x.State
	}
	return IngestionDataSourceSettings_AwsMsk_STATE_UNSPECIFIED
}

func (x *IngestionDataSourceSettings_AwsMsk) GetClusterArn() string {
	if x != nil {
		return x.ClusterArn
	}
	return ""
}

func (x *IngestionDataSourceSettings_AwsMsk) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *IngestionDataSourceSettings_AwsMsk) GetAwsRoleArn() string {
	if x != nil {
		return x.AwsRoleArn
	}
	return ""
}

func (x *IngestionDataSourceSettings_AwsMsk) GetGcpServiceAccount() string {
	if x != nil {
		return x.GcpServiceAccount
	}
	return ""
}

// Ingestion settings for Confluent Cloud.
type IngestionDataSourceSettings_ConfluentCloud struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. An output-only field that indicates the state of the
	// Confluent Cloud ingestion source.
	State IngestionDataSourceSettings_ConfluentCloud_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.pubsub.v1.IngestionDataSourceSettings_ConfluentCloud_State" json:"state,omitempty"`
	// Required. The address of the bootstrap server. The format is url:port.
	BootstrapServer string `protobuf:"bytes,2,opt,name=bootstrap_server,json=bootstrapServer,proto3" json:"bootstrap_server,omitempty"`
	// Required. The id of the cluster.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The name of the topic in the Confluent Cloud cluster that
	// Pub/Sub will import from.
	Topic string `protobuf:"bytes,4,opt,name=topic,proto3" json:"topic,omitempty"`
	// Required. The id of the identity pool to be used for Federated Identity
	// authentication with Confluent Cloud. See
	// https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
	IdentityPoolId string `protobuf:"bytes,5,opt,name=identity_pool_id,json=identityPoolId,proto3" json:"identity_pool_id,omitempty"`
	// Required. The GCP service account to be used for Federated Identity
	// authentication with `identity_pool_id`.
	GcpServiceAccount string `protobuf:"bytes,6,opt,name=gcp_service_account,json=gcpServiceAccount,proto3" json:"gcp_service_account,omitempty"`
}

func (x *IngestionDataSourceSettings_ConfluentCloud) Reset() {
	*x = IngestionDataSourceSettings_ConfluentCloud{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings_ConfluentCloud) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings_ConfluentCloud) ProtoMessage() {}

func (x *IngestionDataSourceSettings_ConfluentCloud) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings_ConfluentCloud.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings_ConfluentCloud) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 4}
}

func (x *IngestionDataSourceSettings_ConfluentCloud) GetState() IngestionDataSourceSettings_ConfluentCloud_State {
	if x != nil {
		return x.State
	}
	return IngestionDataSourceSettings_ConfluentCloud_STATE_UNSPECIFIED
}

func (x *IngestionDataSourceSettings_ConfluentCloud) GetBootstrapServer() string {
	if x != nil {
		return x.BootstrapServer
	}
	return ""
}

func (x *IngestionDataSourceSettings_ConfluentCloud) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *IngestionDataSourceSettings_ConfluentCloud) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *IngestionDataSourceSettings_ConfluentCloud) GetIdentityPoolId() string {
	if x != nil {
		return x.IdentityPoolId
	}
	return ""
}

func (x *IngestionDataSourceSettings_ConfluentCloud) GetGcpServiceAccount() string {
	if x != nil {
		return x.GcpServiceAccount
	}
	return ""
}

// Configuration for reading Cloud Storage data in text format. Each line of
// text as specified by the delimiter will be set to the `data` field of a
// Pub/Sub message.
type IngestionDataSourceSettings_CloudStorage_TextFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. When unset, '\n' is used.
	Delimiter *string `protobuf:"bytes,1,opt,name=delimiter,proto3,oneof" json:"delimiter,omitempty"`
}

func (x *IngestionDataSourceSettings_CloudStorage_TextFormat) Reset() {
	*x = IngestionDataSourceSettings_CloudStorage_TextFormat{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings_CloudStorage_TextFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings_CloudStorage_TextFormat) ProtoMessage() {}

func (x *IngestionDataSourceSettings_CloudStorage_TextFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings_CloudStorage_TextFormat.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings_CloudStorage_TextFormat) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 1, 0}
}

func (x *IngestionDataSourceSettings_CloudStorage_TextFormat) GetDelimiter() string {
	if x != nil && x.Delimiter != nil {
		return *x.Delimiter
	}
	return ""
}

// Configuration for reading Cloud Storage data in Avro binary format. The
// bytes of each object will be set to the `data` field of a Pub/Sub
// message.
type IngestionDataSourceSettings_CloudStorage_AvroFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IngestionDataSourceSettings_CloudStorage_AvroFormat) Reset() {
	*x = IngestionDataSourceSettings_CloudStorage_AvroFormat{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings_CloudStorage_AvroFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings_CloudStorage_AvroFormat) ProtoMessage() {}

func (x *IngestionDataSourceSettings_CloudStorage_AvroFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings_CloudStorage_AvroFormat.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings_CloudStorage_AvroFormat) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 1, 1}
}

// Configuration for reading Cloud Storage data written via [Cloud Storage
// subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage). The
// data and attributes fields of the originally exported Pub/Sub message
// will be restored when publishing.
type IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat) Reset() {
	*x = IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat) ProtoMessage() {}

func (x *IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat.ProtoReflect.Descriptor instead.
func (*IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{2, 1, 2}
}

// Specifies the reason why some data may have been left out of
// the desired Pub/Sub message due to the API message limits
// (https://cloud.google.com/pubsub/quotas#resource_limits). For example,
// when the number of attributes is larger than 100, the number of
// attributes is truncated to 100 to respect the limit on the attribute count.
// Other attribute limits are treated similarly. When the size of the desired
// message would've been larger than 10MB, the message won't be published at
// all, and ingestion of the subsequent messages will proceed as normal.
type IngestionFailureEvent_ApiViolationReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IngestionFailureEvent_ApiViolationReason) Reset() {
	*x = IngestionFailureEvent_ApiViolationReason{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_ApiViolationReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_ApiViolationReason) ProtoMessage() {}

func (x *IngestionFailureEvent_ApiViolationReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_ApiViolationReason.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_ApiViolationReason) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 0}
}

// Set when an Avro file is unsupported or its format is not valid. When this
// occurs, one or more Avro objects won't be ingested.
type IngestionFailureEvent_AvroFailureReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IngestionFailureEvent_AvroFailureReason) Reset() {
	*x = IngestionFailureEvent_AvroFailureReason{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_AvroFailureReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_AvroFailureReason) ProtoMessage() {}

func (x *IngestionFailureEvent_AvroFailureReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_AvroFailureReason.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_AvroFailureReason) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 1}
}

// Set when a Pub/Sub message fails to get published due to a schema
// validation violation.
type IngestionFailureEvent_SchemaViolationReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IngestionFailureEvent_SchemaViolationReason) Reset() {
	*x = IngestionFailureEvent_SchemaViolationReason{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_SchemaViolationReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_SchemaViolationReason) ProtoMessage() {}

func (x *IngestionFailureEvent_SchemaViolationReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_SchemaViolationReason.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_SchemaViolationReason) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 2}
}

// Set when a Pub/Sub message fails to get published due to a message
// transformation error.
type IngestionFailureEvent_MessageTransformationFailureReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IngestionFailureEvent_MessageTransformationFailureReason) Reset() {
	*x = IngestionFailureEvent_MessageTransformationFailureReason{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_MessageTransformationFailureReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_MessageTransformationFailureReason) ProtoMessage() {}

func (x *IngestionFailureEvent_MessageTransformationFailureReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_MessageTransformationFailureReason.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_MessageTransformationFailureReason) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 3}
}

// Failure when ingesting from a Cloud Storage source.
type IngestionFailureEvent_CloudStorageFailure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the Cloud Storage bucket used for ingestion.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Optional. Name of the Cloud Storage object which contained the section
	// that couldn't be ingested.
	ObjectName string `protobuf:"bytes,2,opt,name=object_name,json=objectName,proto3" json:"object_name,omitempty"`
	// Optional. Generation of the Cloud Storage object which contained the
	// section that couldn't be ingested.
	ObjectGeneration int64 `protobuf:"varint,3,opt,name=object_generation,json=objectGeneration,proto3" json:"object_generation,omitempty"`
	// Reason why ingestion failed for the specified object.
	//
	// Types that are assignable to Reason:
	//
	//	*IngestionFailureEvent_CloudStorageFailure_AvroFailureReason
	//	*IngestionFailureEvent_CloudStorageFailure_ApiViolationReason
	//	*IngestionFailureEvent_CloudStorageFailure_SchemaViolationReason
	//	*IngestionFailureEvent_CloudStorageFailure_MessageTransformationFailureReason
	Reason isIngestionFailureEvent_CloudStorageFailure_Reason `protobuf_oneof:"reason"`
}

func (x *IngestionFailureEvent_CloudStorageFailure) Reset() {
	*x = IngestionFailureEvent_CloudStorageFailure{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_CloudStorageFailure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_CloudStorageFailure) ProtoMessage() {}

func (x *IngestionFailureEvent_CloudStorageFailure) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_CloudStorageFailure.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_CloudStorageFailure) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 4}
}

func (x *IngestionFailureEvent_CloudStorageFailure) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *IngestionFailureEvent_CloudStorageFailure) GetObjectName() string {
	if x != nil {
		return x.ObjectName
	}
	return ""
}

func (x *IngestionFailureEvent_CloudStorageFailure) GetObjectGeneration() int64 {
	if x != nil {
		return x.ObjectGeneration
	}
	return 0
}

func (m *IngestionFailureEvent_CloudStorageFailure) GetReason() isIngestionFailureEvent_CloudStorageFailure_Reason {
	if m != nil {
		return m.Reason
	}
	return nil
}

func (x *IngestionFailureEvent_CloudStorageFailure) GetAvroFailureReason() *IngestionFailureEvent_AvroFailureReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_CloudStorageFailure_AvroFailureReason); ok {
		return x.AvroFailureReason
	}
	return nil
}

func (x *IngestionFailureEvent_CloudStorageFailure) GetApiViolationReason() *IngestionFailureEvent_ApiViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_CloudStorageFailure_ApiViolationReason); ok {
		return x.ApiViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_CloudStorageFailure) GetSchemaViolationReason() *IngestionFailureEvent_SchemaViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_CloudStorageFailure_SchemaViolationReason); ok {
		return x.SchemaViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_CloudStorageFailure) GetMessageTransformationFailureReason() *IngestionFailureEvent_MessageTransformationFailureReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_CloudStorageFailure_MessageTransformationFailureReason); ok {
		return x.MessageTransformationFailureReason
	}
	return nil
}

type isIngestionFailureEvent_CloudStorageFailure_Reason interface {
	isIngestionFailureEvent_CloudStorageFailure_Reason()
}

type IngestionFailureEvent_CloudStorageFailure_AvroFailureReason struct {
	// Optional. Failure encountered when parsing an Avro file.
	AvroFailureReason *IngestionFailureEvent_AvroFailureReason `protobuf:"bytes,5,opt,name=avro_failure_reason,json=avroFailureReason,proto3,oneof"`
}

type IngestionFailureEvent_CloudStorageFailure_ApiViolationReason struct {
	// Optional. The Pub/Sub API limits prevented the desired message from
	// being published.
	ApiViolationReason *IngestionFailureEvent_ApiViolationReason `protobuf:"bytes,6,opt,name=api_violation_reason,json=apiViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_CloudStorageFailure_SchemaViolationReason struct {
	// Optional. The Pub/Sub message failed schema validation.
	SchemaViolationReason *IngestionFailureEvent_SchemaViolationReason `protobuf:"bytes,7,opt,name=schema_violation_reason,json=schemaViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_CloudStorageFailure_MessageTransformationFailureReason struct {
	// Optional. Failure encountered when applying a message transformation to
	// the Pub/Sub message.
	MessageTransformationFailureReason *IngestionFailureEvent_MessageTransformationFailureReason `protobuf:"bytes,8,opt,name=message_transformation_failure_reason,json=messageTransformationFailureReason,proto3,oneof"`
}

func (*IngestionFailureEvent_CloudStorageFailure_AvroFailureReason) isIngestionFailureEvent_CloudStorageFailure_Reason() {
}

func (*IngestionFailureEvent_CloudStorageFailure_ApiViolationReason) isIngestionFailureEvent_CloudStorageFailure_Reason() {
}

func (*IngestionFailureEvent_CloudStorageFailure_SchemaViolationReason) isIngestionFailureEvent_CloudStorageFailure_Reason() {
}

func (*IngestionFailureEvent_CloudStorageFailure_MessageTransformationFailureReason) isIngestionFailureEvent_CloudStorageFailure_Reason() {
}

// Failure when ingesting from an Amazon MSK source.
type IngestionFailureEvent_AwsMskFailureReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The ARN of the cluster of the topic being ingested from.
	ClusterArn string `protobuf:"bytes,1,opt,name=cluster_arn,json=clusterArn,proto3" json:"cluster_arn,omitempty"`
	// Optional. The name of the Kafka topic being ingested from.
	KafkaTopic string `protobuf:"bytes,2,opt,name=kafka_topic,json=kafkaTopic,proto3" json:"kafka_topic,omitempty"`
	// Optional. The partition ID of the message that failed to be ingested.
	PartitionId int64 `protobuf:"varint,3,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// Optional. The offset within the partition of the message that failed to
	// be ingested.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	// Reason why ingestion failed for the specified message.
	//
	// Types that are assignable to Reason:
	//
	//	*IngestionFailureEvent_AwsMskFailureReason_ApiViolationReason
	//	*IngestionFailureEvent_AwsMskFailureReason_SchemaViolationReason
	//	*IngestionFailureEvent_AwsMskFailureReason_MessageTransformationFailureReason
	Reason isIngestionFailureEvent_AwsMskFailureReason_Reason `protobuf_oneof:"reason"`
}

func (x *IngestionFailureEvent_AwsMskFailureReason) Reset() {
	*x = IngestionFailureEvent_AwsMskFailureReason{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_AwsMskFailureReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_AwsMskFailureReason) ProtoMessage() {}

func (x *IngestionFailureEvent_AwsMskFailureReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_AwsMskFailureReason.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_AwsMskFailureReason) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 5}
}

func (x *IngestionFailureEvent_AwsMskFailureReason) GetClusterArn() string {
	if x != nil {
		return x.ClusterArn
	}
	return ""
}

func (x *IngestionFailureEvent_AwsMskFailureReason) GetKafkaTopic() string {
	if x != nil {
		return x.KafkaTopic
	}
	return ""
}

func (x *IngestionFailureEvent_AwsMskFailureReason) GetPartitionId() int64 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *IngestionFailureEvent_AwsMskFailureReason) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (m *IngestionFailureEvent_AwsMskFailureReason) GetReason() isIngestionFailureEvent_AwsMskFailureReason_Reason {
	if m != nil {
		return m.Reason
	}
	return nil
}

func (x *IngestionFailureEvent_AwsMskFailureReason) GetApiViolationReason() *IngestionFailureEvent_ApiViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AwsMskFailureReason_ApiViolationReason); ok {
		return x.ApiViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_AwsMskFailureReason) GetSchemaViolationReason() *IngestionFailureEvent_SchemaViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AwsMskFailureReason_SchemaViolationReason); ok {
		return x.SchemaViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_AwsMskFailureReason) GetMessageTransformationFailureReason() *IngestionFailureEvent_MessageTransformationFailureReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AwsMskFailureReason_MessageTransformationFailureReason); ok {
		return x.MessageTransformationFailureReason
	}
	return nil
}

type isIngestionFailureEvent_AwsMskFailureReason_Reason interface {
	isIngestionFailureEvent_AwsMskFailureReason_Reason()
}

type IngestionFailureEvent_AwsMskFailureReason_ApiViolationReason struct {
	// Optional. The Pub/Sub API limits prevented the desired message from
	// being published.
	ApiViolationReason *IngestionFailureEvent_ApiViolationReason `protobuf:"bytes,5,opt,name=api_violation_reason,json=apiViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_AwsMskFailureReason_SchemaViolationReason struct {
	// Optional. The Pub/Sub message failed schema validation.
	SchemaViolationReason *IngestionFailureEvent_SchemaViolationReason `protobuf:"bytes,6,opt,name=schema_violation_reason,json=schemaViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_AwsMskFailureReason_MessageTransformationFailureReason struct {
	// Optional. Failure encountered when applying a message transformation to
	// the Pub/Sub message.
	MessageTransformationFailureReason *IngestionFailureEvent_MessageTransformationFailureReason `protobuf:"bytes,7,opt,name=message_transformation_failure_reason,json=messageTransformationFailureReason,proto3,oneof"`
}

func (*IngestionFailureEvent_AwsMskFailureReason_ApiViolationReason) isIngestionFailureEvent_AwsMskFailureReason_Reason() {
}

func (*IngestionFailureEvent_AwsMskFailureReason_SchemaViolationReason) isIngestionFailureEvent_AwsMskFailureReason_Reason() {
}

func (*IngestionFailureEvent_AwsMskFailureReason_MessageTransformationFailureReason) isIngestionFailureEvent_AwsMskFailureReason_Reason() {
}

// Failure when ingesting from an Azure Event Hubs source.
type IngestionFailureEvent_AzureEventHubsFailureReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The namespace containing the event hub being ingested from.
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Optional. The name of the event hub being ingested from.
	EventHub string `protobuf:"bytes,2,opt,name=event_hub,json=eventHub,proto3" json:"event_hub,omitempty"`
	// Optional. The partition ID of the message that failed to be ingested.
	PartitionId int64 `protobuf:"varint,3,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// Optional. The offset within the partition of the message that failed to
	// be ingested.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	// Reason why ingestion failed for the specified message.
	//
	// Types that are assignable to Reason:
	//
	//	*IngestionFailureEvent_AzureEventHubsFailureReason_ApiViolationReason
	//	*IngestionFailureEvent_AzureEventHubsFailureReason_SchemaViolationReason
	//	*IngestionFailureEvent_AzureEventHubsFailureReason_MessageTransformationFailureReason
	Reason isIngestionFailureEvent_AzureEventHubsFailureReason_Reason `protobuf_oneof:"reason"`
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) Reset() {
	*x = IngestionFailureEvent_AzureEventHubsFailureReason{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_AzureEventHubsFailureReason) ProtoMessage() {}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_AzureEventHubsFailureReason.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_AzureEventHubsFailureReason) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 6}
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) GetEventHub() string {
	if x != nil {
		return x.EventHub
	}
	return ""
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) GetPartitionId() int64 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (m *IngestionFailureEvent_AzureEventHubsFailureReason) GetReason() isIngestionFailureEvent_AzureEventHubsFailureReason_Reason {
	if m != nil {
		return m.Reason
	}
	return nil
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) GetApiViolationReason() *IngestionFailureEvent_ApiViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AzureEventHubsFailureReason_ApiViolationReason); ok {
		return x.ApiViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) GetSchemaViolationReason() *IngestionFailureEvent_SchemaViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AzureEventHubsFailureReason_SchemaViolationReason); ok {
		return x.SchemaViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_AzureEventHubsFailureReason) GetMessageTransformationFailureReason() *IngestionFailureEvent_MessageTransformationFailureReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AzureEventHubsFailureReason_MessageTransformationFailureReason); ok {
		return x.MessageTransformationFailureReason
	}
	return nil
}

type isIngestionFailureEvent_AzureEventHubsFailureReason_Reason interface {
	isIngestionFailureEvent_AzureEventHubsFailureReason_Reason()
}

type IngestionFailureEvent_AzureEventHubsFailureReason_ApiViolationReason struct {
	// Optional. The Pub/Sub API limits prevented the desired message from
	// being published.
	ApiViolationReason *IngestionFailureEvent_ApiViolationReason `protobuf:"bytes,5,opt,name=api_violation_reason,json=apiViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_AzureEventHubsFailureReason_SchemaViolationReason struct {
	// Optional. The Pub/Sub message failed schema validation.
	SchemaViolationReason *IngestionFailureEvent_SchemaViolationReason `protobuf:"bytes,6,opt,name=schema_violation_reason,json=schemaViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_AzureEventHubsFailureReason_MessageTransformationFailureReason struct {
	// Optional. Failure encountered when applying a message transformation to
	// the Pub/Sub message.
	MessageTransformationFailureReason *IngestionFailureEvent_MessageTransformationFailureReason `protobuf:"bytes,7,opt,name=message_transformation_failure_reason,json=messageTransformationFailureReason,proto3,oneof"`
}

func (*IngestionFailureEvent_AzureEventHubsFailureReason_ApiViolationReason) isIngestionFailureEvent_AzureEventHubsFailureReason_Reason() {
}

func (*IngestionFailureEvent_AzureEventHubsFailureReason_SchemaViolationReason) isIngestionFailureEvent_AzureEventHubsFailureReason_Reason() {
}

func (*IngestionFailureEvent_AzureEventHubsFailureReason_MessageTransformationFailureReason) isIngestionFailureEvent_AzureEventHubsFailureReason_Reason() {
}

// Failure when ingesting from a Confluent Cloud source.
type IngestionFailureEvent_ConfluentCloudFailureReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The cluster ID containing the topic being ingested from.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Optional. The name of the Kafka topic being ingested from.
	KafkaTopic string `protobuf:"bytes,2,opt,name=kafka_topic,json=kafkaTopic,proto3" json:"kafka_topic,omitempty"`
	// Optional. The partition ID of the message that failed to be ingested.
	PartitionId int64 `protobuf:"varint,3,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// Optional. The offset within the partition of the message that failed to
	// be ingested.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	// Reason why ingestion failed for the specified message.
	//
	// Types that are assignable to Reason:
	//
	//	*IngestionFailureEvent_ConfluentCloudFailureReason_ApiViolationReason
	//	*IngestionFailureEvent_ConfluentCloudFailureReason_SchemaViolationReason
	//	*IngestionFailureEvent_ConfluentCloudFailureReason_MessageTransformationFailureReason
	Reason isIngestionFailureEvent_ConfluentCloudFailureReason_Reason `protobuf_oneof:"reason"`
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) Reset() {
	*x = IngestionFailureEvent_ConfluentCloudFailureReason{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_ConfluentCloudFailureReason) ProtoMessage() {}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_ConfluentCloudFailureReason.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_ConfluentCloudFailureReason) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 7}
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) GetKafkaTopic() string {
	if x != nil {
		return x.KafkaTopic
	}
	return ""
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) GetPartitionId() int64 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (m *IngestionFailureEvent_ConfluentCloudFailureReason) GetReason() isIngestionFailureEvent_ConfluentCloudFailureReason_Reason {
	if m != nil {
		return m.Reason
	}
	return nil
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) GetApiViolationReason() *IngestionFailureEvent_ApiViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_ConfluentCloudFailureReason_ApiViolationReason); ok {
		return x.ApiViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) GetSchemaViolationReason() *IngestionFailureEvent_SchemaViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_ConfluentCloudFailureReason_SchemaViolationReason); ok {
		return x.SchemaViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_ConfluentCloudFailureReason) GetMessageTransformationFailureReason() *IngestionFailureEvent_MessageTransformationFailureReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_ConfluentCloudFailureReason_MessageTransformationFailureReason); ok {
		return x.MessageTransformationFailureReason
	}
	return nil
}

type isIngestionFailureEvent_ConfluentCloudFailureReason_Reason interface {
	isIngestionFailureEvent_ConfluentCloudFailureReason_Reason()
}

type IngestionFailureEvent_ConfluentCloudFailureReason_ApiViolationReason struct {
	// Optional. The Pub/Sub API limits prevented the desired message from
	// being published.
	ApiViolationReason *IngestionFailureEvent_ApiViolationReason `protobuf:"bytes,5,opt,name=api_violation_reason,json=apiViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_ConfluentCloudFailureReason_SchemaViolationReason struct {
	// Optional. The Pub/Sub message failed schema validation.
	SchemaViolationReason *IngestionFailureEvent_SchemaViolationReason `protobuf:"bytes,6,opt,name=schema_violation_reason,json=schemaViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_ConfluentCloudFailureReason_MessageTransformationFailureReason struct {
	// Optional. Failure encountered when applying a message transformation to
	// the Pub/Sub message.
	MessageTransformationFailureReason *IngestionFailureEvent_MessageTransformationFailureReason `protobuf:"bytes,7,opt,name=message_transformation_failure_reason,json=messageTransformationFailureReason,proto3,oneof"`
}

func (*IngestionFailureEvent_ConfluentCloudFailureReason_ApiViolationReason) isIngestionFailureEvent_ConfluentCloudFailureReason_Reason() {
}

func (*IngestionFailureEvent_ConfluentCloudFailureReason_SchemaViolationReason) isIngestionFailureEvent_ConfluentCloudFailureReason_Reason() {
}

func (*IngestionFailureEvent_ConfluentCloudFailureReason_MessageTransformationFailureReason) isIngestionFailureEvent_ConfluentCloudFailureReason_Reason() {
}

// Failure when ingesting from an AWS Kinesis source.
type IngestionFailureEvent_AwsKinesisFailureReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The stream ARN of the Kinesis stream being ingested from.
	StreamArn string `protobuf:"bytes,1,opt,name=stream_arn,json=streamArn,proto3" json:"stream_arn,omitempty"`
	// Optional. The partition key of the message that failed to be ingested.
	PartitionKey string `protobuf:"bytes,2,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// Optional. The sequence number of the message that failed to be ingested.
	SequenceNumber string `protobuf:"bytes,3,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
	// Reason why ingestion failed for the specified message.
	//
	// Types that are assignable to Reason:
	//
	//	*IngestionFailureEvent_AwsKinesisFailureReason_SchemaViolationReason
	//	*IngestionFailureEvent_AwsKinesisFailureReason_MessageTransformationFailureReason
	//	*IngestionFailureEvent_AwsKinesisFailureReason_ApiViolationReason
	Reason isIngestionFailureEvent_AwsKinesisFailureReason_Reason `protobuf_oneof:"reason"`
}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) Reset() {
	*x = IngestionFailureEvent_AwsKinesisFailureReason{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestionFailureEvent_AwsKinesisFailureReason) ProtoMessage() {}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestionFailureEvent_AwsKinesisFailureReason.ProtoReflect.Descriptor instead.
func (*IngestionFailureEvent_AwsKinesisFailureReason) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{4, 8}
}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) GetStreamArn() string {
	if x != nil {
		return x.StreamArn
	}
	return ""
}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) GetPartitionKey() string {
	if x != nil {
		return x.PartitionKey
	}
	return ""
}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) GetSequenceNumber() string {
	if x != nil {
		return x.SequenceNumber
	}
	return ""
}

func (m *IngestionFailureEvent_AwsKinesisFailureReason) GetReason() isIngestionFailureEvent_AwsKinesisFailureReason_Reason {
	if m != nil {
		return m.Reason
	}
	return nil
}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) GetSchemaViolationReason() *IngestionFailureEvent_SchemaViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AwsKinesisFailureReason_SchemaViolationReason); ok {
		return x.SchemaViolationReason
	}
	return nil
}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) GetMessageTransformationFailureReason() *IngestionFailureEvent_MessageTransformationFailureReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AwsKinesisFailureReason_MessageTransformationFailureReason); ok {
		return x.MessageTransformationFailureReason
	}
	return nil
}

func (x *IngestionFailureEvent_AwsKinesisFailureReason) GetApiViolationReason() *IngestionFailureEvent_ApiViolationReason {
	if x, ok := x.GetReason().(*IngestionFailureEvent_AwsKinesisFailureReason_ApiViolationReason); ok {
		return x.ApiViolationReason
	}
	return nil
}

type isIngestionFailureEvent_AwsKinesisFailureReason_Reason interface {
	isIngestionFailureEvent_AwsKinesisFailureReason_Reason()
}

type IngestionFailureEvent_AwsKinesisFailureReason_SchemaViolationReason struct {
	// Optional. The Pub/Sub message failed schema validation.
	SchemaViolationReason *IngestionFailureEvent_SchemaViolationReason `protobuf:"bytes,4,opt,name=schema_violation_reason,json=schemaViolationReason,proto3,oneof"`
}

type IngestionFailureEvent_AwsKinesisFailureReason_MessageTransformationFailureReason struct {
	// Optional. Failure encountered when applying a message transformation to
	// the Pub/Sub message.
	MessageTransformationFailureReason *IngestionFailureEvent_MessageTransformationFailureReason `protobuf:"bytes,5,opt,name=message_transformation_failure_reason,json=messageTransformationFailureReason,proto3,oneof"`
}

type IngestionFailureEvent_AwsKinesisFailureReason_ApiViolationReason struct {
	// Optional. The message failed to be published due to an API violation.
	// This is only set when the size of the data field of the Kinesis record
	// is zero.
	ApiViolationReason *IngestionFailureEvent_ApiViolationReason `protobuf:"bytes,6,opt,name=api_violation_reason,json=apiViolationReason,proto3,oneof"`
}

func (*IngestionFailureEvent_AwsKinesisFailureReason_SchemaViolationReason) isIngestionFailureEvent_AwsKinesisFailureReason_Reason() {
}

func (*IngestionFailureEvent_AwsKinesisFailureReason_MessageTransformationFailureReason) isIngestionFailureEvent_AwsKinesisFailureReason_Reason() {
}

func (*IngestionFailureEvent_AwsKinesisFailureReason_ApiViolationReason) isIngestionFailureEvent_AwsKinesisFailureReason_Reason() {
}

// Information about an associated [Analytics Hub
// subscription](https://cloud.google.com/bigquery/docs/analytics-hub-manage-subscriptions).
type Subscription_AnalyticsHubSubscriptionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the associated Analytics Hub listing resource.
	// Pattern:
	// "projects/{project}/locations/{location}/dataExchanges/{data_exchange}/listings/{listing}"
	Listing string `protobuf:"bytes,1,opt,name=listing,proto3" json:"listing,omitempty"`
	// Optional. The name of the associated Analytics Hub subscription resource.
	// Pattern:
	// "projects/{project}/locations/{location}/subscriptions/{subscription}"
	Subscription string `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *Subscription_AnalyticsHubSubscriptionInfo) Reset() {
	*x = Subscription_AnalyticsHubSubscriptionInfo{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Subscription_AnalyticsHubSubscriptionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription_AnalyticsHubSubscriptionInfo) ProtoMessage() {}

func (x *Subscription_AnalyticsHubSubscriptionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription_AnalyticsHubSubscriptionInfo.ProtoReflect.Descriptor instead.
func (*Subscription_AnalyticsHubSubscriptionInfo) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{22, 0}
}

func (x *Subscription_AnalyticsHubSubscriptionInfo) GetListing() string {
	if x != nil {
		return x.Listing
	}
	return ""
}

func (x *Subscription_AnalyticsHubSubscriptionInfo) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

// Contains information needed for generating an
// [OpenID Connect
// token](https://developers.google.com/identity/protocols/OpenIDConnect).
type PushConfig_OidcToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. [Service account
	// email](https://cloud.google.com/iam/docs/service-accounts)
	// used for generating the OIDC token. For more information
	// on setting up authentication, see
	// [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Optional. Audience to be used when generating OIDC token. The audience
	// claim identifies the recipients that the JWT is intended for. The
	// audience value is a single case-sensitive string. Having multiple values
	// (array) for the audience field is not supported. More info about the OIDC
	// JWT token audience here:
	// https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
	// the Push endpoint URL will be used.
	Audience string `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *PushConfig_OidcToken) Reset() {
	*x = PushConfig_OidcToken{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushConfig_OidcToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushConfig_OidcToken) ProtoMessage() {}

func (x *PushConfig_OidcToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushConfig_OidcToken.ProtoReflect.Descriptor instead.
func (*PushConfig_OidcToken) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{26, 0}
}

func (x *PushConfig_OidcToken) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *PushConfig_OidcToken) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

// The payload to the push endpoint is in the form of the JSON representation
// of a PubsubMessage
// (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
type PushConfig_PubsubWrapper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PushConfig_PubsubWrapper) Reset() {
	*x = PushConfig_PubsubWrapper{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushConfig_PubsubWrapper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushConfig_PubsubWrapper) ProtoMessage() {}

func (x *PushConfig_PubsubWrapper) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushConfig_PubsubWrapper.ProtoReflect.Descriptor instead.
func (*PushConfig_PubsubWrapper) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{26, 1}
}

// Sets the `data` field as the HTTP body for delivery.
type PushConfig_NoWrapper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. When true, writes the Pub/Sub message metadata to
	// `x-goog-pubsub-<KEY>:<VAL>` headers of the HTTP request. Writes the
	// Pub/Sub message attributes to `<KEY>:<VAL>` headers of the HTTP request.
	WriteMetadata bool `protobuf:"varint,1,opt,name=write_metadata,json=writeMetadata,proto3" json:"write_metadata,omitempty"`
}

func (x *PushConfig_NoWrapper) Reset() {
	*x = PushConfig_NoWrapper{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushConfig_NoWrapper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushConfig_NoWrapper) ProtoMessage() {}

func (x *PushConfig_NoWrapper) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushConfig_NoWrapper.ProtoReflect.Descriptor instead.
func (*PushConfig_NoWrapper) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{26, 2}
}

func (x *PushConfig_NoWrapper) GetWriteMetadata() bool {
	if x != nil {
		return x.WriteMetadata
	}
	return false
}

// Configuration for writing message data in text format.
// Message payloads will be written to files as raw text, separated by a
// newline.
type CloudStorageConfig_TextConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CloudStorageConfig_TextConfig) Reset() {
	*x = CloudStorageConfig_TextConfig{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageConfig_TextConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageConfig_TextConfig) ProtoMessage() {}

func (x *CloudStorageConfig_TextConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageConfig_TextConfig.ProtoReflect.Descriptor instead.
func (*CloudStorageConfig_TextConfig) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{28, 0}
}

// Configuration for writing message data in Avro format.
// Message payloads and metadata will be written to files as an Avro binary.
type CloudStorageConfig_AvroConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. When true, write the subscription name, message_id,
	// publish_time, attributes, and ordering_key as additional fields in the
	// output. The subscription name, message_id, and publish_time fields are
	// put in their own fields while all other message properties other than
	// data (for example, an ordering_key, if present) are added as entries in
	// the attributes map.
	WriteMetadata bool `protobuf:"varint,1,opt,name=write_metadata,json=writeMetadata,proto3" json:"write_metadata,omitempty"`
	// Optional. When true, the output Cloud Storage file will be serialized
	// using the topic schema, if it exists.
	UseTopicSchema bool `protobuf:"varint,2,opt,name=use_topic_schema,json=useTopicSchema,proto3" json:"use_topic_schema,omitempty"`
}

func (x *CloudStorageConfig_AvroConfig) Reset() {
	*x = CloudStorageConfig_AvroConfig{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageConfig_AvroConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageConfig_AvroConfig) ProtoMessage() {}

func (x *CloudStorageConfig_AvroConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageConfig_AvroConfig.ProtoReflect.Descriptor instead.
func (*CloudStorageConfig_AvroConfig) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{28, 1}
}

func (x *CloudStorageConfig_AvroConfig) GetWriteMetadata() bool {
	if x != nil {
		return x.WriteMetadata
	}
	return false
}

func (x *CloudStorageConfig_AvroConfig) GetUseTopicSchema() bool {
	if x != nil {
		return x.UseTopicSchema
	}
	return false
}

// Acknowledgment IDs sent in one or more previous requests to acknowledge a
// previously received message.
type StreamingPullResponse_AcknowledgeConfirmation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Successfully processed acknowledgment IDs.
	AckIds []string `protobuf:"bytes,1,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
	// Optional. List of acknowledgment IDs that were malformed or whose
	// acknowledgment deadline has expired.
	InvalidAckIds []string `protobuf:"bytes,2,rep,name=invalid_ack_ids,json=invalidAckIds,proto3" json:"invalid_ack_ids,omitempty"`
	// Optional. List of acknowledgment IDs that were out of order.
	UnorderedAckIds []string `protobuf:"bytes,3,rep,name=unordered_ack_ids,json=unorderedAckIds,proto3" json:"unordered_ack_ids,omitempty"`
	// Optional. List of acknowledgment IDs that failed processing with
	// temporary issues.
	TemporaryFailedAckIds []string `protobuf:"bytes,4,rep,name=temporary_failed_ack_ids,json=temporaryFailedAckIds,proto3" json:"temporary_failed_ack_ids,omitempty"`
}

func (x *StreamingPullResponse_AcknowledgeConfirmation) Reset() {
	*x = StreamingPullResponse_AcknowledgeConfirmation{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingPullResponse_AcknowledgeConfirmation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingPullResponse_AcknowledgeConfirmation) ProtoMessage() {}

func (x *StreamingPullResponse_AcknowledgeConfirmation) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingPullResponse_AcknowledgeConfirmation.ProtoReflect.Descriptor instead.
func (*StreamingPullResponse_AcknowledgeConfirmation) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{41, 0}
}

func (x *StreamingPullResponse_AcknowledgeConfirmation) GetAckIds() []string {
	if x != nil {
		return x.AckIds
	}
	return nil
}

func (x *StreamingPullResponse_AcknowledgeConfirmation) GetInvalidAckIds() []string {
	if x != nil {
		return x.InvalidAckIds
	}
	return nil
}

func (x *StreamingPullResponse_AcknowledgeConfirmation) GetUnorderedAckIds() []string {
	if x != nil {
		return x.UnorderedAckIds
	}
	return nil
}

func (x *StreamingPullResponse_AcknowledgeConfirmation) GetTemporaryFailedAckIds() []string {
	if x != nil {
		return x.TemporaryFailedAckIds
	}
	return nil
}

// Acknowledgment IDs sent in one or more previous requests to modify the
// deadline for a specific message.
type StreamingPullResponse_ModifyAckDeadlineConfirmation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Successfully processed acknowledgment IDs.
	AckIds []string `protobuf:"bytes,1,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
	// Optional. List of acknowledgment IDs that were malformed or whose
	// acknowledgment deadline has expired.
	InvalidAckIds []string `protobuf:"bytes,2,rep,name=invalid_ack_ids,json=invalidAckIds,proto3" json:"invalid_ack_ids,omitempty"`
	// Optional. List of acknowledgment IDs that failed processing with
	// temporary issues.
	TemporaryFailedAckIds []string `protobuf:"bytes,3,rep,name=temporary_failed_ack_ids,json=temporaryFailedAckIds,proto3" json:"temporary_failed_ack_ids,omitempty"`
}

func (x *StreamingPullResponse_ModifyAckDeadlineConfirmation) Reset() {
	*x = StreamingPullResponse_ModifyAckDeadlineConfirmation{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingPullResponse_ModifyAckDeadlineConfirmation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingPullResponse_ModifyAckDeadlineConfirmation) ProtoMessage() {}

func (x *StreamingPullResponse_ModifyAckDeadlineConfirmation) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingPullResponse_ModifyAckDeadlineConfirmation.ProtoReflect.Descriptor instead.
func (*StreamingPullResponse_ModifyAckDeadlineConfirmation) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{41, 1}
}

func (x *StreamingPullResponse_ModifyAckDeadlineConfirmation) GetAckIds() []string {
	if x != nil {
		return x.AckIds
	}
	return nil
}

func (x *StreamingPullResponse_ModifyAckDeadlineConfirmation) GetInvalidAckIds() []string {
	if x != nil {
		return x.InvalidAckIds
	}
	return nil
}

func (x *StreamingPullResponse_ModifyAckDeadlineConfirmation) GetTemporaryFailedAckIds() []string {
	if x != nil {
		return x.TemporaryFailedAckIds
	}
	return nil
}

// Subscription properties sent as part of the response.
type StreamingPullResponse_SubscriptionProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. True iff exactly once delivery is enabled for this
	// subscription.
	ExactlyOnceDeliveryEnabled bool `protobuf:"varint,1,opt,name=exactly_once_delivery_enabled,json=exactlyOnceDeliveryEnabled,proto3" json:"exactly_once_delivery_enabled,omitempty"`
	// Optional. True iff message ordering is enabled for this subscription.
	MessageOrderingEnabled bool `protobuf:"varint,2,opt,name=message_ordering_enabled,json=messageOrderingEnabled,proto3" json:"message_ordering_enabled,omitempty"`
}

func (x *StreamingPullResponse_SubscriptionProperties) Reset() {
	*x = StreamingPullResponse_SubscriptionProperties{}
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingPullResponse_SubscriptionProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingPullResponse_SubscriptionProperties) ProtoMessage() {}

func (x *StreamingPullResponse_SubscriptionProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_pubsub_v1_pubsub_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingPullResponse_SubscriptionProperties.ProtoReflect.Descriptor instead.
func (*StreamingPullResponse_SubscriptionProperties) Descriptor() ([]byte, []int) {
	return file_google_pubsub_v1_pubsub_proto_rawDescGZIP(), []int{41, 2}
}

func (x *StreamingPullResponse_SubscriptionProperties) GetExactlyOnceDeliveryEnabled() bool {
	if x != nil {
		return x.ExactlyOnceDeliveryEnabled
	}
	return false
}

func (x *StreamingPullResponse_SubscriptionProperties) GetMessageOrderingEnabled() bool {
	if x != nil {
		return x.MessageOrderingEnabled
	}
	return false
}

var File_google_pubsub_v1_pubsub_proto protoreflect.FileDescriptor

var file_google_pubsub_v1_pubsub_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x10, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x8e, 0x01, 0x0a, 0x14, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x43, 0x0a, 0x1b,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x50,
	0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x31, 0x0a, 0x12, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x22, 0xeb, 0x01, 0x0a, 0x0e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3c, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a,
	0x1c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3b, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x2f, 0x0a, 0x11, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x22, 0xcf, 0x1b, 0x0a, 0x1b, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x60, 0x0a, 0x0b, 0x61, 0x77, 0x73, 0x5f, 0x6b, 0x69, 0x6e, 0x65, 0x73, 0x69,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x77, 0x73, 0x4b, 0x69, 0x6e, 0x65, 0x73, 0x69,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x77, 0x73, 0x4b, 0x69, 0x6e,
	0x65, 0x73, 0x69, 0x73, 0x12, 0x66, 0x0a, 0x0d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x6d, 0x0a, 0x10,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x75, 0x62, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x48, 0x75, 0x62, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x75, 0x62, 0x73, 0x12, 0x54, 0x0a, 0x07, 0x61,
	0x77, 0x73, 0x5f, 0x6d, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x77, 0x73, 0x4d,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x06, 0x61, 0x77, 0x73, 0x4d, 0x73,
	0x6b, 0x12, 0x6c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x75,
	0x65, 0x6e, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12,
	0x61, 0x0a, 0x16, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6c, 0x6f, 0x67, 0x73,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x6f, 0x67, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x6f, 0x67, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x1a, 0xa8, 0x03, 0x0a, 0x0a, 0x41, 0x77, 0x73, 0x4b, 0x69, 0x6e, 0x65, 0x73, 0x69,
	0x73, 0x12, 0x59, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x41, 0x77, 0x73, 0x4b, 0x69, 0x6e, 0x65, 0x73, 0x69, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x61, 0x72, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x72, 0x6e,
	0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x61, 0x72, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x72, 0x41, 0x72, 0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x61, 0x77, 0x73, 0x5f,
	0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x61, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x77, 0x73, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x72, 0x6e, 0x12,
	0x33, 0x0a, 0x13, 0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x11, 0x67, 0x63, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x22, 0x96, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x01, 0x12, 0x1d, 0x0a, 0x19, 0x4b, 0x49, 0x4e, 0x45, 0x53, 0x49, 0x53, 0x5f, 0x50, 0x45, 0x52,
	0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x1d, 0x0a, 0x19, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x5f, 0x50, 0x45, 0x52, 0x4d,
	0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x14, 0x0a, 0x10, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f,
	0x55, 0x4e, 0x44, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45,
	0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x05, 0x1a, 0xfe, 0x06,
	0x0a, 0x0c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x5b,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x6d, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78,
	0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x6d, 0x0a, 0x0b, 0x61, 0x76, 0x72, 0x6f, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x76, 0x72, 0x6f,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x80, 0x01, 0x0a, 0x12, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x5f, 0x61, 0x76, 0x72, 0x6f, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x41,
	0x76, 0x72, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x5c, 0x0a, 0x1a, 0x6d, 0x69, 0x6e,
	0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17,
	0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x67, 0x6c, 0x6f, 0x62, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x47, 0x6c, 0x6f, 0x62, 0x1a, 0x42, 0x0a, 0x0a, 0x54,
	0x65, 0x78, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x26, 0x0a, 0x09, 0x64, 0x65, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x88, 0x01,
	0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x1a,
	0x0c, 0x0a, 0x0a, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x1a, 0x12, 0x0a,
	0x10, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x22, 0x9a, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x23,
	0x0a, 0x1f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f,
	0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x5f, 0x50,
	0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x4f, 0x4f, 0x5f,
	0x4d, 0x41, 0x4e, 0x59, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x53, 0x10, 0x05, 0x42, 0x0e,
	0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x1a, 0xe1,
	0x04, 0x0a, 0x0e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x75, 0x62,
	0x73, 0x12, 0x5d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x75, 0x62, 0x73, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x21, 0x0a, 0x09,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x20, 0x0a, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x75, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x75,
	0x62, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x13, 0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x67, 0x63, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xd7, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x48,
	0x55, 0x42, 0x53, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44,
	0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x55, 0x42, 0x4c, 0x49,
	0x53, 0x48, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45,
	0x4e, 0x49, 0x45, 0x44, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50,
	0x41, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x12,
	0x17, 0x0a, 0x13, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x48, 0x55, 0x42, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x55, 0x42, 0x53,
	0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55,
	0x4e, 0x44, 0x10, 0x06, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44,
	0x10, 0x07, 0x1a, 0xaf, 0x03, 0x0a, 0x06, 0x41, 0x77, 0x73, 0x4d, 0x73, 0x6b, 0x12, 0x55, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x77, 0x73, 0x4d,
	0x73, 0x6b, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x61, 0x72, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x72, 0x6e, 0x12, 0x39, 0x0a, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1d, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x25, 0x0a, 0x0c, 0x61, 0x77, 0x73, 0x5f, 0x72, 0x6f, 0x6c,
	0x65, 0x5f, 0x61, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x61, 0x77, 0x73, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x72, 0x6e, 0x12, 0x33, 0x0a, 0x13,
	0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11,
	0x67, 0x63, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0x90, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x19,
	0x0a, 0x15, 0x4d, 0x53, 0x4b, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x55, 0x42,
	0x4c, 0x49, 0x53, 0x48, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4c, 0x55, 0x53,
	0x54, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x12,
	0x13, 0x0a, 0x0f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55,
	0x4e, 0x44, 0x10, 0x05, 0x1a, 0x83, 0x04, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x75, 0x65,
	0x6e, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x5d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x62, 0x6f, 0x6f, 0x74, 0x73, 0x74,
	0x72, 0x61, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x62, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x2d, 0x0a, 0x10, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x13, 0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x67, 0x63, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xbe, 0x01, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x55,
	0x45, 0x4e, 0x54, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1d, 0x0a,
	0x19, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c,
	0x55, 0x4e, 0x52, 0x45, 0x41, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54,
	0x53, 0x54, 0x52, 0x41, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x04, 0x12, 0x15,
	0x0a, 0x11, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f,
	0x55, 0x4e, 0x44, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x06, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x14, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x4c, 0x6f, 0x67, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x50, 0x0a,
	0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x6f, 0x67, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x22,
	0x5f, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53,
	0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10, 0x02, 0x12, 0x08,
	0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05,
	0x22, 0xa5, 0x1e, 0x0a, 0x15, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1d, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x76, 0x0a, 0x15, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x6a, 0x0a, 0x0f, 0x61, 0x77, 0x73, 0x5f, 0x6d,
	0x73, 0x6b, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x77, 0x73, 0x4d, 0x73, 0x6b,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x77, 0x73, 0x4d, 0x73, 0x6b, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x12, 0x83, 0x01, 0x0a, 0x18, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x68, 0x75, 0x62, 0x73, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x75, 0x62, 0x73, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x15, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x75,
	0x62, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x17, 0x63, 0x6f,
	0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x66, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x75, 0x65,
	0x6e, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x76,
	0x0a, 0x13, 0x61, 0x77, 0x73, 0x5f, 0x6b, 0x69, 0x6e, 0x65, 0x73, 0x69, 0x73, 0x5f, 0x66, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x77, 0x73, 0x4b, 0x69, 0x6e, 0x65, 0x73, 0x69, 0x73, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x11, 0x61, 0x77, 0x73, 0x4b, 0x69, 0x6e, 0x65, 0x73, 0x69, 0x73, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x1a, 0x14, 0x0a, 0x12, 0x41, 0x70, 0x69, 0x56, 0x69, 0x6f,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x1a, 0x13, 0x0a, 0x11,
	0x41, 0x76, 0x72, 0x6f, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x1a, 0x17, 0x0a, 0x15, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x1a, 0x24, 0x0a, 0x22, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x1a, 0xa0, 0x05, 0x0a, 0x13, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x11, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70, 0x0a,
	0x13, 0x61, 0x76, 0x72, 0x6f, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x61, 0x76,
	0x72, 0x6f, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x73, 0x0a, 0x14, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x12, 0x61, 0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x12, 0x7c, 0x0a, 0x17, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76,
	0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x12, 0xa4, 0x01, 0x0a, 0x25, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x22, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x1a, 0xca, 0x04, 0x0a, 0x13, 0x41, 0x77, 0x73, 0x4d, 0x73, 0x6b, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x72,
	0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6b, 0x61, 0x66,
	0x6b, 0x61, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x1b, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x73, 0x0a, 0x14,
	0x61, 0x70, 0x69, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x41, 0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x61,
	0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x7c, 0x0a, 0x17, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x69, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0xa4, 0x01, 0x0a, 0x25, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x22, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x1a, 0xcb, 0x04, 0x0a, 0x1b, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48,
	0x75, 0x62, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x12, 0x21, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x75, 0x62,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x48, 0x75, 0x62, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b, 0x0a,
	0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x73, 0x0a, 0x14, 0x61, 0x70,
	0x69, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x41, 0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x61, 0x70, 0x69,
	0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x7c, 0x0a, 0x17, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x69,
	0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0xa4, 0x01,
	0x0a, 0x25, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x22, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x1a, 0xd0,
	0x04, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x22,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x5f, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6b, 0x61,
	0x66, 0x6b, 0x61, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x73, 0x0a,
	0x14, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12,
	0x61, 0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x12, 0x7c, 0x0a, 0x17, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x69, 0x6f,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x12, 0xa4, 0x01, 0x0a, 0x25, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x22, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x1a, 0xb9, 0x04, 0x0a, 0x17, 0x41, 0x77, 0x73, 0x4b, 0x69, 0x6e, 0x65, 0x73, 0x69, 0x73,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x0a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x61, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x72,
	0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x0f, 0x73,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x7c, 0x0a, 0x17, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x15, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0xa4, 0x01, 0x0a, 0x25, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x22, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x73,
	0x0a, 0x14, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x12, 0x61, 0x70, 0x69, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x09, 0x0a,
	0x07, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x22, 0x52, 0x0a, 0x0d, 0x4a, 0x61, 0x76, 0x61,
	0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x55, 0x44, 0x46, 0x12, 0x28, 0x0a, 0x0d, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0xb0, 0x01, 0x0a,
	0x10, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x12, 0x4d, 0x0a, 0x0e, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f,
	0x75, 0x64, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x61, 0x76,
	0x61, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x55, 0x44, 0x46, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x0d, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x55, 0x64, 0x66,
	0x12, 0x1f, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x22,
	0xda, 0x08, 0x0a, 0x05, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x61, 0x0a, 0x16, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x14, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4b, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65,
	0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x5c,
	0x0a, 0x1a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x18, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x77, 0x0a, 0x1e, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x1b, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x56, 0x0a, 0x12, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18,
	0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x2e, 0x54,
	0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x09, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x48, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x47,
	0x45, 0x53, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x3a, 0x63, 0xea, 0x41, 0x60, 0x0a, 0x1b, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x21, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x7d, 0x12, 0x0f, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x2d, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x2a, 0x06, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x73, 0x32, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x22, 0xc3, 0x02, 0x0a,
	0x0d, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x54, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x0c,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x4b, 0x65, 0x79, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x4c, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x22, 0x8a, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x8d, 0x01,
	0x0a, 0x0e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x39, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x40, 0x0a, 0x08, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0x37, 0x0a,
	0x0f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x24, 0x0a, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x73, 0x22, 0xa8, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x77, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x12, 0x2b, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa0, 0x01, 0x0a, 0x1d, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9f, 0x01,
	0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x50, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x9c, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f,
	0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a,
	0x09, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x09, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x4f, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x22, 0x6b, 0x0a, 0x19, 0x44, 0x65, 0x74, 0x61, 0x63, 0x68, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x1c,
	0x0a, 0x1a, 0x44, 0x65, 0x74, 0x61, 0x63, 0x68, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb0, 0x0f, 0x0a,
	0x0c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x12, 0x42, 0x0a, 0x0b, 0x70, 0x75, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x75, 0x73, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x14, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x35, 0x0a, 0x14, 0x61, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x61, 0x63, 0x6b, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6e, 0x41, 0x63, 0x6b, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x5c, 0x0a, 0x1a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3b, 0x0a, 0x17, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x54, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x12, 0x64, 0x65, 0x61,
	0x64, 0x5f, 0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74,
	0x74, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x64, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x45, 0x0a, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x65, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x64, 0x65, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x12, 0x44, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x6c, 0x79, 0x5f, 0x6f, 0x6e, 0x63, 0x65, 0x5f,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x78, 0x61, 0x63, 0x74,
	0x6c, 0x79, 0x4f, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x12, 0x67,
	0x0a, 0x20, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1d, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x1f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x68, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x48, 0x75, 0x62, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x1c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x48,
	0x75, 0x62, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x56, 0x0a, 0x12, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x09, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x1a, 0x8e, 0x01, 0x0a, 0x1c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x48, 0x75, 0x62, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x45, 0x0a, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x27, 0x0a, 0x0c, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x22, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x32, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x9f, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x47, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x6f,
	0x66, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75,
	0x6d, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12, 0x47, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x69,
	0x6d, 0x75, 0x6d, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66,
	0x66, 0x22, 0x9c, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4f, 0x0a, 0x11, 0x64, 0x65, 0x61, 0x64, 0x5f, 0x6c,
	0x65, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x23, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x0f, 0x64, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74, 0x74,
	0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x37, 0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6d, 0x61, 0x78,
	0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73,
	0x22, 0x44, 0x0a, 0x10, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x30, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x22, 0x93, 0x05, 0x0a, 0x0a, 0x50, 0x75, 0x73, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x75, 0x73, 0x68, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x70, 0x75, 0x73, 0x68, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x51, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0a, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x6f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x58, 0x0a, 0x0e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x57, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0d, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x12, 0x4c, 0x0a, 0x0a, 0x6e, 0x6f,
	0x5f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x6f, 0x57,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x6e,
	0x6f, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x1a, 0x65, 0x0a, 0x09, 0x4f, 0x69, 0x64, 0x63,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x1f,
	0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x1a,
	0x0f, 0x0a, 0x0d, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x1a, 0x37, 0x0a, 0x09, 0x4e, 0x6f, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x12, 0x2a, 0x0a,
	0x0e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x17, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x42, 0x09, 0x0a, 0x07, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x22, 0xf3, 0x03, 0x0a,
	0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x73,
	0x65, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x54, 0x6f,
	0x70, 0x69, 0x63, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x2a, 0x0a, 0x0e, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x33, 0x0a, 0x13, 0x64, 0x72, 0x6f, 0x70, 0x5f, 0x75, 0x6e,
	0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x64, 0x72, 0x6f, 0x70, 0x55, 0x6e, 0x6b,
	0x6e, 0x6f, 0x77, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a,
	0x10, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x75, 0x73,
	0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x37, 0x0a, 0x15,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x45, 0x6d, 0x61, 0x69, 0x6c, 0x22, 0x8a, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x43, 0x48, 0x45,
	0x4d, 0x41, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x04, 0x12, 0x23, 0x0a,
	0x1f, 0x49, 0x4e, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f, 0x4c, 0x4f, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x05, 0x22, 0xa0, 0x07, 0x0a, 0x12, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61,
	0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x12, 0x3d, 0x0a, 0x18, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x66, 0x69, 0x6c, 0x65, 0x6e,
	0x61, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x12, 0x57, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x65, 0x78,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a,
	0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0b, 0x61, 0x76,
	0x72, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x76, 0x72, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x76, 0x72, 0x6f, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x41, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x6d, 0x61, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c,
	0x1a, 0x0c, 0x0a, 0x0a, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x67,
	0x0a, 0x0a, 0x41, 0x76, 0x72, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x0e,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x8a, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x4e,
	0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x49, 0x4e,
	0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12,
	0x13, 0x0a, 0x0f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54,
	0x43, 0x48, 0x10, 0x05, 0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x9d, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1a, 0x0a, 0x06, 0x61, 0x63, 0x6b,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05,
	0x61, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x41, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x22, 0x68, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xa6, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xaf, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x19, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x6b, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01,
	0x0a, 0x17, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0b, 0x70, 0x75, 0x73,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x70, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xbb, 0x01,
	0x0a, 0x0b, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a,
	0x12, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x65, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01,
	0x52, 0x11, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x49, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x65, 0x6c, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x6d, 0x61, 0x78, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0x63, 0x0a, 0x0c, 0x50,
	0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x11, 0x72,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x22, 0xbf, 0x01, 0x0a, 0x18, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x41, 0x63, 0x6b, 0x44, 0x65,
	0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a,
	0x07, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x61,
	0x63, 0x6b, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12,
	0x61, 0x63, 0x6b, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x12, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x07, 0x61, 0x63, 0x6b,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x73, 0x22, 0x8b, 0x04, 0x0a, 0x14, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4e, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1c, 0x0a, 0x07, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x73, 0x12, 0x3b,
	0x0a, 0x17, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x44, 0x65, 0x61, 0x64,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x3a, 0x0a, 0x17, 0x6d,
	0x6f, 0x64, 0x69, 0x66, 0x79, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x61,
	0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x14, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e,
	0x65, 0x41, 0x63, 0x6b, 0x49, 0x64, 0x73, 0x12, 0x42, 0x0a, 0x1b, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x18, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x61, 0x64,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x3d, 0x0a,
	0x18, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x6d, 0x61, 0x78, 0x4f, 0x75, 0x74, 0x73, 0x74, 0x61, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x15,
	0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x13, 0x6d, 0x61, 0x78, 0x4f, 0x75, 0x74, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x08, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x53, 0x0a, 0x11, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x12, 0x7f, 0x0a, 0x18, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x61, 0x63,
	0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x93, 0x01, 0x0a, 0x20, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x6c,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	0x41, 0x63, 0x6b, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x6d, 0x6f,
	0x64, 0x69, 0x66, 0x79, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7c, 0x0a, 0x17, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x16, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0xd3, 0x01, 0x0a, 0x17, 0x41, 0x63,
	0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x07, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x6b,
	0x49, 0x64, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x61,
	0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0d, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x41, 0x63, 0x6b, 0x49, 0x64, 0x73,
	0x12, 0x2f, 0x0a, 0x11, 0x75, 0x6e, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x63,
	0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x75, 0x6e, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x41, 0x63, 0x6b, 0x49, 0x64,
	0x73, 0x12, 0x3c, 0x0a, 0x18, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72,
	0x61, 0x72, 0x79, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x63, 0x6b, 0x49, 0x64, 0x73, 0x1a,
	0xa8, 0x01, 0x0a, 0x1d, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x61,
	0x64, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1c, 0x0a, 0x07, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x73, 0x12,
	0x2b, 0x0a, 0x0f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x69,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x41, 0x63, 0x6b, 0x49, 0x64, 0x73, 0x12, 0x3c, 0x0a, 0x18,
	0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x15, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x46, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x41, 0x63, 0x6b, 0x49, 0x64, 0x73, 0x1a, 0x9f, 0x01, 0x0a, 0x16, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x1d, 0x65, 0x78, 0x61, 0x63, 0x74, 0x6c, 0x79,
	0x5f, 0x6f, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x1a, 0x65, 0x78, 0x61, 0x63, 0x74, 0x6c, 0x79, 0x4f, 0x6e, 0x63, 0x65, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3d, 0x0a,
	0x18, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xbb, 0x03, 0x0a,
	0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x50, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x61, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x09, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x96, 0x01, 0x0a, 0x15, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x83, 0x03, 0x0a, 0x08, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x1d,
	0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x05, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x61, 0xea, 0x41, 0x5e, 0x0a, 0x1e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x27, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x7d, 0x2a, 0x09, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x32,
	0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x58, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x22, 0xab, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x83, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x09, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5b, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x22, 0xe4, 0x01, 0x0a, 0x0b, 0x53, 0x65, 0x65, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x48, 0x00, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x0e, 0x0a, 0x0c, 0x53,
	0x65, 0x65, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xb8, 0x0b, 0x0a, 0x09,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12, 0x71, 0x0a, 0x0b, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x1a, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x30, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x3a, 0x01, 0x2a, 0x1a, 0x1e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x91, 0x01, 0x0a,
	0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x43, 0xda, 0x41, 0x11,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x3a, 0x01, 0x2a, 0x32, 0x24, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x93, 0x01, 0x0a, 0x07, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x12, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x43, 0xda, 0x41, 0x0e, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x2c, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01, 0x2a, 0x22, 0x27, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x12, 0x77, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x12, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x2f,
	0xda, 0x41, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x21, 0x12, 0x1f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x8a, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x12, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x31, 0xda, 0x41, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x21, 0x12, 0x1f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x12, 0xba, 0x01, 0x0a,
	0x16, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x05, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xaa, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73,
	0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0xda, 0x41, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0x7c, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x2f, 0xda, 0x41, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x21, 0x2a, 0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xad, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x74, 0x61, 0x63, 0x68, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x74, 0x61, 0x63, 0x68, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x61,
	0x63, 0x68, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x34,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65,
	0x74, 0x61, 0x63, 0x68, 0x1a, 0x70, 0xca, 0x41, 0x15, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x55, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x32, 0xd2, 0x15, 0x0a, 0x0a, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x72, 0x12, 0xb4, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5e, 0xda, 0x41,
	0x2b, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x2c, 0x70, 0x75, 0x73, 0x68,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x61, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x61, 0x64,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2a, 0x3a, 0x01, 0x2a, 0x1a, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa1, 0x01, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0xda, 0x41, 0x0c, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xbb, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x58, 0xda, 0x41, 0x18, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa6,
	0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x38, 0xda,
	0x41, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x12,
	0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x44, 0xda, 0x41, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcf, 0x01, 0x0a, 0x11, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x79, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x12,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x61, 0x64,
	0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x76, 0xda, 0x41, 0x29, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x2c, 0x61, 0x63, 0x6b,
	0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	0x41, 0x63, 0x6b, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0xa8, 0x01, 0x0a, 0x0b,
	0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x12, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5b, 0xda, 0x41, 0x14, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x61, 0x63, 0x6b, 0x5f, 0x69,
	0x64, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x12, 0xd0, 0x01, 0x0a, 0x04, 0x50, 0x75, 0x6c, 0x6c, 0x12,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x88,
	0x01, 0xda, 0x41, 0x2c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x2c, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x65, 0x6c, 0x79, 0x2c, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0xda, 0x41, 0x19, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x75, 0x6c, 0x6c, 0x12, 0x66, 0x0a, 0x0d, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x6c, 0x6c, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50,
	0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30,
	0x01, 0x12, 0xbb, 0x01, 0x0a, 0x10, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x50, 0x75, 0x73, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x64, 0xda, 0x41, 0x18, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x70, 0x75, 0x73, 0x68, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x01, 0x2a, 0x22,
	0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d,
	0x6f, 0x64, 0x69, 0x66, 0x79, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x89, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x22, 0x38, 0xda, 0x41, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x96, 0x01, 0x0a, 0x0d,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34,
	0xda, 0x41, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24,
	0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x73, 0x12, 0x97, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x40, 0xda, 0x41,
	0x11, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x3a, 0x01, 0x2a, 0x1a, 0x21, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa3,
	0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x4c, 0xda, 0x41, 0x14, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x01, 0x2a, 0x32, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8b, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x38, 0xda, 0x41, 0x08, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x2a, 0x25, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x84, 0x01, 0x0a, 0x04, 0x53, 0x65, 0x65, 0x6b, 0x12, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x65, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x65, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x65, 0x6b, 0x1a, 0x70, 0xca, 0x41, 0x15, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x55, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x42, 0xa7, 0x03, 0xea, 0x41,
	0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65,
	0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67,
	0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0xea, 0x41, 0x7f, 0x0a, 0x23, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x7d, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x7b, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x7d, 0x0a, 0x14, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x42, 0x0b, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2f, 0x76, 0x32, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x70, 0x62, 0x3b, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x75, 0x62, 0x53, 0x75,
	0x62, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_pubsub_v1_pubsub_proto_rawDescOnce sync.Once
	file_google_pubsub_v1_pubsub_proto_rawDescData = file_google_pubsub_v1_pubsub_proto_rawDesc
)

func file_google_pubsub_v1_pubsub_proto_rawDescGZIP() []byte {
	file_google_pubsub_v1_pubsub_proto_rawDescOnce.Do(func() {
		file_google_pubsub_v1_pubsub_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_pubsub_v1_pubsub_proto_rawDescData)
	})
	return file_google_pubsub_v1_pubsub_proto_rawDescData
}

var file_google_pubsub_v1_pubsub_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_google_pubsub_v1_pubsub_proto_msgTypes = make([]protoimpl.MessageInfo, 86)
var file_google_pubsub_v1_pubsub_proto_goTypes = []any{
	(IngestionDataSourceSettings_AwsKinesis_State)(0),                 // 0: google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State
	(IngestionDataSourceSettings_CloudStorage_State)(0),               // 1: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State
	(IngestionDataSourceSettings_AzureEventHubs_State)(0),             // 2: google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State
	(IngestionDataSourceSettings_AwsMsk_State)(0),                     // 3: google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State
	(IngestionDataSourceSettings_ConfluentCloud_State)(0),             // 4: google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State
	(PlatformLogsSettings_Severity)(0),                                // 5: google.pubsub.v1.PlatformLogsSettings.Severity
	(Topic_State)(0),                                                  // 6: google.pubsub.v1.Topic.State
	(Subscription_State)(0),                                           // 7: google.pubsub.v1.Subscription.State
	(BigQueryConfig_State)(0),                                         // 8: google.pubsub.v1.BigQueryConfig.State
	(CloudStorageConfig_State)(0),                                     // 9: google.pubsub.v1.CloudStorageConfig.State
	(*MessageStoragePolicy)(nil),                                      // 10: google.pubsub.v1.MessageStoragePolicy
	(*SchemaSettings)(nil),                                            // 11: google.pubsub.v1.SchemaSettings
	(*IngestionDataSourceSettings)(nil),                               // 12: google.pubsub.v1.IngestionDataSourceSettings
	(*PlatformLogsSettings)(nil),                                      // 13: google.pubsub.v1.PlatformLogsSettings
	(*IngestionFailureEvent)(nil),                                     // 14: google.pubsub.v1.IngestionFailureEvent
	(*JavaScriptUDF)(nil),                                             // 15: google.pubsub.v1.JavaScriptUDF
	(*MessageTransform)(nil),                                          // 16: google.pubsub.v1.MessageTransform
	(*Topic)(nil),                                                     // 17: google.pubsub.v1.Topic
	(*PubsubMessage)(nil),                                             // 18: google.pubsub.v1.PubsubMessage
	(*GetTopicRequest)(nil),                                           // 19: google.pubsub.v1.GetTopicRequest
	(*UpdateTopicRequest)(nil),                                        // 20: google.pubsub.v1.UpdateTopicRequest
	(*PublishRequest)(nil),                                            // 21: google.pubsub.v1.PublishRequest
	(*PublishResponse)(nil),                                           // 22: google.pubsub.v1.PublishResponse
	(*ListTopicsRequest)(nil),                                         // 23: google.pubsub.v1.ListTopicsRequest
	(*ListTopicsResponse)(nil),                                        // 24: google.pubsub.v1.ListTopicsResponse
	(*ListTopicSubscriptionsRequest)(nil),                             // 25: google.pubsub.v1.ListTopicSubscriptionsRequest
	(*ListTopicSubscriptionsResponse)(nil),                            // 26: google.pubsub.v1.ListTopicSubscriptionsResponse
	(*ListTopicSnapshotsRequest)(nil),                                 // 27: google.pubsub.v1.ListTopicSnapshotsRequest
	(*ListTopicSnapshotsResponse)(nil),                                // 28: google.pubsub.v1.ListTopicSnapshotsResponse
	(*DeleteTopicRequest)(nil),                                        // 29: google.pubsub.v1.DeleteTopicRequest
	(*DetachSubscriptionRequest)(nil),                                 // 30: google.pubsub.v1.DetachSubscriptionRequest
	(*DetachSubscriptionResponse)(nil),                                // 31: google.pubsub.v1.DetachSubscriptionResponse
	(*Subscription)(nil),                                              // 32: google.pubsub.v1.Subscription
	(*RetryPolicy)(nil),                                               // 33: google.pubsub.v1.RetryPolicy
	(*DeadLetterPolicy)(nil),                                          // 34: google.pubsub.v1.DeadLetterPolicy
	(*ExpirationPolicy)(nil),                                          // 35: google.pubsub.v1.ExpirationPolicy
	(*PushConfig)(nil),                                                // 36: google.pubsub.v1.PushConfig
	(*BigQueryConfig)(nil),                                            // 37: google.pubsub.v1.BigQueryConfig
	(*CloudStorageConfig)(nil),                                        // 38: google.pubsub.v1.CloudStorageConfig
	(*ReceivedMessage)(nil),                                           // 39: google.pubsub.v1.ReceivedMessage
	(*GetSubscriptionRequest)(nil),                                    // 40: google.pubsub.v1.GetSubscriptionRequest
	(*UpdateSubscriptionRequest)(nil),                                 // 41: google.pubsub.v1.UpdateSubscriptionRequest
	(*ListSubscriptionsRequest)(nil),                                  // 42: google.pubsub.v1.ListSubscriptionsRequest
	(*ListSubscriptionsResponse)(nil),                                 // 43: google.pubsub.v1.ListSubscriptionsResponse
	(*DeleteSubscriptionRequest)(nil),                                 // 44: google.pubsub.v1.DeleteSubscriptionRequest
	(*ModifyPushConfigRequest)(nil),                                   // 45: google.pubsub.v1.ModifyPushConfigRequest
	(*PullRequest)(nil),                                               // 46: google.pubsub.v1.PullRequest
	(*PullResponse)(nil),                                              // 47: google.pubsub.v1.PullResponse
	(*ModifyAckDeadlineRequest)(nil),                                  // 48: google.pubsub.v1.ModifyAckDeadlineRequest
	(*AcknowledgeRequest)(nil),                                        // 49: google.pubsub.v1.AcknowledgeRequest
	(*StreamingPullRequest)(nil),                                      // 50: google.pubsub.v1.StreamingPullRequest
	(*StreamingPullResponse)(nil),                                     // 51: google.pubsub.v1.StreamingPullResponse
	(*CreateSnapshotRequest)(nil),                                     // 52: google.pubsub.v1.CreateSnapshotRequest
	(*UpdateSnapshotRequest)(nil),                                     // 53: google.pubsub.v1.UpdateSnapshotRequest
	(*Snapshot)(nil),                                                  // 54: google.pubsub.v1.Snapshot
	(*GetSnapshotRequest)(nil),                                        // 55: google.pubsub.v1.GetSnapshotRequest
	(*ListSnapshotsRequest)(nil),                                      // 56: google.pubsub.v1.ListSnapshotsRequest
	(*ListSnapshotsResponse)(nil),                                     // 57: google.pubsub.v1.ListSnapshotsResponse
	(*DeleteSnapshotRequest)(nil),                                     // 58: google.pubsub.v1.DeleteSnapshotRequest
	(*SeekRequest)(nil),                                               // 59: google.pubsub.v1.SeekRequest
	(*SeekResponse)(nil),                                              // 60: google.pubsub.v1.SeekResponse
	(*IngestionDataSourceSettings_AwsKinesis)(nil),                    // 61: google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
	(*IngestionDataSourceSettings_CloudStorage)(nil),                  // 62: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
	(*IngestionDataSourceSettings_AzureEventHubs)(nil),                // 63: google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
	(*IngestionDataSourceSettings_AwsMsk)(nil),                        // 64: google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
	(*IngestionDataSourceSettings_ConfluentCloud)(nil),                // 65: google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
	(*IngestionDataSourceSettings_CloudStorage_TextFormat)(nil),       // 66: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
	(*IngestionDataSourceSettings_CloudStorage_AvroFormat)(nil),       // 67: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
	(*IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat)(nil), // 68: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
	(*IngestionFailureEvent_ApiViolationReason)(nil),                  // 69: google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
	(*IngestionFailureEvent_AvroFailureReason)(nil),                   // 70: google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
	(*IngestionFailureEvent_SchemaViolationReason)(nil),               // 71: google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
	(*IngestionFailureEvent_MessageTransformationFailureReason)(nil),  // 72: google.pubsub.v1.IngestionFailureEvent.MessageTransformationFailureReason
	(*IngestionFailureEvent_CloudStorageFailure)(nil),                 // 73: google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
	(*IngestionFailureEvent_AwsMskFailureReason)(nil),                 // 74: google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
	(*IngestionFailureEvent_AzureEventHubsFailureReason)(nil),         // 75: google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
	(*IngestionFailureEvent_ConfluentCloudFailureReason)(nil),         // 76: google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
	(*IngestionFailureEvent_AwsKinesisFailureReason)(nil),             // 77: google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
	nil, // 78: google.pubsub.v1.Topic.LabelsEntry
	nil, // 79: google.pubsub.v1.Topic.TagsEntry
	nil, // 80: google.pubsub.v1.PubsubMessage.AttributesEntry
	(*Subscription_AnalyticsHubSubscriptionInfo)(nil), // 81: google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
	nil,                                   // 82: google.pubsub.v1.Subscription.LabelsEntry
	nil,                                   // 83: google.pubsub.v1.Subscription.TagsEntry
	(*PushConfig_OidcToken)(nil),          // 84: google.pubsub.v1.PushConfig.OidcToken
	(*PushConfig_PubsubWrapper)(nil),      // 85: google.pubsub.v1.PushConfig.PubsubWrapper
	(*PushConfig_NoWrapper)(nil),          // 86: google.pubsub.v1.PushConfig.NoWrapper
	nil,                                   // 87: google.pubsub.v1.PushConfig.AttributesEntry
	(*CloudStorageConfig_TextConfig)(nil), // 88: google.pubsub.v1.CloudStorageConfig.TextConfig
	(*CloudStorageConfig_AvroConfig)(nil), // 89: google.pubsub.v1.CloudStorageConfig.AvroConfig
	(*StreamingPullResponse_AcknowledgeConfirmation)(nil),       // 90: google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
	(*StreamingPullResponse_ModifyAckDeadlineConfirmation)(nil), // 91: google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
	(*StreamingPullResponse_SubscriptionProperties)(nil),        // 92: google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
	nil,                           // 93: google.pubsub.v1.CreateSnapshotRequest.LabelsEntry
	nil,                           // 94: google.pubsub.v1.CreateSnapshotRequest.TagsEntry
	nil,                           // 95: google.pubsub.v1.Snapshot.LabelsEntry
	(Encoding)(0),                 // 96: google.pubsub.v1.Encoding
	(*durationpb.Duration)(nil),   // 97: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil), // 98: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil), // 99: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),         // 100: google.protobuf.Empty
}
var file_google_pubsub_v1_pubsub_proto_depIdxs = []int32{
	96,  // 0: google.pubsub.v1.SchemaSettings.encoding:type_name -> google.pubsub.v1.Encoding
	61,  // 1: google.pubsub.v1.IngestionDataSourceSettings.aws_kinesis:type_name -> google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
	62,  // 2: google.pubsub.v1.IngestionDataSourceSettings.cloud_storage:type_name -> google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
	63,  // 3: google.pubsub.v1.IngestionDataSourceSettings.azure_event_hubs:type_name -> google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
	64,  // 4: google.pubsub.v1.IngestionDataSourceSettings.aws_msk:type_name -> google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
	65,  // 5: google.pubsub.v1.IngestionDataSourceSettings.confluent_cloud:type_name -> google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
	13,  // 6: google.pubsub.v1.IngestionDataSourceSettings.platform_logs_settings:type_name -> google.pubsub.v1.PlatformLogsSettings
	5,   // 7: google.pubsub.v1.PlatformLogsSettings.severity:type_name -> google.pubsub.v1.PlatformLogsSettings.Severity
	73,  // 8: google.pubsub.v1.IngestionFailureEvent.cloud_storage_failure:type_name -> google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
	74,  // 9: google.pubsub.v1.IngestionFailureEvent.aws_msk_failure:type_name -> google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
	75,  // 10: google.pubsub.v1.IngestionFailureEvent.azure_event_hubs_failure:type_name -> google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
	76,  // 11: google.pubsub.v1.IngestionFailureEvent.confluent_cloud_failure:type_name -> google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
	77,  // 12: google.pubsub.v1.IngestionFailureEvent.aws_kinesis_failure:type_name -> google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
	15,  // 13: google.pubsub.v1.MessageTransform.javascript_udf:type_name -> google.pubsub.v1.JavaScriptUDF
	78,  // 14: google.pubsub.v1.Topic.labels:type_name -> google.pubsub.v1.Topic.LabelsEntry
	10,  // 15: google.pubsub.v1.Topic.message_storage_policy:type_name -> google.pubsub.v1.MessageStoragePolicy
	11,  // 16: google.pubsub.v1.Topic.schema_settings:type_name -> google.pubsub.v1.SchemaSettings
	97,  // 17: google.pubsub.v1.Topic.message_retention_duration:type_name -> google.protobuf.Duration
	6,   // 18: google.pubsub.v1.Topic.state:type_name -> google.pubsub.v1.Topic.State
	12,  // 19: google.pubsub.v1.Topic.ingestion_data_source_settings:type_name -> google.pubsub.v1.IngestionDataSourceSettings
	16,  // 20: google.pubsub.v1.Topic.message_transforms:type_name -> google.pubsub.v1.MessageTransform
	79,  // 21: google.pubsub.v1.Topic.tags:type_name -> google.pubsub.v1.Topic.TagsEntry
	80,  // 22: google.pubsub.v1.PubsubMessage.attributes:type_name -> google.pubsub.v1.PubsubMessage.AttributesEntry
	98,  // 23: google.pubsub.v1.PubsubMessage.publish_time:type_name -> google.protobuf.Timestamp
	17,  // 24: google.pubsub.v1.UpdateTopicRequest.topic:type_name -> google.pubsub.v1.Topic
	99,  // 25: google.pubsub.v1.UpdateTopicRequest.update_mask:type_name -> google.protobuf.FieldMask
	18,  // 26: google.pubsub.v1.PublishRequest.messages:type_name -> google.pubsub.v1.PubsubMessage
	17,  // 27: google.pubsub.v1.ListTopicsResponse.topics:type_name -> google.pubsub.v1.Topic
	36,  // 28: google.pubsub.v1.Subscription.push_config:type_name -> google.pubsub.v1.PushConfig
	37,  // 29: google.pubsub.v1.Subscription.bigquery_config:type_name -> google.pubsub.v1.BigQueryConfig
	38,  // 30: google.pubsub.v1.Subscription.cloud_storage_config:type_name -> google.pubsub.v1.CloudStorageConfig
	97,  // 31: google.pubsub.v1.Subscription.message_retention_duration:type_name -> google.protobuf.Duration
	82,  // 32: google.pubsub.v1.Subscription.labels:type_name -> google.pubsub.v1.Subscription.LabelsEntry
	35,  // 33: google.pubsub.v1.Subscription.expiration_policy:type_name -> google.pubsub.v1.ExpirationPolicy
	34,  // 34: google.pubsub.v1.Subscription.dead_letter_policy:type_name -> google.pubsub.v1.DeadLetterPolicy
	33,  // 35: google.pubsub.v1.Subscription.retry_policy:type_name -> google.pubsub.v1.RetryPolicy
	97,  // 36: google.pubsub.v1.Subscription.topic_message_retention_duration:type_name -> google.protobuf.Duration
	7,   // 37: google.pubsub.v1.Subscription.state:type_name -> google.pubsub.v1.Subscription.State
	81,  // 38: google.pubsub.v1.Subscription.analytics_hub_subscription_info:type_name -> google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
	16,  // 39: google.pubsub.v1.Subscription.message_transforms:type_name -> google.pubsub.v1.MessageTransform
	83,  // 40: google.pubsub.v1.Subscription.tags:type_name -> google.pubsub.v1.Subscription.TagsEntry
	97,  // 41: google.pubsub.v1.RetryPolicy.minimum_backoff:type_name -> google.protobuf.Duration
	97,  // 42: google.pubsub.v1.RetryPolicy.maximum_backoff:type_name -> google.protobuf.Duration
	97,  // 43: google.pubsub.v1.ExpirationPolicy.ttl:type_name -> google.protobuf.Duration
	87,  // 44: google.pubsub.v1.PushConfig.attributes:type_name -> google.pubsub.v1.PushConfig.AttributesEntry
	84,  // 45: google.pubsub.v1.PushConfig.oidc_token:type_name -> google.pubsub.v1.PushConfig.OidcToken
	85,  // 46: google.pubsub.v1.PushConfig.pubsub_wrapper:type_name -> google.pubsub.v1.PushConfig.PubsubWrapper
	86,  // 47: google.pubsub.v1.PushConfig.no_wrapper:type_name -> google.pubsub.v1.PushConfig.NoWrapper
	8,   // 48: google.pubsub.v1.BigQueryConfig.state:type_name -> google.pubsub.v1.BigQueryConfig.State
	88,  // 49: google.pubsub.v1.CloudStorageConfig.text_config:type_name -> google.pubsub.v1.CloudStorageConfig.TextConfig
	89,  // 50: google.pubsub.v1.CloudStorageConfig.avro_config:type_name -> google.pubsub.v1.CloudStorageConfig.AvroConfig
	97,  // 51: google.pubsub.v1.CloudStorageConfig.max_duration:type_name -> google.protobuf.Duration
	9,   // 52: google.pubsub.v1.CloudStorageConfig.state:type_name -> google.pubsub.v1.CloudStorageConfig.State
	18,  // 53: google.pubsub.v1.ReceivedMessage.message:type_name -> google.pubsub.v1.PubsubMessage
	32,  // 54: google.pubsub.v1.UpdateSubscriptionRequest.subscription:type_name -> google.pubsub.v1.Subscription
	99,  // 55: google.pubsub.v1.UpdateSubscriptionRequest.update_mask:type_name -> google.protobuf.FieldMask
	32,  // 56: google.pubsub.v1.ListSubscriptionsResponse.subscriptions:type_name -> google.pubsub.v1.Subscription
	36,  // 57: google.pubsub.v1.ModifyPushConfigRequest.push_config:type_name -> google.pubsub.v1.PushConfig
	39,  // 58: google.pubsub.v1.PullResponse.received_messages:type_name -> google.pubsub.v1.ReceivedMessage
	39,  // 59: google.pubsub.v1.StreamingPullResponse.received_messages:type_name -> google.pubsub.v1.ReceivedMessage
	90,  // 60: google.pubsub.v1.StreamingPullResponse.acknowledge_confirmation:type_name -> google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
	91,  // 61: google.pubsub.v1.StreamingPullResponse.modify_ack_deadline_confirmation:type_name -> google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
	92,  // 62: google.pubsub.v1.StreamingPullResponse.subscription_properties:type_name -> google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
	93,  // 63: google.pubsub.v1.CreateSnapshotRequest.labels:type_name -> google.pubsub.v1.CreateSnapshotRequest.LabelsEntry
	94,  // 64: google.pubsub.v1.CreateSnapshotRequest.tags:type_name -> google.pubsub.v1.CreateSnapshotRequest.TagsEntry
	54,  // 65: google.pubsub.v1.UpdateSnapshotRequest.snapshot:type_name -> google.pubsub.v1.Snapshot
	99,  // 66: google.pubsub.v1.UpdateSnapshotRequest.update_mask:type_name -> google.protobuf.FieldMask
	98,  // 67: google.pubsub.v1.Snapshot.expire_time:type_name -> google.protobuf.Timestamp
	95,  // 68: google.pubsub.v1.Snapshot.labels:type_name -> google.pubsub.v1.Snapshot.LabelsEntry
	54,  // 69: google.pubsub.v1.ListSnapshotsResponse.snapshots:type_name -> google.pubsub.v1.Snapshot
	98,  // 70: google.pubsub.v1.SeekRequest.time:type_name -> google.protobuf.Timestamp
	0,   // 71: google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.state:type_name -> google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State
	1,   // 72: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.state:type_name -> google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State
	66,  // 73: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.text_format:type_name -> google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
	67,  // 74: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.avro_format:type_name -> google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
	68,  // 75: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.pubsub_avro_format:type_name -> google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
	98,  // 76: google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.minimum_object_create_time:type_name -> google.protobuf.Timestamp
	2,   // 77: google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.state:type_name -> google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State
	3,   // 78: google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.state:type_name -> google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State
	4,   // 79: google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.state:type_name -> google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State
	70,  // 80: google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.avro_failure_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
	69,  // 81: google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.api_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
	71,  // 82: google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.schema_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
	72,  // 83: google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.message_transformation_failure_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.MessageTransformationFailureReason
	69,  // 84: google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.api_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
	71,  // 85: google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.schema_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
	72,  // 86: google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.message_transformation_failure_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.MessageTransformationFailureReason
	69,  // 87: google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.api_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
	71,  // 88: google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.schema_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
	72,  // 89: google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.message_transformation_failure_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.MessageTransformationFailureReason
	69,  // 90: google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.api_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
	71,  // 91: google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.schema_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
	72,  // 92: google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.message_transformation_failure_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.MessageTransformationFailureReason
	71,  // 93: google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.schema_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
	72,  // 94: google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.message_transformation_failure_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.MessageTransformationFailureReason
	69,  // 95: google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.api_violation_reason:type_name -> google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
	17,  // 96: google.pubsub.v1.Publisher.CreateTopic:input_type -> google.pubsub.v1.Topic
	20,  // 97: google.pubsub.v1.Publisher.UpdateTopic:input_type -> google.pubsub.v1.UpdateTopicRequest
	21,  // 98: google.pubsub.v1.Publisher.Publish:input_type -> google.pubsub.v1.PublishRequest
	19,  // 99: google.pubsub.v1.Publisher.GetTopic:input_type -> google.pubsub.v1.GetTopicRequest
	23,  // 100: google.pubsub.v1.Publisher.ListTopics:input_type -> google.pubsub.v1.ListTopicsRequest
	25,  // 101: google.pubsub.v1.Publisher.ListTopicSubscriptions:input_type -> google.pubsub.v1.ListTopicSubscriptionsRequest
	27,  // 102: google.pubsub.v1.Publisher.ListTopicSnapshots:input_type -> google.pubsub.v1.ListTopicSnapshotsRequest
	29,  // 103: google.pubsub.v1.Publisher.DeleteTopic:input_type -> google.pubsub.v1.DeleteTopicRequest
	30,  // 104: google.pubsub.v1.Publisher.DetachSubscription:input_type -> google.pubsub.v1.DetachSubscriptionRequest
	32,  // 105: google.pubsub.v1.Subscriber.CreateSubscription:input_type -> google.pubsub.v1.Subscription
	40,  // 106: google.pubsub.v1.Subscriber.GetSubscription:input_type -> google.pubsub.v1.GetSubscriptionRequest
	41,  // 107: google.pubsub.v1.Subscriber.UpdateSubscription:input_type -> google.pubsub.v1.UpdateSubscriptionRequest
	42,  // 108: google.pubsub.v1.Subscriber.ListSubscriptions:input_type -> google.pubsub.v1.ListSubscriptionsRequest
	44,  // 109: google.pubsub.v1.Subscriber.DeleteSubscription:input_type -> google.pubsub.v1.DeleteSubscriptionRequest
	48,  // 110: google.pubsub.v1.Subscriber.ModifyAckDeadline:input_type -> google.pubsub.v1.ModifyAckDeadlineRequest
	49,  // 111: google.pubsub.v1.Subscriber.Acknowledge:input_type -> google.pubsub.v1.AcknowledgeRequest
	46,  // 112: google.pubsub.v1.Subscriber.Pull:input_type -> google.pubsub.v1.PullRequest
	50,  // 113: google.pubsub.v1.Subscriber.StreamingPull:input_type -> google.pubsub.v1.StreamingPullRequest
	45,  // 114: google.pubsub.v1.Subscriber.ModifyPushConfig:input_type -> google.pubsub.v1.ModifyPushConfigRequest
	55,  // 115: google.pubsub.v1.Subscriber.GetSnapshot:input_type -> google.pubsub.v1.GetSnapshotRequest
	56,  // 116: google.pubsub.v1.Subscriber.ListSnapshots:input_type -> google.pubsub.v1.ListSnapshotsRequest
	52,  // 117: google.pubsub.v1.Subscriber.CreateSnapshot:input_type -> google.pubsub.v1.CreateSnapshotRequest
	53,  // 118: google.pubsub.v1.Subscriber.UpdateSnapshot:input_type -> google.pubsub.v1.UpdateSnapshotRequest
	58,  // 119: google.pubsub.v1.Subscriber.DeleteSnapshot:input_type -> google.pubsub.v1.DeleteSnapshotRequest
	59,  // 120: google.pubsub.v1.Subscriber.Seek:input_type -> google.pubsub.v1.SeekRequest
	17,  // 121: google.pubsub.v1.Publisher.CreateTopic:output_type -> google.pubsub.v1.Topic
	17,  // 122: google.pubsub.v1.Publisher.UpdateTopic:output_type -> google.pubsub.v1.Topic
	22,  // 123: google.pubsub.v1.Publisher.Publish:output_type -> google.pubsub.v1.PublishResponse
	17,  // 124: google.pubsub.v1.Publisher.GetTopic:output_type -> google.pubsub.v1.Topic
	24,  // 125: google.pubsub.v1.Publisher.ListTopics:output_type -> google.pubsub.v1.ListTopicsResponse
	26,  // 126: google.pubsub.v1.Publisher.ListTopicSubscriptions:output_type -> google.pubsub.v1.ListTopicSubscriptionsResponse
	28,  // 127: google.pubsub.v1.Publisher.ListTopicSnapshots:output_type -> google.pubsub.v1.ListTopicSnapshotsResponse
	100, // 128: google.pubsub.v1.Publisher.DeleteTopic:output_type -> google.protobuf.Empty
	31,  // 129: google.pubsub.v1.Publisher.DetachSubscription:output_type -> google.pubsub.v1.DetachSubscriptionResponse
	32,  // 130: google.pubsub.v1.Subscriber.CreateSubscription:output_type -> google.pubsub.v1.Subscription
	32,  // 131: google.pubsub.v1.Subscriber.GetSubscription:output_type -> google.pubsub.v1.Subscription
	32,  // 132: google.pubsub.v1.Subscriber.UpdateSubscription:output_type -> google.pubsub.v1.Subscription
	43,  // 133: google.pubsub.v1.Subscriber.ListSubscriptions:output_type -> google.pubsub.v1.ListSubscriptionsResponse
	100, // 134: google.pubsub.v1.Subscriber.DeleteSubscription:output_type -> google.protobuf.Empty
	100, // 135: google.pubsub.v1.Subscriber.ModifyAckDeadline:output_type -> google.protobuf.Empty
	100, // 136: google.pubsub.v1.Subscriber.Acknowledge:output_type -> google.protobuf.Empty
	47,  // 137: google.pubsub.v1.Subscriber.Pull:output_type -> google.pubsub.v1.PullResponse
	51,  // 138: google.pubsub.v1.Subscriber.StreamingPull:output_type -> google.pubsub.v1.StreamingPullResponse
	100, // 139: google.pubsub.v1.Subscriber.ModifyPushConfig:output_type -> google.protobuf.Empty
	54,  // 140: google.pubsub.v1.Subscriber.GetSnapshot:output_type -> google.pubsub.v1.Snapshot
	57,  // 141: google.pubsub.v1.Subscriber.ListSnapshots:output_type -> google.pubsub.v1.ListSnapshotsResponse
	54,  // 142: google.pubsub.v1.Subscriber.CreateSnapshot:output_type -> google.pubsub.v1.Snapshot
	54,  // 143: google.pubsub.v1.Subscriber.UpdateSnapshot:output_type -> google.pubsub.v1.Snapshot
	100, // 144: google.pubsub.v1.Subscriber.DeleteSnapshot:output_type -> google.protobuf.Empty
	60,  // 145: google.pubsub.v1.Subscriber.Seek:output_type -> google.pubsub.v1.SeekResponse
	121, // [121:146] is the sub-list for method output_type
	96,  // [96:121] is the sub-list for method input_type
	96,  // [96:96] is the sub-list for extension type_name
	96,  // [96:96] is the sub-list for extension extendee
	0,   // [0:96] is the sub-list for field type_name
}

func init() { file_google_pubsub_v1_pubsub_proto_init() }
func file_google_pubsub_v1_pubsub_proto_init() {
	if File_google_pubsub_v1_pubsub_proto != nil {
		return
	}
	file_google_pubsub_v1_schema_proto_init()
	file_google_pubsub_v1_pubsub_proto_msgTypes[2].OneofWrappers = []any{
		(*IngestionDataSourceSettings_AwsKinesis_)(nil),
		(*IngestionDataSourceSettings_CloudStorage_)(nil),
		(*IngestionDataSourceSettings_AzureEventHubs_)(nil),
		(*IngestionDataSourceSettings_AwsMsk_)(nil),
		(*IngestionDataSourceSettings_ConfluentCloud_)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[4].OneofWrappers = []any{
		(*IngestionFailureEvent_CloudStorageFailure_)(nil),
		(*IngestionFailureEvent_AwsMskFailure)(nil),
		(*IngestionFailureEvent_AzureEventHubsFailure)(nil),
		(*IngestionFailureEvent_ConfluentCloudFailure)(nil),
		(*IngestionFailureEvent_AwsKinesisFailure)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[6].OneofWrappers = []any{
		(*MessageTransform_JavascriptUdf)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[26].OneofWrappers = []any{
		(*PushConfig_OidcToken_)(nil),
		(*PushConfig_PubsubWrapper_)(nil),
		(*PushConfig_NoWrapper_)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[28].OneofWrappers = []any{
		(*CloudStorageConfig_TextConfig_)(nil),
		(*CloudStorageConfig_AvroConfig_)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[49].OneofWrappers = []any{
		(*SeekRequest_Time)(nil),
		(*SeekRequest_Snapshot)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[52].OneofWrappers = []any{
		(*IngestionDataSourceSettings_CloudStorage_TextFormat_)(nil),
		(*IngestionDataSourceSettings_CloudStorage_AvroFormat_)(nil),
		(*IngestionDataSourceSettings_CloudStorage_PubsubAvroFormat)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[56].OneofWrappers = []any{}
	file_google_pubsub_v1_pubsub_proto_msgTypes[63].OneofWrappers = []any{
		(*IngestionFailureEvent_CloudStorageFailure_AvroFailureReason)(nil),
		(*IngestionFailureEvent_CloudStorageFailure_ApiViolationReason)(nil),
		(*IngestionFailureEvent_CloudStorageFailure_SchemaViolationReason)(nil),
		(*IngestionFailureEvent_CloudStorageFailure_MessageTransformationFailureReason)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[64].OneofWrappers = []any{
		(*IngestionFailureEvent_AwsMskFailureReason_ApiViolationReason)(nil),
		(*IngestionFailureEvent_AwsMskFailureReason_SchemaViolationReason)(nil),
		(*IngestionFailureEvent_AwsMskFailureReason_MessageTransformationFailureReason)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[65].OneofWrappers = []any{
		(*IngestionFailureEvent_AzureEventHubsFailureReason_ApiViolationReason)(nil),
		(*IngestionFailureEvent_AzureEventHubsFailureReason_SchemaViolationReason)(nil),
		(*IngestionFailureEvent_AzureEventHubsFailureReason_MessageTransformationFailureReason)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[66].OneofWrappers = []any{
		(*IngestionFailureEvent_ConfluentCloudFailureReason_ApiViolationReason)(nil),
		(*IngestionFailureEvent_ConfluentCloudFailureReason_SchemaViolationReason)(nil),
		(*IngestionFailureEvent_ConfluentCloudFailureReason_MessageTransformationFailureReason)(nil),
	}
	file_google_pubsub_v1_pubsub_proto_msgTypes[67].OneofWrappers = []any{
		(*IngestionFailureEvent_AwsKinesisFailureReason_SchemaViolationReason)(nil),
		(*IngestionFailureEvent_AwsKinesisFailureReason_MessageTransformationFailureReason)(nil),
		(*IngestionFailureEvent_AwsKinesisFailureReason_ApiViolationReason)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_pubsub_v1_pubsub_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   86,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_pubsub_v1_pubsub_proto_goTypes,
		DependencyIndexes: file_google_pubsub_v1_pubsub_proto_depIdxs,
		EnumInfos:         file_google_pubsub_v1_pubsub_proto_enumTypes,
		MessageInfos:      file_google_pubsub_v1_pubsub_proto_msgTypes,
	}.Build()
	File_google_pubsub_v1_pubsub_proto = out.File
	file_google_pubsub_v1_pubsub_proto_rawDesc = nil
	file_google_pubsub_v1_pubsub_proto_goTypes = nil
	file_google_pubsub_v1_pubsub_proto_depIdxs = nil
}
