// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/securitycenter/v2/ai_model.proto

package securitycenterpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The platform on which the model is deployed.
type AiModel_DeploymentPlatform int32

const (
	// Unspecified deployment platform.
	AiModel_DEPLOYMENT_PLATFORM_UNSPECIFIED AiModel_DeploymentPlatform = 0
	// Vertex AI.
	AiModel_VERTEX_AI AiModel_DeploymentPlatform = 1
	// Google Kubernetes Engine.
	AiModel_GKE AiModel_DeploymentPlatform = 2
	// Google Compute Engine.
	AiModel_GCE AiModel_DeploymentPlatform = 3
	// Fine tuned model.
	AiModel_FINE_TUNED_MODEL AiModel_DeploymentPlatform = 4
)

// Enum value maps for AiModel_DeploymentPlatform.
var (
	AiModel_DeploymentPlatform_name = map[int32]string{
		0: "DEPLOYMENT_PLATFORM_UNSPECIFIED",
		1: "VERTEX_AI",
		2: "GKE",
		3: "GCE",
		4: "FINE_TUNED_MODEL",
	}
	AiModel_DeploymentPlatform_value = map[string]int32{
		"DEPLOYMENT_PLATFORM_UNSPECIFIED": 0,
		"VERTEX_AI":                       1,
		"GKE":                             2,
		"GCE":                             3,
		"FINE_TUNED_MODEL":                4,
	}
)

func (x AiModel_DeploymentPlatform) Enum() *AiModel_DeploymentPlatform {
	p := new(AiModel_DeploymentPlatform)
	*p = x
	return p
}

func (x AiModel_DeploymentPlatform) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AiModel_DeploymentPlatform) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_ai_model_proto_enumTypes[0].Descriptor()
}

func (AiModel_DeploymentPlatform) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_ai_model_proto_enumTypes[0]
}

func (x AiModel_DeploymentPlatform) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AiModel_DeploymentPlatform.Descriptor instead.
func (AiModel_DeploymentPlatform) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_ai_model_proto_rawDescGZIP(), []int{0, 0}
}

// Contains information about the AI model associated with the finding.
type AiModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the AI model, for example, "gemini:1.0.0".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The domain of the model, for example, “image-classification”.
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
	// The name of the model library, for example, “transformers”.
	Library string `protobuf:"bytes,3,opt,name=library,proto3" json:"library,omitempty"`
	// The region in which the model is used, for example, “us-central1”.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// The publisher of the model, for example, “google” or “nvidia”.
	Publisher string `protobuf:"bytes,5,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// The platform on which the model is deployed.
	DeploymentPlatform AiModel_DeploymentPlatform `protobuf:"varint,6,opt,name=deployment_platform,json=deploymentPlatform,proto3,enum=google.cloud.securitycenter.v2.AiModel_DeploymentPlatform" json:"deployment_platform,omitempty"`
	// The user defined display name of model. Ex. baseline-classification-model
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *AiModel) Reset() {
	*x = AiModel{}
	mi := &file_google_cloud_securitycenter_v2_ai_model_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AiModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AiModel) ProtoMessage() {}

func (x *AiModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_ai_model_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AiModel.ProtoReflect.Descriptor instead.
func (*AiModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_ai_model_proto_rawDescGZIP(), []int{0}
}

func (x *AiModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AiModel) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *AiModel) GetLibrary() string {
	if x != nil {
		return x.Library
	}
	return ""
}

func (x *AiModel) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *AiModel) GetPublisher() string {
	if x != nil {
		return x.Publisher
	}
	return ""
}

func (x *AiModel) GetDeploymentPlatform() AiModel_DeploymentPlatform {
	if x != nil {
		return x.DeploymentPlatform
	}
	return AiModel_DEPLOYMENT_PLATFORM_UNSPECIFIED
}

func (x *AiModel) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_securitycenter_v2_ai_model_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_ai_model_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x61, 0x69, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x22,
	0x8b, 0x03, 0x0a, 0x07, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a,
	0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12, 0x6b, 0x0a, 0x13, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x52, 0x12, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x12, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x45, 0x52, 0x54, 0x45, 0x58,
	0x5f, 0x41, 0x49, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x4b, 0x45, 0x10, 0x02, 0x12, 0x07,
	0x0a, 0x03, 0x47, 0x43, 0x45, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x49, 0x4e, 0x45, 0x5f,
	0x54, 0x55, 0x4e, 0x45, 0x44, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x10, 0x04, 0x42, 0xe6, 0x01,
	0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x42, 0x0c, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62,
	0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56,
	0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c,
	0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_ai_model_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_ai_model_proto_rawDescData = file_google_cloud_securitycenter_v2_ai_model_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_ai_model_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_ai_model_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_ai_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_ai_model_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_ai_model_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_ai_model_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v2_ai_model_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_securitycenter_v2_ai_model_proto_goTypes = []any{
	(AiModel_DeploymentPlatform)(0), // 0: google.cloud.securitycenter.v2.AiModel.DeploymentPlatform
	(*AiModel)(nil),                 // 1: google.cloud.securitycenter.v2.AiModel
}
var file_google_cloud_securitycenter_v2_ai_model_proto_depIdxs = []int32{
	0, // 0: google.cloud.securitycenter.v2.AiModel.deployment_platform:type_name -> google.cloud.securitycenter.v2.AiModel.DeploymentPlatform
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_ai_model_proto_init() }
func file_google_cloud_securitycenter_v2_ai_model_proto_init() {
	if File_google_cloud_securitycenter_v2_ai_model_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_ai_model_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_ai_model_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_ai_model_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_ai_model_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_ai_model_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_ai_model_proto = out.File
	file_google_cloud_securitycenter_v2_ai_model_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_ai_model_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_ai_model_proto_depIdxs = nil
}
