// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The settings for user message delivery in forgot-password operations. Contains
// preference for email or SMS message delivery of password reset codes, or for
// admin-only password reset.
type AccountRecoverySettingType struct {

	// The list of options and priorities for user message delivery in forgot-password
	// operations. Sets or displays user pool preferences for email or SMS message
	// priority, whether users should fall back to a second delivery method, and
	// whether passwords should only be reset by administrators.
	RecoveryMechanisms []RecoveryOptionType

	noSmithyDocumentSerde
}

// A list of account-takeover actions for each level of risk that Amazon Cognito
// might assess with threat protection features.
type AccountTakeoverActionsType struct {

	// The action that you assign to a high-risk assessment by threat protection.
	HighAction *AccountTakeoverActionType

	// The action that you assign to a low-risk assessment by threat protection.
	LowAction *AccountTakeoverActionType

	// The action that you assign to a medium-risk assessment by threat protection.
	MediumAction *AccountTakeoverActionType

	noSmithyDocumentSerde
}

// The automated response to a risk level for adaptive authentication in
// full-function, or ENFORCED , mode. You can assign an action to each risk level
// that threat protection evaluates.
type AccountTakeoverActionType struct {

	// The action to take for the attempted account takeover action for the associated
	// risk level. Valid values are as follows:
	//
	//   - BLOCK : Block the request.
	//
	//   - MFA_IF_CONFIGURED : Present an MFA challenge if possible. MFA is possible if
	//   the user pool has active MFA methods that the user can set up. For example, if
	//   the user pool only supports SMS message MFA but the user doesn't have a phone
	//   number attribute, MFA setup isn't possible. If MFA setup isn't possible, allow
	//   the request.
	//
	//   - MFA_REQUIRED : Present an MFA challenge if possible. Block the request if a
	//   user hasn't set up MFA. To sign in with required MFA, users must have an email
	//   address or phone number attribute, or a registered TOTP factor.
	//
	//   - NO_ACTION : Take no action. Permit sign-in.
	//
	// This member is required.
	EventAction AccountTakeoverEventActionType

	// Determines whether Amazon Cognito sends a user a notification message when your
	// user pools assesses a user's session at the associated risk level.
	//
	// This member is required.
	Notify bool

	noSmithyDocumentSerde
}

// The settings for automated responses and notification templates for adaptive
// authentication with threat protection features.
type AccountTakeoverRiskConfigurationType struct {

	// A list of account-takeover actions for each level of risk that Amazon Cognito
	// might assess with threat protection.
	//
	// This member is required.
	Actions *AccountTakeoverActionsType

	// The settings for composing and sending an email message when threat protection
	// assesses a risk level with adaptive authentication. When you choose to notify
	// users in AccountTakeoverRiskConfiguration , Amazon Cognito sends an email
	// message using the method and template that you set with this data type.
	NotifyConfiguration *NotifyConfigurationType

	noSmithyDocumentSerde
}

// The settings for administrator creation of users in a user pool. Contains
// settings for allowing user sign-up, customizing invitation messages to new
// users, and the amount of time before temporary passwords expire.
type AdminCreateUserConfigType struct {

	// The setting for allowing self-service sign-up. When true , only administrators
	// can create new user profiles. When false , users can register themselves and
	// create a new user profile with the SignUp operation.
	AllowAdminCreateUserOnly bool

	// The template for the welcome message to new users. This template must include
	// the {####} temporary password placeholder if you are creating users with
	// passwords. If your users don't have passwords, you can omit the placeholder.
	//
	// See also [Customizing User Invitation Messages].
	//
	// [Customizing User Invitation Messages]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization
	InviteMessageTemplate *MessageTemplateType

	// This parameter is no longer in use.
	//
	// The password expiration limit in days for administrator-created users. When
	// this time expires, the user can't sign in with their temporary password. To
	// reset the account after that time limit, you must call AdminCreateUser again,
	// specifying RESEND for the MessageAction parameter.
	//
	// The default value for this parameter is 7.
	UnusedAccountValidityDays int32

	noSmithyDocumentSerde
}

// Threat protection configuration options for additional authentication types in
// your user pool, including custom authentication.
type AdvancedSecurityAdditionalFlowsType struct {

	// The operating mode of threat protection in custom authentication with [Custom authentication challenge Lambda triggers].
	//
	// [Custom authentication challenge Lambda triggers]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html
	CustomAuthMode AdvancedSecurityEnabledModeType

	noSmithyDocumentSerde
}

// The settings for Amazon Pinpoint analytics configuration. With an analytics
// configuration, your application can collect user-activity metrics for user
// notifications with a Amazon Pinpoint campaign.
//
// Amazon Pinpoint isn't available in all Amazon Web Services Regions. For a list
// of available Regions, see [Amazon Cognito and Amazon Pinpoint Region availability].
//
// [Amazon Cognito and Amazon Pinpoint Region availability]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html#cognito-user-pools-find-region-mappings
type AnalyticsConfigurationType struct {

	// The Amazon Resource Name (ARN) of an Amazon Pinpoint project that you want to
	// connect to your user pool app client. Amazon Cognito publishes events to the
	// Amazon Pinpoint project that ApplicationArn declares. You can also configure
	// your application to pass an endpoint ID in the AnalyticsMetadata parameter of
	// sign-in operations. The endpoint ID is information about the destination for
	// push notifications
	ApplicationArn *string

	// Your Amazon Pinpoint project ID.
	ApplicationId *string

	// The [external ID] of the role that Amazon Cognito assumes to send analytics data to Amazon
	// Pinpoint.
	//
	// [external ID]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
	ExternalId *string

	// The ARN of an Identity and Access Management role that has the permissions
	// required for Amazon Cognito to publish events to Amazon Pinpoint analytics.
	RoleArn *string

	// If UserDataShared is true , Amazon Cognito includes user data in the events that
	// it publishes to Amazon Pinpoint analytics.
	UserDataShared bool

	noSmithyDocumentSerde
}

// Information that your application adds to authentication requests. Applies an
// endpoint ID to the analytics data that your user pool sends to Amazon Pinpoint.
//
// An endpoint ID uniquely identifies a mobile device, email address or phone
// number that can receive messages from Amazon Pinpoint analytics. For more
// information about Amazon Web Services Regions that can contain Amazon Pinpoint
// resources for use with Amazon Cognito user pools, see [Using Amazon Pinpoint analytics with Amazon Cognito user pools].
//
// [Using Amazon Pinpoint analytics with Amazon Cognito user pools]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html
type AnalyticsMetadataType struct {

	// The endpoint ID. Information that you want to pass to Amazon Pinpoint about
	// where to send notifications.
	AnalyticsEndpointId *string

	noSmithyDocumentSerde
}

// An image file from a managed login branding style in a user pool.
type AssetType struct {

	// The category that the image corresponds to in your managed login configuration.
	// Managed login has asset categories for different types of logos, backgrounds,
	// and icons.
	//
	// This member is required.
	Category AssetCategoryType

	// The display-mode target of the asset: light, dark, or browser-adaptive. For
	// example, Amazon Cognito displays a dark-mode image only when the browser or
	// application is in dark mode, but displays a browser-adaptive file in all
	// contexts.
	//
	// This member is required.
	ColorMode ColorSchemeModeType

	// The file type of the image file.
	//
	// This member is required.
	Extension AssetExtensionType

	// The image file, in Base64-encoded binary.
	Bytes []byte

	// The ID of the asset.
	ResourceId *string

	noSmithyDocumentSerde
}

// The name and value of a user attribute.
type AttributeType struct {

	// The name of the attribute.
	//
	// This member is required.
	Name *string

	// The value of the attribute.
	Value *string

	noSmithyDocumentSerde
}

// The object that your application receives after authentication. Contains tokens
// and information for device authentication.
type AuthenticationResultType struct {

	// Your user's access token.
	AccessToken *string

	// The expiration period of the authentication result in seconds.
	ExpiresIn int32

	// Your user's ID token.
	IdToken *string

	// The new device metadata from an authentication result.
	NewDeviceMetadata *NewDeviceMetadataType

	// Your user's refresh token.
	RefreshToken *string

	// The intended use of the token, for example Bearer .
	TokenType *string

	noSmithyDocumentSerde
}

// One authentication event that Amazon Cognito logged in a user pool with threat
// protection active. Contains user and device metadata and a risk assessment from
// your user pool.
type AuthEventType struct {

	// A list of the challenges that the user was requested to answer, for example
	// Password , and the result, for example Success .
	ChallengeResponses []ChallengeResponseType

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// The user context data captured at the time of an event request. This value
	// provides additional information about the client from which event the request is
	// received.
	EventContextData *EventContextDataType

	// The UpdateAuthEventFeedback or AdminUpdateAuthEventFeedback feedback that you
	// or your user provided in response to the event. A value of Valid indicates that
	// you disagreed with the level of risk that your user pool assigned, and evaluated
	// a session to be valid, or likely safe. A value of Invalid indicates that you
	// agreed with the user pool risk level and evaluated a session to be invalid, or
	// likely malicious.
	EventFeedback *EventFeedbackType

	// The event ID.
	EventId *string

	// The event response.
	EventResponse EventResponseType

	// The threat evaluation from your user pool about an event. Contains information
	// about whether your user pool detected compromised credentials, whether the event
	// triggered an automated response, and the level of risk.
	EventRisk *EventRiskType

	// The type of authentication event.
	EventType EventType

	noSmithyDocumentSerde
}

// The responses to the challenge that you received in the previous request. Each
// challenge has its own required response parameters. The following examples are
// partial JSON request bodies that highlight challenge-response parameters.
//
// You must provide a SECRET_HASH parameter in all challenge responses to an app
// client that has a client secret. Include a DEVICE_KEY for device authentication.
//
// SELECT_CHALLENGE "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": {
// "USERNAME": "[username]", "ANSWER": "[Challenge name]"}
//
// Available challenges are PASSWORD , PASSWORD_SRP , EMAIL_OTP , SMS_OTP , and
// WEB_AUTHN .
//
// Complete authentication in the SELECT_CHALLENGE response for PASSWORD ,
// PASSWORD_SRP , and WEB_AUTHN :
//
//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
//     "WEB_AUTHN", "USERNAME": "[username]", "CREDENTIAL":
//     "[AuthenticationResponseJSON]"}
//
// See [AuthenticationResponseJSON].
//
//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
//     "PASSWORD", "USERNAME": "[username]", "PASSWORD": "[password]"}
//
//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
//     "PASSWORD_SRP", "USERNAME": "[username]", "SRP_A": "[SRP_A]"}
//
// For SMS_OTP and EMAIL_OTP , respond with the username and answer. Your user pool
// will send a code for the user to submit in the next challenge response.
//
//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
//     "SMS_OTP", "USERNAME": "[username]"}
//
//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
//     "EMAIL_OTP", "USERNAME": "[username]"}
//
// SMS_OTP "ChallengeName": "SMS_OTP", "ChallengeResponses": {"SMS_OTP_CODE":
// "[code]", "USERNAME": "[username]"}
//
// EMAIL_OTP "ChallengeName": "EMAIL_OTP", "ChallengeResponses":
// {"EMAIL_OTP_CODE": "[code]", "USERNAME": "[username]"}
//
// SMS_MFA "ChallengeName": "SMS_MFA", "ChallengeResponses": {"SMS_MFA_CODE":
// "[code]", "USERNAME": "[username]"}
//
// PASSWORD_VERIFIER This challenge response is part of the SRP flow. Amazon
// Cognito requires that your application respond to this challenge within a few
// seconds. When the response time exceeds this period, your user pool returns a
// NotAuthorizedException error.
//
//	"ChallengeName": "PASSWORD_VERIFIER", "ChallengeResponses":
//	{"PASSWORD_CLAIM_SIGNATURE": "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK":
//	"[secret_block]", "TIMESTAMP": [timestamp], "USERNAME": "[username]"}
//
// Add "DEVICE_KEY" when you sign in with a remembered device.
//
// CUSTOM_CHALLENGE "ChallengeName": "CUSTOM_CHALLENGE", "ChallengeResponses":
// {"USERNAME": "[username]", "ANSWER": "[challenge_answer]"}
//
// Add "DEVICE_KEY" when you sign in with a remembered device.
//
// NEW_PASSWORD_REQUIRED "ChallengeName": "NEW_PASSWORD_REQUIRED",
// "ChallengeResponses": {"NEW_PASSWORD": "[new_password]", "USERNAME":
// "[username]"}
//
// To set any required attributes that InitiateAuth returned in an
// requiredAttributes parameter, add "userAttributes.[attribute_name]":
// "[attribute_value]" . This parameter can also set values for writable attributes
// that aren't required by your user pool.
//
// In a NEW_PASSWORD_REQUIRED challenge response, you can't modify a required
// attribute that already has a value. In AdminRespondToAuthChallenge or
// RespondToAuthChallenge , set a value for any keys that Amazon Cognito returned
// in the requiredAttributes parameter, then use the AdminUpdateUserAttributes or
// UpdateUserAttributes API operation to modify the value of any additional
// attributes.
//
// SOFTWARE_TOKEN_MFA "ChallengeName": "SOFTWARE_TOKEN_MFA", "ChallengeResponses":
// {"USERNAME": "[username]", "SOFTWARE_TOKEN_MFA_CODE": [authenticator_code]}
//
// DEVICE_SRP_AUTH "ChallengeName": "DEVICE_SRP_AUTH", "ChallengeResponses":
// {"USERNAME": "[username]", "DEVICE_KEY": "[device_key]", "SRP_A": "[srp_a]"}
//
// DEVICE_PASSWORD_VERIFIER "ChallengeName": "DEVICE_PASSWORD_VERIFIER",
// "ChallengeResponses": {"DEVICE_KEY": "[device_key]", "PASSWORD_CLAIM_SIGNATURE":
// "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK": "[secret_block]",
// "TIMESTAMP": [timestamp], "USERNAME": "[username]"}
//
// MFA_SETUP "ChallengeName": "MFA_SETUP", "ChallengeResponses": {"USERNAME":
// "[username]"}, "SESSION": "[Session ID from VerifySoftwareToken]"
//
// SELECT_MFA_TYPE "ChallengeName": "SELECT_MFA_TYPE", "ChallengeResponses":
// {"USERNAME": "[username]", "ANSWER": "[SMS_MFA or SOFTWARE_TOKEN_MFA]"}
//
// For more information about SECRET_HASH , see [Computing secret hash values]. For information about DEVICE_KEY
// , see [Working with user devices in your user pool].
//
// [Computing secret hash values]: https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash
// [AuthenticationResponseJSON]: https://www.w3.org/TR/WebAuthn-3/#dictdef-authenticationresponsejson
// [Working with user devices in your user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html
type ChallengeResponseType struct {

	// The type of challenge that your previous authentication request returned in the
	// parameter ChallengeName , for example SMS_MFA .
	ChallengeName ChallengeName

	// The set of key-value pairs that provides a response to the requested challenge.
	ChallengeResponse ChallengeResponse

	noSmithyDocumentSerde
}

// Configuration for the CloudWatch log group destination of user pool detailed
// activity logging, or of user activity log export with threat protection.
type CloudWatchLogsConfigurationType struct {

	// The Amazon Resource Name (arn) of a CloudWatch Logs log group where your user
	// pool sends logs. The log group must not be encrypted with Key Management Service
	// and must be in the same Amazon Web Services account as your user pool.
	//
	// To send logs to log groups with a resource policy of a size greater than 5120
	// characters, configure a log group with a path that starts with /aws/vendedlogs .
	// For more information, see [Enabling logging from certain Amazon Web Services services].
	//
	// [Enabling logging from certain Amazon Web Services services]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
	LogGroupArn *string

	noSmithyDocumentSerde
}

// The delivery details for an email or SMS message that Amazon Cognito sent for
// authentication or verification.
type CodeDeliveryDetailsType struct {

	// The name of the attribute that Amazon Cognito verifies with the code.
	AttributeName *string

	// The method that Amazon Cognito used to send the code.
	DeliveryMedium DeliveryMediumType

	// The email address or phone number destination where Amazon Cognito sent the
	// code.
	Destination *string

	noSmithyDocumentSerde
}

// Settings for user pool actions when Amazon Cognito detects compromised
// credentials with threat protection in full-function ENFORCED mode.
type CompromisedCredentialsActionsType struct {

	// The action that Amazon Cognito takes when it detects compromised credentials.
	//
	// This member is required.
	EventAction CompromisedCredentialsEventActionType

	noSmithyDocumentSerde
}

// Settings for compromised-credentials actions and authentication-event sources
// with threat protection in full-function ENFORCED mode.
type CompromisedCredentialsRiskConfigurationType struct {

	// Settings for the actions that you want your user pool to take when Amazon
	// Cognito detects compromised credentials.
	//
	// This member is required.
	Actions *CompromisedCredentialsActionsType

	// Settings for the sign-in activity where you want to configure
	// compromised-credentials actions. Defaults to all events.
	EventFilter []EventFilterType

	noSmithyDocumentSerde
}

// Contextual user data used for evaluating the risk of an authentication event by
// user pool threat protection.
type ContextDataType struct {

	// The HTTP headers from your user's authentication request.
	//
	// This member is required.
	HttpHeaders []HttpHeader

	// The source IP address of your user's device.
	//
	// This member is required.
	IpAddress *string

	// The name of your application's service endpoint.
	//
	// This member is required.
	ServerName *string

	// The path of your application's service endpoint.
	//
	// This member is required.
	ServerPath *string

	// Encoded device-fingerprint details that your app collected with the Amazon
	// Cognito context data collection library. For more information, see [Adding user device and session data to API requests].
	//
	// [Adding user device and session data to API requests]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint
	EncodedData *string

	noSmithyDocumentSerde
}

// The configuration for a hosted UI custom domain.
type CustomDomainConfigType struct {

	// The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You
	// use this certificate for the subdomain of your custom domain.
	//
	// This member is required.
	CertificateArn *string

	noSmithyDocumentSerde
}

// The properties of a custom email sender Lambda trigger.
type CustomEmailLambdaVersionConfigType struct {

	// The Amazon Resource Name (ARN) of the function that you want to assign to your
	// Lambda trigger.
	//
	// This member is required.
	LambdaArn *string

	// The user pool trigger version of the request that Amazon Cognito sends to your
	// Lambda function. Higher-numbered versions add fields that support new features.
	//
	// You must use a LambdaVersion of V1_0 with a custom sender function.
	//
	// This member is required.
	LambdaVersion CustomEmailSenderLambdaVersionType

	noSmithyDocumentSerde
}

// The properties of a custom SMS sender Lambda trigger.
type CustomSMSLambdaVersionConfigType struct {

	// The Amazon Resource Name (ARN) of the function that you want to assign to your
	// Lambda trigger.
	//
	// This member is required.
	LambdaArn *string

	// The user pool trigger version of the request that Amazon Cognito sends to your
	// Lambda function. Higher-numbered versions add fields that support new features.
	//
	// You must use a LambdaVersion of V1_0 with a custom sender function.
	//
	// This member is required.
	LambdaVersion CustomSMSSenderLambdaVersionType

	noSmithyDocumentSerde
}

// The device-remembering configuration for a user pool.
//
// When you provide a value for any property of DeviceConfiguration , you activate
// the device remembering for the user pool.
type DeviceConfigurationType struct {

	// When true, a remembered device can sign in with device authentication instead
	// of SMS and time-based one-time password (TOTP) factors for multi-factor
	// authentication (MFA).
	//
	// Whether or not ChallengeRequiredOnNewDevice is true, users who sign in with
	// devices that have not been confirmed or remembered must still provide a second
	// factor in a user pool that requires MFA.
	ChallengeRequiredOnNewDevice bool

	// When true, Amazon Cognito doesn't automatically remember a user's device when
	// your app sends a ConfirmDevice API request. In your app, create a prompt for
	// your user to choose whether they want to remember their device. Return the
	// user's choice in an UpdateDeviceStatus API request.
	//
	// When DeviceOnlyRememberedOnUserPrompt is false , Amazon Cognito immediately
	// remembers devices that you register in a ConfirmDevice API request.
	DeviceOnlyRememberedOnUserPrompt bool

	noSmithyDocumentSerde
}

// A Secure Remote Password (SRP) value that your application generates when you
// register a user's device. For more information, see [Getting a device key].
//
// [Getting a device key]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html#user-pools-remembered-devices-getting-a-device-key
type DeviceSecretVerifierConfigType struct {

	// A password verifier for a user's device. Used in SRP authentication.
	PasswordVerifier *string

	// The salt that you want to use in SRP authentication with the user's device.
	Salt *string

	noSmithyDocumentSerde
}

// Information about a user's device that they've registered for device SRP
// authentication in your application. For more information, see [Working with user devices in your user pool].
//
// [Working with user devices in your user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html
type DeviceType struct {

	// Metadata about a user's device, like name and last-access source IP.
	DeviceAttributes []AttributeType

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	DeviceCreateDate *time.Time

	// The device key, for example
	// us-west-2_EXAMPLE-a1b2c3d4-5678-90ab-cdef-EXAMPLE22222 .
	DeviceKey *string

	// The date when the user last signed in with the device.
	DeviceLastAuthenticatedDate *time.Time

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	DeviceLastModifiedDate *time.Time

	noSmithyDocumentSerde
}

// A container for information about the user pool domain associated with the
// hosted UI and OAuth endpoints.
type DomainDescriptionType struct {

	// The Amazon Web Services account that you created the user pool in.
	AWSAccountId *string

	// The Amazon CloudFront endpoint that hosts your custom domain.
	CloudFrontDistribution *string

	// The configuration for a custom domain that hosts the sign-up and sign-in
	// webpages for your application.
	CustomDomainConfig *CustomDomainConfigType

	// The domain string. For custom domains, this is the fully-qualified domain name,
	// such as auth.example.com . For Amazon Cognito prefix domains, this is the prefix
	// alone, such as auth .
	Domain *string

	// The version of managed login branding that you want to apply to your domain. A
	// value of 1 indicates hosted UI (classic) branding and a version of 2 indicates
	// managed login branding.
	//
	// Managed login requires that your user pool be configured for any [feature plan] other than
	// Lite .
	//
	// [feature plan]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html
	ManagedLoginVersion *int32

	// The Amazon S3 bucket where the static files for this domain are stored.
	S3Bucket *string

	// The domain status.
	Status DomainStatusType

	// The ID of the user pool that the domain is attached to.
	UserPoolId *string

	// The app version.
	Version *string

	noSmithyDocumentSerde
}

// The email configuration of your user pool. The email configuration type sets
// your preferred sending method, Amazon Web Services Region, and sender for
// messages from your user pool.
//
// Amazon Cognito can send email messages with Amazon Simple Email Service
// resources in the Amazon Web Services Region where you created your user pool,
// and in alternate Regions in some cases. For more information on the supported
// Regions, see [Email settings for Amazon Cognito user pools].
//
// [Email settings for Amazon Cognito user pools]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html
type EmailConfigurationType struct {

	// The set of configuration rules that can be applied to emails sent using Amazon
	// Simple Email Service. A configuration set is applied to an email by including a
	// reference to the configuration set in the headers of the email. Once applied,
	// all of the rules in that configuration set are applied to the email.
	// Configuration sets can be used to apply the following types of rules to emails:
	//
	// Event publishing Amazon Simple Email Service can track the number of send,
	// delivery, open, click, bounce, and complaint events for each email sent. Use
	// event publishing to send information about these events to other Amazon Web
	// Services services such as and Amazon CloudWatch
	//
	// IP pool management When leasing dedicated IP addresses with Amazon Simple Email
	// Service, you can create groups of IP addresses, called dedicated IP pools. You
	// can then associate the dedicated IP pools with configuration sets.
	ConfigurationSet *string

	// Specifies whether Amazon Cognito uses its built-in functionality to send your
	// users email messages, or uses your Amazon Simple Email Service email
	// configuration. Specify one of the following values:
	//
	// COGNITO_DEFAULT When Amazon Cognito emails your users, it uses its built-in
	// email functionality. When you use the default option, Amazon Cognito allows only
	// a limited number of emails each day for your user pool. For typical production
	// environments, the default email limit is less than the required delivery volume.
	// To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES
	// email configuration.
	//
	// To look up the email delivery limit for the default option, see [Limits] in the Amazon
	// Cognito Developer Guide.
	//
	// The default FROM address is no-reply@verificationemail.com . To customize the
	// FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified
	// email address for the SourceArn parameter.
	//
	// DEVELOPER When Amazon Cognito emails your users, it uses your Amazon SES
	// configuration. Amazon Cognito calls Amazon SES on your behalf to send email from
	// your verified email address. When you use this option, the email delivery limits
	// are the same limits that apply to your Amazon SES verified email address in your
	// Amazon Web Services account.
	//
	// If you use this option, provide the ARN of an Amazon SES verified email address
	// for the SourceArn parameter.
	//
	// Before Amazon Cognito can email your users, it requires additional permissions
	// to call Amazon SES on your behalf. When you update your user pool with this
	// option, Amazon Cognito creates a service-linked role, which is a type of role in
	// your Amazon Web Services account. This role contains the permissions that allow
	// you to access Amazon SES and send email messages from your email address. For
	// more information about the service-linked role that Amazon Cognito creates, see [Using Service-Linked Roles for Amazon Cognito]
	// in the Amazon Cognito Developer Guide.
	//
	// [Limits]: https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html
	// [Using Service-Linked Roles for Amazon Cognito]: https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html
	EmailSendingAccount EmailSendingAccountType

	// Either the sender’s email address or the sender’s name with their email
	// address. For example, testuser@example.com or Test User . This address appears
	// before the body of the email.
	From *string

	// The destination to which the receiver of the email should reply.
	ReplyToEmailAddress *string

	// The ARN of a verified email address or an address from a verified domain in
	// Amazon SES. You can set a SourceArn email from a verified domain only with an
	// API request. You can set a verified email address, but not an address in a
	// verified domain, in the Amazon Cognito console. Amazon Cognito uses the email
	// address that you provide in one of the following ways, depending on the value
	// that you specify for the EmailSendingAccount parameter:
	//
	//   - If you specify COGNITO_DEFAULT , Amazon Cognito uses this address as the
	//   custom FROM address when it emails your users using its built-in email account.
	//
	//   - If you specify DEVELOPER , Amazon Cognito emails your users with this
	//   address by calling Amazon SES on your behalf.
	//
	// The Region value of the SourceArn parameter must indicate a supported Amazon
	// Web Services Region of your user pool. Typically, the Region in the SourceArn
	// and the user pool Region are the same. For more information, see [Amazon SES email configuration regions]in the [Amazon Cognito Developer Guide].
	//
	// [Amazon SES email configuration regions]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping
	// [Amazon Cognito Developer Guide]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html
	SourceArn *string

	noSmithyDocumentSerde
}

// Sets or shows configuration for user pool email message MFA and sign-in with
// one-time passwords (OTPs). Includes the subject and body of the email message
// template for sign-in and MFA messages. To activate this setting, your user pool
// must be in the [Essentials tier]or higher.
//
// [Essentials tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html
type EmailMfaConfigType struct {

	// The template for the email messages that your user pool sends to users with
	// codes for MFA and sign-in with email OTPs. The message must contain the {####}
	// placeholder. In the message, Amazon Cognito replaces this placeholder with the
	// code. If you don't provide this parameter, Amazon Cognito sends messages in the
	// default format.
	Message *string

	// The subject of the email messages that your user pool sends to users with codes
	// for MFA and email OTP sign-in.
	Subject *string

	noSmithyDocumentSerde
}

// User preferences for multi-factor authentication with email messages. Activates
// or deactivates email MFA and sets it as the preferred MFA method when multiple
// methods are available. To activate this setting, your user pool must be in the [Essentials tier]
// or higher.
//
// [Essentials tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html
type EmailMfaSettingsType struct {

	// Specifies whether email message MFA is active for a user. When the value of
	// this parameter is Enabled , the user will be prompted for MFA during all sign-in
	// attempts, unless device tracking is turned on and the device has been trusted.
	Enabled bool

	// Specifies whether email message MFA is the user's preferred method.
	PreferredMfa bool

	noSmithyDocumentSerde
}

// The context data that your application submitted in an authentication request
// with threat protection, as displayed in an AdminListUserAuthEvents response.
type EventContextDataType struct {

	// The user's city.
	City *string

	// The user's country.
	Country *string

	// The user's device name.
	DeviceName *string

	// The source IP address of your user's device.
	IpAddress *string

	// The user's time zone.
	Timezone *string

	noSmithyDocumentSerde
}

// The feedback that your application submitted to a threat protection event log,
// as displayed in an AdminListUserAuthEvents response.
type EventFeedbackType struct {

	// Your feedback to the authentication event. When you provide a FeedbackValue
	// value of valid , you tell Amazon Cognito that you trust a user session where
	// Amazon Cognito has evaluated some level of risk. When you provide a
	// FeedbackValue value of invalid , you tell Amazon Cognito that you don't trust a
	// user session, or you don't believe that Amazon Cognito evaluated a high-enough
	// risk level.
	//
	// This member is required.
	FeedbackValue FeedbackValueType

	// The submitter of the event feedback. For example, if you submit event feedback
	// in the Amazon Cognito console, this value is Admin .
	//
	// This member is required.
	Provider *string

	// The date that you or your user submitted the feedback.
	FeedbackDate *time.Time

	noSmithyDocumentSerde
}

// The risk evaluation by adaptive authentication, as displayed in an
// AdminListUserAuthEvents response. Contains evaluations of
// compromised-credentials detection and assessed risk level and action taken by
// adaptive authentication.
type EventRiskType struct {

	// Indicates whether compromised credentials were detected during an
	// authentication event.
	CompromisedCredentialsDetected *bool

	// The action taken by adaptive authentication. If NoRisk , your user pool took no
	// action. If AccountTakeover , your user pool applied the adaptive authentication
	// automated response that you configured. If Block , your user pool prevented the
	// attempt.
	RiskDecision RiskDecisionType

	// The risk level that adaptive authentication assessed for the authentication
	// event.
	RiskLevel RiskLevelType

	noSmithyDocumentSerde
}

// Configuration for the Amazon Data Firehose stream destination of user activity
// log export with threat protection.
type FirehoseConfigurationType struct {

	// The ARN of an Amazon Data Firehose stream that's the destination for threat
	// protection log export.
	StreamArn *string

	noSmithyDocumentSerde
}

// A user pool group. Contains details about the group and the way that it
// contributes to IAM role decisions with identity pools. Identity pools can make
// decisions about the IAM role to assign based on groups: users get credentials
// for the role associated with their highest-priority group.
type GroupType struct {

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// A friendly description of the group.
	Description *string

	// The name of the group.
	GroupName *string

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// A non-negative integer value that specifies the precedence of this group
	// relative to the other groups that a user can belong to in the user pool. Zero is
	// the highest precedence value. Groups with lower Precedence values take
	// precedence over groups with higher ornull Precedence values. If a user belongs
	// to two or more groups, it is the group with the lowest precedence value whose
	// role ARN is given in the user's tokens for the cognito:roles and
	// cognito:preferred_role claims.
	//
	// Two groups can have the same Precedence value. If this happens, neither group
	// takes precedence over the other. If two groups with the same Precedence have
	// the same role ARN, that role is used in the cognito:preferred_role claim in
	// tokens for users in each group. If the two groups have different role ARNs, the
	// cognito:preferred_role claim isn't set in users' tokens.
	//
	// The default Precedence value is null .
	Precedence *int32

	// The ARN of the IAM role associated with the group. If a group has the highest
	// priority of a user's groups, users who authenticate with an identity pool get
	// credentials for the RoleArn that's associated with the group.
	RoleArn *string

	// The ID of the user pool that contains the group.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The HTTP header in the ContextData parameter.
type HttpHeader struct {

	// The header name.
	HeaderName *string

	// The header value.
	HeaderValue *string

	noSmithyDocumentSerde
}

// A user pool identity provider (IdP). Contains information about a third-party
// IdP to a user pool, the attributes that it populates to user profiles, and the
// trust relationship between the IdP and your user pool.
type IdentityProviderType struct {

	// A mapping of IdP attributes to standard and custom user pool attributes.
	AttributeMapping map[string]string

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// A list of IdP identifiers. IdP identifiers are strings that represent friendly
	// names or domain names of IdPs, for example MyIdP or auth.example.com . You can
	// choose to route user authorization requests to the right IdP with either IdP
	// identifiers or IdP names. For more information, see identity_provider and
	// idp_identifier at [Authorize endpoint].
	//
	// [Authorize endpoint]: https://docs.aws.amazon.com/cognito/latest/developerguide/authorization-endpoint.html#get-authorize-request-parameters
	IdpIdentifiers []string

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// The scopes, URLs, and identifiers for your external identity provider. The
	// following examples describe the provider detail keys for each IdP type. These
	// values and their schema are subject to change. Social IdP authorize_scopes
	// values must match the values listed here.
	//
	// OpenID Connect (OIDC) Amazon Cognito accepts the following elements when it
	// can't discover endpoint URLs from oidc_issuer : attributes_url , authorize_url ,
	// jwks_uri , token_url .
	//
	// Create or update request: "ProviderDetails": { "attributes_request_method":
	// "GET", "attributes_url": "https://auth.example.com/userInfo",
	// "authorize_scopes": "openid profile email", "authorize_url":
	// "https://auth.example.com/authorize", "client_id": "1example23456789",
	// "client_secret": "provider-app-client-secret", "jwks_uri":
	// "https://auth.example.com/.well-known/jwks.json", "oidc_issuer":
	// "https://auth.example.com", "token_url": "https://example.com/token" }
	//
	// Describe response: "ProviderDetails": { "attributes_request_method": "GET",
	// "attributes_url": "https://auth.example.com/userInfo",
	// "attributes_url_add_attributes": "false", "authorize_scopes": "openid profile
	// email", "authorize_url": "https://auth.example.com/authorize", "client_id":
	// "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri":
	// "https://auth.example.com/.well-known/jwks.json", "oidc_issuer":
	// "https://auth.example.com", "token_url": "https://example.com/token" }
	//
	// SAML Create or update request with Metadata URL: "ProviderDetails": {
	// "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true",
	// "MetadataURL": "https://auth.example.com/sso/saml/metadata",
	// "RequestSigningAlgorithm": "rsa-sha256" }
	//
	// Create or update request with Metadata file: "ProviderDetails": { "IDPInit":
	// "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataFile":
	// "[metadata XML]", "RequestSigningAlgorithm": "rsa-sha256" }
	//
	// The value of MetadataFile must be the plaintext metadata document with all
	// quote (") characters escaped by backslashes.
	//
	// Describe response: "ProviderDetails": { "IDPInit": "true", "IDPSignout":
	// "true", "EncryptedResponses" : "true", "ActiveEncryptionCertificate":
	// "[certificate]", "MetadataURL": "https://auth.example.com/sso/saml/metadata",
	// "RequestSigningAlgorithm": "rsa-sha256", "SLORedirectBindingURI":
	// "https://auth.example.com/slo/saml", "SSORedirectBindingURI":
	// "https://auth.example.com/sso/saml" }
	//
	// LoginWithAmazon Create or update request: "ProviderDetails": {
	// "authorize_scopes": "profile postal_code", "client_id":
	// "amzn1.application-oa2-client.1example23456789", "client_secret":
	// "provider-app-client-secret"
	//
	// Describe response: "ProviderDetails": { "attributes_url":
	// "https://api.amazon.com/user/profile", "attributes_url_add_attributes": "false",
	// "authorize_scopes": "profile postal_code", "authorize_url":
	// "https://www.amazon.com/ap/oa", "client_id":
	// "amzn1.application-oa2-client.1example23456789", "client_secret":
	// "provider-app-client-secret", "token_request_method": "POST", "token_url":
	// "https://api.amazon.com/auth/o2/token" }
	//
	// Google Create or update request: "ProviderDetails": { "authorize_scopes":
	// "email profile openid", "client_id":
	// "1example23456789.apps.googleusercontent.com", "client_secret":
	// "provider-app-client-secret" }
	//
	// Describe response: "ProviderDetails": { "attributes_url":
	// "https://people.googleapis.com/v1/people/me?personFields=",
	// "attributes_url_add_attributes": "true", "authorize_scopes": "email profile
	// openid", "authorize_url": "https://accounts.google.com/o/oauth2/v2/auth",
	// "client_id": "1example23456789.apps.googleusercontent.com", "client_secret":
	// "provider-app-client-secret", "oidc_issuer": "https://accounts.google.com",
	// "token_request_method": "POST", "token_url":
	// "https://www.googleapis.com/oauth2/v4/token" }
	//
	// SignInWithApple Create or update request: "ProviderDetails": {
	// "authorize_scopes": "email name", "client_id": "com.example.cognito",
	// "private_key": "1EXAMPLE", "key_id": "2EXAMPLE", "team_id": "3EXAMPLE" }
	//
	// Describe response: "ProviderDetails": { "attributes_url_add_attributes":
	// "false", "authorize_scopes": "email name", "authorize_url":
	// "https://appleid.apple.com/auth/authorize", "client_id": "com.example.cognito",
	// "key_id": "1EXAMPLE", "oidc_issuer": "https://appleid.apple.com", "team_id":
	// "2EXAMPLE", "token_request_method": "POST", "token_url":
	// "https://appleid.apple.com/auth/token" }
	//
	// Facebook Create or update request: "ProviderDetails": { "api_version": "v17.0",
	// "authorize_scopes": "public_profile, email", "client_id": "1example23456789",
	// "client_secret": "provider-app-client-secret" }
	//
	// Describe response: "ProviderDetails": { "api_version": "v17.0",
	// "attributes_url": "https://graph.facebook.com/v17.0/me?fields=",
	// "attributes_url_add_attributes": "true", "authorize_scopes": "public_profile,
	// email", "authorize_url": "https://www.facebook.com/v17.0/dialog/oauth",
	// "client_id": "1example23456789", "client_secret": "provider-app-client-secret",
	// "token_request_method": "GET", "token_url":
	// "https://graph.facebook.com/v17.0/oauth/access_token" }
	ProviderDetails map[string]string

	// A friendly name for the IdP.
	ProviderName *string

	// The type of IdP. Either SAML, OIDC, or a named social identity provider.
	ProviderType IdentityProviderTypeType

	// The ID of the user pool associated with the IdP.
	UserPoolId *string

	noSmithyDocumentSerde
}

// A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at
// several possible stages of user pool operations. Triggers can modify the outcome
// of the operations that invoked them.
type LambdaConfigType struct {

	// The configuration of a create auth challenge Lambda trigger, one of three
	// triggers in the sequence of the [custom authentication challenge triggers].
	//
	// [custom authentication challenge triggers]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html
	CreateAuthChallenge *string

	// The configuration of a custom email sender Lambda trigger. This trigger routes
	// all email notifications from a user pool to a Lambda function that delivers the
	// message using custom logic.
	CustomEmailSender *CustomEmailLambdaVersionConfigType

	// A custom message Lambda trigger. This trigger is an opportunity to customize
	// all SMS and email messages from your user pool. When a custom message trigger is
	// active, your user pool routes all messages to a Lambda function that returns a
	// runtime-customized message subject and body for your user pool to deliver to a
	// user.
	CustomMessage *string

	// The configuration of a custom SMS sender Lambda trigger. This trigger routes
	// all SMS notifications from a user pool to a Lambda function that delivers the
	// message using custom logic.
	CustomSMSSender *CustomSMSLambdaVersionConfigType

	// The configuration of a define auth challenge Lambda trigger, one of three
	// triggers in the sequence of the [custom authentication challenge triggers].
	//
	// [custom authentication challenge triggers]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html
	DefineAuthChallenge *string

	// The ARN of an [KMS key]. Amazon Cognito uses the key to encrypt codes and temporary
	// passwords sent to custom sender Lambda triggers.
	//
	// [KMS key]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys
	KMSKeyID *string

	// The configuration of a [post authentication Lambda trigger] in a user pool. This trigger can take custom actions
	// after a user signs in.
	//
	// [post authentication Lambda trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html
	PostAuthentication *string

	// The configuration of a [post confirmation Lambda trigger] in a user pool. This trigger can take custom actions
	// after a user confirms their user account and their email address or phone
	// number.
	//
	// [post confirmation Lambda trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html
	PostConfirmation *string

	// The configuration of a [pre authentication trigger] in a user pool. This trigger can evaluate and modify
	// user sign-in events.
	//
	// [pre authentication trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html
	PreAuthentication *string

	// The configuration of a [pre sign-up Lambda trigger] in a user pool. This trigger evaluates new users and
	// can bypass confirmation, [link a federated user profile], or block sign-up requests.
	//
	// [link a federated user profile]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html
	// [pre sign-up Lambda trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html
	PreSignUp *string

	// The legacy configuration of a [pre token generation Lambda trigger] in a user pool.
	//
	// Set this parameter for legacy purposes. If you also set an ARN in
	// PreTokenGenerationConfig , its value must be identical to PreTokenGeneration .
	// For new instances of pre token generation triggers, set the LambdaArn of
	// PreTokenGenerationConfig .
	//
	// [pre token generation Lambda trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html
	PreTokenGeneration *string

	// The detailed configuration of a [pre token generation Lambda trigger] in a user pool. If you also set an ARN in
	// PreTokenGeneration , its value must be identical to PreTokenGenerationConfig .
	//
	// [pre token generation Lambda trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html
	PreTokenGenerationConfig *PreTokenGenerationVersionConfigType

	// The configuration of a [migrate user Lambda trigger] in a user pool. This trigger can create user profiles
	// when users sign in or attempt to reset their password with credentials that
	// don't exist yet.
	//
	// [migrate user Lambda trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html
	UserMigration *string

	// The configuration of a verify auth challenge Lambda trigger, one of three
	// triggers in the sequence of the [custom authentication challenge triggers].
	//
	// [custom authentication challenge triggers]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html
	VerifyAuthChallengeResponse *string

	noSmithyDocumentSerde
}

// The configuration of user event logs to an external Amazon Web Services service
// like Amazon Data Firehose, Amazon S3, or Amazon CloudWatch Logs.
type LogConfigurationType struct {

	// The source of events that your user pool sends for logging. To send error-level
	// logs about user notification activity, set to userNotification . To send
	// info-level logs about threat-protection user activity in user pools with the
	// Plus feature plan, set to userAuthEvents .
	//
	// This member is required.
	EventSource EventSourceName

	// The errorlevel selection of logs that a user pool sends for detailed activity
	// logging. To send userNotification activity with [information about message delivery], choose ERROR with
	// CloudWatchLogsConfiguration . To send userAuthEvents activity with user logs
	// from threat protection with the Plus feature plan, choose INFO with one of
	// CloudWatchLogsConfiguration , FirehoseConfiguration , or S3Configuration .
	//
	// [information about message delivery]: https://docs.aws.amazon.com/cognito/latest/developerguide/exporting-quotas-and-usage.html
	//
	// This member is required.
	LogLevel LogLevel

	// The CloudWatch log group destination of user pool detailed activity logs, or of
	// user activity log export with threat protection.
	CloudWatchLogsConfiguration *CloudWatchLogsConfigurationType

	// The Amazon Data Firehose stream destination of user activity log export with
	// threat protection. To activate this setting, your user pool must be on the [Plus tier].
	//
	// [Plus tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html
	FirehoseConfiguration *FirehoseConfigurationType

	// The Amazon S3 bucket destination of user activity log export with threat
	// protection. To activate this setting, your user pool must be on the [Plus tier].
	//
	// [Plus tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html
	S3Configuration *S3ConfigurationType

	noSmithyDocumentSerde
}

// The logging parameters of a user pool, as returned in the response to a
// GetLogDeliveryConfiguration request.
type LogDeliveryConfigurationType struct {

	// A logging destination of a user pool. User pools can have multiple logging
	// destinations for message-delivery and user-activity logs.
	//
	// This member is required.
	LogConfigurations []LogConfigurationType

	// The ID of the user pool where you configured logging.
	//
	// This member is required.
	UserPoolId *string

	noSmithyDocumentSerde
}

// A managed login branding style that's assigned to a user pool app client.
type ManagedLoginBrandingType struct {

	// An array of image files that you want to apply to roles like backgrounds,
	// logos, and icons. Each object must also indicate whether it is for dark mode,
	// light mode, or browser-adaptive mode.
	Assets []AssetType

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// The ID of the managed login branding style.
	ManagedLoginBrandingId *string

	// A JSON file, encoded as a Document type, with the the settings that you want to
	// apply to your style.
	Settings document.Interface

	// When true, applies the default branding style options. This option reverts to
	// default style options that are managed by Amazon Cognito. You can modify them
	// later in the branding designer.
	//
	// When you specify true for this option, you must also omit values for Settings
	// and Assets in the request.
	UseCognitoProvidedValues bool

	// The user pool where the branding style is assigned.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The message template structure.
type MessageTemplateType struct {

	// The message template for email messages. EmailMessage is allowed only if [EmailSendingAccount] is
	// DEVELOPER.
	//
	// [EmailSendingAccount]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount
	EmailMessage *string

	// The subject line for email messages. EmailSubject is allowed only if [EmailSendingAccount] is
	// DEVELOPER.
	//
	// [EmailSendingAccount]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount
	EmailSubject *string

	// The message template for SMS messages.
	SMSMessage *string

	noSmithyDocumentSerde
}

//	This data type is no longer supported. Applies only to SMS multi-factor
//
// authentication (MFA) configurations. Does not apply to time-based one-time
// password (TOTP) software token MFA configurations.
type MFAOptionType struct {

	// The attribute name of the MFA option type. The only valid value is phone_number .
	AttributeName *string

	// The delivery medium to send the MFA code. You can use this parameter to set
	// only the SMS delivery medium value.
	DeliveryMedium DeliveryMediumType

	noSmithyDocumentSerde
}

// Information that your user pool responds with in AuthenticationResult when you
// configure it to remember devices and a user signs in with an unrecognized
// device. Amazon Cognito presents a new device key that you can use to set up [device authentication]in
// a "Remember me on this device" authentication model.
//
// [device authentication]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html
type NewDeviceMetadataType struct {

	// The device group key, an identifier used in generating the
	// DEVICE_PASSWORD_VERIFIER for device SRP authentication.
	DeviceGroupKey *string

	// The device key, an identifier used in generating the DEVICE_PASSWORD_VERIFIER
	// for device SRP authentication.
	DeviceKey *string

	noSmithyDocumentSerde
}

// The configuration for Amazon SES email messages that threat protection sends to
// a user when your adaptive authentication automated response has a Notify action.
type NotifyConfigurationType struct {

	// The Amazon Resource Name (ARN) of the identity that is associated with the
	// sending authorization policy. This identity permits Amazon Cognito to send for
	// the email address specified in the From parameter.
	//
	// This member is required.
	SourceArn *string

	// The template for the email message that your user pool sends when a detected
	// risk event is blocked.
	BlockEmail *NotifyEmailType

	// The email address that sends the email message. The address must be either
	// individually verified with Amazon Simple Email Service, or from a domain that
	// has been verified with Amazon SES.
	From *string

	// The template for the email message that your user pool sends when MFA is
	// challenged in response to a detected risk.
	MfaEmail *NotifyEmailType

	// The template for the email message that your user pool sends when no action is
	// taken in response to a detected risk.
	NoActionEmail *NotifyEmailType

	// The reply-to email address of an email template.
	ReplyTo *string

	noSmithyDocumentSerde
}

// The template for email messages that threat protection sends to a user when
// your threat protection automated response has a Notify action.
type NotifyEmailType struct {

	// The subject of the threat protection email notification.
	//
	// This member is required.
	Subject *string

	// The body of an email notification formatted in HTML. Choose an HtmlBody or a
	// TextBody to send an HTML-formatted or plaintext message, respectively.
	HtmlBody *string

	// The body of an email notification formatted in plaintext. Choose an HtmlBody or
	// a TextBody to send an HTML-formatted or plaintext message, respectively.
	TextBody *string

	noSmithyDocumentSerde
}

// The minimum and maximum values of an attribute that is of the number type, for
// example custom:age .
type NumberAttributeConstraintsType struct {

	// The maximum length of a number attribute value. Must be a number less than or
	// equal to 2^1023 , represented as a string with a length of 131072 characters or
	// fewer.
	MaxValue *string

	// The minimum value of an attribute that is of the number data type.
	MinValue *string

	noSmithyDocumentSerde
}

// The password policy settings for a user pool, including complexity, history,
// and length requirements.
type PasswordPolicyType struct {

	// The minimum length of the password in the policy that you have set. This value
	// can't be less than 6.
	MinimumLength *int32

	// The number of previous passwords that you want Amazon Cognito to restrict each
	// user from reusing. Users can't set a password that matches any of n previous
	// passwords, where n is the value of PasswordHistorySize .
	PasswordHistorySize *int32

	// The requirement in a password policy that users must include at least one
	// lowercase letter in their password.
	RequireLowercase bool

	// The requirement in a password policy that users must include at least one
	// number in their password.
	RequireNumbers bool

	// The requirement in a password policy that users must include at least one
	// symbol in their password.
	RequireSymbols bool

	// The requirement in a password policy that users must include at least one
	// uppercase letter in their password.
	RequireUppercase bool

	// The number of days a temporary password is valid in the password policy. If the
	// user doesn't sign in during this time, an administrator must reset their
	// password. Defaults to 7 . If you submit a value of 0 , Amazon Cognito treats it
	// as a null value and sets TemporaryPasswordValidityDays to its default value.
	//
	// When you set TemporaryPasswordValidityDays for a user pool, you can no longer
	// set a value for the legacy UnusedAccountValidityDays parameter in that user
	// pool.
	TemporaryPasswordValidityDays int32

	noSmithyDocumentSerde
}

// The properties of a pre token generation Lambda trigger.
type PreTokenGenerationVersionConfigType struct {

	// The Amazon Resource Name (ARN) of the function that you want to assign to your
	// Lambda trigger.
	//
	// This parameter and the PreTokenGeneration property of LambdaConfig have the
	// same value. For new instances of pre token generation triggers, set LambdaArn .
	//
	// This member is required.
	LambdaArn *string

	// The user pool trigger version of the request that Amazon Cognito sends to your
	// Lambda function. Higher-numbered versions add fields that support new features.
	//
	// This member is required.
	LambdaVersion PreTokenGenerationLambdaVersionType

	noSmithyDocumentSerde
}

// The details of a user pool identity provider (IdP), including name and type.
type ProviderDescription struct {

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// The name of the IdP, for example MySAMLProvider .
	ProviderName *string

	// The type of the provider, for example SAML . Amazon Cognito supports SAML 2.0,
	// OIDC, and social IdPs. User pools list supported social IdPs by name in this
	// response parameter: Facebook, Google, Login with Amazon, and Sign in with Apple.
	ProviderType IdentityProviderTypeType

	noSmithyDocumentSerde
}

// The characteristics of a source or destination user for linking a federated
// user profile to a local user profile.
type ProviderUserIdentifierType struct {

	// The name of the provider attribute to link to, such as NameID .
	ProviderAttributeName *string

	// The value of the provider attribute to link to, such as xxxxx_account .
	ProviderAttributeValue *string

	// The name of the provider, such as Facebook, Google, or Login with Amazon.
	ProviderName *string

	noSmithyDocumentSerde
}

// A recovery option for a user. The AccountRecoverySettingType data type is an
// array of this object. Each RecoveryOptionType has a priority property that
// determines whether it is a primary or secondary option.
//
// For example, if verified_email has a priority of 1 and verified_phone_number
// has a priority of 2 , your user pool sends account-recovery messages to a
// verified email address but falls back to an SMS message if the user has a
// verified phone number. The admin_only option prevents self-service account
// recovery.
type RecoveryOptionType struct {

	// The recovery method that this object sets a recovery option for.
	//
	// This member is required.
	Name RecoveryOptionNameType

	// Your priority preference for using the specified attribute in account recovery.
	// The highest priority is 1 .
	//
	// This member is required.
	Priority *int32

	noSmithyDocumentSerde
}

// One custom scope associated with a user pool resource server. This data type is
// a member of ResourceServerScopeType . For more information, see [Scopes, M2M, and API authorization with resource servers].
//
// [Scopes, M2M, and API authorization with resource servers]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html
type ResourceServerScopeType struct {

	// A friendly description of a custom scope.
	//
	// This member is required.
	ScopeDescription *string

	// The name of the scope. Amazon Cognito renders custom scopes in the format
	// resourceServerIdentifier/ScopeName . For example, if this parameter is
	// exampleScope in the resource server with the identifier exampleResourceServer ,
	// you request and receive the scope exampleResourceServer/exampleScope .
	//
	// This member is required.
	ScopeName *string

	noSmithyDocumentSerde
}

// The details of a resource server configuration and associated custom scopes in
// a user pool.
type ResourceServerType struct {

	// A unique resource server identifier for the resource server. The identifier can
	// be an API friendly name like solar-system-data . You can also set an API URL
	// like https://solar-system-data-api.example.com as your identifier.
	//
	// Amazon Cognito represents scopes in the access token in the format
	// $resource-server-identifier/$scope . Longer scope-identifier strings increase
	// the size of your access tokens.
	Identifier *string

	// The name of the resource server.
	Name *string

	// A list of scopes that are defined for the resource server.
	Scopes []ResourceServerScopeType

	// The ID of the user pool that contains the resource server configuration.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The settings of risk configuration for threat protection with threat protection
// in a user pool.
type RiskConfigurationType struct {

	// The settings for automated responses and notification templates for adaptive
	// authentication with threat protection.
	AccountTakeoverRiskConfiguration *AccountTakeoverRiskConfigurationType

	// The app client where this configuration is applied. When this parameter isn't
	// present, the risk configuration applies to all user pool app clients that don't
	// have client-level settings.
	ClientId *string

	// Settings for compromised-credentials actions and authentication types with
	// threat protection in full-function ENFORCED mode.
	CompromisedCredentialsRiskConfiguration *CompromisedCredentialsRiskConfigurationType

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// Exceptions to the risk evaluation configuration, including always-allow and
	// always-block IP address ranges.
	RiskExceptionConfiguration *RiskExceptionConfigurationType

	// The ID of the user pool that has the risk configuration applied.
	UserPoolId *string

	noSmithyDocumentSerde
}

// Exceptions to the risk evaluation configuration, including always-allow and
// always-block IP address ranges.
type RiskExceptionConfigurationType struct {

	// An always-block IP address list. Overrides the risk decision and always blocks
	// authentication requests. This parameter is displayed and set in CIDR notation.
	BlockedIPRangeList []string

	// An always-allow IP address list. Risk detection isn't performed on the IP
	// addresses in this range list. This parameter is displayed and set in CIDR
	// notation.
	SkippedIPRangeList []string

	noSmithyDocumentSerde
}

// Configuration for the Amazon S3 bucket destination of user activity log export
// with threat protection.
type S3ConfigurationType struct {

	// The ARN of an Amazon S3 bucket that's the destination for threat protection log
	// export.
	BucketArn *string

	noSmithyDocumentSerde
}

// A list of the user attributes and their properties in your user pool. The
// attribute schema contains standard attributes, custom attributes with a custom:
// prefix, and developer attributes with a dev: prefix. For more information, see [User pool attributes].
//
// Developer-only dev: attributes are a legacy feature of user pools, and are
// read-only to all app clients. You can create and update developer-only
// attributes only with IAM-authenticated API operations. Use app client read/write
// permissions instead.
//
// [User pool attributes]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
type SchemaAttributeType struct {

	// The data format of the values for your attribute. When you choose an
	// AttributeDataType , Amazon Cognito validates the input against the data type. A
	// custom attribute value in your user's ID token is always a string, for example
	// "custom:isMember" : "true" or "custom:YearsAsMember" : "12" .
	AttributeDataType AttributeDataType

	// You should use [WriteAttributes] in the user pool client to control how attributes can be
	// mutated for new use cases instead of using DeveloperOnlyAttribute .
	//
	// Specifies whether the attribute type is developer only. This attribute can only
	// be modified by an administrator. Users won't be able to modify this attribute
	// using their access token. For example, DeveloperOnlyAttribute can be modified
	// using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.
	//
	// [WriteAttributes]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes
	DeveloperOnlyAttribute *bool

	// Specifies whether the value of the attribute can be changed.
	//
	// Any user pool attribute whose value you map from an IdP attribute must be
	// mutable, with a parameter value of true . Amazon Cognito updates mapped
	// attributes when users sign in to your application through an IdP. If an
	// attribute is immutable, Amazon Cognito throws an error when it attempts to
	// update the attribute. For more information, see [Specifying Identity Provider Attribute Mappings for Your User Pool].
	//
	// [Specifying Identity Provider Attribute Mappings for Your User Pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html
	Mutable *bool

	// The name of your user pool attribute. When you create or update a user pool,
	// adding a schema attribute creates a custom or developer-only attribute. When you
	// add an attribute with a Name value of MyAttribute , Amazon Cognito creates the
	// custom attribute custom:MyAttribute . When DeveloperOnlyAttribute is true ,
	// Amazon Cognito creates your attribute as dev:MyAttribute . In an operation that
	// describes a user pool, Amazon Cognito returns this value as value for standard
	// attributes, custom:value for custom attributes, and dev:value for
	// developer-only attributes..
	Name *string

	// Specifies the constraints for an attribute of the number type.
	NumberAttributeConstraints *NumberAttributeConstraintsType

	// Specifies whether a user pool attribute is required. If the attribute is
	// required and the user doesn't provide a value, registration or sign-in will
	// fail.
	Required *bool

	// Specifies the constraints for an attribute of the string type.
	StringAttributeConstraints *StringAttributeConstraintsType

	noSmithyDocumentSerde
}

// The policy for allowed types of authentication in a user pool. To activate this
// setting, your user pool must be in the [Essentials tier]or higher.
//
// [Essentials tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html
type SignInPolicyType struct {

	// The sign-in methods that a user pool supports as the first factor. You can
	// permit users to start authentication with a standard username and password, or
	// with other one-time password and hardware factors.
	AllowedFirstAuthFactors []AuthFactorType

	noSmithyDocumentSerde
}

// User pool configuration for delivery of SMS messages with Amazon Simple
// Notification Service. To send SMS messages with Amazon SNS in the Amazon Web
// Services Region that you want, the Amazon Cognito user pool uses an Identity and
// Access Management (IAM) role in your Amazon Web Services account.
type SmsConfigurationType struct {

	// The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the
	// IAM role in your Amazon Web Services account that Amazon Cognito will use to
	// send SMS messages. SMS messages are subject to a [spending limit].
	//
	// [spending limit]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html
	//
	// This member is required.
	SnsCallerArn *string

	// The external ID provides additional security for your IAM role. You can use an
	// ExternalId with the IAM role that you use with Amazon SNS to send SMS messages
	// for your user pool. If you provide an ExternalId , your Amazon Cognito user pool
	// includes it in the request to assume your IAM role. You can configure the role
	// trust policy to require that Amazon Cognito, and any principal, provide the
	// ExternalID . If you use the Amazon Cognito Management Console to create a role
	// for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with
	// the required permissions and a trust policy that demonstrates use of the
	// ExternalId .
	//
	// For more information about the ExternalId of a role, see [How to use an external ID when granting access to your Amazon Web Services resources to a third party].
	//
	// [How to use an external ID when granting access to your Amazon Web Services resources to a third party]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
	ExternalId *string

	// The Amazon Web Services Region to use with Amazon SNS integration. You can
	// choose the same Region as your user pool, or a supported Legacy Amazon SNS
	// alternate Region.
	//
	// Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region
	// must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For
	// more information, see [SMS message settings for Amazon Cognito user pools].
	//
	// [SMS message settings for Amazon Cognito user pools]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html
	SnsRegion *string

	noSmithyDocumentSerde
}

// The configuration of multi-factor authentication (MFA) with SMS messages in a
// user pool.
type SmsMfaConfigType struct {

	// The SMS authentication message that will be sent to users with the code they
	// must sign in with. The message must contain the {####} placeholder. Your user
	// pool replaces the placeholder with the MFA code. If this parameter isn't
	// provided, your user pool sends a default message.
	SmsAuthenticationMessage *string

	// User pool configuration for delivery of SMS messages with Amazon Simple
	// Notification Service. To send SMS messages with Amazon SNS in the Amazon Web
	// Services Region that you want, the Amazon Cognito user pool uses an Identity and
	// Access Management (IAM) role in your Amazon Web Services account.
	//
	// You can set SmsConfiguration in CreateUserPool and  UpdateUserPool , or in
	// SetUserPoolMfaConfig .
	SmsConfiguration *SmsConfigurationType

	noSmithyDocumentSerde
}

// A user's preference for using SMS message multi-factor authentication (MFA).
// Turns SMS MFA on and off, and can set SMS as preferred when other MFA options
// are available. You can't turn off SMS MFA for any of your users when MFA is
// required in your user pool; you can only set the type that your user prefers.
type SMSMfaSettingsType struct {

	// Specifies whether SMS message MFA is activated. If an MFA type is activated for
	// a user, the user will be prompted for MFA during all sign-in attempts, unless
	// device tracking is turned on and the device has been trusted.
	Enabled bool

	// Specifies whether SMS is the preferred MFA method. If true, your user pool
	// prompts the specified user for a code delivered by SMS message after
	// username-password sign-in succeeds.
	PreferredMfa bool

	noSmithyDocumentSerde
}

// Settings for time-based one-time password (TOTP) multi-factor authentication
// (MFA) in a user pool. Enables and disables availability of this feature.
type SoftwareTokenMfaConfigType struct {

	// The activation state of TOTP MFA.
	Enabled bool

	noSmithyDocumentSerde
}

// A user's preference for using time-based one-time password (TOTP) multi-factor
// authentication (MFA). Turns TOTP MFA on and off, and can set TOTP as preferred
// when other MFA options are available. You can't turn off TOTP MFA for any of
// your users when MFA is required in your user pool; you can only set the type
// that your user prefers.
type SoftwareTokenMfaSettingsType struct {

	// Specifies whether software token MFA is activated. If an MFA type is activated
	// for a user, the user will be prompted for MFA during all sign-in attempts,
	// unless device tracking is turned on and the device has been trusted.
	Enabled bool

	// Specifies whether software token MFA is the preferred MFA method.
	PreferredMfa bool

	noSmithyDocumentSerde
}

// The minimum and maximum length values of an attribute that is of the string
// type, for example custom:department .
type StringAttributeConstraintsType struct {

	// The maximum length of a string attribute value. Must be a number less than or
	// equal to 2^1023 , represented as a string with a length of 131072 characters or
	// fewer.
	MaxLength *string

	// The minimum length of a string attribute value.
	MinLength *string

	noSmithyDocumentSerde
}

// The time units that, with IdTokenValidity , AccessTokenValidity , and
// RefreshTokenValidity , set and display the duration of ID, access, and refresh
// tokens for an app client. You can assign a separate token validity unit to each
// type of token.
type TokenValidityUnitsType struct {

	//  A time unit for the value that you set in the AccessTokenValidity parameter.
	// The default AccessTokenValidity time unit is hours . AccessTokenValidity
	// duration can range from five minutes to one day.
	AccessToken TimeUnitsType

	// A time unit for the value that you set in the IdTokenValidity parameter. The
	// default IdTokenValidity time unit is hours . IdTokenValidity duration can range
	// from five minutes to one day.
	IdToken TimeUnitsType

	// A time unit for the value that you set in the RefreshTokenValidity parameter.
	// The default RefreshTokenValidity time unit is days . RefreshTokenValidity
	// duration can range from 60 minutes to 10 years.
	RefreshToken TimeUnitsType

	noSmithyDocumentSerde
}

// A container for the UI customization information for the hosted UI in a user
// pool.
type UICustomizationType struct {

	// The CSS values in the UI customization.
	CSS *string

	// The CSS version number.
	CSSVersion *string

	// The app client ID for your UI customization. When this value isn't present, the
	// customization applies to all user pool app clients that don't have client-level
	// settings..
	ClientId *string

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// A URL path to the hosted logo image of your UI customization.
	ImageUrl *string

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// The ID of the user pool with hosted UI customizations.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The settings for updates to user attributes. These settings include the
// property AttributesRequireVerificationBeforeUpdate , a user-pool setting that
// tells Amazon Cognito how to handle changes to the value of your users' email
// address and phone number attributes. For more information, see [Verifying updates to email addresses and phone numbers].
//
// [Verifying updates to email addresses and phone numbers]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates
type UserAttributeUpdateSettingsType struct {

	// Requires that your user verifies their email address, phone number, or both
	// before Amazon Cognito updates the value of that attribute. When you update a
	// user attribute that has this option activated, Amazon Cognito sends a
	// verification message to the new phone number or email address. Amazon Cognito
	// doesn’t change the value of the attribute until your user responds to the
	// verification message and confirms the new value.
	//
	// When AttributesRequireVerificationBeforeUpdate is false, your user pool doesn't
	// require that your users verify attribute changes before Amazon Cognito updates
	// them. In a user pool where AttributesRequireVerificationBeforeUpdate is false,
	// API operations that change attribute values can immediately update a user’s
	// email or phone_number attribute.
	AttributesRequireVerificationBeforeUpdate []VerifiedAttributeType

	noSmithyDocumentSerde
}

// Contextual data, such as the user's device fingerprint, IP address, or
// location, used for evaluating the risk of an unexpected event by Amazon Cognito
// threat protection.
type UserContextDataType struct {

	// Encoded device-fingerprint details that your app collected with the Amazon
	// Cognito context data collection library. For more information, see [Adding user device and session data to API requests].
	//
	// [Adding user device and session data to API requests]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint
	EncodedData *string

	// The source IP address of your user's device.
	IpAddress *string

	noSmithyDocumentSerde
}

// A user import job in a user pool. Describes the status of user import with a
// CSV file. For more information, see [Importing users into user pools from a CSV file].
//
// [Importing users into user pools from a CSV file]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-using-import-tool.html
type UserImportJobType struct {

	// The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for
	// the user import job. For more information, see "Creating the CloudWatch Logs IAM
	// Role" in the Amazon Cognito Developer Guide.
	CloudWatchLogsRoleArn *string

	// The date when the user import job was completed.
	CompletionDate *time.Time

	// The message returned when the user import job is completed.
	CompletionMessage *string

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// The number of users that couldn't be imported.
	FailedUsers int64

	// The number of users that were successfully imported.
	ImportedUsers int64

	// The ID of the user import job.
	JobId *string

	// The friendly name of the user import job.
	JobName *string

	// The pre-signed URL target for uploading the CSV file.
	PreSignedUrl *string

	// The number of users that were skipped.
	SkippedUsers int64

	// The date when the user import job was started.
	StartDate *time.Time

	// The status of the user import job. One of the following:
	//
	//   - Created - The job was created but not started.
	//
	//   - Pending - A transition state. You have started the job, but it has not begun
	//   importing users yet.
	//
	//   - InProgress - The job has started, and users are being imported.
	//
	//   - Stopping - You have stopped the job, but the job has not stopped importing
	//   users yet.
	//
	//   - Stopped - You have stopped the job, and the job has stopped importing users.
	//
	//   - Succeeded - The job has completed successfully.
	//
	//   - Failed - The job has stopped due to an error.
	//
	//   - Expired - You created a job, but did not start the job within 24-48 hours.
	//   All data associated with the job was deleted, and the job can't be started.
	Status UserImportJobStatusType

	// The ID of the user pool that the users are being imported into.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The configuration of a user pool for username case sensitivity.
type UsernameConfigurationType struct {

	// Specifies whether user name case sensitivity will be applied for all users in
	// the user pool through Amazon Cognito APIs. For most use cases, set case
	// sensitivity to False (case insensitive) as a best practice. When usernames and
	// email addresses are case insensitive, users can sign in as the same user when
	// they enter a different capitalization of their user name.
	//
	// Valid values include:
	//
	// true Enables case sensitivity for all username input. When this option is set
	// to true , users must sign in using the exact capitalization of their given
	// username, such as “UserName”. This is the default value.
	//
	// false Enables case insensitivity for all username input. For example, when this
	// option is set to false , users can sign in using username , USERNAME , or
	// UserName . This option also enables both preferred_username and email alias to
	// be case insensitive, in addition to the username attribute.
	//
	// This member is required.
	CaseSensitive *bool

	noSmithyDocumentSerde
}

// Contains settings for activation of threat protection, including the operating
// mode and additional authentication types. To log user security information but
// take no action, set to AUDIT . To configure automatic security responses to
// potentially unwanted traffic to your user pool, set to ENFORCED .
//
// For more information, see [Adding advanced security to a user pool]. To activate this setting, your user pool must be on
// the [Plus tier].
//
// [Plus tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html
// [Adding advanced security to a user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html
type UserPoolAddOnsType struct {

	// The operating mode of threat protection for standard authentication types in
	// your user pool, including username-password and secure remote password (SRP)
	// authentication.
	//
	// This member is required.
	AdvancedSecurityMode AdvancedSecurityModeType

	// Threat protection configuration options for additional authentication types in
	// your user pool, including custom authentication.
	AdvancedSecurityAdditionalFlows *AdvancedSecurityAdditionalFlowsType

	noSmithyDocumentSerde
}

// A short description of a user pool app client.
type UserPoolClientDescription struct {

	// The app client ID.
	ClientId *string

	// The app client name.
	ClientName *string

	// The ID of the user pool that's associated with the app client.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The configuration of a user pool client.
type UserPoolClientType struct {

	// The access token time limit. After this limit expires, your user can't use
	// their access token. To specify the time unit for AccessTokenValidity as seconds
	// , minutes , hours , or days , set a TokenValidityUnits value in your API
	// request.
	//
	// For example, when you set AccessTokenValidity to 10 and TokenValidityUnits to
	// hours , your user can authorize access with their access token for 10 hours.
	//
	// The default time unit for AccessTokenValidity in an API request is hours. Valid
	// range is displayed below in seconds.
	//
	// If you don't specify otherwise in the configuration of your app client, your
	// access tokens are valid for one hour.
	AccessTokenValidity *int32

	// The OAuth grant types that you want your app client to generate. To create an
	// app client that generates client credentials grants, you must add
	// client_credentials as the only allowed OAuth flow.
	//
	// code Use a code grant flow, which provides an authorization code as the
	// response. This code can be exchanged for access tokens with the /oauth2/token
	// endpoint.
	//
	// implicit Issue the access token (and, optionally, ID token, based on scopes)
	// directly to your user.
	//
	// client_credentials Issue the access token from the /oauth2/token endpoint
	// directly to a non-person user using a combination of the client ID and client
	// secret.
	AllowedOAuthFlows []OAuthFlowType

	// Set to true to use OAuth 2.0 authorization server features in your app client.
	//
	// This parameter must have a value of true before you can configure the following
	// features in your app client.
	//
	//   - CallBackURLs : Callback URLs.
	//
	//   - LogoutURLs : Sign-out redirect URLs.
	//
	//   - AllowedOAuthScopes : OAuth 2.0 scopes.
	//
	//   - AllowedOAuthFlows : Support for authorization code, implicit, and client
	//   credentials OAuth 2.0 grants.
	//
	// To use authorization server features, configure one of these features in the
	// Amazon Cognito console or set AllowedOAuthFlowsUserPoolClient to true in a
	// CreateUserPoolClient or UpdateUserPoolClient API request. If you don't set a
	// value for AllowedOAuthFlowsUserPoolClient in a request with the CLI or SDKs, it
	// defaults to false . When false , only SDK-based API sign-in is permitted.
	AllowedOAuthFlowsUserPoolClient *bool

	// The OAuth 2.0 scopes that you want your app client to support. Can include
	// standard OAuth scopes like phone , email , openid , and profile . Can also
	// include the aws.cognito.signin.user.admin scope that authorizes user profile
	// self-service operations and custom scopes from resource servers.
	AllowedOAuthScopes []string

	// The user pool analytics configuration for collecting metrics and sending them
	// to your Amazon Pinpoint campaign.
	//
	// In Amazon Web Services Regions where Amazon Pinpoint isn't available, user
	// pools only support sending events to Amazon Pinpoint projects in Amazon Web
	// Services Region us-east-1. In Regions where Amazon Pinpoint is available, user
	// pools support sending events to Amazon Pinpoint projects within that same
	// Region.
	AnalyticsConfiguration *AnalyticsConfigurationType

	// Amazon Cognito creates a session token for each API request in an
	// authentication flow. AuthSessionValidity is the duration, in minutes, of that
	// session token. Your user pool native user must respond to each authentication
	// challenge before the session expires.
	AuthSessionValidity *int32

	// A list of allowed redirect (callback) URLs for the IdPs.
	//
	// A redirect URI must:
	//
	//   - Be an absolute URI.
	//
	//   - Be registered with the authorization server.
	//
	//   - Not include a fragment component.
	//
	// See [OAuth 2.0 - Redirection Endpoint].
	//
	// Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing
	// purposes only.
	//
	// App callback URLs such as myapp://example are also supported.
	//
	// [OAuth 2.0 - Redirection Endpoint]: https://tools.ietf.org/html/rfc6749#section-3.1.2
	CallbackURLs []string

	// The ID of the app client.
	ClientId *string

	// The name of the app client.
	ClientName *string

	// The app client secret.
	ClientSecret *string

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// The default redirect URI. Must be in the CallbackURLs list.
	//
	// A redirect URI must:
	//
	//   - Be an absolute URI.
	//
	//   - Be registered with the authorization server.
	//
	//   - Not include a fragment component.
	//
	// See [OAuth 2.0 - Redirection Endpoint].
	//
	// Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing
	// purposes only.
	//
	// App callback URLs such as myapp://example are also supported.
	//
	// [OAuth 2.0 - Redirection Endpoint]: https://tools.ietf.org/html/rfc6749#section-3.1.2
	DefaultRedirectURI *string

	// When EnablePropagateAdditionalUserContextData is true, Amazon Cognito accepts
	// an IpAddress value that you send in the UserContextData parameter. The
	// UserContextData parameter sends information to Amazon Cognito threat protection
	// for risk analysis. You can send UserContextData when you sign in Amazon Cognito
	// native users with the InitiateAuth and RespondToAuthChallenge API operations.
	//
	// When EnablePropagateAdditionalUserContextData is false, you can't send your
	// user's source IP address to Amazon Cognito threat protection with
	// unauthenticated API operations. EnablePropagateAdditionalUserContextData
	// doesn't affect whether you can send a source IP address in a ContextData
	// parameter with the authenticated API operations AdminInitiateAuth and
	// AdminRespondToAuthChallenge .
	//
	// You can only activate EnablePropagateAdditionalUserContextData in an app client
	// that has a client secret. For more information about propagation of user context
	// data, see [Adding user device and session data to API requests].
	//
	// [Adding user device and session data to API requests]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint
	EnablePropagateAdditionalUserContextData *bool

	// Indicates whether token revocation is activated for the user pool client. When
	// you create a new user pool client, token revocation is activated by default.
	EnableTokenRevocation *bool

	// The [authentication flows] that you want your user pool client to support. For each app client in
	// your user pool, you can sign in your users with any combination of one or more
	// flows, including with a user name and Secure Remote Password (SRP), a user name
	// and password, or a custom authentication process that you define with Lambda
	// functions.
	//
	// If you don't specify a value for ExplicitAuthFlows , your app client supports
	// ALLOW_REFRESH_TOKEN_AUTH , ALLOW_USER_SRP_AUTH , and ALLOW_CUSTOM_AUTH .
	//
	// The values for authentication flow options include the following.
	//
	//   - ALLOW_USER_AUTH : Enable selection-based sign-in with USER_AUTH . This
	//   setting covers username-password, secure remote password (SRP), passwordless,
	//   and passkey authentication. This authentiation flow can do username-password and
	//   SRP authentication without other ExplicitAuthFlows permitting them. For
	//   example users can complete an SRP challenge through USER_AUTH without the flow
	//   USER_SRP_AUTH being active for the app client. This flow doesn't include
	//   CUSTOM_AUTH .
	//
	// To activate this setting, your user pool must be in the [Essentials tier]or higher.
	//
	//   - ALLOW_ADMIN_USER_PASSWORD_AUTH : Enable admin based user password
	//   authentication flow ADMIN_USER_PASSWORD_AUTH . This setting replaces the
	//   ADMIN_NO_SRP_AUTH setting. With this authentication flow, your app passes a
	//   user name and password to Amazon Cognito in the request, instead of using the
	//   Secure Remote Password (SRP) protocol to securely transmit the password.
	//
	//   - ALLOW_CUSTOM_AUTH : Enable Lambda trigger based authentication.
	//
	//   - ALLOW_USER_PASSWORD_AUTH : Enable user password-based authentication. In
	//   this flow, Amazon Cognito receives the password in the request instead of using
	//   the SRP protocol to verify passwords.
	//
	//   - ALLOW_USER_SRP_AUTH : Enable SRP-based authentication.
	//
	//   - ALLOW_REFRESH_TOKEN_AUTH : Enable authflow to refresh tokens.
	//
	// In some environments, you will see the values ADMIN_NO_SRP_AUTH ,
	// CUSTOM_AUTH_FLOW_ONLY , or USER_PASSWORD_AUTH . You can't assign these legacy
	// ExplicitAuthFlows values to user pool clients at the same time as values that
	// begin with ALLOW_ , like ALLOW_USER_SRP_AUTH .
	//
	// [authentication flows]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html
	// [Essentials tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html
	ExplicitAuthFlows []ExplicitAuthFlowsType

	// The ID token time limit. After this limit expires, your user can't use their ID
	// token. To specify the time unit for IdTokenValidity as seconds , minutes , hours
	// , or days , set a TokenValidityUnits value in your API request.
	//
	// For example, when you set IdTokenValidity as 10 and TokenValidityUnits as hours
	// , your user can authenticate their session with their ID token for 10 hours.
	//
	// The default time unit for IdTokenValidity in an API request is hours. Valid
	// range is displayed below in seconds.
	//
	// If you don't specify otherwise in the configuration of your app client, your ID
	// tokens are valid for one hour.
	IdTokenValidity *int32

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// A list of allowed logout URLs for the IdPs.
	LogoutURLs []string

	// When ENABLED , suppresses messages that might indicate a valid user exists when
	// someone attempts sign-in. This parameters sets your preference for the errors
	// and responses that you want Amazon Cognito APIs to return during authentication,
	// account confirmation, and password recovery when the user doesn't exist in the
	// user pool. When set to ENABLED and the user doesn't exist, authentication
	// returns an error indicating either the username or password was incorrect.
	// Account confirmation and password recovery return a response indicating a code
	// was sent to a simulated destination. When set to LEGACY , those APIs return a
	// UserNotFoundException exception if the user doesn't exist in the user pool.
	//
	// Defaults to LEGACY .
	PreventUserExistenceErrors PreventUserExistenceErrorTypes

	// The list of user attributes that you want your app client to have read access
	// to. After your user authenticates in your app, their access token authorizes
	// them to read their own attribute value for any attribute in this list.
	//
	// When you don't specify the ReadAttributes for your app client, your app can
	// read the values of email_verified , phone_number_verified , and the standard
	// attributes of your user pool. When your user pool app client has read access to
	// these default attributes, ReadAttributes doesn't return any information. Amazon
	// Cognito only populates ReadAttributes in the API response if you have specified
	// your own custom set of read attributes.
	ReadAttributes []string

	// The refresh token time limit. After this limit expires, your user can't use
	// their refresh token. To specify the time unit for RefreshTokenValidity as
	// seconds , minutes , hours , or days , set a TokenValidityUnits value in your
	// API request.
	//
	// For example, when you set RefreshTokenValidity as 10 and TokenValidityUnits as
	// days , your user can refresh their session and retrieve new access and ID tokens
	// for 10 days.
	//
	// The default time unit for RefreshTokenValidity in an API request is days. You
	// can't set RefreshTokenValidity to 0. If you do, Amazon Cognito overrides the
	// value with the default value of 30 days. Valid range is displayed below in
	// seconds.
	//
	// If you don't specify otherwise in the configuration of your app client, your
	// refresh tokens are valid for 30 days.
	RefreshTokenValidity int32

	// A list of provider names for the identity providers (IdPs) that are supported
	// on this client. The following are supported: COGNITO , Facebook , Google ,
	// SignInWithApple , and LoginWithAmazon . You can also specify the names that you
	// configured for the SAML and OIDC IdPs in your user pool, for example MySAMLIdP
	// or MyOIDCIdP .
	//
	// This parameter sets the IdPs that [managed login] will display on the login page for your app
	// client. The removal of COGNITO from this list doesn't prevent authentication
	// operations for local users with the user pools API in an Amazon Web Services
	// SDK. The only way to prevent SDK-based authentication is to block access with a [WAF rule]
	// .
	//
	// [WAF rule]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html
	// [managed login]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html
	SupportedIdentityProviders []string

	// The time units that, with IdTokenValidity , AccessTokenValidity , and
	// RefreshTokenValidity , set and display the duration of ID, access, and refresh
	// tokens for an app client. You can assign a separate token validity unit to each
	// type of token.
	TokenValidityUnits *TokenValidityUnitsType

	// The ID of the user pool associated with the app client.
	UserPoolId *string

	// The list of user attributes that you want your app client to have write access
	// to. After your user authenticates in your app, their access token authorizes
	// them to set or modify their own attribute value for any attribute in this list.
	//
	// When you don't specify the WriteAttributes for your app client, your app can
	// write the values of the Standard attributes of your user pool. When your user
	// pool has write access to these default attributes, WriteAttributes doesn't
	// return any information. Amazon Cognito only populates WriteAttributes in the
	// API response if you have specified your own custom set of write attributes.
	//
	// If your app client allows users to sign in through an IdP, this array must
	// include all attributes that you have mapped to IdP attributes. Amazon Cognito
	// updates mapped attributes when users sign in to your application through an IdP.
	// If your app client does not have write access to a mapped attribute, Amazon
	// Cognito throws an error when it tries to update the attribute. For more
	// information, see [Specifying IdP Attribute Mappings for Your user pool].
	//
	// [Specifying IdP Attribute Mappings for Your user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html
	WriteAttributes []string

	noSmithyDocumentSerde
}

// A short description of a user pool.
type UserPoolDescriptionType struct {

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// The user pool ID.
	Id *string

	// A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at
	// several possible stages of user pool operations. Triggers can modify the outcome
	// of the operations that invoked them.
	LambdaConfig *LambdaConfigType

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// The user pool name.
	Name *string

	// The user pool status.
	//
	// Deprecated: This property is no longer available.
	Status StatusType

	noSmithyDocumentSerde
}

// A list of user pool policies. Contains the policy that sets password-complexity
// requirements.
type UserPoolPolicyType struct {

	// The password policy settings for a user pool, including complexity, history,
	// and length requirements.
	PasswordPolicy *PasswordPolicyType

	// The policy for allowed types of authentication in a user pool.
	SignInPolicy *SignInPolicyType

	noSmithyDocumentSerde
}

// The configuration of a user pool.
type UserPoolType struct {

	// The available verified method a user can use to recover their password when
	// they call ForgotPassword . You can use this setting to define a preferred method
	// when a user has more than one method available. With this setting, SMS doesn't
	// qualify for a valid password recovery mechanism if the user also has SMS
	// multi-factor authentication (MFA) activated. In the absence of this setting,
	// Amazon Cognito uses the legacy behavior to determine the recovery method where
	// SMS is preferred through email.
	AccountRecoverySetting *AccountRecoverySettingType

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType

	// Attributes supported as an alias for this user pool. An alias is an attribute
	// that users can enter as an alternative username. Possible values: phone_number,
	// email, or preferred_username.
	AliasAttributes []AliasAttributeType

	// The Amazon Resource Name (ARN) of the user pool.
	Arn *string

	// The attributes that are auto-verified in a user pool.
	AutoVerifiedAttributes []VerifiedAttributeType

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	CreationDate *time.Time

	// A custom domain name that you provide to Amazon Cognito. This parameter applies
	// only if you use a custom domain to host the sign-up and sign-in pages for your
	// application. An example of a custom domain name might be auth.example.com .
	//
	// For more information about adding a custom domain to your user pool, see [Using Your Own Domain for the Hosted UI].
	//
	// [Using Your Own Domain for the Hosted UI]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
	CustomDomain *string

	// When active, DeletionProtection prevents accidental deletion of your user pool.
	// Before you can delete a user pool that you have protected against deletion, you
	// must deactivate this feature.
	//
	// When you try to delete a protected user pool in a DeleteUserPool API request,
	// Amazon Cognito returns an InvalidParameterException error. To delete a
	// protected user pool, send a new DeleteUserPool request after you deactivate
	// deletion protection in an UpdateUserPool API request.
	DeletionProtection DeletionProtectionType

	// The device-remembering configuration for a user pool. A null value indicates
	// that you have deactivated device remembering in your user pool.
	//
	// When you provide a value for any DeviceConfiguration field, you activate the
	// Amazon Cognito device-remembering feature.
	DeviceConfiguration *DeviceConfigurationType

	// The domain prefix, if the user pool has a domain associated with it.
	Domain *string

	// The email configuration of your user pool. The email configuration type sets
	// your preferred sending method, Amazon Web Services Region, and sender for
	// messages from your user pool.
	EmailConfiguration *EmailConfigurationType

	// Deprecated. Review error codes from API requests with
	// EventSource:cognito-idp.amazonaws.com in CloudTrail for information about
	// problems with user pool email configuration.
	EmailConfigurationFailure *string

	// This parameter is no longer used.
	EmailVerificationMessage *string

	// This parameter is no longer used.
	EmailVerificationSubject *string

	// A number estimating the size of the user pool.
	EstimatedNumberOfUsers int32

	// The ID of the user pool.
	Id *string

	// A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at
	// several possible stages of user pool operations. Triggers can modify the outcome
	// of the operations that invoked them.
	LambdaConfig *LambdaConfigType

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	LastModifiedDate *time.Time

	// Can be one of the following values:
	//
	//   - OFF - MFA tokens aren't required and can't be specified during user
	//   registration.
	//
	//   - ON - MFA tokens are required for all user registrations. You can only
	//   specify required when you're initially creating a user pool.
	//
	//   - OPTIONAL - Users have the option when registering to create an MFA token.
	MfaConfiguration UserPoolMfaType

	// The name of the user pool.
	Name *string

	// A list of user pool policies. Contains the policy that sets password-complexity
	// requirements.
	Policies *UserPoolPolicyType

	// A list of the user attributes and their properties in your user pool. The
	// attribute schema contains standard attributes, custom attributes with a custom:
	// prefix, and developer attributes with a dev: prefix. For more information, see [User pool attributes].
	//
	// Developer-only attributes are a legacy feature of user pools, and are read-only
	// to all app clients. You can create and update developer-only attributes only
	// with IAM-authenticated API operations. Use app client read/write permissions
	// instead.
	//
	// [User pool attributes]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
	SchemaAttributes []SchemaAttributeType

	// The contents of the SMS authentication message.
	SmsAuthenticationMessage *string

	// User pool configuration for delivery of SMS messages with Amazon Simple
	// Notification Service. To send SMS messages with Amazon SNS in the Amazon Web
	// Services Region that you want, the Amazon Cognito user pool uses an Identity and
	// Access Management (IAM) role in your Amazon Web Services account.
	SmsConfiguration *SmsConfigurationType

	// The reason why the SMS configuration can't send the messages to your users.
	//
	// This message might include comma-separated values to describe why your SMS
	// configuration can't send messages to user pool end users.
	//
	// InvalidSmsRoleAccessPolicyException The Identity and Access Management role
	// that Amazon Cognito uses to send SMS messages isn't properly configured. For
	// more information, see [SmsConfigurationType].
	//
	// SNSSandbox The Amazon Web Services account is in the SNS SMS Sandbox and
	// messages will only reach verified end users. This parameter won’t get populated
	// with SNSSandbox if the user creating the user pool doesn’t have SNS permissions.
	// To learn how to move your Amazon Web Services account out of the sandbox, see [Moving out of the SMS sandbox].
	//
	// [Moving out of the SMS sandbox]: https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html
	// [SmsConfigurationType]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html
	SmsConfigurationFailure *string

	// This parameter is no longer used.
	SmsVerificationMessage *string

	// This parameter is no longer used.
	//
	// Deprecated: This property is no longer available.
	Status StatusType

	// The settings for updates to user attributes. These settings include the
	// property AttributesRequireVerificationBeforeUpdate , a user-pool setting that
	// tells Amazon Cognito how to handle changes to the value of your users' email
	// address and phone number attributes. For more information, see [Verifying updates to email addresses and phone numbers].
	//
	// [Verifying updates to email addresses and phone numbers]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates
	UserAttributeUpdateSettings *UserAttributeUpdateSettingsType

	// Contains settings for activation of threat protection, including the operating
	// mode and additional authentication types. To log user security information but
	// take no action, set to AUDIT . To configure automatic security responses to
	// potentially unwanted traffic to your user pool, set to ENFORCED .
	//
	// For more information, see [Adding advanced security to a user pool]. To activate this setting, your user pool must be on
	// the [Plus tier].
	//
	// [Plus tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html
	// [Adding advanced security to a user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html
	UserPoolAddOns *UserPoolAddOnsType

	// The tags that are assigned to the user pool. A tag is a label that you can
	// apply to user pools to categorize and manage them in different ways, such as by
	// purpose, owner, environment, or other criteria.
	UserPoolTags map[string]string

	// The user pool [feature plan], or tier. This parameter determines the eligibility of the user
	// pool for features like managed login, access-token customization, and threat
	// protection. Defaults to ESSENTIALS .
	//
	// [feature plan]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html
	UserPoolTier UserPoolTierType

	// Specifies whether a user can use an email address or phone number as a username
	// when they sign up.
	UsernameAttributes []UsernameAttributeType

	// Case sensitivity of the username input for the selected sign-in option. When
	// case sensitivity is set to False (case insensitive), users can sign in with any
	// combination of capital and lowercase letters. For example, username , USERNAME ,
	// or UserName , or for email, email@example.com or EMaiL@eXamplE.Com . For most
	// use cases, set case sensitivity to False (case insensitive) as a best practice.
	// When usernames and email addresses are case insensitive, Amazon Cognito treats
	// any variation in case as the same user, and prevents a case variation from being
	// assigned to the same attribute for a different user.
	UsernameConfiguration *UsernameConfigurationType

	// The template for the verification message that your user pool delivers to users
	// who set an email address or phone number attribute.
	VerificationMessageTemplate *VerificationMessageTemplateType

	noSmithyDocumentSerde
}

// A user profile in a Amazon Cognito user pool.
type UserType struct {

	// Names and values of a user's attributes, for example email .
	Attributes []AttributeType

	// Indicates whether the user's account is enabled or disabled.
	Enabled bool

	// The user's MFA configuration.
	MFAOptions []MFAOptionType

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	UserCreateDate *time.Time

	// The date and time when the item was modified. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	UserLastModifiedDate *time.Time

	// The user status. This can be one of the following:
	//
	//   - UNCONFIRMED : User has been created but not confirmed.
	//
	//   - CONFIRMED : User has been confirmed.
	//
	//   - EXTERNAL_PROVIDER : User signed in with a third-party IdP.
	//
	//   - RESET_REQUIRED : User is confirmed, but the user must request a code and
	//   reset their password before they can sign in.
	//
	//   - FORCE_CHANGE_PASSWORD : The user is confirmed and the user can sign in using
	//   a temporary password, but on first sign-in, the user must change their password
	//   to a new value before doing anything else.
	//
	// The statuses ARCHIVED , UNKNOWN , and COMPROMISED are no longer used.
	UserStatus UserStatusType

	// The user's username.
	Username *string

	noSmithyDocumentSerde
}

// The template for the verification message that your user pool delivers to users
// who set an email address or phone number attribute.
type VerificationMessageTemplateType struct {

	// The configuration of verification emails to contain a clickable link or a
	// verification code.
	//
	// For link, your template body must contain link text in the format {##Click
	// here##} . "Click here" in the example is a customizable string. For code, your
	// template body must contain a code placeholder in the format {####} .
	DefaultEmailOption DefaultEmailOptionType

	// The template for email messages that Amazon Cognito sends to your users. You
	// can set an EmailMessage template only if the value of [EmailSendingAccount] is DEVELOPER . When your [EmailSendingAccount]
	// is DEVELOPER , your user pool sends email messages with your own Amazon SES
	// configuration.
	//
	// [EmailSendingAccount]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount
	EmailMessage *string

	// The email message template for sending a confirmation link to the user. You can
	// set an EmailMessageByLink template only if the value of [EmailSendingAccount] is DEVELOPER . When
	// your [EmailSendingAccount]is DEVELOPER , your user pool sends email messages with your own Amazon SES
	// configuration.
	//
	// [EmailSendingAccount]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount
	EmailMessageByLink *string

	// The subject line for the email message template. You can set an EmailSubject
	// template only if the value of [EmailSendingAccount]is DEVELOPER . When your [EmailSendingAccount] is DEVELOPER , your user
	// pool sends email messages with your own Amazon SES configuration.
	//
	// [EmailSendingAccount]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount
	EmailSubject *string

	// The subject line for the email message template for sending a confirmation link
	// to the user. You can set an EmailSubjectByLink template only if the value of [EmailSendingAccount]
	// is DEVELOPER . When your [EmailSendingAccount] is DEVELOPER , your user pool sends email messages
	// with your own Amazon SES configuration.
	//
	// [EmailSendingAccount]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount
	EmailSubjectByLink *string

	// The template for SMS messages that Amazon Cognito sends to your users.
	SmsMessage *string

	noSmithyDocumentSerde
}

// Settings for authentication (MFA) with passkey, or webauthN, biometric and
// security-key devices in a user pool. Configures the following:
//
//   - Configuration for requiring user-verification support in passkeys.
//
//   - The user pool relying-party ID. This is the domain, typically your user
//     pool domain, that user's passkey providers should trust as a receiver of passkey
//     authentication.
//
//   - The providers that you want to allow as origins for passkey authentication.
type WebAuthnConfigurationType struct {

	// Sets or displays the authentication domain, typically your user pool domain,
	// that passkey providers must use as a relying party (RP) in their configuration.
	//
	// Under the following conditions, the passkey relying party ID must be the
	// fully-qualified domain name of your custom domain:
	//
	//   - The user pool is configured for passkey authentication.
	//
	//   - The user pool has a custom domain, whether or not it also has a prefix
	//   domain.
	//
	//   - Your application performs authentication with managed login or the classic
	//   hosted UI.
	RelyingPartyId *string

	// When required , users can only register and sign in users with passkeys that are
	// capable of [user verification]. When preferred , your user pool doesn't require the use of
	// authenticators with user verification but encourages it.
	//
	// [user verification]: https://www.w3.org/TR/webauthn-2/#enum-userVerificationRequirement
	UserVerification UserVerificationType

	noSmithyDocumentSerde
}

// The details of a passkey, or webauthN, biometric or security-key authentication
// factor for a user.
type WebAuthnCredentialDescription struct {

	// Information about the transport methods of the passkey credential, for example
	// USB or Bluetooth Low Energy.
	//
	// This member is required.
	AuthenticatorTransports []string

	// The date and time when the item was created. Amazon Cognito returns this
	// timestamp in UNIX epoch time format. Your SDK might render the output in a
	// human-readable format like ISO 8601 or a Java Date object.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the passkey credential.
	//
	// This member is required.
	CredentialId *string

	// An automatically-generated friendly name for the passkey credential.
	//
	// This member is required.
	FriendlyCredentialName *string

	// The relying-party ID of the provider for the passkey credential.
	//
	// This member is required.
	RelyingPartyId *string

	// The general category of the passkey authenticator. Can be a platform, or
	// on-device authenticator like a built-in fingerprint scanner, or a cross-platform
	// device that's not attached to the device like a Bluetooth security key.
	AuthenticatorAttachment *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
