/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.label.CargoLabel;
import net.sf.freecol.client.gui.label.FreeColLabel;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public class CargoPanel
extends FreeColPanel
implements DropTarget,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(CargoPanel.class.getName());
    private Unit carrier = null;
    private DefaultTransferHandler defaultTransferHandler = new DefaultTransferHandler(this.getFreeColClient(), this);
    private boolean withStyling;

    public CargoPanel(FreeColClient freeColClient, boolean withTitle, boolean withStyling) {
        super(freeColClient, "CargoPanelUI", new MigLayout("wrap 6, gap 0 0, insets 0", "[79!, center][79!, center][79!, center][79!, center][79!, center][79!, center]", "[100!]"));
        this.withStyling = withStyling;
        if (withTitle) {
            this.setBorder(Utility.localizedBorder("cargoOnCarrier"));
        } else {
            this.setBorder(null);
        }
    }

    public void initialize() {
        this.addPropertyChangeListeners();
        this.update();
    }

    public void cleanup() {
        this.removePropertyChangeListeners();
    }

    protected void addPropertyChangeListeners() {
        if (this.carrier != null) {
            this.carrier.addPropertyChangeListener("CARGO_CHANGE", this);
            this.carrier.getGoodsContainer().addPropertyChangeListener(this);
        }
    }

    protected void removePropertyChangeListeners() {
        if (this.carrier != null) {
            this.carrier.removePropertyChangeListener("CARGO_CHANGE", this);
            this.carrier.getGoodsContainer().removePropertyChangeListener(this);
        }
    }

    public void update() {
        this.removeAll();
        if (this.carrier != null) {
            FreeColLabel label;
            FreeColClient fcc = this.getFreeColClient();
            DragListener dl = new DragListener(fcc, this);
            for (Unit unit : this.carrier.getUnitList()) {
                label = new UnitLabel(fcc, unit);
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(dl);
                }
                this.add(label);
            }
            for (Goods g : this.carrier.getGoodsList()) {
                label = new GoodsLabel(fcc, g);
                if (this.withStyling) {
                    label.setHorizontalTextPosition(0);
                    label.setVerticalTextPosition(3);
                    label.setForeground(Color.WHITE);
                }
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(dl);
                }
                this.add(label);
            }
        }
        this.updateTitle();
        this.revalidate();
        this.repaint();
    }

    public boolean isActive() {
        return this.carrier != null;
    }

    public Unit getCarrier() {
        return this.carrier;
    }

    public void setCarrier(Unit newCarrier) {
        if (newCarrier != this.carrier) {
            this.cleanup();
            this.carrier = newCarrier;
            this.initialize();
        }
    }

    private void updateTitle() {
        if (this.getBorder() == null) {
            return;
        }
        Utility.localizeBorder(this, this.carrier == null ? StringTemplate.key("cargoOnCarrier") : ((StringTemplate)StringTemplate.template("cargoPanel.cargoAndSpace").addStringTemplate("%name%", this.carrier.getLabel(Unit.UnitLabelType.NATIONAL))).addAmount("%space%", this.carrier.getSpaceLeft()));
    }

    @Override
    public boolean accepts(Goods goods) {
        return this.carrier != null && this.carrier.canAdd(goods);
    }

    @Override
    public boolean accepts(Unit unit) {
        return this.carrier != null && this.carrier.canAdd(unit);
    }

    @Override
    public Component add(Component comp, boolean editState) {
        if (this.carrier != null && comp instanceof CargoLabel && editState && ((CargoLabel)((Object)comp)).addCargo(comp, this.carrier, this)) {
            return comp;
        }
        return null;
    }

    @Override
    public int suggested(GoodsType type) {
        return this.carrier.getLoadableAmount(type);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("CargoPanel change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
        this.update();
    }

    @Override
    public void remove(Component comp) {
        if (comp instanceof CargoLabel) {
            ((CargoLabel)((Object)comp)).removeCargo(comp, this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.removePropertyChangeListeners();
        this.defaultTransferHandler = null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.withStyling) {
            return;
        }
        Dimension size = this.getSize();
        int cargoHoldsPerRow = 6;
        BufferedImage available = this.getImageLibrary().getScaledCargoHold(true);
        BufferedImage unavailable = this.getImageLibrary().getScaledCargoHold(false);
        int totalAvailableHolds = this.carrier != null ? this.carrier.getCargoCapacity() : 0;
        int rows = totalAvailableHolds / 6 + (totalAvailableHolds % 6 > 0 ? 1 : 0);
        if (rows == 0) {
            int x;
            for (x = 0; x < size.width; x += unavailable.getWidth()) {
                g.drawImage(unavailable, x, 0, null);
            }
            g.drawImage(unavailable, x, 0, null);
            return;
        }
        int y = 0;
        for (int row = 0; row < rows; ++row) {
            int availableHolds = row < rows - 1 ? 6 : totalAvailableHolds - 6 * row;
            int x = 0;
            for (int i = 0; i < availableHolds; ++i) {
                g.drawImage(available, x, y, null);
                x += available.getWidth();
            }
            while (x < size.width) {
                g.drawImage(unavailable, x, y, null);
                x += unavailable.getWidth();
            }
            g.drawImage(unavailable, x, y, null);
            y += available.getHeight();
        }
    }
}

