/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.NativeAIPlayer;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class TensionTest
extends FreeColTestCase {
    private static final TileType plainsType = TensionTest.spec().getTileType("model.tile.plains");

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testTension() {
        UnitType unitType;
        ServerGame game = ServerTestHelper.startServerGame(TensionTest.getTestMap(plainsType));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer european = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer indian = this.getServerPlayer(game, "model.nation.tupi");
        NativeAIPlayer indianAI = (NativeAIPlayer)aiMain.getAIPlayer(indian);
        Tension tension = indian.getTension(european);
        Stance stance = indian.getStance(european);
        TensionTest.assertTrue((tension != null && tension.getValue() == 0 ? 1 : 0) != 0);
        TensionTest.assertEquals((Object)Stance.UNCONTACTED, (Object)stance);
        TensionTest.assertFalse((boolean)indian.hasContacted(european));
        Tile tile = map.getTile(6, 9);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement is = builder.player(indian).settlementTile(tile).skillToTeach(null).capital(true).build();
        int unitCount = is.getType().getMaximumSize();
        for (int i = 0; i < unitCount; ++i) {
            unitType = TensionTest.spec().getDefaultUnitType(indian);
            ServerUnit unit = new ServerUnit(game, is, indian, unitType);
            unit.changeHomeIndianSettlement(is);
            if (i == 0) {
                unit.setLocation(tile);
                continue;
            }
            unit.setLocation(is);
        }
        Player.makeContact(indian, european);
        tension = indian.getTension(european);
        stance = indian.getStance(european);
        TensionTest.assertNotNull((Object)tension);
        TensionTest.assertEquals((Object)Stance.PEACE, (Object)stance);
        Tile tile2 = map.getTile(6, 8);
        unitType = TensionTest.spec().getUnitType("model.unit.hardyPioneer");
        ServerUnit unit1 = new ServerUnit(game, tile2, european, unitType);
        european.exploreForUnit(unit1);
        TensionTest.assertEquals((Object)indian, (Object)tile2.getOwner());
        igc.claimLand(european, tile2, null, -1);
        TensionTest.assertEquals((Object)european, (Object)tile2.getOwner());
        tension = indian.getTension(european);
        stance = indian.getStance(european);
        TensionTest.assertNotNull((Object)tension);
        TensionTest.assertEquals((int)200, (int)tension.getValue());
        TensionTest.assertEquals((Object)Stance.PEACE, (Object)stance);
        indianAI.secureIndianSettlement(is, new LogBuilder(0));
        tension = indian.getTension(european);
        stance = indian.getStance(european);
        TensionTest.assertNotNull((Object)tension);
        TensionTest.assertEquals((int)200, (int)tension.getValue());
        TensionTest.assertEquals((Object)Stance.PEACE, (Object)stance);
    }
}

