package proto

// Subset of possible errors.
const (
	ErrUnsupportedMethod                                   Error = 1
	ErrUnsupportedParameter                                Error = 2
	ErrUnexpectedEndOfFile                                 Error = 3
	ErrExpectedEndOfFile                                   Error = 4
	ErrCannotParseText                                     Error = 6
	ErrIncorrectNumberOfColumns                            Error = 7
	ErrThereIsNoColumn                                     Error = 8
	ErrSizesOfColumnsDoesntMatch                           Error = 9
	ErrNotFoundColumnInBlock                               Error = 10
	ErrPositionOutOfBound                                  Error = 11
	ErrParameterOutOfBound                                 Error = 12
	ErrSizesOfColumnsInTupleDoesntMatch                    Error = 13
	ErrDuplicateColumn                                     Error = 15
	ErrNoSuchColumnInTable                                 Error = 16
	ErrDelimiterInStringLiteralDoesntMatch                 Error = 17 // Deprecated: Error removed from ClickHouse
	ErrCannotInsertElementIntoConstantColumn               Error = 18 // Deprecated: Error removed from ClickHouse
	ErrSizeOfFixedStringDoesntMatch                        Error = 19
	ErrNumberOfColumnsDoesntMatch                          Error = 20
	ErrCannotReadAllDataFromTabSeparatedInput              Error = 21 // Deprecated: Error removed from ClickHouse
	ErrCannotParseAllValueFromTabSeparatedInput            Error = 22 // Deprecated: Error removed from ClickHouse
	ErrCannotReadFromIstream                               Error = 23
	ErrCannotWriteToOstream                                Error = 24
	ErrCannotParseEscapeSequence                           Error = 25
	ErrCannotParseQuotedString                             Error = 26
	ErrCannotParseInputAssertionFailed                     Error = 27
	ErrCannotPrintFloatOrDoubleNumber                      Error = 28
	ErrCannotPrintInteger                                  Error = 29 // Deprecated: Error removed from ClickHouse
	ErrCannotReadSizeOfCompressedChunk                     Error = 30 // Deprecated: Error removed from ClickHouse
	ErrCannotReadCompressedChunk                           Error = 31 // Deprecated: Error removed from ClickHouse
	ErrAttemptToReadAfterEOF                               Error = 32
	ErrCannotReadAllData                                   Error = 33
	ErrTooManyArgumentsForFunction                         Error = 34
	ErrTooFewArgumentsForFunction                          Error = 35
	ErrTooLessArgumentsForFunction                         Error = 35 // Deprecated: Use ErrTooFewArgumentsForFunction instead
	ErrBadArguments                                        Error = 36
	ErrUnknownElementInAst                                 Error = 37
	ErrCannotParseDate                                     Error = 38
	ErrTooLargeSizeCompressed                              Error = 39
	ErrChecksumDoesntMatch                                 Error = 40
	ErrCannotParseDatetime                                 Error = 41
	ErrNumberOfArgumentsDoesntMatch                        Error = 42
	ErrIllegalTypeOfArgument                               Error = 43
	ErrIllegalColumn                                       Error = 44
	ErrIllegalNumberOfResultColumns                        Error = 45 // Deprecated: Error removed from ClickHouse
	ErrUnknownFunction                                     Error = 46
	ErrUnknownIdentifier                                   Error = 47
	ErrNotImplemented                                      Error = 48
	ErrLogicalError                                        Error = 49
	ErrUnknownType                                         Error = 50
	ErrEmptyListOfColumnsQueried                           Error = 51
	ErrColumnQueriedMoreThanOnce                           Error = 52
	ErrTypeMismatch                                        Error = 53
	ErrStorageDoesntAllowParameters                        Error = 54 // Deprecated: Error removed from ClickHouse
	ErrStorageRequiresParameter                            Error = 55
	ErrUnknownStorage                                      Error = 56
	ErrTableAlreadyExists                                  Error = 57
	ErrTableMetadataAlreadyExists                          Error = 58
	ErrIllegalTypeOfColumnForFilter                        Error = 59
	ErrUnknownTable                                        Error = 60
	ErrOnlyFilterColumnInBlock                             Error = 61 // Deprecated: Error removed from ClickHouse
	ErrSyntaxError                                         Error = 62
	ErrUnknownAggregateFunction                            Error = 63
	ErrCannotReadAggregateFunctionFromText                 Error = 64 // Deprecated: Error removed from ClickHouse
	ErrCannotWriteAggregateFunctionAsText                  Error = 65 // Deprecated: Error removed from ClickHouse
	ErrNotAColumn                                          Error = 66 // Deprecated: Error removed from ClickHouse
	ErrIllegalKeyOfAggregation                             Error = 67 // Deprecated: Error removed from ClickHouse
	ErrCannotGetSizeOfField                                Error = 68
	ErrArgumentOutOfBound                                  Error = 69
	ErrCannotConvertType                                   Error = 70
	ErrCannotWriteAfterEndOfBuffer                         Error = 71
	ErrCannotParseNumber                                   Error = 72
	ErrUnknownFormat                                       Error = 73
	ErrCannotReadFromFileDescriptor                        Error = 74
	ErrCannotWriteToFileDescriptor                         Error = 75
	ErrCannotOpenFile                                      Error = 76
	ErrCannotCloseFile                                     Error = 77
	ErrUnknownTypeOfQuery                                  Error = 78
	ErrIncorrectFileName                                   Error = 79
	ErrIncorrectQuery                                      Error = 80
	ErrUnknownDatabase                                     Error = 81
	ErrDatabaseAlreadyExists                               Error = 82
	ErrDirectoryDoesntExist                                Error = 83
	ErrDirectoryAlreadyExists                              Error = 84
	ErrFormatIsNotSuitableForInput                         Error = 85
	ErrReceivedErrorFromRemoteIoServer                     Error = 86 // Deprecated: Use ErrReceivedErrorFromRemoteIOServer instead
	ErrReceivedErrorFromRemoteIOServer                     Error = 86
	ErrCannotSeekThroughFile                               Error = 87
	ErrCannotTruncateFile                                  Error = 88
	ErrUnknownCompressionMethod                            Error = 89
	ErrEmptyListOfColumnsPassed                            Error = 90
	ErrSizesOfMarksFilesAreInconsistent                    Error = 91
	ErrEmptyDataPassed                                     Error = 92
	ErrUnknownAggregatedDataVariant                        Error = 93
	ErrCannotMergeDifferentAggregatedDataVariants          Error = 94
	ErrCannotReadFromSocket                                Error = 95
	ErrCannotWriteToSocket                                 Error = 96
	ErrCannotReadAllDataFromChunkedInput                   Error = 97 // Deprecated: Error removed from ClickHouse
	ErrCannotWriteToEmptyBlockOutputStream                 Error = 98 // Deprecated: Error removed from ClickHouse
	ErrUnknownPacketFromClient                             Error = 99
	ErrUnknownPacketFromServer                             Error = 100
	ErrUnexpectedPacketFromClient                          Error = 101
	ErrUnexpectedPacketFromServer                          Error = 102
	ErrReceivedDataForWrongQueryID                         Error = 103 // Deprecated: Error removed from ClickHouse
	ErrTooSmallBufferSize                                  Error = 104
	ErrCannotReadHistory                                   Error = 105 // Deprecated: Error removed from ClickHouse
	ErrCannotAppendHistory                                 Error = 106 // Deprecated: Error removed from ClickHouse
	ErrFileDoesntExist                                     Error = 107
	ErrNoDataToInsert                                      Error = 108
	ErrCannotBlockSignal                                   Error = 109
	ErrCannotUnblockSignal                                 Error = 110
	ErrCannotManipulateSigset                              Error = 111
	ErrCannotWaitForSignal                                 Error = 112
	ErrThereIsNoSession                                    Error = 113
	ErrCannotClockGettime                                  Error = 114
	ErrUnknownSetting                                      Error = 115
	ErrThereIsNoDefaultValue                               Error = 116
	ErrIncorrectData                                       Error = 117
	ErrEngineRequired                                      Error = 119
	ErrCannotInsertValueOfDifferentSizeIntoTuple           Error = 120
	ErrUnsupportedJoinKeys                                 Error = 121
	ErrUnknownSetDataVariant                               Error = 121 // Deprecated: Use ErrUnsupportedJoinKeys instead
	ErrIncompatibleColumns                                 Error = 122
	ErrUnknownTypeOfAstNode                                Error = 123
	ErrIncorrectElementOfSet                               Error = 124
	ErrIncorrectResultOfScalarSubquery                     Error = 125
	ErrCannotGetReturnType                                 Error = 126 // Deprecated: Error removed from ClickHouse
	ErrIllegalIndex                                        Error = 127
	ErrTooLargeArraySize                                   Error = 128
	ErrFunctionIsSpecial                                   Error = 129
	ErrCannotReadArrayFromText                             Error = 130
	ErrTooLargeStringSize                                  Error = 131
	ErrCannotCreateTableFromMetadata                       Error = 132 // Deprecated: Error removed from ClickHouse
	ErrAggregateFunctionDoesntAllowParameters              Error = 133
	ErrParametersToAggregateFunctionsMustBeLiterals        Error = 134
	ErrZeroArrayOrTupleIndex                               Error = 135
	ErrUnknownElementInConfig                              Error = 137
	ErrExcessiveElementInConfig                            Error = 138
	ErrNoElementsInConfig                                  Error = 139
	ErrAllRequestedColumnsAreMissing                       Error = 140 // Deprecated: Error removed from ClickHouse
	ErrSamplingNotSupported                                Error = 141
	ErrNotFoundNode                                        Error = 142
	ErrFoundMoreThanOneNode                                Error = 143 // Deprecated: Error removed from ClickHouse
	ErrFirstDateIsBiggerThanLastDate                       Error = 144 // Deprecated: Error removed from ClickHouse
	ErrUnknownOverflowMode                                 Error = 145
	ErrQuerySectionDoesntMakeSense                         Error = 146 // Deprecated: Error removed from ClickHouse
	ErrNotFoundFunctionElementForAggregate                 Error = 147 // Deprecated: Error removed from ClickHouse
	ErrNotFoundRelationElementForCondition                 Error = 148 // Deprecated: Error removed from ClickHouse
	ErrNotFoundRHSElementForCondition                      Error = 149 // Deprecated: Error removed from ClickHouse
	ErrNoAttributesListed                                  Error = 150 // Deprecated: Error removed from ClickHouse
	ErrIndexOfColumnInSortClauseIsOutOfRange               Error = 151 // Deprecated: Error removed from ClickHouse
	ErrUnknownDirectionOfSorting                           Error = 152
	ErrIllegalDivision                                     Error = 153
	ErrAggregateFunctionNotApplicable                      Error = 154 // Deprecated: Error removed from ClickHouse
	ErrUnknownRelation                                     Error = 155 // Deprecated: Error removed from ClickHouse
	ErrDictionariesWasNotLoaded                            Error = 156
	ErrIllegalOverflowMode                                 Error = 157 // Deprecated: Error removed from ClickHouse
	ErrTooManyRows                                         Error = 158
	ErrTimeoutExceeded                                     Error = 159
	ErrTooSlow                                             Error = 160
	ErrTooManyColumns                                      Error = 161
	ErrTooDeepSubqueries                                   Error = 162
	ErrTooDeepPipeline                                     Error = 163 // Deprecated: Error removed from ClickHouse
	ErrReadonly                                            Error = 164
	ErrTooManyTemporaryColumns                             Error = 165
	ErrTooManyTemporaryNonConstColumns                     Error = 166
	ErrTooDeepAst                                          Error = 167
	ErrTooBigAst                                           Error = 168
	ErrBadTypeOfField                                      Error = 169
	ErrBadGet                                              Error = 170
	ErrBlocksHaveDifferentStructure                        Error = 171 // Deprecated: Error removed from ClickHouse
	ErrCannotCreateDirectory                               Error = 172
	ErrCannotAllocateMemory                                Error = 173
	ErrCyclicAliases                                       Error = 174
	ErrChunkNotFound                                       Error = 176 // Deprecated: Error removed from ClickHouse
	ErrDuplicateChunkName                                  Error = 177 // Deprecated: Error removed from ClickHouse
	ErrMultipleAliasesForExpression                        Error = 178 // Deprecated: Error removed from ClickHouse
	ErrMultipleExpressionsForAlias                         Error = 179
	ErrThereIsNoProfile                                    Error = 180
	ErrIllegalFinal                                        Error = 181
	ErrIllegalPrewhere                                     Error = 182
	ErrUnexpectedExpression                                Error = 183
	ErrIllegalAggregation                                  Error = 184
	ErrUnsupportedMyisamBlockType                          Error = 185 // Deprecated: Error removed from ClickHouse
	ErrUnsupportedCollationLocale                          Error = 186
	ErrCollationComparisonFailed                           Error = 187
	ErrUnknownAction                                       Error = 188 // Deprecated: Error removed from ClickHouse
	ErrTableMustNotBeCreatedManually                       Error = 189 // Deprecated: Error removed from ClickHouse
	ErrSizesOfArraysDontMatch                              Error = 190
	ErrSizesOfArraysDoesntMatch                            Error = 190 // Deprecated: Use ErrSizesOfArraysDontMatch instead
	ErrSetSizeLimitExceeded                                Error = 191
	ErrUnknownUser                                         Error = 192
	ErrWrongPassword                                       Error = 193
	ErrRequiredPassword                                    Error = 194
	ErrIPAddressNotAllowed                                 Error = 195
	ErrUnknownAddressPatternType                           Error = 196
	ErrServerRevisionIsTooOld                              Error = 197 // Deprecated: Error removed from ClickHouse
	ErrDNSError                                            Error = 198
	ErrUnknownQuota                                        Error = 199
	ErrQuotaDoesntAllowKeys                                Error = 200 // Deprecated: Error removed from ClickHouse
	ErrQuotaExpired                                        Error = 201 // Deprecated: Use ErrQuotaExceeded instead
	ErrQuotaExceeded                                       Error = 201
	ErrTooManySimultaneousQueries                          Error = 202
	ErrNoFreeConnection                                    Error = 203
	ErrCannotFsync                                         Error = 204
	ErrNestedTypeTooDeep                                   Error = 205 // Deprecated: Error removed from ClickHouse
	ErrAliasRequired                                       Error = 206
	ErrAmbiguousIdentifier                                 Error = 207
	ErrEmptyNestedTable                                    Error = 208
	ErrSocketTimeout                                       Error = 209
	ErrNetworkError                                        Error = 210
	ErrEmptyQuery                                          Error = 211
	ErrUnknownLoadBalancing                                Error = 212
	ErrUnknownTotalsMode                                   Error = 213
	ErrCannotStatvfs                                       Error = 214
	ErrNotAnAggregate                                      Error = 215
	ErrQueryWithSameIDIsAlreadyRunning                     Error = 216
	ErrClientHasConnectedToWrongPort                       Error = 217
	ErrTableIsDropped                                      Error = 218
	ErrDatabaseNotEmpty                                    Error = 219
	ErrDuplicateInterserverIOEndpoint                      Error = 220
	ErrDuplicateInterserverIoEndpoint                      Error = 220 // Deprecated: Use ErrDuplicateInterserverIOEndpoint instead
	ErrNoSuchInterserverIoEndpoint                         Error = 221 // Deprecated: Use ErrNoSuchInterserverIOEndpoint instead
	ErrNoSuchInterserverIOEndpoint                         Error = 221
	ErrAddingReplicaToNonEmptyTable                        Error = 222 // Deprecated: Error removed from ClickHouse
	ErrUnexpectedAstStructure                              Error = 223
	ErrReplicaIsAlreadyActive                              Error = 224
	ErrNoZookeeper                                         Error = 225
	ErrNoFileInDataPart                                    Error = 226
	ErrUnexpectedFileInDataPart                            Error = 227
	ErrBadSizeOfFileInDataPart                             Error = 228
	ErrQueryIsTooLarge                                     Error = 229
	ErrNotFoundExpectedDataPart                            Error = 230
	ErrTooManyUnexpectedDataParts                          Error = 231
	ErrNoSuchDataPart                                      Error = 232
	ErrBadDataPartName                                     Error = 233
	ErrNoReplicaHasPart                                    Error = 234
	ErrDuplicateDataPart                                   Error = 235
	ErrAborted                                             Error = 236
	ErrNoReplicaNameGiven                                  Error = 237
	ErrFormatVersionTooOld                                 Error = 238
	ErrCannotMunmap                                        Error = 239
	ErrCannotMremap                                        Error = 240
	ErrMemoryLimitExceeded                                 Error = 241
	ErrTableIsReadOnly                                     Error = 242
	ErrNotEnoughSpace                                      Error = 243
	ErrUnexpectedZookeeperError                            Error = 244
	ErrCorruptedData                                       Error = 246
	ErrIncorrectMark                                       Error = 247 // Deprecated: Error removed from ClickHouse
	ErrInvalidPartitionValue                               Error = 248
	ErrNotEnoughBlockNumbers                               Error = 250 // Deprecated: Error removed from ClickHouse
	ErrNoSuchReplica                                       Error = 251
	ErrTooManyParts                                        Error = 252
	ErrReplicaIsAlreadyExist                               Error = 253 // Deprecated: Use ErrReplicaAlreadyExists instead
	ErrReplicaAlreadyExists                                Error = 253
	ErrNoActiveReplicas                                    Error = 254
	ErrTooManyRetriesToFetchParts                          Error = 255
	ErrPartitionAlreadyExists                              Error = 256
	ErrPartitionDoesntExist                                Error = 257
	ErrUnionAllResultStructuresMismatch                    Error = 258
	ErrClientOutputFormatSpecified                         Error = 260
	ErrUnknownBlockInfoField                               Error = 261
	ErrBadCollation                                        Error = 262
	ErrCannotCompileCode                                   Error = 263
	ErrIncompatibleTypeOfJoin                              Error = 264
	ErrNoAvailableReplica                                  Error = 265
	ErrMismatchReplicasDataSources                         Error = 266
	ErrStorageDoesntSupportParallelReplicas                Error = 267 // Deprecated: Error removed from ClickHouse
	ErrCPUIDError                                          Error = 268 // Deprecated: Error removed from ClickHouse
	ErrInfiniteLoop                                        Error = 269
	ErrCannotCompress                                      Error = 270
	ErrCannotDecompress                                    Error = 271
	ErrCannotIOSubmit                                      Error = 272
	ErrAioSubmitError                                      Error = 272 // Deprecated: Use ErrCannotIOSubmit instead
	ErrCannotIOGetevents                                   Error = 273
	ErrAioCompletionError                                  Error = 273 // Deprecated: Use ErrCannotIOGetevents instead
	ErrAioReadError                                        Error = 274
	ErrAioWriteError                                       Error = 275
	ErrIndexNotUsed                                        Error = 277
	ErrLeadershipLost                                      Error = 278 // Deprecated: Error removed from ClickHouse
	ErrAllConnectionTriesFailed                            Error = 279
	ErrNoAvailableData                                     Error = 280
	ErrDictionaryIsEmpty                                   Error = 281
	ErrIncorrectIndex                                      Error = 282
	ErrUnknownDistributedProductMode                       Error = 283
	ErrWrongGlobalSubquery                                 Error = 284
	ErrUnknownGlobalSubqueriesMethod                       Error = 284 // Deprecated: Use ErrWrongGlobalSubquery instead
	ErrTooFewLiveReplicas                                  Error = 285
	ErrTooLessLiveReplicas                                 Error = 285 // Deprecated: Use ErrTooFewLiveReplicas instead
	ErrUnsatisfiedQuorumForPreviousWrite                   Error = 286
	ErrUnknownFormatVersion                                Error = 287
	ErrDistributedInJoinSubqueryDenied                     Error = 288
	ErrReplicaIsNotInQuorum                                Error = 289
	ErrLimitExceeded                                       Error = 290
	ErrDatabaseAccessDenied                                Error = 291
	ErrLeadershipChanged                                   Error = 292 // Deprecated: Error removed from ClickHouse
	ErrMongodbCannotAuthenticate                           Error = 293
	ErrCannotWriteToFile                                   Error = 294
	ErrInvalidBlockExtraInfo                               Error = 294 // Deprecated: Use ErrCannotWriteToFile instead
	ErrReceivedEmptyData                                   Error = 295
	ErrNoRemoteShardFound                                  Error = 296 // Deprecated: Error removed from ClickHouse
	ErrShardHasNoConnections                               Error = 297
	ErrCannotPipe                                          Error = 298
	ErrCannotFork                                          Error = 299
	ErrCannotDlsym                                         Error = 300
	ErrCannotCreateChildProcess                            Error = 301
	ErrChildWasNotExitedNormally                           Error = 302
	ErrCannotSelect                                        Error = 303
	ErrCannotWaitpid                                       Error = 304
	ErrTableWasNotDropped                                  Error = 305
	ErrTooDeepRecursion                                    Error = 306
	ErrTooManyBytes                                        Error = 307
	ErrUnexpectedNodeInZookeeper                           Error = 308
	ErrFunctionCannotHaveParameters                        Error = 309
	ErrInvalidShardWeight                                  Error = 317 // Deprecated: Error removed from ClickHouse
	ErrInvalidConfigParameter                              Error = 318
	ErrUnknownStatusOfInsert                               Error = 319
	ErrValueIsOutOfRangeOfDataType                         Error = 321
	ErrBarrierTimeout                                      Error = 335 // Deprecated: Error removed from ClickHouse
	ErrUnknownDatabaseEngine                               Error = 336
	ErrDdlGuardIsActive                                    Error = 337 // Deprecated: Error removed from ClickHouse
	ErrUnfinished                                          Error = 341
	ErrMetadataMismatch                                    Error = 342
	ErrSupportIsDisabled                                   Error = 344
	ErrTableDiffersTooMuch                                 Error = 345
	ErrCannotConvertCharset                                Error = 346
	ErrCannotLoadConfig                                    Error = 347
	ErrCannotInsertNullInOrdinaryColumn                    Error = 349
	ErrIncompatibleSourceTables                            Error = 350 // Deprecated: Error removed from ClickHouse
	ErrAmbiguousTableName                                  Error = 351 // Deprecated: Error removed from ClickHouse
	ErrAmbiguousColumnName                                 Error = 352
	ErrIndexOfPositionalArgumentIsOutOfRange               Error = 353
	ErrZlibInflateFailed                                   Error = 354
	ErrZlibDeflateFailed                                   Error = 355
	ErrBadLambda                                           Error = 356 // Deprecated: Error removed from ClickHouse
	ErrReservedIdentifierName                              Error = 357 // Deprecated: Error removed from ClickHouse
	ErrIntoOutfileNotAllowed                               Error = 358
	ErrTableSizeExceedsMaxDropSizeLimit                    Error = 359
	ErrCannotCreateCharsetConverter                        Error = 360
	ErrSeekPositionOutOfBound                              Error = 361
	ErrCurrentWriteBufferIsExhausted                       Error = 362
	ErrCannotCreateIoBuffer                                Error = 363 // Deprecated: Use ErrCannotCreateIOBuffer instead
	ErrCannotCreateIOBuffer                                Error = 363
	ErrReceivedErrorTooManyRequests                        Error = 364
	ErrOutputIsNotSorted                                   Error = 365 // Deprecated: Error removed from ClickHouse
	ErrSizesOfNestedColumnsAreInconsistent                 Error = 366
	ErrTooManyFetches                                      Error = 367 // Deprecated: Error removed from ClickHouse
	ErrBadCast                                             Error = 368 // Deprecated: Error removed from ClickHouse
	ErrAllReplicasAreStale                                 Error = 369
	ErrDataTypeCannotBeUsedInTables                        Error = 370
	ErrInconsistentClusterDefinition                       Error = 371
	ErrSessionNotFound                                     Error = 372
	ErrSessionIsLocked                                     Error = 373
	ErrInvalidSessionTimeout                               Error = 374
	ErrCannotDlopen                                        Error = 375
	ErrCannotParseUUID                                     Error = 376
	ErrIllegalSyntaxForDataType                            Error = 377
	ErrDataTypeCannotHaveArguments                         Error = 378
	ErrUnknownStatusOfDistributedDdlTask                   Error = 379 // Deprecated: Error removed from ClickHouse
	ErrCannotKill                                          Error = 380
	ErrHTTPLengthRequired                                  Error = 381
	ErrCannotLoadCatboostModel                             Error = 382
	ErrCannotApplyCatboostModel                            Error = 383
	ErrPartIsTemporarilyLocked                             Error = 384
	ErrMultipleStreamsRequired                             Error = 385
	ErrNoCommonType                                        Error = 386
	ErrExternalLoadableAlreadyExists                       Error = 387 // Deprecated: Use ErrDictionaryAlreadyExists instead
	ErrDictionaryAlreadyExists                             Error = 387
	ErrCannotAssignOptimize                                Error = 388
	ErrInsertWasDeduplicated                               Error = 389
	ErrCannotGetCreateTableQuery                           Error = 390
	ErrExternalLibraryError                                Error = 391
	ErrQueryIsProhibited                                   Error = 392
	ErrThereIsNoQuery                                      Error = 393
	ErrQueryWasCancelled                                   Error = 394
	ErrFunctionThrowIfValueIsNonZero                       Error = 395
	ErrTooManyRowsOrBytes                                  Error = 396
	ErrQueryIsNotSupportedInMaterializedView               Error = 397
	ErrUnknownMutationCommand                              Error = 398
	ErrFormatIsNotSuitableForOutput                        Error = 399
	ErrCannotStat                                          Error = 400
	ErrFeatureIsNotEnabledAtBuildTime                      Error = 401
	ErrCannotIosetup                                       Error = 402
	ErrInvalidJoinOnExpression                             Error = 403
	ErrBadOdbcConnectionString                             Error = 404
	ErrTopAndLimitTogether                                 Error = 406
	ErrDecimalOverflow                                     Error = 407
	ErrBadRequestParameter                                 Error = 408
	ErrExternalServerIsNotResponding                       Error = 410
	ErrPthreadError                                        Error = 411
	ErrNetlinkError                                        Error = 412
	ErrCannotSetSignalHandler                              Error = 413
	ErrAllReplicasLost                                     Error = 415
	ErrReplicaStatusChanged                                Error = 416
	ErrExpectedAllOrAny                                    Error = 417
	ErrUnknownJoin                                         Error = 418
	ErrMultipleAssignmentsToColumn                         Error = 419
	ErrCannotUpdateColumn                                  Error = 420
	ErrCannotAddDifferentAggregateStates                   Error = 421
	ErrUnsupportedURIScheme                                Error = 422
	ErrCannotGettimeofday                                  Error = 423
	ErrCannotLink                                          Error = 424
	ErrSystemError                                         Error = 425
	ErrCannotCompileRegexp                                 Error = 427
	ErrFailedToGetpwuid                                    Error = 429
	ErrMismatchingUsersForProcessAndData                   Error = 430
	ErrIllegalSyntaxForCodecType                           Error = 431
	ErrUnknownCodec                                        Error = 432
	ErrIllegalCodecParameter                               Error = 433
	ErrCannotParseProtobufSchema                           Error = 434
	ErrNoColumnSerializedToRequiredProtobufField           Error = 435
	ErrProtobufBadCast                                     Error = 436
	ErrProtobufFieldNotRepeated                            Error = 437
	ErrDataTypeCannotBePromoted                            Error = 438
	ErrCannotScheduleTask                                  Error = 439
	ErrInvalidLimitExpression                              Error = 440
	ErrCannotParseDomainValueFromString                    Error = 441
	ErrBadDatabaseForTemporaryTable                        Error = 442
	ErrNoColumnsSerializedToProtobufFields                 Error = 443
	ErrUnknownProtobufFormat                               Error = 444
	ErrCannotMprotect                                      Error = 445
	ErrFunctionNotAllowed                                  Error = 446
	ErrHyperscanCannotScanText                             Error = 447
	ErrBrotliReadFailed                                    Error = 448
	ErrBrotliWriteFailed                                   Error = 449
	ErrBadTTLExpression                                    Error = 450
	ErrBadTTLFile                                          Error = 451
	ErrSettingConstraintViolation                          Error = 452
	ErrMysqlClientInsufficientCapabilities                 Error = 453
	ErrOpensslError                                        Error = 454
	ErrSuspiciousTypeForLowCardinality                     Error = 455
	ErrUnknownQueryParameter                               Error = 456
	ErrBadQueryParameter                                   Error = 457
	ErrCannotUnlink                                        Error = 458
	ErrCannotSetThreadPriority                             Error = 459
	ErrCannotCreateTimer                                   Error = 460
	ErrCannotSetTimerPeriod                                Error = 461
	ErrCannotFcntl                                         Error = 463
	ErrCannotParseElf                                      Error = 464
	ErrCannotParseDwarf                                    Error = 465
	ErrInsecurePath                                        Error = 466
	ErrCannotParseBool                                     Error = 467
	ErrCannotPthreadAttr                                   Error = 468
	ErrViolatedConstraint                                  Error = 469
	ErrInvalidSettingValue                                 Error = 471
	ErrReadonlySetting                                     Error = 472
	ErrDeadlockAvoided                                     Error = 473
	ErrInvalidTemplateFormat                               Error = 474
	ErrInvalidWithFillExpression                           Error = 475
	ErrWithTiesWithoutOrderBy                              Error = 476
	ErrInvalidUsageOfInput                                 Error = 477
	ErrUnknownPolicy                                       Error = 478
	ErrUnknownDisk                                         Error = 479
	ErrUnknownProtocol                                     Error = 480
	ErrPathAccessDenied                                    Error = 481
	ErrDictionaryAccessDenied                              Error = 482
	ErrTooManyRedirects                                    Error = 483
	ErrInternalRedisError                                  Error = 484
	ErrCannotGetCreateDictionaryQuery                      Error = 487
	ErrIncorrectDictionaryDefinition                       Error = 489
	ErrCannotFormatDatetime                                Error = 490
	ErrUnacceptableURL                                     Error = 491
	ErrAccessEntityNotFound                                Error = 492
	ErrAccessEntityAlreadyExists                           Error = 493
	ErrAccessStorageReadonly                               Error = 495
	ErrQuotaRequiresClientKey                              Error = 496
	ErrAccessDenied                                        Error = 497
	ErrLimitByWithTiesIsNotSupported                       Error = 498
	ErrS3Error                                             Error = 499
	ErrAzureBlobStorageError                               Error = 500
	ErrCannotCreateDatabase                                Error = 501
	ErrCannotSigqueue                                      Error = 502
	ErrAggregateFunctionThrow                              Error = 503
	ErrFileAlreadyExists                                   Error = 504
	ErrUnableToSkipUnusedShards                            Error = 507
	ErrUnknownAccessType                                   Error = 508
	ErrInvalidGrant                                        Error = 509
	ErrCacheDictionaryUpdateFail                           Error = 510
	ErrUnknownRole                                         Error = 511
	ErrSetNonGrantedRole                                   Error = 512
	ErrUnknownPartType                                     Error = 513
	ErrAccessStorageForInsertionNotFound                   Error = 514
	ErrIncorrectAccessEntityDefinition                     Error = 515
	ErrAuthenticationFailed                                Error = 516
	ErrCannotAssignAlter                                   Error = 517
	ErrCannotCommitOffset                                  Error = 518
	ErrNoRemoteShardAvailable                              Error = 519
	ErrCannotDetachDictionaryAsTable                       Error = 520
	ErrAtomicRenameFail                                    Error = 521
	ErrUnknownRowPolicy                                    Error = 523
	ErrAlterOfColumnIsForbidden                            Error = 524
	ErrIncorrectDiskIndex                                  Error = 525
	ErrNoSuitableFunctionImplementation                    Error = 527
	ErrCassandraInternalError                              Error = 528
	ErrNotALeader                                          Error = 529
	ErrCannotConnectRabbitmq                               Error = 530
	ErrCannotFstat                                         Error = 531
	ErrLdapError                                           Error = 532
	ErrUnknownRaidType                                     Error = 535
	ErrCannotRestoreFromFieldDump                          Error = 536
	ErrIllegalMysqlVariable                                Error = 537
	ErrMysqlSyntaxError                                    Error = 538
	ErrCannotBindRabbitmqExchange                          Error = 539
	ErrCannotDeclareRabbitmqExchange                       Error = 540
	ErrCannotCreateRabbitmqQueueBinding                    Error = 541
	ErrCannotRemoveRabbitmqExchange                        Error = 542
	ErrUnknownMysqlDatatypesSupportLevel                   Error = 543
	ErrRowAndRowsTogether                                  Error = 544
	ErrFirstAndNextTogether                                Error = 545
	ErrNoRowDelimiter                                      Error = 546
	ErrInvalidRaidType                                     Error = 547
	ErrUnknownVolume                                       Error = 548
	ErrDataTypeCannotBeUsedInKey                           Error = 549
	ErrUnrecognizedArguments                               Error = 552
	ErrLzmaStreamEncoderFailed                             Error = 553
	ErrLzmaStreamDecoderFailed                             Error = 554
	ErrRocksdbError                                        Error = 555
	ErrSyncMysqlUserAccessError                            Error = 556
	ErrUnknownUnion                                        Error = 557
	ErrExpectedAllOrDistinct                               Error = 558
	ErrInvalidGrpcQueryInfo                                Error = 559
	ErrZstdEncoderFailed                                   Error = 560
	ErrZstdDecoderFailed                                   Error = 561
	ErrTldListNotFound                                     Error = 562
	ErrCannotReadMapFromText                               Error = 563
	ErrInterserverSchemeDoesntMatch                        Error = 564
	ErrTooManyPartitions                                   Error = 565
	ErrCannotRmdir                                         Error = 566
	ErrDuplicatedPartUuids                                 Error = 567
	ErrRaftError                                           Error = 568
	ErrMultipleColumnsSerializedToSameProtobufField        Error = 569
	ErrDataTypeIncompatibleWithProtobufField               Error = 570
	ErrDatabaseReplicationFailed                           Error = 571
	ErrTooManyQueryPlanOptimizations                       Error = 572
	ErrEpollError                                          Error = 573
	ErrDistributedTooManyPendingBytes                      Error = 574
	ErrUnknownSnapshot                                     Error = 575
	ErrKerberosError                                       Error = 576
	ErrInvalidShardID                                      Error = 577
	ErrInvalidFormatInsertQueryWithData                    Error = 578
	ErrIncorrectPartType                                   Error = 579
	ErrCannotSetRoundingMode                               Error = 580
	ErrTooLargeDistributedDepth                            Error = 581
	ErrNoSuchProjectionInTable                             Error = 582
	ErrIllegalProjection                                   Error = 583
	ErrProjectionNotUsed                                   Error = 584
	ErrCannotParseYaml                                     Error = 585
	ErrCannotCreateFile                                    Error = 586
	ErrConcurrentAccessNotSupported                        Error = 587
	ErrDistributedBrokenBatchInfo                          Error = 588
	ErrDistributedBrokenBatchFiles                         Error = 589
	ErrCannotSysconf                                       Error = 590
	ErrSqliteEngineError                                   Error = 591
	ErrDataEncryptionError                                 Error = 592
	ErrZeroCopyReplicationError                            Error = 593
	ErrBzip2StreamDecoderFailed                            Error = 594
	ErrBzip2StreamEncoderFailed                            Error = 595
	ErrIntersectOrExceptResultStructuresMismatch           Error = 596
	ErrNoSuchErrorCode                                     Error = 597
	ErrBackupAlreadyExists                                 Error = 598
	ErrBackupNotFound                                      Error = 599
	ErrBackupVersionNotSupported                           Error = 600
	ErrBackupDamaged                                       Error = 601
	ErrNoBaseBackup                                        Error = 602
	ErrWrongBaseBackup                                     Error = 603
	ErrBackupEntryAlreadyExists                            Error = 604
	ErrBackupEntryNotFound                                 Error = 605
	ErrBackupIsEmpty                                       Error = 606
	ErrCannotRestoreDatabase                               Error = 607
	ErrCannotRestoreTable                                  Error = 608
	ErrFunctionAlreadyExists                               Error = 609
	ErrCannotDropFunction                                  Error = 610
	ErrCannotCreateRecursiveFunction                       Error = 611
	ErrPostgresqlConnectionFailure                         Error = 614
	ErrCannotAdvise                                        Error = 615
	ErrUnknownReadMethod                                   Error = 616
	ErrLz4EncoderFailed                                    Error = 617
	ErrLz4DecoderFailed                                    Error = 618
	ErrPostgresqlReplicationInternalError                  Error = 619
	ErrQueryNotAllowed                                     Error = 620
	ErrCannotNormalizeString                               Error = 621
	ErrCannotParseCapnProtoSchema                          Error = 622
	ErrCapnProtoBadCast                                    Error = 623
	ErrBadFileType                                         Error = 624
	ErrIOSetupError                                        Error = 625
	ErrCannotSkipUnknownField                              Error = 626
	ErrBackupEngineNotFound                                Error = 627
	ErrOffsetFetchWithoutOrderBy                           Error = 628
	ErrHTTPRangeNotSatisfiable                             Error = 629
	ErrHaveDependentObjects                                Error = 630
	ErrUnknownFileSize                                     Error = 631
	ErrUnexpectedDataAfterParsedValue                      Error = 632
	ErrQueryIsNotSupportedInWindowView                     Error = 633
	ErrMongodbError                                        Error = 634
	ErrCannotPoll                                          Error = 635
	ErrCannotExtractTableStructure                         Error = 636
	ErrInvalidTableOverride                                Error = 637
	ErrSnappyUncompressFailed                              Error = 638
	ErrSnappyCompressFailed                                Error = 639
	ErrNoHivemetastore                                     Error = 640
	ErrCannotAppendToFile                                  Error = 641
	ErrCannotPackArchive                                   Error = 642
	ErrCannotUnpackArchive                                 Error = 643
	ErrNumberOfDimensionsMismatched                        Error = 645
	ErrCannotBackupTable                                   Error = 647
	ErrWrongDdlRenamingSettings                            Error = 648
	ErrInvalidTransaction                                  Error = 649
	ErrSerializationError                                  Error = 650
	ErrCapnProtoBadType                                    Error = 651
	ErrOnlyNullsWhileReadingSchema                         Error = 652
	ErrCannotParseBackupSettings                           Error = 653
	ErrWrongBackupSettings                                 Error = 654
	ErrFailedToSyncBackupOrRestore                         Error = 655
	ErrUnknownStatusOfTransaction                          Error = 659
	ErrHdfsError                                           Error = 660
	ErrCannotSendSignal                                    Error = 661
	ErrFsMetadataError                                     Error = 662
	ErrInconsistentMetadataForBackup                       Error = 663
	ErrAccessStorageDoesntAllowBackup                      Error = 664
	ErrCannotConnectNats                                   Error = 665
	ErrNotInitialized                                      Error = 667
	ErrInvalidState                                        Error = 668
	ErrNamedCollectionDoesntExist                          Error = 669
	ErrNamedCollectionAlreadyExists                        Error = 670
	ErrNamedCollectionIsImmutable                          Error = 671
	ErrInvalidSchedulerNode                                Error = 672
	ErrResourceAccessDenied                                Error = 673
	ErrResourceNotFound                                    Error = 674
	ErrCannotParseIpv4                                     Error = 675
	ErrCannotParseIpv6                                     Error = 676
	ErrThreadWasCanceled                                   Error = 677
	ErrIOUringInitFailed                                   Error = 678
	ErrIOUringSubmitError                                  Error = 679
	ErrMixedAccessParameterTypes                           Error = 690
	ErrUnknownElementOfEnum                                Error = 691
	ErrTooManyMutations                                    Error = 692
	ErrAwsError                                            Error = 693
	ErrAsyncLoadCycle                                      Error = 694
	ErrAsyncLoadFailed                                     Error = 695
	ErrAsyncLoadCanceled                                   Error = 696
	ErrCannotRestoreToNonencryptedDisk                     Error = 697
	ErrInvalidRedisStorageType                             Error = 698
	ErrInvalidRedisTableStructure                          Error = 699
	ErrUserSessionLimitExceeded                            Error = 700
	ErrClusterDoesntExist                                  Error = 701
	ErrClientInfoDoesNotMatch                              Error = 702
	ErrInvalidIdentifier                                   Error = 703
	ErrQueryCacheUsedWithNondeterministicFunctions         Error = 704
	ErrTableNotEmpty                                       Error = 705
	ErrLibsshError                                         Error = 706
	ErrGcpError                                            Error = 707
	ErrIllegalStatistics                                   Error = 708
	ErrCannotGetReplicatedDatabaseSnapshot                 Error = 709
	ErrFaultInjected                                       Error = 710
	ErrFilecacheAccessDenied                               Error = 711
	ErrTooManyMaterializedViews                            Error = 712
	ErrBrokenProjection                                    Error = 713
	ErrUnexpectedCluster                                   Error = 714
	ErrCannotDetectFormat                                  Error = 715
	ErrCannotForgetPartition                               Error = 716
	ErrExperimentalFeatureError                            Error = 717
	ErrTooSlowParsing                                      Error = 718
	ErrQueryCacheUsedWithSystemTable                       Error = 719
	ErrUserExpired                                         Error = 720
	ErrDeprecatedFunction                                  Error = 721
	ErrAsyncLoadWaitFailed                                 Error = 722
	ErrParquetException                                    Error = 723
	ErrTooManyTables                                       Error = 724
	ErrTooManyDatabases                                    Error = 725
	ErrUnexpectedHTTPHeaders                               Error = 726
	ErrUnexpectedTableEngine                               Error = 727
	ErrUnexpectedDataType                                  Error = 728
	ErrIllegalTimeSeriesTags                               Error = 729
	ErrRefreshFailed                                       Error = 730
	ErrQueryCacheUsedWithNonThrowOverflowMode              Error = 731
	ErrTableIsBeingRestarted                               Error = 733
	ErrCannotWriteAfterBufferCanceled                      Error = 734
	ErrQueryWasCancelledByClient                           Error = 735
	ErrDatalakeDatabaseError                               Error = 736
	ErrGoogleCloudError                                    Error = 737
	ErrPartIsLocked                                        Error = 738
	ErrBuzzhouse                                           Error = 739
	ErrPotentiallyBrokenDataPart                           Error = 740
	ErrTableUUIDMismatch                                   Error = 741
	ErrDeltaKernelError                                    Error = 742
	ErrIcebergSpecificationViolation                       Error = 743
	ErrSessionIDEmpty                                      Error = 744
	ErrServerOverloaded                                    Error = 745
	ErrDependenciesNotFound                                Error = 746
	ErrFilecacheCannotWriteThroughCacheWithConcurrentReads Error = 747
	ErrDistributedCacheError                               Error = 900
	ErrCannotUseDistributedCache                           Error = 901
	ErrProtocolVersionMismatch                             Error = 902
	ErrLicenseExpired                                      Error = 903
	ErrKeeperException                                     Error = 999
	ErrPocoException                                       Error = 1000
	ErrStdException                                        Error = 1001
	ErrUnknownException                                    Error = 1002
	ErrSSHException                                        Error = 1003
	ErrStartupScriptsError                                 Error = 1004
	ErrConditionalTreeParentNotFound                       Error = 2001 // Deprecated: Error removed from ClickHouse
	ErrIllegalProjectionManipulator                        Error = 2002 // Deprecated: Error removed from ClickHouse
)
