package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIsolationRulesOfResource invokes the ahas_openapi.ListIsolationRulesOfResource API synchronously
func (client *Client) ListIsolationRulesOfResource(request *ListIsolationRulesOfResourceRequest) (response *ListIsolationRulesOfResourceResponse, err error) {
	response = CreateListIsolationRulesOfResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListIsolationRulesOfResourceWithChan invokes the ahas_openapi.ListIsolationRulesOfResource API asynchronously
func (client *Client) ListIsolationRulesOfResourceWithChan(request *ListIsolationRulesOfResourceRequest) (<-chan *ListIsolationRulesOfResourceResponse, <-chan error) {
	responseChan := make(chan *ListIsolationRulesOfResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIsolationRulesOfResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIsolationRulesOfResourceWithCallback invokes the ahas_openapi.ListIsolationRulesOfResource API asynchronously
func (client *Client) ListIsolationRulesOfResourceWithCallback(request *ListIsolationRulesOfResourceRequest, callback func(response *ListIsolationRulesOfResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIsolationRulesOfResourceResponse
		var err error
		defer close(result)
		response, err = client.ListIsolationRulesOfResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIsolationRulesOfResourceRequest is the request struct for api ListIsolationRulesOfResource
type ListIsolationRulesOfResourceRequest struct {
	*requests.RpcRequest
	Resource     string           `position:"Query" name:"Resource"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
}

// ListIsolationRulesOfResourceResponse is the response struct for api ListIsolationRulesOfResource
type ListIsolationRulesOfResourceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListIsolationRulesOfResourceRequest creates a request to invoke ListIsolationRulesOfResource API
func CreateListIsolationRulesOfResourceRequest() (request *ListIsolationRulesOfResourceRequest) {
	request = &ListIsolationRulesOfResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListIsolationRulesOfResource", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListIsolationRulesOfResourceResponse creates a response to parse from ListIsolationRulesOfResource response
func CreateListIsolationRulesOfResourceResponse() (response *ListIsolationRulesOfResourceResponse) {
	response = &ListIsolationRulesOfResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
