package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIspFlushCacheTask invokes the alidns.DescribeIspFlushCacheTask API synchronously
func (client *Client) DescribeIspFlushCacheTask(request *DescribeIspFlushCacheTaskRequest) (response *DescribeIspFlushCacheTaskResponse, err error) {
	response = CreateDescribeIspFlushCacheTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIspFlushCacheTaskWithChan invokes the alidns.DescribeIspFlushCacheTask API asynchronously
func (client *Client) DescribeIspFlushCacheTaskWithChan(request *DescribeIspFlushCacheTaskRequest) (<-chan *DescribeIspFlushCacheTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeIspFlushCacheTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIspFlushCacheTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIspFlushCacheTaskWithCallback invokes the alidns.DescribeIspFlushCacheTask API asynchronously
func (client *Client) DescribeIspFlushCacheTaskWithCallback(request *DescribeIspFlushCacheTaskRequest, callback func(response *DescribeIspFlushCacheTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIspFlushCacheTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeIspFlushCacheTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIspFlushCacheTaskRequest is the request struct for api DescribeIspFlushCacheTask
type DescribeIspFlushCacheTaskRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
	TaskId       string `position:"Query" name:"TaskId"`
}

// DescribeIspFlushCacheTaskResponse is the response struct for api DescribeIspFlushCacheTask
type DescribeIspFlushCacheTaskResponse struct {
	*responses.BaseResponse
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	TaskId            string             `json:"TaskId" xml:"TaskId"`
	DomainName        string             `json:"DomainName" xml:"DomainName"`
	InstanceId        string             `json:"InstanceId" xml:"InstanceId"`
	InstanceName      string             `json:"InstanceName" xml:"InstanceName"`
	Isp               string             `json:"Isp" xml:"Isp"`
	TaskStatus        string             `json:"TaskStatus" xml:"TaskStatus"`
	CreateTime        string             `json:"CreateTime" xml:"CreateTime"`
	CreateTimestamp   int64              `json:"CreateTimestamp" xml:"CreateTimestamp"`
	FlushCacheResults []FlushCacheResult `json:"FlushCacheResults" xml:"FlushCacheResults"`
}

// CreateDescribeIspFlushCacheTaskRequest creates a request to invoke DescribeIspFlushCacheTask API
func CreateDescribeIspFlushCacheTaskRequest() (request *DescribeIspFlushCacheTaskRequest) {
	request = &DescribeIspFlushCacheTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeIspFlushCacheTask", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIspFlushCacheTaskResponse creates a response to parse from DescribeIspFlushCacheTask response
func CreateDescribeIspFlushCacheTaskResponse() (response *DescribeIspFlushCacheTaskResponse) {
	response = &DescribeIspFlushCacheTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
