package alimt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TranslateImageBatch invokes the alimt.TranslateImageBatch API synchronously
func (client *Client) TranslateImageBatch(request *TranslateImageBatchRequest) (response *TranslateImageBatchResponse, err error) {
	response = CreateTranslateImageBatchResponse()
	err = client.DoAction(request, response)
	return
}

// TranslateImageBatchWithChan invokes the alimt.TranslateImageBatch API asynchronously
func (client *Client) TranslateImageBatchWithChan(request *TranslateImageBatchRequest) (<-chan *TranslateImageBatchResponse, <-chan error) {
	responseChan := make(chan *TranslateImageBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TranslateImageBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TranslateImageBatchWithCallback invokes the alimt.TranslateImageBatch API asynchronously
func (client *Client) TranslateImageBatchWithCallback(request *TranslateImageBatchRequest, callback func(response *TranslateImageBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TranslateImageBatchResponse
		var err error
		defer close(result)
		response, err = client.TranslateImageBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TranslateImageBatchRequest is the request struct for api TranslateImageBatch
type TranslateImageBatchRequest struct {
	*requests.RpcRequest
	Ext            string `position:"Body" name:"Ext"`
	SourceLanguage string `position:"Body" name:"SourceLanguage"`
	ImageUrls      string `position:"Body" name:"ImageUrls"`
	CustomTaskId   string `position:"Body" name:"CustomTaskId"`
	Field          string `position:"Body" name:"Field"`
	TargetLanguage string `position:"Body" name:"TargetLanguage"`
}

// TranslateImageBatchResponse is the response struct for api TranslateImageBatch
type TranslateImageBatchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateTranslateImageBatchRequest creates a request to invoke TranslateImageBatch API
func CreateTranslateImageBatchRequest() (request *TranslateImageBatchRequest) {
	request = &TranslateImageBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alimt", "2018-10-12", "TranslateImageBatch", "", "")
	request.Method = requests.POST
	return
}

// CreateTranslateImageBatchResponse creates a response to parse from TranslateImageBatch response
func CreateTranslateImageBatchResponse() (response *TranslateImageBatchResponse) {
	response = &TranslateImageBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
