package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetadataAmount invokes the amqp_open.GetMetadataAmount API synchronously
func (client *Client) GetMetadataAmount(request *GetMetadataAmountRequest) (response *GetMetadataAmountResponse, err error) {
	response = CreateGetMetadataAmountResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetadataAmountWithChan invokes the amqp_open.GetMetadataAmount API asynchronously
func (client *Client) GetMetadataAmountWithChan(request *GetMetadataAmountRequest) (<-chan *GetMetadataAmountResponse, <-chan error) {
	responseChan := make(chan *GetMetadataAmountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetadataAmount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetadataAmountWithCallback invokes the amqp_open.GetMetadataAmount API asynchronously
func (client *Client) GetMetadataAmountWithCallback(request *GetMetadataAmountRequest, callback func(response *GetMetadataAmountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetadataAmountResponse
		var err error
		defer close(result)
		response, err = client.GetMetadataAmount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetadataAmountRequest is the request struct for api GetMetadataAmount
type GetMetadataAmountRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetMetadataAmountResponse is the response struct for api GetMetadataAmount
type GetMetadataAmountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetMetadataAmountRequest creates a request to invoke GetMetadataAmount API
func CreateGetMetadataAmountRequest() (request *GetMetadataAmountRequest) {
	request = &GetMetadataAmountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "GetMetadataAmount", "onsproxy", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetMetadataAmountResponse creates a response to parse from GetMetadataAmount response
func CreateGetMetadataAmountResponse() (response *GetMetadataAmountResponse) {
	response = &GetMetadataAmountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
