package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecoverMigrationJob invokes the apds.RecoverMigrationJob API synchronously
func (client *Client) RecoverMigrationJob(request *RecoverMigrationJobRequest) (response *RecoverMigrationJobResponse, err error) {
	response = CreateRecoverMigrationJobResponse()
	err = client.DoAction(request, response)
	return
}

// RecoverMigrationJobWithChan invokes the apds.RecoverMigrationJob API asynchronously
func (client *Client) RecoverMigrationJobWithChan(request *RecoverMigrationJobRequest) (<-chan *RecoverMigrationJobResponse, <-chan error) {
	responseChan := make(chan *RecoverMigrationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecoverMigrationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecoverMigrationJobWithCallback invokes the apds.RecoverMigrationJob API asynchronously
func (client *Client) RecoverMigrationJobWithCallback(request *RecoverMigrationJobRequest, callback func(response *RecoverMigrationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecoverMigrationJobResponse
		var err error
		defer close(result)
		response, err = client.RecoverMigrationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecoverMigrationJobRequest is the request struct for api RecoverMigrationJob
type RecoverMigrationJobRequest struct {
	*requests.RoaRequest
	Id string `position:"Query" name:"id"`
}

// RecoverMigrationJobResponse is the response struct for api RecoverMigrationJob
type RecoverMigrationJobResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateRecoverMigrationJobRequest creates a request to invoke RecoverMigrationJob API
func CreateRecoverMigrationJobRequest() (request *RecoverMigrationJobRequest) {
	request = &RecoverMigrationJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "RecoverMigrationJob", "/okss-services/migration-job/recover-migration-job", "", "")
	request.Method = requests.POST
	return
}

// CreateRecoverMigrationJobResponse creates a response to parse from RecoverMigrationJob response
func CreateRecoverMigrationJobResponse() (response *RecoverMigrationJobResponse) {
	response = &RecoverMigrationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
