package aps

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFxCustomerType invokes the aps.GetFxCustomerType API synchronously
func (client *Client) GetFxCustomerType(request *GetFxCustomerTypeRequest) (response *GetFxCustomerTypeResponse, err error) {
	response = CreateGetFxCustomerTypeResponse()
	err = client.DoAction(request, response)
	return
}

// GetFxCustomerTypeWithChan invokes the aps.GetFxCustomerType API asynchronously
func (client *Client) GetFxCustomerTypeWithChan(request *GetFxCustomerTypeRequest) (<-chan *GetFxCustomerTypeResponse, <-chan error) {
	responseChan := make(chan *GetFxCustomerTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFxCustomerType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFxCustomerTypeWithCallback invokes the aps.GetFxCustomerType API asynchronously
func (client *Client) GetFxCustomerTypeWithCallback(request *GetFxCustomerTypeRequest, callback func(response *GetFxCustomerTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFxCustomerTypeResponse
		var err error
		defer close(result)
		response, err = client.GetFxCustomerType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFxCustomerTypeRequest is the request struct for api GetFxCustomerType
type GetFxCustomerTypeRequest struct {
	*requests.RpcRequest
	Uid requests.Integer `position:"Query" name:"Uid"`
}

// GetFxCustomerTypeResponse is the response struct for api GetFxCustomerType
type GetFxCustomerTypeResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetFxCustomerTypeRequest creates a request to invoke GetFxCustomerType API
func CreateGetFxCustomerTypeRequest() (request *GetFxCustomerTypeRequest) {
	request = &GetFxCustomerTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aps", "2024-03-25", "GetFxCustomerType", "", "")
	request.Method = requests.POST
	return
}

// CreateGetFxCustomerTypeResponse creates a response to parse from GetFxCustomerType response
func CreateGetFxCustomerTypeResponse() (response *GetFxCustomerTypeResponse) {
	response = &GetFxCustomerTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
