package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricInviter invokes the baas.DescribeFabricInviter API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricinviter.html
func (client *Client) DescribeFabricInviter(request *DescribeFabricInviterRequest) (response *DescribeFabricInviterResponse, err error) {
	response = CreateDescribeFabricInviterResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricInviterWithChan invokes the baas.DescribeFabricInviter API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricinviter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricInviterWithChan(request *DescribeFabricInviterRequest) (<-chan *DescribeFabricInviterResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricInviterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricInviter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricInviterWithCallback invokes the baas.DescribeFabricInviter API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricinviter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricInviterWithCallback(request *DescribeFabricInviterRequest, callback func(response *DescribeFabricInviterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricInviterResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricInviter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricInviterRequest is the request struct for api DescribeFabricInviter
type DescribeFabricInviterRequest struct {
	*requests.RpcRequest
	Code string `position:"Body" name:"Code"`
}

// DescribeFabricInviterResponse is the response struct for api DescribeFabricInviter
type DescribeFabricInviterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeFabricInviterRequest creates a request to invoke DescribeFabricInviter API
func CreateDescribeFabricInviterRequest() (request *DescribeFabricInviterRequest) {
	request = &DescribeFabricInviterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricInviter", "baas", "openAPI")
	return
}

// CreateDescribeFabricInviterResponse creates a response to parse from DescribeFabricInviter response
func CreateDescribeFabricInviterResponse() (response *DescribeFabricInviterResponse) {
	response = &DescribeFabricInviterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
