package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddTrafficMatchRuleToTrafficMarkingPolicy invokes the cbn.AddTrafficMatchRuleToTrafficMarkingPolicy API synchronously
func (client *Client) AddTrafficMatchRuleToTrafficMarkingPolicy(request *AddTrafficMatchRuleToTrafficMarkingPolicyRequest) (response *AddTrafficMatchRuleToTrafficMarkingPolicyResponse, err error) {
	response = CreateAddTrafficMatchRuleToTrafficMarkingPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// AddTrafficMatchRuleToTrafficMarkingPolicyWithChan invokes the cbn.AddTrafficMatchRuleToTrafficMarkingPolicy API asynchronously
func (client *Client) AddTrafficMatchRuleToTrafficMarkingPolicyWithChan(request *AddTrafficMatchRuleToTrafficMarkingPolicyRequest) (<-chan *AddTrafficMatchRuleToTrafficMarkingPolicyResponse, <-chan error) {
	responseChan := make(chan *AddTrafficMatchRuleToTrafficMarkingPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddTrafficMatchRuleToTrafficMarkingPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddTrafficMatchRuleToTrafficMarkingPolicyWithCallback invokes the cbn.AddTrafficMatchRuleToTrafficMarkingPolicy API asynchronously
func (client *Client) AddTrafficMatchRuleToTrafficMarkingPolicyWithCallback(request *AddTrafficMatchRuleToTrafficMarkingPolicyRequest, callback func(response *AddTrafficMatchRuleToTrafficMarkingPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddTrafficMatchRuleToTrafficMarkingPolicyResponse
		var err error
		defer close(result)
		response, err = client.AddTrafficMatchRuleToTrafficMarkingPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddTrafficMatchRuleToTrafficMarkingPolicyRequest is the request struct for api AddTrafficMatchRuleToTrafficMarkingPolicy
type AddTrafficMatchRuleToTrafficMarkingPolicyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                                              `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string                                                        `position:"Query" name:"ClientToken"`
	TrafficMarkingPolicyId string                                                        `position:"Query" name:"TrafficMarkingPolicyId"`
	DryRun                 requests.Boolean                                              `position:"Query" name:"DryRun"`
	TrafficMatchRules      *[]AddTrafficMatchRuleToTrafficMarkingPolicyTrafficMatchRules `position:"Query" name:"TrafficMatchRules"  type:"Repeated"`
	ResourceOwnerAccount   string                                                        `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string                                                        `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer                                              `position:"Query" name:"OwnerId"`
	Version                string                                                        `position:"Query" name:"Version"`
}

// AddTrafficMatchRuleToTrafficMarkingPolicyTrafficMatchRules is a repeated param struct in AddTrafficMatchRuleToTrafficMarkingPolicyRequest
type AddTrafficMatchRuleToTrafficMarkingPolicyTrafficMatchRules struct {
	DstPortRange                *[]string `name:"DstPortRange" type:"Repeated"`
	MatchDscp                   string    `name:"MatchDscp"`
	Protocol                    string    `name:"Protocol"`
	TrafficMatchRuleDescription string    `name:"TrafficMatchRuleDescription"`
	SrcPortRange                *[]string `name:"SrcPortRange" type:"Repeated"`
	DstCidr                     string    `name:"DstCidr"`
	TrafficMatchRuleName        string    `name:"TrafficMatchRuleName"`
	SrcCidr                     string    `name:"SrcCidr"`
}

// AddTrafficMatchRuleToTrafficMarkingPolicyResponse is the response struct for api AddTrafficMatchRuleToTrafficMarkingPolicy
type AddTrafficMatchRuleToTrafficMarkingPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddTrafficMatchRuleToTrafficMarkingPolicyRequest creates a request to invoke AddTrafficMatchRuleToTrafficMarkingPolicy API
func CreateAddTrafficMatchRuleToTrafficMarkingPolicyRequest() (request *AddTrafficMatchRuleToTrafficMarkingPolicyRequest) {
	request = &AddTrafficMatchRuleToTrafficMarkingPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "AddTrafficMatchRuleToTrafficMarkingPolicy", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddTrafficMatchRuleToTrafficMarkingPolicyResponse creates a response to parse from AddTrafficMatchRuleToTrafficMarkingPolicy response
func CreateAddTrafficMatchRuleToTrafficMarkingPolicyResponse() (response *AddTrafficMatchRuleToTrafficMarkingPolicyResponse) {
	response = &AddTrafficMatchRuleToTrafficMarkingPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
