package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnassociateCenBandwidthPackage invokes the cbn.UnassociateCenBandwidthPackage API synchronously
func (client *Client) UnassociateCenBandwidthPackage(request *UnassociateCenBandwidthPackageRequest) (response *UnassociateCenBandwidthPackageResponse, err error) {
	response = CreateUnassociateCenBandwidthPackageResponse()
	err = client.DoAction(request, response)
	return
}

// UnassociateCenBandwidthPackageWithChan invokes the cbn.UnassociateCenBandwidthPackage API asynchronously
func (client *Client) UnassociateCenBandwidthPackageWithChan(request *UnassociateCenBandwidthPackageRequest) (<-chan *UnassociateCenBandwidthPackageResponse, <-chan error) {
	responseChan := make(chan *UnassociateCenBandwidthPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnassociateCenBandwidthPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnassociateCenBandwidthPackageWithCallback invokes the cbn.UnassociateCenBandwidthPackage API asynchronously
func (client *Client) UnassociateCenBandwidthPackageWithCallback(request *UnassociateCenBandwidthPackageRequest, callback func(response *UnassociateCenBandwidthPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnassociateCenBandwidthPackageResponse
		var err error
		defer close(result)
		response, err = client.UnassociateCenBandwidthPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnassociateCenBandwidthPackageRequest is the request struct for api UnassociateCenBandwidthPackage
type UnassociateCenBandwidthPackageRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                 string           `position:"Query" name:"CenId"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	Version               string           `position:"Query" name:"Version"`
	CenBandwidthPackageId string           `position:"Query" name:"CenBandwidthPackageId"`
}

// UnassociateCenBandwidthPackageResponse is the response struct for api UnassociateCenBandwidthPackage
type UnassociateCenBandwidthPackageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnassociateCenBandwidthPackageRequest creates a request to invoke UnassociateCenBandwidthPackage API
func CreateUnassociateCenBandwidthPackageRequest() (request *UnassociateCenBandwidthPackageRequest) {
	request = &UnassociateCenBandwidthPackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "UnassociateCenBandwidthPackage", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnassociateCenBandwidthPackageResponse creates a response to parse from UnassociateCenBandwidthPackage response
func CreateUnassociateCenBandwidthPackageResponse() (response *UnassociateCenBandwidthPackageResponse) {
	response = &UnassociateCenBandwidthPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
