package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudSiemAssetsCounter invokes the cloud_siem.DescribeCloudSiemAssetsCounter API synchronously
func (client *Client) DescribeCloudSiemAssetsCounter(request *DescribeCloudSiemAssetsCounterRequest) (response *DescribeCloudSiemAssetsCounterResponse, err error) {
	response = CreateDescribeCloudSiemAssetsCounterResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudSiemAssetsCounterWithChan invokes the cloud_siem.DescribeCloudSiemAssetsCounter API asynchronously
func (client *Client) DescribeCloudSiemAssetsCounterWithChan(request *DescribeCloudSiemAssetsCounterRequest) (<-chan *DescribeCloudSiemAssetsCounterResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudSiemAssetsCounterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudSiemAssetsCounter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudSiemAssetsCounterWithCallback invokes the cloud_siem.DescribeCloudSiemAssetsCounter API asynchronously
func (client *Client) DescribeCloudSiemAssetsCounterWithCallback(request *DescribeCloudSiemAssetsCounterRequest, callback func(response *DescribeCloudSiemAssetsCounterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudSiemAssetsCounterResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudSiemAssetsCounter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudSiemAssetsCounterRequest is the request struct for api DescribeCloudSiemAssetsCounter
type DescribeCloudSiemAssetsCounterRequest struct {
	*requests.RpcRequest
	IncidentUuid string `position:"Body" name:"IncidentUuid"`
}

// DescribeCloudSiemAssetsCounterResponse is the response struct for api DescribeCloudSiemAssetsCounter
type DescribeCloudSiemAssetsCounterResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeCloudSiemAssetsCounterRequest creates a request to invoke DescribeCloudSiemAssetsCounter API
func CreateDescribeCloudSiemAssetsCounterRequest() (request *DescribeCloudSiemAssetsCounterRequest) {
	request = &DescribeCloudSiemAssetsCounterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeCloudSiemAssetsCounter", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudSiemAssetsCounterResponse creates a response to parse from DescribeCloudSiemAssetsCounter response
func CreateDescribeCloudSiemAssetsCounterResponse() (response *DescribeCloudSiemAssetsCounterResponse) {
	response = &DescribeCloudSiemAssetsCounterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
