package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyIntranetDomainPolicy invokes the cloudapi.ModifyIntranetDomainPolicy API synchronously
func (client *Client) ModifyIntranetDomainPolicy(request *ModifyIntranetDomainPolicyRequest) (response *ModifyIntranetDomainPolicyResponse, err error) {
	response = CreateModifyIntranetDomainPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyIntranetDomainPolicyWithChan invokes the cloudapi.ModifyIntranetDomainPolicy API asynchronously
func (client *Client) ModifyIntranetDomainPolicyWithChan(request *ModifyIntranetDomainPolicyRequest) (<-chan *ModifyIntranetDomainPolicyResponse, <-chan error) {
	responseChan := make(chan *ModifyIntranetDomainPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyIntranetDomainPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyIntranetDomainPolicyWithCallback invokes the cloudapi.ModifyIntranetDomainPolicy API asynchronously
func (client *Client) ModifyIntranetDomainPolicyWithCallback(request *ModifyIntranetDomainPolicyRequest, callback func(response *ModifyIntranetDomainPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyIntranetDomainPolicyResponse
		var err error
		defer close(result)
		response, err = client.ModifyIntranetDomainPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyIntranetDomainPolicyRequest is the request struct for api ModifyIntranetDomainPolicy
type ModifyIntranetDomainPolicyRequest struct {
	*requests.RpcRequest
	GroupId           string           `position:"Query" name:"GroupId"`
	VpcIntranetEnable requests.Boolean `position:"Query" name:"VpcIntranetEnable"`
	SecurityToken     string           `position:"Query" name:"SecurityToken"`
}

// ModifyIntranetDomainPolicyResponse is the response struct for api ModifyIntranetDomainPolicy
type ModifyIntranetDomainPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyIntranetDomainPolicyRequest creates a request to invoke ModifyIntranetDomainPolicy API
func CreateModifyIntranetDomainPolicyRequest() (request *ModifyIntranetDomainPolicyRequest) {
	request = &ModifyIntranetDomainPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyIntranetDomainPolicy", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyIntranetDomainPolicyResponse creates a response to parse from ModifyIntranetDomainPolicy response
func CreateModifyIntranetDomainPolicyResponse() (response *ModifyIntranetDomainPolicyResponse) {
	response = &ModifyIntranetDomainPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
