package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNatFirewallControlPolicy invokes the cloudfw.ModifyNatFirewallControlPolicy API synchronously
func (client *Client) ModifyNatFirewallControlPolicy(request *ModifyNatFirewallControlPolicyRequest) (response *ModifyNatFirewallControlPolicyResponse, err error) {
	response = CreateModifyNatFirewallControlPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNatFirewallControlPolicyWithChan invokes the cloudfw.ModifyNatFirewallControlPolicy API asynchronously
func (client *Client) ModifyNatFirewallControlPolicyWithChan(request *ModifyNatFirewallControlPolicyRequest) (<-chan *ModifyNatFirewallControlPolicyResponse, <-chan error) {
	responseChan := make(chan *ModifyNatFirewallControlPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNatFirewallControlPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNatFirewallControlPolicyWithCallback invokes the cloudfw.ModifyNatFirewallControlPolicy API asynchronously
func (client *Client) ModifyNatFirewallControlPolicyWithCallback(request *ModifyNatFirewallControlPolicyRequest, callback func(response *ModifyNatFirewallControlPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNatFirewallControlPolicyResponse
		var err error
		defer close(result)
		response, err = client.ModifyNatFirewallControlPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNatFirewallControlPolicyRequest is the request struct for api ModifyNatFirewallControlPolicy
type ModifyNatFirewallControlPolicyRequest struct {
	*requests.RpcRequest
	DestPortType        string    `position:"Query" name:"DestPortType"`
	Release             string    `position:"Query" name:"Release"`
	Destination         string    `position:"Query" name:"Destination"`
	DestinationType     string    `position:"Query" name:"DestinationType"`
	DestPortGroup       string    `position:"Query" name:"DestPortGroup"`
	ApplicationNameList *[]string `position:"Query" name:"ApplicationNameList"  type:"Repeated"`
	Description         string    `position:"Query" name:"Description"`
	Source              string    `position:"Query" name:"Source"`
	OpsStatus           string    `position:"Query" name:"OpsStatus"`
	AclUuid             string    `position:"Query" name:"AclUuid"`
	AclAction           string    `position:"Query" name:"AclAction"`
	SourceIp            string    `position:"Query" name:"SourceIp"`
	SourceType          string    `position:"Query" name:"SourceType"`
	NatGatewayId        string    `position:"Query" name:"NatGatewayId"`
	Lang                string    `position:"Query" name:"Lang"`
	DomainResolveType   string    `position:"Query" name:"DomainResolveType"`
	Proto               string    `position:"Query" name:"Proto"`
	DestPort            string    `position:"Query" name:"DestPort"`
}

// ModifyNatFirewallControlPolicyResponse is the response struct for api ModifyNatFirewallControlPolicy
type ModifyNatFirewallControlPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNatFirewallControlPolicyRequest creates a request to invoke ModifyNatFirewallControlPolicy API
func CreateModifyNatFirewallControlPolicyRequest() (request *ModifyNatFirewallControlPolicyRequest) {
	request = &ModifyNatFirewallControlPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyNatFirewallControlPolicy", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNatFirewallControlPolicyResponse creates a response to parse from ModifyNatFirewallControlPolicy response
func CreateModifyNatFirewallControlPolicyResponse() (response *ModifyNatFirewallControlPolicyResponse) {
	response = &ModifyNatFirewallControlPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
