package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConfigRules invokes the config.ListConfigRules API synchronously
func (client *Client) ListConfigRules(request *ListConfigRulesRequest) (response *ListConfigRulesResponse, err error) {
	response = CreateListConfigRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListConfigRulesWithChan invokes the config.ListConfigRules API asynchronously
func (client *Client) ListConfigRulesWithChan(request *ListConfigRulesRequest) (<-chan *ListConfigRulesResponse, <-chan error) {
	responseChan := make(chan *ListConfigRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConfigRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConfigRulesWithCallback invokes the config.ListConfigRules API asynchronously
func (client *Client) ListConfigRulesWithCallback(request *ListConfigRulesRequest, callback func(response *ListConfigRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConfigRulesResponse
		var err error
		defer close(result)
		response, err = client.ListConfigRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConfigRulesRequest is the request struct for api ListConfigRules
type ListConfigRulesRequest struct {
	*requests.RpcRequest
	FilterInCompliancePack           requests.Boolean `position:"Query" name:"FilterInCompliancePack"`
	ConfigRuleState                  string           `position:"Query" name:"ConfigRuleState"`
	FilterInCompliancePackExcludeIds string           `position:"Query" name:"FilterInCompliancePackExcludeIds"`
	PageNumber                       requests.Integer `position:"Query" name:"PageNumber"`
	PageSize                         requests.Integer `position:"Query" name:"PageSize"`
	CompliancePackId                 string           `position:"Query" name:"CompliancePackId"`
	Keyword                          string           `position:"Query" name:"Keyword"`
	ComplianceType                   string           `position:"Query" name:"ComplianceType"`
	ResourceTypes                    string           `position:"Query" name:"ResourceTypes"`
	RiskLevel                        requests.Integer `position:"Query" name:"RiskLevel"`
	ConfigRuleName                   string           `position:"Query" name:"ConfigRuleName"`
	ServiceChannel                   string           `position:"Query" name:"ServiceChannel"`
}

// ListConfigRulesResponse is the response struct for api ListConfigRules
type ListConfigRulesResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	ConfigRules ConfigRules `json:"ConfigRules" xml:"ConfigRules"`
}

// CreateListConfigRulesRequest creates a request to invoke ListConfigRules API
func CreateListConfigRulesRequest() (request *ListConfigRulesRequest) {
	request = &ListConfigRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListConfigRules", "", "")
	request.Method = requests.POST
	return
}

// CreateListConfigRulesResponse creates a response to parse from ListConfigRules response
func CreateListConfigRulesResponse() (response *ListConfigRulesResponse) {
	response = &ListConfigRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
