package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCloudBenchTasks invokes the das.CreateCloudBenchTasks API synchronously
func (client *Client) CreateCloudBenchTasks(request *CreateCloudBenchTasksRequest) (response *CreateCloudBenchTasksResponse, err error) {
	response = CreateCreateCloudBenchTasksResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCloudBenchTasksWithChan invokes the das.CreateCloudBenchTasks API asynchronously
func (client *Client) CreateCloudBenchTasksWithChan(request *CreateCloudBenchTasksRequest) (<-chan *CreateCloudBenchTasksResponse, <-chan error) {
	responseChan := make(chan *CreateCloudBenchTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCloudBenchTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCloudBenchTasksWithCallback invokes the das.CreateCloudBenchTasks API asynchronously
func (client *Client) CreateCloudBenchTasksWithCallback(request *CreateCloudBenchTasksRequest, callback func(response *CreateCloudBenchTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCloudBenchTasksResponse
		var err error
		defer close(result)
		response, err = client.CreateCloudBenchTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCloudBenchTasksRequest is the request struct for api CreateCloudBenchTasks
type CreateCloudBenchTasksRequest struct {
	*requests.RpcRequest
	ClientType          string `position:"Query" name:"ClientType"`
	DstPort             string `position:"Query" name:"DstPort"`
	Description         string `position:"Query" name:"Description"`
	RequestStartTime    string `position:"Query" name:"RequestStartTime"`
	DstConnectionString string `position:"Query" name:"DstConnectionString"`
	DstSuperPassword    string `position:"Query" name:"DstSuperPassword"`
	DstSuperAccount     string `position:"Query" name:"DstSuperAccount"`
	DstInstanceId       string `position:"Query" name:"DstInstanceId"`
	Rate                string `position:"Query" name:"Rate"`
	RequestDuration     string `position:"Query" name:"RequestDuration"`
	DtsJobId            string `position:"Query" name:"DtsJobId"`
	RequestEndTime      string `position:"Query" name:"RequestEndTime"`
	Amount              string `position:"Query" name:"Amount"`
	TaskType            string `position:"Query" name:"TaskType"`
	EndState            string `position:"Query" name:"EndState"`
	BackupId            string `position:"Query" name:"BackupId"`
	SrcSuperPassword    string `position:"Query" name:"SrcSuperPassword"`
	BackupTime          string `position:"Query" name:"BackupTime"`
	GatewayVpcIp        string `position:"Query" name:"GatewayVpcIp"`
	WorkDir             string `position:"Query" name:"WorkDir"`
	DtsJobClass         string `position:"Query" name:"DtsJobClass"`
	SrcPublicIp         string `position:"Query" name:"SrcPublicIp"`
	SrcInstanceId       string `position:"Query" name:"SrcInstanceId"`
	DstType             string `position:"Query" name:"DstType"`
	SrcSuperAccount     string `position:"Query" name:"SrcSuperAccount"`
	GatewayVpcId        string `position:"Query" name:"GatewayVpcId"`
	SmartPressureTime   string `position:"Query" name:"SmartPressureTime"`
}

// CreateCloudBenchTasksResponse is the response struct for api CreateCloudBenchTasks
type CreateCloudBenchTasksResponse struct {
	*responses.BaseResponse
	Code      string                      `json:"Code" xml:"Code"`
	Message   string                      `json:"Message" xml:"Message"`
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Success   string                      `json:"Success" xml:"Success"`
	Data      DataInCreateCloudBenchTasks `json:"Data" xml:"Data"`
}

// CreateCreateCloudBenchTasksRequest creates a request to invoke CreateCloudBenchTasks API
func CreateCreateCloudBenchTasksRequest() (request *CreateCloudBenchTasksRequest) {
	request = &CreateCloudBenchTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "CreateCloudBenchTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCloudBenchTasksResponse creates a response to parse from CreateCloudBenchTasks response
func CreateCreateCloudBenchTasksResponse() (response *CreateCloudBenchTasksResponse) {
	response = &CreateCloudBenchTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
