package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgWhiteListAddOrUpdate invokes the dataworks_public.DsgWhiteListAddOrUpdate API synchronously
func (client *Client) DsgWhiteListAddOrUpdate(request *DsgWhiteListAddOrUpdateRequest) (response *DsgWhiteListAddOrUpdateResponse, err error) {
	response = CreateDsgWhiteListAddOrUpdateResponse()
	err = client.DoAction(request, response)
	return
}

// DsgWhiteListAddOrUpdateWithChan invokes the dataworks_public.DsgWhiteListAddOrUpdate API asynchronously
func (client *Client) DsgWhiteListAddOrUpdateWithChan(request *DsgWhiteListAddOrUpdateRequest) (<-chan *DsgWhiteListAddOrUpdateResponse, <-chan error) {
	responseChan := make(chan *DsgWhiteListAddOrUpdateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgWhiteListAddOrUpdate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgWhiteListAddOrUpdateWithCallback invokes the dataworks_public.DsgWhiteListAddOrUpdate API asynchronously
func (client *Client) DsgWhiteListAddOrUpdateWithCallback(request *DsgWhiteListAddOrUpdateRequest, callback func(response *DsgWhiteListAddOrUpdateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgWhiteListAddOrUpdateResponse
		var err error
		defer close(result)
		response, err = client.DsgWhiteListAddOrUpdate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgWhiteListAddOrUpdateRequest is the request struct for api DsgWhiteListAddOrUpdate
type DsgWhiteListAddOrUpdateRequest struct {
	*requests.RpcRequest
	WhiteLists *[]DsgWhiteListAddOrUpdateWhiteLists `position:"Query" name:"WhiteLists"  type:"Json"`
}

// DsgWhiteListAddOrUpdateWhiteLists is a repeated param struct in DsgWhiteListAddOrUpdateRequest
type DsgWhiteListAddOrUpdateWhiteLists struct {
	EndTime      string    `name:"EndTime"`
	UserGroupIds *[]string `name:"UserGroupIds" type:"Repeated"`
	Id           string    `name:"Id"`
	StartTime    string    `name:"StartTime"`
	RuleId       string    `name:"RuleId"`
}

// DsgWhiteListAddOrUpdateResponse is the response struct for api DsgWhiteListAddOrUpdate
type DsgWhiteListAddOrUpdateResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDsgWhiteListAddOrUpdateRequest creates a request to invoke DsgWhiteListAddOrUpdate API
func CreateDsgWhiteListAddOrUpdateRequest() (request *DsgWhiteListAddOrUpdateRequest) {
	request = &DsgWhiteListAddOrUpdateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgWhiteListAddOrUpdate", "", "")
	request.Method = requests.POST
	return
}

// CreateDsgWhiteListAddOrUpdateResponse creates a response to parse from DsgWhiteListAddOrUpdate response
func CreateDsgWhiteListAddOrUpdateResponse() (response *DsgWhiteListAddOrUpdateResponse) {
	response = &DsgWhiteListAddOrUpdateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
