package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExtensions invokes the dataworks_public.ListExtensions API synchronously
func (client *Client) ListExtensions(request *ListExtensionsRequest) (response *ListExtensionsResponse, err error) {
	response = CreateListExtensionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListExtensionsWithChan invokes the dataworks_public.ListExtensions API asynchronously
func (client *Client) ListExtensionsWithChan(request *ListExtensionsRequest) (<-chan *ListExtensionsResponse, <-chan error) {
	responseChan := make(chan *ListExtensionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExtensions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExtensionsWithCallback invokes the dataworks_public.ListExtensions API asynchronously
func (client *Client) ListExtensionsWithCallback(request *ListExtensionsRequest, callback func(response *ListExtensionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExtensionsResponse
		var err error
		defer close(result)
		response, err = client.ListExtensions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExtensionsRequest is the request struct for api ListExtensions
type ListExtensionsRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListExtensionsResponse is the response struct for api ListExtensions
type ListExtensionsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PagingInfo PagingInfo `json:"PagingInfo" xml:"PagingInfo"`
}

// CreateListExtensionsRequest creates a request to invoke ListExtensions API
func CreateListExtensionsRequest() (request *ListExtensionsRequest) {
	request = &ListExtensionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListExtensions", "", "")
	request.Method = requests.POST
	return
}

// CreateListExtensionsResponse creates a response to parse from ListExtensions response
func CreateListExtensionsResponse() (response *ListExtensionsResponse) {
	response = &ListExtensionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
