package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRefDISyncTasks invokes the dataworks_public.ListRefDISyncTasks API synchronously
func (client *Client) ListRefDISyncTasks(request *ListRefDISyncTasksRequest) (response *ListRefDISyncTasksResponse, err error) {
	response = CreateListRefDISyncTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListRefDISyncTasksWithChan invokes the dataworks_public.ListRefDISyncTasks API asynchronously
func (client *Client) ListRefDISyncTasksWithChan(request *ListRefDISyncTasksRequest) (<-chan *ListRefDISyncTasksResponse, <-chan error) {
	responseChan := make(chan *ListRefDISyncTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRefDISyncTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRefDISyncTasksWithCallback invokes the dataworks_public.ListRefDISyncTasks API asynchronously
func (client *Client) ListRefDISyncTasksWithCallback(request *ListRefDISyncTasksRequest, callback func(response *ListRefDISyncTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRefDISyncTasksResponse
		var err error
		defer close(result)
		response, err = client.ListRefDISyncTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRefDISyncTasksRequest is the request struct for api ListRefDISyncTasks
type ListRefDISyncTasksRequest struct {
	*requests.RpcRequest
	TaskType       string           `position:"Query" name:"TaskType"`
	DatasourceName string           `position:"Query" name:"DatasourceName"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
	RefType        string           `position:"Query" name:"RefType"`
}

// ListRefDISyncTasksResponse is the response struct for api ListRefDISyncTasks
type ListRefDISyncTasksResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListRefDISyncTasksRequest creates a request to invoke ListRefDISyncTasks API
func CreateListRefDISyncTasksRequest() (request *ListRefDISyncTasksRequest) {
	request = &ListRefDISyncTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListRefDISyncTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateListRefDISyncTasksResponse creates a response to parse from ListRefDISyncTasks response
func CreateListRefDISyncTasksResponse() (response *ListRefDISyncTasksResponse) {
	response = &ListRefDISyncTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
