package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafScenes invokes the dcdn.DescribeDcdnWafScenes API synchronously
func (client *Client) DescribeDcdnWafScenes(request *DescribeDcdnWafScenesRequest) (response *DescribeDcdnWafScenesResponse, err error) {
	response = CreateDescribeDcdnWafScenesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafScenesWithChan invokes the dcdn.DescribeDcdnWafScenes API asynchronously
func (client *Client) DescribeDcdnWafScenesWithChan(request *DescribeDcdnWafScenesRequest) (<-chan *DescribeDcdnWafScenesResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafScenesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafScenes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafScenesWithCallback invokes the dcdn.DescribeDcdnWafScenes API asynchronously
func (client *Client) DescribeDcdnWafScenesWithCallback(request *DescribeDcdnWafScenesRequest, callback func(response *DescribeDcdnWafScenesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafScenesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafScenes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafScenesRequest is the request struct for api DescribeDcdnWafScenes
type DescribeDcdnWafScenesRequest struct {
	*requests.RpcRequest
	DefenseScenes string `position:"Query" name:"DefenseScenes"`
}

// DescribeDcdnWafScenesResponse is the response struct for api DescribeDcdnWafScenes
type DescribeDcdnWafScenesResponse struct {
	*responses.BaseResponse
	RequestId     string             `json:"RequestId" xml:"RequestId"`
	DefenseScenes []DefenseSceneItem `json:"DefenseScenes" xml:"DefenseScenes"`
}

// CreateDescribeDcdnWafScenesRequest creates a request to invoke DescribeDcdnWafScenes API
func CreateDescribeDcdnWafScenesRequest() (request *DescribeDcdnWafScenesRequest) {
	request = &DescribeDcdnWafScenesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafScenes", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafScenesResponse creates a response to parse from DescribeDcdnWafScenes response
func CreateDescribeDcdnWafScenesResponse() (response *DescribeDcdnWafScenesResponse) {
	response = &DescribeDcdnWafScenesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
