package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserGroupsMapping invokes the dfs.DeleteUserGroupsMapping API synchronously
func (client *Client) DeleteUserGroupsMapping(request *DeleteUserGroupsMappingRequest) (response *DeleteUserGroupsMappingResponse, err error) {
	response = CreateDeleteUserGroupsMappingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserGroupsMappingWithChan invokes the dfs.DeleteUserGroupsMapping API asynchronously
func (client *Client) DeleteUserGroupsMappingWithChan(request *DeleteUserGroupsMappingRequest) (<-chan *DeleteUserGroupsMappingResponse, <-chan error) {
	responseChan := make(chan *DeleteUserGroupsMappingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserGroupsMapping(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserGroupsMappingWithCallback invokes the dfs.DeleteUserGroupsMapping API asynchronously
func (client *Client) DeleteUserGroupsMappingWithCallback(request *DeleteUserGroupsMappingRequest, callback func(response *DeleteUserGroupsMappingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserGroupsMappingResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserGroupsMapping(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserGroupsMappingRequest is the request struct for api DeleteUserGroupsMapping
type DeleteUserGroupsMappingRequest struct {
	*requests.RpcRequest
	GroupNames    string `position:"Query" name:"GroupNames"`
	InputRegionId string `position:"Query" name:"InputRegionId"`
	FileSystemId  string `position:"Query" name:"FileSystemId"`
	UserName      string `position:"Query" name:"UserName"`
}

// DeleteUserGroupsMappingResponse is the response struct for api DeleteUserGroupsMapping
type DeleteUserGroupsMappingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUserGroupsMappingRequest creates a request to invoke DeleteUserGroupsMapping API
func CreateDeleteUserGroupsMappingRequest() (request *DeleteUserGroupsMappingRequest) {
	request = &DeleteUserGroupsMappingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "DeleteUserGroupsMapping", "alidfs", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDeleteUserGroupsMappingResponse creates a response to parse from DeleteUserGroupsMapping response
func CreateDeleteUserGroupsMappingResponse() (response *DeleteUserGroupsMappingResponse) {
	response = &DeleteUserGroupsMappingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
